import os
from distutils.core import setup
from distutils.sysconfig import get_config_vars

exec_prefix, libdir = get_config_vars('exec_prefix', 'LIBDIR')
if libdir.startswith(exec_prefix + '/'):
    libdir = libdir[len(exec_prefix)+1:]

plugindir = os.path.join(libdir, 'nagios/plugins')

fd = open('VERSION','rw')
version = fd.read().strip()
fd.close()

setup(
    name = 'nordugrid-arc-nagios-plugins',
    version = version,
    description = 'Nagios Probes for Arc CEs',
    url = 'http://www.nordugrid.org/',
    author = 'Petter Urkedal',
    author_email = 'urkedal@nbi.dk',

    requires = ['arc', 'argparse', 'ldap', 'ply'],
    packages = ['arcnagios', 'arcnagios.plugins', 'arcnagios.jobplugins'],
    data_files = [
	(plugindir, [
	    'plugins/check_arcce_clean',
	    'plugins/check_arcce_monitor',
	    'plugins/check_arcce_submit',
	    'plugins/check_aris',
	    'plugins/check_egiis',
	    'plugins/check_arcglue2',
	    'plugins/check_arcinfosys',
	    'plugins/check_archostcert',
	    'plugins/check_arcservice',
	    'plugins/check_gridstorage',
	]),
	('/etc/arc/nagios', ['config/20-dist.ini']),
	('/etc/arc/nagios/20-dist.d', ['config/20-dist.d/default.jsdl']),
	('/etc/arc/nagios', ['config/60-egi.ini']),
	('/etc/arc/nagios/60-egi.d', ['config/60-egi.d/arcce_igtf.py']),
    ],
)
