/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanTypeConverter
implements TypeConverter<Boolean> {
    private static final Collection<String> truths = new HashSet<String>();

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public Boolean convert(String input, Class<? extends Boolean> targetType, Collection<ValidationError> errors) {
        boolean retval = false;
        for (String truth : truths) {
            retval = retval || truth.equalsIgnoreCase(input);
        }
        if (!retval) {
            try {
                long number = Long.parseLong(input);
                retval = number > 0L;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return retval;
    }

    static {
        truths.add("true");
        truths.add("t");
        truths.add("yes");
        truths.add("y");
        truths.add("on");
    }
}

