/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.plus.AbstractService;
import org.mortbay.jndi.Util;

public class MailService
extends AbstractService
implements Map {
    static Log log = LogFactory.getLog(MailService.class);
    public static final String DEFAULT_MAIL_JNDI = "mail/Session";
    protected Properties _sessionProperties;
    protected String _user;
    protected String _password;
    protected ObjectFactory _objectFactory;

    public MailService() {
        this.setJNDI(DEFAULT_MAIL_JNDI);
        this._sessionProperties = new Properties();
    }

    public void setUser(String user) {
        this._user = user;
        this._sessionProperties.put("User", user);
    }

    public String getUser() {
        return this._user;
    }

    public void setPassword(String pwd) {
        this._password = pwd;
        this._sessionProperties.put("Password", pwd);
    }

    protected String getPassword() {
        return this._password;
    }

    public void clear() {
        this._sessionProperties.clear();
    }

    public int size() {
        return this._sessionProperties.size();
    }

    public boolean isEmpty() {
        return this._sessionProperties.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this._sessionProperties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._sessionProperties.containsValue(value);
    }

    public Object get(Object key) {
        return this._sessionProperties.get(key);
    }

    public Object put(Object key, Object value) {
        return this._sessionProperties.put(key, value);
    }

    public Object remove(Object key) {
        return this._sessionProperties.remove(key);
    }

    public void putAll(Map t) {
        this._sessionProperties.putAll((Map<?, ?>)t);
    }

    public Set keySet() {
        return this._sessionProperties.keySet();
    }

    public Collection values() {
        return this._sessionProperties.values();
    }

    public Set entrySet() {
        return this._sessionProperties.entrySet();
    }

    public boolean equals(Object o) {
        return this._sessionProperties.equals(o);
    }

    public int hashCode() {
        return this._sessionProperties.hashCode();
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            MailAuthenticator authenticator = new MailAuthenticator(this.getUser(), this.getPassword());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mail authenticator: user=" + this.getUser()));
            }
            Session session = Session.getInstance((Properties)this._sessionProperties, (Authenticator)authenticator);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created Session=" + session + " with ClassLoader=" + session.getClass().getClassLoader()));
            }
            StringRefAddr refAddr = new StringRefAddr("xx", this.getJNDI());
            SessionObjectFactory.addSession(session, refAddr);
            Reference reference = new Reference(session.getClass().getName(), refAddr, SessionObjectFactory.class.getName(), null);
            InitialContext initialCtx = new InitialContext();
            Util.bind(initialCtx, this.getJNDI(), reference);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bound reference to " + this.getJNDI()));
            }
            Object o = initialCtx.lookup(this.getJNDI());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looked up Session=" + o + " from classloader=" + o.getClass().getClassLoader()));
            }
            super.start();
            log.info((Object)"Mail Service started");
        } else {
            log.warn((Object)"MailService is already started");
        }
    }

    public void stop() throws InterruptedException {
        super.stop();
    }

    public static class SessionObjectFactory
    implements ObjectFactory {
        protected static HashMap _sessionMap = new HashMap();

        public static void addSession(Session session, StringRefAddr ref) {
            _sessionMap.put(ref, session);
        }

        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            Reference ref;
            if (log.isDebugEnabled()) {
                log.debug((Object)"ObjectFactory getObjectInstance() called");
            }
            if (obj instanceof Reference && (ref = (Reference)obj).getClassName().equals(Session.class.getName())) {
                Object inst = _sessionMap.get(ref.get("xx"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Returning object: " + inst + " for reference: " + ref.get("xx")));
                }
                return inst;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returning null");
            }
            return null;
        }
    }

    public class MailAuthenticator
    extends Authenticator {
        PasswordAuthentication _passwordAuthentication;

        public MailAuthenticator(String user, String password) {
            this._passwordAuthentication = new PasswordAuthentication(user, password);
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this._passwordAuthentication;
        }
    }
}

