// generated by ../../../../tools/tube_transfer.py
// tube: 12AU7
// plate current function: pentode
// mu: 21.5
// kx: 1.3
// kg1: 1180
// kg2: 0
// kp: 84
// kvb: 300
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_12AU7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	127.20225505231797,127.14473552149342,127.08720854506194,127.02967413493148,126.97213230303844,
	126.9145830613479,126.85702642185377,126.79946239657872,126.74189099757443,126.68431223692141,
	126.62672612672945,126.5691326791373,126.51153190631307,126.45392382045407,126.39630843378711,
	126.33868575856843,126.28105580708377,126.22341859164862,126.16577412460806,126.10812241833699,
	126.05046348524021,125.99279733775248,125.93512398833862,125.87744344949348,125.81975573374221,
	125.76206085364018,125.70435882177311,125.64664965075724,125.58893335323926,125.53120994189645,
	125.47347942943694,125.41574182859945,125.3579971521536,125.3002454129001,125.24248662367047,
	125.18472079732743,125.12694794676494,125.06916808490813,125.01138122471356,124.95358737916925,
	124.89578656129464,124.8379787841409,124.78016406079081,124.72234240435893,124.66451382799175,
	124.60667834486762,124.54883596819697,124.49098671122235,124.4331305872185,124.3752676094924,
	124.31739779138348,124.25952114626364,124.20163768753719,124.14374742864119,124.08585038304538,
	124.02794656425232,123.97003598579738,123.91211866124901,123.85419460420866,123.79626382831088,
	123.73832634722359,123.68038217464789,123.62243132431837,123.56447381000307,123.50650964550366,
	123.44853884465545,123.39056142132748,123.3325773894227,123.27458676287787,123.21658955566399,
	123.15858578178594,123.1005754552829,123.04255859022837,122.98453520073016,122.92650530093056,
	122.86846890500641,122.81042602716924,122.75237668166523,122.69432088277543,122.63625864481578,
	122.57818998213726,122.52011490912588,122.46203344020286,122.40394558982466,122.34585137248315,
	122.28775080270563,122.2296438950549,122.17153066412942,122.11341112456337,122.05528529102672,
	121.99715317822542,121.93901480090129,121.88087017383232,121.82271931183267,121.76456222975271,
	121.70639894247923,121.64822946493544,121.59005381208111,121.53187199891264,121.47368404046311,
	121.41548995180244,121.35728974803759,121.29908344431226,121.24087105580749,121.1826525977414,
	121.12442808536935,121.0661975339842,121.00796095891613,120.949718375533,120.89146979924024,
	120.8332152454811,120.7749547297366,120.71668826752573,120.65841587440549,120.60013756597105,
	120.54185335785576,120.48356326573122,120.42526730530751,120.36696549233325,120.3086578425955,
	120.25034437192016,120.19202509617182,120.133700031254,120.07536919310915,120.01703259771884,
	119.9586902611037,119.90034219932373,119.84198842847823,119.78362896470594,119.72526382418513,
	119.66689302313377,119.60851657780952,119.55013450450987,119.49174681957228,119.43335353937414,
	119.37495468033303,119.31655025890679,119.25814029159339,119.19972479493147,119.14130378549991,
	119.08287727991839,119.02444529484723,118.96600784698745,118.9075649530811,118.84911662991111,
	118.79066289430159,118.73220376311774,118.67373925326616,118.61526938169466,118.5567941653927,
	118.49831362139119,118.43982776676279,118.38133661862186,118.32284019412465,118.26433851046943,
	118.20583158489643,118.14731943468816,118.08880207716929,118.03027952970689,117.97175180971047,
	117.91321893463211,117.85468092196655,117.79613778925122,117.73758955406655,117.67903623403568,
	117.62047784682504,117.56191441014406,117.50334594174547,117.44477245942528,117.38619398102307,
	117.32761052442181,117.26902210754824,117.2104287483728,117.15183046490972,117.09322727521722,
	117.03461919739759,116.97600624959719,116.91738845000665,116.85876581686095,116.80013836843948,
	116.74150612306622,116.68286909910971,116.6242273149833,116.56558078914517,116.50692954009838,
	116.44827358639114,116.38961294661662,116.33094763941341,116.27227768346539,116.21360309750177,
	116.15492390029748,116.09624011067294,116.03755174749435,115.97885882967381,115.92016137616933,
	115.8614594059849,115.80275293817071,115.74404199182324,115.68532658608524,115.6266067401459,
	115.56788247324101,115.50915380465295,115.4504207537109,115.39168333979087,115.33294158231577,
	115.27419550075567,115.21544511462764,115.15669044349616,115.09793150697296,115.03916832471721,
	114.98040091643574,114.9216293018829,114.86285350086092,114.80407353321979,114.74528941885752,
	114.68650117772017,114.62770882980192,114.56891239514525,114.51011189384103,114.45130734602849,
	114.39249877189549,114.33368619167862,114.27486962566313,114.21604909418316,114.15722461762186,
	114.09839621641144,114.03956391103324,113.9807277220179,113.92188766994543,113.8630437754453,
	113.8041960591966,113.74534454192803,113.68648924441811,113.62763018749523,113.56876739203771,
	113.50990087897407,113.45103066928282,113.39215678399295,113.3332792441837,113.27439807098482,
	113.21551328557668,113.15662490919027,113.09773296310746,113.03883746866087,112.97993844723422,
	112.92103592026226,112.86212990923093,112.80322043567746,112.74430752119046,112.68539118741008,
	112.62647145602797,112.56754834878747,112.5086218874838,112.44969209396399,112.39075899012704,
	112.3318225979241,112.27288293935852,112.21394003648581,112.15499391141398,112.09604458630348,
	112.03709208336738,111.97813642487141,111.91917763313403,111.86021573052669,111.80125073947374,
	111.74228268245267,111.68331158199405,111.62433746068186,111.56536034115335,111.5063802460993,
	111.44739719826404,111.38841122044562,111.32942233549578,111.27043056632021,111.21143593587853,
	111.15243846718441,111.0934381833057,111.03443510736456,110.97542926253739,110.91642067205518,
	110.8574093592034,110.79839534732217,110.73937865980639,110.6803593201058,110.62133735172506,
	110.56231277822387,110.5032856232171,110.44425591037482,110.38522366342248,110.32618890614084,
	110.26715166236632,110.20811195599087,110.14906981096219,110.09002525128378,110.030978301015,
	109.97192898427127,109.91287732522412,109.85382334810119,109.79476707718645,109.73570853682023,
	109.6766477513994,109.6175847453773,109.55851954326398,109.49945216962624,109.44038264908771,
	109.38131100632901,109.32223726608778,109.26316145315874,109.20408359239387,109.14500370870242,
	109.08592182705114,109.0268379724642,108.96775217002336,108.90866444486811,108.84957482219569,
	108.79048332726116,108.73138998537763,108.67229482191614,108.61319786230598,108.5540991320346,
	108.4949986566478,108.43589646174973,108.37679257300313,108.31768701612924,108.25857981690805,
	108.19947100117825,108.14036059483745,108.0812486238421,108.02213511420779,107.96302009200915,
	107.90390358338009,107.84478561451371,107.7856662116626,107.72654540113876,107.66742320931374,
	107.60829966261873,107.54917478754462,107.49004861064222,107.4309211585221,107.3717924578549,
	107.31266253537125,107.253531417862,107.19439913217825,107.1352657052313,107.07613116399297,
	107.01699553549548,106.95785884683173,106.8987211251551,106.83958239767988,106.78044269168103,
	106.7213020344945,106.66216045351716,106.60301797620693,106.54387463008293,106.48473044272544,
	106.42558544177602,106.36643965493768,106.30729310997482,106.24814583471338,106.18899785704096,
	106.12984920490676,106.07069990632183,106.01154998935901,105.95239948215308,105.89324841290079,
	105.83409680986104,105.77494470135476,105.71579211576517,105.6566390815378,105.5974856271805,
	105.5383317812636,105.47917757241993,105.4200230293449,105.36086818079661,105.30171305559591,
	105.24255768262638,105.18340209083456,105.12424630922985,105.06509036688476,105.00593429293481,
	104.94677811657873,104.88762186707847,104.82846557375922,104.76930926600959,104.71015297328162,
	104.65099672509079,104.59184055101619,104.53268448070052,104.4735285438502,104.41437277023533,
	104.35521718968994,104.2960618321119,104.23690672746302,104.17775190576907,104.11859739712001,
	104.05944323166989,104.00028943963692,103.94113605130357,103.8819830970167,103.82283060718751,
	103.76367861229161,103.70452714286915,103.6453762295248,103.58622590292784,103.52707619381228,
	103.4679271329768,103.40877875128484,103.34963107966475,103.29048414910972,103.23133799067787,
	103.1721926354924,103.11304811474146,103.05390445967836,102.99476170162154,102.9356198719547,
	102.87647900212671,102.81733912365183,102.75820026810965,102.69906246714513,102.63992575246868,
	102.58079015585626,102.5216557091494,102.4625224442551,102.40339039314608,102.34425958786076,
	102.28513006050325,102.22600184324344,102.16687496831702,102.10774946802555,102.04862537473646,
	101.98950272088317,101.930381538965,101.87126186154737,101.8121437212617,101.7530271508055,
	101.69391218294243,101.63479885050229,101.57568718638113,101.5165772235412,101.45746899501103,
	101.39836253388543,101.33925787332561,101.28015504655907,101.22105408687979,101.1619550276481,
	101.10285790229089,101.04376274430147,100.98466958723967,100.9255784647319,100.86648941047113,
	100.80740245821696,100.74831764179552,100.68923499509974,100.6301545520891,100.57107634678984,
	100.5120004132949,100.45292678576399,100.39385549842353,100.3347865855668,100.27572008155379,
	100.21665602081139,100.15759443783327,100.09853536718005,100.03947884347907,99.98042490142471,
	99.92137357577815,99.86232490136757,99.80327891308798,99.7442356459014,99.68519513483677,
	99.62615741499008,99.56712252152408,99.50809048966876,99.44906135472093,99.39003515204443,
	99.33101191707011,99.27199168529586,99.21297449228656,99.15396037367408,99.09494936515733,
	99.03594150250224,98.97693682154178,98.91793535817594,98.85893714837168,98.79994222816305,
	98.74095063365108,98.68196240100384,98.62297756645641,98.56399616631089,98.50501823693634,
	98.44604381476884,98.38707293631151,98.32810563813439,98.2691419568745,98.21018192923589,
	98.15122559198949,98.09227298197322,98.03332413609192,97.97437909131736,97.91543788468819,
	97.85650055331001,97.79756713435523,97.73863766506318,97.67971218274005,97.62079072475875,
	97.56187332855916,97.50296003164785,97.44405087159818,97.3851458860503,97.32624511271106,
	97.26734858935404,97.20845635381954,97.1495684440145,97.09068489791248,97.0318057535537,
	96.97293104904499,96.91406082255969,96.8551951123378,96.7963339566857,96.73747739397636,
	96.67862546264921,96.61977820121011,96.5609356482313,96.50209784235145,96.44326482227554,
	96.38443662677489,96.32561329468713,96.26679486491615,96.20798137643206,96.14917286827115,
	96.09036937953596,96.03157094939506,95.9727776170832,95.91398942190119,95.8552064032159,
	95.79642860046016,95.73765605313282,95.67888880079869,95.62012688308843,95.56137033969867,
	95.5026192103918,95.44387353499609,95.38513335340559,95.32639870558013,95.26766963154517,
	95.20894617139199,95.15022836527746,95.09151625342403,95.03280987611991,94.97410927371875,
	94.91541448663988,94.856725555368,94.79804252045344,94.73936542251192,94.6806943022247,
	94.62202920033832,94.5633701576649,94.50471721508187,94.446070413532,94.38742979402345,
	94.32879539762966,94.27016726548953,94.21154543880714,94.15292995885196,94.09432086695864,
	94.03571820452724,93.97712201302309,93.91853233397677,93.85994920898419,93.80137267970653,
	93.74280278787032,93.68423957526733,93.62568308375478,93.56713335525517,93.50859043175639,
	93.45005435531176,93.39152516804008,93.33300291212548,93.2744876298178,93.2159793634323,
	93.15747815534992,93.09898404801723,93.04049708394656,92.9820173057161,92.9235447559698,
	92.86507947741762,92.80662151283558,92.74817090506589,92.68972769701685,92.6312919316633,
	92.57286365204641,92.51444290127402,92.45602972252073,92.397624159028,92.33922625410428,
	92.28083605112532,92.22245359353418,92.16407892484159,92.10571208862595,92.04735312853373,
	91.98900208827958,91.93065901164663,91.87232394248667,91.81399692472056,91.7556780023383,
	91.69736721939958,91.63906462003386,91.5807702484409,91.52248414889094,91.46420636572525,
	91.40593694335628,91.3476759262684,91.289423359018,91.23117928623417,91.17294375261905,
	91.11471680294841,91.05649848207213,90.99828883491482,90.9400879064763,90.88189574183222,
	90.82371238613487,90.76553788461361,90.70737228257568,90.64921562540701,90.59106795857285,
	90.53292932761865,90.4747997781709,90.41667935593803,90.35856810671132,90.30046607636577,
	90.24237331086125,90.1842898562436,90.12621575864549,90.06815106428779,90.0100958194807,
	89.95205007062506,89.89401386421359,89.83598724683233,89.777970265162,89.7199629659796,
	89.6619653961599,89.6039776026771,89.54599963260654,89.48803153312646,89.43007335151987,
	89.37212513517647,89.31418693159475,89.2562587883839,89.19834075326625,89.14043287407937,
	89.08253519877856,89.02464777543932,88.96677065225985,88.90890387756394,88.85104749980366,
	88.7932015675622,88.73536612955722,88.67754123464366,88.61972693181742,88.56192327021861,
	88.50413029913511,88.44634806800656,88.38857662642795,88.33081602415395,88.27306631110298,
	88.21532753736179,88.15759975318979,88.09988300902408,88.04217735548433,87.9844828433779,
	87.92679952370534,87.8691274476659,87.81146666666346,87.75381723231254,87.69617919644469,
	87.63855261111492,87.58093752860877,87.52333400144924,87.4657420824044,87.40816182449483,
	87.35059328100192,87.29303650547601,87.23549155174524,87.17795847392448,87.12043732642472,
	87.06292816396287,87.00543104157197,86.94794601461166,86.89047313877931,86.83301247012129,
	86.77556406504502,86.7181279803312,86.66070427314679,86.60329300105829,86.54589422204572,
	86.488507994517,86.431134377323,86.37377342977324,86.31642521165209,86.25908978323564,
	86.20176720530924,86.14445753918586,86.08716084672506,86.02987719035256,85.97260663308097,
	85.91534923853095,85.85810507095346,85.80087419525276,85.7436566770104,85.68645258251003,
	85.62926197876331,85.57208493353683,85.51492151537995,85.457771793654,85.40063583856221,
	85.34351372118134,85.28640551349409,85.22931128842303,85.17223111986576,85.11516508273151,
	85.05811325297908,85.00107570765641,84.94405252494154,84.88704378418511,84.83004956595492,
	84.77306995208167,84.71610502570684,84.65915487133243,84.60221957487234,84.54529922370615,
	84.4883939067346,84.43150371443755,84.37462873893396,84.31776907404424,84.26092481535505,
	84.20409606028663,84.14728290816262,84.0904854602826,84.03370381999754,83.97693809278803,
	83.92018838634553,83.86345481065676,83.80673747809128,83.75003650349255,83.6933520042723,
	83.63668410050866,83.58003291504787,83.52339857361007,83.46678120489885,83.41018094071525,
	83.35359791607587,83.29703226933556,83.24048414231464,83.1839536804311,83.12744103283762,
	83.07094635256387,83.01446979666392,82.9580115263696,82.90157170724912,82.84515050937199,
	82.7887481074798,82.73236468116359,82.67600041504764,82.61965549898008,82.56333012823065,
	82.50702450369558,82.45073883211008,82.3944733262687,82.33822820525343,82.28200369467058,
	82.2258000268958,82.16961744132816,82.11345618465354,82.05731651111711,82.00119868280598,
	81.9451029699415,81.88902965118244,81.83297901393833,81.77695135469428,81.72094697934699,
	81.6649662035524,81.60900935308564,81.55307676421312,81.4971687840776,81.44128577109629,
	81.38542809537255,81.32959613912126,81.27379029710873,81.2180109771071,81.16225860036297,
	81.10653360208329,81.05083643193491,80.99516755456158,80.93952745011663,80.88391661481313,
	80.82833556149083,80.77278482020074,80.71726493880769,80.66177648361098,80.60632003998379,
	80.55089621303108,80.49550562826693,80.44014893231105,80.38482679360514,80.32953990314877,
	80.27428897525559,80.21907474832955,80.16389798566132,80.10875947624545,80.05366003561738,
	79.99860050671127,79.94358176073793,79.88860469808289,79.83367024922468,79.77877937567239,
	79.72393307092305,79.66913236143769,79.61437830763585,79.55967200490805,79.50501458464531,
	79.45040721528484,79.39585110337141,79.3413474946328,79.28689767506836,79.23250297204956,
	79.17816475543077,79.12388443866851,79.06966347994808,79.01550338331447,78.9614056998065,
	78.90737202859104,78.8534040180952,78.79950336713344,78.74567182602685,78.6919111977112,
	78.63822333883039,78.58461016081162,78.53107363091831,78.47761577327664,78.42423866987116,
	78.37094446150489,78.31773534871884,78.26461359266591,78.21158151593337,78.1586415033085,
	78.10579600248126,78.05304752467768,78.00039864521779,77.9478520039909,77.89541030584203,
	77.84307632086167,77.7908528845722,77.73874289800338,77.68674932764937,77.6348752052997,
	77.58312362773688,77.5314977562925,77.48000081625482,77.42863609612002,77.37740694667983,
	77.3263167799386,77.27536906785258,77.22456734088537,77.17391518637275,77.1234162466917,
	77.07307421722824,77.02289284413938,76.97287592190541,76.92302729066948,76.87335083336174,
	76.82385047260698,76.77453016741511,76.72539390965501,76.67644572031347,76.62768964554195,
	76.5791297524952,76.530770124967,76.48261485882966,76.43466805728504,76.38693382593625,
	76.33941626769115,76.29211947750856,76.24504753700151,76.19820450891153,76.15159443146952,
	76.10522131266104,76.0590891244133,76.01320179672355,75.9675632117487,75.92217719787726,
	75.8770475238052,75.83217789263782,75.7875719360405,75.7432332084608,75.69916518144547,
	75.65537123807451,75.611854667536,75.56861865986264,75.52566630085312,75.483000567198,
	75.44062432183094,75.39854030952385,75.35675115274378,75.31525934778784,75.27406726121124,
	75.2331771265614,75.19259104143002,75.15231096483288,75.11233871492519,75.07267596705888,
	75.033324252186,74.99428495561034,74.95555931608814,74.9171484252762,74.87905322752414,
	74.84127452000614,74.8038129531852,74.76666903160202,74.72984311497851,74.69333541962513,
	74.65714602013966,74.62127485138417,74.58572171072517,74.55048626052283,74.51556803085231,
	74.48096642244104,74.44668070980528,74.41271004456831,74.37905345894303,74.3457098693614,
	74.31267808023368,74.27995678781953,74.24754458419484,74.215439961297,74.18364131503309,
	74.15214694943495,74.12095508084624,74.09006384212735,74.05947128686427,74.02917539356845,
	73.99917406985584,73.96946515659332,73.94004643200218,73.91091561570902,73.88207037273462,
	73.85350831741333,73.82522701723492,73.79722399660281,73.76949674050263,73.74204269807595,
	73.71485928609498,73.68794389233432,73.66129387883673,73.63490658507065,73.60877933097706,
	73.58290941990496,73.55729414143403,73.53193077408449,73.5068165879139,73.48194884700172,
	73.45732481182169,73.43294174150415,73.40879689598881,73.38488753807032,73.36121093533794,
	73.33776436201221,73.31454510068001,73.29155044393134,73.26877769589979,73.24622417370968,
	73.22388720883274,73.20176414835674,73.1798523561697,73.15814921406181,73.1366521227488,
	73.11535850281906,73.094265795608,73.07337146400225,73.05267299317669,73.03216789126743,
	73.01185368998331,72.99172794515871,72.97178823725069,72.95203217178283,72.93245737973847,
	72.91306151790609,72.89384226917898,72.8747973428118,72.85592447463644,72.83722142723896,
	72.81868599010065,72.80031597970422,72.78210923960812,72.76406364049016,72.74617708016294,
	72.72844748356228,72.71087280271091,72.69345101665851,72.67618013140022,72.65905817977463,
	72.64208322134307,72.62525334225126,72.60856665507468,72.59202129864926,72.57561543788783,
	72.55934726358412,72.54321499220127,72.52721686566939,72.5113511511326,72.4956161407295,
	72.4800101513437,72.46453152435198,72.44917862536582,72.43394984396724,72.4188435934398,
	72.40385831049498,72.38899245499493,72.37424450967188,72.35961297984493,72.34509639313436,
	72.33069329917454,72.31640226932524,72.30222189638198,72.28815079428597,72.27418759783379,
	72.260330962387,72.2465795635824,72.23293209704286,72.21938727808903,72.2059438414524,
	72.19260054098962,72.17935614939849,72.16620945793576,72.1531592761369,72.14020443153798,
	72.12734376939981,72.11457615243455,72.10190046053478,72.08931559050524,72.0768204557973,
	72.06441398624617,72.05209512781116,72.03986284231875,72.02771610720872,72.01565391528345,
	72.0036752744602,71.99177920752669,71.97996475189966,71.9682309593869,71.95657689595232,
	71.9450016414844,71.93350428956778,71.92208394725822,71.91073973486081,71.89947078571129,
	71.88827624596097,71.8771552743645,71.86610704207116,71.85513073241937,71.84422554073407,
	71.83339067412784,71.82262535130461,71.811928802367,71.80130026862643,71.79073900241646,
	71.7802442669092,71.7698153359347,71.75945149380338,71.74915203513135,71.73891626466875,
	71.72874349713092,71.71863305703248,71.70858427852421,71.69859650523266,71.68866909010268,
	71.67880139524242,71.66899279177132,71.6592426596703,71.64955038763513,71.63991537293178,
	71.63033702125477,71.62081474658761,71.61134797106602,71.60193612484339,71.59257864595855,
	71.5832749802062,71.57402458100911,71.5648269092931,71.55568143336396,71.5465876287866,
	71.53754497826637,71.52855297153253,71.51961110522372,71.51071888277558,71.50187581431024,
	71.49308141652784,71.48433521260017,71.47563673206578,71.46698551072751,71.45838109055134,
	71.44982301956314,71.44131085176897,71.43284414703216,71.42442247099812,71.41604539499744,
	71.40771249595527,71.3994233563023,71.39117756388748,71.38297471189223,71.37481439874617,
	71.36669622804423,71.35861980846562,71.3505847536937,71.34259068233776,71.3346372178559,
	71.32672398847937,71.31885062713833,71.31101677138871,71.3032220633406,71.29546614958782,
	71.28774868113862,71.28006931334778,71.27242770584989,71.26482352249353,71.2572564312771,
	71.24972610428527,71.24223221762692,71.2347744513739,71.2273524895011,71.21996601982737,
	71.21261473395752,71.20529832722544,71.1980164986381,71.19076895082048,71.18355538996161,
	71.17637552576139,71.1692290713784,71.16211574337869,71.15503526168521,71.1479873495284,
	71.14097173339744,71.13398814299234,71.12703631117698,71.12011597393281,71.11322687031344,
	71.10636874239992,71.09954133525683,71.09274439688907,71.08597767819951,71.07924093294714,
	71.07253391770614,71.06585639182548,71.05920811738923,71.0525888591777,71.04599838462894,
	71.03943646380115,71.03290286933552,71.02639737641985,71.01991976275262,71.01346980850779,
	71.00704729630007,71.00065201115088,70.99428374045472,70.98794227394626,70.98162740366786,
	70.97533892393758,70.9690766313179,70.96284032458476,70.95662980469714,70.95044487476727,
	70.9442853400311,70.93815100781944,70.93204168752955,70.92595719059695,70.91989733046802,
	70.9138619225728,70.90785078429842,70.90186373496262,70.89590059578812,70.88996118987713,
	70.88404534218621,70.87815287950183,70.87228363041595,70.86643742530224,70.8606140962927,
	70.85481347725424,70.84903540376627,70.84327971309803,70.83754624418671,70.83183483761566,
	70.82614533559303,70.82047758193072,70.81483142202369,70.80920670282951,70.80360327284835,
	70.7980209821031,70.79245968212007,70.78691922590956,70.78139946794717,70.77590026415517,
	70.77042147188416,70.764962949895,70.75952455834108,70.75410615875083,70.74870761401046,
	70.743328788347,70.73796954731158,70.73262975776295,70.72730928785124,70.72200800700195,
	70.71672578590032,70.71146249647566,70.70621801188615,70.70099220650377,70.69578495589944,
	70.69059613682843,70.68542562721588,70.68027330614271,70.67513905382687,70.67002275162871,
	70.664924282008,70.65984352853062,70.65478037585018,70.64973470969515,70.64470641685584,
	70.63969538517189,70.63470150351979,70.62972466180062,70.62476475092788,70.61982166281558,
	70.61489529036662,70.60998552746092,70.60509226894429,70.60021541061688,70.5953548492223,
	70.59051048243651,70.5856822088571,70.5808699279926,70.57607354025198,70.57129294693432,
	70.56652805021858,70.56177875315349,70.55704495964767,70.55232657445983,70.54762350318907,
	70.54293565226538,70.53826292894026,70.5336052412774,70.52896249814353,70.5243346091995,
	70.51972148489129,70.51512303644124,70.51053917583943,70.50596981583509,70.50141486992824,
	70.49687425236134,70.49234787811105,70.4878356628802,70.48333752308979,70.47885337587105,
	70.47438313905785,70.4699267311787,70.46548407144958,70.46105507976611,70.45663967669643,
	70.45223778347379,70.44784932198945,70.44347421478555,70.4391123850481,70.43476375660015,
	70.43042825389487,70.42610580200896,70.42179632663589,70.41749975407943,70.41321601124713,
	70.408945025644,70.40468672536613,70.40044103909455,70.39620789608897,70.39198722618188,
	70.38777895977243,70.38358302782059,70.37939936184125,70.37522789389854,70.37106855660006,
	70.36692128309137,70.3627860070503,70.35866266268157,70.35455118471138,70.35045150838202,
	70.34636356944662,70.34228730416399,70.33822264929333,70.33416954208933,70.33012792029702,
	70.3260977221469,70.32207888634991,70.31807135209284,70.31407505903324,70.31008994729495,
	70.30611595746333,70.30215303058067,70.29820110814164,70.29426013208882,70.29033004480827,
	70.28641078912503,70.28250230829896,70.27860454602035,70.2747174464057,70.2708409539936,
	70.26697501374048,70.26311957101669,70.25927457160233,70.2554399616834,70.2516156878477,
	70.24780169708104,70.24399793676348,70.24020435466528,70.23642089894344,70.2326475181378,
	70.22888416116739,70.2251307773269,70.221387316283,70.21765372807089,70.21392996309066,
	70.21021597210401,70.20651170623074,70.20281711694527,70.19913215607357,70.19545677578955,
	70.19179092861202,70.18813456740135,70.18448764535634,70.18085011601102,70.17722193323151,
	70.17360305121308,70.1699934244769,70.16639300786723,70.16280175654825,70.15921962600127,
	70.15564657202172,70.15208255071221,70.14852751849658,70.14498143209092,70.14144424851885,
	70.13791592510401,70.13439641946745,70.13088568952479,70.12738369348376,70.12389038984135,
	70.12040573738136,70.11692969517179,70.11346222256219,70.11000327918138,70.10655282493467,
	70.10311082000156,70.09967722483334,70.09625200015054,70.09283510694063,70.08942650645565,
	70.08602616020993,70.08263402997765,70.07925007779066,70.07587426593618,70.07250655695461,
	70.06914691363727,70.0657952990242,70.06245167640208,70.05911600930197,70.05578826149733,
	70.05246839700179,70.04915638006713,70.04585217518128,70.04255574706625,70.03926706067605,
	70.03598608119482,70.03271277403478,70.02944710483438,70.0261890394562,70.02293854398522,
	70.0196955847269,70.01646012820518,70.01323214116084,70.0100115905495,70.00679844353989,
	70.00359266751204,70.00039423005553,69.9972030989677,69.99401924225198,69.99084262811604,
	69.98767322497025,69.9845110014259,69.98135592629355,69.97820796858139,69.97506709749359,
	69.97193328242875,69.96880649297819,69.96568669892443,69.96257387023968,69.95946797708413,
	69.9563689898046,69.9532768789329,69.95019161518432,69.9471131694562,69.94404151282646,
	69.94097661655204,69.93791845206756,69.93486699098385,69.93182220508653,69.9287840663346,
	69.92575254685903,69.92272761896143,69.9197092551127,69.9166974279516,69.91369211028346,
	69.91069327507888,69.90770089547242,69.90471494476118,69.90173539640371,69.8987622240186,
	69.89579540138328,69.89283490243274,69.88988070125828,69.88693277210037,69.88399108937256,
	69.88105562762041,69.87812636154848,69.87520326601167,69.87228631601405,69.8693754867077,
	69.86647075339152,69.86357209151019,69.86067947665292,69.8577928845525,69.85491229108403,
	69.85203767226396,69.84916900424892,69.84630626333474,69.84344942595528,69.84059846868148,
	69.83775336822022,69.8349141014134,69.83208064523683,69.82925297679925,69.82643107334133,
	69.82361491223467,69.82080447098082,69.81799972721033,69.81520065868168,69.81240724328049,
	69.80961945901838,69.80683728403223,69.80406069658308,69.80128967505529,69.79852419795372,
	69.79576424391193,69.79300979167418,69.79026082010984,69.78751730825694,69.7847792350695,
	69.78204657992136,69.77931932210112,69.77659744106029,69.7738809163701,69.77116972771174,
	69.76846385488021,69.76576327778255,69.76306797643709,69.76037793097251,69.75769312162717,
	69.75501352874824,69.7523391327909,69.74966991431766,69.74700585399752,69.74434693260521,
	69.74169313102043,69.73904443022714,69.73640081131276,69.73376225546745,69.73112874398345,
	69.7285002582542,69.72587677977381,69.7232582901362,69.72064477103447,69.71803620426016,
	69.71543257170258,69.71283385534818,69.71024003727968,69.70765109967566,69.70506702480967,
	69.70248779504963,69.69991339285725,69.69734380078732,69.69477900148698,69.69221897769525,
	69.68966371224968,69.68711318805772,69.68456738813599,69.68202629558436,69.67948989359135,
	69.67695816543358,69.67443109447505,69.67190866416668,69.66939085804562,69.66687765973465,
	69.66436905294171,69.66186502145922,69.6593655491635,69.65687062001426,69.65438021805402,
	69.6518943274075,69.64941293228115,69.6469360169625,69.6444635658197,69.64199556330094,
	69.63953199393391,69.63707284232528,69.63461809316016,69.63216773120155,69.62972174128993,
	69.62728010834259,69.62484281735325,69.62240985339147,69.61998120160217,69.61755684720512,
	69.61513677549455,69.61272097183848,69.61030942167837,69.60790211052851,69.60549902397581,
	69.6031001476789,69.6007054673681,69.59831496884465,69.59592863798032,69.59354646071708,
	69.59116842306645,69.58879451110917,69.58642471099472,69.58405900894088,69.58169739123328,
	69.57933984422496,69.57698635433592,69.57463690805275,69.57229149192813,69.56995009258047,
	69.56761269669342,69.56527929101546,69.5629498623596,69.56062439760282,69.55830288368574,
	69.55598530761219,69.55367165644883,69.55136191732475,69.54905607743103,69.54675412402042,
	69.5444560444069,69.54216182596527,69.53987145613085,69.53758492239908,69.53530221232502,
	69.53302331352315,69.53074821366688,69.52847690048829,69.52620936177759,69.52394558538298,
	69.52168555921006,69.51942927122168,69.51717670943744,69.5149278619334,69.51268271684174,
	69.51044126235037,69.5082034867026,69.50596937819687,69.50373892518627,69.50151211607835,
	69.49928893933468,69.49706938347059,69.49485343705479,69.49264108870905,69.49043232710795,
	69.48822714097847,69.48602551909966,69.48382745030241,69.4816329234691,69.47944192753326,
	69.4772544514793,69.47507048434214,69.472890015207,69.47071303320901,69.46853952753298,
	69.46636948741306,69.46420290213241,69.462039761023,69.45988005346524,69.4577237688833,
	69.45557089676215,69.45342142662183,69.45127534803373,69.44913265061632,69.44699332403484,
	69.44485735800099,69.4427247422727,69.44059546665385,69.43846952099395,69.43634689518792,
	69.4342275791759,69.43211156294274,69.42999883651804,69.42788938997566,69.42578321343358,
	69.4236802970536,69.4215806310411,69.41948420564475,69.41739101115634,69.41530103791042,
	69.41321427628417,69.41113071669702,69.40905034961052,69.4069731655281,69.40489915499468,
	69.40282830859661,69.40076061696135,69.39869607075723,69.39663466069322,69.39457637751869,
	69.39252121202323,69.39046915503636,69.38842019742734,69.3863743301049,69.38433154401707,
	69.38229183015095,69.38025517953243,69.378221583226,69.37619103233459,69.3741635179993,
	69.37213903139914,69.37011756375092,69.36809910630895,69.36608365036486,69.36407118724742,
	69.3620617083223,69.36005520499182,69.35805166869488,69.3560510909066,69.35405346313821,
	69.35205877693681,69.35006702388523,69.34807819560174,69.34609228373994,69.34410927998849,
	69.34212917607098,69.34015196374568,69.33817763480546,69.3362061810774,69.33423759442279,
	69.33227186673687,69.33030898994863,69.32834895602063,69.32639175694885,69.32443738476249,
	69.32248583152374,69.3205370893277,69.31859115030207,69.31664800660712,69.3147076504354,
	69.31277007401162,69.31083526959245,69.30890322946635,69.30697394595342,69.30504741140523,
	69.30312361820458,69.30120255876545,69.29928422553276,69.29736861098213,69.29545570761992,
	69.29354550798288,69.29163800463805,69.2897331901826,69.2878310572437,69.28593159847831,
	69.28403480657302,69.28214067424393,69.28024919423652,69.27836035932536,69.27647416231413,
	69.27459059603535,69.27270965335025,69.27083132714864,69.26895561034875,69.2670824958971,
	69.26521197676827,69.26334404596489,69.26147869651737,69.25961592148381,69.25775571394986,
	69.25589806702851,69.25404297386008,69.25219042761196,69.25034042147848,69.24849294868082,
	69.24664800246687,69.24480557611102,69.24296566291413,69.2411282562033,69.23929334933175,
	69.23746093567873,69.23563100864938,69.23380356167455,69.23197858821068,69.23015608173974,
	69.22833603576899,69.22651844383093,69.22470329948312,69.22289059630812,69.2210803279133,
	69.21927248793065,69.21746707001691,69.21566406785314,69.21386347514473,69.21206528562136,
	69.21026949303673,69.20847609116848,69.20668507381814,69.20489643481092,69.20311016799567,
	69.20132626724472,69.1995447264537,69.19776553954152,69.19598870045024,69.19421420314497,
	69.1924420416136,69.19067220986689,69.18890470193824,69.18713951188364,69.18537663378149,
	69.18361606173252,69.18185778985969,69.18010181230812,69.17834812324483,69.17659671685882,
	69.17484758736084,69.17310072898333,69.17135613598028,69.16961380262717,69.16787372322081,
	69.16613589207927,69.1644003035418,69.16266695196865,69.16093583174106,69.15920693726105,
	69.15748026295142,69.15575580325562,69.15403355263763,69.15231350558179,69.15059565659286,
	69.14888000019583,69.1471665309358,69.14545524337794,69.14374613210734,69.14203919172895,
	69.14033441686747,69.13863180216727,69.13693134229226,69.13523303192584,69.13353686577075,
	69.13184283854908,69.13015094500203,69.12846117988995,69.12677353799218,69.12508801410696,
	69.12340460305141,69.1217232996613,69.12004409879108,69.11836699531383,69.11669198412098,
	69.11501906012244,69.11334821824633,69.11167945343904,69.11001276066506,69.10834813490692,
	69.10668557116509,69.10502506445788,69.10336660982148,69.10171020230965,69.10005583699385,
	69.09840350896305,69.09675321332367,69.09510494519948,69.09345869973157,69.09181447207823,
	69.09017225741482,69.08853205093382,69.08689384784464,69.08525764337358,69.08362343275832,
	69.0819912112693,69.08036097417784,69.07873271677701,69.07710643437639,69.075482122302,
	69.07385977589614,69.07223939051748,69.07062096154078,69.06900448435698,69.0673899543731,
	69.06577736701207,69.06416671771278,69.06255800192987,69.06095121513384,69.05934635281078,
	69.05774341046245,69.05614238360614,69.05454326777459,69.05294605851596,69.05135075139376,
	69.04975734198669,69.0481658258887,69.04657619870889,69.04498845607134,69.04340259361514,
	69.04181860699435,69.04023649187779,69.03865624394915,69.03707785890677,69.03550133246371,
	69.03392666034755,69.03235383830045,69.03078286207895,69.02921372745406,69.02764643021105,
	69.02608096614951,69.02451733108319,69.02295552083997,69.02139553126185,69.01983735820477,
	69.01828099753868,69.0167264451474,69.0151736969285,69.01362274879345,69.0120735966673,
	69.0105262364888,69.0089806642103,69.00743687579758,69.00589486722997,69.00435463450019,
	69.00281617361426,69.00127948059152,68.99974455146452,68.99821138227901,68.99667996909376,
	68.99515030798075,68.9936223950248,68.99209622632375,68.99057179798832,68.98904910614202,
	68.98752814692115,68.98600891647476,68.98449141096451,68.98297562656468,68.98146155946213,
	68.9799492058562,68.97843856195863,68.97692962399361,68.97542238819763,68.97391685081945,
	68.97241300812013,68.9709108563728,68.96941039186284,68.96791161088757,68.9664145097564,
	68.96491908479078,68.96342533232391,68.96193324870099,68.96044283027898,68.95895407342661,
	68.9574669745244,68.95598152996436,68.95449773615033,68.95301558949755,68.95153508643288,
	68.95005622339455,68.94857899683234,68.94710340320731,68.94562943899184,68.94415710066964,
	68.9426863847356,68.9412172876958,68.9397498060675,68.93828393637901,68.93681967516966,
	68.9353570189898,68.9338959644007,68.93243650797463,68.93097864629458,68.92952237595442,
	68.9280676935588,68.92661459572308,68.92516307907327,68.92371314024604,68.9222647758886,
	68.9208179826588,68.91937275722493,68.91792909626568,68.91648699647028,68.91504645453821,
	68.91360746717936,68.91217003111386,68.91073414307209,68.90929979979465,68.90786699803229,
	68.90643573454587,68.90500600610628,68.90357780949454,68.90215114150156,68.90072599892831,
	68.89930237858557,68.89788027729406,68.89645969188426,68.89504061919651,68.89362305608086,
	68.89220699939708,68.8907924460146,68.8893793928125,68.88796783667944,68.88655777451363,
	68.8851492032228,68.88374211972415,68.88233652094429,68.88093240381934,68.87952976529465,
	68.87812860232494,68.87672891187422,68.87533069091579,68.87393393643204,68.87253864541469,
	68.87114481486448,68.86975244179133,68.86836152321415,68.86697205616093,68.86558403766861,
	68.86419746478315,68.86281233455938,68.86142864406101,68.86004639036065,68.85866557053964,
	68.85728618168821,68.85590822090522,68.8545316852983,68.85315657198379,68.85178287808661,
	68.85041060074025,68.8490397370869,68.84767028427717,68.84630223947022,68.84493559983372,
	68.8435703625437,68.84220652478466,68.8408440837494,68.83948303663915,68.83812338066339,
	68.83676511303987,68.8354082309946,68.8340527317618,68.83269861258384,68.83134587071127,
	68.82999450340277,68.82864450792499,68.82729588155276,68.82594862156887,68.82460272526411,
	68.8232581899372,68.82191501289483,68.82057319145157,68.81923272292983,68.81789360465983,
	68.81655583397973,68.81521940823528,68.81388432478008,68.81255058097545,68.81121817419034,
	68.80988710180141,68.8085573611929,68.80722894975668,68.80590186489212,68.80457610400623,
	68.80325166451345,68.80192854383574,68.8006067394025,68.79928624865053,68.79796706902405,
	68.79664919797465,68.79533263296125,68.79401737145008,68.79270341091464,68.7913907488357,
	68.79007938270126,68.78876931000654,68.78746052825387,68.78615303495278,68.78484682761989,
	68.78354190377894
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	127.20225505231797,127.14473552149342,127.08720854506198,127.02967413493151,126.97213230303844,
	126.9145830613479,126.85702642185376,126.79946239657872,126.74189099757442,126.68431223692141,
	126.62672612672945,126.5691326791373,126.51153190631305,126.45392382045408,126.39630843378711,
	126.33868575856846,126.28105580708377,126.22341859164862,126.16577412460806,126.10812241833698,
	126.05046348524021,125.99279733775248,125.93512398833862,125.87744344949351,125.81975573374221,
	125.76206085364018,125.70435882177313,125.64664965075724,125.58893335323926,125.53120994189645,
	125.47347942943694,125.41574182859945,125.3579971521536,125.30024541290011,125.24248662367046,
	125.18472079732743,125.12694794676493,125.06916808490813,125.01138122471356,124.95358737916925,
	124.89578656129464,124.8379787841409,124.78016406079081,124.72234240435894,124.66451382799175,
	124.60667834486762,124.54883596819697,124.49098671122236,124.43313058721847,124.3752676094924,
	124.31739779138351,124.25952114626364,124.20163768753721,124.14374742864122,124.0858503830454,
	124.02794656425233,123.9700359857974,123.91211866124904,123.85419460420866,123.79626382831088,
	123.73832634722359,123.68038217464792,123.62243132431838,123.5644738100031,123.50650964550367,
	123.44853884465545,123.39056142132748,123.3325773894227,123.27458676287792,123.216589555664,
	123.15858578178594,123.10057545528292,123.04255859022838,122.98453520073016,122.92650530093057,
	122.86846890500644,122.81042602716926,122.75237668166524,122.69432088277544,122.63625864481583,
	122.57818998213727,122.52011490912588,122.46203344020287,122.4039455898247,122.34585137248318,
	122.28775080270565,122.22964389505493,122.17153066412945,122.11341112456338,122.05528529102678,
	121.99715317822546,121.93901480090133,121.88087017383238,121.8227193118327,121.76456222975277,
	121.70639894247928,121.64822946493548,121.59005381208115,121.53187199891266,121.47368404046314,
	121.41548995180253,121.35728974803763,121.29908344431233,121.24087105580756,121.18265259774144,
	121.12442808536942,121.06619753398424,121.00796095891619,120.94971837553305,120.89146979924033,
	120.83321524548116,120.77495472973666,120.7166882675258,120.65841587440558,120.60013756597115,
	120.54185335785584,120.4835632657313,120.42526730530761,120.36696549233334,120.30865784259562,
	120.25034437192028,120.19202509617193,120.13370003125412,120.0753691931093,120.01703259771895,
	119.95869026110384,119.90034219932386,119.84198842847839,119.78362896470607,119.72526382418529,
	119.66689302313391,119.6085165778097,119.55013450451005,119.49174681957246,119.43335353937432,
	119.37495468033323,119.31655025890696,119.2581402915936,119.19972479493167,119.14130378550016,
	119.08287727991865,119.02444529484748,118.9660078469877,118.90756495308136,118.84911662991139,
	118.79066289430187,118.73220376311806,118.67373925326646,118.615269381695,118.55679416539304,
	118.49831362139156,118.43982776676316,118.38133661862223,118.32284019412506,118.26433851046983,
	118.20583158489686,118.14731943468861,118.08880207716975,118.03027952970736,117.97175180971097,
	117.91321893463262,117.85468092196709,117.79613778925179,117.73758955406711,117.67903623403629,
	117.6204778468257,117.56191441014471,117.50334594174615,117.44477245942598,117.3861939810238,
	117.3276105244226,117.26902210754903,117.21042874837363,117.15183046491057,117.09322727521813,
	117.03461919739854,116.97600624959814,116.91738845000764,116.858765816862,116.80013836844059,
	116.74150612306732,116.68286909911089,116.62422731498454,116.56558078914645,116.50692954009973,
	116.4482735863925,116.38961294661807,116.33094763941492,116.27227768346694,116.21360309750341,
	116.15492390029917,116.09624011067469,116.03755174749617,115.97885882967572,115.92016137617128,
	115.86145940598693,115.80275293817284,115.74404199182544,115.68532658608751,115.62660674014826,
	115.56788247324349,115.50915380465553,115.45042075371359,115.39168333979364,115.33294158231867,
	115.27419550075868,115.21544511463078,115.15669044349943,115.09793150697634,115.03916832472073,
	114.9804009164394,114.92162930188671,114.86285350086486,114.8040735332239,114.74528941886179,
	114.6865011777246,114.62770882980654,114.56891239515005,114.51011189384599,114.45130734603366,
	114.39249877190089,114.33368619168421,114.27486962566894,114.2160490941892,114.15722461762817,
	114.09839621641798,114.03956391104005,113.98072772202497,113.92188766995277,113.86304377545294,
	113.80419605920453,113.74534454193628,113.68648924442668,113.62763018750414,113.568767392047,
	113.50990087898369,113.45103066929282,113.39215678400335,113.3332792441945,113.27439807099606,
	113.21551328558836,113.15662490920242,113.09773296312008,113.038837468674,112.97993844724787,
	112.92103592027644,112.86212990924568,112.80322043569281,112.74430752120642,112.68539118742666,
	112.6264714560452,112.5675483488054,112.50862188750243,112.44969209398333,112.39075899014719,
	112.33182259794503,112.27288293938028,112.21394003650842,112.15499391143747,112.09604458632793,
	112.0370920833928,111.97813642489781,111.91917763316151,111.86021573055525,111.80125073950343,
	111.74228268248352,111.68331158202614,111.62433746071518,111.565360341188,111.50638024613532,
	111.4473971983015,111.38841122048456,111.32942233553626,111.27043056636228,111.21143593592227,
	111.15243846722989,111.09343818335299,111.0344351074137,110.97542926258846,110.91642067210829,
	110.8574093592586,110.79839534737955,110.73937865986606,110.68035932016782,110.62133735178952,
	110.56231277829092,110.50328562328677,110.44425591044727,110.38522366349778,110.32618890621912,
	110.26715166244769,110.20811195607546,110.14906981105014,110.09002525137517,110.03097830111003,
	109.97192898437007,109.91287732532679,109.85382334820794,109.79476707729742,109.73570853693562,
	109.67664775151933,109.61758474550199,109.55851954339357,109.49945216976097,109.44038264922777,
	109.38131100647463,109.32223726623913,109.26316145331606,109.20408359255742,109.14500370887247,
	109.0859218272279,109.02683797264794,108.96775217021437,108.9086644450667,108.84957482240209,
	108.79048332747574,108.73138998560067,108.67229482214805,108.61319786254705,108.5540991322852,
	108.4949986569083,108.43589646202052,108.37679257328463,108.31768701642189,108.25857981721227,
	108.1994710014945,108.14036059516617,108.08124862418384,108.02213511456303,107.96302009237843,
	107.90390358376398,107.8447856149128,107.78566621207746,107.72654540157002,107.66742320976205,
	107.60829966308474,107.54917478802908,107.49004861114581,107.43092115904561,107.37179245839907,
	107.31266253593695,107.25353141845008,107.19439913278956,107.13526570586679,107.07613116465357,
	107.01699553618222,106.9578588475456,106.89872112589721,106.83958239845131,106.78044269248296,
	106.72130203532811,106.66216045438371,106.60301797710775,106.54387463101936,106.48473044369885,
	106.42558544278793,106.36643965598958,106.30729311106832,106.2481458358501,106.18899785822259,
	106.1298492061351,106.0706999075987,106.01154999068635,105.95239948353287,105.89324841433512,
	105.83409681135205,105.77494470290468,105.71579211737635,105.65663908321264,105.59748562892153,
	105.53833178307342,105.47917757430127,105.42002303130062,105.3608681828296,105.30171305770924,
	105.24255768482321,105.18340209311818,105.12424631160371,105.0650903693524,105.00593429549996,
	104.94677811924525,104.88762186985032,104.8284655766406,104.76930926900485,104.7101529763952,
	104.65099672832739,104.59184055438065,104.53268448419793,104.47352854748576,104.41437277401454,
	104.35521719361846,104.2960618361956,104.23690673170805,104.17775191018181,104.11859740170709,
	104.05944323643816,104.00028944459353,103.941136056456,103.88198310237269,103.82283061275506,
	103.7636786180791,103.70452714888523,103.64537623577853,103.58622590942858,103.5270762005698,
	103.46792714000124,103.40877875858675,103.34963108725503,103.29048415699981,103.23133799887961,
	103.17219264401807,103.11304812360383,103.05390446889076,102.9947617111978,102.93561988190916,
	102.87647901247432,102.81733913440809,102.75820027929069,102.69906247876771,102.63992576455026,
	102.58079016841498,102.52165572220403,102.46252245782524,102.4033904072521,102.34425960252382,
	102.28513007574531,102.22600185908738,102.16687498478656,102.1077494851454,102.04862539253233,
	101.98950273938169,101.93038155819394,101.87126188153556,101.81214374203905,101.75302717240321,
	101.69391220539286,101.6347988738391,101.57568721063933,101.51657724875712,101.45746902122245,
	101.39836256113166,101.33925790164749,101.28015507599903,101.22105411748197,101.16195505945836,
	101.1028579353569,101.04376277867276,100.98466962296777,100.92557850187035,100.8664894490756,
	100.80740249834524,100.7483176835078,100.68923503845848,100.63015459715929,100.571076393639,
	100.51200046199321,100.45292683638439,100.39385555104187,100.33478664026191,100.27572013840759,
	100.21665607990906,100.15759449926335,100.09853543103452,100.03947890985359,99.9804249704187,
	99.92137364749492,99.86232497591453,99.8032789905768,99.74423572644811,99.685195218562,
	99.62615750201915,99.5671226119874,99.50809058370174,99.44906145246438,99.39003525364468,
	99.33101202267933,99.27199179507215,99.21297460639424,99.153960492284,99.09494948844707,
	99.03594163065637,98.97693695475213,98.9179354966419,98.85893729230052,98.79994237777022,
	98.7409507891605,98.68196256264828,98.62297773447779,98.56399634096064,98.50501841847586,
	98.44604400346981,98.38707313245631,98.32810584201654,98.26914216879909,98.21018214952001,
	98.15122582096278,98.09227321997824,98.03332438348477,97.97437934846818,97.9154381519817,
	97.85650083114608,97.7975674231495,97.73863796524766,97.67971249476376,97.62079104908844,
	97.56187366567994,97.50296038206396,97.44405123583374,97.38514626465007,97.32624550624125,
	97.2673489984032,97.20845677899938,97.14956888596079,97.09068535728612,97.0318062310416,
	96.97293154536108,96.91406133844613,96.85519564856587,96.79633451405714,96.73747797332446,
	96.67862606484007,96.619778827144,96.56093629884391,96.50209851861531,96.44326552520153,
	96.38443735741372,96.32561405413087,96.26679565429986,96.20798219693553,96.14917372112066,
	96.09037026600603,96.03157187081047,95.97277857482088,95.91399041739227,95.85520743794788,
	95.79642967597914,95.7376571710458,95.6788899627759,95.62012809086592,95.56137159508083,
	95.50262051525407,95.44387489128779,95.38513476315276,95.32640017088856,95.26767115460363,
	95.20894775447539,95.15023001075026,95.09151796374385,95.03281165384107,94.97411112149616,
	94.91541640723293,94.85672755164477,94.79804459539488,94.73936757921635,94.68069654391238,
	94.62203153035637,94.56337257949207,94.5047197323339,94.44607302996695,94.38743251354732,
	94.32879822430223,94.27017020353027,94.21154849260168,94.15293313295847,94.09432416611477,
	94.03572163365709,93.97712557724448,93.91853603860902,93.85995305955586,93.80137668196386,
	93.74280694778555,93.68424389904789,93.62568757785222,93.56713802637496,93.50859528686786,
	93.45005940165848,93.39153041315058,93.33300836382459,93.27449329623816,93.21598525302657,
	93.15748427690329,93.09899041066055,93.04050369716991,92.98202417938289,92.92355190033146,
	92.86508690312891,92.80662923097039,92.7481789271337,92.68973603497994,92.63130059795444,
	92.57287265958745,92.51445226349507,92.45603945338017,92.39763427303316,92.33923676633314,
	92.28084697724888,92.22246494983978,92.16409072825707,92.10572435674493,92.04736587964173,
	91.98901534138118,91.93067278649377,91.87233825960804,91.81401180545205,91.75569346885482,
	91.69738329474795,91.63908132816705,91.58078761425375,91.5225021982571,91.46422512553558,
	91.40595644155897,91.34769619191034,91.28944442228808,91.23120117850804,91.17296650650582,
	91.11474045233909,91.05652306218997,90.99831438236762,90.94011445931082,90.8819233395908,
	90.82374106991395,90.76556769712495,90.70740326820979,90.64924783029896,90.59110143067092,
	90.53296411675548,90.47483593613751,90.41671693656063,90.35860716593132,90.30050667232284,
	90.24241550397963,90.18433370932166,90.12626133694918,90.06819843564729,90.01014505439127,
	89.95210124235149,89.89406704889903,89.83604252361123,89.77802771627756,89.72002267690571,
	89.66202745572804,89.60404210320803,89.54606667004727,89.48810120719251,89.43014576584319,
	89.37220039745915,89.31426515376856,89.25634008677646,89.19842524877329,89.14052069234404,
	89.08262647037762,89.0247426360767,88.96686924296776,88.90900634491179,88.85115399611522,
	88.79331225114134,88.7354811649223,88.67766079277139,88.6198511903959,88.56205241391046,
	88.50426451985108,88.44648756518936,88.38872160734776,88.33096670421507,88.27322291416263,
	88.21549029606136,88.15776890929907,88.1000588137989,88.04236007003819,87.9846727390682,
	87.92699688253458,87.86933256269865,87.81167984245953,87.75403878537718,87.69640945569628,
	87.63879191837104,87.58118623909104,87.52359248430808,87.46601072126404,87.40844101801987,
	87.35088344348574,87.29333806745221,87.23580496062296,87.17828419464837,87.12077584216081,
	87.06327997681089,87.00579667330572,86.94832600744797,86.89086805617701,86.83342289761126,
	86.77599061109255,86.71857127723193,86.66116497795724,86.60377179656287,86.54639181776102,
	86.48902512773536,86.43167181419633,86.37433196643897,86.31700567540284,86.25969303373414,
	86.20239413585043,86.14510907800782,86.08783795837053,86.03058087708342,85.97333793634725,
	85.91610924049657,85.85889489608095,85.80169501194923,85.74450969933689,85.6873390719567,
	85.63018324609332,85.57304234070085,85.51591647750459,85.45880578110639,85.40171037909431,
	85.3446304021561,85.28756598419727,85.23051726246351,85.1734843776677,85.1164674741219,
	85.0594666998741,85.00248220685029,84.94551415100176,84.88856269245802,84.83162799568544,
	84.77471022965166,84.71780956799637,84.66092618920835,84.6040602768091,84.54721201954305,
	84.49038161157537,84.43356925269636,84.37677514853398,84.31999951077377,84.26324255738707,
	84.20650451286733,84.14978560847523,84.09308608249262,84.03640618048561,83.97974615557699,
	83.92310626872883,83.86648678903471,83.80988799402269,83.75331016996877,83.69675361222173,
	83.64021862553898,83.5837055244346,83.52721463353903,83.47074628797168,83.41430083372595,
	83.3578786280677,83.30148003994721,83.24510545042504,83.18875525311233,83.13242985462546,
	83.0761296750562,83.0198551484571,82.96360672334265,82.90738486320684,82.85119004705709,
	82.79502276996533,82.73888354363636,82.68277289699385,82.62669137678445,82.57063954820018,
	82.51461799551973,82.45862732276854,82.40266815439853,82.34674113598699,82.2908469349559,
	82.23498624131079,82.17915976840027,82.12336825369589,82.0676124595926,82.01189317422995,
	81.95621121233407,81.90056741608024,81.84496265597649,81.7893978317674,81.73387387335879,
	81.6783917417622,81.6229524300595,81.56755696438712,81.5122064049389,81.45690184698836,
	81.40164442192612,81.34643529831901,81.29127568298078,81.23616682206033,81.1811100021431,
	81.12610655136557,81.07115784054064,81.01626528429293,80.96143034220187,80.90665451995078,
	80.85193937047983,80.79728649514054,80.7426975448494,80.68817422123774,80.633718277795,
	80.57933152100227,80.52501581145279,80.47077306495537,80.41660525361745,80.36251440690302,
	80.30850261266167,80.25457201812347,80.20072483085517,80.14696331967237,80.09328981550237,
	80.03970671219169,79.9862164672525,79.93282160254184,79.87952470486675,79.8263284265091,
	79.7732354856629,79.72024866677705,79.66737082079636,79.61460486529313,79.561953784482,
	79.50942062911031,79.45700851621626,79.40472062874704,79.3525602150293,79.30053058808434,
	79.24863512478056,79.19687726481544,79.14526050952063,79.09378842048251,79.04246461797256,
	78.9912927791809,78.94027663624787,78.88941997408857,78.83872662800592,78.78820048108912,
	78.73784546139419,78.68766553890507,78.63766472227432,78.58784705534333,78.53821661344317,
	78.48877749947873,78.43953383979945,78.39048977986131,78.34164947968623,78.2930171091266,
	78.24459684294301,78.1963928557063,78.14840931653436,78.10065038367723,78.0531201989648,
	78.00582288213187,77.95876252503808,77.91194318580015,77.86536888285575,77.81904358897859,
	77.77297122526612,77.72715565512108,77.68160067824945,77.6363100246975,77.591287348951,
	77.5465362241201,77.50206013623291,77.45786247866108,77.41394654670017,77.37031553232707,
	77.32697251915602,77.28392047761402,77.2411622603554,77.19870059793395,77.15653809474985,
	77.11467722528738,77.0731203306573,77.03186961545671,76.9909271449569,76.95029484262842,
	76.90997448801009,76.8699677149275,76.8302760100638,76.7909007118844,76.75184300991498,
	76.71310394436999,76.67468440612787,76.63658513704667,76.59880673061264,76.56134963291251,
	76.52421414391883,76.48740041907652,76.45090847117767,76.41473817251003,76.37888925726452,
	76.34336132418571,76.30815383944885,76.27326613974637,76.23869743556641,76.20444681464636,
	76.17051324558275,76.13689558158075,76.10359256432503,76.07060282795527,76.03792490312883,
	76.00555722115429,75.97349811817992,75.94174583942123,75.91029854341312,75.87915430627243,
	75.84831112595714,75.81776692651002,75.78751956227457,75.7575668220721,75.7279064333301,
	75.69853606615197,75.6694533373199,75.64065581422271,75.61214101870202,75.58390643081025,
	75.55594949247487,75.52826761106448,75.5008581628523,75.47371849637378,75.44684593567555,
	75.42023778345367,75.39389132407901,75.36780382650963,75.34197254708837,75.31639473222663,
	75.29106762097356,75.2659884474722,75.24115444330293,75.21656283971579,75.19221086975327,
	75.1680957702653,75.14421478381851,75.12056516050221,75.09714415963306,75.0739490513617,
	75.05097711818307,75.02822565635421,75.00569197722176,74.9833734084621,74.96126729523743,
	74.9393710012705,74.91768190984114,74.89619742470744,74.87491497095472,74.85383199577525,
	74.83294596918148,74.81225438465593,74.79175475974043,74.7714446365673,74.75132158233605,
	74.73138318973689,74.71162707732505,74.6920508898475,74.67265229852494,74.65342900129146,
	74.63437872299383,74.61549921555326,74.59678825809104,74.57824365702085,74.5598632461092,
	74.54164488650622,74.52358646674442,74.50568590273231,74.4879411376805,74.47035014204917,
	74.45291091345169,74.43562147654282,74.41847988288882,74.4014842108203,74.38463256526936,
	74.36792307759215,74.35135390537806,74.3349232322465,74.31862926763246,74.30247024656184,
	74.28644442941722,74.27055010169533,74.25478557375682,74.23914918056904,74.22363928144286,
	74.20825425976398,74.1929925227194,74.17785250101984,74.16283264861865,74.14793144242734,
	74.13314738202912,74.1184789893899,74.10392480856807,74.0894834054228,74.07515336732189,
	74.06093330284892,74.04682184151046,74.03281763344354,74.01891934912351,74.00512567907302,
	73.99143533357157,73.97784704236696,73.9643595543877,73.9509716374574,73.93768207801114,
	73.92448968081356,73.91139326867967,73.89839168219738,73.88548377945308,73.87266843575946,
	73.85994454338622,73.8473110112934,73.83476676486777,73.82231074566195,73.80994191113679,
	73.79765923440661,73.7854617039876,73.77334832354956,73.76131811167053,73.74937010159493,
	73.73750334099473,73.72571689173408,73.71400982963704,73.70238124425872,73.69083023865966,
	73.67935592918354,73.66795744523816,73.65663392907962,73.6453845355999,73.63420843211773,
	73.62310479817242,73.61207282532125,73.60111171693988,73.59022068802597,73.57939896500596,
	73.56864578554502,73.55796039835994,73.54734206303532,73.53679004984262,73.52630363956233,
	73.51588212330897,73.50552480235922,73.4952309879828,73.48500000127619,73.47483117299944,
	73.46472384341544,73.45467736213217,73.44469108794759,73.43476438869719,73.42489664110428,
	73.41508723063285,73.40533555134282,73.39564100574809,73.38600300467701,73.37642096713515,
	73.36689432017059,73.35742249874171,73.34800494558701,73.3386411110976,73.32933045319163,
	73.32007243719119,73.31086653570117,73.30171222849052,73.29260900237546,73.28355635110472,
	73.2745537752471,73.26560078208067,73.25669688548426,73.24784160583069,73.23903446988199,
	73.23027501068644,73.22156276747762,73.21289728557495,73.20427811628632,73.1957048168122,
	73.18717695014746,73.1786940850064,73.17025579570515,73.16186166209093,73.15351126944987,
	73.14520420842099,73.13694007491182,73.1287184700154,73.12053899992895,73.11240127587378,
	73.10430491401671,73.09624953539291,73.08823476583012,73.08026023587406,73.0723255807154,
	73.06443044011786,73.0565744583475,73.04875728410356,73.04097857045019,73.0332379747496,
	73.02553515859626,73.01786978775229,73.01024153208405,73.00265006549978,72.99509506588822,
	72.9875762150586,72.9800931986813,72.97264570622994,72.96523343092404,72.95785606967311,
	72.95051332302138,72.94320489509367,72.93593049354207,72.9286898294937,72.92148261749924,
	72.91430857548227,72.9071674246898,72.90005888964325,72.89298269809053,72.88593858095886,
	72.8789262723084,72.87194550928668,72.86499603208367,72.85807758388793,72.85118991084316,
	72.84433276200562,72.83750588930239,72.83070904749009,72.82394199411446,72.81720448947064,
	72.81049629656393,72.80381718107144,72.7971669113042,72.79054525816996,72.78395199513666,
	72.77738689819643,72.77084974583015,72.7643403189728,72.75785840097912,72.75140377758996,
	72.74497623689923,72.7385755693213,72.73220156755897,72.72585402657194,72.71953274354583,
	72.7132375178617,72.70696815106604,72.70072444684118,72.69450621097641,72.6883132513392,
	72.68214537784728,72.67600240244083,72.66988413905536,72.66379040359483,72.65772101390537,
	72.65167578974933,72.64565455277967,72.6396571265149,72.63368333631436,72.62773300935385,
	72.6218059746016,72.61590206279493,72.61002110641671,72.60416293967273,72.59832739846917,
	72.5925143203904,72.58672354467723,72.58095491220539,72.57520826546445,72.56948344853703,
	72.5637803070782,72.55809868829544,72.55243844092877,72.54679941523099,72.54118146294874,
	72.53558443730324,72.53000819297178,72.52445258606924,72.51891747413008,72.51340271609027,
	72.50790817226999,72.50243370435608,72.49697917538516,72.49154444972669,72.4861293930665,
	72.48073387239049,72.47535775596849,72.47000091333854,72.46466321529122,72.45934453385432,
	72.4540447422777,72.4487637150184,72.44350132772587,72.43825745722762,72.43303198151479,
	72.42782477972825,72.4226357321446,72.41746472016266,72.41231162628982,72.407176334129,
	72.40205872836539,72.39695869475364,72.3918761201052,72.38681089227566,72.3817629001526,
	72.37673203364322,72.37171818366258,72.36672124212151,72.36174110191517,72.35677765691142,
	72.3518308019396,72.34690043277924,72.34198644614916,72.33708873969651,72.33220721198613,
	72.32734176248998,72.32249229157661,72.31765870050113,72.31284089139479,72.30803876725525,
	72.3032522319366,72.29848119013961,72.29372554740226,72.28898521009017,72.28426008538734,
	72.27955008128701,72.27485510658244,72.27017507085813,72.26550988448079,72.26085945859089,
	72.25622370509384,72.25160253665162,72.2469958666744,72.24240360931233,72.23782567944727,
	72.23326199268493,72.2287124653468,72.22417701446243,72.21965555776167,72.21514801366703,
	72.21065430128625,72.20617434040476,72.20170805147843,72.19725535562641,72.19281617462387,
	72.18839043089508,72.18397804750634,72.17957894815927,72.17519305717906,72.17082029952768,
	72.16646060076702,72.16211388707286,72.15778008522331,72.15345912259237,72.14915092714375,
	72.14485542742464,72.14057255255962,72.13630223224467,72.13204439674112,72.12779897686993,
	72.12356590400573,72.11934511007124,72.1151365275315,72.11094008938832,72.10675572917482,
	72.10258338094997,72.09842297929303,72.09427445929859,72.09013775657102,72.08601280721939,
	72.08189954785242,72.07779791557337,72.07370784797497,72.06962928313469,72.06556215960964,
	72.06150641643197,72.05746199310394,72.05342882959337,72.04940686632891,72.0453960441955,
	72.04139630452983,72.03740758911592,72.03342984018059,72.02946300038923,72.0255070128414,
	72.02156182106665,72.01762736902016,72.01370360107879,72.00979046203678,72.00588789710183,
	72.00199585189101,71.99811427242685,71.99424310513331,71.99038229683211,71.98653179473868,
	71.98269154645854,71.97886149998347,71.97504160368786,71.9712318063251,71.96743205702387,
	71.96364230528464,71.95986250097616,71.95609259433189,71.95233253594671,71.94858227677334,
	71.9448417681191,71.94111096164254,71.93738980935012,71.93367826359307,71.92997627706399,
	71.92628380279388,71.92260079414886,71.9189272048271,71.91526298885579,71.91160810058801,
	71.90796249469986,71.90432612618737,71.90069895036366,71.89708092285593,71.89347199960277,
	71.88987213685108,71.88628129115344,71.88269941936538,71.87912647864242,71.87556242643754,
	71.87200722049845,71.8684608188649,71.86492317986607,71.86139426211807,71.85787402452118,
	71.85436242625751,71.8508594267883,71.84736498585167,71.84387906345991,71.84040161989721,
	71.83693261571722,71.83347201174067,71.83001976905301,71.82657584900205,71.82314021319576,
	71.81971282349987,71.8162936420357,71.81288263117791,71.80947975355227,71.80608497203355,
	71.80269824974322,71.79931955004749,71.79594883655507,71.79258607311512,71.78923122381524,
	71.78588425297926,71.78254512516543,71.77921380516425,71.77589025799655,71.77257444891151,
	71.76926634338479,71.76596590711647,71.76267310602928,71.75938790626665,71.75611027419087,
	71.75284017638121,71.74957757963217,71.74632245095161,71.74307475755897,71.73983446688354,
	71.73660154656265,71.73337596444003,71.73015768856399,71.72694668718576,71.72374292875787,
	71.72054638193242,71.71735701555943,71.7141747986852,71.71099970055086,71.70783169059047,
	71.70467073842973,71.70151681388425,71.69836988695808,71.69522992784208,71.69209690691251,
	71.68897079472951,71.68585156203548,71.68273917975382,71.67963361898732,71.67653485101671,
	71.67344284729934,71.67035757946765,71.66727901932788,71.6642071388585,71.6611419102091,
	71.65808330569877,71.65503129781493,71.65198585921185,71.6489469627095,71.64591458129209,
	71.64288868810685,71.6398692564627,71.63685625982906,71.63384967183447,71.63084946626546,
	71.62785561706522,71.62486809833244,71.62188688432013,71.61891194943425,71.61594326823274,
	71.61298081542427,71.61002456586691,71.60707449456724,71.60413057667901,71.60119278750211,
	71.5982611024814,71.59533549720558,71.5924159474062,71.58950242895642,71.58659491787,
	71.58369339030027,71.58079782253897,71.5779081910153,71.57502447229484,71.57214664307848,
	71.56927468020145,71.56640856063228,71.56354826147182,71.56069375995226,71.55784503343602,
	71.555002059415,71.55216481550943,71.54933327946692,71.54650742916164,71.54368724259326,
	71.5408726978861,71.53806377328814,71.53526044717009,71.5324626980246,71.52967050446527,
	71.52688384522571,71.52410269915885,71.52132704523582,71.5185568625453,71.51579213029248,
	71.51303282779841,71.51027893449896,71.50753042994404,71.50478729379695,71.50204950583323,
	71.49931704594017,71.49658989411579,71.49386803046814,71.49115143521445,71.48844008868043,
	71.48573397129938,71.48303306361157,71.48033734626325,71.47764680000616,71.47496140569656,
	71.4722811442946,71.46960599686358,71.46693594456916,71.46427096867865,71.46161105056039,
	71.45895617168289,71.4563063136142,71.45366145802124,71.451021586669,71.44838668142,
	71.44575672423348,71.44313169716479,71.44051158236465,71.43789636207867,71.43528601864641,
	71.43268053450096,71.43007989216818,71.4274840742661,71.42489306350423,71.42230684268307,
	71.41972539469326,71.41714870251515,71.4145767492181,71.4120095179599,71.40944699198614,
	71.40688915462961,71.40433598930973,71.40178747953198,71.39924360888719,71.39670436105116,
	71.39416971978393,71.39163966892924,71.389114192414,71.38659327424772,71.38407689852193,
	71.38156504940964,71.37905771116482,71.37655486812179,71.37405650469478,71.37156260537729,
	71.36907315474167,71.36658813743847,71.36410753819604,71.36163134181994,71.35915953319245,
	71.35669209727209,71.35422901909301,71.35177028376467,71.34931587647117,71.34686578247084,
	71.34441998709578,71.34197847575129,71.33954123391551,71.33710824713877,71.33467950104334,
	71.33225498132276,71.32983467374149,71.32741856413442,71.32500663840639,71.32259888253178,
	71.32019528255405,71.31779582458053,71.31540049480114,71.3130092794589,71.31062216486914,
	71.30823913741402,71.30586018354212,71.30348528976813,71.30111444267224,71.29874762889987,
	71.2963848351612,71.29402604823076,71.29167125494698,71.2893204422119,71.28697359699065,
	71.28463070631106,71.2822917572634,71.2799567369998,71.27762563273397,71.27529843174081,
	71.27297512135594,71.27065568897548,71.26834012205549,71.26602840811175,71.26372053471923,
	71.2614164895119,71.25911626018224,71.25681983448084,71.25452720021624,71.2522383452543,
	71.24995325751811,71.24767192498742,71.24539433569838,71.24312047774328,71.24085033927001,
	71.23858390848191,71.2363211736373,71.23406212304918,71.23180674508495,71.22955502816602,
	71.22730696076745,71.22506253141773,71.22282172869835,71.22058454124353,71.21835095773989,
	71.21612096692614,71.21389455759272,71.21167171858161,71.20945243878585,71.20723670714935,
	71.20502451266657,71.20281584438214,71.20061069139071,71.19840904283647,71.19621088791301,
	71.19401621586289,71.19182501597744,71.1896372775965,71.18745299010801,71.18527214294781,
	71.18309472559933,71.18092072759335,71.17875013850762,71.17658294796672,71.17441914564166,
	71.1722587212497,71.170101664554,71.1679479653634,71.16579761353213,71.16365059895962,
	71.16150691159008,71.15936654141233,71.15722947845961,71.15509571280921,71.15296523458227,
	71.15083803394347,71.14871410110085,71.14659342630553,71.14447599985141,71.14236181207502,
	71.14025085335523,71.13814311411292,71.13603858481093,71.13393725595363,71.13183911808676,
	71.12974416179725,71.12765237771285,71.12556375650206,71.12347828887371,71.12139596557694,
	71.11931677740075,71.11724071517398,71.11516776976492,71.11309793208123,71.11103119306956,
	71.10896754371551,71.1069069750432,71.10484947811523,71.10279504403242,71.10074366393353,
	71.09869532899512,71.09665003043129,71.09460775949347,71.09256850747033,71.09053226568734,
	71.08849902550679,71.08646877832747,71.08444151558444,71.08241722874897,71.08039590932819,
	71.07837754886495,71.07636213893763,71.07434967115994,71.0723401371807,71.07033352868372,
	71.06832983738748,71.06632905504507,71.06433117344392,71.06233618440562,71.06034407978582,
	71.05835485147388,71.05636849139283,71.05438499149909,71.05240434378244,71.05042654026558,
	71.04845157300424,71.04647943408676,71.04451011563408,71.04254360979948,71.04057990876844,
	71.03861900475842,71.03666089001874,71.03470555683039,71.03275299750585,71.03080320438893,
	71.02885616985459,71.02691188630881,71.02497034618841,71.02303154196078,71.02109546612392,
	71.01916211120613,71.01723146976586,71.01530353439162,71.0133782977017,71.01145575234418,
	71.0095358909966,71.00761870636596,71.00570419118843,71.00379233822926,71.00188314028267,
	70.9999765901716,70.99807268074763,70.99617140489079,70.99427275550943,70.9923767255401,
	70.99048330794736,70.98859249572362,70.98670428188906,70.9848186594914,70.98293562160588,
	70.98105516133496,70.97917727180828,70.97730194618255,70.97542917764129,70.97355895939477,
	70.97169128467995,70.96982614676008,70.96796353892492,70.96610345449032,70.96424588679821,
	70.96239082921645,70.96053827513866,70.95868821798418,70.95684065119781,70.9549955682498,
	70.95315296263563,70.95131282787597,70.94947515751642,70.9476399451275,70.94580718430458,
	70.94397686866749,70.94214899186072,70.94032354755305,70.93850052943753,70.93667993123141,
	70.93486174667588,70.9330459695361,70.93123259360088,70.92942161268286,70.92761302061808,
	70.92580681126606,70.92400297850959,70.92220151625465,70.92040241843033,70.91860567898861,
	70.9168112919044,70.91501925117522,70.91322955082127,70.9114421848853,70.90965714743234,
	70.90787443254976,70.90609403434712,70.904315946956,70.90254016452994,70.9007666812443,
	70.89899549129622,70.89722658890445,70.89545996830927,70.89369562377233,70.89193354957663,
	70.89017374002641,70.88841618944694,70.88666089218454,70.88490784260641,70.88315703510052,
	70.88140846407562,70.87966212396097,70.87791800920633,70.8761761142819,70.87443643367816,
	70.87269896190577,70.8709636934955,70.86923062299813,70.86749974498434,70.86577105404464,
	70.86404454478922,70.86232021184792,70.86059804987008,70.85887805352449,70.85716021749933,
	70.85544453650192,70.85373100525884,70.85201961851565,70.85031037103697,70.84860325760621,
	70.84689827302566,70.84519541211625,70.84349466971757,70.84179604068773,70.84009951990322,
	70.83840510225897,70.83671278266814,70.83502255606206,70.83333441739015,70.83164836161988,
	70.82996438373658,70.82828247874349,70.82660264166157,70.82492486752942,70.8232491514033,
	70.82157548835694,70.81990387348152,70.8182343018855,70.81656676869468,70.81490126905204,
	70.8132377981176,70.81157635106848,70.80991692309868,70.80825950941913,70.8066041052575,
	70.80495070585823,70.8032993064823,70.80164990240733,70.80000248892742,70.798357061353,
	70.79671361501093,70.79507214524426,70.79343264741225,70.79179511689023,70.79015954906963,
	70.78852593935773,70.78689428317784,70.78526457596898,70.78363681318592,70.78201099029918,
	70.78038710279479,70.77876514617431,70.77714511595484,70.77552700766879,70.77391081686392,
	70.77229653910325,70.77068416996495,70.76907370504232,70.76746513994371,70.7658584702924,
	70.7642536917267,70.76265079989957,70.76104979047892,70.7594506591473,70.75785340160188,
	70.75625801355443,70.75466449073124,70.75307282887307,70.751483023735,70.74989507108646,
	70.74830896671116,70.74672470640695,70.74514228598588,70.74356170127399,70.74198294811137,
	70.74040602235202,70.7388309198639,70.73725763652867,70.73568616824184,70.73411651091257,
	70.73254866046366,70.73098261283154,70.72941836396608,70.72785590983067,70.72629524640203,
	70.72473636967032,70.72317927563888,70.72162396032437,70.72007041975652,70.71851864997825,
	70.71696864704546,70.71542040702712,70.71387392600506,70.7123292000741,70.71078622534174,
	70.70924499792835,70.70770551396703,70.70616776960348,70.70463176099604,70.7030974843156,
	70.70156493574552,70.70003411148164,70.69850500773218,70.69697762071766,70.69545194667096,
	70.69392798183709,70.69240572247331,70.69088516484904,70.68936630524568,70.6878491399567,
	70.68633366528753,70.68481987755558,70.68330777309002,70.68179734823194,70.68028859933416,
	70.67878152276117,70.67727611488924,70.67577237210618,70.67427029081135,70.67276986741572,
	70.67127109834168,70.66977398002301,70.66827850890493,70.666784681444,70.665292494108,
	70.66380194337594,70.66231302573809,70.66082573769579,70.6593400757615,70.65785603645878,
	70.65637361632206,70.65489281189683,70.6534136197395,70.65193603641725,70.65046005850816,
	70.64898568260104,70.64751290529547,70.64604172320166,70.64457213294052,70.64310413114347,
	70.64163771445257,70.64017287952036,70.6387096230098,70.63724794159434,70.63578783195778,
	70.63432929079424,70.63287231480813,70.63141690071413,70.62996304523197,70.62851074510719,
	70.62705999707964,70.62561079790456,70.62416314434728,70.6227170331831,70.62127246119726,
	70.61982942518496,70.61838792195125,70.61694794831106,70.61550950108908,70.61407257711977,
	70.6126371732473,70.61120328632555,70.609770913218,70.60834005079778,70.60691069594755,
	70.60548284555951,70.60405649653534,70.60263164578615,70.60120829023248,70.59978642680429,
	70.59836605244074,70.59694716409044,70.59552975871117,70.59411383326994,70.59269938474299,
	70.59128641011566,70.58987490638243,70.58846487054684,70.5870562996215,70.58564919062796,
	70.58424354059682,70.58283934656755,70.58143660558852,70.58003531471705,70.57863547101915,
	70.57723707156971,70.57584011345237,70.57444459375945,70.57305050959201,70.57165785805974,
	70.57026663628089,70.56887684138242,70.56748847049977,70.56610152077687,70.56471598936618,
	70.56333187342858,70.56194917013342,70.56056787665838,70.55918799018951,70.5578095079212,
	70.5564324270561,70.55505674480511,70.55368245838739,70.55230956503024,70.55093806196918,
	70.54956794644778,70.54819921571779,70.54683186703896,70.54546589767911,70.54410130491404,
	70.54273808602748,70.54137623831123,70.54001575906486,70.5386566455959,70.5372988952197,
	70.53594250525943,70.53458747304602,70.5332337959182,70.53188147122248,70.53053049631293,
	70.52918086855139,70.52783258530731,70.52648564395773,70.52514004188734,70.52379577648831,
	70.52245284516036,70.52111124531073,70.51977097435409,70.51843202971256,70.51709440881564,
	70.51575810910032,70.51442312801076,70.51308946299865,70.51175711152283,70.51042607104947,
	70.50909633905196,70.50776791301095,70.50644079041422,70.50511496875674,70.50379044554064,
	70.50246721827507,70.50114528447638,70.4998246416679,70.49850528738,70.49718721915004,
	70.49587043452236,70.4945549310483,70.49324070628604,70.49192775780071,70.49061608316431,
	70.48930567995568,70.48799654576042,70.48668867817106,70.48538207478677,70.48407673321351,
	70.48277265106398,70.48146982595756,70.48016825552028,70.47886793738485,70.47756886919056,
	70.47627104858331,70.47497447321564,70.47367914074653,70.4723850488415,70.47109219517267,
	70.46980057741852,70.46851019326404,70.46722104040062,70.46593311652607,70.46464641934459,
	70.46336094656672
	}}
};
table1d_imp<2001> tubetable2_12AU7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	21570.200094980897,21562.163047252146,21554.136263445507,21546.119738380567,21538.113466881106,
	21530.117443776347,21522.131663899538,21514.156122088676,21506.1908131849,21498.23573203492,
	21490.290873488928,21482.356232401493,21474.431803632167,21466.51758204247,21458.6135624988,
	21450.719739872973,21442.836109038642,21434.962664874216,21427.099402261334,21419.24631608571,
	21411.40340123677,21403.570652607268,21395.748065093092,21387.935633594116,21380.13335301324,
	21372.341218257425,21364.55922423506,21356.787365860182,21349.025638047337,21341.274035716535,
	21333.532553789377,21325.80118719044,21318.079930847725,21310.36877969174,21302.667728655473,
	21294.976772674385,21287.295906688498,21279.625125637445,21271.964424465696,21264.313798118714,
	21256.67324154486,21249.042749695232,21241.4223175225,21233.81193998071,21226.211612028143,
	21218.62132862387,21211.041084728036,21203.470875304592,21195.910695317812,21188.36053973434,
	21180.820403522503,21173.290281652382,21165.770169094703,21158.26006082339,21150.75995181202,
	21143.269837037016,21135.789711474372,21128.3195701031,21120.859407902386,21113.409219852303,
	21105.969000935205,21098.538746132337,21091.11845042783,21083.70810880532,21076.307716250107,
	21068.917267746794,21061.53675828225,21054.166182842622,21046.80553641497,21039.454813986988,
	21032.11401054573,21024.78312107973,21017.462140576994,21010.151064025627,21002.849886413667,
	20995.55860272942,20988.277207961026,20981.00569709563,20973.74406512206,20966.49230702634,
	20959.250417795512,20952.018392416005,20944.796225873513,20937.583913152583,20930.381449238426,
	20923.188829114064,20916.006047762006,20908.833100163767,20901.669981300496,20894.51668615159,
	20887.373209695015,20880.239546908706,20873.115692767875,20866.001642247338,20858.897390319366,
	20851.802931955357,20844.718262125487,20837.64337579762,20830.57826793767,20823.522933509455,
	20816.47736747635,20809.441564798115,20802.415520432605,20795.399229335722,20788.392686461888,
	20781.395886761966,20774.40882518476,20767.43149667634,20760.463896181453,20753.50601864007,
	20746.557858991204,20739.61941216961,20732.69067310873,20725.77163673734,20718.862297981806,
	20711.962651765716,20705.072693009297,20698.19241662849,20691.321817536667,20684.46089064383,
	20677.60963085566,20670.768033074844,20663.936092199572,20657.11380312519,20650.301160741994,
	20643.498159937215,20636.704795593178,20629.92106258848,20623.14695579708,20616.382470089357,
	20609.62760032993,20602.88234138027,20596.14668809625,20589.42063532911,20582.704177926014,
	20575.997310728035,20569.30002857267,20562.61232629092,20555.934198709638,20549.265640649366,
	20542.606646927128,20535.95721235254,20529.31733173103,20522.686999861035,20516.066211536796,
	20509.454961545853,20502.853244670565,20496.261055686296,20489.67838936229,20483.105240463556,
	20476.54160374609,20469.98747396177,20463.442845855097,20456.90771416319,20450.38207361836,
	20443.865918944473,20437.359244860174,20430.862046075596,20424.37431729439,20417.896053213837,
	20411.42724852323,20404.96789790474,20398.51799603313,20392.077537575584,20385.646517191748,
	20379.224929533375,20372.812769245127,20366.410030962747,20360.01670931502,20353.632798921917,
	20347.25829439524,20340.89319033909,20334.537481348238,20328.19116200984,20321.85422690233,
	20315.526670594547,20309.208487647975,20302.899672614156,20296.600220035587,20290.310124447045,
	20284.029380372132,20277.757982326246,20271.495924815656,20265.243202336205,20258.99980937546,
	20252.76574040985,20246.540989906294,20240.325552322574,20234.11942210609,20227.92259369393,
	20221.735061512354,20215.556819978974,20209.387863499385,20203.228186468983,20197.07778327283,
	20190.93664828534,20184.804775869692,20178.682160378186,20172.56879615177,20166.464677520777,
	20160.369798804142,20154.284154308745,20148.207738330635,20142.14054515412,20136.08256905137,
	20130.033804283317,20123.994245098147,20117.96388573291,20111.94272041177,20105.930743347097,
	20099.927948738576,20093.934330772972,20087.94988362536,20081.974601457503,20076.008478418506,
	20070.051508644206,20064.10368625808,20058.165005369094,20052.235460074975,20046.31504445757,
	20040.403752587405,20034.501578519765,20028.6085162978,20022.72455994876,20016.849703487616,
	20010.98394091437,20005.127266215695,19999.279673362293,19993.441156312056,19987.611709007237,
	19981.791325376802,19975.97999933295,19970.17772477433,19964.384495584258,19958.600305631233,
	19952.825148767493,19947.059018830954,19941.301909642792,19935.553815010462,19929.814728723817,
	19924.084644557635,19918.363556270975,19912.651457606138,19906.948342289706,19901.25420403156,
	19895.569036525627,19889.892833448353,19884.22558846028,19878.567295205106,19872.917947308662,
	19867.277538380808,19861.646062013828,19856.023511782303,19850.409881243806,19844.80516393788,
	19839.20935338667,19833.62244309492,19828.044426548826,19822.475297216304,19816.915048548086,
	19811.36367397521,19805.82116691135,19800.28752075079,19794.762728870304,19789.246784626732,
	19783.73968135812,19778.241412383828,19772.751971003505,19767.2713504982,19761.799544128855,
	19756.336545136735,19750.882346743638,19745.436942151828,19740.00032454306,19734.572487079236,
	19729.15342290207,19723.74312513259,19718.34158687126,19712.9488011991,19707.564761174304,
	19702.189459836103,19696.822890201558,19691.465045267138,19686.115918007537,19680.775501376364,
	19675.443788305805,19670.120771705628,19664.806444465295,19659.50079945013,19654.203829505394,
	19648.91552745322,19643.635886093067,19638.36489820251,19633.1025565362,19627.84885382695,
	19622.60378278304,19617.367336090465,19612.139506412877,19606.920286389213,19601.709668636257,
	19596.507645746267,19591.314210288358,19586.12935480756,19580.953071825334,19575.78535383803,
	19570.626193318854,19565.475582716244,19560.333514453858,19555.199980931207,19550.07497452245,
	19544.95848757723,19539.850512420006,19534.751041349722,19529.660066640678,19524.577580540456,
	19519.50357527242,19514.438043033726,19509.38097599491,19504.332366301165,19499.292206071423,
	19494.260487398387,19489.237202347253,19484.222342958852,19479.215901244967,19474.217869191336,
	19469.22823875727,19464.247001874028,19459.274150446232,19454.3096763507,19449.353571436663,
	19444.405827525436,19439.466436411058,19434.53538985909,19429.612679607348,19424.698297364674,
	19419.792234811684,19414.894483601718,19410.005035356648,19405.123881672116,19400.25101411358,
	19395.386424217493,19390.530103491015,19385.682043411744,19380.842235427997,19376.010670958083,
	19371.187341390934,19366.37223808432,19361.565352367536,19356.766675538147,19351.976198863817,
	19347.193913581945,19342.41981089855,19337.65388198904,19332.896117998345,19328.146510039405,
	19323.405049194265,19318.67172651369,19313.94653301601,19309.22945968928,19304.520497488105,
	19299.819637335968,19295.126870124386,19290.442186711778,19285.765577924434,19281.097034556322,
	19276.436547368477,19271.784107088686,19267.13970441216,19262.503330000924,19257.87497448324,
	19253.25462845403,19248.64228247545,19244.03792707432,19239.44155274522,19234.85314994687,
	19230.272709105862,19225.700220611798,19221.135674822966,19216.579062060922,19212.030372612713,
	19207.489596730316,19202.956724631564,19198.43174649813,19193.91465247713,19189.405432679276,
	19184.904077180134,19180.410576019425,19175.924919201017,19171.447096693017,19166.977098426112,
	19162.51491429589,19158.060534160708,19153.61394784277,19149.175145126967,19144.744115761332,
	19140.320849457392,19135.90533588854,19131.497564691228,19127.097525464724,19122.705207769814,
	19118.32060113029,19113.943695031867,19109.574478921455,19105.212942207894,19100.8590742626,
	19096.512864417975,19092.174301966872,19087.843376164285,19083.520076226556,19079.20439132945,
	19074.896310610944,19070.595823168976,19066.302918062334,19062.017584309473,19057.73981089,
	19053.46958674244,19049.20690076636,19044.951741820365,19040.704098722832,19036.463960252047,
	19032.231315144698,19028.006152097714,19023.78845976654,19019.578226765927,19015.375441668515,
	19011.180093006904,19006.992169271172,19002.811658910803,18998.638550331994,18994.472831900668,
	18990.314491939258,18986.163518729696,18982.01990051004,18977.883625476774,18973.754681783037,
	18969.63305754037,18965.518740816417,18961.411719636828,18957.31198198309,18953.219515794164,
	18949.134308965455,18945.056349348455,18940.9856247516,18936.922122938904,18932.86583163143,
	18928.816738505164,18924.774831192437,18920.740097280705,18916.7125243143,18912.69209979115,
	18908.67881116612,18904.672645848157,18900.673591201576,18896.68163454603,18892.696763155294,
	18888.718964258303,18884.748225037558,18880.78453263136,18876.82787413124,18872.878236583227,
	18868.935606987638,18864.999972298207,18861.071319422324,18857.14963522181,18853.234906511316,
	18849.327120058948,18845.42626258671,18841.53232076856,18837.645281232908,18833.76513056005,
	18829.891855283357,18826.025441889105,18822.16587681585,18818.313146454453,18814.467237148812,
	18810.628135194136,18806.79582683847,18802.970298281198,18799.151535674184,18795.339525119995,
	18791.534252674133,18787.735704342962,18783.94386608418,18780.15872380677,18776.38026337128,
	18772.60847058895,18768.843331221702,18765.084830983178,18761.332955537215,18757.58769049834,
	18753.849021431583,18750.116933852234,18746.391413226414,18742.67244497001,18738.96001444869,
	18735.254106979348,18731.554707827916,18727.861802209733,18724.175375290753,18720.49541218588,
	18716.821897959784,18713.154817626717,18709.49415614968,18705.839898442056,18702.192029364305,
	18698.5505337279,18694.915396292326,18691.286601766195,18687.664134806564,18684.047980019124,
	18680.438121958272,18676.83454512736,18673.237233977266,18669.64617290751,18666.06134626603,
	18662.482738348575,18658.910333399297,18655.34411560968,18651.784069119705,18648.230178016656,
	18644.68242633625,18641.14079806084,18637.605277120732,18634.075847394357,18630.55249270671,
	18627.035196830093,18623.523943484415,18620.018716336646,18616.51949900106,18613.02627503834,
	18609.539027957344,18606.05774121131,18602.582398203253,18599.11298228143,18595.649476740662,
	18592.191864822635,18588.74012971534,18585.294254554006,18581.854222419617,18578.4200163391,
	18574.991619286935,18571.56901418264,18568.152183892555,18564.74111122865,18561.33577894919,
	18557.936169758847,18554.542266307417,18551.154051191425,18547.771506952424,18544.394616078313,
	18541.02336100233,18537.65772410423,18534.29768770808,18530.943234084603,18527.59434544918,
	18524.25100396387,18520.91319173507,18517.58089081515,18514.254083201577,18510.932750837477,
	18507.616875610438,18504.30643935477,18501.001423848516,18497.701810815415,18494.407581924752,
	18491.118718790516,18487.835202971364,18484.557015971423,18481.284139239946,18478.016554170976,
	18474.754242103216,18471.497184320968,18468.245362052152,18464.998756471407,18461.757348696276,
	18458.521119790206,18455.290050760883,18452.06412256127,18448.84331608823,18445.627612184297,
	18442.41699163581,18439.211435174453,18436.010923475686,18432.815437160327,18429.624956793225,
	18426.439462884468,18423.258935888174,18420.083356202744,18416.912704171526,18413.7469600825,
	18410.586104167432,18407.430116602907,18404.278977510246,18401.132666954712,18397.991164946132,
	18394.85445143843,18391.722506330632,18388.595309465247,18385.47284062977,18382.355079555648,
	18379.242005918597,18376.133599338536,18373.029839380182,18369.930705551767,18366.836177306093,
	18363.746234040435,18360.66085509548,18357.580019756806,18354.50370725412,18351.431896760336,
	18348.36456739334,18345.301698214695,18342.24326823053,18339.189256390262,18336.139641587233,
	18333.09440265928,18330.053518388544,18327.01696749944,18323.98472866205,18320.95678048861,
	18317.93310153621,18314.913670305785,18311.898465241058,18308.887464729727,18305.880647103477,
	18302.877990636727,18299.879473547884,18296.885073998677,18293.894770093833,18290.90853988142,
	18287.926361352955,18284.948212443258,18281.97407102931,18279.00391493112,18276.037721912453,
	18273.075469678548,18270.11713587794,18267.162698101256,18264.21213388202,18261.265420695872,
	18258.32253596,18255.38345703355,18252.448161218574,18249.516625757522,18246.588827834617,
	18243.664744575803,18240.744353047583,18237.827630257812,18234.91455315409,18232.00509862618,
	18229.099243502264,18226.196964552233,18223.298238483967,18220.40304194601,18217.511351525696,
	18214.623143749326,18211.738395081673,18208.857081925737,18205.979180622217,18203.104667450152,
	18200.233518624547,18197.365710297854,18194.501218558817,18191.640019432183,18188.782088877113,
	18185.927402789373,18183.075936997648,18180.227667265135,18177.38256928832,18174.54061869677,
	18171.701791051593,18168.866061845605,18166.03340650267,18163.203800376552,18160.37721875061,
	18157.55363683626,18154.733029773437,18151.91537262923,18149.100640395707,18146.288807991463,
	18143.479850258867,18140.67374196332,18137.87045779189,18135.06997235463,18132.27226017964,
	18129.477295715,18126.68505332629,18123.895507294834,18121.108631817217,18118.324401003665,
	18115.542788876406,18112.763769368605,18109.987316321538,18107.213403485224,18104.442004513876,
	18101.673092966557,18098.906642303675,18096.14262588545,18093.381016970987,18090.621788714572,
	18087.864914164435,18085.110366259665,18082.358117829164,18079.608141587614,18076.860410134123,
	18074.114895948802,18071.371571389736,18068.630408691235,18065.891379959943,18063.154457171666,
	18060.419612167974,18057.68681665386,18054.956042192694,18052.22726020389,18049.500441957458,
	18046.77555857262,18044.052581010503,18041.331480072047,18038.612226393667,18035.89479044051,
	18033.17914250325,18030.46525269421,18027.75309093925,18025.042626973962,18022.33383033926,
	18019.62667037341,18016.921116206475,18014.217136755513,18011.514700716572,18008.81377655811,
	18006.114332515106,18003.41633658036,18000.7197564977,17998.024559754438,17995.330713572595,
	17992.638184901894,17989.946940408197,17987.256946468427,17984.568169157512,17981.880574241826,
	17979.194127167524,17976.50879304929,17973.824536662225,17971.14132242847,17968.459114407153,
	17965.77787628162,17963.097571347553,17960.41816250036,17957.739612221652,17955.06188256598,
	17952.384935146885,17949.708731122362,17947.033231179117,17944.358395518862,17941.68418384073,
	17939.010555325603,17936.337468618487,17933.66488181257,17930.992752429083,17928.32103740061,
	17925.649693050036,17922.97867507346,17920.30793851744,17917.637437759142,17914.967126485062,
	17912.29695766858,17909.62688354872,17906.956855603756,17904.286824531573,17901.616740221714,
	17898.946551732173,17896.27620726415,17893.605654133444,17890.934838746896,17888.263706572627,
	17885.592202112384,17882.92026887532,17880.247849345313,17877.57488495473,17874.901316052197,
	17872.227081873567,17869.55212051009,17866.87636887742,17864.19976268483,17861.522236401597,
	17858.84372322618,17856.164155053797,17853.483462443353,17850.801574585254,17848.118419268434,
	17845.433922849716,17842.748010219108,17840.060604770682,17837.371628369045,17834.68100131931,
	17831.98864233868,17829.294468523713,17826.59839532601,17823.900336523177,17821.200204192497,
	17818.497908689333,17815.793358623858,17813.086460839746,17810.37712039842,17807.665240562095,
	17804.950722783204,17802.233466693724,17799.513370098924,17796.790328978754,17794.064237485316,
	17791.334987954033,17788.60247091323,17785.86657510118,17783.127187490958,17780.384193318678,
	17777.63747611883,17774.88691777062,17772.132398546026,17769.373797171975,17766.6109908984,
	17763.843855576688,17761.072265747538,17758.296094741152,17755.5152147873,17752.729497138724,
	17749.938812205397,17747.143029704752,17744.342018822917,17741.535648394034,17738.723787089955,
	17735.90630363308,17733.08306701705,17730.253946752488,17727.418813124452,17724.577537472458,
	17721.729992485085,17718.876052518026,17716.015593927237,17713.14849542515,17710.27463845434,
	17707.393907583875,17704.50619092204,17701.611380553375,17698.709372991434,17695.800069653425,
	17692.883377352548,17689.95920880916,17687.02748317982,17684.088126601702,17681.14107275279,
	17678.186263426178,17675.223649118783,17672.253189626314,17669.27485465147,17666.288624418466,
	17663.294490287615,17660.292455379444,17657.28253519057,17654.264758209112,17651.23916652803,
	17648.205816436577,17645.16477901194,17642.116140683625,17639.060003782597,17635.996487064196,
	17632.925726203222,17629.847874255174,17626.763102084853,17623.671598749606,17620.57357184476,
	17617.46924779638,17614.358872104247,17611.242709531998,17608.121044234194,17604.994179828955,
	17601.862439398068,17598.72616542978,17595.585719683426,17592.441482992625,17589.293854989217,
	17586.143253758666,17582.990115420707,17579.834893637657,17576.678059048067,17573.520098632696,
	17570.36151500493,17567.202825637814,17564.04456202278,17560.887268767758,17557.731502634248,
	17554.577831520204,17551.42683339582,17548.279095183927,17545.135211611887,17541.995784019597,
	17538.861419139703,17535.73272785609,17532.610323942954,17529.494822792414,17526.386840138955,
	17523.28699078125,17520.195887314105,17517.114138872505,17514.042349895954,17510.981118914868,
	17507.931037371058,17504.892688470318,17501.86664607819,17498.853473659903,17495.853723265103,
	17492.867934575417,17489.89663399364,17486.94033380634,17483.999531395395,17481.074708522283,
	17478.16633066796,17475.27484644644,17472.400687076395,17469.544265927732,17466.705978125,
	17463.886200223274,17461.08528994553,17458.303585979644,17455.541407843197,17452.79905580412,
	17450.076810856495,17447.374934755167,17444.69367010051,17442.033240471665,17439.393850610308,
	17436.775686641515,17434.178916343037,17431.603689444797,17429.050137969254,17426.518376597924,
	17424.008503068097,17421.520598596187,17419.05472832272,17416.610941775518,17414.18927334919,
	17411.789742800098,17409.412355753942,17407.057104217558,17404.72396710346,17402.412910750205,
	17400.12388945717,17397.856846006645,17395.611712194586,17393.388409351846,17391.186848864163,
	17389.006932686996,17386.84855384718,17384.711596944646,17382.59593863754,17380.5014481236,
	17378.42798760245,17376.37541273453,17374.343573080954,17372.332312535233,17370.341469742376,
	17368.370878496804,17366.420368136245,17364.489763917896,17362.57888737895,17360.6875566856,
	17358.815586965506,17356.962790631846,17355.128977686418,17353.313956015278,17351.51753166671,
	17349.73950912071,17347.979691539105,17346.237881009092,17344.513878773938,17342.807485443234,
	17341.118501209126,17339.446726029437,17337.79195981691,17336.154002610834,17334.532654738257,
	17332.92771696687,17331.33899064786,17329.7662778508,17328.209381485627,17326.66810542245,
	17325.14225459776,17323.631635117952,17322.136054345916,17320.65532099683,17319.189245211113,
	17317.73763862685,17316.300314453158,17314.877087523,17313.467774356315,17312.072193205873,
	17310.690164103446,17309.321508901154,17307.966051308736,17306.62361692244,17305.29403325792,
	17303.977129767532,17302.672737870293,17301.380690960676,17300.100824428788,17298.83297566927,
	17297.576984089526,17296.332691118536,17295.099940206695,17293.878576832274,17292.668448494205,
	17291.469404716485,17290.281297034995,17289.103979004223,17287.937306173983,17286.781136093417,
	17285.635328293298,17284.49974427623,17283.37424750253,17282.25870337847,17281.152979239057,
	17280.056944334847,17278.970469810058,17277.89342869288,17276.82569587065,17275.76714807382,
	17274.71766385851,17273.677123581972,17272.645409390476,17271.622405189817,17270.607996629362,
	17269.602071083085,17268.60451762275,17267.615227003007,17266.634091630825,17265.66100555459,
	17264.695864434165,17263.73856552004,17262.789007638345,17261.84709115782,17260.91271797887,
	17259.98579150184,17259.066216613912,17258.153899661367,17257.248748431775,17256.350672128745,
	17255.459581353563,17254.575388084697,17253.69800565394,17252.827348726343,17251.963333281863,
	17251.10587658801,17250.25489719051,17249.410314882574,17248.572050692957,17247.74002686177,
	17246.91416681711,17246.09439516923,17245.280637679916,17244.472821241525,17243.670873870407,
	17242.874724680307,17242.084303864183,17241.299542680725,17240.520373431722,17239.74672945097,
	17238.978545078215,17238.215755652527,17237.458297489822,17236.70610786691,17235.959125003643,
	17235.217288055363,17234.480537085183,17233.748813062186,17233.022057830873,17232.300214110845,
	17231.583225473027,17230.8710363314,17230.163591919623,17229.460838289924,17228.762722287538,
	17228.069191545383,17227.380194463163,17226.69568020776,17226.015598682832,17225.339900529678,
	17224.668537109992,17224.00146049137,17223.338623439955,17222.679979409775,17222.025482521087,
	17221.37508756264,17220.728749970804,17220.086425822632,17219.448071826977,17218.81364530493,
	17218.18310419282,17217.556407021504,17216.933512911983,17216.314381561682,17215.698973238173,
	17215.08724876214,17214.479169519338,17213.874697419375,17213.27379491268,17212.676424974394,
	17212.082551085983,17211.4921372405,17210.90514793047,17210.321548130352,17209.741303302373,
	17209.164379381054,17208.590742763303,17208.020360308456,17207.453199321466,17206.88922755313,
	17206.32841319305,17205.770724854334,17205.216131574325,17204.664602806944,17204.116108412298,
	17203.57061865367,17203.028104189136,17202.48853606277,17201.95188570874,17201.418124929383,
	17200.88722590378,17200.35916117014,17199.83390363406,17199.31142654733,17198.791703507002,
	17198.27470845977,17197.760415687102,17197.24879979419,17196.739835724547,17196.233498731217,
	17195.72976439421,17195.228608594207,17194.73000752617,17194.2339376814,17193.74037584928,
	17193.24929911392,17192.76068484467,17192.274510693645,17191.79075459542,17191.309394754026,
	17190.830409646736,17190.35377802204,17189.87947887874,17189.407491484282,17188.937795356658,
	17188.470370265848,17188.00519622398,17187.542253493084,17187.081522570123,17186.622984190108,
	17186.166619316282,17185.712409145093,17185.26033509591,17184.810378812173,17184.36252215495,
	17183.91674719741,17183.47303623247,17183.0313717579,17182.59173647512,17182.154113291872,
	17181.71848531931,17181.284835857914,17180.853148408187,17180.42340666118,17179.995594496137,
	17179.569695977778,17179.145695359475,17178.723577065433,17178.303325707402,17177.884926067298,
	17177.46836310046,17177.05362193779,17176.64068787437,17176.229546370065,17175.820183050473,
	17175.412583700403,17175.00673427105,17174.60262085777,17174.20022971992,17173.799547271123,
	17173.400560063736,17173.003254810752,17172.60761836014,17172.21363771687,17171.821300016938,
	17171.430592542336,17171.041502710046,17170.654018075744,17170.268126332427,17169.88381529848,
	17169.501072924882,17169.11988730195,17168.740246633963,17168.362139255925,17167.98555363013,
	17167.610478335664,17167.236902080796,17166.86481368174,17166.49420207663,17166.125056328226,
	17165.757365598398,17165.391119172076,17165.026306447056,17164.662916923244,17164.300940215697,
	17163.94036604183,17163.5811842287,17163.223384702647,17162.866957501592,17162.511892757553,
	17162.15818070452,17161.80581167607,17161.454776109764,17161.105064521085,17160.756667544712,
	17160.40957589667,17160.063780384717,17159.7192719123,17159.376041469033,17159.034080140944,
	17158.693379097043,17158.35392959818,17158.015722981625,17157.67875067909,17157.343004207127,
	17157.008475156013,17156.67515520641,17156.343036112423,17156.012109714546,17155.68236793222,
	17155.353802759753,17155.02640626766,17154.70017060301,17154.37508799076,17154.05115072563,
	17153.728351183272,17153.40668180244,17153.086135096906,17152.766703653957,17152.448380129805,
	17152.131157246444,17151.815027791938,17151.499984632323,17151.18602069137,17150.87312896112,
	17150.561302493643,17150.250534416507,17149.9408179071,17149.63214622104,17149.324512661544,
	17149.017910595056,17148.712333460826,17148.407774740772,17148.104227992495,17147.801686816856,
	17147.500144883896,17147.199595913036,17146.90003368883,17146.601452040668,17146.303844862658,
	17146.00720609964,17145.711529746284,17145.416809854527,17145.123040534272,17144.830215937844,
	17144.538330272077,17144.247377798834,17143.957352827932,17143.668249714512,17143.380062872766,
	17143.09278674945,17142.80641586311,17142.5209447567,17142.23636803154,17141.95268033899,
	17141.669876362055,17141.387950845816,17141.106898567432,17140.826714360723,17140.54739309414,
	17140.26892967934,17139.991319077493,17139.71455628942,17139.438636353472,17139.163554359206,
	17138.889305430956,17138.61588473357,17138.343287475796,17138.07150890151,17137.80054429717,
	17137.530388989617,17137.26103834077,17136.992487757856,17136.724732673625,17136.457768569977,
	17136.191590959545,17135.926195394222,17135.661577459345,17135.397732780075,17135.134657016308,
	17134.872345861957,17134.610795043067,17134.350000325405,17134.089957502943,17133.830662408545,
	17133.572110906785,17133.314298891295,17133.05722229623,17132.800877083428,17132.54525924584,
	17132.290364808872,17132.036189831666,17131.782730402396,17131.529982636275,17131.277942690125,
	17131.026606734667,17130.77597098923,17130.52603168079,17130.276785087364,17130.028227500163,
	17129.780355248306,17129.53316468534,17129.286652193307,17129.040814177224,17128.795647081613,
	17128.55114736456,17128.307311525798,17128.06413607316,17127.82161755983,17127.579752550806,
	17127.338537645493,17127.097969472237,17126.858044664696,17126.618759909325,17126.380111896746,
	17126.14209734807,17125.90471301848,17125.667955666442,17125.431822103183,17125.196309139505,
	17124.961413617846,17124.727132400727,17124.49346237965,17124.260400473162,17124.027943609217,
	17123.796088742914,17123.56483285084,17123.334172945062,17123.104106037023,17122.874629177786,
	17122.64573943032,17122.41743388814,17122.18970964544,17121.962563845813,17121.735993624377,
	17121.50999616042,17121.284568646355,17121.059708283206,17120.83541230635,17120.611677964753,
	17120.38850252409,17120.165883278674,17119.943817527062,17119.722302603925,17119.501335850655,
	17119.280914634466,17119.061036329418,17118.841698345954,17118.622898093545,17118.404633016205,
	17118.186900564953,17117.96969820967,17117.75302344276,17117.53687376564,17117.32124671408,
	17117.10613981974,17116.891550636756,17116.67747674866,17116.46391573591,17116.25086521658,
	17116.038322806005,17115.826286150717,17115.614752901834,17115.40372073155,17115.193187328434,
	17114.98315039149,17114.77360764396,17114.564556817015,17114.355995659316,17114.147921931126,
	17113.940333414255,17113.733227903376,17113.526603208193,17113.32045714006,17113.114787550014,
	17112.909592278094,17112.70486919332,17112.5006161804,17112.296831122814,17112.093511932795,
	17111.890656532265,17111.68826284957,17111.486328839088,17111.28485245518,17111.08383167772,
	17110.883264486514,17110.68314888883,17110.483482894742,17110.2842645323,17110.085491832324,
	17109.88716285926,17109.689275663055,17109.49182833253,17109.294818934202,17109.098245595073,
	17108.902106412945,17108.706399503335,17108.51112302057,17108.316275106474,17108.12185391207,
	17107.927857615294,17107.734284399437,17107.541132453764,17107.348399988696,17107.156085220515,
	17106.96418637079,17106.772701679318,17106.5816293964,17106.390967786676,17106.200715114996,
	17106.01086966377,17105.821429723648,17105.6323936002,17105.44375960375,17105.255526067554,
	17105.067691310418,17104.88025368841,17104.69321154277,17104.50656324969,17104.3203071679,
	17104.134441692928,17103.948965217012,17103.763876138582,17103.57917287445,17103.39485384206,
	17103.210917473458,17103.027362216202,17102.84418650904,17102.66138882036,17102.47896761124,
	17102.296921371053,17102.115248576185,17101.933947724825,17101.753017331965,17101.57245588082,
	17101.392261921897,17101.212433983004,17101.032970591237,17100.853870301118,17100.675131676497,
	17100.496753266594,17100.318733657794,17100.141071423262,17099.96376515461,17099.786813452698,
	17099.61021491856,17099.43396817044,17099.25807182843,17099.08252452593,17098.90732489542,
	17098.732471581035,17098.557963242714,17098.383798542385,17098.209976139744,17098.03649470873,
	17097.86335294854,17097.69054953524,17097.518083179373,17097.345952580326,17097.174156448953,
	17097.002693510392,17096.831562494022,17096.660762131854,17096.49029115333,17096.32014832866,
	17096.15033239419,17095.98084213179,17095.81167629904,17095.642833671158,17095.474313045564,
	17095.306113191815,17095.138232917696,17094.97067103238,17094.803426331575,17094.636497642812,
	17094.46988378021,17094.303583587087,17094.137595881526,17093.97191951872,17093.80655334217,
	17093.641496204957,17093.476746969107,17093.312304505565,17093.148167681244,17092.984335377485,
	17092.8208064918,17092.65757989259,17092.494654490267,17092.332029193512,17092.169702898074,
	17092.007674527555,17091.845943000728,17091.68450724255,17091.523366187805,17091.362518771602,
	17091.20196394444,17091.04170064551,17090.881727831817,17090.722044462065,17090.562649511332,
	17090.40354194912,17090.244720741313,17090.08618487409,17089.927933337625,17089.76996512396,
	17089.612279230154,17089.45487466091,17089.29775041695,17089.140905520708,17088.984338985894,
	17088.82804983663,17088.672037100132,17088.516299809024,17088.360837009808,17088.205647735962,
	17088.050731044972,17087.896085982487,17087.74171160605,17087.58760698792,17087.433771181295,
	17087.2802032762,17087.126902333992,17086.973867447763,17086.82109769849,17086.66859217437,
	17086.51634997597,17086.36437020544,17086.212651956488,17086.061194354854,17085.909996504648,
	17085.759057515774,17085.60837653151,17085.45795266508,17085.30778504866,17085.157872823118,
	17085.008215114118,17084.85881108618,17084.709659873737,17084.56076064098,17084.41211252852,
	17084.26371471291,17084.11556634684,17083.967666611235,17083.82001467872,17083.672609712794,
	17083.52545090769,17083.378537443714,17083.231868512346,17083.08544331212,17082.93926103175,
	17082.793320879384,17082.647622048204,17082.50216375959,17082.356945222087,17082.211965652128,
	17082.067224266983,17081.922720301725,17081.778452970055,17081.63442150926,17081.490625159004,
	17081.347063155914,17081.203734738385,17081.060639151405,17080.917775651487,17080.77514348767,
	17080.63274192681,17080.49057020688,17080.34862761795,17080.206913406688,17080.06542685378,
	17079.92416723294,17079.783133813504,17079.642325896584,17079.501742752418,17079.36138365786,
	17079.221247927668,17079.081334839826,17078.9416437026,17078.80217380627,17078.662924466305,
	17078.523894975693,17078.385084658006,17078.246492824255,17078.108118790395,17077.969961878774,
	17077.83202140259,17077.69429670541,17077.55678710796,17077.41949193771,17077.282410534222,
	17077.14554224015,17077.00888639489,17076.872442342763,17076.736209425653,17076.600187016145,
	17076.464374437004,17076.328771065797,17076.193376254454,17076.058189374733,17075.923209773136,
	17075.78843683143,17075.65386993242,17075.519508424153,17075.385351703153,17075.25139913035,
	17075.117650103297,17074.98410399905,17074.850760215344,17074.717618134153,17074.584677149243,
	17074.45193665872,17074.31939606687,17074.18705476458,17074.054912163392,17073.922967656665,
	17073.79122067336,17073.659670605,17073.528316883087,17073.397158919426,17073.26619613409,
	17073.135427940193,17073.004853769522,17072.874473055515,17072.744285219414,17072.614289695306,
	17072.484485913646,17072.354873316388,17072.225451339116,17072.096219437604,17071.967177037266,
	17071.838323597287,17071.709658560518,17071.58118137528,17071.452891512738,17071.324788414866,
	17071.196871540957,17071.06914035106,17070.941594313183,17070.814232887617,17070.68705555574,
	17070.560061767144,17070.43325100377,17070.30662274432,17070.180176460683,17070.053911637162,
	17069.92782774754,17069.80192427625,17069.676200715763,17069.55065654606,17069.425291266798,
	17069.30010435863,17069.175095327882,17069.050263656787,17068.92560886134,17068.80113042067,
	17068.676827849835,17068.552700654993,17068.428748346527,17068.304970419693,17068.181366396264,
	17068.057935787576,17067.934678107296,17067.811592867907,17067.688679603216,17067.565937819505,
	17067.443367034848,17067.320966790456,17067.198736599606,17067.076676013163,17066.95478452981,
	17066.833061709,17066.711507073607,17066.59012016099,17066.46890050042,17066.34784765723,
	17066.226961153992,17066.10624053849,17065.985685356573,17065.865295151776,17065.745069482855,
	17065.625007904528,17065.505109955495,17065.385375189027,17065.265803183393,17065.146393480896,
	17065.027145639644,17064.908059239508,17064.789133821792,17064.670368967356,17064.551764237443,
	17064.43331919706,17064.315033428666,17064.19690650445,17064.078937984563,17063.961127453727,
	17063.843474483776,17063.725978667186,17063.608639570328,17063.491456788393,17063.37442990009,
	17063.257558489622,17063.140842144625,17063.02428046003,17062.90787301849,17062.79161941035,
	17062.675519248292,17062.559572104103,17062.443777586548,17062.328135298914,17062.212644830004,
	17062.097305787564,17061.98211778238,17061.867080406217,17061.752193266544,17061.637455987522,
	17061.522868158816,17061.408429400763,17061.294139326423,17061.179997555988,17061.066003683143,
	17060.952157356227,17060.838458160775,17060.724905733143,17060.61149970649,17060.49823969002,
	17060.385125303874,17060.272156177096,17060.15933193743,17060.04665221721,17059.934116650522,
	17059.821724862868,17059.70947648022,17059.597371148346,17059.48540848968,17059.37358814876,
	17059.261909777444,17059.150372996843,17059.038977444994,17058.927722777124,17058.81660864258,
	17058.705634660833,17058.594800507955,17058.48410581178,17058.37355023142,17058.263133399414,
	17058.152854990574,17058.042714652864,17057.93271202381,17057.82284677784,17057.71311857105,
	17057.60352704305,17057.494071878675,17057.384752719812,17057.27556923386,17057.16652108856,
	17057.05760793969,17056.94882946156,17056.840185308112,17056.73167516859,17056.623298691167,
	17056.515055554883,17056.406945426897,17056.29896799449,17056.191122918255,17056.083409867664,
	17055.975828545743,17055.86837860887,17055.761059737022,17055.65387162093,17055.54681392073,
	17055.439886337146,17055.333088557985,17055.226420245075,17055.119881103972,17055.013470810776,
	17054.90718906857,17054.801035546654,17054.695009953783,17054.589111955593,17054.483341266827,
	17054.377697580057,17054.272180592634,17054.166789986702,17054.06152545716,17053.95638672511,
	17053.851373464946,17053.74648538329,17053.64172218421,17053.537083577252,17053.432569258246,
	17053.32817894108,17053.223912294212,17053.119769074376,17053.015748958835,17052.911851660156,
	17052.808076898025,17052.70442437594,17052.60089381022,17052.497484897613,17052.394197371512,
	17052.291030937224,17052.187985304747,17052.085060200796,17051.982255338662,17051.87957043027,
	17051.777005210028,17051.67455939847,17051.572232690072,17051.470024839353,17051.36793555134,
	17051.265964555118,17051.164111584436,17051.062376350743,17050.960758587837,17050.859258024877,
	17050.757874394236,17050.656607416804,17050.55545683494,17050.454422374172,17050.353503763916,
	17050.252700734993,17050.152013037976,17050.05144039898,17049.950982548413,17049.85063923127,
	17049.750410177785,17049.65029513763,17049.550293855642,17049.450406053445,17049.3506314795,
	17049.25096989041,17049.15142100055,17049.051984584985,17048.952660381463,17048.853448128568,
	17048.754347569426,17048.655358465498,17048.556480549618,17048.45771357705,17048.359057317804,
	17048.260511492128,17048.162075871896,17048.06375019863,17047.965534227464,17047.867427724213,
	17047.769430434353,17047.671542123193,17047.573762532244,17047.476091432112,17047.37852857297,
	17047.28107371857,17047.183726631716,17047.08648706909,17046.98935479108,17046.89232956939,
	17046.795411149404,17046.69859931306,17046.601893810814,17046.505294430426,17046.408800911515,
	17046.31241303472,17046.21613057205,17046.11995328703,17046.023880934015,17045.927913317264,
	17045.832050181147,17045.73629129941,17045.64063645892,17045.545085415215,17045.449637944534,
	17045.354293841912,17045.259052853886,17045.163914790657,17045.06887939266,17044.973946460104,
	17044.879115767464,17044.784387082025,17044.689760199028,17044.595234892164,17044.500810940608,
	17044.40648813362,17044.312266246954,17044.218145050476,17044.124124363017,17044.03020394112,
	17043.936383580814,17043.842663059895,17043.749042188283,17043.655520707955,17043.562098447823,
	17043.468775176054,17043.375550704008,17043.282424793688,17043.18939725161,17043.096467876006,
	17043.003636443813,17042.910902748703,17042.81826658766,17042.725727761554,17042.633286050317,
	17042.5409412489,17042.44869316906,17042.356541609537,17042.26448635443,17042.172527205446,
	17042.08066395805,17041.988896416202,17041.89722436556,17041.80564764096,17041.71416600346,
	17041.622779277914,17041.531487250235,17041.440289743663,17041.34918655232,17041.258177475353,
	17041.167262306863,17041.076440887373,17040.98571300093,17040.89507844461,17040.804537037293,
	17040.714088592656,17040.623732906173,17040.53346979153,17040.4432990533,17040.353220505098,
	17040.26323396823,17040.173339243713,17040.08353613846,17039.99382446534,17039.904204055216,
	17039.81467469361,17039.72523622402,17039.635888441902,17039.546631161145,17039.457464202864,
	17039.36838738696,17039.279400536314,17039.19050344266,17039.101695952697,17039.012977859977,
	17038.924349007724,17038.835809197197,17038.74735825444,17038.6589960041,17038.57072226597,
	17038.48253685136,17038.39443959003,17038.30643029947,17038.218508829046,17038.13067497228,
	17038.04292857303,17037.95526943956,17037.867697405363,17037.780212295944,17037.69281393504,
	17037.60550214535,17037.518276777442,17037.431137646563,17037.344084560482,17037.25711737374,
	17037.170235907168,17037.083439998216,17036.996729463117,17036.91010413551,17036.823563867096,
	17036.737108466496,17036.65073777264,17036.56445162776,17036.478249849326,17036.39213229365,
	17036.306098766974,17036.220149123215,17036.13428319772,17036.048500820994,17035.962801828475,
	17035.87718606466
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	21570.200094980897,21562.163047252146,21554.136263445598,21546.119738380487,21538.113466881023,
	21530.117443776347,21522.131663899876,21514.156122088676,21506.190813184723,21498.23573203492,
	21490.29087348902,21482.356232401493,21474.431803632164,21466.517582042037,21458.613562498802,
	21450.719739873068,21442.836109038733,21434.962664874216,21427.099402261334,21419.24631608562,
	21411.40340123677,21403.570652607268,21395.748065093092,21387.935633594294,21380.133353013152,
	21372.341218257337,21364.559224234894,21356.787365860007,21349.025638047337,21341.274035716535,
	21333.53255378928,21325.80118719044,21318.079930847885,21310.368779691733,21302.667728655204,
	21294.97677267455,21287.295906688483,21279.625125637445,21271.964424465696,21264.313798118714,
	21256.67324154486,21249.042749695218,21241.422317522327,21233.81193998079,21226.211612028135,
	21218.62132862387,21211.041084728124,21203.470875304683,21195.910695317856,21188.360539734334,
	21180.820403522685,21173.290281652382,21165.770169094973,21158.260060823315,21150.759951812113,
	21143.26983703709,21135.789711474205,21128.31957010319,21120.859407902462,21113.409219852358,
	21105.969000935198,21098.538746132428,21091.118450427824,21083.708108805477,21076.307716249932,
	21068.917267746867,21061.536758282233,21054.16618284252,21046.80553641498,21039.454813986566,
	21032.114010545778,21024.783121079803,21017.462140576965,21010.15106402561,21002.849886413886,
	20995.55860272948,20988.27720796108,20981.005697096018,20973.74406512202,20966.492307026267,
	20959.25041779546,20952.018392416056,20944.79622587339,20937.58391315289,20930.381449238335,
	20923.188829113948,20916.006047761763,20908.83310016357,20901.669981300136,20894.516686151484,
	20887.373209695088,20880.239546908695,20873.115692768097,20866.001642247385,20858.897390319264,
	20851.80293195539,20844.718262125614,20837.643375797572,20830.578267937544,20823.522933509696,
	20816.477367476244,20809.441564797893,20802.415520432478,20795.399229335995,20788.39268646196,
	20781.395886761984,20774.408825184524,20767.431496676814,20760.463896181387,20753.506018639928,
	20746.557858991087,20739.61941216968,20732.690673108547,20725.77163673726,20718.86229798189,
	20711.96265176585,20705.07269300914,20698.19241662837,20691.321817536787,20684.460890643655,
	20677.609630855535,20670.76803307463,20663.93609219986,20657.113803125398,20650.301160741907,
	20643.498159937157,20636.704795593105,20629.921062588233,20623.146955797027,20616.382470089346,
	20609.627600329863,20602.88234138007,20596.146688096145,20589.420635329338,20582.704177925953,
	20575.997310728115,20569.300028572612,20562.612326290906,20555.934198709434,20549.26564064949,
	20542.60664692694,20535.957212352398,20529.317331730712,20522.686999861187,20516.066211536978,
	20509.454961545936,20502.85324467045,20496.261055685958,20489.67838936237,20483.10524046337,
	20476.54160374626,20469.987473961766,20463.442845854966,20456.907714163226,20450.382073618268,
	20443.86591894458,20437.359244860156,20430.86204607539,20424.374317294347,20417.896053213837,
	20411.427248523287,20404.967897904527,20398.5179960329,20392.07753757553,20385.646517191428,
	20379.224929533237,20372.812769245116,20366.410030962867,20360.016709315085,20353.63279892187,
	20347.258294395153,20340.89319033872,20334.537481347732,20328.191162009796,20321.854226901916,
	20315.52667059446,20309.2084876477,20302.89967261382,20296.60022003546,20290.31012444669,
	20284.02938037178,20277.757982326024,20271.495924815597,20265.243202336085,20258.99980937526,
	20252.76574040937,20246.540989905996,20240.325552322633,20234.119422105934,20227.92259369341,
	20221.735061512336,20215.556819978723,20209.38786349907,20203.228186468772,20197.077783272838,
	20190.936648285224,20184.80477586953,20178.682160377935,20172.568796151543,20166.46467752061,
	20160.36979880387,20154.284154308494,20148.20773833029,20142.14054515372,20136.082569050912,
	20130.033804283135,20123.994245097816,20117.963885732177,20111.942720411484,20105.93074334665,
	20099.927948737968,20093.934330772277,20087.94988362487,20081.974601456903,20076.008478417883,
	20070.05150864375,20064.103686257346,20058.165005368624,20052.235460074215,20046.31504445683,
	20040.40375258678,20034.5015785193,20028.608516297056,20022.724559948078,20016.849703486754,
	20010.983940913782,20005.127266214644,19999.279673361576,19993.44115631105,19987.611709006596,
	19981.791325375827,19975.97999933176,19970.177724773323,19964.384495583126,19958.600305629916,
	19952.825148765936,19947.05901882926,19941.3019096414,19935.55381500888,19929.81472872244,
	19924.08464455607,19918.363556269287,19912.65145760449,19906.948342287866,19901.254204029698,
	19895.56903652338,19889.892833446327,19884.225588458223,19878.56729520288,19872.917947306243,
	19867.277538378385,19861.646062011227,19856.023511779626,19850.409881240976,19844.805163934983,
	19839.209353383783,19833.622443091917,19828.044426545483,19822.475297213183,19816.915048544473,
	19811.363673971802,19805.821166907404,19800.287520747417,19794.762728866208,19789.246784622504,
	19783.73968135393,19778.241412379393,19772.75197099893,19767.271350493225,19761.79954412352,
	19756.336545131126,19750.88234673792,19745.43694214581,19740.000324537054,19734.572487073012,
	19729.153422895466,19723.743125125766,19718.34158686434,19712.94880119162,19707.56476116686,
	19702.18945982823,19696.82289019333,19691.465045258396,19686.115917998613,19680.775501366952,
	19675.443788296216,19670.120771695714,19664.806444454745,19659.500799439105,19654.20382949429,
	19648.91552744137,19643.635886080836,19638.364898189986,19633.102556523383,19627.84885381333,
	19622.603782768703,19617.367336075786,19612.139506397594,19606.920286373326,19601.709668619904,
	19596.507645729034,19591.314210270357,19586.129354788725,19580.95307180563,19575.78535381774,
	19570.626193297605,19565.47558269442,19560.333514431215,19555.199980907695,19550.074974497904,
	19544.958487551754,19539.850512393325,19534.75104132218,19529.660066611727,19524.577580510697,
	19519.50357524149,19514.438043001417,19509.380975961314,19504.332366266455,19499.292206035225,
	19494.2604873605,19489.237202308417,19484.222342918092,19479.21590120247,19474.217869147225,
	19469.22823871157,19464.24700182649,19459.27415039671,19454.30967629931,19449.35357138314,
	19444.405827469658,19439.466436353283,19434.53538979911,19429.612679544873,19424.69829729964,
	19419.792234744396,19414.89448353117,19410.00503528358,19405.123881596213,19400.251014034817,
	19395.386424135664,19390.53010340579,19385.682043323155,19380.84223533576,19376.010670862393,
	19371.187341291276,19366.372237980777,19361.565352259768,19356.76667542597,19351.976198747372,
	19347.193913460982,19342.41981077282,19337.65388185839,19332.89611786239,19328.146509898084,
	19323.405049047626,19318.671726360848,19313.94653285747,19309.229459523915,19304.520497316164,
	19299.81963715765,19295.126869938853,19290.442186518732,19285.76557772383,19281.097034347833,
	19276.43654715155,19271.78410686338,19267.13970417781,19262.503329757325,19257.874974230024,
	19253.254628190884,19248.64228220163,19244.03792678986,19239.44155244918,19234.85314963929,
	19230.272708785687,19225.700220279567,19221.135674477486,19216.5790617016,19212.030372239125,
	19207.48959634214,19202.95672422784,19198.431746078517,19193.914652040705,19189.405432225383,
	19184.904076708433,19180.410575529077,19175.9249186915,19171.44709616296,19166.977097875275,
	19162.514913723036,19158.060533565404,19153.613947223694,19149.17514448343,19144.744115092166,
	19140.320848761574,19135.905335165317,19131.497563939483,19127.097524683086,19122.705206957264,
	19118.32060028573,19113.943694153568,19109.574478008304,19105.212941258833,19100.85907327609,
	19096.512863392196,19092.174300900508,19087.843375055632,19083.52007507387,19079.20439013098,
	19074.89630936538,19070.59582187379,19066.302916715984,19062.017582909888,19057.73980943511,
	19053.469585229883,19049.206899193836,19044.95174018549,19040.70409702318,19036.463958484972,
	19032.231313307657,19028.00615018801,19023.7884577813,19019.57822470177,19015.37543952273,
	19011.18009077633,19006.992166952434,19002.811656500064,18998.638547825816,18994.47282929506,
	18990.314489230972,18986.163515914042,18982.01989758279,18977.883622433495,18973.754678619196,
	18969.633054251422,18965.518737397528,18961.411716082308,18957.31197828805,18953.219511952717,
	18949.13430497184,18945.056345196983,18940.985620435415,18936.922118452378,18932.865826967354,
	18928.81673365639,18924.774826151555,18920.740092040458,18916.71251886653,18912.69209412809,
	18908.678805278923,18904.67263972799,18900.673584839275,18896.68162793195,18892.696756279332,
	18888.718957109806,18884.748217606346,18880.784524906216,18876.82786610036,18872.878228234727,
	18868.935598308784,18864.999963275877,18861.071310043328,18857.149625471462,18853.23489637527,
	18849.327109522183,18845.426251632864,18841.532309381764,18837.64526939545,18833.765118254378,
	18829.89184249085,18826.025428590812,18822.16586299138,18818.31313208342,18814.467222209136,
	18810.628119663943,18806.7958106942,18802.970281498205,18799.15151822731,18795.33950698355,
	18791.534233820654,18787.735684743522,18783.943845709877,18780.15870262679,18776.380241353865,
	18772.608447700797,18768.843307428935,18765.084806249786,18761.332929825938,18757.587663770482,
	18753.84899364717,18750.116904969505,18746.391383201913,18742.672413758744,18738.959982004093,
	18735.254073252236,18731.554672767645,18727.861765763864,18724.17533740435,18720.49537280235,
	18716.82185701967,18713.154775068902,18709.494111910466,18705.839852454043,18702.191981559703,
	18698.550484034233,18694.915344635272,18691.286548068027,18687.6640789869,18684.04792199425,
	18680.438061641118,18676.834482427315,18673.23716880049,18669.646105156222,18666.06127583859,
	18662.48266513927,18658.910257298223,18655.344036502953,18651.783986888684,18648.230092538295,
	18644.682337482238,18641.140705697708,18637.605181110604,18634.075747593088,18630.55238896455,
	18627.035088991946,18623.52383138852,18620.018599815136,18616.519377879427,18613.026149135203,
	18609.53889708362,18606.05760517153,18602.582256793703,18599.112835289925,18595.649323947422,
	18592.191705998735,18588.7399646235,18585.294082946446,18581.854044039843,18578.419830920266,
	18574.991426551132,18571.56881384184,18568.15197564666,18564.74089476627,18561.335553946654,
	18557.935935879534,18554.542023201415,18551.153798495245,18547.771244288113,18544.394343052896,
	18541.02307720811,18537.657429116392,18534.297381085704,18530.942915369505,18527.594014165217,
	18524.25065961575,18520.912833808223,18517.580518774743,18514.25369649197,18510.932348880524,
	18507.616457806358,18504.306005079,18501.0009724525,18497.701341625536,18494.407094240127,
	18491.11821188274,18487.834676083996,18484.556468317835,18481.283570002975,18478.01596250116,
	18474.753627117345,18471.49654510109,18468.244697645412,18464.99806588615,18461.75663090251,
	18458.52037371727,18455.289275296305,18452.063316548578,18448.84247832604,18445.626741423057,
	18442.41608657793,18439.210494470633,18436.009945724098,18432.814420904117,18429.623900518036,
	18426.438365016576,18423.257794792047,18420.082170178855,18416.911471453597,18413.745678834628,
	18410.58477248148,18407.428732496955,18404.277538923285,18401.131171745783,18397.989610889592,
	18394.85283622222,18391.720827551108,18388.593564625073,18385.471027132804,18382.353194704956,
	18379.240046910807,18376.131563261042,18373.02772320481,18369.928506133205,18366.833891374798,
	18363.743858198926,18360.658385813258,18357.577453364363,18354.501039938485,18351.429124559927,
	18348.361686190037,18345.29870372983,18342.240156017648,18339.1860218282,18336.13627987518,
	18333.090908806735,18330.04988721051,18327.013193607796,18323.98080645724,18320.95270415249,
	18317.928865022815,18314.909267331732,18311.893889277537,18308.882708992358,18305.875704542446,
	18302.87285392634,18299.874135075843,18296.879525854813,18293.889004058557,18290.90254741376,
	18287.920133578173,18284.941740138573,18281.967344611967,18278.996924444164,18276.03045700898,
	18273.067919607452,18270.109289468273,18267.1545437458,18264.203659518847,18261.256613792855,
	18258.313383495035,18255.37394547602,18252.43827650958,18249.506353288692,18246.578152427974,
	18243.653650460416,18240.732823836734,18237.815648925833,18234.902102011238,18231.99215929172,
	18229.085796879146,18226.182990797573,18223.28371698234,18220.38795127727,18217.495669434935,
	18214.60684711442,18211.72145987921,18208.839483196356,18205.96089243422,18203.08566286135,
	18200.213769643728,18197.34518784439,18194.47989241948,18191.61785821806,18188.75905997813,
	18185.90347232593,18183.051069772868,18180.20182671328,18177.355717422342,18174.51271605254,
	18171.672796630748,18168.83593305813,18166.002099103254,18163.17126840206,18160.34341445285,
	18157.518510614762,18154.69653010226,18151.87744598331,18149.061231175066,18146.247858439405,
	18143.437300380316,18140.629529439193,18137.824517889087,18135.02223783253,18132.22266119558,
	18129.42575972304,18126.631504974506,18123.839868317704,18121.050820923374,18118.26433376149,
	18115.48037759278,18112.69892296428,18109.91994020348,18107.1433994103,18104.369270451683,
	18101.597522954344,18098.82812629676,18096.06104960253,18093.2962617331,18090.533731277636,
	18087.773426546915,18085.015315563436,18082.259366052906,18079.505545434684,18076.75382081247,
	18074.00415896357,18071.256526329696,18068.510889005378,18065.76721272711,18063.02546286274,
	18060.28560439792,18057.547601925242,18054.81141963077,18052.077021281602,18049.34437021184,
	18046.61342930845,18043.884160996437,18041.156527226143,18038.43048945372,18035.706008629226,
	18032.98304517764,18030.261558981725,18027.54150936651,18024.822855079223,18022.105554271377,
	18019.38956447975,18016.674842605797,18013.96134489577,18011.24902691959,18008.537843548937,
	18005.82774893496,18003.118696486712,18000.410638845042,17997.703527860824,17994.997314568674,
	17992.291949162285,17989.58738096851,17986.883558418354,17984.18042902421,17981.477939346678,
	17978.77603496916,17976.07466046775,17973.373759381226,17970.673274180102,17967.97314623751,
	17965.273315794704,17962.573721931185,17959.874302531476,17957.174994251414,17954.47573248575,
	17951.77645133338,17949.077083563352,17946.377560580444,17943.677812391135,17940.97776756694,
	17938.277353211994,17935.576494926012,17932.875116771076,17930.173141235256,17927.47048920131,
	17924.767079910456,17922.062830929986,17919.357658120243,17916.651475605257,17913.944195739816,
	17911.235729081298,17908.525984361837,17905.814868462596,17903.10228638922,17900.38814124968,
	17897.67233423437,17894.954764600494,17892.23532965653,17889.51392475231,17886.790443272166,
	17884.06477663184,17881.336814279155,17878.60644370141,17875.87355043661,17873.13801808889,
	17870.39972835509,17867.658561050048,17864.914394148313,17862.167103825424,17859.41656451228,
	17856.662648956808,17853.905228294414,17851.144172128857,17848.379348625665,17845.610624613364,
	17842.837865698388,17840.060936393675,17837.279700258397,17834.494020053422,17831.70375790952,
	17828.908775512136,17826.10893430274,17823.304095694366,17820.494121306554,17817.678873216508,
	17814.858214229374,17812.032008168106,17809.200120179696,17806.362417064644,17803.518767624915,
	17800.669043029746,17797.81311720705,17794.950867251016,17792.082173851453,17789.20692174464,
	17786.325000182227,17783.43630342096,17780.540731232202,17777.63818942818,17774.728590406667,
	17771.811853712006,17768.88790661037,17765.956684681678,17763.01813241956,17760.072203844004,
	17757.11886312311,17754.158085197603,17751.189856412548,17748.214175146295,17745.23105244055,
	17742.24051262582,17739.24259393275,17736.237349099254,17733.2248459589,17730.205168009667,
	17727.17841496059,17724.14470325443,17721.104166555764,17718.056956206863,17715.003241644874,
	17711.943210776473,17708.877070305785,17705.80504601225,17702.727382976387,17699.644345743953,
	17696.556218436264,17693.463304790523,17690.36592813896,17687.264431316155,17684.159176497622,
	17681.050544966736,17677.93893680737,17674.824770523606,17671.708482584312,17668.590526895325,
	17665.471374197707,17662.351511394114,17659.231440808067,17656.111679369787,17652.99275774533,
	17649.875219397138,17646.759619591845,17643.646524352345,17640.53650936266,17637.430158828,
	17634.328064297835,17631.23082345365,17628.13903887519,17625.053316779,17621.974265748973,
	17618.902495454517,17615.8386153675,17612.78323348566,17609.736955061137,17606.70038135508,
	17603.674108402214,17600.658725814803,17597.654815612008,17594.6629510923,17591.68369574674,
	17588.71760221975,17585.76521132235,17582.827051099008,17579.903635951894,17576.995465827626,
	17574.103025463704,17571.226783701397,17568.367192862857,17565.524688193836,17562.699687373704,
	17559.89259009151,17557.103777687666,17554.33361286172,17551.58243944308,17548.850582221472,
	17546.138346844215,17543.446019764368,17540.77386825091,17538.122140448526,17535.49106549084,
	17532.880853659644,17530.291696591095,17527.723767521402,17525.177221574046,17522.652196082585,
	17520.14881094484,17517.667169006738,17515.207356473595,17512.769443346013,17510.353483875748,
	17507.95951703466,17505.587567010043,17503.237643699184,17500.90974322298,17498.60384844426,
	17496.319929489895,17494.057944278917,17491.817839050185,17489.599548888575,17487.4029982486,
	17485.228101480276,17483.074763335946,17480.942879489445,17478.83233702521,17476.743014938776,
	17474.674784612733,17472.627510293118,17470.601049541812,17468.59525369081,17466.609968271834,
	17464.645033440735,17462.70028438632,17460.77555172137,17458.870661868434,17456.985437424395,
	17455.119697514652,17453.27325812964,17451.445932453527,17449.637531175063,17447.84786278374,
	17446.076733855203,17444.32394932387,17442.589312739292,17440.872626513363,17439.173692151653,
	17437.492310474085,17435.82828182936,17434.18140628303,17432.551483815212,17430.938314488525,
	17429.34169861707,17427.761436921184,17426.197330674127,17424.649181836903,17423.116793187917,
	17421.59996844026,17420.098512355322,17418.612230842984,17417.140931056532,17415.68442148509,
	17414.242512031677,17412.815014089054,17411.401740607605,17410.002506160137,17408.61712699638,
	17407.245421096995,17405.887208217762,17404.54230993694,17403.21054968511,17401.89175278415,
	17400.58574647332,17399.292359935494,17398.011424318098,17396.74277275316,17395.486240371178,
	17394.24166431192,17393.008883735056,17391.78773982806,17390.578075807378,17389.379736921404,
	17388.192570451723,17387.016425710357,17385.851154032396,17384.696608773535,17383.552645301563,
	17382.419120988194,17381.295895196185,17380.182829269306,17379.079786520797,17377.98663221688,
	17376.90323356167,17375.82945968426,17374.76518162067,17373.710272296106,17372.664606503506,
	17371.6280608941,17370.600513947305,17369.581845957833,17368.571939014717,17367.57067697994,
	17366.5779454645,17365.593631811862,17364.61762507705,17363.64981600031,17362.690096988383,
	17361.73836209204,17360.794506985156,17359.858428942924,17358.93002681467,17358.009201009772,
	17357.09585347144,17356.189887650762,17355.29120849549,17354.399722415223,17353.51533727075,
	17352.637962343066,17351.767508321107,17350.90388727357,17350.047012629802,17349.196799156987,
	17348.353162946038,17347.516021379077,17346.685293122122,17345.86089809569,17345.042757457344,
	17344.23079357956,17343.424930039844,17342.625091586488,17341.831204130078,17341.043194722286,
	17340.260991534935,17339.48452384277,17338.713722007247,17337.948517454988,17337.188842661843,
	17336.434631138167,17335.685817405873,17334.942336987206,17334.20412638032,17333.471123056806,
	17332.743265429053,17332.02049284409,17331.30274556592,17330.589964759234,17329.882092477914,
	17329.179071643786,17328.48084603197,17327.787360268998,17327.09855979907,17326.4143908859,
	17325.734800592047,17325.05973676275,17324.38914802294,17323.722983752006,17323.06119407674,
	17322.40372986294,17321.750542692735,17321.101584861044,17320.456809358227,17319.816169864054,
	17319.179620728188,17318.54711696796,17317.91861424903,17317.29406887856,17316.673437794652,
	17316.056678552926,17315.44374931752,17314.834608855308,17314.22921651887,17313.627532234812,
	17313.029516508854,17312.43513040068,17311.844335518163,17311.257094010234,17310.67336856463,
	17310.09312238526,17309.516319191458,17308.942923211835,17308.37289916982,17307.806212273554,
	17307.242828221788,17306.682713182054,17306.12583378462,17305.57215711906,17305.021650728715,
	17304.474282595427,17303.93002113944,17303.388835206348,17302.85069406541,17302.31556740165,
	17301.783425304322,17301.254238269703,17300.72797718274,17300.204613318532,17299.684118336725,
	17299.166464273996,17298.651623527887,17298.139568873154,17297.630273430983,17297.123710682452,
	17296.619854454264,17296.118678912055,17295.620158559355,17295.124268228752,17294.63098308209,
	17294.140278594135,17293.652130562827,17293.166515092504,17292.68340859333,17292.20278777465,
	17291.724629643595,17291.24891150105,17290.775610929973,17290.304705800296,17289.836174255248,
	17289.36999471272,17288.906145863177,17288.444606663168,17287.985356325895,17287.528374322414,
	17287.07364038418,17286.621134482848,17286.17083684278,17285.722727925993,17285.27678843746,
	17284.83299931023,17284.391341715786,17283.951797052006,17283.51434693182,17283.07897320796,
	17282.645657931465,17282.214383378312,17281.785132035347,17281.357886595477,17280.932629959032,
	17280.50934522508,17280.088015694433,17279.6686248619,17279.25115642357,17278.835594253796,
	17278.421922421214,17278.010125182267,17277.600186971744,17277.192092404362,17276.78582627611,
	17276.38137354872,17275.97871936779,17275.577849037963,17275.17874804007,17274.781402013006,
	17274.38579676197,17273.99191825493,17273.59975260721,17273.209286106434,17272.820505175234,
	17272.433396404518,17272.047946520885,17271.664142405847,17271.281971088425,17270.90141973399,
	17270.522475651756,17270.14512629277,17269.769359243226,17269.395162221826,17269.02252308434,
	17268.651429823054,17268.281870551156,17267.91383351229,17267.54730708194,17267.182279754194,
	17266.81874015333,17266.456677012782,17266.09607919909,17265.736935693043,17265.379235584624,
	17265.02296808627,17264.668122525083,17264.31468833576,17263.96265506699,17263.612012375004,
	17263.26275001931,17262.914857874996,17262.568325913122,17262.223144215903,17261.879302960722,
	17261.5367924293,17261.19560299991,17260.855725158406,17260.517149473788,17260.17986662559,
	17259.843867370968,17259.509142574498,17259.175683186273,17258.84348025162,17258.512524896985,
	17258.182808345817,17257.854321907682,17257.52705697676,17257.201005032242,17256.876157638017,
	17256.55250644185,17256.230043169104,17255.90875963861,17255.588647730958,17255.269699423574,
	17254.95190675991,17254.63526186647,17254.31975694418,17254.005384270604,17253.692136195954,
	17253.380005140356,17253.068983603218,17252.759064156187,17252.4502394353,17252.142502150782,
	17251.835845077676,17251.530261064912,17251.225743025057,17250.922283938264,17250.619876854194,
	17250.318514879713,17250.018191195053,17249.718899034735,17249.420631701534,17249.123382559163,
	17248.82714503494,17248.531912614213,17248.237678836344,17247.94443731713,17247.652181705056,
	17247.36090573555,17247.070603177748,17246.781267869545,17246.49289369799,17246.205474609385,
	17245.91900460375,17245.63347773641,17245.34888811532,17245.06522989321,17244.782497287222,
	17244.500684557337,17244.219786022913,17243.939796042425,17243.660709027623,17243.38251944937,
	17243.105221814352,17242.828810688447,17242.55328066549,17242.278626411276,17242.004842626204,
	17241.731924049705,17241.459865477762,17241.188661754026,17240.91830774451,17240.648798389542,
	17240.38012864922,17240.112293539598,17239.8452881117,17239.579107468384,17239.313746739896,
	17239.04920110664,17238.78546579696,17238.522536061573,17238.260407201804,17237.99907455862,
	17237.7385335124,17237.47877947721,17237.219807906822,17236.96161429993,17236.704194179536,
	17236.447543119102,17236.19165671217,17235.936530609837,17235.682160484568,17235.42854204173,
	17235.175671027035,17234.923543230787,17234.672154459313,17234.421500563858,17234.17157742319,
	17233.922380964304,17233.673907122677,17233.42615187863,17233.179111261903,17232.93278129824,
	17232.68715807384,17232.442237698437,17232.198016304872,17231.9544900663,17231.711655180927,
	17231.469507878937,17231.22804441889,17230.987261089966,17230.747154205696,17230.507720116308,
	17230.26895520073,17230.030855858695,17229.793418516267,17229.556639637376,17229.32051570586,
	17229.08504323939,17228.850218771513,17228.616038872995,17228.382500133383,17228.149599176,
	17227.91733264149,17227.685697202458,17227.45468954896,17227.224306412227,17226.99454452429,
	17226.765400664557,17226.53687162383,17226.308954217286,17226.081645288155,17225.85494170687,
	17225.628840355974,17225.403338152562,17225.178432030116,17224.954118939153,17224.730395870753,
	17224.507259821363,17224.284707812814,17224.062736900727,17223.841344144366,17223.620526637715,
	17223.400281487087,17223.180605828707,17222.961496810593,17222.742951613032,17222.524967419733,
	17222.307541450245,17222.090670941474,17221.874353137173,17221.658585318986,17221.443364782688,
	17221.228688830124,17221.014554800677,17220.800960045246,17220.587901925544,17220.375377836146,
	17220.163385177893,17219.9519213827,17219.74098389444,17219.53057015937,17219.32067766926,
	17219.11130391189,17218.902446413344,17218.694102691206,17218.48627029581,17218.27894679521,
	17218.072129778266,17217.865816833964,17217.660005574522,17217.454693647018,17217.24987868331,
	17217.045558351052,17216.8417303283,17216.638392320725,17216.435542032952,17216.2331771909,
	17216.03129554289,17215.82989483953,17215.62897285356,17215.42852738001,17215.22855621273,
	17215.02905717056,17214.83002809611,17214.631466824172,17214.433371220995,17214.23573915563,
	17214.038568529708,17213.8418572375,17213.645603194516,17213.449804334974,17213.254458602005,
	17213.05956395506,17212.86511836603,17212.671119817056,17212.47756631147,17212.284455848956,
	17212.09178646392,17211.899556195433,17211.70776308322,17211.516405196966,17211.3254806035,
	17211.134987400856,17210.944923671483,17210.75528755103,17210.566077144525,17210.377290591256,
	17210.188926044346,17210.00098166106,17209.813455607557,17209.626346073113,17209.43965124869,
	17209.253369337745,17209.067498567078,17208.882037158644,17208.696983346203,17208.51233538553,
	17208.328091539497,17208.14425008136,17207.960809288183,17207.777767463085,17207.5951229009,
	17207.412873922065,17207.231018849867,17207.04955602387,17206.868483784237,17206.687800492822,
	17206.507504513396,17206.32759422508,17206.148068007547,17205.968924263874,17205.79016139189,
	17205.611777818558,17205.433771958982,17205.256142257644,17205.07888714672,17204.90200509266,
	17204.725494550108,17204.549353998584,17204.373581907144,17204.198176780075,17204.023137109467,
	17203.84846141212,17203.674148196747,17203.500195987555,17203.32660332848,17203.15336875682,
	17202.980490838072,17202.80796811347,17202.635799166794,17202.46398256784,17202.29251691255,
	17202.12140079033,17201.950632803248,17201.780211561585,17201.61013569006,17201.4404038071,
	17201.271014555336,17201.101966572416,17200.933258520836,17200.76488904353,17200.59685682075,
	17200.429160518954,17200.26179881767,17200.094770414144,17199.928074008178,17199.761708295737,
	17199.595671987157,17199.429963808594,17199.26458248354,17199.099526744896,17198.93479533846,
	17198.770387006116,17198.60630051472,17198.44253461018,17198.279088067524,17198.11595967078,
	17197.953148199347,17197.790652438685,17197.628471192093,17197.46660325016,17197.305047438567,
	17197.143802560826,17196.98286745339,17196.822240936108,17196.661921848816,17196.501909037404,
	17196.342201345895,17196.182797629204,17196.023696757344,17195.86489758944,17195.70639900424,
	17195.548199883844,17195.390299104045,17195.23269557077,17195.075388177986,17194.918375824825,
	17194.761657433442,17194.60523190719,17194.4490981834,17194.293255177327,17194.137701827145,
	17193.98243707782,17193.827459866305,17193.672769145654,17193.51836387685,17193.364243020045,
	17193.210405541406,17193.05685042063,17192.90357663227,17192.750583156503,17192.597868980763,
	17192.44543311669,17192.29327454449,17192.1413922842,17191.98978534248,17191.8384527335,
	17191.687393480195,17191.536606605525,17191.386091144963,17191.235846135136,17191.085870615112,
	17190.936163631406,17190.78672424217,17190.637551490996,17190.488644451056,17190.34000218238,
	17190.19162376116,17190.043508253737,17189.895654749598,17189.748062330134,17189.600730089165,
	17189.453657112623,17189.30684251686,17189.16028538547,17189.01398484102,17188.867939989836,
	17188.722149950438,17188.576613842346,17188.431330799867,17188.286299954518,17188.141520428984,
	17187.996991375254,17187.852711931457,17187.708681245964,17187.564898472436,17187.421362772457,
	17187.278073290556,17187.135029214704,17186.992229700878,17186.849673928424,17186.707361065517,
	17186.565290302948,17186.423460828384,17186.28187182656,17186.140522489222,17185.999412010482,
	17185.85853961145,17185.71790447309,17185.57750582799,17185.43734287732,17185.297414833945,
	17185.15772093128,17185.01826037951,17184.8790324228,17184.7400362862,17184.60127120898,
	17184.462736426987,17184.324431185472,17184.186354737365,17184.048506316038,17183.9108852,
	17183.7734906272,17183.636321880254,17183.499378203192,17183.362658879167,17183.226163173076,
	17183.089890359563,17182.95383972479,17182.818010550574,17182.68240212264,17182.54701372515,
	17182.41184465682,17182.2768942062,17182.142161675278,17182.00764637742,17181.8733476141,
	17181.73926469223,17181.605396915704,17181.471743613183,17181.338304096178,17181.205077691175,
	17181.072063732277,17180.939261528525,17180.806670429345,17180.67428975354,17180.54211885187,
	17180.41015706829,17180.278403734683,17180.146858201195,17180.015519820485,17179.88438795218,
	17179.753461939938,17179.622741152987,17179.492224948797,17179.36191268847,17179.23180375268,
	17179.101897495522,17178.972193301543,17178.84269055066,17178.713388607568,17178.584286869784,
	17178.45538471118,17178.326681521023,17178.198176701233,17178.069869639225,17177.94175972316,
	17177.81384635692,17177.68612894386,17177.55860688721,17177.431279593337,17177.30414648009,
	17177.177206943736,17177.05046040334,17176.923906282875,17176.797544004352,17176.671372986162,
	17176.545392641165,17176.419602420778,17176.29400174202,17176.168590031684,17176.04336674053,
	17175.918331290493,17175.793483141075,17175.668821717263,17175.544346467526,17175.42005684034,
	17175.29595229585,17175.17203227589,17175.04829623506,17174.924743641855,17174.801373942355,
	17174.67818659642,17174.555181086187,17174.43235686819,17174.309713410952,17174.187250178078,
	17174.064966657636,17173.942862315544,17173.820936632084,17173.699189094088,17173.577619175983,
	17173.45622636057,17173.335010145212,17173.213970008877,17173.093105455348,17172.972415962577,
	17172.85190103494,17172.731560171913,17172.611392872484,17172.491398631188,17172.37157696329,
	17172.251927369267,17172.132449352855,17172.013142439406,17171.894006124872,17171.775039930057,
	17171.656243383677,17171.53761598613,17171.419157262324,17171.300866746344,17171.18274394981,
	17171.064788404692,17170.946999644162,17170.829377195605,17170.711920576363,17170.594629345447,
	17170.47750302742,17170.36054116115,17170.243743287578,17170.127108953748,17170.010637700274,
	17169.894329071565,17169.778182609818,17169.66219787351,17169.546374414473,17169.43071178684,
	17169.315209535856,17169.199867227435,17169.08468442192,17168.96966067482,17168.854795553827,
	17168.740088615483,17168.62553943223,17168.511147567537,17168.396912601795,17168.282834085378,
	17168.168911609493,17168.055144751386,17167.941533066798,17167.82807615052,17167.714773577467,
	17167.601624935905,17167.488629799398,17167.375787766414,17167.263098405,17167.150561315986,
	17167.038176080176,17166.92594230177,17166.813859566988,17166.701927475824,17166.59014560227,
	17166.47851358199,17166.36703097802,17166.255697414028,17166.14451248775,17166.033475803644,
	17165.9225869624,17165.81184557761,17165.701251263028,17165.590803618557,17165.480502256432,
	17165.37034679022,17165.26033684967,17165.15047203153,17165.04075196678,17164.931176267117,
	17164.821744564735,17164.71245647213,17164.603311614355,17164.49430962051,17164.385450115722,
	17164.276732729642,17164.16815708288,17164.059722828184,17163.951429576446,17163.843276974843,
	17163.735264651594,17163.62739224337,17163.519659390695,17163.412065735192,17163.30461092652,
	17163.197294588503,17163.090116368883,17162.98307592064,17162.87617289211,17162.769406924643,
	17162.662777666505,17162.556284769238,17162.449927892656,17162.34370668456,17162.237620791268,
	17162.131669875707,17162.02585359063,17161.92017161343,17161.814623579678,17161.70920915736,
	17161.603928019566,17161.498779816728,17161.393764218497,17161.28888089169,17161.18412949861,
	17161.079509712592,17160.975021205853,17160.8706636466,17160.76643670494,17160.66234005067,
	17160.55837337139,17160.45453632905,17160.35082860853,17160.24724989084,17160.14379984636,
	17160.04047815956,17159.937284514876,17159.834218591957,17159.731280068878,17159.62846865005,
	17159.525784001806,17159.42322582481,17159.320793797477,17159.21848761905,17159.11630697941,
	17159.0142515649,17158.91232106809,17158.810515189944,17158.708833624358,17158.6072760622,
	17158.505842208073,17158.404531762433,17158.303344416297,17158.202279876175,17158.101337845455,
	17158.00051801156,17157.899820108185,17157.799243821337,17157.69878885171,17157.598454920586,
	17157.498241729303,17157.39814898859,17157.29817641172,17157.19832371269,17157.098590589016,
	17156.998976765637,17156.89948195985,17156.80010588523,17156.700848250977,17156.601708783866,
	17156.502687190037,17156.40378320496,17156.304996548653,17156.206326932148,17156.10777406939,
	17156.00933771097,17155.911017561673,17155.81281334547,17155.714724814214,17155.61675166311,
	17155.518893628712,17155.42115045824,17155.323521865022,17155.22600758503,17155.128607349696,
	17155.031320895545,17154.9341479505,17154.837088251566,17154.74014154057,17154.643307538987,
	17154.54658600404,17154.44997666466,17154.353479257345,17154.257093530945,17154.16081920538,
	17154.064656052808,17153.968603806847,17153.872662199512,17153.776830978964,17153.681109909343,
	17153.585498717537,17153.489997146797,17153.394604966932,17153.299321912888,17153.20414772827,
	17153.10908217637,17153.014125008125,17152.919275980286,17152.82453482375,17152.72990132385,
	17152.635375214173,17152.54095625051,17152.44664420021,17152.35243882203,17152.25833986242,
	17152.16434708979,17152.070460259423,17151.976679125863,17151.883003469597,17151.789433038877,
	17151.695967592037,17151.602606915487,17151.509350752975,17151.416198872295,17151.32315104328,
	17151.230207047327,17151.13736662513,17151.044629560856,17150.951995631418,17150.85946459122,
	17150.767036219146,17150.67471028236,17150.582486565094,17150.490364819896,17150.398344836827,
	17150.306426391267,17150.21460926041,17150.122893199794,17150.031278008315,17149.939763447335,
	17149.8483493151,17149.757035377235,17149.665821417428,17149.57470720954,17149.483692537702,
	17149.39277719808,17149.301960956513,17149.211243602258,17149.12062491384,17149.03010468447,
	17148.93968269845,17148.849358738138,17148.75913258192,17148.669004038606,17148.57897289499,
	17148.489038926265,17148.399201913304,17148.309461664176,17148.21981796579,17148.130270612925,
	17148.04081939697,17147.951464101392,17147.86220453269,17147.77304046415,17147.683971729704,
	17147.594998090626,17147.50611935572,17147.417335314083,17147.328645776895,17147.240050526856,
	17147.151549372495,17147.063142115796,17146.97482854997,17146.88660848278,17146.798481703492,
	17146.710448029447,17146.6225072528,17146.534659184093,17146.44690362841,17146.359240371537,
	17146.271669241523,17146.18419002864,17146.096802555985,17146.009506607348,17145.922302008086,
	17145.835188556382,17145.74816608203,17145.661234368654,17145.57439322657,17145.487642493095,
	17145.40098195585,17145.314411432137,17145.227930733636,17145.14153967432,17145.055238069577,
	17144.969025734437,17144.882902482692,17144.79686811649,17144.710922471713,17144.625065362983,
	17144.539296581224,17144.453615980674,17144.368023356477,17144.282518535183,17144.19710132105,
	17144.11177156352,17144.02652905466,17143.941373634374,17143.856305116653,17143.771323318135,
	17143.68642806269,17143.601619183246,17143.51689649482,17143.432259826335,17143.34770898891,
	17143.26324382329,17143.178864156896,17143.094569796067,17143.01036059481,17142.92623635313,
	17142.842196926285,17142.75824212737,17142.67437177532,17142.590585713973,17142.506883771952,
	17142.42326578498,17142.33973155265,17142.256280950103,17142.172913783037,17142.08962989229,
	17142.006429106274,17141.92331126246,17141.84027619541,17141.757323734095,17141.67445371075,
	17141.59166597969,17141.5089603597,17141.42633667665,17141.34379478981,17141.261334538405,
	17141.17895573462,17141.0966582422,17141.014441886782,17140.9323065121,17140.85025195704,
	17140.7682780681,17140.686384669792,17140.604571612836,17140.522838744288,17140.441185896616,
	17140.3596129107,17140.278119632174,17140.196705922022,17140.115371610136,17140.034116536463,
	17139.952940551222,17139.87184349521,17139.790825219545,17139.709885562777,17139.62902438,
	17139.548241524244,17139.467536825927,17139.386910128316,17139.306361312396,17139.225890203004,
	17139.14549664814,17139.06518051735,17138.98494162461,17138.904779847944,17138.82469504338,
	17138.74468705878,17138.664755730762,17138.58490090617,17138.50512247475,17138.425420242485,
	17138.345794102952,17138.266243893886,17138.18676946016,17138.10737067122,17138.028047381875,
	17137.94879943368,17137.869626702115,17137.790529043334,17137.711506279677,17137.63255830542,
	17137.55368496655
	}}
};
