# Debian: dokuwiki-plugins-extra

# Copyright (C) 2024-2025 Daniel Baumann <daniel@debian.org>
#
# SPDX-License-Identifier: GPL-3.0+
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Build-Depends:
# none

SHELL := sh -e

PLUGIN := gitbacked

all:

test:

build:

install:
	mkdir -p $(DESTDIR)/usr/share/dokuwiki/plugins-extra
	cp -a $(PLUGIN) $(DESTDIR)/usr/share/dokuwiki/plugins-extra

	# removing unused files
	rm -f $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)/README*
	rm -rf $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)/.git*

	rm -f $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)/CHANGELOG*
	rm -f $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)/LICENSE*

	rm -rf $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)/.[a-z]*
	rm -rf $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)/_test

uninstall:
	rm -rf $(DESTDIR)/usr/share/dokuwiki/plugins-extra/$(PLUGIN)
	rmdir --ignore-fail-on-non-empty --parents $(DESTDIR) || true

clean:

distclean:

reinstall: uninstall install

upstream:
	rm -rf $(PLUGIN)
	git clone https://github.com/woolfg/dokuwiki-plugin-gitbacked $(PLUGIN)
	rm -rf $(PLUGIN)/.git
