/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include <glib.h>
#include "general.h"

gint comp_string(const void * elem1, const void * elem2)
{
	return g_strcmp0(*(gchar **)elem1, *(gchar **)elem2);
}

gchar * get_app_dir()
{
	return g_build_filename(g_get_user_config_dir(), "desktopnova/", NULL);
}

gchar * get_setting_file()
{
	gchar * app_dir = get_app_dir();

	gchar * setting_file = g_build_filename(app_dir, SETTINGFILE, NULL);

	g_free(app_dir);
	return setting_file;
}

