/* Database of special points in Brillouin zones according to
 * classification of Setawan and Curtarolo
 *  Comp. Mater. Sci. 49 299 (2010)
 * Indexation is by real space lattice
 *
 * Real space fcc -> reciprocal space bcc, and vice versa
 * Real space hex (120 deg) -> recip. space hex (60 deg) and vice versa
 */


struct special_sc specials_sc[]={{"CUB","cubic",{'1','1','1'},
				  {{"R",{0.5,0.5,0.5}},
				   {"X",{0,0.5,0}},
				   {"M",{0.5,0.5,0}},
				   {"",{0,0,0}}}},
				 {"FCC","fcc",{'1','1','1'},
				  {{"X",{0.5,0,0.5}},
				   {"L",{0.5,0.5,0.5}},
				   {"W",{0.5,0.25,0.75}},
				   {"K",{0.375,0.375,0.75}},
				   {"U",{0.625,0.25,0.625}},
				   {"",{0,0,0}}}},
				 {"BCC","bcc",{'1','1','1'},
				  {{"P",{0.25,0.25,0.25}},
				   {"H",{0.5,-0.5,0.5}},
				   {"N",{0,0,0.5}},
				   {"",{0,0,0}}}},
				 {"TET","tetragaonal",{'1','1','2'},
				  {{"A",{0.5,0.5,0.5}},
				   {"X",{0,0.5,0}},
				   {"M",{0.5,0.5,0}},
				   {"R",{0,0.5,0.5}},
				   {"Z",{0,0,0.5}},
				   {"",{0,0,0}}}},
				 {"ORC","orthorhombic",{'1','2','3'},
				  {{"R",{0.5,0.5,0.5}},
				   {"X",{0.5,0,0}},
				   {"Y",{0,0.5,0}},
				   {"Z",{0,0,0.5}},
				   {"S",{0.5,0.5,0}},
				   {"T",{0,0.5,0.5}},
				   {"U",{0.5,0,0.5}},
				   {"",{0,0,0}}}},
				 {"HEX","hexagonal",{'1','1','2'},
				  {{"A",{0,0,0.5}},
				   {"M",{0.5,0,0}},
				   {"M",{0.5,0.5,0}},
				   {"K",{1./3.,1./3.,0}},
				   {"K",{2./3.,2./3.,0}},
				   {"L",{0.5,0,0.5}},
				   {"L",{0.5,0.5,0.5}},
				   {"H",{1./3.,1./3.,0.5}},
				   {"H",{2./3.,2./3.,0.5}},
				   {"",{0,0,0}}}},
				 {"RHL1","rhombohedral",{'1','1','1'},
				  {{"Z",{0.5,0.5,0.5}},
				   {"L",{0.5,0,0}},
				   {"F",{0.5,0.5,0}},
				   {"",{0,0,0}}}},
				 {"RHL2","rhombohedral",{'1','1','1'},
				  {{"Z",{0.5,0.5,0.5}},
				   {"L",{0.5,0,0}},
				   {"F",{0.5,-0.5,0}},
				   {"",{0,0,0}}}},
				 {"MCL","monoclinic",{'1','2','3'},
				  {{"A",{0.5,0.5,0}},
				   {"B",{0.5,0,0}},
				   {"X",{0,0.5,0}},
				   {"Y",{0,0,0.5}},
				   {"Z",{0.5,0,0}},
				   {"C",{0,0.5,0.5}},
				   {"D",{0.5,0,0.5}},
				   {"E",{0.5,0.5,0.5}},
				   {"",{0,0,0}}}},
				 {"","","",{{"",{0,0,0}}}}};



  
