/*
 * Simple X11 client-side cursor
 * Implementation file
 *
 * $Id: xcursor.cc,v 1.2 2003/02/10 01:41:05 hsteoh Exp hsteoh $
 */

#include "exception.h"
#include "xcursor.h"


void xcursor::draw() {
  bckgnd.save(d, x-cursor->org_x(), y-cursor->org_y(),
              cursor->width(), cursor->height());
  cursor->draw(d,x,y);
}

xcursor::xcursor(xsprite_engine *engine, Drawable drw, xflatsprite *curs,
                 int max_wd, int max_ht) :
	eng(engine), d(drw), bckgnd(engine,d,max_wd,max_ht) {
  set_sprite(curs);
  visible=0;
  x=y=0;
}

xcursor::~xcursor() {
  if (visible) {
    bckgnd.restore();
  }
}

void xcursor::set_sprite(xflatsprite *curs) {
  if (curs->width() > bckgnd.max_width() ||
      curs->height() > bckgnd.max_height()) {
    throw exception("xcursor::set_sprite(): cursor sprite too big\n");
  } else {
    cursor=curs;
    if (visible) {			// redraw with new cursor image
      bckgnd.restore();
      draw();
    }
  }
}

void xcursor::on() {
  if (!visible) {
    visible=1;
    draw();
  }
}

void xcursor::off() {
  if (visible) {
    bckgnd.restore();
  }
  visible=0;
}

void xcursor::move(int new_x, int new_y) {
  if (visible) {
    if (new_x!=x || new_y!=y) {		// only update if coors changed
      bckgnd.restore();			// erase from last position
      x = new_x;
      y = new_y;
      draw();
    }
  } else {
    x = new_x;				// still update internal coor anyway
    y = new_y;
  }
}

