/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 19:30:08 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.variant.CDSFeature;
import uk.ac.sanger.artemis.components.variant.VCFRecord;
import uk.ac.sanger.artemis.components.variant.VariantBase;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class VCFRecord_ESTest extends VCFRecord_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      RangeVector rangeVector0 = selection0.getSelectionRanges();
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, 0, 4, "H.Jq:piO");
      short short0 = VCFRecord.checkSyn(cDSFeature0, 4, 'r');
      assertEquals((short) (-1), short0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Range range0 = new Range(0, 6);
      RangeVector rangeVector0 = new RangeVector(range0);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, 6, (-4260), "\t");
      short short0 = VCFRecord.checkSyn(cDSFeature0, 0, 'K');
      assertEquals((short) (-1), short0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      String[] stringArray0 = VCFRecord.split("=N?ZrPSMt(c", "=N?ZrPSMt(c", 2696);
      assertEquals(1, stringArray0.length);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      String[] stringArray0 = VCFRecord.split("", "", 0);
      assertEquals(0, stringArray0.length);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getSampleDataString();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null=null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.variant.VCFRecord\t0.0\tnull\tnull\tnull\t", 1426);
      String string0 = vCFRecord0.getRef();
      assertEquals("null", string0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef("");
      String string0 = vCFRecord0.getRef();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t", 3);
      String string0 = vCFRecord0.getInfo();
      assertEquals("null", string0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setInfo("");
      String string0 = vCFRecord0.getInfo();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setID("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.variant.VCFRecord\t0.0\tnull\tnull\tnull\t");
      String string0 = vCFRecord0.getID();
      assertEquals("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.variant.VCFRecord\t0.0\tnull\tnull\tnull\t", string0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setID("");
      String string0 = vCFRecord0.getID();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String[][] stringArray0 = new String[6][4];
      vCFRecord0.setGenoTypeData(stringArray0);
      String[][] stringArray1 = vCFRecord0.getGenoTypeData();
      assertSame(stringArray1, stringArray0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getFormat();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFormat("Ii ");
      String string0 = vCFRecord0.getFormat();
      assertEquals("Ii ", string0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getFilter();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFilter("Af%p]/r7n!EK>Y");
      String string0 = vCFRecord0.getFilter();
      assertEquals("Af%p]/r7n!EK>Y", string0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getChrom();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setChrom("");
      String string0 = vCFRecord0.getChrom();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setAlt("uk.ac.sanger.artemis.components.va iant.VCFRecord");
      VariantBase variantBase0 = vCFRecord0.getAlt();
      assertEquals("uk.ac.sanger.artemis.components.va iant.VCFRecord", variantBase0.toString());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      int int0 = VCFRecord.countOccurrences(":", 'Z');
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.split((String) null, "", 502);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.split("B,4\"3z@)J%C", (String) null, (-1781));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      // Undeclared exception!
      try { 
        vCFRecord0.setFilter((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.parse((String) null, 2815);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.parse((String) null, (-319));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.parse("Jp*|`E!", 2748);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 1
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setAlt("");
      // Undeclared exception!
      try { 
        vCFRecord0.getSynFlag((FeatureVector) null, 5);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        vCFRecord0.getSynFlag(featureVector0, 5);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setAlt(":");
      KeyVector keyVector0 = new KeyVector();
      Object object0 = new Object();
      keyVector0.add(object0);
      // Undeclared exception!
      try { 
        vCFRecord0.getSynFlag(keyVector0, 130);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.Object cannot be cast to uk.ac.sanger.artemis.components.variant.CDSFeature
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.countOccurrences((String) null, 'u');
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      // Undeclared exception!
      try { 
        vCFRecord0.containsInfoFlag("Af%p]/r7n!EK>Y");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.checkSyn((CDSFeature) null, (-2292), 'L');
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      // Undeclared exception!
      try { 
        vCFRecord0.appendFilter("uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Range range0 = new Range(29);
      RangeVector rangeVector0 = new RangeVector(range0);
      CDSFeature cDSFeature0 = new CDSFeature(true, rangeVector0, 3, 29, "Index not found for File '");
      cDSFeature0.lastBase = 4436;
      short short0 = VCFRecord.checkSyn(cDSFeature0, ')', ')');
      assertEquals((short) (-1), short0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Range range0 = new Range(29);
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.addElement(range0);
      CDSFeature cDSFeature0 = new CDSFeature(true, rangeVector0, 3, 29, "Index not found for File '");
      cDSFeature0.lastBase = 4436;
      cDSFeature0.intronlength = 58;
      short short0 = VCFRecord.checkSyn(cDSFeature0, 29, ')');
      assertEquals((short) (-1), short0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Range range0 = new Range(29);
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.addElement(range0);
      CDSFeature cDSFeature0 = new CDSFeature(true, rangeVector0, 3, 29, "Index not found for File '");
      cDSFeature0.lastBase = 4436;
      short short0 = VCFRecord.checkSyn(cDSFeature0, 29, ')');
      assertEquals((short) (-1), short0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Range range0 = new Range(29);
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.addElement(range0);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, 3, 29, "Index not found for File '");
      short short0 = VCFRecord.checkSyn(cDSFeature0, 15, ')');
      assertEquals((short) (-1), short0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      KeyVector keyVector0 = new KeyVector();
      vCFRecord0.setAlt("Bt%ost7;E ");
      CDSFeature cDSFeature0 = new CDSFeature(false, (RangeVector) null, 81, (-2095), "Plot number : ");
      keyVector0.add((Object) cDSFeature0);
      short short0 = vCFRecord0.getSynFlag(keyVector0, 8912);
      assertEquals((short)3, short0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      CDSFeature cDSFeature0 = new CDSFeature(false, (RangeVector) null, 8912, 8912, "2vYW_D9ZE'&q%1");
      KeyVector keyVector0 = new KeyVector();
      vCFRecord0.setAlt("Bt%ost7;E ");
      keyVector0.add((Object) cDSFeature0);
      short short0 = vCFRecord0.getSynFlag(keyVector0, 8912);
      assertEquals((short)3, short0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      KeyVector keyVector0 = new KeyVector();
      // Undeclared exception!
      try { 
        vCFRecord0.getSynFlag(keyVector0, 8912);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setAlt("uk.ac.sanger.artemis.components.va iant.VCFRecord");
      FeatureVector featureVector0 = new FeatureVector();
      vCFRecord0.getSynFlag(featureVector0, 2147483645);
      short short0 = vCFRecord0.getSynFlag(featureVector0, 1623);
      assertEquals((short)3, short0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFilter(" ( ");
      vCFRecord0.appendFilter((String) null);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFilter("z");
      vCFRecord0.appendFilter((String) null);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFilter("");
      vCFRecord0.appendFilter("");
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFilter(":");
      vCFRecord0.appendFilter((String) null);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t=", 98);
      String string0 = vCFRecord0.getSampleDataString();
      assertEquals("=", string0);
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFormat("P&$s_?|1^");
      // Undeclared exception!
      try { 
        vCFRecord0.getFormatValues("P&$s_?|1^");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t=", 98);
      String string0 = vCFRecord0.getFormatValueForSample(" segment=", 98);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getFormatValueForSample(15);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t=", 98);
      // Undeclared exception!
      try { 
        vCFRecord0.getFormatValueForSample(18);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 18
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setInfo("");
      boolean boolean0 = vCFRecord0.containsInfoFlag("");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      // Undeclared exception!
      try { 
        vCFRecord0.getInfoValue((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t=", 98);
      vCFRecord0.containsInfoFlag("6C-s");
      String string0 = vCFRecord0.getInfoValue("=");
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      // Undeclared exception!
      try { 
        VCFRecord.split("Ii ", "Ii ", 0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      int int0 = VCFRecord.countOccurrences(";hW18:lqxrQvYUq,NEV", 'l');
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t", 3);
      vCFRecord0.getInfoValue((String) null);
      boolean boolean0 = vCFRecord0.containsInfoFlag("uk.ac.sanger.artemis.components.va iant.VCFRecord");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      boolean boolean0 = vCFRecord0.isMarkAsNewStop();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setFormat("tnu=9z[aY]\"8");
      // Undeclared exception!
      try { 
        vCFRecord0.getFormatValueForSample(3);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String[] stringArray0 = vCFRecord0.getFormatValues((String) null);
      assertNull(stringArray0);
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getID();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getRef();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setPos((-2557));
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      float float0 = vCFRecord0.getQuality();
      assertEquals(0.0F, float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = vCFRecord0.getAlt();
      assertNull(variantBase0);
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      int int0 = vCFRecord0.getPos();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test65()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setAlt("uk.ac.sanger.artemis.components.va iant.VCFRecord");
      String string0 = vCFRecord0.toString();
      assertEquals("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t", string0);
  }

  @Test(timeout = 4000)
  public void test66()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setMarkAsNewStop(true);
      boolean boolean0 = vCFRecord0.isMarkAsNewStop();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test67()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String[][] stringArray0 = vCFRecord0.getGenoTypeData();
      assertNull(stringArray0);
  }

  @Test(timeout = 4000)
  public void test68()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String string0 = vCFRecord0.getInfo();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test69()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t=", 110);
      vCFRecord0.appendFilter(" ");
  }

  @Test(timeout = 4000)
  public void test70()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String[][] stringArray0 = new String[3][2];
      vCFRecord0.setGenoTypeData(stringArray0);
      String string0 = vCFRecord0.getSampleDataString();
      assertEquals("null:null\tnull:null\tnull:null", string0);
  }

  @Test(timeout = 4000)
  public void test71()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t=", 110);
      vCFRecord0.setQuality((-116.65F));
      float float0 = vCFRecord0.getQuality();
      assertEquals((-116.65F), float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test72()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      // Undeclared exception!
      try { 
        vCFRecord0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test73()  throws Throwable  {
      VCFRecord vCFRecord0 = VCFRecord.parse("null\t0\tnull\tnull\tuk.ac.sanger.artemis.components.va iant.VCFRecord\t0.0\tnull\tnull\tnull\t=", 110);
      String string0 = vCFRecord0.getChrom();
      assertEquals("null", string0);
  }
}
