!{\src2tex{textfont=tt}}
!!****f* ABINIT/optics_paw
!! NAME
!! optics_paw
!!
!! FUNCTION
!! Output routine for the outscfcv.F90 routine for optical conductivity
!!
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (SM,VR,FJ,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions.
!!  cprj(natom,nspinor*mband*mkmem*nsppol)= <p_lmn|Cnk> coefficients for each WF |Cnk>
!!                                          and each |p_lmn> non-local projector
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  ecut=cut-off energy for plane wave basis sphere (Ha)
!!  fildata= name of the output file
!!  gprimd(3,3)=dimensional reciprocal space primitive translations
!!  gsc(2,mpw*nspinor*mband*mkmem*nsppol)=<g|S|c> matrix elements (S=overlap)
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  indlmn(6,lmnmax,ntypat)= array giving l,m,n,lm,ln,s for i=lmn
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  lmnmax=max. number of (l,m,n) numbers over all types of atom
!!  mband=maximum number of bands
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  mpi_enreg=informations about MPI parallelization
!!  mpsang =1+maximum angular momentum for nonlocal pseudopotentials
!!  mpw=maximum dimensioned size of npw.
!!  natom=number of atoms in cell.
!!  nattyp(ntypat)= # atoms of each type.
!!  nkpt=number of k points.
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspden=number of spin-density components
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data:
!!     %mesh_size=Dimension of radial mesh
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data:
!!     %mesh_size=Dimension of radial mesh
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!
!! OUTPUT
!!  (only writing, printing)
!!
!! SIDE EFFECTS
!!
!!
!! NOTES
!!
!! PARENTS
!!      outscfcv
!!
!! CHILDREN
!!      int_ang,nderiv_gen,simp_gen
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine optics_paw(cg,cprj,dtset,ecut,fildata,gprimd,hdr,indlmn,kg,lmnmax,&
&               mband,mkmem,mpi_enreg,mpsang,mpw,natom,nattyp,nkpt,npwarr,nspinor,nsppol,&
&               pawrad,pawtab)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13paw, except_this_one => optics_paw
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: lmnmax,mband,mkmem,mpsang,mpw,natom,nkpt,nspinor,nsppol
 real(dp),intent(in) :: ecut
 character(len=fnlen),intent(in) :: fildata
 type(MPI_type),intent(inout) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
 type(hdr_type),intent(inout) :: hdr
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,dtset%ntypat),kg(3,mpw*mkmem)
 integer,intent(in) :: nattyp(dtset%ntypat),npwarr(nkpt)
 real(dp),intent(in) :: gprimd(3,3)
 real(dp),intent(inout) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
 type(cprj_type) :: cprj(natom,nspinor*mband*mkmem*nsppol)
 type(pawrad_type),intent(in) :: pawrad(dtset%ntypat)
 type(pawtab_type),intent(in) :: pawtab(dtset%ntypat)

!Local variables-------------------------------
!scalars
 integer :: basis_size,iatom,iband,ibg,icat,icg
 integer :: idir,ii,ij_size,ikg,ikpt,ilm,ilmn,ilmn2,iln
 integer :: ip,ip1,ip2,ipw,ispinor,isppol,itypat,iwavef,j0lm,j0lmn,j0ln,jband,jj
 integer :: il,jl,jlm,jlmn,jln,jwavef,kk,klm,klmn,kln,lmn2_size,lmn_size,mesh_size
 integer :: nband_k,npw_k
 real(dp) :: cgnm1,cgnm2,intg,sum_cg,test_ij,test_ijk
 character(len=500) :: message

 !arrays
 integer,allocatable :: indlmn_(:,:)
 real(dp) :: ang_phipphj(16,16,8)
 real(dp) :: kpoint(3),kptg(3,mpw),prod_im(3),prod_re(3),tnm_im(3)
 real(dp) :: tnm_re(3),tpsi_nabla_tpsi(mband,mband,3)
 real(dp),allocatable :: dphi(:),dtphi(:),ff(:),int1(:,:),int2(:,:),phidphj(:,:)
 real(dp),allocatable :: phipphj(:,:,:),rad(:),tphidtphj(:,:)

!no_abirules
!
 type coeff_type    ! gives the phipphj
 real(dp), pointer :: phipphj(:,:,:)
 end type coeff_type
 type(coeff_type), allocatable :: typatom_fj(:)
!
 type matrix_elts
  real(dp),pointer :: eigen11(:,:,:)
  real(dp),pointer :: eigen12(:,:,:)
  real(dp),pointer :: eigen13(:,:,:)
 end type matrix_elts
 type(matrix_elts), allocatable :: psinablapsi(:)

! ************************************************************************

!DEBUG
!write(*,*)' optics_paw : enter'
!ENDDEBUG

!Compatibility tests
 if(mpi_enreg%paral_compil_kpt==1) then
  write(message, '(4a)' ) ch10,&
&  ' optics_paw: ERROR -',ch10,&
&  '  Not available with k-point parallelization !'
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if
 if (mkmem==0) then
  write(message, '(4a)' ) ch10,&
&  ' optics_paw: ERROR -',ch10,&
&  '  Not available with mkmem=0 !'
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if
 if (nspinor>1) then
  write(message, '(4a)' ) ch10,&
&  ' optics_paw: ERROR -',ch10,&
&  '  Not available with nspinor>1 !'
  call wrtout(06,message,'PERS')
  call leave_new('PERS')
 end if
 if(mpsang>=4)then
  write(message, '(a,a,a,a,a,a)' )ch10,&
&   ' optics_paw :  -',ch10,&
&   '  Not designed for angular momentum greater than 2',ch10,&
&   '  Sorry about this ...'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

 open(123,file=fildata,form='unformatted')

!------------------------------------------------------------------------------------------------
! 1 - phipphj=<phi_i|nabla|phi_j>-<tphi_i|nabla|tphi_j>
!------------------------------------------------------------------------------------------------

! 1-a Integration of the angular part : all angular integrals have been computed outside
!     Abinit and tabulated for each (l,m) value
 call int_ang(ang_phipphj)
!DEBUG
! write(79,*)'ang_phipphj'
! write(79,*) ang_phipphj
!ENDDEBUG

 allocate(typatom_fj(dtset%ntypat))
!loop on atoms type
 do itypat=1,dtset%ntypat

  mesh_size=pawrad(itypat)%mesh_size
  lmn_size=pawtab(itypat)%lmn_size
  lmn2_size=pawtab(itypat)%lmn2_size
  basis_size=pawtab(itypat)%basis_size
  ij_size=lmn_size*lmn_size

  allocate(indlmn_(6,lmnmax))
  allocate(ff(mesh_size),rad(mesh_size))
  allocate(int2(lmn_size,lmn_size),int1(lmn_size,lmn_size))
  allocate(dphi(mesh_size),dtphi(mesh_size),phidphj(mesh_size,ij_size),tphidtphj(mesh_size,ij_size))
  allocate(typatom_fj(itypat)%phipphj(lmn_size,lmn_size,3))

  indlmn_(:,:)=indlmn(:,:,itypat)
  rad(1:mesh_size)=pawrad(itypat)%rad(1:mesh_size)

! 1-b  int1=\int phi phj /r dr - \int tphi tphj /r dr
  do jln=1,basis_size
   do iln=1,basis_size
    ff(2:mesh_size)=(pawtab(itypat)%phi(2:mesh_size,iln)*pawtab(itypat)%phi(2:mesh_size,jln)&
&                   -pawtab(itypat)%tphi(2:mesh_size,iln)*pawtab(itypat)%tphi(2:mesh_size,jln))/rad(2:mesh_size)
    call deducer0(ff,mesh_size,pawrad(itypat))
    call simp_gen(intg,ff,pawrad(itypat))
    int1(iln,jln)=intg
   end do
  end do

! 1-c int2=\int phi/r d/dr(phj/r) r^2dr - \int tphi/r d/dr(tphj/r)r^2 dr
  do jln=1,basis_size

   ff(1:mesh_size)=pawtab(itypat)%phi(1:mesh_size,jln)
   call nderiv_gen(dphi,ff,1,pawrad(itypat))
   ff(1:mesh_size)=pawtab(itypat)%tphi(1:mesh_size,jln)
   call nderiv_gen(dtphi,ff,1,pawrad(itypat))

   do iln=1,basis_size
    ff(2:mesh_size)=pawtab(itypat)%phi(2:mesh_size,iln)*dphi(2:mesh_size) &
&     -pawtab(itypat)%phi (2:mesh_size,iln)*pawtab(itypat)%phi(2:mesh_size,jln)/ &
&     rad(2:mesh_size)-(pawtab(itypat)%tphi(2:mesh_size,iln)*dtphi(2:mesh_size) &
&  -pawtab(itypat)%tphi (2:mesh_size,iln)*pawtab(itypat)%tphi(2:mesh_size,jln)/rad(2:mesh_size))
    call deducer0(ff,mesh_size,pawrad(itypat))
    call simp_gen(intg,ff,pawrad(itypat))
    int2(iln,jln)=intg
   end do
  end do


! 1-c Integration of the radial part
  do jlmn=1,lmn_size
   jlm=indlmn_(4,jlmn)
   jl=indlmn_(5,jlmn)
   do ilmn=1,lmn_size
    ilm=indlmn_(4,ilmn)
    il=indlmn_(5,ilmn)
    typatom_fj(itypat)%phipphj(ilmn,jlmn,1)= int2(il,jl)*ang_phipphj(ilm,jlm,1)&
&                  + int1(il,jl)*(ang_phipphj(ilm,jlm,2)+ang_phipphj(ilm,jlm,3))
    typatom_fj(itypat)%phipphj(ilmn,jlmn,2)= int2(il,jl)*ang_phipphj(ilm,jlm,4)&
&                  + int1(il,jl)*(ang_phipphj(ilm,jlm,5)+ang_phipphj(ilm,jlm,6))
    typatom_fj(itypat)%phipphj(ilmn,jlmn,3)= int2(il,jl)*ang_phipphj(ilm,jlm,7)&
&                  + int1(il,jl)*ang_phipphj(ilm,jlm,8)
!   if(typatom_fj(itypat)%phipphj(ilmn,jlmn,3)/=0.) then
!    write(80,'(6i4,6(1x,e10.4))') ilmn,ilm,il,jlmn,jlm,jl,typatom_fj(itypat)%phipphj(ilmn,jlmn,3),int1(il,jl),int2(il,jl),ang_phipphj(ilm,jlm,7),ang_phipphj(ilm,jlm,8)
!   endif
   end do
  end do

!DEBUG
! write(80,*)'itypat,typatom_fj(itypat)%phipphj(klmn,1:3)',itypat
! do klmn=1,lmn2_size
!  write(80,*)klmn,itypat
!  write(80,*)typatom_fj(itypat)%phipphj(klmn,1),typatom_fj(itypat)%phipphj(klmn,2),typatom_fj(itypat)%phipphj(klmn,3)
! enddo
!ENDDEBUG

! 1-d operateur p=-i*nabla  -  ATTENTION phipphj is a imaginary
  typatom_fj(itypat)%phipphj=-one*typatom_fj(itypat)%phipphj

  deallocate(indlmn_,ff,rad)
  deallocate(int2,int1)
  deallocate(dphi,dtphi,phidphj,tphidtphj)

!end loop on atoms type
 end do

!---------------------------------------------------------------------------------------------
! 2 Computation of <tpsi_n|-i/nabla|tpsi_m> for each k
!---------------------------------------------------------------------------------------------
 sum_cg=0.0_dp
 allocate(psinablapsi(nkpt))

 ibg=0;icg=0
 do isppol=1,nsppol

  ikg=0
  do ikpt=1,nkpt

   kpoint(:)=dtset%kptns(:,ikpt)
   nband_k=dtset%nband(ikpt+(isppol-1)*nkpt)
   npw_k=npwarr(ikpt)
   allocate(psinablapsi(ikpt)%eigen11(2,nband_k,nband_k))
   allocate(psinablapsi(ikpt)%eigen12(2,nband_k,nband_k))
   allocate(psinablapsi(ikpt)%eigen13(2,nband_k,nband_k))

!DEBUG
!   write(6,*)'k-point coordinates'
!   write(6,'(3(2x,e12.5))')kpoint(:)
!   write(6,*)'nband_k,npw_k',nband_k,npw_k,nsppol
!ENDDEBUG

! 2-a calculation of k+G in cartesian coordinates
   do ipw=1,npw_k
    kptg(1,ipw)=(kpoint(1)+kg(1,ipw+ikg))*gprimd(1,1)&
&              +(kpoint(2)+kg(2,ipw+ikg))*gprimd(1,2)&
&              +(kpoint(3)+kg(3,ipw+ikg))*gprimd(1,3)
    kptg(2,ipw)=(kpoint(1)+kg(1,ipw+ikg))*gprimd(2,1)&
&              +(kpoint(2)+kg(2,ipw+ikg))*gprimd(2,2)&
&              +(kpoint(3)+kg(3,ipw+ikg))*gprimd(2,3)
    kptg(3,ipw)=(kpoint(1)+kg(1,ipw+ikg))*gprimd(3,1)&
&              +(kpoint(2)+kg(2,ipw+ikg))*gprimd(3,2)&
&              +(kpoint(3)+kg(3,ipw+ikg))*gprimd(3,3)
   end do !ipw

   do iband=1,nband_k
    iwavef=(iband-1)*npw_k*nspinor+icg
    do jband=1,nband_k
     jwavef=(jband-1)*npw_k*nspinor+icg
     tnm_re=zero
     tnm_im=zero
!2-b Computation of (C_nk*C_mk^*)*(k+g) in cartesian coordinates
     do ipw=1,npw_k
      cgnm1=cg(1,ipw+iwavef)*cg(1,ipw+jwavef)+cg(2,ipw+iwavef)*cg(2,ipw+jwavef)
      tnm_re(1)=tnm_re(1)+kptg(1,ipw)*cgnm1
      tnm_re(2)=tnm_re(2)+kptg(2,ipw)*cgnm1
      tnm_re(3)=tnm_re(3)+kptg(3,ipw)*cgnm1
      cgnm2=cg(1,ipw+iwavef)*cg(2,ipw+jwavef)-cg(2,ipw+iwavef)*cg(1,ipw+jwavef)
      tnm_im(1)=tnm_im(1)+kptg(1,ipw)*cgnm2
      tnm_im(2)=tnm_im(2)+kptg(2,ipw)*cgnm2
      tnm_im(3)=tnm_im(3)+kptg(3,ipw)*cgnm2
     end do !ipw
     tnm_im=two_pi*tnm_im
     tnm_re=two_pi*tnm_re

!DEBUG
!    write(81,'(i4,2x,i4,2x,i4,2x,es21.14,2x,es21.14,2x,es21.14)')&
!&               ikpt,iband,jband,tnm_re(1),tnm_re(2),tnm_re(3)
!    write(81,'(i4,2x,i4,2x,i4,2x,es21.14,2x,es21.14,2x,es21.14)')&
!&               ikpt,iband,jband,tnm_im(1),tnm_im(2),tnm_im(3)
!ENDDEBUG

!---------------------------------------------------------------------------------------------
! 3 - Computation of <psi_n|p_i><p_j|psi_m>(<phi_i|nabla|phi_j>-<tphi_i|nabla|tphi_j>)
!---------------------------------------------------------------------------------------------
     ispinor=1
     prod_im=zero
     prod_re=zero
     icat=1
     do itypat=1,dtset%ntypat
      lmn_size=pawtab(itypat)%lmn_size
      lmn2_size=pawtab(itypat)%lmn2_size
      do iatom=icat,nattyp(itypat)
       do jlmn=1,lmn_size
       do ilmn=1,lmn_size
        prod_im(1)=prod_im(1)+&
&         (cprj(iatom,iband+ibg)%cp(1,ilmn)*cprj(iatom,jband+ibg)%cp(1,jlmn)  &
&         +cprj(iatom,iband+ibg)%cp(2,ilmn)*cprj(iatom,jband+ibg)%cp(2,jlmn)) &
&         *typatom_fj(itypat)%phipphj(ilmn,jlmn,1)
!DEBUG
!       if(iband/=jband) write(81,'(5i4,3(1x,e10.4))')iband,jband,ilmn,jlmn,klmn,typatom_fj(itypat)%phipphj(ilmn,jlmn,1),prod_im(1),cprj(iatom,iband+ibg)%cpnk(1,ilmn)
!ENDDEBUG
        prod_im(2)=prod_im(2)+&
&         (cprj(iatom,iband+ibg)%cp(1,ilmn)*cprj(iatom,jband+ibg)%cp(1,jlmn)  &
&         +cprj(iatom,iband+ibg)%cp(2,ilmn)*cprj(iatom,jband+ibg)%cp(2,jlmn)) &
&         *typatom_fj(itypat)%phipphj(ilmn,jlmn,2)
        prod_im(3)=prod_im(3)+&
&         (cprj(iatom,iband+ibg)%cp(1,ilmn)*cprj(iatom,jband+ibg)%cp(1,jlmn)  &
&         +cprj(iatom,iband+ibg)%cp(2,ilmn)*cprj(iatom,jband+ibg)%cp(2,jlmn)) &
&         *typatom_fj(itypat)%phipphj(ilmn,jlmn,3)
!
       prod_re(1)=prod_re(1)+&
&         (cprj(iatom,iband+ibg)%cp(1,ilmn)*cprj(iatom,jband+ibg)%cp(2,jlmn)  &
&         -cprj(iatom,iband+ibg)%cp(2,ilmn)*cprj(iatom,jband+ibg)%cp(1,jlmn)) &
&         *typatom_fj(itypat)%phipphj(ilmn,jlmn,1)
!DEBUG
! if(iband==1.and.jband==2.and.ilmn==1.and.jlmn==5) then
!   write(79,'(5i4,6(1x,e10.4))')iatom,iband,jband,ilmn,jlmn,prod_re(1),&
!&    cprj(iatom,iband+ibg)%cp(1,ilmn),cprj(iatom,iband+ibg)%cp(2,ilmn), &
!&    typatom_fj(itypat)%phipphj(ilmn,jlmn,1),&
!&    cprj(iatom,jband+ibg)%cp(1,jlmn),cprj(iatom,jband+ibg)%cp(2,jlmn)
!ENDDEBUG
        prod_re(2)=prod_re(2)+&
&         (cprj(iatom,iband+ibg)%cp(1,ilmn)*cprj(iatom,jband+ibg)%cp(2,jlmn)  &
&         -cprj(iatom,iband+ibg)%cp(2,ilmn)*cprj(iatom,jband+ibg)%cp(1,jlmn)) &
&         *typatom_fj(itypat)%phipphj(ilmn,jlmn,2)
        prod_re(3)=prod_re(3)+&
&         (cprj(iatom,iband+ibg)%cp(1,ilmn)*cprj(iatom,jband+ibg)%cp(2,jlmn)  &
&         -cprj(iatom,iband+ibg)%cp(2,ilmn)*cprj(iatom,jband+ibg)%cp(1,jlmn)) &
&         *typatom_fj(itypat)%phipphj(ilmn,jlmn,3)

       end do !ilmn
      end do !jlmn
    end do !iatom
    icat=icat+nattyp(itypat)
    end do !itypat

    psinablapsi(ikpt)%eigen11(1,iband,jband)=-prod_re(1)+tnm_re(1)
    psinablapsi(ikpt)%eigen12(1,iband,jband)=-prod_re(2)+tnm_re(2)
    psinablapsi(ikpt)%eigen13(1,iband,jband)=-prod_re(3)+tnm_re(3)
    psinablapsi(ikpt)%eigen11(2,iband,jband)=-prod_im(1)+tnm_im(1)
    psinablapsi(ikpt)%eigen12(2,iband,jband)=-prod_im(2)+tnm_im(2)
    psinablapsi(ikpt)%eigen13(2,iband,jband)=-prod_im(3)+tnm_im(3)
!DEBUG
!    write(82,'(2i4,5(1x,e10.4))')iband,jband,prod_re(1),prod_im(1),tnm_re(1),tnm_im(1)
!ENDDEBUG

    end do ! jband
   end do !iband

   if (mkmem/=0) then
    ibg = ibg + nspinor*nband_k
    icg = icg + npw_k*nspinor*nband_k
    ikg = ikg + npw_k
   end if

!---------------------------------------------------------------------------------------------
! 4 - Write  data
!---------------------------------------------------------------------------------------------
   write(123)psinablapsi(ikpt)%eigen11
   write(123)psinablapsi(ikpt)%eigen12
   write(123)psinablapsi(ikpt)%eigen13

   end do ! ikpt
  end do !isppol
  close (123)
!
!DEBUG
! do isppol=1,nsppol
! do ikpt=1,nkpt
!  nband_k=dtset%nband(ikpt+(isppol-1)*nkpt)
!  do iband=1,nband_k
!  do jband=1,nband_k
!  write(82,*)psinablapsi(ikpt)%eigen11(1,iband,jband)&
!&           ,psinablapsi(ikpt)%eigen12(1,iband,jband),psinablapsi(ikpt)%eigen13(1,iband,jband)
!  write(82,*)psinablapsi(ikpt)%eigen11(2,iband,jband)&
!&           ,psinablapsi(ikpt)%eigen12(2,iband,jband),psinablapsi(ikpt)%eigen13(2,iband,jband)
!  enddo
!  enddo
! enddo
! enddo
!ENDDEBUG
!
  do ikpt=1,nkpt
   deallocate(psinablapsi(ikpt)%eigen11,psinablapsi(ikpt)%eigen12,psinablapsi(ikpt)%eigen13)
  end do
  do itypat=1,dtset%ntypat
   deallocate(typatom_fj(itypat)%phipphj)
  end do
  deallocate(psinablapsi)
  deallocate(typatom_fj)

!DEBUG
!write(6,*)' optics_paw : exit '
!stop
!ENDDEBUG

 end subroutine optics_paw
!!***
