# -*- Autoconf -*-
#
# Copyright (c) 2005-2007 The ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Miscellaneous macros
#



# ABI_MSG_END()
# -------------
#
# Prints a message at the end of the configure process.
#
AC_DEFUN([ABI_MSG_END],
[[cat <<EOF

Configuration complete.
You may now type "make" (or "make multi" or "make multi_alt" on a SMP machine)
to build ABINIT.

EOF
]]) # ABI_MSG_END



# ABI_MSG_FC_BUGGY(FC_TYPE)
# -------------------------
#
# Prints a message explaining why a compiler has been wrapped, or giving
# advice for its use.
#
AC_DEFUN([ABI_MSG_FC_BUGGY],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

[case "$1" in

  absoft)
   echo ""
   echo "Concerning the ABSOFT Pro Fortran compiler"
   echo "------------------------------------------"
   echo ""
   echo "Your compiler has been wrapped because it provides a non-standard"
   echo "interface."
   echo ""
   echo "Please complain to your compiler vendor, asking them to use -I"
   echo "instead of -p to search for Fortran modules."
   ;;

  intel)
   echo ""
   echo "Concerning the Intel Fortran compiler"
   echo "-------------------------------------"
   echo ""
   echo "Your compiler will work properly only if the LD_LIBRARY_PATH and"
   echo "INTEL_LICENSE_FILE environment variables are correctly set-up."
   echo "Please make sure that this is the case before building ABINIT."
   echo ""
   echo "If you don't know what this is all about, please refer to the Intel"
   echo "documentation or ask your system administrator."
   ;;

  ibm)
   echo ""
   echo "Concerning the IBM XL Fortran compiler"
   echo "--------------------------------------"
   echo ""
   echo "Your compiler has been wrapped because it is unable to include"
   echo "files for preprocessing, and because its preprocessing interface"
   echo "itself is highly non-standard."
   echo ""
   echo "Please complain to your compiler vendor, asking them to implement"
   echo "a standard interface for preprocessing."
   ;;

 esac
]]) # ABI_MSG_FC_BUGGY



# ABI_MSG_SECTION(TITLE)
# ----------------------
#
# Prints a nice title for each section.
#
AC_DEFUN([ABI_MSG_SECTION],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 abi_sec_title="$1"

 dnl Calculate amount of space chars needed for pretty-printing
 abi_sec_spaces="                                                                      "
 abi_sec_tmp="${abi_sec_title}"
 while test "${abi_sec_tmp}" != ""; do
  abi_sec_spaces=`echo "${abi_sec_spaces}" | sed -e 's/^.//'`
  abi_sec_tmp=`echo "${abi_sec_tmp}" | sed -e 's/^.//'`
 done

 echo ""
 echo " =============================================================================="
 echo " === ${abi_sec_title}${abi_sec_spaces} ==="
 echo " =============================================================================="
 echo ""
]) # ABI_MSG_SECTION
