/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.security;

import amazon.fws.clicommando.security.ConsoleInputMaskingThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class MaskedValueConsoleInput {
    public static final String readValue(InputStream in, String prompt, int maxInputSize) throws IOException, InterruptedException {
        ConsoleInputMaskingThread consoleInputMaskingThread = new ConsoleInputMaskingThread(prompt);
        Thread maskingThread = new Thread(consoleInputMaskingThread);
        maskingThread.setPriority(5);
        maskingThread.start();
        consoleInputMaskingThread.printMaskSequence();
        PushbackInputStream pin = new PushbackInputStream(System.in);
        MaskedValueConsoleInput.blockUntilWritingToConsoleIsFinished(pin, maskingThread);
        return MaskedValueConsoleInput.readFromConsole(pin, maxInputSize);
    }

    private static void blockUntilWritingToConsoleIsFinished(PushbackInputStream pin, Thread maskingThread) throws IOException, InterruptedException {
        int firstChar = -1;
        firstChar = pin.read();
        maskingThread.interrupt();
        maskingThread.join();
        if (firstChar == -1) {
            throw new RuntimeException("No data read");
        }
        if (System.out.checkError()) {
            throw new RuntimeException("Error writing to console");
        }
        pin.unread(firstChar);
    }

    private static String readFromConsole(PushbackInputStream pin, int maxInputSize) throws IOException {
        int inChar;
        char[] buf = new char[maxInputSize];
        int location = -1;
        while (!MaskedValueConsoleInput.EOI(inChar = pin.read())) {
            if (inChar == 13) {
                int nextChar = pin.read();
                if (MaskedValueConsoleInput.EOI(nextChar)) break;
                pin.unread(nextChar);
                continue;
            }
            buf[++location] = (char)inChar;
            if (location != maxInputSize) continue;
        }
        if (location < 0) {
            return null;
        }
        return String.valueOf(buf, 0, location + 1);
    }

    private static boolean EOI(int inChar) {
        return inChar == -1 || inChar == 10;
    }
}

