#include "encoding_trad_chinese.h"

#include "core/encoding.h"
#include "core/image.h"
#include "core/log.h"

#include <stdlib.h>
#include <string.h>

typedef struct {
    uint16_t internal;
    uint8_t utf8[3];
} chinese_entry;

static const chinese_entry codepage_to_utf8[IMAGE_FONT_MULTIBYTE_TRAD_CHINESE_MAX_CHARS] = {
    {0x8080, {0xef, 0xbc, 0x81}},
    {0x8081, {0xe6, 0xaa, 0x94}},
    {0x8082, {0xe6, 0xa1, 0x88}},
    {0x8083, {0xe6, 0x96, 0xb0}},
    {0x8084, {0xe9, 0x81, 0x8a}},
    {0x8085, {0xe6, 0x88, 0xb2}},
    {0x8086, {0xe9, 0x87, 0x8d}},
    {0x8087, {0xe7, 0x8e, 0xa9}},
    {0x8088, {0xe5, 0x9c, 0xb0}},
    {0x8089, {0xe5, 0x9c, 0x96}},
    {0x808a, {0xe8, 0xbc, 0x89}},
    {0x808b, {0xe5, 0x85, 0xa5}},
    {0x808c, {0xe5, 0x84, 0xb2}},
    {0x808d, {0xe5, 0xad, 0x98}},
    {0x808e, {0xe9, 0x9b, 0xa2}},
    {0x808f, {0xe9, 0x96, 0x8b}},
    {0x8090, {0xe9, 0x81, 0xb8}},
    {0x8091, {0xe9, 0xa0, 0x85}},
    {0x8092, {0xe9, 0xa1, 0xaf}},
    {0x8093, {0xe7, 0xa4, 0xba}},
    {0x8094, {0xe8, 0xa8, 0xad}},
    {0x8095, {0xe5, 0xae, 0x9a}},
    {0x8096, {0xe9, 0x9f, 0xb3}},
    {0x8097, {0xe6, 0x95, 0x88}},
    {0x8098, {0xe9, 0x80, 0x9f}},
    {0x8099, {0xe5, 0xba, 0xa6}},
    {0x809a, {0xe5, 0x95, 0x93}},
    {0x809b, {0xe5, 0x8b, 0x95}},
    {0x809c, {0xe8, 0x87, 0xaa}},
    {0x809d, {0xe6, 0xb8, 0x85}},
    {0x809e, {0xe9, 0x99, 0xa4}},
    {0x809f, {0xe9, 0x97, 0x9c}},
    {0x80a0, {0xe9, 0x96, 0x89}},
    {0x80a1, {0xe8, 0xaa, 0xaa}},
    {0x80a2, {0xe6, 0x98, 0x8e}},
    {0x80a3, {0xe6, 0xbb, 0x91}},
    {0x80a4, {0xe9, 0xbc, 0xa0}},
    {0x80a5, {0xe9, 0x83, 0xa8}},
    {0x80a6, {0xe4, 0xbb, 0xbd}},
    {0x80a7, {0xe5, 0xae, 0x8c}},
    {0x80a8, {0xe6, 0x95, 0xb4}},
    {0x80a9, {0xe8, 0xad, 0xa6}},
    {0x80aa, {0xe5, 0x91, 0x8a}},
    {0x80ab, {0xe6, 0x96, 0xbc}},
    {0x80ac, {0xe9, 0xa1, 0xa7}},
    {0x80ad, {0xe5, 0x95, 0x8f}},
    {0x80ae, {0xe5, 0x8b, 0x9e}},
    {0x80af, {0xe5, 0xb7, 0xa5}},
    {0x80b0, {0xe8, 0xbb, 0x8d}},
    {0x80b1, {0xe9, 0x9a, 0x8a}},
    {0x80b2, {0xe7, 0x9a, 0x87}},
    {0x80b3, {0xe5, 0xb8, 0x9d}},
    {0x80b4, {0xe8, 0xa9, 0x95}},
    {0x80b5, {0xe5, 0x83, 0xb9}},
    {0x80b6, {0xe8, 0xb2, 0xbf}},
    {0x80b7, {0xe6, 0x98, 0x93}},
    {0x80b8, {0xe4, 0xba, 0xba}},
    {0x80b9, {0xe5, 0x8f, 0xa3}},
    {0x80ba, {0xe5, 0x81, 0xa5}},
    {0x80bb, {0xe5, 0xba, 0xb7}},
    {0x80bc, {0xe6, 0x95, 0x99}},
    {0x80bd, {0xe8, 0x82, 0xb2}},
    {0x80be, {0xe5, 0xa8, 0x9b}},
    {0x80bf, {0xe6, 0xa8, 0x82}},
    {0x80c0, {0xe5, 0xae, 0x97}},
    {0x80c1, {0xe8, 0xb2, 0xa1}},
    {0x80c2, {0xe6, 0x94, 0xbf}},
    {0x80c3, {0xe4, 0xb8, 0xbb}},
    {0x80c4, {0xe8, 0xa6, 0x81}},
    {0x80c5, {0xe7, 0xbe, 0x85}},
    {0x80c6, {0xe9, 0xa6, 0xac}},
    {0x80c7, {0xe5, 0x9c, 0x8b}},
    {0x80c8, {0xe5, 0x97, 0x8e}},
    {0x80c9, {0xef, 0xbc, 0x9f}},
    {0x80ca, {0xe8, 0xb7, 0xaf}},
    {0x80cb, {0xe7, 0xb7, 0x9a}},
    {0x80cc, {0xe4, 0xbb, 0x98}},
    {0x80cd, {0xe9, 0x8c, 0xa2}},
    {0x80ce, {0xe9, 0x80, 0x99}},
    {0x80cf, {0xe6, 0xa2, 0x9d}},
    {0x80d0, {0xe7, 0x9a, 0x84}},
    {0x80d1, {0xe6, 0xb1, 0x82}},
    {0x80d2, {0xe5, 0x88, 0x86}},
    {0x80d3, {0xe7, 0x99, 0xbc}},
    {0x80d4, {0xe8, 0xb2, 0xa8}},
    {0x80d5, {0xe7, 0x89, 0xa9}},
    {0x80d6, {0xe4, 0xbd, 0xa0}},
    {0x80d7, {0xe5, 0x80, 0x89}},
    {0x80d8, {0xe5, 0xba, 0xab}},
    {0x80d9, {0xe8, 0xa3, 0xa1}},
    {0x80da, {0xe6, 0xb2, 0x92}},
    {0x80db, {0xe6, 0x9c, 0x89}},
    {0x80dc, {0xe8, 0xb6, 0xb3}},
    {0x80dd, {0xe5, 0xa4, 0xa0}},
    {0x80de, {0xe5, 0x8f, 0xaf}},
    {0x80df, {0xe4, 0xbe, 0x9b}},
    {0x80e0, {0xe6, 0xb4, 0xbe}},
    {0x80e1, {0xe9, 0x81, 0xa3}},
    {0x80e2, {0xe5, 0x91, 0xbd}},
    {0x80e3, {0xe4, 0xbb, 0xa4}},
    {0x80e4, {0xe4, 0xba, 0x8b}},
    {0x80e5, {0xe4, 0xb8, 0x80}},
    {0x80e6, {0xe4, 0xba, 0x9b}},
    {0x80e7, {0xe7, 0x8f, 0xbe}},
    {0x80e8, {0xe5, 0xbd, 0xb9}},
    {0x80e9, {0xe5, 0xbe, 0x9e}},
    {0x80ea, {0xe6, 0x9c, 0x8d}},
    {0x80eb, {0xe5, 0x8b, 0x99}},
    {0x80ec, {0xe6, 0x8f, 0xb4}},
    {0x80ed, {0xe7, 0xa0, 0xb4}},
    {0x80ee, {0xe5, 0xa3, 0x9e}},
    {0x80ef, {0xe5, 0xa1, 0x9e}},
    {0x80f0, {0xe7, 0xa2, 0xba}},
    {0x80f1, {0xe5, 0x80, 0x8b}},
    {0x80f2, {0xe5, 0x85, 0x89}},
    {0x80f3, {0xe7, 0xa2, 0x9f}},
    {0x80f4, {0xe8, 0xab, 0x8b}},
    {0x80f5, {0xe5, 0xb0, 0x87}},
    {0x80f6, {0xe3, 0x80, 0x8c}},
    {0x80f7, {0xe5, 0x87, 0xb1}},
    {0x80f8, {0xe6, 0x92, 0x92}},
    {0x80f9, {0xe5, 0xa4, 0xa7}},
    {0x80fa, {0xe3, 0x80, 0x8d}},
    {0x80fb, {0xe6, 0x94, 0xbe}},
    {0x80fc, {0xe9, 0x80, 0xb2}},
    {0x80fd, {0xe6, 0xa9, 0x9f}},
    {0x80fe, {0xe4, 0xb8, 0xad}},
    {0x80ff, {0xe6, 0x91, 0xa7}},
    {0x8180, {0xe6, 0xaf, 0x80}},
    {0x8181, {0xe5, 0xba, 0xa7}},
    {0x8182, {0xe6, 0xa9, 0x8b}},
    {0x8183, {0xe6, 0xa8, 0x91}},
    {0x8184, {0xe5, 0xb0, 0x8f}},
    {0x8185, {0xe5, 0xbf, 0x83}},
    {0x8186, {0xe6, 0x8b, 0x86}},
    {0x8187, {0xe3, 0x80, 0x82}},
    {0x8188, {0xe5, 0xa6, 0x82}},
    {0x8189, {0xe6, 0x9e, 0x9c}},
    {0x818a, {0xe7, 0x8d, 0xa8}},
    {0x818b, {0xe7, 0xab, 0x8b}},
    {0x818c, {0xe7, 0xa4, 0xbe}},
    {0x818d, {0xe5, 0x8d, 0x80}},
    {0x818e, {0xe8, 0xa2, 0xab}},
    {0x818f, {0xe9, 0x9a, 0x94}},
    {0x8190, {0xe9, 0x80, 0x9a}},
    {0x8191, {0xe5, 0xbe, 0x80}},
    {0x8192, {0xe9, 0x81, 0x93}},
    {0x8193, {0xe4, 0xb9, 0x8b}},
    {0x8194, {0xe5, 0xa4, 0x96}},
    {0x8195, {0xef, 0xbc, 0x8c}},
    {0x8196, {0xe5, 0xae, 0x83}},
    {0x8197, {0xe5, 0x80, 0x91}},
    {0x8198, {0xe5, 0xbe, 0x88}},
    {0x8199, {0xe5, 0xbf, 0xab}},
    {0x819a, {0xe5, 0xb0, 0xb1}},
    {0x819b, {0xe6, 0x9c, 0x83}},
    {0x819c, {0xe6, 0xb6, 0x88}},
    {0x819d, {0xe5, 0xa4, 0xb1}},
    {0x819e, {0xe8, 0xb7, 0x9d}},
    {0x819f, {0xe6, 0x88, 0xb0}},
    {0x81a0, {0xe6, 0x95, 0x97}},
    {0x81a1, {0xe6, 0x9c, 0x88}},
    {0x81a2, {0xe5, 0x8b, 0x9d}},
    {0x81a3, {0xe5, 0x88, 0xa9}},
    {0x81a4, {0xe8, 0xa6, 0x86}},
    {0x81a5, {0xe5, 0xb1, 0xa4}},
    {0x81a6, {0xe7, 0xb7, 0xa8}},
    {0x81a7, {0xe8, 0xbc, 0xaf}},
    {0x81a8, {0xe5, 0x99, 0xa8}},
    {0x81a9, {0xe9, 0x8a, 0x80}},
    {0x81aa, {0xe5, 0xb9, 0xa3}},
    {0x81ab, {0xe6, 0xb0, 0x91}},
    {0x81ac, {0xe7, 0xa9, 0x80}},
    {0x81ad, {0xe5, 0xb9, 0xb4}},
    {0x81ae, {0xe5, 0x96, 0xae}},
    {0x81af, {0xe4, 0xbd, 0x8d}},
    {0x81b0, {0xe9, 0x9b, 0x87}},
    {0x81b1, {0xe6, 0x9b, 0xb4}},
    {0x81b2, {0xe5, 0xa4, 0x9a}},
    {0x81b3, {0xe5, 0xad, 0xb8}},
    {0x81b4, {0xe6, 0xa0, 0xa1}},
    {0x81b5, {0xe6, 0x9b, 0xb8}},
    {0x81b6, {0xe9, 0xa4, 0xa8}},
    {0x81b7, {0xe6, 0xbe, 0xa1}},
    {0x81b8, {0xe5, 0xa0, 0x82}},
    {0x81b9, {0xe7, 0x90, 0x86}},
    {0x81ba, {0xe9, 0xab, 0xae}},
    {0x81bb, {0xe5, 0xba, 0x97}},
    {0x81bc, {0xe8, 0xa8, 0xba}},
    {0x81bd, {0xe6, 0x89, 0x80}},
    {0x81be, {0xe9, 0x86, 0xab}},
    {0x81bf, {0xe9, 0x99, 0xa2}},
    {0x81c0, {0xe7, 0xa5, 0x9e}},
    {0x81c1, {0xe5, 0x96, 0xbb}},
    {0x81c2, {0xe5, 0x9c, 0x93}},
    {0x81c3, {0xe5, 0xbd, 0xa2}},
    {0x81c4, {0xe5, 0x8a, 0x87}},
    {0x81c5, {0xe5, 0xa0, 0xb4}},
    {0x81c6, {0xe7, 0xab, 0xb6}},
    {0x81c7, {0xe6, 0x8a, 0x80}},
    {0x81c8, {0xe8, 0xa1, 0x93}},
    {0x81c9, {0xe8, 0xa8, 0x8a}},
    {0x81ca, {0xe6, 0x81, 0xaf}},
    {0x81cb, {0xe5, 0xa4, 0xa9}},
    {0x81cc, {0xe5, 0xa3, 0xab}},
    {0x81cd, {0xe5, 0x85, 0xb5}},
    {0x81ce, {0xe7, 0x89, 0x88}},
    {0x81cf, {0xe6, 0x9c, 0xac}},
    {0x81d0, {0xe6, 0xac, 0x8a}},
    {0x81d1, {0xe4, 0xbb, 0xbb}},
    {0x81d2, {0xe5, 0xba, 0x9c}},
    {0x81d3, {0xe5, 0xae, 0x98}},
    {0x81d4, {0xe6, 0x88, 0x91}},
    {0x81d5, {0xe6, 0x99, 0xaf}},
    {0x81d6, {0xe5, 0x85, 0xa7}},
    {0x81d7, {0xe7, 0x89, 0xb2}},
    {0x81d8, {0xe7, 0x95, 0x9c}},
    {0x81d9, {0xe6, 0xbc, 0x81}},
    {0x81da, {0xe9, 0xa1, 0x9e}},
    {0x81db, {0xe4, 0xbe, 0xb5}},
    {0x81dc, {0xe8, 0x80, 0x85}},
    {0x81dd, {0xe7, 0x82, 0xba}},
    {0x81de, {0xe9, 0xa0, 0x90}},
    {0x81df, {0xe5, 0x82, 0x99}},
    {0x81e0, {0xe8, 0xb3, 0x87}},
    {0x81e1, {0xe6, 0x96, 0x99}},
    {0x81e2, {0xe8, 0xbf, 0x94}},
    {0x81e3, {0xe5, 0x9b, 0x9e}},
    {0x81e4, {0xe5, 0x89, 0x8d}},
    {0x81e5, {0xe9, 0xa1, 0x8c}},
    {0x81e6, {0xe8, 0xa7, 0xa3}},
    {0x81e7, {0xe6, 0xb1, 0xba}},
    {0x81e8, {0xe7, 0xb3, 0xa7}},
    {0x81e9, {0xe9, 0xa3, 0x9f}},
    {0x81ea, {0xe9, 0x87, 0x8f}},
    {0x81eb, {0xe9, 0x81, 0x8e}},
    {0x81ec, {0xe4, 0xbd, 0x8e}},
    {0x81ed, {0xe6, 0x98, 0xaf}},
    {0x81ee, {0xe9, 0xab, 0x98}},
    {0x81ef, {0xe6, 0xa5, 0xad}},
    {0x81f0, {0xe7, 0x8e, 0x87}},
    {0x81f1, {0xe7, 0xa8, 0x85}},
    {0x81f2, {0xe8, 0x96, 0xaa}},
    {0x81f3, {0xe7, 0xb4, 0x9a}},
    {0x81f4, {0xe6, 0x88, 0xbf}},
    {0x81f5, {0xe5, 0xb1, 0x8b}},
    {0x81f6, {0xe5, 0xb1, 0x85}},
    {0x81f7, {0xe9, 0x9c, 0x80}},
    {0x81f8, {0xe8, 0xbc, 0x83}},
    {0x81f9, {0xe5, 0xa5, 0xbd}},
    {0x81fa, {0xe7, 0x94, 0x9f}},
    {0x81fb, {0xe6, 0xb4, 0xbb}},
    {0x81fc, {0xe7, 0x92, 0xb0}},
    {0x81fd, {0xe5, 0xa2, 0x83}},
    {0x81fe, {0xe6, 0x8c, 0x89}},
    {0x81ff, {0xe9, 0x8d, 0xb5}},
    {0x8280, {0xe7, 0xb9, 0xbc}},
    {0x8281, {0xe7, 0xba, 0x8c}},
    {0x8282, {0xe5, 0x8f, 0xb3}},
    {0x8283, {0xe6, 0x9a, 0xab}},
    {0x8284, {0xe5, 0x81, 0x9c}},
    {0x8285, {0xef, 0xbc, 0x88}},
    {0x8286, {0xef, 0xbc, 0x89}},
    {0x8287, {0xe5, 0x8f, 0x96}},
    {0x8288, {0xe5, 0xb1, 0x95}},
    {0x8289, {0xe7, 0x84, 0xa1}},
    {0x828a, {0xe6, 0xad, 0xa4}},
    {0x828b, {0xe5, 0x8a, 0x9f}},
    {0x828c, {0xe8, 0x83, 0xbd}},
    {0x828d, {0xe5, 0xa7, 0x8b}},
    {0x828e, {0xe8, 0x88, 0xac}},
    {0x828f, {0xe5, 0x8d, 0xb1}},
    {0x8290, {0xe6, 0xb0, 0xb4}},
    {0x8291, {0xe5, 0x95, 0x86}},
    {0x8292, {0xe9, 0x98, 0xb2}},
    {0x8293, {0xe7, 0x8a, 0xaf}},
    {0x8294, {0xe7, 0xbd, 0xaa}},
    {0x8295, {0xe9, 0xab, 0x94}},
    {0x8296, {0xe8, 0xb3, 0xbd}},
    {0x8297, {0xe6, 0x94, 0xb6}},
    {0x8298, {0xe6, 0xbb, 0xbf}},
    {0x8299, {0xe6, 0x84, 0x8f}},
    {0x829a, {0xe5, 0x8e, 0x9f}},
    {0x829b, {0xe4, 0xbd, 0x8f}},
    {0x829c, {0xe6, 0x8e, 0xa5}},
    {0x829d, {0xe5, 0x8f, 0x97}},
    {0x829e, {0xe6, 0x8b, 0x92}},
    {0x829f, {0xe7, 0xb5, 0x95}},
    {0x82a0, {0xe5, 0xbe, 0x97}},
    {0x82a1, {0xe5, 0xbb, 0xba}},
    {0x82a2, {0xe7, 0xaf, 0x89}},
    {0x82a3, {0xe6, 0x8e, 0xa7}},
    {0x82a4, {0xe5, 0x88, 0xb6}},
    {0x82a5, {0xe5, 0x87, 0x88}},
    {0x82a6, {0xe5, 0x80, 0xbc}},
    {0x82a7, {0xe9, 0x9a, 0xa8}},
    {0x82a8, {0xe7, 0x95, 0xab}},
    {0x82a9, {0xe2, 0x80, 0x93}},
    {0x82aa, {0xe5, 0xbd, 0xb1}},
    {0x82ab, {0xe9, 0x9f, 0xbf}},
    {0x82ac, {0xe5, 0x8a, 0x9b}},
    {0x82ad, {0xe5, 0x9f, 0x8e}},
    {0x82ae, {0xe5, 0xa2, 0xbb}},
    {0x82af, {0xe7, 0xb6, 0xb2}},
    {0x82b0, {0xe5, 0x9f, 0x9f}},
    {0x82b1, {0xe5, 0x8c, 0x97}},
    {0x82b2, {0xe6, 0x9d, 0xb1}},
    {0x82b3, {0xe5, 0x8d, 0x97}},
    {0x82b4, {0xe8, 0xa5, 0xbf}},
    {0x82b5, {0xe5, 0x90, 0xa6}},
    {0x82b6, {0xe5, 0xbf, 0x85}},
    {0x82b7, {0xe9, 0xa0, 0x88}},
    {0x82b8, {0xe5, 0x9c, 0xa8}},
    {0x82b9, {0xe9, 0x97, 0x8a}},
    {0x82ba, {0xe4, 0xb8, 0x8a}},
    {0x82bb, {0xe6, 0xba, 0x90}},
    {0x82bc, {0xe8, 0x80, 0x97}},
    {0x82bd, {0xe7, 0x9b, 0xa1}},
    {0x82be, {0xe5, 0x8f, 0xaa}},
    {0x82bf, {0xe6, 0x93, 0x81}},
    {0x82c0, {0xe6, 0xa3, 0x9f}},
    {0x82c1, {0xe5, 0xae, 0x85}},
    {0x82c2, {0xe9, 0x80, 0xa3}},
    {0x82c3, {0xe6, 0x9c, 0xaa}},
    {0x82c4, {0xe9, 0x82, 0x8a}},
    {0x82c5, {0xe4, 0xb8, 0x8d}},
    {0x82c6, {0xe6, 0x8f, 0x90}},
    {0x82c7, {0xe5, 0xb0, 0x9a}},
    {0x82c8, {0xe5, 0x85, 0xa9}},
    {0x82c9, {0xe8, 0xbb, 0x8a}},
    {0x82ca, {0xe7, 0x9f, 0xb3}},
    {0x82cb, {0xe6, 0x89, 0x8d}},
    {0x82cc, {0xe8, 0x88, 0x88}},
    {0x82cd, {0xe5, 0xbb, 0x9f}},
    {0x82ce, {0xe5, 0xb8, 0x82}},
    {0x82cf, {0xe7, 0x94, 0xa8}},
    {0x82d0, {0xe4, 0xbb, 0x96}},
    {0x82d1, {0xe7, 0x94, 0xa2}},
    {0x82d2, {0xe9, 0x80, 0xa0}},
    {0x82d3, {0xe4, 0xbb, 0xa5}},
    {0x82d4, {0xe9, 0x85, 0x8d}},
    {0x82d5, {0xe8, 0xbe, 0xb2}},
    {0x82d6, {0xe5, 0xb0, 0x8b}},
    {0x82d7, {0xe6, 0x89, 0xbe}},
    {0x82d8, {0xe9, 0xbb, 0x83}},
    {0x82d9, {0xe8, 0x89, 0xb2}},
    {0x82da, {0xe8, 0x8d, 0x89}},
    {0x82db, {0xe5, 0x8f, 0xa2}},
    {0x82dc, {0xe9, 0xbb, 0x8f}},
    {0x82dd, {0xe5, 0x9c, 0x9f}},
    {0x82de, {0xe5, 0x9d, 0x91}},
    {0x82df, {0xe5, 0xb2, 0xa9}},
    {0x82e0, {0xe6, 0x97, 0x81}},
    {0x82e1, {0xe6, 0xa8, 0xb9}},
    {0x82e2, {0xe6, 0x9c, 0xa8}},
    {0x82e3, {0xe6, 0x9d, 0x90}},
    {0x82e4, {0xe6, 0xb2, 0xbf}},
    {0x82e5, {0xe8, 0x91, 0x97}},
    {0x82e6, {0xe6, 0xb2, 0xb3}},
    {0x82e7, {0xe5, 0xb2, 0xb8}},
    {0x82e8, {0xe9, 0x81, 0xa9}},
    {0x82e9, {0xe5, 0x90, 0x88}},
    {0x82ea, {0xe9, 0xbb, 0x9e}},
    {0x82eb, {0xe9, 0x90, 0xb5}},
    {0x82ec, {0xe7, 0xa4, 0xa6}},
    {0x82ed, {0xe8, 0x91, 0xa1}},
    {0x82ee, {0xe8, 0x90, 0x84}},
    {0x82ef, {0xe6, 0xa9, 0x84}},
    {0x82f0, {0xe6, 0xac, 0x96}},
    {0x82f1, {0xe9, 0x99, 0xb6}},
    {0x82f2, {0xe4, 0xbe, 0xbf}},
    {0x82f3, {0xe6, 0x8c, 0x87}},
    {0x82f4, {0xe5, 0x9c, 0x92}},
    {0x82f5, {0xe5, 0x88, 0xb0}},
    {0x82f6, {0xe8, 0xa3, 0x9d}},
    {0x82f7, {0xe8, 0xb2, 0xaf}},
    {0x82f8, {0xe6, 0xb1, 0xa0}},
    {0x82f9, {0xe9, 0x81, 0x8b}},
    {0x82fa, {0xe4, 0xbd, 0x9c}},
    {0x82fb, {0xe5, 0x87, 0xba}},
    {0x82fc, {0xe5, 0xb7, 0xa1}},
    {0x82fd, {0xe9, 0x82, 0x8f}},
    {0x82fe, {0xe7, 0x87, 0x9f}},
    {0x82ff, {0xe6, 0x87, 0x89}},
    {0x8380, {0xe6, 0xad, 0xa6}},
    {0x8381, {0xe6, 0xbc, 0x94}},
    {0x8382, {0xe5, 0x93, 0xa1}},
    {0x8383, {0xe5, 0x9f, 0xb9}},
    {0x8384, {0xe8, 0xa8, 0x93}},
    {0x8385, {0xe4, 0xbe, 0x86}},
    {0x8386, {0xe9, 0xac, 0xa5}},
    {0x8387, {0xe8, 0xa1, 0xa8}},
    {0x8388, {0xe7, 0x8d, 0x85}},
    {0x8389, {0xe6, 0xac, 0x84}},
    {0x838a, {0xe8, 0x88, 0x89}},
    {0x838b, {0xe8, 0xa1, 0x8c}},
    {0x838c, {0xe6, 0xaf, 0x94}},
    {0x838d, {0xe8, 0xa9, 0xa6}},
    {0x838e, {0xe5, 0x8e, 0x9a}},
    {0x838f, {0xe5, 0xa1, 0x94}},
    {0x8390, {0xe8, 0x88, 0x87}},
    {0x8391, {0xe6, 0x95, 0xb5}},
    {0x8392, {0xe8, 0xbf, 0x91}},
    {0x8393, {0xe6, 0xb0, 0xa3}},
    {0x8394, {0xe6, 0xb3, 0x95}},
    {0x8395, {0xe5, 0xb7, 0xb1}},
    {0x8396, {0xe6, 0xaf, 0x8f}},
    {0x8397, {0xe9, 0x99, 0xb8}},
    {0x8398, {0xe6, 0xb9, 0x96}},
    {0x8399, {0xe6, 0xb5, 0xb7}},
    {0x839a, {0xe6, 0xb4, 0x8b}},
    {0x839b, {0xe8, 0xa6, 0x96}},
    {0x839c, {0xe7, 0xaa, 0x97}},
    {0x839d, {0xe6, 0xa8, 0xa1}},
    {0x839e, {0xe5, 0xbc, 0x8f}},
    {0x839f, {0xe7, 0x99, 0xbb}},
    {0x83a0, {0xe5, 0x8d, 0xa1}},
    {0x83a1, {0xe5, 0xb8, 0x83}},
    {0x83a2, {0xe4, 0xba, 0x9e}},
    {0x83a3, {0xe6, 0x9e, 0x97}},
    {0x83a4, {0xe5, 0xba, 0x95}},
    {0x83a5, {0xe5, 0xb8, 0x8c}},
    {0x83a6, {0xe8, 0x8e, 0xab}},
    {0x83a7, {0xe8, 0xbf, 0xaa}},
    {0x83a8, {0xe6, 0xad, 0x90}},
    {0x83a9, {0xe8, 0xbf, 0xa6}},
    {0x83aa, {0xe5, 0xa4, 0xaa}},
    {0x83ab, {0xe5, 0x9f, 0xba}},
    {0x83ac, {0xc2, 0xb7}},
    {0x83ad, {0xe8, 0xab, 0xbe}},
    {0x83ae, {0xe7, 0x93, 0xa6}},
    {0x83af, {0xe6, 0xb4, 0x9b}},
    {0x83b0, {0xe9, 0x9b, 0x85}},
    {0x83b1, {0xe5, 0x85, 0xb8}},
    {0x83b2, {0xe7, 0x99, 0xbd}},
    {0x83b3, {0xe5, 0x8a, 0xa0}},
    {0x83b4, {0xe5, 0xad, 0x9f}},
    {0x83b5, {0xe9, 0x82, 0xa3}},
    {0x83b6, {0xe6, 0x96, 0xaf}},
    {0x83b7, {0xe7, 0x91, 0x9f}},
    {0x83b8, {0xe6, 0x8b, 0x89}},
    {0x83b9, {0xe6, 0x99, 0xae}},
    {0x83ba, {0xe7, 0x91, 0xaa}},
    {0x83bb, {0xe6, 0xa0, 0xbc}},
    {0x83bc, {0xe4, 0xb8, 0x81}},
    {0x83bd, {0xe5, 0x90, 0x89}},
    {0x83be, {0xe7, 0xa7, 0x91}},
    {0x83bf, {0xe8, 0x8c, 0x83}},
    {0x83c0, {0xe5, 0x80, 0xab}},
    {0x83c1, {0xe5, 0xbc, 0x97}},
    {0x83c2, {0xe7, 0xbe, 0x8e}},
    {0x83c3, {0xe9, 0x87, 0x8c}},
    {0x83c4, {0xe5, 0x8f, 0xb8}},
    {0x83c5, {0xe5, 0xb0, 0xbc}},
    {0x83c6, {0xe5, 0xae, 0x89}},
    {0x83c7, {0xe9, 0x98, 0xbf}},
    {0x83c8, {0xe5, 0xa5, 0xa7}},
    {0x83c9, {0xe6, 0xb3, 0xa2}},
    {0x83ca, {0xe9, 0x9d, 0xa9}},
    {0x83cb, {0xe8, 0x80, 0xb6}},
    {0x83cc, {0xe5, 0x86, 0xb7}},
    {0x83cd, {0xe5, 0xb7, 0xb4}},
    {0x83ce, {0xe9, 0xbb, 0x8e}},
    {0x83cf, {0xe6, 0x8b, 0xbf}},
    {0x83d0, {0xe5, 0xbb, 0xac}},
    {0x83d1, {0xe6, 0xad, 0xb7}},
    {0x83d2, {0xe5, 0xb1, 0xb1}},
    {0x83d3, {0xe5, 0x8d, 0x93}},
    {0x83d4, {0xe5, 0x8f, 0xa4}},
    {0x83d5, {0xe5, 0xb4, 0x94}},
    {0x83d6, {0xe6, 0xa0, 0xb9}},
    {0x83d7, {0xe6, 0x89, 0x98}},
    {0x83d8, {0xe6, 0xb2, 0x83}},
    {0x83d9, {0xe9, 0xad, 0xaf}},
    {0x83da, {0xe9, 0x9a, 0x86}},
    {0x83db, {0xe7, 0x8b, 0x84}},
    {0x83dc, {0xe6, 0x81, 0xa9}},
    {0x83dd, {0xe6, 0x85, 0x95}},
    {0x83de, {0xe7, 0xb1, 0xb3}},
    {0x83df, {0xe6, 0x8b, 0x9c}},
    {0x83e0, {0xe5, 0x8d, 0xa0}},
    {0x83e1, {0xe5, 0xba, 0xad}},
    {0x83e2, {0xe7, 0xa9, 0xba}},
    {0x83e3, {0xe9, 0x87, 0x8e}},
    {0x83e4, {0xe5, 0x85, 0x94}},
    {0x83e5, {0xe6, 0xaf, 0x92}},
    {0x83e6, {0xe8, 0x9b, 0x87}},
    {0x83e7, {0xe6, 0xb5, 0x81}},
    {0x83e8, {0xe9, 0xad, 0x9a}},
    {0x83e9, {0xe7, 0xa8, 0xae}},
    {0x83ea, {0xe5, 0x93, 0xae}},
    {0x83eb, {0xe7, 0x8b, 0xbc}},
    {0x83ec, {0xe8, 0x8b, 0xb1}},
    {0x83ed, {0xe9, 0x9b, 0x84}},
    {0x83ee, {0xe8, 0xb1, 0xac}},
    {0x83ef, {0xe7, 0x8c, 0x9b}},
    {0x83f0, {0xe8, 0x94, 0xac}},
    {0x83f1, {0xe8, 0x8f, 0x9c}},
    {0x83f2, {0xe8, 0x82, 0x89}},
    {0x83f3, {0xe9, 0x85, 0x92}},
    {0x83f4, {0xe6, 0xb2, 0xb9}},
    {0x83f5, {0xe5, 0x82, 0xa2}},
    {0x83f6, {0xe4, 0xbf, 0xb1}},
    {0x83f7, {0xe7, 0xac, 0xac}},
    {0x83f8, {0xe9, 0x80, 0xb1}},
    {0x83f9, {0xe4, 0xba, 0x8c}},
    {0x83fa, {0xe4, 0xb8, 0x89}},
    {0x83fb, {0xe5, 0x9b, 0x9b}},
    {0x83fc, {0xe4, 0xba, 0x94}},
    {0x83fd, {0xe5, 0x85, 0xad}},
    {0x83fe, {0xe4, 0xb8, 0x83}},
    {0x83ff, {0xe5, 0x85, 0xab}},
    {0x8480, {0xe4, 0xb9, 0x9d}},
    {0x8481, {0xe5, 0x8d, 0x81}},
    {0x8482, {0xe7, 0xb4, 0x85}},
    {0x8483, {0xe8, 0x97, 0x8d}},
    {0x8484, {0xe7, 0xb6, 0xa0}},
    {0x8485, {0xe6, 0xa9, 0x98}},
    {0x8486, {0xe7, 0xb4, 0xab}},
    {0x8487, {0xe9, 0xbb, 0x91}},
    {0x8488, {0xe5, 0xbb, 0xa0}},
    {0x8489, {0xe6, 0x8c, 0x96}},
    {0x848a, {0xe6, 0x8e, 0x98}},
    {0x848b, {0xef, 0xbc, 0x91}},
    {0x848c, {0xef, 0xbc, 0x92}},
    {0x848d, {0xef, 0xbc, 0x93}},
    {0x848e, {0xef, 0xbc, 0x94}},
    {0x848f, {0xef, 0xbc, 0x95}},
    {0x8490, {0xef, 0xbc, 0x96}},
    {0x8491, {0xef, 0xbc, 0x97}},
    {0x8492, {0xef, 0xbc, 0x98}},
    {0x8493, {0xef, 0xbc, 0x99}},
    {0x8494, {0xef, 0xbc, 0x90}},
    {0x8495, {0xe5, 0xbb, 0xa3}},
    {0x8496, {0xe8, 0x8a, 0xb1}},
    {0x8497, {0xe5, 0x9e, 0x8b}},
    {0x8498, {0xe9, 0x9b, 0x95}},
    {0x8499, {0xe5, 0x83, 0x8f}},
    {0x849a, {0xe8, 0xbc, 0x94}},
    {0x849b, {0xe5, 0x8a, 0xa9}},
    {0x849c, {0xe9, 0x8f, 0xa2}},
    {0x849d, {0xe6, 0xa7, 0x8d}},
    {0x849e, {0xe9, 0xa8, 0x8e}},
    {0x849f, {0xe5, 0xb8, 0xab}},
    {0x84a0, {0xe9, 0x80, 0x81}},
    {0x84a1, {0xe5, 0xb1, 0x80}},
    {0x84a2, {0xe6, 0x8b, 0xb1}},
    {0x84a3, {0xe9, 0x96, 0x80}},
    {0x84a4, {0xe9, 0xba, 0x97}},
    {0x84a5, {0xe7, 0xb5, 0xb2}},
    {0x84a6, {0xe7, 0xb4, 0x8d}},
    {0x84a7, {0xe6, 0x95, 0xa6}},
    {0x84a8, {0xe4, 0xb8, 0x98}},
    {0x84a9, {0xe7, 0xb6, 0xad}},
    {0x84aa, {0xe8, 0x88, 0xb9}},
    {0x84ab, {0xe5, 0xa1, 0xa2}},
    {0x84ac, {0xe7, 0xa2, 0xbc}},
    {0x84ad, {0xe9, 0xa0, 0xad}},
    {0x84ae, {0xe5, 0x9f, 0xa0}},
    {0x84af, {0xe8, 0x8f, 0xaf}},
    {0x84b0, {0xe5, 0xae, 0xae}},
    {0x84b1, {0xe6, 0xae, 0xbf}},
    {0x84b2, {0xe5, 0x93, 0xa8}},
    {0x84b3, {0xe7, 0xab, 0x99}},
    {0x84b4, {0xe7, 0xa8, 0x8b}},
    {0x84b5, {0xe5, 0x85, 0x83}},
    {0x84b6, {0xe8, 0x80, 0x81}},
    {0x84b7, {0xe5, 0x85, 0xac}},
    {0x84b8, {0xe5, 0x85, 0xb1}},
    {0x84b9, {0xe9, 0x9b, 0x86}},
    {0x84ba, {0xe6, 0xb3, 0x89}},
    {0x84bb, {0xe4, 0xba, 0x95}},
    {0x84bc, {0xe7, 0x87, 0x83}},
    {0x84bd, {0xe7, 0x87, 0x92}},
    {0x84be, {0xe5, 0xbb, 0xa2}},
    {0x84bf, {0xe5, 0xa2, 0x9f}},
    {0x84c0, {0xe6, 0x8e, 0xa1}},
    {0x84c1, {0xe8, 0xa3, 0x82}},
    {0x84c2, {0xe7, 0xb8, 0xab}},
    {0x84c3, {0xe5, 0x8f, 0x8d}},
    {0x84c4, {0xe5, 0xb8, 0xb3}},
    {0x84c5, {0xe8, 0x93, 0xac}},
    {0x84c6, {0xe6, 0xa3, 0x9a}},
    {0x84c7, {0xe8, 0x88, 0x8d}},
    {0x84c8, {0xe8, 0xb1, 0xaa}},
    {0x84c9, {0xe6, 0xb6, 0xaf}},
    {0x84ca, {0xe5, 0x85, 0xb7}},
    {0x84cb, {0xe6, 0x93, 0x87}},
    {0x84cc, {0xe5, 0x90, 0x8d}},
    {0x84cd, {0xe7, 0xa8, 0xb1}},
    {0x84ce, {0xe8, 0xbc, 0xb8}},
    {0x84cf, {0xe5, 0xa7, 0x93}},
    {0x84d0, {0xe5, 0xb9, 0xb3}},
    {0x84d1, {0xe8, 0xa8, 0x98}},
    {0x84d2, {0xe5, 0x9f, 0xb7}},
    {0x84d3, {0xe6, 0x96, 0xb9}},
    {0x84d4, {0xe7, 0xb8, 0xbd}},
    {0x84d5, {0xe7, 0x9d, 0xa3}},
    {0x84d6, {0xe5, 0x87, 0xa1}},
    {0x84d7, {0xe9, 0x9d, 0x9e}},
    {0x84d8, {0xe5, 0xb8, 0xb8}},
    {0x84d9, {0xe7, 0xb0, 0xa1}},
    {0x84da, {0xe6, 0xa8, 0x99}},
    {0x84db, {0xe6, 0xba, 0x96}},
    {0x84dc, {0xe7, 0x9b, 0xb8}},
    {0x84dd, {0xe7, 0x95, 0xb6}},
    {0x84de, {0xe5, 0x9b, 0xb0}},
    {0x84df, {0xe9, 0x9b, 0xa3}},
    {0x84e0, {0xe6, 0xa5, 0xb5}},
    {0x84e1, {0xe6, 0x9c, 0x80}},
    {0x84e2, {0xe5, 0xb9, 0xbe}},
    {0x84e3, {0xe4, 0xb9, 0x8e}},
    {0x84e4, {0xe6, 0x88, 0x90}},
    {0x84e5, {0xe8, 0xbf, 0xb7}},
    {0x84e6, {0xe5, 0xb7, 0xa8}},
    {0x84e7, {0xe9, 0xbe, 0x90}},
    {0x84e8, {0xe7, 0x9b, 0x9c}},
    {0x84e9, {0xe8, 0xb3, 0x8a}},
    {0x84ea, {0xe5, 0xbc, 0xb7}},
    {0x84eb, {0xe9, 0x81, 0xa0}},
    {0x84ec, {0xe6, 0x94, 0xbb}},
    {0x84ed, {0xe6, 0x93, 0x8a}},
    {0x84ee, {0xe9, 0x8d, 0x8a}},
    {0x84ef, {0xe9, 0x87, 0x91}},
    {0x84f0, {0xe8, 0xa0, 0xbb}},
    {0x84f1, {0xe4, 0xbc, 0x8a}},
    {0x84f2, {0xe7, 0x89, 0xb9}},
    {0x84f3, {0xe8, 0x96, 0xa9}},
    {0x84f4, {0xe5, 0xa5, 0x88}},
    {0x84f5, {0xe5, 0x85, 0xb6}},
    {0x84f6, {0xe9, 0xa0, 0x93}},
    {0x84f7, {0xe8, 0x87, 0x98}},
    {0x84f8, {0xe5, 0x9f, 0x83}},
    {0x84f9, {0xe5, 0x8f, 0x8a}},
    {0x84fa, {0xe5, 0x8c, 0xb9}},
    {0x84fb, {0xe5, 0x85, 0x8b}},
    {0x84fc, {0xe7, 0x88, 0xbe}},
    {0x84fd, {0xe5, 0x88, 0x97}},
    {0x84fe, {0xe9, 0xa1, 0x9b}},
    {0x84ff, {0xe8, 0xb5, 0xab}},
    {0x8580, {0xe6, 0xad, 0x8c}},
    {0x8581, {0xe5, 0xbe, 0xb7}},
    {0x8582, {0xe5, 0x93, 0xa5}},
    {0x8583, {0xe5, 0x8c, 0x88}},
    {0x8584, {0xe5, 0xa5, 0xb4}},
    {0x8585, {0xe4, 0xbc, 0xaf}},
    {0x8586, {0xe7, 0x8c, 0xb6}},
    {0x8587, {0xe6, 0xae, 0x8a}},
    {0x8588, {0xe4, 0xbb, 0xb6}},
    {0x8589, {0xe9, 0x9c, 0x87}},
    {0x858a, {0xe6, 0x9a, 0xb4}},
    {0x858b, {0xe6, 0x8f, 0x9b}},
    {0x858c, {0xe9, 0x99, 0x8d}},
    {0x858d, {0xe6, 0xb1, 0xa1}},
    {0x858e, {0xe6, 0x9f, 0x93}},
    {0x858f, {0xe5, 0x80, 0x92}},
    {0x8590, {0xe6, 0xa6, 0xbb}},
    {0x8591, {0xe6, 0xb7, 0xb9}},
    {0x8592, {0xe4, 0xbd, 0xbf}},
    {0x8593, {0xe6, 0x99, 0x82}},
    {0x8594, {0xe9, 0x96, 0x93}},
    {0x8595, {0xe8, 0x84, 0x86}},
    {0x8596, {0xe5, 0xbc, 0xb1}},
    {0x8597, {0xe5, 0x9d, 0x87}},
    {0x8598, {0xe8, 0xa3, 0xbd}},
    {0x8599, {0xe8, 0x81, 0x9a}},
    {0x859a, {0xe8, 0x99, 0x95}},
    {0x859b, {0xe9, 0xa4, 0x8a}},
    {0x859c, {0xe5, 0x85, 0xa8}},
    {0x859d, {0xe8, 0x9e, 0xa2}},
    {0x859e, {0xe5, 0xb9, 0x95}},
    {0x859f, {0xe9, 0x9d, 0xa2}},
    {0x85a0, {0xe6, 0x9e, 0x90}},
    {0x85a1, {0xe7, 0x9c, 0x81}},
    {0x85a2, {0xe5, 0xa2, 0x9e}},
    {0x85a3, {0xe5, 0x88, 0xaa}},
    {0x85a4, {0xe8, 0xa4, 0x87}},
    {0x85a5, {0xe8, 0xb3, 0xbc}},
    {0x85a6, {0xe8, 0xb2, 0xb7}},
    {0x85a7, {0xe5, 0x85, 0x8d}},
    {0x85a8, {0xe8, 0xb2, 0xbb}},
    {0x85a9, {0xe6, 0x97, 0xa5}},
    {0x85aa, {0xe6, 0x9c, 0x9f}},
    {0x85ab, {0xe7, 0x95, 0xa5}},
    {0x85ac, {0xe7, 0x9b, 0xae}},
    {0x85ad, {0xe7, 0x8b, 0x80}},
    {0x85ae, {0xe6, 0x85, 0x8b}},
    {0x85af, {0xe6, 0x8e, 0x92}},
    {0x85b0, {0xe5, 0x94, 0xae}},
    {0x85b1, {0xe5, 0xbc, 0xb5}},
    {0x85b2, {0xe7, 0x9f, 0xad}},
    {0x85b3, {0xe5, 0x8f, 0xb2}},
    {0x85b4, {0xe3, 0x80, 0x81}},
    {0x85b5, {0xe7, 0xad, 0x89}},
    {0x85b6, {0xe8, 0xaa, 0xbf}},
    {0x85b7, {0xe6, 0x96, 0x87}},
    {0x85b8, {0xe5, 0x8c, 0x96}},
    {0x85b9, {0xe7, 0xb9, 0x81}},
    {0x85ba, {0xe6, 0xa6, 0xae}},
    {0x85bb, {0xe5, 0x92, 0x8c}},
    {0x85bc, {0xe6, 0x94, 0xaf}},
    {0x85bd, {0xe6, 0x8c, 0x81}},
    {0x85be, {0xe9, 0x99, 0x90}},
    {0x85bf, {0xe7, 0x8d, 0xb2}},
    {0x85c0, {0xe6, 0x95, 0xb8}},
    {0x85c1, {0xe5, 0x8e, 0xbb}},
    {0x85c2, {0xe6, 0x95, 0x91}},
    {0x85c3, {0xe8, 0xb2, 0xb8}},
    {0x85c4, {0xe6, 0xac, 0xbe}},
    {0x85c5, {0xe7, 0xa2, 0x91}},
    {0x85c6, {0xe7, 0xb5, 0x84}},
    {0x85c7, {0xe5, 0xa4, 0xae}},
    {0x85c8, {0xe6, 0xb2, 0x99}},
    {0x85c9, {0xe6, 0xbc, 0xa0}},
    {0x85ca, {0xe9, 0xa3, 0x84}},
    {0x85cb, {0xe6, 0xb5, 0xae}},
    {0x85cc, {0xe6, 0x93, 0xb4}},
    {0x85cd, {0xe7, 0xbd, 0xae}},
    {0x85ce, {0xe5, 0x88, 0x9d}},
    {0x85cf, {0xe6, 0xb3, 0x81}},
    {0x85d0, {0xe8, 0xb5, 0xb7}},
    {0x85d1, {0xe5, 0x83, 0x85}},
    {0x85d2, {0xe5, 0x81, 0x9a}},
    {0x85d3, {0xe6, 0x94, 0xb9}},
    {0x85d4, {0xe8, 0xae, 0x8a}},
    {0x85d5, {0xe9, 0x80, 0x94}},
    {0x85d6, {0xe6, 0x98, 0x87}},
    {0x85d7, {0xe5, 0xb0, 0x8d}},
    {0x85d8, {0xe4, 0xb8, 0x8b}},
    {0x85d9, {0xef, 0xbc, 0x9a}},
    {0x85da, {0xe9, 0x80, 0x97}},
    {0x85db, {0xe8, 0x99, 0x9f}},
    {0x85dc, {0xe5, 0x8f, 0xa5}},
    {0x85dd, {0xe8, 0xbf, 0x85}},
    {0x85de, {0xe7, 0xa7, 0xbb}},
    {0x85df, {0xe8, 0xb2, 0xa0}},
    {0x85e0, {0xe9, 0x9a, 0x8e}},
    {0x85e1, {0xe8, 0xa1, 0x9d}},
    {0x85e2, {0xe7, 0xaa, 0x81}},
    {0x85e3, {0xe8, 0xa8, 0xb1}},
    {0x85e4, {0xe5, 0x9c, 0x8d}},
    {0x85e5, {0xef, 0xbc, 0x9f}},
    {0x85e6, {0xe6, 0x8d, 0xb2}},
    {0x85e7, {0xe5, 0xb7, 0xb2}},
    {0x85e8, {0xe8, 0xaa, 0x9e}},
    {0x85e9, {0xe9, 0x81, 0x99}},
    {0x85ea, {0xe5, 0x8d, 0xb3}},
    {0x85eb, {0xe4, 0xbd, 0x94}},
    {0x85ec, {0xe5, 0xa8, 0x81}},
    {0x85ed, {0xe8, 0x84, 0x85}},
    {0x85ee, {0xe6, 0xad, 0xa3}},
    {0x85ef, {0xe7, 0xb4, 0xb0}},
    {0x85f0, {0xe7, 0xad, 0x86}},
    {0x85f1, {0xe5, 0x88, 0xb7}},
    {0x85f2, {0xe5, 0x9d, 0xa1}},
    {0x85f3, {0xe6, 0x89, 0x93}},
    {0x85f4, {0xe7, 0x81, 0x8c}},
    {0x85f5, {0xef, 0xbc, 0x8f}},
    {0x85f6, {0xe8, 0xa8, 0x88}},
    {0x85f7, {0xe5, 0x9b, 0xba}},
    {0x85f8, {0xe5, 0x84, 0xaa}},
    {0x85f9, {0xe5, 0x85, 0x88}},
    {0x85fa, {0xe9, 0xa0, 0x98}},
    {0x85fb, {0xe4, 0xbd, 0x95}},
    {0x85fc, {0xe8, 0xa9, 0xb2}},
    {0x85fd, {0xe9, 0x81, 0xad}},
    {0x85fe, {0xe5, 0xa0, 0xb1}},
    {0x85ff, {0xe6, 0x9c, 0x9d}},
    {0x8680, {0xe7, 0xb6, 0x93}},
    {0x8681, {0xe7, 0xaf, 0x84}},
    {0x8682, {0xe9, 0x9a, 0xb8}},
    {0x8683, {0xe5, 0xb1, 0xac}},
    {0x8684, {0xe9, 0x81, 0x94}},
    {0x8685, {0xe5, 0x90, 0x91}},
    {0x8686, {0xe5, 0x8d, 0x94}},
    {0x8687, {0xe6, 0x8b, 0xaf}},
    {0x8688, {0xe6, 0x8f, 0xae}},
    {0x8689, {0xe5, 0xae, 0xb9}},
    {0x868a, {0xe7, 0xb5, 0xa6}},
    {0x868b, {0xe5, 0xa5, 0x89}},
    {0x868c, {0xe7, 0x8d, 0xbb}},
    {0x868d, {0xe9, 0xa1, 0x8d}},
    {0x868e, {0xe6, 0x83, 0xb3}},
    {0x868f, {0xe9, 0x80, 0x90}},
    {0x8690, {0xe6, 0x84, 0x9f}},
    {0x8691, {0xe6, 0x82, 0x85}},
    {0x8692, {0xe6, 0x93, 0x94}},
    {0x8693, {0xe8, 0xa6, 0xba}},
    {0x8694, {0xe7, 0x9f, 0x9b}},
    {0x8695, {0xe7, 0x9b, 0xbe}},
    {0x8696, {0xe9, 0x82, 0x84}},
    {0x8697, {0xe5, 0xb7, 0xae}},
    {0x8698, {0xe8, 0xae, 0x9a}},
    {0x8699, {0xe8, 0xb3, 0x9e}},
    {0x869a, {0xe8, 0xae, 0x93}},
    {0x869b, {0xe6, 0x89, 0xbf}},
    {0x869c, {0xe7, 0xa6, 0xae}},
    {0x869d, {0xe6, 0xac, 0xa1}},
    {0x869e, {0xe6, 0xaf, 0xaf}},
    {0x869f, {0xe7, 0x8e, 0xbb}},
    {0x86a0, {0xe7, 0x92, 0x83}},
    {0x86a1, {0xe8, 0x97, 0x9d}},
    {0x86a2, {0xe5, 0x93, 0x81}},
    {0x86a3, {0xe6, 0xb4, 0xb2}},
    {0x86a4, {0xe8, 0xb1, 0xa1}},
    {0x86a5, {0xe7, 0x89, 0x99}},
    {0x86a6, {0xe7, 0xbe, 0xa4}},
    {0x86a7, {0xe8, 0xad, 0xb7}},
    {0x86a8, {0xe8, 0xa1, 0x9b}},
    {0x86a9, {0xe5, 0x8d, 0xb0}},
    {0x86aa, {0xe8, 0xb1, 0xb9}},
    {0x86ab, {0xe9, 0x95, 0xb7}},
    {0x86ac, {0xe9, 0xa0, 0xb8}},
    {0x86ad, {0xe9, 0xb9, 0xbf}},
    {0x86ae, {0xe7, 0xae, 0xb1}},
    {0x86af, {0xe5, 0xaf, 0xb6}},
    {0x86b0, {0xe8, 0xbc, 0x9b}},
    {0x86b1, {0xe6, 0x85, 0xb7}},
    {0x86b2, {0xe6, 0x85, 0xa8}},
    {0x86b3, {0xe5, 0x90, 0xa7}},
    {0x86b4, {0xe8, 0x8b, 0xa5}},
    {0x86b5, {0xe4, 0xbf, 0x9d}},
    {0x86b6, {0xe7, 0x94, 0xb1}},
    {0x86b7, {0xe7, 0xa6, 0x81}},
    {0x86b8, {0xe6, 0xad, 0xa2}},
    {0x86b9, {0xe5, 0x9b, 0xa0}},
    {0x86ba, {0xe7, 0x9b, 0xb4}},
    {0x86bb, {0xe5, 0xbf, 0x97}},
    {0x86bc, {0xe7, 0xae, 0xa1}},
    {0x86bd, {0xe5, 0xad, 0x97}},
    {0x86be, {0xe5, 0xb0, 0x91}},
    {0x86bf, {0xe6, 0x95, 0xac}},
    {0x86c0, {0xe7, 0xa5, 0x87}},
    {0x86c1, {0xe4, 0xbc, 0xb0}},
    {0x86c2, {0xe8, 0xb3, 0xaa}},
    {0x86c3, {0xe5, 0x96, 0x84}},
    {0x86c4, {0xe5, 0xae, 0xb6}},
    {0x86c5, {0xe8, 0x99, 0xa7}},
    {0x86c6, {0xe6, 0x90, 0x8d}},
    {0x86c7, {0xe7, 0xb5, 0x90}},
    {0x86c8, {0xe4, 0xba, 0x86}},
    {0x86c9, {0xe5, 0xaf, 0x8c}},
    {0x86ca, {0xe8, 0xa3, 0x95}},
    {0x86cb, {0xe7, 0xaf, 0xb7}},
    {0x86cc, {0xe7, 0x9c, 0x8b}},
    {0x86cd, {0xe8, 0xb2, 0xa7}},
    {0x86ce, {0xe7, 0xaa, 0xae}},
    {0x86cf, {0xe8, 0xb2, 0xa2}},
    {0x86d0, {0xe8, 0xb2, 0xbc}},
    {0x86d1, {0xe5, 0xb9, 0xab}},
    {0x86d2, {0xe6, 0xb8, 0xa1}},
    {0x86d3, {0xe8, 0xb2, 0xb4}},
    {0x86d4, {0xe8, 0x81, 0xb2}},
    {0x86d5, {0xe4, 0xbb, 0x8a}},
    {0x86d6, {0xe5, 0x91, 0x88}},
    {0x86d7, {0xe5, 0x90, 0xb8}},
    {0x86d8, {0xe5, 0xbc, 0x95}},
    {0x86d9, {0xe6, 0xb3, 0xa8}},
    {0x86da, {0xe8, 0xbe, 0xa6}},
    {0x86db, {0xe6, 0x80, 0x9d}},
    {0x86dc, {0xe8, 0xad, 0xb0}},
    {0x86dd, {0xe4, 0xb9, 0x9f}},
    {0x86de, {0xe6, 0x83, 0xb9}},
    {0x86df, {0xe6, 0x83, 0xb1}},
    {0x86e0, {0xe9, 0x83, 0xbd}},
    {0x86e1, {0xe8, 0xa8, 0x8e}},
    {0x86e2, {0xe8, 0xab, 0x96}},
    {0x86e3, {0xe9, 0xa1, 0x8f}},
    {0x86e4, {0xe6, 0x81, 0xa5}},
    {0x86e5, {0xe8, 0xb2, 0xaa}},
    {0x86e6, {0xe5, 0xa9, 0xaa}},
    {0x86e7, {0xe6, 0x9c, 0x9b}},
    {0x86e8, {0xe5, 0x9a, 0xb4}},
    {0x86e9, {0xe8, 0xb6, 0x85}},
    {0x86ea, {0xe5, 0x8e, 0xad}},
    {0x86eb, {0xe6, 0x83, 0xa1}},
    {0x86ec, {0xe8, 0x80, 0x8c}},
    {0x86ed, {0xe8, 0xa8, 0x80}},
    {0x86ee, {0xe6, 0x88, 0x96}},
    {0x86ef, {0xe5, 0x88, 0xbb}},
    {0x86f0, {0xe7, 0x96, 0x8f}},
    {0x86f1, {0xe5, 0xbf, 0xbd}},
    {0x86f2, {0xe8, 0xa9, 0xb1}},
    {0x86f3, {0xe8, 0xaa, 0x8d}},
    {0x86f4, {0xe8, 0x87, 0xb4}},
    {0x86f5, {0xe7, 0x95, 0x99}},
    {0x86f6, {0xe6, 0xa8, 0xa3}},
    {0x86f7, {0xe7, 0xb9, 0xb3}},
    {0x86f8, {0xe4, 0xba, 0xa4}},
    {0x86f9, {0xe6, 0x8a, 0x8a}},
    {0x86fa, {0xe7, 0xb7, 0xa9}},
    {0x86fb, {0xe6, 0x85, 0xa2}},
    {0x86fc, {0xe6, 0xae, 0xb5}},
    {0x86fd, {0xe4, 0xbd, 0x86}},
    {0x86fe, {0xe5, 0xae, 0x88}},
    {0x86ff, {0xe6, 0xb2, 0x88}},
    {0x8780, {0xe9, 0x9d, 0x9c}},
    {0x8781, {0xe7, 0x9c, 0x9f}},
    {0x8782, {0xe5, 0x96, 0x9c}},
    {0x8783, {0xe6, 0xad, 0xa1}},
    {0x8784, {0xe5, 0xad, 0x90}},
    {0x8785, {0xe5, 0x8a, 0x83}},
    {0x8786, {0xe7, 0xb5, 0x82}},
    {0x8787, {0xe7, 0x9b, 0x8a}},
    {0x8788, {0xe9, 0xa9, 0x9a}},
    {0x8789, {0xe5, 0x9a, 0x87}},
    {0x878a, {0xe8, 0xab, 0x87}},
    {0x878b, {0xe7, 0x84, 0xa6}},
    {0x878c, {0xe9, 0xba, 0xbd}},
    {0x878d, {0xe5, 0xb0, 0x8a}},
    {0x878e, {0xe5, 0xb1, 0xaf}},
    {0x878f, {0xe7, 0xa9, 0x8d}},
    {0x8790, {0xe6, 0x93, 0xb1}},
    {0x8791, {0xe9, 0x96, 0x92}},
    {0x8792, {0xe9, 0x9d, 0xa0}},
    {0x8793, {0xe4, 0xb8, 0xa6}},
    {0x8794, {0xe6, 0x88, 0xb6}},
    {0x8795, {0xe6, 0x9f, 0xa5}},
    {0x8796, {0xe9, 0x8c, 0x84}},
    {0x8797, {0xe4, 0xbe, 0x9d}},
    {0x8798, {0xe9, 0xbd, 0xa1}},
    {0x8799, {0xe9, 0x81, 0xb7}},
    {0x879a, {0xe7, 0xbc, 0xba}},
    {0x879b, {0xe9, 0xa1, 0x98}},
    {0x879c, {0xe4, 0xb9, 0x8f}},
    {0x879d, {0xe9, 0x80, 0xbc}},
    {0x879e, {0xe6, 0x90, 0xac}},
    {0x879f, {0xe5, 0x88, 0xa5}},
    {0x87a0, {0xe7, 0xa9, 0xa9}},
    {0x87a1, {0xe5, 0x84, 0x98}},
    {0x87a2, {0xe8, 0x89, 0xaf}},
    {0x87a3, {0xe7, 0x85, 0xa7}},
    {0x87a4, {0xe6, 0xb6, 0xb5}},
    {0x87a5, {0xe8, 0x93, 0x8b}},
    {0x87a6, {0xe7, 0x97, 0x85}},
    {0x87a7, {0xe6, 0x96, 0xbd}},
    {0x87a8, {0xe5, 0x89, 0x87}},
    {0x87a9, {0xef, 0xbc, 0x9b}},
    {0x87aa, {0xe9, 0x98, 0xbb}},
    {0x87ab, {0xe7, 0xa4, 0x99}},
    {0x87ac, {0xe9, 0x99, 0x84}},
    {0x87ad, {0xe9, 0x9a, 0x9b}},
    {0x87ae, {0xe8, 0xb6, 0x8a}},
    {0x87af, {0xe5, 0x88, 0xae}},
    {0x87b0, {0xe9, 0xac, 0x8d}},
    {0x87b1, {0xe7, 0x99, 0x82}},
    {0x87b2, {0xe6, 0x9f, 0x90}},
    {0x87b3, {0xe4, 0xbd, 0xb3}},
    {0x87b4, {0xe6, 0x97, 0x8f}},
    {0x87b5, {0xe7, 0x84, 0xb6}},
    {0x87b6, {0xe5, 0xbe, 0x8c}},
    {0x87b7, {0xe5, 0x86, 0x8d}},
    {0x87b8, {0xe6, 0xa7, 0x8b}},
    {0x87b9, {0xe7, 0xb3, 0x9f}},
    {0x87ba, {0xe7, 0xb3, 0x95}},
    {0x87bb, {0xe6, 0x80, 0x95}},
    {0x87bc, {0xe5, 0x82, 0xb3}},
    {0x87bd, {0xe6, 0x95, 0xb7}},
    {0x87be, {0xe7, 0x96, 0xbe}},
    {0x87bf, {0xe9, 0x81, 0xbf}},
    {0x87c0, {0xe5, 0xae, 0xb3}},
    {0x87c1, {0xe4, 0xb8, 0x94}},
    {0x87c2, {0xe9, 0x8c, 0xaf}},
    {0x87c3, {0xe5, 0xbe, 0xae}},
    {0x87c4, {0xe6, 0x81, 0x99}},
    {0x87c5, {0xe7, 0x95, 0xb0}},
    {0x87c6, {0xe5, 0x80, 0x99}},
    {0x87c7, {0xe5, 0x82, 0x91}},
    {0x87c8, {0xe5, 0xad, 0xa9}},
    {0x87c9, {0xe7, 0xab, 0xa5}},
    {0x87ca, {0xe8, 0xbc, 0x95}},
    {0x87cb, {0xe7, 0xa8, 0x80}},
    {0x87cc, {0xe9, 0x96, 0xb1}},
    {0x87cd, {0xe8, 0xae, 0x80}},
    {0x87ce, {0xe8, 0xb5, 0xb0}},
    {0x87cf, {0xe7, 0xbf, 0x92}},
    {0x87d0, {0xe4, 0xba, 0xa6}},
    {0x87d1, {0xe5, 0xae, 0xa4}},
    {0x87d2, {0xe6, 0xb8, 0x9b}},
    {0x87d3, {0xe6, 0x93, 0xa0}},
    {0x87d4, {0xe8, 0x85, 0xa6}},
    {0x87d5, {0xe7, 0xb4, 0x93}},
    {0x87d6, {0xe5, 0x91, 0xb3}},
    {0x87d7, {0xe6, 0x8a, 0xb1}},
    {0x87d8, {0xe6, 0x80, 0xa8}},
    {0x87d9, {0xe6, 0xad, 0xa5}},
    {0x87da, {0xe5, 0xb9, 0x85}},
    {0x87db, {0xe7, 0x86, 0xb1}},
    {0x87dc, {0xe5, 0x88, 0x87}},
    {0x87dd, {0xe7, 0xaf, 0x80}},
    {0x87de, {0xe6, 0x85, 0xb6}},
    {0x87df, {0xe4, 0xbb, 0x8d}},
    {0x87e0, {0xe7, 0x8b, 0x82}},
    {0x87e1, {0xe5, 0xae, 0xbf}},
    {0x87e2, {0xe9, 0x86, 0x89}},
    {0x87e3, {0xe9, 0x86, 0x92}},
    {0x87e4, {0xe9, 0xa0, 0x8c}},
    {0x87e5, {0xe6, 0x86, 0xb6}},
    {0x87e6, {0xe8, 0xa4, 0xaa}},
    {0x87e7, {0xe5, 0x9f, 0x8b}},
    {0x87e8, {0xe5, 0x8f, 0x88}},
    {0x87e9, {0xe8, 0xa1, 0x97}},
    {0x87ea, {0xe5, 0x96, 0x83}},
    {0x87eb, {0xe7, 0x9c, 0xbe}},
    {0x87ec, {0xe7, 0x88, 0xad}},
    {0x87ed, {0xe6, 0x84, 0x9b}},
    {0x87ee, {0xe6, 0x83, 0x85}},
    {0x87ef, {0xe8, 0xb6, 0xa3}},
    {0x87f0, {0xe8, 0x87, 0xb3}},
    {0x87f1, {0xe8, 0xa7, 0xb8}},
    {0x87f2, {0xe5, 0x8f, 0xa6}},
    {0x87f3, {0xe5, 0x90, 0x8c}},
    {0x87f4, {0xe5, 0xb0, 0x88}},
    {0x87f5, {0xe5, 0x90, 0x84}},
    {0x87f6, {0xe5, 0x8b, 0x83}},
    {0x87f7, {0xe4, 0xbf, 0xa1}},
    {0x87f8, {0xe4, 0xbb, 0xb0}},
    {0x87f9, {0xe7, 0xa5, 0xad}},
    {0x87fa, {0xe9, 0x9a, 0xaa}},
    {0x87fb, {0xe7, 0xa5, 0x82}},
    {0x87fc, {0xe9, 0xa3, 0xa2}},
    {0x87fd, {0xe8, 0x8d, 0x92}},
    {0x87fe, {0xe7, 0x81, 0xbd}},
    {0x87ff, {0xe6, 0x89, 0x8b}},
    {0x8880, {0xe9, 0x9a, 0xbb}},
    {0x8881, {0xe6, 0x80, 0x92}},
    {0x8882, {0xe5, 0xa4, 0xab}},
    {0x8883, {0xe5, 0x86, 0x92}},
    {0x8884, {0xe9, 0x80, 0x80}},
    {0x8885, {0xe8, 0xb3, 0x9c}},
    {0x8886, {0xe6, 0x8e, 0x89}},
    {0x8887, {0xe5, 0x81, 0x95}},
    {0x8888, {0xe6, 0x86, 0xa4}},
    {0x8889, {0xe6, 0x84, 0x89}},
    {0x888a, {0xe6, 0xac, 0xa0}},
    {0x888b, {0xe5, 0x82, 0xb5}},
    {0x888c, {0xe9, 0x9b, 0x9c}},
    {0x888d, {0xe8, 0xa1, 0xa1}},
    {0x888e, {0xe6, 0x8d, 0x90}},
    {0x888f, {0xe8, 0xb4, 0x88}},
    {0x8890, {0xe9, 0xa6, 0x96}},
    {0x8891, {0xe5, 0xb8, 0xad}},
    {0x8892, {0xe7, 0xb7, 0x92}},
    {0x8893, {0xe9, 0xba, 0xbb}},
    {0x8894, {0xe7, 0x85, 0xa9}},
    {0x8895, {0xe7, 0x9a, 0x86}},
    {0x8896, {0xe6, 0x88, 0xb4}},
    {0x8897, {0xe5, 0xb4, 0x87}},
    {0x8898, {0xe7, 0x94, 0x9a}},
    {0x8899, {0xe5, 0x89, 0x9b}},
    {0x889a, {0xe9, 0xa4, 0xb5}},
    {0x889b, {0xe9, 0xa3, 0xbd}},
    {0x889c, {0xe8, 0xa3, 0xb9}},
    {0x889d, {0xe6, 0x99, 0x89}},
    {0x889e, {0xe6, 0x81, 0xad}},
    {0x889f, {0xe9, 0xa9, 0x95}},
    {0x88a0, {0xe5, 0x82, 0xb2}},
    {0x88a1, {0xe5, 0xae, 0xa3}},
    {0x88a2, {0xe4, 0xbd, 0x88}},
    {0x88a3, {0xe4, 0xbc, 0x91}},
    {0x88a4, {0xe9, 0x9a, 0xb1}},
    {0x88a5, {0xe7, 0xa7, 0x81}},
    {0x88a6, {0xe6, 0xb0, 0xb8}},
    {0x88a7, {0xe5, 0x81, 0x89}},
    {0x88a8, {0xe7, 0xb5, 0xb1}},
    {0x88a9, {0xe6, 0xb2, 0xbb}},
    {0x88aa, {0xe8, 0x90, 0xac}},
    {0x88ab, {0xe6, 0xad, 0xb2}},
    {0x88ac, {0xe6, 0x8a, 0x95}},
    {0x88ad, {0xe5, 0x8d, 0xbb}},
    {0x88ae, {0xe8, 0x80, 0x80}},
    {0x88af, {0xe8, 0xaa, 0xa4}},
    {0x88b0, {0xe8, 0xba, 0xab}},
    {0x88b1, {0xe8, 0xbf, 0xab}},
    {0x88b2, {0xe4, 0xbb, 0xa3}},
    {0x88b3, {0xe8, 0xa7, 0x92}},
    {0x88b4, {0xe6, 0x89, 0xae}},
    {0x88b5, {0xe8, 0x82, 0xaf}},
    {0x88b6, {0xe8, 0x81, 0x96}},
    {0x88b7, {0xe5, 0x8d, 0x92}},
    {0x88b8, {0xe6, 0xad, 0xb8}},
    {0x88b9, {0xe6, 0x8e, 0xa8}},
    {0x88ba, {0xe7, 0x88, 0x86}},
    {0x88bb, {0xe7, 0x82, 0xb8}},
    {0x88bc, {0xe5, 0x90, 0x8f}},
    {0x88bd, {0xe6, 0x93, 0xb2}},
    {0x88be, {0xe9, 0xa6, 0xb4}},
    {0x88bf, {0xe7, 0x8d, 0xb8}},
    {0x88c0, {0xe9, 0xa7, 0x95}},
    {0x88c1, {0xe9, 0xa7, 0x9b}},
    {0x88c2, {0xe6, 0x8a, 0x97}},
    {0x88c3, {0xe6, 0x97, 0x97}},
    {0x88c4, {0xe5, 0xb9, 0x9f}},
    {0x88c5, {0xe6, 0xbc, 0x82}},
    {0x88c6, {0xe7, 0xae, 0xad}},
    {0x88c7, {0xe5, 0xbc, 0xa9}},
    {0x88c8, {0xe7, 0xa0, 0xb2}},
    {0x88c9, {0xe9, 0xb7, 0x97}},
    {0x88ca, {0xe7, 0xbe, 0x8a}},
    {0x88cb, {0xe6, 0x96, 0x91}},
    {0x88cc, {0xe6, 0x99, 0xba}},
    {0x88cd, {0xe6, 0x85, 0xa7}},
    {0x88ce, {0xe5, 0xa1, 0x8a}},
    {0x88cf, {0xe9, 0x81, 0x87}},
    {0x88d0, {0xe9, 0xa3, 0xb2}},
    {0x88d1, {0xe5, 0x90, 0x83}},
    {0x88d2, {0xe7, 0x81, 0xab}},
    {0x88d3, {0xe6, 0x80, 0xa7}},
    {0x88d4, {0xe6, 0xba, 0xab}},
    {0x88d5, {0xe5, 0xba, 0x8a}},
    {0x88d6, {0xe5, 0xa1, 0x8c}},
    {0x88d7, {0xe9, 0x99, 0xb7}},
    {0x88d8, {0xe5, 0x81, 0xb6}},
    {0x88d9, {0xe5, 0xb0, 0x8e}},
    {0x88da, {0xe8, 0xa6, 0x8b}},
    {0x88db, {0xe6, 0x85, 0xa3}},
    {0x88dc, {0xe4, 0xbb, 0x80}},
    {0x88dd, {0xe9, 0xa0, 0x86}},
    {0x88de, {0xe9, 0xa0, 0x82}},
    {0x88df, {0xe6, 0x9d, 0xbf}},
    {0x88e0, {0xe9, 0xa0, 0x81}},
    {0x88e1, {0xe6, 0x93, 0x8d}},
    {0x88e2, {0xe8, 0x97, 0x8f}},
    {0x88e3, {0xe5, 0xaf, 0xac}},
    {0x88e4, {0xe4, 0xba, 0xae}},
    {0x88e5, {0xe8, 0xbc, 0xaa}},
    {0x88e6, {0xe4, 0xbf, 0xaf}},
    {0x88e7, {0xe8, 0xa8, 0xaa}},
    {0x88e8, {0xe8, 0xa7, 0x80}},
    {0x88e9, {0xe6, 0x81, 0xa2}},
    {0x88ea, {0xe5, 0xbe, 0xa9}},
    {0x88eb, {0xe9, 0x80, 0x86}},
    {0x88ec, {0xe9, 0x90, 0x98}},
    {0x88ed, {0xe6, 0x97, 0x8b}},
    {0x88ee, {0xe8, 0xbd, 0x89}},
    {0x88ef, {0xe5, 0xba, 0x8f}},
    {0x88f0, {0xe5, 0xaf, 0xa6}},
    {0x88f1, {0xe5, 0x81, 0x8f}},
    {0x88f2, {0xe7, 0xa9, 0xbf}},
    {0x88f3, {0xe8, 0x84, 0x88}},
    {0x88f4, {0xe9, 0x80, 0x8f}},
    {0x88f5, {0xe9, 0x84, 0xb0}},
    {0x88f6, {0xe6, 0xb7, 0xb1}},
    {0x88f7, {0xe6, 0xb7, 0xb5}},
    {0x88f8, {0xe5, 0xa1, 0xa1}},
    {0x88f9, {0xe8, 0xa3, 0x9c}},
    {0x88fa, {0xe5, 0xbb, 0xb6}},
    {0x88fb, {0xe8, 0x88, 0x8a}},
    {0x88fc, {0xe6, 0xae, 0x98}},
    {0x88fd, {0xe5, 0xbf, 0x8d}},
    {0x88fe, {0xe5, 0x82, 0xb7}},
    {0x88ff, {0xe6, 0x92, 0x9e}},
    {0x8980, {0xe4, 0xb9, 0x85}},
    {0x8981, {0xe5, 0x85, 0x81}},
    {0x8982, {0xe5, 0x8f, 0x8b}},
    {0x8983, {0xe6, 0x9a, 0xa2}},
    {0x8984, {0xe6, 0x9b, 0xbe}},
    {0x8985, {0xe5, 0x88, 0xba}},
    {0x8986, {0xe6, 0xbf, 0x80}},
    {0x8987, {0xe6, 0xad, 0xbb}},
    {0x8988, {0xe6, 0x82, 0xb2}},
    {0x8989, {0xe6, 0x89, 0xb9}},
    {0x898a, {0xe9, 0xa2, 0xa8}},
    {0x898b, {0xe6, 0x83, 0x9f}},
    {0x898c, {0xe5, 0xad, 0x9a}},
    {0x898d, {0xe8, 0x92, 0x82}},
    {0x898e, {0xe5, 0xa6, 0xae}},
    {0x898f, {0xe6, 0x9f, 0x8f}},
    {0x8990, {0xe8, 0x8a, 0xac}},
    {0x8991, {0xe8, 0x90, 0x8a}},
    {0x8992, {0xe5, 0xa5, 0x87}},
    {0x8993, {0xe6, 0x9b, 0xbc}},
    {0x8994, {0xe5, 0x84, 0x82}},
    {0x8995, {0xe8, 0x8d, 0xb7}},
    {0x8996, {0xe8, 0xa1, 0x80}},
    {0x8997, {0xe8, 0x85, 0xa5}},
    {0x8998, {0xe6, 0xb7, 0xbb}},
    {0x8999, {0xe6, 0x9b, 0xbf}},
    {0x899a, {0xe5, 0x85, 0x85}},
    {0x899b, {0xe7, 0xb7, 0xb4}},
    {0x899c, {0xe5, 0xab, 0x8c}},
    {0x899d, {0xe5, 0x8d, 0x8a}},
    {0x899e, {0xe5, 0x8b, 0x89}},
    {0x899f, {0xe6, 0xa0, 0xbd}},
    {0x89a0, {0xe5, 0x8c, 0xa0}},
    {0x89a1, {0xe5, 0xa0, 0x85}},
    {0x89a2, {0xe8, 0xbf, 0x8e}},
    {0x89a3, {0xe5, 0x98, 0x88}},
    {0x89a4, {0xe7, 0x82, 0x8e}},
    {0x89a5, {0xe7, 0x81, 0xb0}},
    {0x89a6, {0xe5, 0xa1, 0xb5}},
    {0x89a7, {0xe4, 0xba, 0xab}},
    {0x89a8, {0xe5, 0x86, 0xbd}},
    {0x89a9, {0xe7, 0xb4, 0x80}},
    {0x89aa, {0xe5, 0xbf, 0xb5}},
    {0x89ab, {0xe5, 0xae, 0x8f}},
    {0x89ac, {0xe9, 0x9b, 0x96}},
    {0x89ad, {0xe8, 0xa5, 0xb2}},
    {0x89ae, {0xe6, 0xb4, 0x97}},
    {0x89af, {0xe9, 0xac, 0x86}},
    {0x89b0, {0xe8, 0xaa, 0xb0}},
    {0x89b1, {0xe6, 0x97, 0xa2}},
    {0x89b2, {0xe4, 0xb9, 0xbe}},
    {0x89b3, {0xe4, 0xbf, 0xae}},
    {0x89b4, {0xe5, 0x89, 0xaa}},
    {0x89b5, {0xe5, 0x84, 0x80}},
    {0x89b6, {0xe6, 0xbd, 0x94}},
    {0x89b7, {0xe5, 0xaf, 0xab}},
    {0x89b8, {0xe7, 0xae, 0x97}},
    {0x89b9, {0xe8, 0xad, 0x98}},
    {0x89ba, {0xe7, 0x95, 0xa2}},
    {0x89bb, {0xe8, 0x83, 0x8c}},
    {0x89bc, {0xe6, 0x9e, 0xb6}},
    {0x89bd, {0xe7, 0x9f, 0xa5}},
    {0x89be, {0xe5, 0x8d, 0xb7}},
    {0x89bf, {0xe8, 0xbb, 0xb8}},
    {0x89c0, {0xe5, 0xaf, 0xa7}},
    {0x89c1, {0xe6, 0x92, 0xb2}},
    {0x89c2, {0xe6, 0xbb, 0x85}},
    {0x89c3, {0xe5, 0x8b, 0xa4}},
    {0x89c4, {0xe6, 0x98, 0x9f}},
    {0x89c5, {0xe8, 0x9b, 0x8b}},
    {0x89c6, {0xe5, 0x92, 0x92}},
    {0x89c7, {0xe8, 0xa9, 0x9b}},
    {0x89c8, {0xe6, 0x95, 0xa2}},
    {0x89c9, {0xe5, 0xbe, 0xb5}},
    {0x89ca, {0xe5, 0x8f, 0xac}},
    {0x89cb, {0xe7, 0xa6, 0xa6}},
    {0x89cc, {0xe5, 0xb8, 0xb6}},
    {0x89cd, {0xe5, 0xa5, 0xb9}},
    {0x89ce, {0xe6, 0x8c, 0xa8}},
    {0x89cf, {0xe9, 0xa4, 0x93}},
    {0x89d0, {0xe7, 0x9b, 0xa3}},
    {0x89d1, {0xe9, 0xbc, 0x93}},
    {0x89d2, {0xe8, 0x88, 0x9e}},
    {0x89d3, {0xe5, 0x8b, 0x87}},
    {0x89d4, {0xe7, 0xa5, 0x9d}},
    {0x89d5, {0xe7, 0xa6, 0x8f}},
    {0x89d6, {0xe8, 0x86, 0xbd}},
    {0x89d7, {0xe6, 0x95, 0xa3}},
    {0x89d8, {0xe6, 0x92, 0xad}},
    {0x89d9, {0xe8, 0xb3, 0xa3}},
    {0x89da, {0xe8, 0x89, 0x98}},
    {0x89db, {0xe6, 0xb3, 0x8a}},
    {0x89dc, {0xe5, 0x8d, 0xb8}},
    {0x89dd, {0xe6, 0xb8, 0xaf}},
    {0x89de, {0xe8, 0x88, 0xaa}},
    {0x89df, {0xe7, 0xa9, 0xab}},
    {0x89e0, {0xe7, 0xbe, 0xa8}},
    {0x89e1, {0xe8, 0xa6, 0x8f}},
    {0x89e2, {0xe6, 0xaa, 0xa2}},
    {0x89e3, {0xe8, 0xbf, 0xbd}},
    {0x89e4, {0xe8, 0xb9, 0xa4}},
    {0x89e5, {0xe7, 0xb4, 0x84}},
    {0x89e6, {0xe8, 0x93, 0x84}},
    {0x89e7, {0xe9, 0xa4, 0x98}},
    {0x89e8, {0xe6, 0x8a, 0xb5}},
    {0x89e9, {0xe5, 0x89, 0xa9}},
    {0x89ea, {0xe6, 0xa4, 0x8d}},
    {0x89eb, {0xe8, 0x95, 0xaa}},
    {0x89ec, {0xe8, 0x9d, 0x97}},
    {0x89ed, {0xe6, 0x99, 0x9a}},
    {0x89ee, {0xe4, 0xbf, 0x82}},
    {0x89ef, {0xe5, 0xa3, 0x93}},
    {0x89f0, {0xe6, 0xa6, 0xa8}},
    {0x89f1, {0xe7, 0x83, 0xb9}},
    {0x89f2, {0xe6, 0xbd, 0xa4}},
    {0x89f3, {0xe6, 0x9e, 0x9d}},
    {0x89f4, {0xe7, 0xb4, 0xaf}},
    {0x89f5, {0xe5, 0x9e, 0x82}},
    {0x89f6, {0xe9, 0x87, 0x80}},
    {0x89f7, {0xe9, 0x80, 0x83}},
    {0x89f8, {0xe8, 0x82, 0xa5}},
    {0x89f9, {0xe5, 0xa3, 0xaf}},
    {0x89fa, {0xe7, 0xa0, 0x8d}},
    {0x89fb, {0xe4, 0xbc, 0x90}},
    {0x89fc, {0xe9, 0xa3, 0xbe}},
    {0x89fd, {0xe5, 0xa4, 0xa5}},
    {0x89fe, {0xe4, 0xbc, 0xb4}},
    {0x89ff, {0xe6, 0xa8, 0xb5}},
    {0x8a80, {0xe5, 0x82, 0x85}},
    {0x8a81, {0xe9, 0xa3, 0xaa}},
    {0x8a82, {0xe7, 0x94, 0xb2}},
    {0x8a83, {0xe5, 0xa1, 0x91}},
    {0x8a84, {0xe6, 0xb8, 0xac}},
    {0x8a85, {0xe6, 0x81, 0x90}},
    {0x8a86, {0xe9, 0x84, 0x89}},
    {0x8a87, {0xe6, 0x96, 0xb7}},
    {0x8a88, {0xe7, 0xbd, 0x95}},
    {0x8a89, {0xe4, 0xbe, 0x8b}},
    {0x8a8a, {0xe5, 0x8b, 0xb5}},
    {0x8a8b, {0xe6, 0x90, 0xad}},
    {0x8a8c, {0xe9, 0x8c, 0xa8}},
    {0x8a8d, {0xe4, 0xbc, 0xbc}},
    {0x8a8e, {0xe6, 0xa3, 0x92}},
    {0x8a8f, {0xe8, 0xb7, 0xa1}},
    {0x8a90, {0xe5, 0xbf, 0x99}},
    {0x8a91, {0xe8, 0x94, 0x93}},
    {0x8a92, {0xe5, 0xa5, 0xae}},
    {0x8a93, {0xe8, 0xac, 0x9d}},
    {0x8a94, {0xe8, 0xab, 0xb8}},
    {0x8a95, {0xe6, 0x82, 0xb6}},
    {0x8a96, {0xe5, 0xb9, 0xb8}},
    {0x8a97, {0xe5, 0x8a, 0xaa}},
    {0x8a98, {0xe6, 0x86, 0x90}},
    {0x8a99, {0xe6, 0x86, 0xab}},
    {0x8a9a, {0xe5, 0x98, 0xb2}},
    {0x8a9b, {0xe7, 0xac, 0x91}},
    {0x8a9c, {0xe5, 0x97, 0xaf}},
    {0x8a9d, {0xe8, 0xb6, 0x95}},
    {0x8a9e, {0xe5, 0xa4, 0x9c}},
    {0x8a9f, {0xe6, 0xb7, 0x9a}},
    {0x8aa0, {0xe6, 0xb5, 0xaa}},
    {0x8aa1, {0xe8, 0x81, 0x8a}},
    {0x8aa2, {0xe7, 0xb1, 0x83}},
    {0x8aa3, {0xe7, 0xb2, 0xbe}},
    {0x8aa4, {0xe5, 0x89, 0xb5}},
    {0x8aa5, {0xe5, 0xa6, 0xbb}},
    {0x8aa6, {0xe5, 0x82, 0xac}},
    {0x8aa7, {0xe4, 0xbf, 0x83}},
    {0x8aa8, {0xe8, 0x99, 0x94}},
    {0x8aa9, {0xe8, 0xaa, 0xa0}},
    {0x8aaa, {0xe5, 0x8a, 0xa3}},
    {0x8aab, {0xe5, 0xbe, 0x85}},
    {0x8aac, {0xe6, 0x9a, 0x88}},
    {0x8aad, {0xe6, 0xac, 0xa3}},
    {0x8aae, {0xe8, 0xa8, 0x9d}},
    {0x8aaf, {0xe8, 0xaa, 0xb2}},
    {0x8ab0, {0xe5, 0xa6, 0x99}},
    {0x8ab1, {0xe8, 0x82, 0x8b}},
    {0x8ab2, {0xe9, 0xaa, 0xa8}},
    {0x8ab3, {0xe8, 0x80, 0x83}},
    {0x8ab4, {0xe6, 0x85, 0xae}},
    {0x8ab5, {0xe5, 0xbf, 0x98}},
    {0x8ab6, {0xe6, 0xaf, 0x9b}},
    {0x8ab7, {0xe8, 0xaa, 0xa6}},
    {0x8ab8, {0xe5, 0x8f, 0xb0}},
    {0x8ab9, {0xe8, 0xa9, 0x9e}},
    {0x8aba, {0xe5, 0x95, 0x8a}},
    {0x8abb, {0xe8, 0x81, 0xbd}},
    {0x8abc, {0xe8, 0xa8, 0xb4}},
    {0x8abd, {0xe6, 0x97, 0xa9}},
    {0x8abe, {0xe9, 0xa4, 0x90}},
    {0x8abf, {0xe7, 0x89, 0xa0}},
    {0x8ac0, {0xe7, 0x98, 0x8b}},
    {0x8ac1, {0xe5, 0x90, 0xbc}},
    {0x8ac2, {0xe9, 0x9e, 0xad}},
    {0x8ac3, {0xe6, 0xbb, 0x8b}},
    {0x8ac4, {0xe5, 0x93, 0xbc}},
    {0x8ac5, {0xe5, 0x8b, 0x81}},
    {0x8ac6, {0xe8, 0xb1, 0x88}},
    {0x8ac7, {0xe8, 0x88, 0x92}},
    {0x8ac8, {0xe6, 0x8d, 0xa8}},
    {0x8ac9, {0xe9, 0xba, 0xb5}},
    {0x8aca, {0xe5, 0x8c, 0x85}},
    {0x8acb, {0xe8, 0x80, 0x8d}},
    {0x8acc, {0xe8, 0x84, 0xbe}},
    {0x8acd, {0xe4, 0xbb, 0x94}},
    {0x8ace, {0xe5, 0x85, 0x92}},
    {0x8acf, {0xe5, 0x85, 0x84}},
    {0x8ad0, {0xe7, 0x8b, 0x97}},
    {0x8ad1, {0xe4, 0xbb, 0x81}},
    {0x8ad2, {0xe6, 0x85, 0x88}},
    {0x8ad3, {0xe8, 0x83, 0x96}},
    {0x8ad4, {0xe5, 0xa5, 0xb3}},
    {0x8ad5, {0xe8, 0xb7, 0x9f}},
    {0x8ad6, {0xe5, 0xbe, 0x8b}},
    {0x8ad7, {0xe6, 0x93, 0xbe}},
    {0x8ad8, {0xe5, 0xbb, 0xb3}},
    {0x8ad9, {0xe9, 0x85, 0x8b}},
    {0x8ada, {0xe7, 0xb4, 0xa0}},
    {0x8adb, {0xe7, 0xa3, 0xa8}},
    {0x8adc, {0xe5, 0xb7, 0xa7}},
    {0x8add, {0xe8, 0x84, 0xab}},
    {0x8ade, {0xe7, 0xa9, 0x8e}},
    {0x8adf, {0xe9, 0xa9, 0x97}},
    {0x8ae0, {0xe9, 0x99, 0xa3}},
    {0x8ae1, {0xe6, 0x8e, 0x83}},
    {0x8ae2, {0xe7, 0x9b, 0xaa}},
    {0x8ae3, {0xe5, 0x8b, 0xa2}},
    {0x8ae4, {0xe6, 0xbd, 0xb0}},
    {0x8ae5, {0xe4, 0xba, 0x82}},
    {0x8ae6, {0xe6, 0x92, 0xbc}},
    {0x8ae7, {0xe7, 0xa4, 0xab}},
    {0x8ae8, {0xe8, 0xbf, 0xb0}},
    {0x8ae9, {0xe8, 0xb9, 0x82}},
    {0x8aea, {0xe8, 0xba, 0xaa}},
    {0x8aeb, {0xe5, 0xa2, 0xbe}},
    {0x8aec, {0xe7, 0x98, 0xa0}},
    {0x8aed, {0xe5, 0xb3, 0xb6}},
    {0x8aee, {0xe6, 0x8c, 0x91}},
    {0x8aef, {0xe5, 0xa5, 0xaa}},
    {0x8af0, {0xe6, 0x8e, 0xaa}},
    {0x8af1, {0xe6, 0xb2, 0xbe}},
    {0x8af2, {0xe6, 0x93, 0x9a}},
    {0x8af3, {0xe8, 0x81, 0xaf}},
    {0x8af4, {0xe7, 0x9b, 0x9f}},
    {0x8af5, {0xe8, 0x80, 0xbd}},
    {0x8af6, {0xe6, 0xa3, 0x84}},
    {0x8af7, {0xe7, 0x8f, 0xad}},
    {0x8af8, {0xe7, 0xa7, 0x92}},
    {0x8af9, {0xe7, 0xa4, 0x8e}},
    {0x8afa, {0xe6, 0xae, 0x96}},
    {0x8afb, {0xe6, 0x9d, 0x9f}},
    {0x8afc, {0xe5, 0xb9, 0xb9}},
    {0x8afd, {0xe6, 0x9a, 0x97}},
    {0x8afe, {0xe6, 0x8c, 0xbd}},
    {0x8aff, {0xe5, 0x80, 0x9f}},
    {0x8b80, {0xe7, 0xa0, 0x94}},
    {0x8b81, {0xe6, 0x93, 0xac}},
    {0x8b82, {0xe6, 0xbc, 0xa2}},
    {0x8b83, {0xe6, 0x8b, 0x94}},
    {0x8b84, {0xe5, 0x8d, 0x91}},
    {0x8b85, {0xe8, 0xb9, 0x9f}},
    {0x8b86, {0xe5, 0xbd, 0xa9}},
    {0x8b87, {0xe5, 0xbf, 0xa0}},
    {0x8b88, {0xe5, 0x91, 0xbc}},
    {0x8b89, {0xe7, 0x8f, 0x8d}},
    {0x8b8a, {0xe5, 0x83, 0x95}},
    {0x8b8b, {0xe6, 0xbc, 0xb8}},
    {0x8b8c, {0xe5, 0xaf, 0x86}},
    {0x8b8d, {0xe6, 0xbe, 0x88}},
    {0x8b8e, {0xe7, 0xa2, 0x8e}},
    {0x8b8f, {0xe5, 0x8f, 0x9b}},
    {0x8b90, {0xe9, 0x9d, 0x88}},
    {0x8b91, {0xe7, 0xa9, 0xb6}},
    {0x8b92, {0xe8, 0xac, 0x82}},
    {0x8b93, {0xe5, 0xaf, 0x9f}},
    {0x8b94, {0xe6, 0x95, 0x98}},
    {0x8b95, {0xe7, 0x83, 0x8f}},
    {0x8b96, {0xe5, 0x8a, 0x8d}},
    {0x8b97, {0xe9, 0x8b, 0x92}},
    {0x8b98, {0xe7, 0x8e, 0x8b}},
    {0x8b99, {0xe6, 0x86, 0x8e}},
    {0x8b9a, {0xe6, 0x81, 0xa8}},
    {0x8b9b, {0xe6, 0xa3, 0xae}},
    {0x8b9c, {0xe6, 0xa0, 0xb8}},
    {0x8b9d, {0xe8, 0xa8, 0xbc}},
    {0x8b9e, {0xe7, 0xa7, 0x80}},
    {0x8b9f, {0xe2, 0x85, 0xa2}},
    {0x8ba0, {0xe8, 0x93, 0xb7}},
    {0x8ba1, {0xe5, 0xb7, 0xa6}},
    {0x8ba2, {0xe8, 0xab, 0xa7}},
    {0x8ba3, {0xe5, 0x9e, 0x83}},
    {0x8ba4, {0xe5, 0x9c, 0xbe}},
    {0x8ba5, {0xe7, 0xb7, 0xa3}},
    {0x8ba6, {0xe5, 0xa0, 0xb5}},
    {0x8ba7, {0xe4, 0xba, 0xa1}},
    {0x8ba8, {0xe5, 0x8f, 0x83}},
    {0x8ba9, {0xe7, 0x89, 0xa7}},
    {0x8baa, {0xe6, 0xa7, 0xaa}},
    {0x8bab, {0xe8, 0x80, 0x95}},
    {0x8bac, {0xe9, 0x88, 0x95}},
    {0x8bad, {0xe7, 0x9b, 0xa4}},
    {0x8bae, {0xe5, 0x96, 0x9a}},
    {0x8baf, {0xe9, 0x9b, 0xa8}},
    {0x8bb0, {0xe7, 0x89, 0x87}},
    {0x8bb1, {0xe9, 0x9b, 0xb2}},
    {0x8bb2, {0xe6, 0x87, 0x82}},
    {0x8bb3, {0xe7, 0x95, 0x8f}},
    {0x8bb4, {0xe5, 0x80, 0x8d}},
    {0x8bb5, {0xe9, 0x9b, 0x99}},
    {0x8bb6, {0xe6, 0x8f, 0xad}},
    {0x8bb7, {0xe9, 0x9c, 0xb2}},
    {0x8bb8, {0xe5, 0xa6, 0xa5}},
    {0x8bb9, {0xe7, 0x85, 0x99}},
    {0x8bba, {0xe7, 0x87, 0xbb}},
    {0x8bbb, {0xe7, 0x98, 0x9f}},
    {0x8bbc, {0xe7, 0x96, 0xab}},
    {0x8bbd, {0xe7, 0x82, 0x99}},
    {0x8bbe, {0xe9, 0xad, 0x82}},
    {0x8bbf, {0xe7, 0x94, 0xa6}},
    {0x8bc0, {0xe6, 0xae, 0xba}},
    {0x8bc1, {0xe9, 0x80, 0xae}},
    {0x8bc2, {0xe6, 0x8d, 0x95}},
    {0x8bc3, {0xe4, 0xbc, 0x99}},
    {0x8bc4, {0xe8, 0x80, 0x90}},
    {0x8bc5, {0xe6, 0x88, 0xaa}},
    {0x8bc6, {0xe8, 0xaa, 0x93}},
    {0x8bc7, {0xe8, 0xa3, 0x81}},
    {0x8bc8, {0xe8, 0xb4, 0x8f}},
    {0x8bc9, {0xe5, 0x91, 0xa2}},
    {0x8bca, {0xe6, 0x80, 0x8e}},
    {0x8bcb, {0xe6, 0x83, 0x9c}},
    {0x8bcc, {0xe9, 0x8e, 0xae}},
    {0x8bcd, {0xe5, 0xb0, 0xa4}},
    {0x8bce, {0xe8, 0x81, 0xb7}},
    {0x8bcf, {0xe6, 0x90, 0xb6}},
    {0x8bd0, {0xe7, 0x93, 0xb6}},
    {0x8bd1, {0xe7, 0x9f, 0xae}},
    {0x8bd2, {0xe6, 0x93, 0x8b}},
    {0x8bd3, {0xe5, 0xb1, 0x8f}},
    {0x8bd4, {0xe9, 0x9a, 0x9c}},
    {0x8bd5, {0xe6, 0x9b, 0xb2}},
    {0x8bd6, {0xe7, 0xb7, 0x8a}},
    {0x8bd7, {0xe6, 0x80, 0xa5}},
    {0x8bd8, {0xe6, 0x8b, 0x8b}},
    {0x8bd9, {0xe7, 0x97, 0x9b}},
    {0x8bda, {0xe8, 0x8b, 0xa6}},
    {0x8bdb, {0xe6, 0x90, 0x96}},
    {0x8bdc, {0xe5, 0x90, 0x9e}},
    {0x8bdd, {0xe5, 0x96, 0xab}},
    {0x8bde, {0xe6, 0x9c, 0xb1}},
    {0x8bdf, {0xe5, 0xb4, 0xa9}},
    {0x8be0, {0xe6, 0xbd, 0x9b}},
    {0x8be1, {0xe7, 0x95, 0x8c}},
    {0x8be2, {0xe8, 0xb3, 0xba}},
    {0x8be3, {0xe8, 0xb2, 0xab}},
    {0x8be4, {0xe8, 0x90, 0xbd}},
    {0x8be5, {0xe7, 0xac, 0xa8}},
    {0x8be6, {0xe6, 0x8b, 0x99}},
    {0x8be7, {0xe6, 0x8e, 0xa9}},
    {0x8be8, {0xe5, 0x81, 0xb7}},
    {0x8be9, {0xe6, 0xba, 0x9c}},
    {0x8bea, {0xe6, 0xb2, 0x90}},
    {0x8beb, {0xe6, 0xb5, 0xb4}},
    {0x8bec, {0xe8, 0xa6, 0xaa}},
    {0x8bed, {0xe7, 0x99, 0xbe}},
    {0x8bee, {0xe5, 0x8d, 0x83}},
    {0x8bef, {0xe6, 0xb7, 0xb7}},
    {0x8bf0, {0xe7, 0x84, 0xb0}},
    {0x8bf1, {0xe6, 0x8e, 0xa0}},
    {0x8bf2, {0xe6, 0xa9, 0xab}},
    {0x8bf3, {0xe5, 0x8a, 0xab}},
    {0x8bf4, {0xe6, 0x89, 0xba}},
    {0x8bf5, {0xe7, 0xad, 0x94}},
    {0x8bf6, {0xe6, 0x8b, 0x96}},
    {0x8bf7, {0xe5, 0x84, 0x9f}},
    {0x8bf8, {0xe6, 0x85, 0x98}},
    {0x8bf9, {0xe2, 0x80, 0xa6}},
    {0x8bfa, {0xe9, 0xa0, 0xbb}},
    {0x8bfb, {0xe6, 0x9d, 0x91}},
    {0x8bfc, {0xe8, 0x8e, 0x8a}},
    {0x8bfd, {0xe6, 0x8e, 0x88}},
    {0x8bfe, {0xe4, 0xba, 0x88}},
    {0x8bff, {0xe9, 0x81, 0xba}},
    {0x8c80, {0xe4, 0xbe, 0xae}},
    {0x8c81, {0xe8, 0xbe, 0xb1}},
    {0x8c82, {0xe5, 0xb1, 0x86}},
    {0x8c83, {0xe5, 0xb0, 0xbe}},
    {0x8c84, {0xe8, 0xb9, 0xa3}},
    {0x8c85, {0xe8, 0xb7, 0x9a}},
    {0x8c86, {0xe6, 0x8f, 0x9a}},
    {0x8c87, {0xe8, 0x9f, 0xb2}},
    {0x8c88, {0xe4, 0xbb, 0x87}},
    {0x8c89, {0xe7, 0x83, 0x88}},
    {0x8c8a, {0xe5, 0x93, 0xad}},
    {0x8c8b, {0xe6, 0xb3, 0xa3}},
    {0x8c8c, {0xe5, 0x93, 0x80}},
    {0x8c8d, {0xe6, 0x8c, 0xab}},
    {0x8c8e, {0xe6, 0x8a, 0x98}},
    {0x8c8f, {0xe7, 0xab, 0x8a}},
    {0x8c90, {0xe8, 0xac, 0x9b}},
    {0x8c91, {0xe8, 0x96, 0x84}},
    {0x8c92, {0xe8, 0xa2, 0x8b}},
    {0x8c93, {0xe5, 0x85, 0x86}},
    {0x8c94, {0xe6, 0x8b, 0xac}},
    {0x8c95, {0xe8, 0xb7, 0xb3}},
    {0x8c96, {0xe8, 0xba, 0x8d}},
    {0x8c97, {0xe8, 0xaa, 0x87}},
    {0x8c98, {0xe8, 0xb2, 0xac}},
    {0x8c99, {0xe9, 0x88, 0xb4}},
    {0x8c9a, {0xe4, 0xbe, 0x8d}},
    {0x8c9b, {0xe8, 0x90, 0x8e}},
    {0x8c9c, {0xe7, 0xb8, 0xae}},
    {0x8c9d, {0xe5, 0xaf, 0x93}},
    {0x8c9e, {0xe5, 0xbd, 0xbc}},
    {0x8c9f, {0xe6, 0x99, 0x83}},
    {0x8ca0, {0xe8, 0xbe, 0xaf}},
    {0x8ca1, {0xe5, 0x93, 0xb2}},
    {0x8ca2, {0xe6, 0xbc, 0xab}},
    {0x8ca3, {0xe8, 0xb7, 0xa8}},
    {0x8ca4, {0xe8, 0xb7, 0x8b}},
    {0x8ca5, {0xe6, 0xb6, 0x89}},
    {0x8ca6, {0xe7, 0x9c, 0xbc}},
    {0x8ca7, {0xe6, 0x92, 0x90}},
    {0x8ca8, {0xe5, 0x81, 0xb4}},
    {0x8ca9, {0xe5, 0xa0, 0x86}},
    {0x8caa, {0xe5, 0x90, 0xb5}},
    {0x8cab, {0xe9, 0xac, 0xa7}},
    {0x8cac, {0xe9, 0xaa, 0xaf}},
    {0x8cad, {0xe9, 0xab, 0x92}},
    {0x8cae, {0xe6, 0x8b, 0x9b}},
    {0x8caf, {0xe8, 0xa9, 0xb3}},
    {0x8cb0, {0xe9, 0xad, 0x94}},
    {0x8cb1, {0xe6, 0xb9, 0xae}},
    {0x8cb2, {0xe7, 0xa3, 0x9a}},
    {0x8cb3, {0xe5, 0x87, 0x9d}},
    {0x8cb4, {0xe5, 0xbb, 0x89}},
    {0x8cb5, {0xe7, 0x87, 0xa5}},
    {0x8cb6, {0xe8, 0x87, 0xa8}},
    {0x8cb7, {0xe5, 0xae, 0x9c}},
    {0x8cb8, {0xe7, 0x8b, 0xb9}},
    {0x8cb9, {0xe7, 0xaa, 0x84}},
    {0x8cba, {0xe7, 0x8a, 0xa7}},
    {0x8cbb, {0xe9, 0x8e, 0x96}},
    {0x8cbc, {0xe5, 0xbe, 0xaa}},
    {0x8cbd, {0xe9, 0x9b, 0xb6}},
    {0x8cbe, {0xe5, 0xa3, 0x99}},
    {0x8cbf, {0xe9, 0x96, 0x83}},
    {0x8cc0, {0xe6, 0xbf, 0x83}},
    {0x8cc1, {0xe9, 0x87, 0x87}},
    {0x8cc2, {0xe5, 0xb7, 0xb7}},
    {0x8cc3, {0xe6, 0xbc, 0x8f}},
    {0x8cc4, {0xe3, 0x80, 0x8a}},
    {0x8cc5, {0xe3, 0x80, 0x8b}},
    {0x8cc6, {0xe9, 0x9b, 0xbb}},
    {0x8cc7, {0xe9, 0x80, 0x9d}},
    {0x8cc8, {0xe7, 0xb3, 0xbb}},
    {0x8cc9, {0xe6, 0xb8, 0xb8}},
    {0x8cca, {0xe6, 0xa1, 0x86}},
    {0x8ccb, {0xe7, 0xab, 0xaf}},
    {0x8ccc, {0xe6, 0x9b, 0x86}},
    {0x8ccd, {0xe6, 0x9f, 0xb1}},
    {0x8cce, {0xe7, 0xab, 0x9f}},
    {0x8ccf, {0xe6, 0xa3, 0x95}},
    {0x8cd0, {0xe7, 0x9a, 0xae}},
    {0x8cd1, {0xe8, 0xa4, 0x90}},
    {0x8cd2, {0xe6, 0xb7, 0xba}},
    {0x8cd3, {0xe5, 0x88, 0xa4}},
    {0x8cd4, {0xe5, 0x87, 0xb8}},
    {0x8cd5, {0xe8, 0xab, 0xae}},
    {0x8cd6, {0xe8, 0xa9, 0xa2}},
    {0x8cd7, {0xe7, 0x9b, 0xbc}},
    {0x8cd8, {0xe7, 0xbe, 0xa9}},
    {0x8cd9, {0xe9, 0x81, 0xbd}},
    {0x8cda, {0xe4, 0xbb, 0x8b}},
    {0x8cdb, {0xe6, 0xbf, 0x9f}},
    {0x8cdc, {0xe8, 0xb1, 0x90}},
    {0x8cdd, {0xe6, 0x87, 0xb8}},
    {0x8cde, {0xe6, 0x91, 0x98}},
    {0x8cdf, {0xe5, 0xaf, 0xa1}},
    {0x8ce0, {0xe8, 0xb5, 0xa4}},
    {0x8ce1, {0xe6, 0x82, 0xa3}},
    {0x8ce2, {0xe9, 0x81, 0x9c}},
    {0x8ce3, {0xe5, 0xa5, 0xa2}},
    {0x8ce4, {0xe6, 0x92, 0xab}},
    {0x8ce5, {0xe7, 0xb4, 0xa2}},
    {0x8ce6, {0xe7, 0xb6, 0x9c}},
    {0x8ce7, {0xe8, 0xbe, 0xa8}},
    {0x8ce8, {0xe8, 0x8f, 0xb1}},
    {0x8ce9, {0xe9, 0x87, 0x9d}},
    {0x8cea, {0xe9, 0x8a, 0xb7}},
    {0x8ceb, {0xe7, 0x9b, 0x88}},
    {0x8cec, {0xe5, 0xbe, 0x92}},
    {0x8ced, {0xe7, 0xb9, 0x8b}},
    {0x8cee, {0xe5, 0x96, 0xaa}},
    {0x8cef, {0xe9, 0xa7, 0x90}},
    {0x8cf0, {0xe7, 0xb4, 0xae}},
    {0x8cf1, {0xe6, 0x92, 0xa4}},
    {0x8cf2, {0xe6, 0x84, 0x88}},
    {0x8cf3, {0xe5, 0xbc, 0xad}},
    {0x8cf4, {0xe6, 0x85, 0x8c}},
    {0x8cf5, {0xe6, 0x94, 0x9c}},
    {0x8cf6, {0xe8, 0x9c, 0x82}},
    {0x8cf7, {0xe6, 0xb9, 0xa7}},
    {0x8cf8, {0xe6, 0xaf, 0xab}},
    {0x8cf9, {0xe8, 0xb1, 0xab}},
    {0x8cfa, {0xe6, 0x9c, 0x8b}},
    {0x8cfb, {0xe8, 0x96, 0xa6}},
    {0x8cfc, {0xe5, 0xae, 0xb4}},
    {0x8cfd, {0xe7, 0xb3, 0xbe}},
    {0x8cfe, {0xe8, 0xa1, 0xa3}},
    {0x8cff, {0xe6, 0x8e, 0xae}},
    {0x8d80, {0xe5, 0xae, 0xa2}},
    {0x8d81, {0xe5, 0x8f, 0x89}},
    {0x8d82, {0xe5, 0x9d, 0x90}},
    {0x8d83, {0xe6, 0xa2, 0xaf}},
    {0x8d84, {0xe9, 0x87, 0x8b}},
    {0x8d85, {0xe9, 0xae, 0xae}},
    {0x8d86, {0xe7, 0x86, 0x9f}},
    {0x8d87, {0xe5, 0x89, 0xb2}},
    {0x8d88, {0xe8, 0xaa, 0x98}},
    {0x8d89, {0xe6, 0x83, 0x91}},
    {0x8d8a, {0xe8, 0x81, 0xb0}},
    {0x8d8b, {0xe7, 0x80, 0x8f}},
    {0x8d8c, {0xe8, 0xa6, 0xbd}},
    {0x8d8d, {0xe9, 0xb3, 0xa5}},
    {0x8d8e, {0xe7, 0xa2, 0x8c}},
    {0x8d8f, {0xe9, 0x97, 0xa2}},
    {0x8d90, {0xe6, 0x97, 0x85}},
    {0x8d91, {0xe7, 0xb9, 0x9e}},
    {0x8d92, {0xe5, 0x81, 0x87}},
    {0x8d93, {0xe8, 0xa8, 0x82}},
    {0x8d94, {0xe5, 0xbc, 0x84}},
    {0x8d95, {0xe8, 0xb7, 0x91}},
    {0x8d96, {0xe8, 0xbe, 0xad}},
    {0x8d97, {0xe5, 0xab, 0x89}},
    {0x8d98, {0xe5, 0xa6, 0x92}},
    {0x8d99, {0xe6, 0x8e, 0x8c}},
    {0x8d9a, {0xe5, 0x8d, 0x9c}},
    {0x8d9b, {0xe7, 0xad, 0x96}},
    {0x8d9c, {0xe5, 0x9c, 0x98}},
    {0x8d9d, {0xe5, 0x8c, 0x95}},
    {0x8d9e, {0xe9, 0xbe, 0x9c}},
    {0x8d9f, {0xe5, 0x8a, 0x91}},
    {0x8da0, {0xe7, 0xb9, 0x94}},
    {0x8da1, {0xe5, 0x89, 0x8a}},
    {0x8da2, {0xe8, 0xab, 0xba}},
    {0x8da3, {0xe4, 0xba, 0x91}},
    {0x8da4, {0xe7, 0x97, 0x8a}},
    {0x8da5, {0xe7, 0x99, 0x92}},
    {0x8da6, {0xe4, 0xba, 0x92}},
    {0x8da7, {0xe5, 0x99, 0xaa}},
    {0x8da8, {0xe6, 0x98, 0x82}},
    {0x8da9, {0xe7, 0x87, 0x88}},
    {0x8daa, {0xe6, 0x9a, 0x96}},
    {0x8dab, {0xe6, 0xbb, 0xaf}},
    {0x8dac, {0xe7, 0xbe, 0x9e}},
    {0x8dad, {0xe6, 0xb3, 0xa5}},
    {0x8dae, {0xe5, 0xbe, 0x91}},
    {0x8daf, {0xe8, 0x88, 0x96}},
    {0x8db0, {0xe5, 0xbd, 0x8e}},
    {0x8db1, {0xe7, 0xb5, 0xa1}},
    {0x8db2, {0xe7, 0x96, 0x8a}},
    {0x8db3, {0xe5, 0x80, 0x9a}},
    {0x8db4, {0xe6, 0x87, 0xb2}},
    {0x8db5, {0xe7, 0xbd, 0xb0}},
    {0x8db6, {0xe9, 0x81, 0x8d}},
    {0x8db7, {0xe6, 0xbe, 0xa4}},
    {0x8db8, {0xe8, 0xb9, 0xa6}},
    {0x8db9, {0xe6, 0x81, 0x86}},
    {0x8dba, {0xe6, 0x80, 0xaa}},
    {0x8dbb, {0xe9, 0x8f, 0x88}},
    {0x8dbc, {0xe7, 0xb1, 0x8d}},
    {0x8dbd, {0xe5, 0x9c, 0x88}},
    {0x8dbe, {0xe6, 0x8f, 0x92}},
    {0x8dbf, {0xe5, 0xb0, 0x84}},
    {0x8dc0, {0xe8, 0x85, 0xb9}},
    {0x8dc1, {0xe8, 0xb3, 0xa6}},
    {0x8dc2, {0xe6, 0x95, 0x85}},
    {0x8dc3, {0xe7, 0x94, 0xb0}},
    {0x8dc4, {0xe4, 0xb8, 0x91}},
    {0x8dc5, {0xe9, 0xa0, 0x83}},
    {0x8dc6, {0xe6, 0x8f, 0xa1}},
    {0x8dc7, {0xe8, 0xba, 0x9d}},
    {0x8dc8, {0xe5, 0xb1, 0xa5}},
    {0x8dc9, {0xe5, 0xbe, 0x81}},
    {0x8dca, {0xe4, 0xbd, 0x83}},
    {0x8dcb, {0xe7, 0x89, 0x9b}},
    {0x8dcc, {0xe6, 0xa3, 0x97}},
    {0x8dcd, {0xe6, 0xa4, 0xb0}},
    {0x8dce, {0xe6, 0x9d, 0x8e}},
    {0x8dcf, {0xe7, 0xa7, 0x9f}},
    {0x8dd0, {0xe8, 0x86, 0x8f}},
    {0x8dd1, {0xe9, 0x91, 0xb2}},
    {0x8dd2, {0xe5, 0xb5, 0x8c}},
    {0x8dd3, {0xe5, 0xbb, 0x8a}},
    {0x8dd4, {0xe7, 0xb7, 0xbb}},
    {0x8dd5, {0xe5, 0xaf, 0x92}},
    {0x8dd6, {0xe6, 0xbd, 0xae}},
    {0x8dd7, {0xe6, 0xba, 0xbc}},
    {0x8dd8, {0xe6, 0xa4, 0x85}},
    {0x8dd9, {0xe8, 0x85, 0xb3}},
    {0x8dda, {0xe5, 0x87, 0xb3}},
    {0x8ddb, {0xe6, 0xa1, 0x8c}},
    {0x8ddc, {0xe6, 0x96, 0x9c}},
    {0x8ddd, {0xe8, 0xbb, 0x9f}},
    {0x8dde, {0xe5, 0xa2, 0x8a}},
    {0x8ddf, {0xe6, 0x9d, 0xaf}},
    {0x8de0, {0xe7, 0xa2, 0x97}},
    {0x8de1, {0xe6, 0xab, 0xa5}},
    {0x8de2, {0xe9, 0xa6, 0x99}},
    {0x8de3, {0xe8, 0xa0, 0x9f}},
    {0x8de4, {0xe7, 0x87, 0xad}},
    {0x8de5, {0xe5, 0x98, 0x86}},
    {0x8de6, {0xe5, 0xbb, 0x93}},
    {0x8de7, {0xe6, 0xa8, 0x93}},
    {0x8de8, {0xe5, 0x8d, 0x87}},
    {0x8de9, {0xe9, 0x9d, 0x92}},
    {0x8dea, {0xe7, 0x9d, 0x9e}},
    {0x8deb, {0xe8, 0x82, 0xa9}},
    {0x8dec, {0xe9, 0xbd, 0x8a}},
    {0x8ded, {0xe4, 0xbc, 0xb8}},
    {0x8dee, {0xe5, 0x88, 0x91}},
    {0x8def, {0xe4, 0xbc, 0x8d}},
    {0x8df0, {0xe9, 0x99, 0xaa}},
    {0x8df1, {0xe9, 0x82, 0xb1}},
    {0x8df2, {0xe5, 0x93, 0xa9}},
    {0x8df3, {0xe6, 0xba, 0xaf}},
    {0x8df4, {0xe5, 0xb7, 0x9d}},
    {0x8df5, {0xe8, 0x87, 0xba}},
    {0x8df6, {0xe6, 0xb4, 0xaa}},
    {0x8df7, {0xe6, 0xb2, 0x96}},
    {0x8df8, {0xe6, 0x9c, 0xbd}},
    {0x8df9, {0xe9, 0x89, 0x9b}},
    {0x8dfa, {0xe6, 0xbe, 0xb1}},
    {0x8dfb, {0xe6, 0xa7, 0xbd}},
    {0x8dfc, {0xe9, 0x96, 0x98}},
    {0x8dfd, {0xe9, 0xbe, 0x8d}},
    {0x8dfe, {0xe4, 0xbc, 0x81}},
    {0x8dff, {0xe7, 0xa7, 0xa9}},
    {0x8e80, {0xe4, 0xb8, 0x96}},
    {0x8e81, {0xe6, 0xbf, 0x81}},
    {0x8e82, {0xe5, 0xb0, 0xba}},
    {0x8e83, {0xe8, 0x9d, 0x95}},
    {0x8e84, {0xe8, 0x92, 0xb8}},
    {0x8e85, {0xe6, 0xba, 0x9d}},
    {0x8e86, {0xe5, 0xa0, 0xaa}},
    {0x8e87, {0xe6, 0xbb, 0xb2}},
    {0x8e88, {0xe5, 0xa3, 0xa4}},
    {0x8e89, {0xe6, 0xbf, 0xbe}},
    {0x8e8a, {0xe7, 0x94, 0x9c}},
    {0x8e8b, {0xe8, 0x81, 0x9e}},
    {0x8e8c, {0xe8, 0xac, 0xa0}},
    {0x8e8d, {0xe9, 0x8f, 0xa1}},
    {0x8e8e, {0xe6, 0x8a, 0xab}},
    {0x8e8f, {0xe5, 0x88, 0x80}},
    {0x8e90, {0xe7, 0xb2, 0x97}},
    {0x8e91, {0xe7, 0xb3, 0x99}},
    {0x8e92, {0xe6, 0x91, 0x92}},
    {0x8e93, {0xe5, 0x89, 0x83}},
    {0x8e94, {0xe9, 0x88, 0x8d}},
    {0x8e95, {0xe7, 0x9a, 0x80}},
    {0x8e96, {0xe7, 0x94, 0xb7}},
    {0x8e97, {0xe5, 0xa6, 0x9d}},
    {0x8e98, {0xe6, 0xbc, 0x86}},
    {0x8e99, {0xe8, 0x86, 0x9a}},
    {0x8e9a, {0xe9, 0x81, 0xae}},
    {0x8e9b, {0xe4, 0xb9, 0xb3}},
    {0x8e9c, {0xe9, 0x9c, 0x9c}},
    {0x8e9d, {0xe8, 0x97, 0xa5}},
    {0x8e9e, {0xe6, 0x91, 0xa9}},
    {0x8e9f, {0xe8, 0x87, 0x89}},
    {0x8ea0, {0xe9, 0xa0, 0xb0}},
    {0x8ea1, {0xe7, 0x95, 0x9d}},
    {0x8ea2, {0xe5, 0xa3, 0x81}},
    {0x8ea3, {0xe7, 0xb4, 0x8b}},
    {0x8ea4, {0xe9, 0x9a, 0xa7}},
    {0x8ea5, {0xe6, 0xa2, 0xad}},
    {0x8ea6, {0xe6, 0xb1, 0x97}},
    {0x8ea7, {0xe6, 0xb1, 0xbd}},
    {0x8ea8, {0xe6, 0x93, 0xa6}},
    {0x8ea9, {0xe6, 0x8a, 0xb9}},
    {0x8eaa, {0xe5, 0x8d, 0x9a}},
    {0x8eab, {0xe7, 0x88, 0x90}},
    {0x8eac, {0xe5, 0xa5, 0xb6}},
    {0x8ead, {0xe6, 0x93, 0x85}},
    {0x8eae, {0xe7, 0xa7, 0x98}},
    {0x8eaf, {0xe8, 0x96, 0x91}},
    {0x8eb0, {0xe7, 0xbd, 0x8c}},
    {0x8eb1, {0xe7, 0xb2, 0x9f}},
    {0x8eb2, {0xe8, 0x8a, 0xa5}},
    {0x8eb3, {0xe8, 0xb2, 0x93}},
    {0x8eb4, {0xe7, 0xb3, 0x9e}},
    {0x8eb5, {0xe9, 0xb7, 0xb9}},
    {0x8eb6, {0xe7, 0x88, 0xaa}},
    {0x8eb7, {0xe5, 0x89, 0x96}},
    {0x8eb8, {0xe4, 0xb9, 0x83}},
    {0x8eb9, {0xe9, 0xa0, 0x97}},
    {0x8eba, {0xe7, 0x96, 0x91}},
    {0x8ebb, {0xe6, 0xaf, 0x8d}},
    {0x8ebc, {0xe7, 0x80, 0x95}},
    {0x8ebd, {0xe5, 0x85, 0xbc}},
    {0x8ebe, {0xe5, 0x8f, 0xab}},
    {0x8ebf, {0xe4, 0xbf, 0x97}},
    {0x8ec0, {0xe7, 0x8c, 0xa9}},
    {0x8ec1, {0xe8, 0xad, 0xbd}},
    {0x8ec2, {0xe8, 0xab, 0xb7}},
    {0x8ec3, {0xe8, 0x87, 0xa3}},
    {0x8ec4, {0xe5, 0x80, 0xa1}},
    {0x8ec5, {0xe4, 0xbe, 0xb7}},
    {0x8ec6, {0xe5, 0xae, 0xb0}},
    {0x8ec7, {0xe8, 0xb2, 0x9d}},
    {0x8ec8, {0xe7, 0xae, 0xb4}},
    {0x8ec9, {0xe8, 0xab, 0xad}},
    {0x8eca, {0xe9, 0x82, 0x81}},
    {0x8ecb, {0xe6, 0xb4, 0x9e}},
    {0x8ecc, {0xe7, 0xa9, 0xb4}},
    {0x8ecd, {0xe8, 0xad, 0xaf}},
    {0x8ece, {0xe8, 0x87, 0x9f}},
    {0x8ecf, {0xe8, 0x8a, 0x99}},
    {0x8ed0, {0xe9, 0xbb, 0x9b}},
    {0x8ed1, {0xe8, 0x8c, 0xb1}},
    {0x8ed2, {0xe8, 0x8e, 0x89}},
    {0x8ed3, {0xe5, 0xa7, 0xa6}},
    {0x8ed4, {0xe5, 0x8b, 0x92}},
    {0x8ed5, {0xe9, 0x9b, 0xb7}},
    {0x8ed6, {0xe5, 0xa9, 0xa6}},
    {0x8ed7, {0xe7, 0xa6, 0xb1}},
    {0x8ed8, {0xe7, 0xa5, 0x88}},
    {0x8ed9, {0xe8, 0x98, 0xbf}},
    {0x8eda, {0xe5, 0xa8, 0x9c}},
    {0x8edb, {0xe5, 0x86, 0xac}},
    {0x8edc, {0xe5, 0xad, 0xa3}},
    {0x8edd, {0xe6, 0x98, 0xa5}},
    {0x8ede, {0xe5, 0x86, 0xa5}},
    {0x8edf, {0xe8, 0xb3, 0x80}},
    {0x8ee0, {0xe7, 0xbf, 0x85}},
    {0x8ee1, {0xe8, 0x86, 0x80}},
    {0x8ee2, {0xe6, 0xb6, 0xbc}},
    {0x8ee3, {0xe9, 0x9e, 0x8b}},
    {0x8ee4, {0xe5, 0xb8, 0xbd}},
    {0x8ee5, {0xe5, 0xbb, 0xb7}},
    {0x8ee6, {0xe5, 0xa3, 0x87}},
    {0x8ee7, {0xe6, 0x8f, 0x8f}},
    {0x8ee8, {0xe7, 0xb9, 0xaa}},
    {0x8ee9, {0xe9, 0xac, 0x9a}},
    {0x8eea, {0xe6, 0x88, 0x9f}},
    {0x8eeb, {0xe7, 0x88, 0xb6}},
    {0x8eec, {0xe6, 0x9c, 0xab}},
    {0x8eed, {0xe7, 0xa5, 0xa8}},
    {0x8eee, {0xe8, 0xa1, 0xb7}},
    {0x8eef, {0xe7, 0x9f, 0xa9}},
    {0x8ef0, {0xe8, 0x8e, 0x8e}},
    {0x8ef1, {0xe7, 0xb4, 0x99}},
    {0x8ef2, {0xe7, 0x9a, 0xba}},
    {0x8ef3, {0xe7, 0x9c, 0x89}},
    {0x8ef4, {0xe5, 0xb9, 0xbd}},
    {0x8ef5, {0xe9, 0xbb, 0x98}},
    {0x8ef6, {0xe8, 0xa2, 0x8d}},
    {0x8ef7, {0xe5, 0xa5, 0x97}},
    {0x8ef8, {0xe6, 0x9c, 0x97}},
    {0x8ef9, {0xe5, 0xa7, 0xbf}},
    {0x8efa, {0xe6, 0x91, 0x94}},
    {0x8efb, {0xe7, 0xa5, 0xbf}},
    {0x8efc, {0xe5, 0x94, 0xb1}},
    {0x8efd, {0xe5, 0x87, 0x86}},
    {0x8efe, {0xe8, 0x91, 0xac}},
    {0x8eff, {0xe8, 0x89, 0xbe}},
    {0x8f80, {0xe8, 0x8f, 0xb2}},
    {0x8f81, {0xe7, 0xb4, 0x90}},
    {0x8f82, {0xe5, 0x9d, 0x80}},
    {0x8f83, {0xe9, 0x9f, 0x8b}},
    {0x8f84, {0xe5, 0xb8, 0x95}},
    {0x8f85, {0xe6, 0x8a, 0xbd}},
    {0x8f86, {0xe7, 0x9b, 0x9b}},
    {0x8f87, {0xe5, 0xb8, 0x86}},
    {0x8f88, {0xe8, 0x94, 0xbd}},
    {0x8f89, {0xe6, 0xb7, 0x8b}},
    {0x8f8a, {0xe6, 0x9b, 0xac}},
    {0x8f8b, {0xe7, 0x89, 0xa2}},
    {0x8f8c, {0xe7, 0xb1, 0xa0}},
    {0x8f8d, {0xe5, 0x9b, 0x9a}},
    {0x8f8e, {0xe6, 0xa9, 0xa2}},
    {0x8f8f, {0xe8, 0xb0, 0xb7}},
    {0x8f90, {0xe5, 0x90, 0xb9}},
    {0x8f91, {0xe8, 0xac, 0x80}},
    {0x8f92, {0xe7, 0xb0, 0xbd}},
    {0x8f93, {0xe6, 0x8b, 0xbc}},
    {0x8f94, {0xe6, 0x90, 0x8f}},
    {0x8f95, {0xe7, 0x89, 0x8c}},
    {0x8f96, {0xe6, 0x8b, 0x87}},
    {0x8f97, {0xe6, 0x9f, 0xb4}},
    {0x8f98, {0xe5, 0xb1, 0x8d}},
    {0x8f99, {0xe5, 0x96, 0x87}},
    {0x8f9a, {0xe5, 0x8f, 0xad}},
    {0x8f9b, {0xe8, 0x99, 0x8e}},
    {0x8f9c, {0xe4, 0xb8, 0x9f}},
    {0x8f9d, {0xe6, 0x88, 0xae}},
    {0x8f9e, {0xe5, 0x97, 0x9c}},
    {0x8f9f, {0xe7, 0x8f, 0xa0}},
    {0x8fa0, {0xe8, 0xb3, 0xad}},
    {0x8fa1, {0xe7, 0x9b, 0x94}},
    {0x8fa2, {0xe8, 0x83, 0xb8}},
    {0x8fa3, {0xe8, 0x85, 0xbf}},
    {0x8fa4, {0xe6, 0x9f, 0x84}},
    {0x8fa5, {0xe7, 0xb9, 0xa9}},
    {0x8fa6, {0xe8, 0x85, 0xb0}},
    {0x8fa7, {0xe7, 0xba, 0x8f}},
    {0x8fa8, {0xe6, 0xa7, 0x93}},
    {0x8fa9, {0xe6, 0xa1, 0xbf}},
    {0x8faa, {0xe8, 0xb8, 0xa9}},
    {0x8fab, {0xe8, 0xb8, 0x8f}},
    {0x8fac, {0xe7, 0x8d, 0x8e}},
    {0x8fad, {0xe9, 0xb4, 0xbf}},
    {0x8fae, {0xe6, 0xb2, 0xbc}},
    {0x8faf, {0xe5, 0xa2, 0x93}},
    {0x8fb0, {0xe9, 0x82, 0xa6}},
    {0x8fb1, {0xe9, 0x9c, 0xb8}},
    {0x8fb2, {0xe8, 0xb6, 0xa8}},
    {0x8fb3, {0xe4, 0xbb, 0xbf}},
    {0x8fb4, {0xe9, 0xa9, 0x85}},
    {0x8fb5, {0xe5, 0x9d, 0xa6}},
    {0x8fb6, {0xe5, 0xa0, 0xa1}},
    {0x8fb7, {0xe9, 0x8a, 0x85}},
    {0x8fb8, {0xe8, 0x9e, 0x8d}},
    {0x8fb9, {0xe5, 0xb4, 0x9b}},
    {0x8fba, {0xe5, 0xb1, 0x88}},
    {0x8fbb, {0xe6, 0xa5, 0x9a}},
    {0x8fbc, {0xe5, 0xb1, 0xa0}},
    {0x8fbd, {0xe8, 0x97, 0x89}},
    {0x8fbe, {0xe7, 0x90, 0x83}},
    {0x8fbf, {0xe9, 0x99, 0xbd}},
    {0x8fc0, {0xe6, 0x9e, 0x9a}},
    {0x8fc1, {0xe8, 0xb2, 0x8c}},
    {0x8fc2, {0xe9, 0x91, 0xbf}},
    {0x8fc3, {0xe6, 0xa4, 0x8e}},
    {0x8fc4, {0xe7, 0x8e, 0xab}},
    {0x8fc5, {0xe7, 0x91, 0xb0}},
    {0x8fc6, {0xe8, 0x97, 0xa4}},
    {0x8fc7, {0xe8, 0xb2, 0xa9}},
    {0x8fc8, {0xe5, 0x8b, 0x98}},
    {0x8fc9, {0xe5, 0xbc, 0x94}},
    {0x8fca, {0xe8, 0x89, 0xb7}},
    {0x8fcb, {0xe6, 0x84, 0x81}},
    {0x8fcc, {0xe6, 0xb1, 0xaa}},
    {0x8fcd, {0xe8, 0x89, 0xa6}},
    {0x8fce, {0xe5, 0x8c, 0xbf}},
    {0x8fcf, {0xe6, 0xbb, 0xbe}},
    {0x8fd0, {0xe5, 0x99, 0xb8}},
    {0x8fd1, {0xe6, 0xbc, 0xb2}},
    {0x8fd2, {0xe9, 0xa7, 0x81}},
    {0x8fd3, {0xe7, 0xb5, 0x9e}},
    {0x8fd4, {0xe5, 0xa0, 0xa4}},
    {0x8fd5, {0xe7, 0xa2, 0x87}},
    {0x8fd6, {0xe9, 0x9c, 0x8d}},
    {0x8fd7, {0xe8, 0xa1, 0xb0}},
    {0x8fd8, {0xe7, 0x96, 0x86}},
    {0x8fd9, {0xe5, 0x93, 0x88}},
    {0x8fda, {0xe7, 0x88, 0xac}},
    {0x8fdb, {0xe4, 0xbc, 0xba}},
    {0x8fdc, {0xe6, 0x94, 0x80}},
    {0x8fdd, {0xe6, 0x93, 0xba}},
    {0x8fde, {0xe5, 0xbc, 0x93}},
    {0x8fdf, {0xe6, 0x88, 0x92}},
    {0x8fe0, {0xe7, 0x89, 0xbd}},
    {0x8fe1, {0xe5, 0x82, 0xbe}},
    {0x8fe2, {0xe6, 0xa1, 0xb6}},
    {0x8fe3, {0xe8, 0xb3, 0xb4}},
    {0x8fe4, {0xe7, 0xb2, 0x89}},
    {0x8fe5, {0xe5, 0x9d, 0x8a}},
    {0x8fe6, {0xe9, 0xba, 0xa5}},
    {0x8fe7, {0xe6, 0x9d, 0xbe}},
    {0x8fe8, {0xe8, 0x84, 0x82}},
    {0x8fe9, {0xe8, 0xb1, 0x86}},
    {0x8fea, {0xe5, 0x89, 0x94}},
    {0x8feb, {0xe5, 0x95, 0xa4}},
    {0x8fec, {0xe6, 0xb1, 0x81}},
    {0x8fed, {0xe8, 0x90, 0x83}},
    {0x8fee, {0xe9, 0x85, 0xb5}},
    {0x8fef, {0xe5, 0x9a, 0x90}},
    {0x8ff0, {0xe7, 0x93, 0xb7}},
    {0x8ff1, {0xe9, 0xa3, 0xbc}},
    {0x8ff2, {0xe8, 0xa5, 0xaf}},
    {0x8ff3, {0xe7, 0xa0, 0x82}},
    {0x8ff4, {0xe5, 0xb6, 0xba}},
    {0x8ff5, {0xe5, 0xb4, 0x97}},
    {0x8ff6, {0xe6, 0xb0, 0xbe}},
    {0x8ff7, {0xe6, 0xbf, 0xab}},
    {0x8ff8, {0xe9, 0x8f, 0x9f}},
    {0x8ff9, {0xe7, 0xb4, 0x94}},
    {0x8ffa, {0xe7, 0xb2, 0xb9}},
    {0x8ffb, {0xe8, 0x80, 0xb3}},
    {0x8ffc, {0xe7, 0x85, 0x89}},
    {0x8ffd, {0xe5, 0x86, 0xb6}},
    {0x8ffe, {0xe8, 0xbe, 0x9b}},
    {0x8fff, {0xe7, 0x8d, 0xb5}},
    {0x9080, {0xe5, 0x9b, 0x82}},
    {0x9081, {0xe6, 0xbc, 0xbf}},
    {0x9082, {0xe6, 0x99, 0xb6}},
    {0x9083, {0xe7, 0x9b, 0x86}},
    {0x9084, {0xe6, 0x9b, 0x9d}},
    {0x9085, {0xe5, 0x90, 0xab}},
    {0x9086, {0xe6, 0xb8, 0xb4}},
    {0x9087, {0xe9, 0x91, 0x91}},
    {0x9088, {0xe7, 0xb3, 0x8a}},
    {0x9089, {0xe6, 0xb8, 0xa3}},
    {0x908a, {0xe6, 0xbb, 0x93}},
    {0x908b, {0xe7, 0xa2, 0xbe}},
    {0x908c, {0xe6, 0xbb, 0xb4}},
    {0x908d, {0xe7, 0x82, 0xad}},
    {0x908e, {0xe6, 0x95, 0xb2}},
    {0x908f, {0xe6, 0xb7, 0xac}},
    {0x9090, {0xe9, 0x8d, 0x9b}},
    {0x9091, {0xe9, 0x8b, 0xbc}},
    {0x9092, {0xe8, 0x8c, 0x85}},
    {0x9093, {0xe9, 0x9f, 0x8c}},
    {0x9094, {0xe5, 0xbd, 0x88}},
    {0x9095, {0xe9, 0x89, 0xb8}},
    {0x9096, {0xe9, 0xb1, 0x97}},
    {0x9097, {0xe5, 0xa4, 0xbe}},
    {0x9098, {0xe8, 0xba, 0xba}},
    {0x9099, {0xe6, 0xb9, 0x8a}},
    {0x909a, {0xe5, 0xbb, 0x81}},
    {0x909b, {0xe4, 0xbe, 0x96}},
    {0x909c, {0xe7, 0xa3, 0x85}},
    {0x909d, {0xe9, 0x86, 0xac}},
    {0x909e, {0xe5, 0xad, 0x94}},
    {0x909f, {0xe5, 0x96, 0xa7}},
    {0x90a0, {0xe5, 0xaf, 0xa9}},
    {0x90a1, {0xe5, 0x96, 0x9d}},
    {0x90a2, {0xe7, 0x84, 0x9a}},
    {0x90a3, {0xe5, 0x96, 0x80}},
    {0x90a4, {0xe7, 0xa1, 0xac}},
    {0x90a5, {0xe6, 0x94, 0xa4}},
    {0x90a6, {0xe5, 0x85, 0x8c}},
    {0x90a7, {0xe8, 0xaa, 0x95}},
    {0x90a8, {0xe6, 0x9b, 0xb3}},
    {0x90a9, {0xe8, 0xa8, 0x97}},
    {0x90aa, {0xe9, 0xa5, 0x8b}},
    {0x90ab, {0xe5, 0x96, 0x94}},
    {0x90ac, {0xe8, 0xa8, 0xa3}},
    {0x90ad, {0xe9, 0xa5, 0x91}},
    {0x90ae, {0xe8, 0x87, 0xa7}},
    {0x90af, {0xe9, 0xa4, 0x8c}},
    {0x90b0, {0xe6, 0xb5, 0xa6}},
    {0x90b1, {0xe7, 0x88, 0xbd}},
    {0x90b2, {0xe5, 0x93, 0xa6}},
    {0x90b3, {0xe5, 0xb4, 0x8e}},
    {0x90b4, {0xe5, 0xb6, 0x87}},
    {0x90b5, {0xe7, 0xb4, 0x9b}},
    {0x90b6, {0xe6, 0x8e, 0x99}},
    {0x90b7, {0xe6, 0x89, 0x8e}},
    {0x90b8, {0xe6, 0x87, 0xbc}},
    {0x90b9, {0xe6, 0x99, 0xa8}},
    {0x90ba, {0xe5, 0x87, 0xb6}},
    {0x90bb, {0xe6, 0x92, 0xa5}},
    {0x90bc, {0xe6, 0x90, 0x9e}},
    {0x90bd, {0xe6, 0x87, 0xb7}},
    {0x90be, {0xe5, 0xad, 0xbd}},
    {0x90bf, {0xe7, 0xa5, 0x96}},
    {0x90c0, {0xe7, 0x97, 0xb4}},
    {0x90c1, {0xe7, 0xb0, 0xbf}},
    {0x90c2, {0xe5, 0x9b, 0x8a}},
    {0x90c3, {0xe6, 0xac, 0xba}},
    {0x90c4, {0xe9, 0xa8, 0x99}},
    {0x90c5, {0xe7, 0x8d, 0x84}},
    {0x90c6, {0xe7, 0xb6, 0x81}},
    {0x90c7, {0xe5, 0xbd, 0x8c}},
    {0x90c8, {0xe5, 0xb6, 0xbc}},
    {0x90c9, {0xe5, 0xa4, 0x8f}},
    {0x90ca, {0xe7, 0x9d, 0xac}},
    {0x90cb, {0xe6, 0x82, 0xa0}},
    {0x90cc, {0xe5, 0x97, 0xa3}},
    {0x90cd, {0xe5, 0x86, 0xa0}},
    {0x90ce, {0xe9, 0x9e, 0x8f}},
    {0x90cf, {0xe9, 0x80, 0xb8}},
    {0x90d0, {0xe5, 0xbc, 0x9f}},
    {0x90d1, {0xe8, 0x98, 0x87}},
    {0x90d2, {0xe8, 0x98, 0xad}},
    {0x90d3, {0xe5, 0x9d, 0x8d}},
    {0x90d4, {0xe8, 0xa9, 0xa3}},
    {0x90d5, {0xe6, 0xac, 0xb2}},
    {0x90d6, {0xe9, 0xa9, 0xa2}},
    {0x90d7, {0xe6, 0x9f, 0xaf}},
    {0x90d8, {0xe7, 0x88, 0xb5}},
    {0x90d9, {0xe8, 0x91, 0x9b}},
    {0x90da, {0xe5, 0xa7, 0x86}},
    {0x90db, {0xe9, 0x8c, 0xab}},
    {0x90dc, {0xe6, 0xb3, 0xb0}},
    {0x90dd, {0xe6, 0xa2, 0x85}},
    {0x90de, {0xe4, 0xbc, 0x8f}},
    {0x90df, {0xe5, 0xa5, 0x8e}},
    {0x90e0, {0xe4, 0xb8, 0xb9}},
    {0x90e1, {0xe4, 0xbd, 0xa9}},
    {0x90e2, {0xe6, 0x88, 0x88}},
    {0x90e3, {0xe6, 0x98, 0x86}},
    {0x90e4, {0xe6, 0xb1, 0x8e}},
    {0x90e5, {0xe8, 0x95, 0xbe}},
    {0x90e6, {0xe9, 0x90, 0xb8}},
    {0x90e7, {0xe6, 0x9d, 0x9c}},
    {0x90e8, {0xe4, 0xba, 0xa8}},
    {0x90e9, {0xe4, 0xbd, 0x9b}},
    {0x90ea, {0xe8, 0x92, 0x99}},
    {0x90eb, {0xe6, 0xb9, 0xaf}},
    {0x90ec, {0xe7, 0x93, 0x9c}},
    {0x90ed, {0xe5, 0xb9, 0xbc}},
    {0x90ee, {0xe8, 0x8c, 0xb2}},
    {0x90ef, {0xe5, 0x9d, 0x8e}},
    {0x90f0, {0xe8, 0x83, 0xa1}},
    {0x90f1, {0xe8, 0x96, 0x9b}},
    {0x90f2, {0xe5, 0x91, 0x82}},
    {0x90f3, {0xe8, 0xb3, 0x93}},
    {0x90f4, {0xe5, 0x8e, 0x84}},
    {0x90f5, {0xe9, 0x99, 0xb3}},
    {0x90f6, {0xe7, 0x91, 0x9e}},
    {0x90f7, {0xe6, 0x80, 0x96}},
    {0x90f8, {0xe8, 0x82, 0x85}},
    {0x90f9, {0xe8, 0x82, 0x9d}},
    {0x90fa, {0xe7, 0xa6, 0xbf}},
    {0x90fb, {0xe8, 0xac, 0xb9}},
    {0x90fc, {0xe6, 0x85, 0x8e}},
    {0x90fd, {0xe7, 0xbf, 0xb0}},
    {0x90fe, {0xe8, 0x9c, 0x98}},
    {0x90ff, {0xe8, 0x9b, 0x9b}},
    {0x9180, {0xe8, 0xb6, 0xbe}},
    {0x9181, {0xe5, 0xb7, 0xab}},
    {0x9182, {0xe5, 0x92, 0xac}},
    {0x9183, {0xe5, 0x9a, 0xbc}},
    {0x9184, {0xe6, 0xa1, 0x91}},
    {0x9185, {0xe7, 0xbf, 0x81}},
    {0x9186, {0xe8, 0xa9, 0xb9}},
    {0x9187, {0xe4, 0xbf, 0xbe}},
    {0x9188, {0xe8, 0x82, 0xa1}},
    {0x9189, {0xe9, 0xba, 0x93}},
    {0x918a, {0xe5, 0x94, 0xaf}},
    {0x918b, {0xe5, 0xbe, 0xb9}}
};

static chinese_entry *utf8_to_codepage;

typedef struct {
    uint16_t image_id;
    uint16_t codepage;
} image_entry;

// only define the characters that are actually used in the language files
static image_entry image_entries[] = {
    {4, 0xb943},
    {5, 0xc0b8},
    {14, 0xc2f7},
    {15, 0xb67d},
    {51, 0xabd2},
    {68, 0xad6e},
    {69, 0xc3b9},
    {70, 0xb0a8},
    {71, 0xb0ea},
    {72, 0xb6dc},
    {73, 0xa148},
    {80, 0xaaba},
    {118, 0xa175},
    {119, 0xb3cd},
    {120, 0xbcbb},
    {121, 0xa46a},
    {122, 0xa176},
    {297, 0xa1d0},
    {782, 0xb751},
    {1439, 0xa2bb},
    {0, 0}
};

static int compare_utf8(const void *a, const void *b)
{
    const uint8_t *va = ((const chinese_entry*) a)->utf8;
    const uint8_t *vb = ((const chinese_entry*) b)->utf8;
    for (int i = 0; i < 3; i++) {
        if (va[i] == vb[i] || (va[i] == 0 || vb[i] == 0)) {
            continue;
        }
        return va[i] < vb[i] ? -1 : 1;
    }
    return 0;
}

static int compare_internal(const void *a, const void *b)
{
    uint16_t va = ((const chinese_entry*) a)->internal;
    uint16_t vb = ((const chinese_entry*) b)->internal;
    return va == vb ? 0 : (va < vb ? -1 : 1);
}

void encoding_trad_chinese_init(void)
{
    if (!utf8_to_codepage) {
        utf8_to_codepage =
            (chinese_entry*) malloc(sizeof(chinese_entry) * IMAGE_FONT_MULTIBYTE_TRAD_CHINESE_MAX_CHARS);
        if (!utf8_to_codepage) {
            log_error("Unable to allocate memory for Chinese codepage", 0, 0);
            return;
        }
    }
    // codepage_to_utf8 is already sorted, copy data and sort the other way around
    memcpy(utf8_to_codepage, codepage_to_utf8,
        IMAGE_FONT_MULTIBYTE_TRAD_CHINESE_MAX_CHARS * sizeof(chinese_entry));

    qsort(utf8_to_codepage, IMAGE_FONT_MULTIBYTE_TRAD_CHINESE_MAX_CHARS, sizeof(chinese_entry), compare_utf8);
}

void encoding_trad_chinese_to_utf8(const uint8_t *input, char *output, int output_length)
{
    const char *max_output = &output[output_length - 1];

    while (*input && output < max_output) {
        if (*input < 0x80) {
            *output = *input;
            ++output;
            ++input;
        } else {
            // multi-byte char
            const chinese_entry key = {input[1] << 8 | input[0]};
            const chinese_entry *entry = bsearch(&key, codepage_to_utf8,
                IMAGE_FONT_MULTIBYTE_TRAD_CHINESE_MAX_CHARS, sizeof(chinese_entry), compare_internal);
            int bytes = entry ? (entry->utf8[2] ? 3 : 2) : 0;
            if (entry && output + bytes <= max_output) {
                for (int i = 0; i < bytes; i++) {
                    *output = entry->utf8[i];
                    output++;
                }
            }
            input += 2;
        }
    }
    *output = 0;
}

void encoding_trad_chinese_from_utf8(const char *input, uint8_t *output, int output_length)
{
    if (!utf8_to_codepage) {
        output[0] = 0;
        return;
    }
    const uint8_t *max_output = &output[output_length - 1];

    while (*input && output < max_output) {
        if ((*input & 0x80) == 0) {
            *output = *input;
            ++output;
            ++input;
        } else {
            // multi-byte char: Chinese characters from the table may be 2 or 3 bytes in UTF-8
            const chinese_entry key = {0, {(uint8_t)input[0], (uint8_t)input[1], (uint8_t)input[2]}};
            const chinese_entry *entry = bsearch(&key, utf8_to_codepage,
                IMAGE_FONT_MULTIBYTE_TRAD_CHINESE_MAX_CHARS, sizeof(chinese_entry), compare_utf8);
            if (entry && output + 2 <= max_output) {
                *output = entry->internal & 0xff;
                output++;
                *output = (entry->internal >> 8) & 0xff;
                output++;
                input += entry->utf8[2] ? 3 : 2;
            } else {
                *output = '?';
                output++;
                input += encoding_get_utf8_character_bytes(*input);
            }
        }
    }
    *output = 0;
}

int encoding_trad_chinese_big5_to_image_id(int big5)
{
    for (int i = 0; image_entries[i].image_id; i++) {
        if (image_entries[i].codepage == big5) {
            return image_entries[i].image_id;
        }
    }
    return -1;
}
