
/*******************************************************************************
 * Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of XTPcpp.
 *
 *     XTPcpp is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTPcpp is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#pragma once

#include <QDialog>
#include <pappsomspp/amino_acid/aamodification.h>
#include <pappsomspp/precision.h>


namespace Ui
{
class ChooseModificationDialog;
}

class ChooseModificationDialog : public QDialog
{
  Q_OBJECT

  public:
  explicit ChooseModificationDialog(QWidget *parent);
  ~ChooseModificationDialog();


  /** @brief set mz target to filter among possible modifications
   */
  void setMzTarget(double target_mz);


  /** @brief set mz precision to filter among possible modifications
   */
  void setPrecision(pappso::PrecisionPtr precision);

  pappso::AaModificationP getSelectedModification() const;

  private:
  Ui::ChooseModificationDialog *ui;
};
