C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LNRAY1
C                       *****************
C
C      -------------------------------------------------------------
     * (NDIM,NELRAY,NODRAY,NRFRAY,NPOINR,ITRAV1,ITRAV2,
     *  NNSRAY,NNFRAY,NNERAY)
C      -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C      NOMBRES DE NOEUDS POUR LE MAILLAGE RAYONNEMENT                  *
C          - noeuds couples avec le fluide                             *
C          - noeuds couples avec le solide                             *
C          - noeuds entree/sortie                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (3     )               !
C !  NPOINR   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE RAYONNEMENT     !
C !  NELRAY   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE RAYONNEMENT        !
C !  NODRAY   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE RAYONNEMENT !
C !  NRFRAY   ! TE ! R  ! TABLEAU DES REFERENCES ELTS MAILLAGE RAYT    !
C !  COORAY   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE RAYONNEMENT     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    !    !                                              !
C ! /DIVCT/   !    !    !                                              !
C ! /NLOFES/  !    !    !                                              !
C ! /NLOFCT/  !    !    !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "xrefer.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NPOINR,NDIM,NNSRAY,NNFRAY,NNERAY
      INTEGER NODRAY(NELRAY,NDIM),NRFRAY(NELRAY)
      INTEGER ITRAV1(NPOINR),ITRAV2(NPOINR)
C
C.. Variables internes
      INTEGER N,M,NF,I
      LOGICAL LS
C
C***********************************************************************
C
C     1- INITIALISATION 
C     =================
C
      DO N=1,NPOINR
        ITRAV1(N) = 0
        ITRAV2(N) = 0
      ENDDO
C
C 
C     2- MARQUAGE DES NOEUDS
C     ======================
C
      DO 200 N=1,NELRAY
C
        NF = NRFRAY(N)
C
        LS = .FALSE.
        DO M=1,NRFMAX
          IF (IRERCS(M).NE.0  .AND. NF.EQ.M) LS = .TRUE.
        ENDDO
C
        IF (LS) THEN
          DO I=1,NDIM
            ITRAV1(NODRAY(N,I)) = 1
          ENDDO
        ENDIF
C
        LS = .FALSE.
        DO M=1,NRFMAX
          IF ((IRERCF(M).NE.0 .OR. IRESTF(M).NE.0 )
     *           .AND. NF.EQ.M) LS = .TRUE.
        ENDDO
C
        IF (LS) THEN
          DO I=1,NDIM
            ITRAV2(NODRAY(N,I)) = 1
          ENDDO
        ENDIF
C
  200 CONTINUE
C
C     3- GENERATION DES LISTES
C     ========================
C
      NNSRAY = 0
      NNFRAY = 0
      NNERAY = 0
C
      DO N=1,NPOINR
        IF (ITRAV1(N).EQ.1) NNSRAY = NNSRAY + 1
        IF (ITRAV2(N).EQ.1) NNFRAY = NNFRAY + 1
      ENDDO
C
C
C
C--------
C FORMATS
C--------
C
C
      END
