# - Try to find NumPy
# Once done this will define
#
#   NUMPY_FOUND        - system has NumPy
#   NUMPY_INCLUDE_DIRS - include directories for NumPy

if (NOT NUMPY_INCLUDE_DIRS)
  execute_process(
    COMMAND ${PYTHON_EXECUTABLE} -c "import numpy; print numpy.get_include()"
    OUTPUT_VARIABLE NUMPY_INCLUDE_DIR
    OUTPUT_STRIP_TRAILING_WHITESPACE)

  if (EXISTS ${NUMPY_INCLUDE_DIR})
    set(NUMPY_INCLUDE_DIRS ${NUMPY_INCLUDE_DIR} CACHE STRING "NumPy include path")
    mark_as_advanced(NUMPY_INCLUDE_DIRS)
  endif()
endif()

# Standard package handling
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(NumPy DEFAULT_MSG NUMPY_INCLUDE_DIRS)
