-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Containers                                                      --
--                                                                           --
-- Description                                                               --
--   This is a binding to package Ada.Containers                             --
--                                                                           --
-- Language                                                                  --
--   Specification : SPARK                                                   --
--   Private Part  : N/A                                                     --
--   Body          : N/A                                                     --
--                                                                           --
-- Runtime Requirements and Dependencies                                     --
--   No Ada Runtime                                                          --
--                                                                           --
-- Verification                                                              --
--   N/A                                                                     --
--                                                                           --
-- Exceptions                                                                --
--   None                                                                    --
--                                                                           --
-------------------------------------------------------------------------------

package SPARK.Ada.Containers is

   -- These declarations comply with the minimum range required by
   -- the Ada2005 LRM, and also agree with the ranges used by GNAT Pro.

   type Hash_Type is mod 2 ** 32;

   type Count_Type is range 0 .. 2 ** 31 - 1;

   -- GNAT's Capacity_Error exception is not supported in SPARK.

end SPARK.Ada.Containers;
