-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--  IndexManager
--
--  Purpose:
--
--  The goal of this package is to manage the link between a package
--  name or a procedure/function name and the filename that contains
--  the subunit.
--
--------------------------------------------------------------------------------

with ContextManager;
with ExaminerConstants;
with E_Strings;
with LexTokenLists;
with LexTokenManager;
with SPARK_IO;

use type SPARK_IO.File_Status;
use type LexTokenLists.Lists;
use type LexTokenManager.Str_Comp_Result;

--# inherit Ada.Characters.Latin_1,
--#         CommandLineData,
--#         ContextManager,
--#         ErrorHandler,
--#         ExaminerConstants,
--#         E_Strings,
--#         FileSystem,
--#         LexTokenLists,
--#         LexTokenManager,
--#         ScreenEcho,
--#         SPARK_IO,
--#         SystemErrors,
--#         XMLReport;

package IndexManager
--# own State;
--# initializes State;
is
   subtype Component_Index is Integer range 1 .. ExaminerConstants.MaxIndexComponents;

   type Component_Lists is array (Component_Index) of LexTokenLists.Lists;

   procedure Look_Up
     (Required_Unit       : in     LexTokenLists.Lists;
      Possible_Unit_Types : in     ContextManager.UnitTypeSets;
      Source_Filename     :    out LexTokenManager.Lex_String;
      Actual_Unit_Type    :    out ContextManager.UnitTypes;
      Found               :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives Actual_Unit_Type,
   --#         ErrorHandler.Error_Context,
   --#         Found,
   --#         LexTokenManager.State,
   --#         Source_Filename,
   --#         SPARK_IO.File_Sys,
   --#         State                      from CommandLineData.Content,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Possible_Unit_Types,
   --#                                         Required_Unit,
   --#                                         SPARK_IO.File_Sys,
   --#                                         State;

   procedure Look_Up_Components (Required_Unit : in     LexTokenLists.Lists;
                                 Components    :    out Component_Lists);
   --# global in     CommandLineData.Content;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives Components,
   --#         ErrorHandler.Error_Context,
   --#         LexTokenManager.State,
   --#         SPARK_IO.File_Sys,
   --#         State                      from CommandLineData.Content,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Required_Unit,
   --#                                         SPARK_IO.File_Sys,
   --#                                         State;

   procedure Add_Unit
     (Unit            : in LexTokenLists.Lists;
      Unit_Types      : in ContextManager.UnitTypes;
      Source_Filename : in E_Strings.T);
   --# global in     CommandLineData.Content;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives ErrorHandler.Error_Context,
   --#         State                      from *,
   --#                                         LexTokenManager.State,
   --#                                         Source_Filename,
   --#                                         State,
   --#                                         Unit,
   --#                                         Unit_Types &
   --#         LexTokenManager.State      from *,
   --#                                         Source_Filename &
   --#         SPARK_IO.File_Sys          from *,
   --#                                         CommandLineData.Content,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Source_Filename,
   --#                                         State,
   --#                                         Unit,
   --#                                         Unit_Types;

   procedure List_Index_File (Report_File : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.State;
   --#        in     State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLReport.State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                LexTokenManager.State,
   --#                                Report_File,
   --#                                State,
   --#                                XMLReport.State &
   --#         XMLReport.State   from *,
   --#                                CommandLineData.Content,
   --#                                State;

private

   type Entry_Types is (
                        Super_Index,
                        Aux_Index,
                        Main_P,
                        P_Spec,
                        -- GenOption -- GenericDec, -- See comment in body
                        P_Bodi,
                        Subunit,
                        Component_List,
                        Invalid_Entry_Type);

   type Library_Manager_Errors is (
                                   ES_FileLocation,
                                   ES_IsIn,
                                   ES_UnitEntry,
                                   EW_Index,
                                   EW_UnexpectedSuper,
                                   ES_Comment,
                                   ES_Are,
                                   ES_Components,
                                   EW_IllegalUnitName,
                                   EW_Aux,
                                   EW_Super,
                                   ES_Recursion,
                                   EF_Contradiction,
                                   EW_Duplicate,
                                   EW_DuplicateAux);

   type File_Position is record
      Line : Positive;
      Col  : Positive;
   end record;

end IndexManager;
