/* Public domain. */

#ifndef CDB_H
#define CDB_H

#include "gccattributes.h"
#include "uint32.h"

#define CDB_HASHSTART 5381
extern uint32 cdb_hashadd (uint32, unsigned char) gccattr_const ;
extern uint32 cdb_hash (char const *, unsigned int) gccattr_pure ;

struct cdb
{
  char *map ; /* 0 if no map is available */
  int fd ;
  uint32 size ; /* initialized if map is nonzero */
  uint32 loop ; /* number of hash slots searched under this key */
  uint32 khash ; /* initialized if loop is nonzero */
  uint32 kpos ; /* initialized if loop is nonzero */
  uint32 hpos ; /* initialized if loop is nonzero */
  uint32 hslots ; /* initialized if loop is nonzero */
  uint32 dpos ; /* initialized if cdb_findnext() returns 1 */
  uint32 dlen ; /* initialized if cdb_findnext() returns 1 */
} ;

#define CDB_ZERO { 0, -1, 0, 0, 0, 0, 0, 0, 0, 0 }

extern void cdb_free (struct cdb *) ;
extern int cdb_init (struct cdb *, int fd) ;

extern int cdb_read (struct cdb *, char *, unsigned int, uint32) ;

extern void cdb_findstart (struct cdb *) ;
extern int cdb_findnext (struct cdb *, char const *, unsigned int) ;
extern int cdb_find (struct cdb *, char const *, unsigned int) ;

#define cdb_datapos(c) ((c)->dpos)
#define cdb_datalen(c) ((c)->dlen)
#define cdb_keypos(c) ((c)->kpos)
#define cdb_keylen(c) ((c)->dpos - (c)->kpos)

extern int cdb_firstkey (struct cdb *, uint32 *) ;
extern int cdb_nextkey (struct cdb *, uint32 *) ;
extern int cdb_successor (struct cdb *, char const *, unsigned int) ;

#endif
