/* Public domain. */

#include "tai.h"
#include "iopause.h"
#include "dns_transmit.h"

int dns_resolve_r (char const *q, char const *qtype, struct dns_transmit *dt, struct dns_rcip_info *dr)
{
  int r = 0 ;
  if (!dns_resolvconfipit(dr)) return -1 ;
  if (dns_transmit_start(dt, dr->ip, 1, q, qtype, "\0\0\0") == -1) return -1 ;

  while (!r)
  {
    struct taia deadline, stamp ;
    iopause_fd x[1] ;
    taia_now(&stamp) ;
    taia_addsec(&deadline, &stamp, 120) ;
    dns_transmit_io(dt, x, &deadline) ;
    if (iopause(x, 1, &deadline, &stamp) == -1) goto err ;
    r = dns_transmit_get(dt, x, &stamp) ;
  }
  if (r < 0) goto err ;
  return 0 ;

err:
  dns_transmit_free(dt) ;
  return -1 ;
}
