% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-indicators.R
\name{busyIndicatorOptions}
\alias{busyIndicatorOptions}
\title{Customize busy indicator options}
\usage{
busyIndicatorOptions(
  ...,
  spinner_type = NULL,
  spinner_color = NULL,
  spinner_size = NULL,
  spinner_delay = NULL,
  spinner_selector = NULL,
  fade_opacity = NULL,
  fade_selector = NULL,
  pulse_background = NULL,
  pulse_height = NULL,
  pulse_speed = NULL
)
}
\arguments{
\item{...}{Currently ignored.}

\item{spinner_type}{The type of spinner. Pre-bundled types include:
'ring', 'ring2', 'ring3', 'bars', 'bars2', 'bars3', 'pulse', 'pulse2', 'pulse3', 'dots', 'dots2', 'dots3'.

A path to a local SVG file can also be provided. The SVG should adhere to
the following rules:
\itemize{
\item The SVG itself should contain the animation.
\item It should avoid absolute sizes (the spinner's containing DOM element
size is set in CSS by \code{spinner_size}, so it should fill that container).
\item It should avoid setting absolute colors (the spinner's containing DOM element
color is set in CSS by \code{spinner_color}, so it should inherit that color).
}}

\item{spinner_color}{The color of the spinner. This can be any valid CSS
color. Defaults to the app's "primary" color if Bootstrap is on the page.}

\item{spinner_size}{The size of the spinner. This can be any valid CSS size.}

\item{spinner_delay}{The amount of time to wait before showing the spinner.
This can be any valid CSS time and can be useful for not showing the spinner
if the computation finishes quickly.}

\item{spinner_selector}{A character string containing a CSS selector for
scoping the spinner customization. The default (\code{NULL}) will apply the
spinner customization to the parent element of the spinner.}

\item{fade_opacity}{The opacity (a number between 0 and 1) for recalculating
output. Set to 1 to "disable" the fade.}

\item{fade_selector}{A character string containing a CSS selector for
scoping the spinner customization. The default (\code{NULL}) will apply the
spinner customization to the parent element of the spinner.}

\item{pulse_background}{A CSS background definition for the pulse. The
default uses a
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/gradient/linear-gradient}{linear-gradient}
of the theme's indigo, purple, and pink colors.}

\item{pulse_height}{The height of the pulsing banner. This can be any valid
CSS size.}

\item{pulse_speed}{The speed of the pulsing banner. This can be any valid CSS
time.}
}
\description{
Shiny automatically includes busy indicators, which more specifically means:
\enumerate{
\item Calculating/recalculating outputs have a spinner overlay.
\item Outputs fade out/in when recalculating.
\item When no outputs are calculating/recalculating, but Shiny is busy
doing something else (e.g., a download, side-effect, etc), a page-level
pulsing banner is shown.
}

This function allows you to customize the appearance of these busy indicators
by including the result of this function inside the app's UI. Note that,
unless \code{spinner_selector} (or \code{fade_selector}) is specified, the spinner/fade
customization applies to the parent element. If the customization should
instead apply to the entire page, set \code{spinner_selector = 'html'} and
\code{fade_selector = 'html'}.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(bslib)

card_ui <- function(id, spinner_type = id) {
  card(
    busyIndicatorOptions(spinner_type = spinner_type),
    card_header(paste("Spinner:", spinner_type)),
    plotOutput(shiny::NS(id, "plot"))
  )
}

card_server <- function(id, simulate = reactive()) {
  moduleServer(
    id = id,
    function(input, output, session) {
      output$plot <- renderPlot({
        Sys.sleep(1)
        simulate()
        plot(x = rnorm(100), y = rnorm(100))
      })
    }
  )
}

ui <- page_fillable(
  useBusyIndicators(),
  input_task_button("simulate", "Simulate", icon = icon("refresh")),
  layout_columns(
    card_ui("ring"),
    card_ui("bars"),
    card_ui("dots"),
    card_ui("pulse"),
    col_widths = 6
  )
)

server <- function(input, output, session) {
  simulate <- reactive(input$simulate)
  card_server("ring", simulate)
  card_server("bars", simulate)
  card_server("dots", simulate)
  card_server("pulse", simulate)
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=useBusyIndicators]{useBusyIndicators()}} to disable/enable busy indicators.
}
