% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/colour-mapping.r
\name{col_numeric}
\alias{col_bin}
\alias{col_factor}
\alias{col_numeric}
\alias{col_quantile}
\title{Color mapping}
\usage{
col_numeric(palette, domain, na.color = "#808080")

col_bin(palette, domain, bins = 7, pretty = TRUE, na.color = "#808080")

col_quantile(palette, domain, n = 4, probs = seq(0, 1, length.out = n + 1),
  na.color = "#808080")

col_factor(palette, domain, levels = NULL, ordered = FALSE,
  na.color = "#808080")
}
\arguments{
\item{palette}{The colors or color function that values will be mapped to}

\item{domain}{The possible values that can be mapped.

  For \code{col_numeric} and \code{col_bin}, this can be a simple numeric
  range (e.g. \code{c(0, 100)}); \code{col_quantile} needs representative
  numeric data; and \code{col_factor} needs categorical data.

  If \code{NULL}, then whenever the resulting color function is called, the
  \code{x} value will represent the domain. This implies that if the function
  is invoked multiple times, the encoding between values and colors may not
  be consistent; if consistency is needed, you must provide a non-\code{NULL}
  domain.}

\item{na.color}{The color to return for \code{NA} values. Note that
  \code{na.color=NA} is valid.}

\item{bins}{Either a numeric vector of two or more unique cut points or a
single number (greater than or equal to 2) giving the number of intervals
into which the domain values are to be cut.}

\item{pretty}{Whether to use the function \code{\link{pretty}()} to generate
the bins when the argument \code{bins} is a single number. When
\code{pretty = TRUE}, the actual number of bins may not be the number of
bins you specified. When \code{pretty = FALSE}, \code{\link{seq}()} is used
to generate the bins and the breaks may not be "pretty".}

\item{n}{Number of equal-size quantiles desired. For more precise control,
use the \code{probs} argument instead.}

\item{probs}{See \code{\link[stats]{quantile}}. If provided, the \code{n}
argument is ignored.}

\item{levels}{An alternate way of specifying levels; if specified, domain is
ignored}

\item{ordered}{If \code{TRUE} and \code{domain} needs to be coerced to a
factor, treat it as already in the correct order}
}
\value{
A function that takes a single parameter \code{x}; when called with a
  vector of numbers (except for \code{col_factor}, which expects
  factors/characters), #RRGGBB color strings are returned.
}
\description{
Conveniently maps data values (numeric or factor/character) to colors
according to a given palette, which can be provided in a variety of formats.
}
\details{
\code{col_numeric} is a simple linear mapping from continuous numeric data
to an interpolated palette.

\code{col_bin} also maps continuous numeric data, but performs
  binning based on value (see the \code{\link[base]{cut}} function).

\code{col_quantile} similarly bins numeric data, but via the
  \code{\link[stats]{quantile}} function.

\code{col_factor} maps factors to colors. If the palette is
  discrete and has a different number of colors than the number of factors,
  interpolation is used.

The \code{palette} argument can be any of the following:
\enumerate{
  \item{A character vector of RGB or named colors. Examples: \code{palette()}, \code{c("#000000", "#0000FF", "#FFFFFF")}, \code{topo.colors(10)}}
  \item{The name of an RColorBrewer palette, e.g. \code{"BuPu"} or \code{"Greens"}.}
  \item{A function that receives a single value between 0 and 1 and returns a color. Examples: \code{colorRamp(c("#000000", "#FFFFFF"), interpolate="spline")}.}
}
}
\examples{
pal <- col_bin("Greens", domain = 0:100)
show_col(pal(sort(runif(10, 60, 100))))

# Exponential distribution, mapped continuously
show_col(col_numeric("Blues", domain = NULL)(sort(rexp(16))))
# Exponential distribution, mapped by interval
show_col(col_bin("Blues", domain = NULL, bins = 4)(sort(rexp(16))))
# Exponential distribution, mapped by quantile
show_col(col_quantile("Blues", domain = NULL)(sort(rexp(16))))

# Categorical data; by default, the values being colored span the gamut...
show_col(col_factor("RdYlBu", domain = NULL)(LETTERS[1:5]))
# ...unless the data is a factor, without droplevels...
show_col(col_factor("RdYlBu", domain = NULL)(factor(LETTERS[1:5], levels=LETTERS)))
# ...or the domain is stated explicitly.
show_col(col_factor("RdYlBu", levels = LETTERS)(LETTERS[1:5]))
}

