/* Generated from "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod" by precompile.pike running Pike v7.8 release 866
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 3

#undef PRECOMPILE_SUB_PIKEVARS
#define PRECOMPILE_SUB_PIKEVARS 1

#undef PRECOMPILE_DYNAMIC_TYPES
#define PRECOMPILE_DYNAMIC_TYPES 1


#line 1 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
*/

#include "global.h"

#include "interpret.h"
#include "svalue.h"
#include "array.h"
#include "pike_macros.h"
#include "program.h"
#include "stralloc.h"
#include "object.h"
#include "pike_types.h"
#include "threads.h"
#include "dynamic_buffer.h"
#include "builtin_functions.h"
#include "config.h"

#if defined(HAVE_FFTW_H) && defined(HAVE_LIBFFTW) && defined(HAVE_RFFTW_H) && defined(HAVE_LIBRFFTW)
#define HAVE_RFFTW
#endif

#ifdef HAVE_RFFTW

#ifdef HAVE_FFTW_H
#include <fftw.h>
#endif

#ifdef HAVE_RFFTW_H
#include <rfftw.h>
#endif



#ifndef PIKE_UNUSED_ATTRIBUTE
#define PIKE_UNUSED_ATTRIBUTE
#endif
#define CMOD_MAP_PROGRAM_IDS_DEFINED 1
static int ___cmod_map_program_ids(int id) PIKE_UNUSED_ATTRIBUTE;
#ifndef TYPEOF
/* Compat with older Pikes. */
#define TYPEOF(SVAL)	((SVAL).type)
#define SUBTYPEOF(SVAL)	((SVAL).subtype)
#define SET_SVAL_TYPE(SVAL, TYPE)	(TYPEOF(SVAL) = TYPE)
#define SET_SVAL_SUBTYPE(SVAL, TYPE)	(SUBTYPEOF(SVAL) = TYPE)
#define SET_SVAL(SVAL, TYPE, SUBTYPE, FIELD, EXPR) do {	\
    /* Set the type afterwards to avoid a clobbered	\
     * svalue in case EXPR throws. */			\
    (SVAL).u.FIELD = (EXPR);				\
    SET_SVAL_TYPE((SVAL), (TYPE));			\
    SET_SVAL_SUBTYPE((SVAL), (SUBTYPE));		\
  } while(0)
#endif /* !TYPEOF */
#ifndef PIKE_UNUSED
/* Compat with Pike 7.8 and earlier. */
/* NB: Not strictly correct; PIKE_UNUSED was added the
 *     day after set_program_id_to_id(), but good enough.
 */
#ifndef UNUSED
#define UNUSED(X)	X
#endif
#ifndef set_program_id_to_id
/* NB: Recent Pike 7.8 has a #define that conflicts with
 *     the following declaration.
 */
static void set_program_id_to_id(void*UNUSED(id)){}
#endif
#else /* */
PMOD_EXPORT void set_program_id_to_id( int (*to)(int) );
#endif /* !PIKE_UNUSED */


#ifndef DEFAULT_CMOD_STORAGE
#define CMOD_COND_USED
#define DEFAULT_CMOD_STORAGE static
#endif
#ifndef CMOD_COND_USED
# define f_Math_FFT_create_fun_num_used 1
#else
#undef f_Math_FFT_create_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Math_FFT_program_fun_num_used 1
#else
#undef Math_FFT_program_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Math_FFT_rIFFT_fun_num_used 1
#else
#undef f_Math_FFT_rIFFT_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Math_FFT_rFFT_fun_num_used 1
#else
#undef f_Math_FFT_rFFT_fun_num_used
#endif
/*! @module Math
 */

/*! @module Transforms
 */

/*! @class FFT
 */


#undef class_Math_FFT_defined
#define class_Math_FFT_defined
DEFAULT_CMOD_STORAGE struct program *Math_FFT_program=NULL;

#ifdef Math_FFT_program_fun_num_used
DEFAULT_CMOD_STORAGE int Math_FFT_program_fun_num=-1;
#endif /* Math_FFT_program_fun_num_used */

#undef var_r_in_Math_FFT_defined
#define var_r_in_Math_FFT_defined

#undef var_r_out_Math_FFT_defined
#define var_r_out_Math_FFT_defined

#undef var_r_cr_plan_Math_FFT_defined
#define var_r_cr_plan_Math_FFT_defined

#undef var_r_rc_plan_Math_FFT_defined
#define var_r_rc_plan_Math_FFT_defined

#undef var_r_cr_plan_size_Math_FFT_defined
#define var_r_cr_plan_size_Math_FFT_defined

#undef var_r_rc_plan_size_Math_FFT_defined
#define var_r_rc_plan_size_Math_FFT_defined

#undef THIS
#define THIS ((struct Math_FFT_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MATH_FFT
#define THIS_MATH_FFT ((struct Math_FFT_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MATH_FFT
#define OBJ2_MATH_FFT(o) ((struct Math_FFT_struct *)(o->storage+Math_FFT_storage_offset))

#undef GET_MATH_FFT_STORAGE
#define GET_MATH_FFT_STORAGE(o) ((struct Math_FFT_struct *)(o->storage+Math_FFT_storage_offset)
static ptrdiff_t Math_FFT_storage_offset;
struct Math_FFT_struct {

#ifdef var_r_in_Math_FFT_defined
#line 49 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
fftw_real *r_in;
#endif /* var_r_in_Math_FFT_defined */

#ifdef var_r_out_Math_FFT_defined
#line 50 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
fftw_real *r_out;
#endif /* var_r_out_Math_FFT_defined */

#ifdef var_r_cr_plan_Math_FFT_defined
#line 51 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
rfftw_plan r_cr_plan;
#endif /* var_r_cr_plan_Math_FFT_defined */

#ifdef var_r_rc_plan_Math_FFT_defined
#line 52 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
rfftw_plan r_rc_plan;
#endif /* var_r_rc_plan_Math_FFT_defined */

#ifdef var_r_cr_plan_size_Math_FFT_defined
#line 53 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
int r_cr_plan_size;
#endif /* var_r_cr_plan_size_Math_FFT_defined */

#ifdef var_r_rc_plan_size_Math_FFT_defined
#line 54 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
int r_rc_plan_size;
#endif /* var_r_rc_plan_size_Math_FFT_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Math_FFT_struct *Math_FFT_gdb_dummy_ptr;
#endif
/*! @decl array(array(float)) rFFT(array(int|float) real_input)
   *!
   *!   Returns the FFT of the input array.
   *!   The input must be real and the output is complex.
   *!   The output consists of an array. It's first element is the amplitudes and the
   *!   second element is the phases.
   *!
   *! @param real_input
   *!   The array of floats and/or ints to transform.
   *!
   *! @note
   *!   rIFFT(rFFT()) returns the input array scaled by n=sizeof(input array).
   *!   This is due to the nature of the DFT algorithm.
   *!
   *! @seealso
   *!   @[rIFFT()]
   */
  #define f_Math_FFT_rFFT_defined

#ifdef f_Math_FFT_rFFT_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Math_FFT_rFFT_fun_num = 0;

#endif /* f_Math_FFT_rFFT_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Math_FFT_rFFT(INT32 args) {
#line 73 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
struct array * myarray;
#line 73 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if(args != 1) wrong_number_of_args_error("rFFT",args,1);
#line 73 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("rFFT",1,"array");
#line 73 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
debug_malloc_pass(myarray=Pike_sp[0-1].u.array);
{
      int i, j;

      if (args<1)
	SIMPLE_TOO_FEW_ARGS_ERROR("rFFT", 1);

      if (TYPEOF(Pike_sp[-args]) == PIKE_T_ARRAY)
	{
	  struct array *a = Pike_sp[-args].u.array;
	  int n = a->size;
	  THIS->r_in = malloc(sizeof(fftw_real)*n);

	  for(i=0; i<n; i++)
	    {
	      if (TYPEOF(a->item[i]) == PIKE_T_INT)
		THIS->r_in[i] = (fftw_real)a->item[i].u.integer;

	      if (TYPEOF(a->item[i]) == PIKE_T_FLOAT)
		THIS->r_in[i] = (fftw_real)a->item[i].u.float_number;
	    };

	  THIS->r_out = malloc(sizeof(fftw_real)*n);

	  if (THIS->r_rc_plan_size != n)
	    {
	      if (THIS->r_rc_plan_size > 0)
		rfftw_destroy_plan(THIS->r_rc_plan);
	      THIS->r_rc_plan =
		rfftw_create_plan(n, FFTW_REAL_TO_COMPLEX, FFTW_ESTIMATE);
	      THIS->r_rc_plan_size = n;
	    };
	  rfftw_one(THIS->r_rc_plan, THIS->r_in, THIS->r_out);

	  pop_n_elems(args);

	  i = (n+1)/2;
	  for(j=0; j<i; j++)
	    push_float((float)THIS->r_out[j]);

	  if (n%2==0) i++;

	  for(j=1; j<i; j++)
	    push_float((float)THIS->r_out[j]);

	  f_aggregate(n);


	  i = (n+1)/2;

	  push_float((float)0);
	  for(j=1; j<i; j++)
	    push_float((float)THIS->r_out[n-j]);

	  if (n%2==0)
	    push_float((float)0);

	  for(j=1; j<i; j++)
	    push_float((float) -(THIS->r_out[n-j]));

	  f_aggregate(n);
	  f_aggregate(2);

	  free(THIS->r_out);
	  THIS->r_out = NULL;
	  free(THIS->r_in);
	  THIS->r_in = NULL;
	}
      else
	pop_n_elems(args);
    }

  }
/*! @decl array(float) rIFFT(array(array(float)) input)
   *!
   *!   Returns the inverse FFT of the input array.
   *!   The input must be complex and guaranteed to generate a real output.
   *!
   *!   The input is an array. It's first element is the amplitudes and the
   *!   second element is the phases.
   *!
   *!   The output is an array of the real values for the iFFT.
   *! @param real_input
   *!   The array of floats and/or ints to transform.
   *!
   *! @note
   *!   rIFFT(rFFT()) returns the input array scaled by n=sizeof(input array).
   *!   This is due to the nature of the DFT algorithm.
   *!
   *! @seealso
   *!   @[rFFT()]
   */
  #define f_Math_FFT_rIFFT_defined

#ifdef f_Math_FFT_rIFFT_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Math_FFT_rIFFT_fun_num = 0;

#endif /* f_Math_FFT_rIFFT_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Math_FFT_rIFFT(INT32 args) {
#line 164 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
struct array * myarray;
#line 164 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if(args != 1) wrong_number_of_args_error("rIFFT",args,1);
#line 164 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("rIFFT",1,"array");
#line 164 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
debug_malloc_pass(myarray=Pike_sp[0-1].u.array);
{
      int i, j=1;
      struct array *r;
      struct array *p;
      int n;

      if (TYPEOF(myarray->item[0]) != PIKE_T_ARRAY ||
	  TYPEOF(myarray->item[1]) != PIKE_T_ARRAY ||
	  myarray->item[0].u.array->size != myarray->item[1].u.array->size)
	Pike_error("Argument error!\n");

      r = myarray->item[0].u.array;
      p = myarray->item[1].u.array;
      n = r->size;

      free(THIS->r_in);
      THIS->r_in = NULL; /* Needs to be NULL if xcalloc throws */
      THIS->r_in = xcalloc(sizeof(fftw_real), n);

      for(i=0; i<=n/2; i++)
	{
	  if (TYPEOF(r->item[i]) == PIKE_T_INT)
	    THIS->r_in[i] = (fftw_real)r->item[i].u.integer;
	  else if (TYPEOF(r->item[i]) == PIKE_T_FLOAT)
	    THIS->r_in[i] = (fftw_real)r->item[i].u.float_number;
	  else Pike_error("Invalid type in array!\n");
	}

      for(;i<n;i++, j++)
	{
	  if (TYPEOF(p->item[j]) == PIKE_T_INT)
	    THIS->r_in[n-j] = (fftw_real)p->item[j].u.integer;
	  else if (TYPEOF(p->item[j]) == PIKE_T_FLOAT)
	    THIS->r_in[n-j] = (fftw_real)p->item[j].u.float_number;
	  else Pike_error("Invalid type in array!\n");
	}

      free(THIS->r_out);
      THIS->r_out = NULL; /* Needs to be NULL if xcalloc throws */
      THIS->r_out = xcalloc(sizeof(fftw_real), n);

      if (THIS->r_cr_plan_size!=n)
	{
	  if (THIS->r_cr_plan_size > 0)
	    rfftw_destroy_plan(THIS->r_cr_plan);
	  THIS->r_cr_plan =
	    rfftw_create_plan(n, FFTW_COMPLEX_TO_REAL, FFTW_ESTIMATE);
	  THIS->r_cr_plan_size = n;
	}

      rfftw_one(THIS->r_cr_plan, THIS->r_in, THIS->r_out);

      pop_n_elems(args);

      for(i=0;i<n;i++)
	push_float((float)THIS->r_out[i]);

      f_aggregate(n);

      free(THIS->r_out);
      THIS->r_out = NULL;
      free(THIS->r_in);
      THIS->r_out = NULL;
    }

  }
/*! @decl void create(void|int n, void|int(0..1) exact)
   *!  Creates a new transform object. If n is specified, a plan
   *!  is created for transformations of n-size arrays.
   *!
   *! @param n
   *!   Size of the transform to be preformed. Note that the transform object
   *!   will be initialized for this size, but if an array of different size is
   *!   sent to the object, it will be reinitialized. This can be used to gain
   *!   preformace if all transforms will be of a given size.
   *!
   *! @param exact
   *!   If exact is 1, a "better" plan for the transform will be created. This
   *!   will take more time though. Use only if preformance is needed.
   */
  #define f_Math_FFT_create_defined

#ifdef f_Math_FFT_create_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Math_FFT_create_fun_num = 0;

#endif /* f_Math_FFT_create_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Math_FFT_create(INT32 args) {
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
struct svalue * no;
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
struct svalue * exact;
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if ((args > 0) &&
    ((TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[0-args]) != NUMBER_UNDEFINED))) {
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",1,"void|int");
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
no=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
} else no = NULL;
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",2,"void|int(0..1)");
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
exact=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
} else exact = NULL;
#line 247 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
{
    int t = FFTW_ESTIMATE;
    int n = 0;
    switch(args)
      {
      case 2:
	if (Pike_sp[1-args].u.integer!=0)
	  t=FFTW_MEASURE;
      case 1:
	n = Pike_sp[-args].u.integer;
	break;
      case 0:
	break;
      default:
	Pike_error("Invalid number of arguments\n");
      }

    THIS->r_rc_plan_size = n;
    THIS->r_cr_plan_size = n;
    if (n>0)
      {
	THIS->r_rc_plan = rfftw_create_plan(n, FFTW_REAL_TO_COMPLEX, t);
	THIS->r_cr_plan = rfftw_create_plan(n, FFTW_COMPLEX_TO_REAL, t);
      }
    pop_n_elems(args);
  }

  }

#undef internal_init_Math_FFT_defined
#define internal_init_Math_FFT_defined

#undef Math_FFT_event_handler_defined
#define Math_FFT_event_handler_defined
static void init_Math_FFT_struct(void)
#line 275 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
{
      THIS->r_in=NULL;
      THIS->r_out=NULL;
    }

  
#undef internal_exit_Math_FFT_defined
#define internal_exit_Math_FFT_defined

#undef Math_FFT_event_handler_defined
#define Math_FFT_event_handler_defined
static void exit_Math_FFT_struct(void)
#line 282 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
{
      if (THIS->r_cr_plan_size>0)
	rfftw_destroy_plan(THIS->r_cr_plan);
      if (THIS->r_rc_plan_size>0)
	rfftw_destroy_plan(THIS->r_rc_plan);
      free(THIS->r_out);
      free(THIS->r_in);
    }

#ifdef Math_FFT_event_handler_defined
static void Math_FFT_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Math_FFT_defined
  case PROG_EVENT_INIT: init_Math_FFT_struct(); break;

#endif /* internal_init_Math_FFT_defined */

#ifdef internal_exit_Math_FFT_defined
  case PROG_EVENT_EXIT: exit_Math_FFT_struct(); break;

#endif /* internal_exit_Math_FFT_defined */
  default: break; 
  }
}

#endif /* Math_FFT_event_handler_defined */
/*! @endclass
 */

/*! @endmodule
 */

/*! @endmodule
 */

#line 301 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
#endif /* HAVE_RFFTW */

void init_math_transforms(void)
{
#ifdef HAVE_RFFTW
  
#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( ___cmod_map_program_ids );

#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */

#ifdef class_Math_FFT_defined

#ifdef PROG_MATH_FFT_ID
#line 47 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
  START_NEW_PROGRAM_ID(MATH_FFT);
#else
#line 47 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
  start_new_program();

#endif /* PROG_MATH_FFT_ID */
#line 47 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
  Math_FFT_program = Pike_compiler->new_program;

#ifndef tObjImpl_MATH_FFT

#undef tObjIs_MATH_FFT
#define tObjIs_MATH_FFT "\3\1\177\0\0\2"

#undef tObjImpl_MATH_FFT
#define tObjImpl_MATH_FFT "\3\0\177\0\0\2"

#endif /* tObjImpl_MATH_FFT */

#ifdef THIS_MATH_FFT
  Math_FFT_storage_offset = ADD_STORAGE(struct Math_FFT_struct);
#endif /* THIS_MATH_FFT */

#ifdef Math_FFT_event_handler_defined
  pike_set_prog_event_callback(Math_FFT_event_handler);

#ifndef Math_FFT_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Math_FFT_gc_live_obj */

#endif /* Math_FFT_event_handler_defined */

#ifdef f_Math_FFT_rFFT_defined

#ifdef f_Math_FFT_rFFT_fun_num_used
  f_Math_FFT_rFFT_fun_num =
#endif /* f_Math_FFT_rFFT_fun_num_used */
#line 73 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
    ADD_FUNCTION2("rFFT", f_Math_FFT_rFFT, tFunc(tArray,tArray), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Math_FFT_rFFT_defined */

#ifdef f_Math_FFT_rIFFT_defined

#ifdef f_Math_FFT_rIFFT_fun_num_used
  f_Math_FFT_rIFFT_fun_num =
#endif /* f_Math_FFT_rIFFT_fun_num_used */
#line 164 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
    ADD_FUNCTION2("rIFFT", f_Math_FFT_rIFFT, tFunc(tArray,tArray), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Math_FFT_rIFFT_defined */

#ifdef f_Math_FFT_create_defined

#ifdef f_Math_FFT_create_fun_num_used
  f_Math_FFT_create_fun_num =
#endif /* f_Math_FFT_create_fun_num_used */
#line 244 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
    ADD_FUNCTION2("create", f_Math_FFT_create, tFunc(tOr(tVoid,"\10\200\0\0\0\177\377\377\377") tOr(tVoid,"\10\0\0\0\0\0\0\0\1"),tVoid), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Math_FFT_create_defined */
#line 47 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
  Math_FFT_program=end_program();
#line 47 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
#ifdef Math_FFT_program_fun_num_used
Math_FFT_program_fun_num=
#endif
 add_program_constant("FFT",Math_FFT_program,0);

#endif /* class_Math_FFT_defined */

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( 0 );
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
#line 307 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
#endif /* HAVE_RFFTW */
}

void exit_math_transforms(void)
{
#ifdef HAVE_RFFTW
  
#ifdef class_Math_FFT_defined
  if(Math_FFT_program) {
#line 47 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
    free_program(Math_FFT_program);
    Math_FFT_program=0;
  }

#endif /* class_Math_FFT_defined */
#line 314 "/home/zino/hack/pike8-rel/pike/src/modules/Math/transforms.cmod"
#endif /* HAVE_RFFTW */
}


#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
static int ___cmod_map_program_ids(int id)
{
  int i = 0;
  if( (id&0x7f000000) != 0x7f000000 ) return id;
  id = id&0x00ffffff;
#ifdef class_Math_FFT_defined
if(id==2) return Math_FFT_program->id;
#endif
  return 0;
}
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
