/* Copyright (c) 2012, The Linux Foundation. All rights reserved.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 and
* only version 2 as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*/

#include <linux/mfd/wcd9xxx/wcd9320_registers.h>
#include "wcd9320.h"

const u8 taiko_reg_readable[TAIKO_CACHE_SIZE] = {
	[TAIKO_A_CHIP_CTL] = 1,
	[TAIKO_A_CHIP_STATUS] = 1,
	[TAIKO_A_CHIP_ID_BYTE_0] = 1,
	[TAIKO_A_CHIP_ID_BYTE_1] = 1,
	[TAIKO_A_CHIP_ID_BYTE_2] = 1,
	[TAIKO_A_CHIP_ID_BYTE_3] = 1,
	[TAIKO_A_CHIP_VERSION] = 1,
	[TAIKO_A_SLAVE_ID_1] = 1,
	[TAIKO_A_SLAVE_ID_2] = 1,
	[TAIKO_A_SLAVE_ID_3] = 1,
	[TAIKO_A_PIN_CTL_OE0] = 1,
	[TAIKO_A_PIN_CTL_OE1] = 1,
	[TAIKO_A_PIN_CTL_DATA0] = 1,
	[TAIKO_A_PIN_CTL_DATA1] = 1,
	[TAIKO_A_HDRIVE_GENERIC] = 1,
	[TAIKO_A_HDRIVE_OVERRIDE] = 1,
	[TAIKO_A_ANA_CSR_WAIT_STATE] = 1,
	[TAIKO_A_PROCESS_MONITOR_CTL0] = 1,
	[TAIKO_A_PROCESS_MONITOR_CTL1] = 1,
	[TAIKO_A_PROCESS_MONITOR_CTL2] = 1,
	[TAIKO_A_PROCESS_MONITOR_CTL3] = 1,
	[TAIKO_A_QFUSE_CTL] = 1,
	[TAIKO_A_QFUSE_STATUS] = 1,
	[TAIKO_A_QFUSE_DATA_OUT0] = 1,
	[TAIKO_A_QFUSE_DATA_OUT1] = 1,
	[TAIKO_A_QFUSE_DATA_OUT2] = 1,
	[TAIKO_A_QFUSE_DATA_OUT3] = 1,
	[TAIKO_A_QFUSE_DATA_OUT4] = 1,
	[TAIKO_A_QFUSE_DATA_OUT5] = 1,
	[TAIKO_A_QFUSE_DATA_OUT6] = 1,
	[TAIKO_A_QFUSE_DATA_OUT7] = 1,
	[TAIKO_A_CDC_CTL] = 1,
	[TAIKO_A_LEAKAGE_CTL] = 1,
	[TAIKO_A_INTR_MODE] = 1,
	[TAIKO_A_INTR_MASK0] = 1,
	[TAIKO_A_INTR_MASK1] = 1,
	[TAIKO_A_INTR_MASK2] = 1,
	[TAIKO_A_INTR_MASK3] = 1,
	[TAIKO_A_INTR_STATUS0] = 1,
	[TAIKO_A_INTR_STATUS1] = 1,
	[TAIKO_A_INTR_STATUS2] = 1,
	[TAIKO_A_INTR_STATUS3] = 1,
	[TAIKO_A_INTR_CLEAR0] = 0,
	[TAIKO_A_INTR_CLEAR1] = 0,
	[TAIKO_A_INTR_CLEAR2] = 0,
	[TAIKO_A_INTR_CLEAR3] = 0,
	[TAIKO_A_INTR_LEVEL0] = 1,
	[TAIKO_A_INTR_LEVEL1] = 1,
	[TAIKO_A_INTR_LEVEL2] = 1,
	[TAIKO_A_INTR_LEVEL3] = 1,
	[TAIKO_A_INTR_TEST0] = 1,
	[TAIKO_A_INTR_TEST1] = 1,
	[TAIKO_A_INTR_TEST2] = 1,
	[TAIKO_A_INTR_TEST3] = 1,
	[TAIKO_A_INTR_SET0] = 1,
	[TAIKO_A_INTR_SET1] = 1,
	[TAIKO_A_INTR_SET2] = 1,
	[TAIKO_A_INTR_SET3] = 1,
	[TAIKO_A_INTR_DESTN0] = 1,
	[TAIKO_A_INTR_DESTN1] = 1,
	[TAIKO_A_INTR_DESTN2] = 1,
	[TAIKO_A_INTR_DESTN3] = 1,
	[TAIKO_A_CDC_TX_I2S_SCK_MODE] = 1,
	[TAIKO_A_CDC_TX_I2S_WS_MODE] = 1,
	[TAIKO_A_CDC_DMIC_DATA0_MODE] = 1,
	[TAIKO_A_CDC_DMIC_CLK0_MODE] = 1,
	[TAIKO_A_CDC_DMIC_DATA1_MODE] = 1,
	[TAIKO_A_CDC_DMIC_CLK1_MODE] = 1,
	[TAIKO_A_CDC_RX_I2S_SCK_MODE] = 1,
	[TAIKO_A_CDC_RX_I2S_WS_MODE] = 1,
	[TAIKO_A_CDC_DMIC_DATA2_MODE] = 1,
	[TAIKO_A_CDC_DMIC_CLK2_MODE] = 1,
	[TAIKO_A_CDC_INTR1_MODE] = 1,
	[TAIKO_A_CDC_SB_NRZ_SEL_MODE] = 1,
	[TAIKO_A_CDC_INTR2_MODE] = 1,
	[TAIKO_A_CDC_RF_PA_ON_MODE] = 1,
	[TAIKO_A_BIAS_REF_CTL] = 1,
	[TAIKO_A_BIAS_CENTRAL_BG_CTL] = 1,
	[TAIKO_A_BIAS_PRECHRG_CTL] = 1,
	[TAIKO_A_BIAS_CURR_CTL_1] = 1,
	[TAIKO_A_BIAS_CURR_CTL_2] = 1,
	[TAIKO_A_BIAS_OSC_BG_CTL] = 1,
	[TAIKO_A_CLK_BUFF_EN1] = 1,
	[TAIKO_A_CLK_BUFF_EN2] = 1,
	[TAIKO_A_LDO_H_MODE_1] = 1,
	[TAIKO_A_LDO_H_MODE_2] = 1,
	[TAIKO_A_LDO_H_LOOP_CTL] = 1,
	[TAIKO_A_LDO_H_COMP_1] = 1,
	[TAIKO_A_LDO_H_COMP_2] = 1,
	[TAIKO_A_LDO_H_BIAS_1] = 1,
	[TAIKO_A_LDO_H_BIAS_2] = 1,
	[TAIKO_A_LDO_H_BIAS_3] = 1,
	[TAIKO_A_VBAT_CLK] = 1,
	[TAIKO_A_VBAT_LOOP] = 1,
	[TAIKO_A_VBAT_REF] = 1,
	[TAIKO_A_VBAT_ADC_TEST] = 1,
	[TAIKO_A_VBAT_FE] = 1,
	[TAIKO_A_VBAT_BIAS_1] = 1,
	[TAIKO_A_VBAT_BIAS_2] = 1,
	[TAIKO_A_VBAT_ADC_DATA_MSB] = 1,
	[TAIKO_A_VBAT_ADC_DATA_LSB] = 1,
	[TAIKO_A_MICB_CFILT_1_CTL] = 1,
	[TAIKO_A_MICB_CFILT_1_VAL] = 1,
	[TAIKO_A_MICB_CFILT_1_PRECHRG] = 1,
	[TAIKO_A_MICB_1_CTL] = 1,
	[TAIKO_A_MICB_1_INT_RBIAS] = 1,
	[TAIKO_A_MICB_1_MBHC] = 1,
	[TAIKO_A_MICB_CFILT_2_CTL] = 1,
	[TAIKO_A_MICB_CFILT_2_VAL] = 1,
	[TAIKO_A_MICB_CFILT_2_PRECHRG] = 1,
	[TAIKO_A_MICB_2_CTL] = 1,
	[TAIKO_A_MICB_2_INT_RBIAS] = 1,
	[TAIKO_A_MICB_2_MBHC] = 1,
	[TAIKO_A_MICB_CFILT_3_CTL] = 1,
	[TAIKO_A_MICB_CFILT_3_VAL] = 1,
	[TAIKO_A_MICB_CFILT_3_PRECHRG] = 1,
	[TAIKO_A_MICB_3_CTL] = 1,
	[TAIKO_A_MICB_3_INT_RBIAS] = 1,
	[TAIKO_A_MICB_3_MBHC] = 1,
	[TAIKO_A_MICB_4_CTL] = 1,
	[TAIKO_A_MICB_4_INT_RBIAS] = 1,
	[TAIKO_A_MICB_4_MBHC] = 1,
	[TAIKO_A_MBHC_INSERT_DETECT] = 1,
	[TAIKO_A_MBHC_INSERT_DET_STATUS] = 1,
	[TAIKO_A_TX_COM_BIAS] = 1,
	[TAIKO_A_MBHC_SCALING_MUX_1] = 1,
	[TAIKO_A_MBHC_SCALING_MUX_2] = 1,
	[TAIKO_A_MAD_ANA_CTRL] = 1,
	[TAIKO_A_TX_SUP_SWITCH_CTRL_1] = 1,
	[TAIKO_A_TX_SUP_SWITCH_CTRL_2] = 1,
	[TAIKO_A_TX_1_2_EN] = 1,
	[TAIKO_A_TX_1_2_TEST_EN] = 1,
	[TAIKO_A_TX_1_2_ADC_CH1] = 1,
	[TAIKO_A_TX_1_2_ADC_CH2] = 1,
	[TAIKO_A_TX_1_2_ATEST_REFCTRL] = 1,
	[TAIKO_A_TX_1_2_TEST_CTL] = 1,
	[TAIKO_A_TX_1_2_TEST_BLOCK_EN] = 1,
	[TAIKO_A_TX_1_2_TXFE_CLKDIV] = 1,
	[TAIKO_A_TX_1_2_SAR_ERR_CH1] = 1,
	[TAIKO_A_TX_1_2_SAR_ERR_CH2] = 1,
	[TAIKO_A_TX_3_4_EN] = 1,
	[TAIKO_A_TX_3_4_TEST_EN] = 1,
	[TAIKO_A_TX_3_4_ADC_CH3] = 1,
	[TAIKO_A_TX_3_4_ADC_CH4] = 1,
	[TAIKO_A_TX_3_4_ATEST_REFCTRL] = 1,
	[TAIKO_A_TX_3_4_TEST_CTL] = 1,
	[TAIKO_A_TX_3_4_TEST_BLOCK_EN] = 1,
	[TAIKO_A_TX_3_4_TXFE_CKDIV] = 1,
	[TAIKO_A_TX_3_4_SAR_ERR_CH3] = 1,
	[TAIKO_A_TX_3_4_SAR_ERR_CH4] = 1,
	[TAIKO_A_TX_5_6_EN] = 1,
	[TAIKO_A_TX_5_6_TEST_EN] = 1,
	[TAIKO_A_TX_5_6_ADC_CH5] = 1,
	[TAIKO_A_TX_5_6_ADC_CH6] = 1,
	[TAIKO_A_TX_5_6_ATEST_REFCTRL] = 1,
	[TAIKO_A_TX_5_6_TEST_CTL] = 1,
	[TAIKO_A_TX_5_6_TEST_BLOCK_EN] = 1,
	[TAIKO_A_TX_5_6_TXFE_CKDIV] = 1,
	[TAIKO_A_TX_5_6_SAR_ERR_CH5] = 1,
	[TAIKO_A_TX_5_6_SAR_ERR_CH6] = 1,
	[TAIKO_A_TX_7_MBHC_EN] = 1,
	[TAIKO_A_TX_7_MBHC_ATEST_REFCTRL] = 1,
	[TAIKO_A_TX_7_MBHC_ADC] = 1,
	[TAIKO_A_TX_7_MBHC_TEST_CTL] = 1,
	[TAIKO_A_TX_7_MBHC_SAR_ERR] = 1,
	[TAIKO_A_TX_7_TXFE_CLKDIV] = 1,
	[TAIKO_A_BUCK_MODE_1] = 1,
	[TAIKO_A_BUCK_MODE_2] = 1,
	[TAIKO_A_BUCK_MODE_3] = 1,
	[TAIKO_A_BUCK_MODE_4] = 1,
	[TAIKO_A_BUCK_MODE_5] = 1,
	[TAIKO_A_BUCK_CTRL_VCL_1] = 1,
	[TAIKO_A_BUCK_CTRL_VCL_2] = 1,
	[TAIKO_A_BUCK_CTRL_VCL_3] = 1,
	[TAIKO_A_BUCK_CTRL_CCL_1] = 1,
	[TAIKO_A_BUCK_CTRL_CCL_2] = 1,
	[TAIKO_A_BUCK_CTRL_CCL_3] = 1,
	[TAIKO_A_BUCK_CTRL_CCL_4] = 1,
	[TAIKO_A_BUCK_CTRL_PWM_DRVR_1] = 1,
	[TAIKO_A_BUCK_CTRL_PWM_DRVR_2] = 1,
	[TAIKO_A_BUCK_CTRL_PWM_DRVR_3] = 1,
	[TAIKO_A_BUCK_TMUX_A_D] = 1,
	[TAIKO_A_NCP_BUCKREF] = 1,
	[TAIKO_A_NCP_EN] = 1,
	[TAIKO_A_NCP_CLK] = 1,
	[TAIKO_A_NCP_STATIC] = 1,
	[TAIKO_A_NCP_VTH_LOW] = 1,
	[TAIKO_A_NCP_VTH_HIGH] = 1,
	[TAIKO_A_NCP_ATEST] = 1,
	[TAIKO_A_NCP_DTEST] = 1,
	[TAIKO_A_NCP_DLY1] = 1,
	[TAIKO_A_NCP_DLY2] = 1,
	[TAIKO_A_RX_AUX_SW_CTL] = 1,
	[TAIKO_A_RX_PA_AUX_IN_CONN] = 1,
	[TAIKO_A_RX_COM_TIMER_DIV] = 1,
	[TAIKO_A_RX_COM_OCP_CTL] = 1,
	[TAIKO_A_RX_COM_OCP_COUNT] = 1,
	[TAIKO_A_RX_COM_DAC_CTL] = 1,
	[TAIKO_A_RX_COM_BIAS] = 1,
	[TAIKO_A_RX_HPH_AUTO_CHOP] = 1,
	[TAIKO_A_RX_HPH_CHOP_CTL] = 1,
	[TAIKO_A_RX_HPH_BIAS_PA] = 1,
	[TAIKO_A_RX_HPH_BIAS_LDO] = 1,
	[TAIKO_A_RX_HPH_BIAS_CNP] = 1,
	[TAIKO_A_RX_HPH_BIAS_WG_OCP] = 1,
	[TAIKO_A_RX_HPH_OCP_CTL] = 1,
	[TAIKO_A_RX_HPH_CNP_EN] = 1,
	[TAIKO_A_RX_HPH_CNP_WG_CTL] = 1,
	[TAIKO_A_RX_HPH_CNP_WG_TIME] = 1,
	[TAIKO_A_RX_HPH_L_GAIN] = 1,
	[TAIKO_A_RX_HPH_L_TEST] = 1,
	[TAIKO_A_RX_HPH_L_PA_CTL] = 1,
	[TAIKO_A_RX_HPH_L_DAC_CTL] = 1,
	[TAIKO_A_RX_HPH_L_ATEST] = 1,
	[TAIKO_A_RX_HPH_L_STATUS] = 1,
	[TAIKO_A_RX_HPH_R_GAIN] = 1,
	[TAIKO_A_RX_HPH_R_TEST] = 1,
	[TAIKO_A_RX_HPH_R_PA_CTL] = 1,
	[TAIKO_A_RX_HPH_R_DAC_CTL] = 1,
	[TAIKO_A_RX_HPH_R_ATEST] = 1,
	[TAIKO_A_RX_HPH_R_STATUS] = 1,
	[TAIKO_A_RX_EAR_BIAS_PA] = 1,
	[TAIKO_A_RX_EAR_BIAS_CMBUFF] = 1,
	[TAIKO_A_RX_EAR_EN] = 1,
	[TAIKO_A_RX_EAR_GAIN] = 1,
	[TAIKO_A_RX_EAR_CMBUFF] = 1,
	[TAIKO_A_RX_EAR_ICTL] = 1,
	[TAIKO_A_RX_EAR_CCOMP] = 1,
	[TAIKO_A_RX_EAR_VCM] = 1,
	[TAIKO_A_RX_EAR_CNP] = 1,
	[TAIKO_A_RX_EAR_DAC_CTL_ATEST] = 1,
	[TAIKO_A_RX_EAR_STATUS] = 1,
	[TAIKO_A_RX_LINE_BIAS_PA] = 1,
	[TAIKO_A_RX_BUCK_BIAS1] = 1,
	[TAIKO_A_RX_BUCK_BIAS2] = 1,
	[TAIKO_A_RX_LINE_COM] = 1,
	[TAIKO_A_RX_LINE_CNP_EN] = 1,
	[TAIKO_A_RX_LINE_CNP_WG_CTL] = 1,
	[TAIKO_A_RX_LINE_CNP_WG_TIME] = 1,
	[TAIKO_A_RX_LINE_1_GAIN] = 1,
	[TAIKO_A_RX_LINE_1_TEST] = 1,
	[TAIKO_A_RX_LINE_1_DAC_CTL] = 1,
	[TAIKO_A_RX_LINE_1_STATUS] = 1,
	[TAIKO_A_RX_LINE_2_GAIN] = 1,
	[TAIKO_A_RX_LINE_2_TEST] = 1,
	[TAIKO_A_RX_LINE_2_DAC_CTL] = 1,
	[TAIKO_A_RX_LINE_2_STATUS] = 1,
	[TAIKO_A_RX_LINE_3_GAIN] = 1,
	[TAIKO_A_RX_LINE_3_TEST] = 1,
	[TAIKO_A_RX_LINE_3_DAC_CTL] = 1,
	[TAIKO_A_RX_LINE_3_STATUS] = 1,
	[TAIKO_A_RX_LINE_4_GAIN] = 1,
	[TAIKO_A_RX_LINE_4_TEST] = 1,
	[TAIKO_A_RX_LINE_4_DAC_CTL] = 1,
	[TAIKO_A_RX_LINE_4_STATUS] = 1,
	[TAIKO_A_RX_LINE_CNP_DBG] = 1,
	[TAIKO_A_SPKR_DRV_EN] = 1,
	[TAIKO_A_SPKR_DRV_GAIN] = 1,
	[TAIKO_A_SPKR_DRV_DAC_CTL] = 1,
	[TAIKO_A_SPKR_DRV_OCP_CTL] = 1,
	[TAIKO_A_SPKR_DRV_CLIP_DET] = 1,
	[TAIKO_A_SPKR_DRV_IEC] = 1,
	[TAIKO_A_SPKR_DRV_DBG_DAC] = 1,
	[TAIKO_A_SPKR_DRV_DBG_PA] = 1,
	[TAIKO_A_SPKR_DRV_DBG_PWRSTG] = 1,
	[TAIKO_A_SPKR_DRV_BIAS_LDO] = 1,
	[TAIKO_A_SPKR_DRV_BIAS_INT] = 1,
	[TAIKO_A_SPKR_DRV_BIAS_PA] = 1,
	[TAIKO_A_SPKR_DRV_STATUS_OCP] = 1,
	[TAIKO_A_SPKR_DRV_STATUS_PA] = 1,
	[TAIKO_A_SPKR_PROT_EN] = 1,
	[TAIKO_A_SPKR_PROT_ADC_EN] = 1,
	[TAIKO_A_SPKR_PROT_ISENSE_BIAS] = 1,
	[TAIKO_A_SPKR_PROT_VSENSE_BIAS] = 1,
	[TAIKO_A_SPKR_PROT_ADC_ATEST_REFCTRL] = 1,
	[TAIKO_A_SPKR_PROT_ADC_TEST_CTL] = 1,
	[TAIKO_A_SPKR_PROT_TEST_BLOCK_EN] = 1,
	[TAIKO_A_SPKR_PROT_ATEST] = 1,
	[TAIKO_A_SPKR_PROT_V_SAR_ERR] = 1,
	[TAIKO_A_SPKR_PROT_I_SAR_ERR] = 1,
	[TAIKO_A_SPKR_PROT_LDO_CTRL] = 1,
	[TAIKO_A_SPKR_PROT_ISENSE_CTRL] = 1,
	[TAIKO_A_SPKR_PROT_VSENSE_CTRL] = 1,
	[TAIKO_A_RC_OSC_FREQ] = 1,
	[TAIKO_A_RC_OSC_TEST] = 1,
	[TAIKO_A_RC_OSC_STATUS] = 1,
	[TAIKO_A_RC_OSC_TUNER] = 1,
	[TAIKO_A_MBHC_HPH] = 1,
	[TAIKO_A_CDC_ANC1_B1_CTL] = 1,
	[TAIKO_A_CDC_ANC2_B1_CTL] = 1,
	[TAIKO_A_CDC_ANC1_SHIFT] = 1,
	[TAIKO_A_CDC_ANC2_SHIFT] = 1,
	[TAIKO_A_CDC_ANC1_IIR_B1_CTL] = 1,
	[TAIKO_A_CDC_ANC2_IIR_B1_CTL] = 1,
	[TAIKO_A_CDC_ANC1_IIR_B2_CTL] = 1,
	[TAIKO_A_CDC_ANC2_IIR_B2_CTL] = 1,
	[TAIKO_A_CDC_ANC1_IIR_B3_CTL] = 1,
	[TAIKO_A_CDC_ANC2_IIR_B3_CTL] = 1,
	[TAIKO_A_CDC_ANC1_LPF_B1_CTL] = 1,
	[TAIKO_A_CDC_ANC2_LPF_B1_CTL] = 1,
	[TAIKO_A_CDC_ANC1_LPF_B2_CTL] = 1,
	[TAIKO_A_CDC_ANC2_LPF_B2_CTL] = 1,
	[TAIKO_A_CDC_ANC1_SPARE] = 1,
	[TAIKO_A_CDC_ANC2_SPARE] = 1,
	[TAIKO_A_CDC_ANC1_SMLPF_CTL] = 1,
	[TAIKO_A_CDC_ANC2_SMLPF_CTL] = 1,
	[TAIKO_A_CDC_ANC1_DCFLT_CTL] = 1,
	[TAIKO_A_CDC_ANC2_DCFLT_CTL] = 1,
	[TAIKO_A_CDC_ANC1_GAIN_CTL] = 1,
	[TAIKO_A_CDC_ANC2_GAIN_CTL] = 1,
	[TAIKO_A_CDC_ANC1_B2_CTL] = 1,
	[TAIKO_A_CDC_ANC2_B2_CTL] = 1,
	[TAIKO_A_CDC_TX1_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX2_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX3_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX4_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX5_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX6_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX7_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX8_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX9_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX10_VOL_CTL_TIMER] = 1,
	[TAIKO_A_CDC_TX1_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX2_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX3_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX4_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX5_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX6_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX7_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX8_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX9_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX10_VOL_CTL_GAIN] = 1,
	[TAIKO_A_CDC_TX1_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX2_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX3_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX4_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX5_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX6_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX7_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX8_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX9_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX10_VOL_CTL_CFG] = 1,
	[TAIKO_A_CDC_TX1_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX2_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX3_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX4_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX5_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX6_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX7_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX8_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX9_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX10_MUX_CTL] = 1,
	[TAIKO_A_CDC_TX1_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX2_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX3_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX4_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX5_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX6_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX7_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX8_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX9_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX10_CLK_FS_CTL] = 1,
	[TAIKO_A_CDC_TX1_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX2_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX3_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX4_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX5_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX6_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX7_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX8_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX9_DMIC_CTL] = 1,
	[TAIKO_A_CDC_TX10_DMIC_CTL] = 1,
	[TAIKO_A_CDC_DEBUG_B1_CTL] = 1,
	[TAIKO_A_CDC_DEBUG_B2_CTL] = 1,
	[TAIKO_A_CDC_DEBUG_B3_CTL] = 1,
	[TAIKO_A_CDC_DEBUG_B4_CTL] = 1,
	[TAIKO_A_CDC_DEBUG_B5_CTL] = 1,
	[TAIKO_A_CDC_DEBUG_B6_CTL] = 1,
	[TAIKO_A_CDC_DEBUG_B7_CTL] = 1,
	[TAIKO_A_CDC_SRC1_PDA_CFG] = 1,
	[TAIKO_A_CDC_SRC2_PDA_CFG] = 1,
	[TAIKO_A_CDC_SRC1_FS_CTL] = 1,
	[TAIKO_A_CDC_SRC2_FS_CTL] = 1,
	[TAIKO_A_CDC_RX1_B1_CTL] = 1,
	[TAIKO_A_CDC_RX2_B1_CTL] = 1,
	[TAIKO_A_CDC_RX3_B1_CTL] = 1,
	[TAIKO_A_CDC_RX4_B1_CTL] = 1,
	[TAIKO_A_CDC_RX5_B1_CTL] = 1,
	[TAIKO_A_CDC_RX6_B1_CTL] = 1,
	[TAIKO_A_CDC_RX7_B1_CTL] = 1,
	[TAIKO_A_CDC_RX1_B2_CTL] = 1,
	[TAIKO_A_CDC_RX2_B2_CTL] = 1,
	[TAIKO_A_CDC_RX3_B2_CTL] = 1,
	[TAIKO_A_CDC_RX4_B2_CTL] = 1,
	[TAIKO_A_CDC_RX5_B2_CTL] = 1,
	[TAIKO_A_CDC_RX6_B2_CTL] = 1,
	[TAIKO_A_CDC_RX7_B2_CTL] = 1,
	[TAIKO_A_CDC_RX1_B3_CTL] = 1,
	[TAIKO_A_CDC_RX2_B3_CTL] = 1,
	[TAIKO_A_CDC_RX3_B3_CTL] = 1,
	[TAIKO_A_CDC_RX4_B3_CTL] = 1,
	[TAIKO_A_CDC_RX5_B3_CTL] = 1,
	[TAIKO_A_CDC_RX6_B3_CTL] = 1,
	[TAIKO_A_CDC_RX7_B3_CTL] = 1,
	[TAIKO_A_CDC_RX1_B4_CTL] = 1,
	[TAIKO_A_CDC_RX2_B4_CTL] = 1,
	[TAIKO_A_CDC_RX3_B4_CTL] = 1,
	[TAIKO_A_CDC_RX4_B4_CTL] = 1,
	[TAIKO_A_CDC_RX5_B4_CTL] = 1,
	[TAIKO_A_CDC_RX6_B4_CTL] = 1,
	[TAIKO_A_CDC_RX7_B4_CTL] = 1,
	[TAIKO_A_CDC_RX1_B5_CTL] = 1,
	[TAIKO_A_CDC_RX2_B5_CTL] = 1,
	[TAIKO_A_CDC_RX3_B5_CTL] = 1,
	[TAIKO_A_CDC_RX4_B5_CTL] = 1,
	[TAIKO_A_CDC_RX5_B5_CTL] = 1,
	[TAIKO_A_CDC_RX6_B5_CTL] = 1,
	[TAIKO_A_CDC_RX7_B5_CTL] = 1,
	[TAIKO_A_CDC_RX1_B6_CTL] = 1,
	[TAIKO_A_CDC_RX2_B6_CTL] = 1,
	[TAIKO_A_CDC_RX3_B6_CTL] = 1,
	[TAIKO_A_CDC_RX4_B6_CTL] = 1,
	[TAIKO_A_CDC_RX5_B6_CTL] = 1,
	[TAIKO_A_CDC_RX6_B6_CTL] = 1,
	[TAIKO_A_CDC_RX7_B6_CTL] = 1,
	[TAIKO_A_CDC_RX1_VOL_CTL_B1_CTL] = 1,
	[TAIKO_A_CDC_RX2_VOL_CTL_B1_CTL] = 1,
	[TAIKO_A_CDC_RX3_VOL_CTL_B1_CTL] = 1,
	[TAIKO_A_CDC_RX4_VOL_CTL_B1_CTL] = 1,
	[TAIKO_A_CDC_RX5_VOL_CTL_B1_CTL] = 1,
	[TAIKO_A_CDC_RX6_VOL_CTL_B1_CTL] = 1,
	[TAIKO_A_CDC_RX7_VOL_CTL_B1_CTL] = 1,
	[TAIKO_A_CDC_RX1_VOL_CTL_B2_CTL] = 1,
	[TAIKO_A_CDC_RX2_VOL_CTL_B2_CTL] = 1,
	[TAIKO_A_CDC_RX3_VOL_CTL_B2_CTL] = 1,
	[TAIKO_A_CDC_RX4_VOL_CTL_B2_CTL] = 1,
	[TAIKO_A_CDC_RX5_VOL_CTL_B2_CTL] = 1,
	[TAIKO_A_CDC_RX6_VOL_CTL_B2_CTL] = 1,
	[TAIKO_A_CDC_RX7_VOL_CTL_B2_CTL] = 1,
	[TAIKO_A_CDC_VBAT_CFG] = 1,
	[TAIKO_A_CDC_VBAT_ADC_CAL1] = 1,
	[TAIKO_A_CDC_VBAT_ADC_CAL2] = 1,
	[TAIKO_A_CDC_VBAT_ADC_CAL3] = 1,
	[TAIKO_A_CDC_VBAT_PK_EST1] = 1,
	[TAIKO_A_CDC_VBAT_PK_EST2] = 1,
	[TAIKO_A_CDC_VBAT_PK_EST3] = 1,
	[TAIKO_A_CDC_VBAT_RF_PROC1] = 1,
	[TAIKO_A_CDC_VBAT_RF_PROC2] = 1,
	[TAIKO_A_CDC_VBAT_TAC1] = 1,
	[TAIKO_A_CDC_VBAT_TAC2] = 1,
	[TAIKO_A_CDC_VBAT_TAC3] = 1,
	[TAIKO_A_CDC_VBAT_TAC4] = 1,
	[TAIKO_A_CDC_VBAT_GAIN_UPD1] = 1,
	[TAIKO_A_CDC_VBAT_GAIN_UPD2] = 1,
	[TAIKO_A_CDC_VBAT_GAIN_UPD3] = 1,
	[TAIKO_A_CDC_VBAT_GAIN_UPD4] = 1,
	[TAIKO_A_CDC_VBAT_DEBUG1] = 1,
	[TAIKO_A_CDC_CLK_ANC_RESET_CTL] = 1,
	[TAIKO_A_CDC_CLK_RX_RESET_CTL] = 1,
	[TAIKO_A_CDC_CLK_TX_RESET_B1_CTL] = 1,
	[TAIKO_A_CDC_CLK_TX_RESET_B2_CTL] = 1,
	[TAIKO_A_CDC_CLK_DMIC_B1_CTL] = 1,
	[TAIKO_A_CDC_CLK_DMIC_B2_CTL] = 1,
	[TAIKO_A_CDC_CLK_RX_I2S_CTL] = 1,
	[TAIKO_A_CDC_CLK_TX_I2S_CTL] = 1,
	[TAIKO_A_CDC_CLK_OTHR_RESET_B1_CTL] = 1,
	[TAIKO_A_CDC_CLK_OTHR_RESET_B2_CTL] = 1,
	[TAIKO_A_CDC_CLK_TX_CLK_EN_B1_CTL] = 1,
	[TAIKO_A_CDC_CLK_TX_CLK_EN_B2_CTL] = 1,
	[TAIKO_A_CDC_CLK_OTHR_CTL] = 1,
	[TAIKO_A_CDC_CLK_RDAC_CLK_EN_CTL] = 1,
	[TAIKO_A_CDC_CLK_ANC_CLK_EN_CTL] = 1,
	[TAIKO_A_CDC_CLK_RX_B1_CTL] = 1,
	[TAIKO_A_CDC_CLK_RX_B2_CTL] = 1,
	[TAIKO_A_CDC_CLK_MCLK_CTL] = 1,
	[TAIKO_A_CDC_CLK_PDM_CTL] = 1,
	[TAIKO_A_CDC_CLK_SD_CTL] = 1,
	[TAIKO_A_CDC_CLK_POWER_CTL] = 1,
	[TAIKO_A_CDC_CLSH_B1_CTL] = 1,
	[TAIKO_A_CDC_CLSH_B2_CTL] = 1,
	[TAIKO_A_CDC_CLSH_B3_CTL] = 1,
	[TAIKO_A_CDC_CLSH_BUCK_NCP_VARS] = 1,
	[TAIKO_A_CDC_CLSH_IDLE_HPH_THSD] = 1,
	[TAIKO_A_CDC_CLSH_IDLE_EAR_THSD] = 1,
	[TAIKO_A_CDC_CLSH_FCLKONLY_HPH_THSD] = 1,
	[TAIKO_A_CDC_CLSH_FCLKONLY_EAR_THSD] = 1,
	[TAIKO_A_CDC_CLSH_K_ADDR] = 1,
	[TAIKO_A_CDC_CLSH_K_DATA] = 1,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_HPH_L] = 1,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_HPH_U] = 1,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_EAR_L] = 1,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_EAR_U] = 1,
	[TAIKO_A_CDC_CLSH_V_PA_HD_EAR] = 1,
	[TAIKO_A_CDC_CLSH_V_PA_HD_HPH] = 1,
	[TAIKO_A_CDC_CLSH_V_PA_MIN_EAR] = 1,
	[TAIKO_A_CDC_CLSH_V_PA_MIN_HPH] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B1_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B1_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B2_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B2_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B3_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B3_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B4_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B4_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B5_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B5_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B6_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B6_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B7_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B7_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_B8_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_B8_CTL] = 1,
	[TAIKO_A_CDC_IIR1_CTL] = 1,
	[TAIKO_A_CDC_IIR2_CTL] = 1,
	[TAIKO_A_CDC_IIR1_GAIN_TIMER_CTL] = 1,
	[TAIKO_A_CDC_IIR2_GAIN_TIMER_CTL] = 1,
	[TAIKO_A_CDC_IIR1_COEF_B1_CTL] = 1,
	[TAIKO_A_CDC_IIR2_COEF_B1_CTL] = 1,
	[TAIKO_A_CDC_IIR1_COEF_B2_CTL] = 1,
	[TAIKO_A_CDC_IIR2_COEF_B2_CTL] = 1,
	[TAIKO_A_CDC_TOP_GAIN_UPDATE] = 1,
	[TAIKO_A_CDC_COMP0_B1_CTL] = 1,
	[TAIKO_A_CDC_COMP1_B1_CTL] = 1,
	[TAIKO_A_CDC_COMP2_B1_CTL] = 1,
	[TAIKO_A_CDC_COMP0_B2_CTL] = 1,
	[TAIKO_A_CDC_COMP1_B2_CTL] = 1,
	[TAIKO_A_CDC_COMP2_B2_CTL] = 1,
	[TAIKO_A_CDC_COMP0_B3_CTL] = 1,
	[TAIKO_A_CDC_COMP1_B3_CTL] = 1,
	[TAIKO_A_CDC_COMP2_B3_CTL] = 1,
	[TAIKO_A_CDC_COMP0_B4_CTL] = 1,
	[TAIKO_A_CDC_COMP1_B4_CTL] = 1,
	[TAIKO_A_CDC_COMP2_B4_CTL] = 1,
	[TAIKO_A_CDC_COMP0_B5_CTL] = 1,
	[TAIKO_A_CDC_COMP1_B5_CTL] = 1,
	[TAIKO_A_CDC_COMP2_B5_CTL] = 1,
	[TAIKO_A_CDC_COMP0_B6_CTL] = 1,
	[TAIKO_A_CDC_COMP1_B6_CTL] = 1,
	[TAIKO_A_CDC_COMP2_B6_CTL] = 1,
	[TAIKO_A_CDC_COMP0_SHUT_DOWN_STATUS] = 1,
	[TAIKO_A_CDC_COMP1_SHUT_DOWN_STATUS] = 1,
	[TAIKO_A_CDC_COMP2_SHUT_DOWN_STATUS] = 1,
	[TAIKO_A_CDC_COMP0_FS_CFG] = 1,
	[TAIKO_A_CDC_COMP1_FS_CFG] = 1,
	[TAIKO_A_CDC_COMP2_FS_CFG] = 1,
	[TAIKO_A_CDC_CONN_RX1_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX1_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX1_B3_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX2_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX2_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX2_B3_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX3_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX3_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX4_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX4_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX5_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX5_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX6_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX6_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX7_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX7_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX7_B3_CTL] = 1,
	[TAIKO_A_CDC_CONN_ANC_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_ANC_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_B3_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_B4_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ1_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ1_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ1_B3_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ1_B4_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ2_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ2_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ2_B3_CTL] = 1,
	[TAIKO_A_CDC_CONN_EQ2_B4_CTL] = 1,
	[TAIKO_A_CDC_CONN_SRC1_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_SRC1_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_SRC2_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_SRC2_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B3_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B4_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B5_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B6_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B7_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B8_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B9_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B10_CTL] = 1,
	[TAIKO_A_CDC_CONN_TX_SB_B11_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX_SB_B1_CTL] = 1,
	[TAIKO_A_CDC_CONN_RX_SB_B2_CTL] = 1,
	[TAIKO_A_CDC_CONN_CLSH_CTL] = 1,
	[TAIKO_A_CDC_CONN_MISC] = 1,
	[TAIKO_A_CDC_CONN_MAD] = 1,
	[TAIKO_A_CDC_MBHC_EN_CTL] = 1,
	[TAIKO_A_CDC_MBHC_FIR_B1_CFG] = 1,
	[TAIKO_A_CDC_MBHC_FIR_B2_CFG] = 1,
	[TAIKO_A_CDC_MBHC_TIMER_B1_CTL] = 1,
	[TAIKO_A_CDC_MBHC_TIMER_B2_CTL] = 1,
	[TAIKO_A_CDC_MBHC_TIMER_B3_CTL] = 1,
	[TAIKO_A_CDC_MBHC_TIMER_B4_CTL] = 1,
	[TAIKO_A_CDC_MBHC_TIMER_B5_CTL] = 1,
	[TAIKO_A_CDC_MBHC_TIMER_B6_CTL] = 1,
	[TAIKO_A_CDC_MBHC_B1_STATUS] = 1,
	[TAIKO_A_CDC_MBHC_B2_STATUS] = 1,
	[TAIKO_A_CDC_MBHC_B3_STATUS] = 1,
	[TAIKO_A_CDC_MBHC_B4_STATUS] = 1,
	[TAIKO_A_CDC_MBHC_B5_STATUS] = 1,
	[TAIKO_A_CDC_MBHC_B1_CTL] = 1,
	[TAIKO_A_CDC_MBHC_B2_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B1_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B2_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B3_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B4_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B5_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B6_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B7_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B8_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B9_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B10_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B11_CTL] = 1,
	[TAIKO_A_CDC_MBHC_VOLT_B12_CTL] = 1,
	[TAIKO_A_CDC_MBHC_CLK_CTL] = 1,
	[TAIKO_A_CDC_MBHC_INT_CTL] = 1,
	[TAIKO_A_CDC_MBHC_DEBUG_CTL] = 1,
	[TAIKO_A_CDC_MBHC_SPARE] = 1,
	[TAIKO_A_CDC_MAD_MAIN_CTL_1] = 1,
	[TAIKO_A_CDC_MAD_MAIN_CTL_2] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_1] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_2] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_3] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_4] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_5] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_6] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_7] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_8] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_IIR_CTL_PTR] = 1,
	[TAIKO_A_CDC_MAD_AUDIO_IIR_CTL_VAL] = 1,
	[TAIKO_A_CDC_MAD_ULTR_CTL_1] = 1,
	[TAIKO_A_CDC_MAD_ULTR_CTL_2] = 1,
	[TAIKO_A_CDC_MAD_ULTR_CTL_3] = 1,
	[TAIKO_A_CDC_MAD_ULTR_CTL_4] = 1,
	[TAIKO_A_CDC_MAD_ULTR_CTL_5] = 1,
	[TAIKO_A_CDC_MAD_ULTR_CTL_6] = 1,
	[TAIKO_A_CDC_MAD_ULTR_CTL_7] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_1] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_2] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_3] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_4] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_5] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_6] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_7] = 1,
	[TAIKO_A_CDC_MAD_BEACON_CTL_8] = 1,
	[TAIKO_A_CDC_MAD_BEACON_IIR_CTL_PTR] = 1,
	[TAIKO_A_CDC_MAD_BEACON_IIR_CTL_VAL] = 1,
};

const u8 taiko_reg_defaults[TAIKO_CACHE_SIZE] = {
	[TAIKO_A_CHIP_CTL] = TAIKO_A_CHIP_CTL__POR,
	[TAIKO_A_CHIP_STATUS] = TAIKO_A_CHIP_STATUS__POR,
	[TAIKO_A_CHIP_ID_BYTE_0] = TAIKO_A_CHIP_ID_BYTE_0__POR,
	[TAIKO_A_CHIP_ID_BYTE_1] = TAIKO_A_CHIP_ID_BYTE_1__POR,
	[TAIKO_A_CHIP_ID_BYTE_2] = TAIKO_A_CHIP_ID_BYTE_2__POR,
	[TAIKO_A_CHIP_ID_BYTE_3] = TAIKO_A_CHIP_ID_BYTE_3__POR,
	[TAIKO_A_CHIP_VERSION] = TAIKO_A_CHIP_VERSION__POR,
	[TAIKO_A_SLAVE_ID_1] = TAIKO_A_SLAVE_ID_1__POR,
	[TAIKO_A_SLAVE_ID_2] = TAIKO_A_SLAVE_ID_2__POR,
	[TAIKO_A_SLAVE_ID_3] = TAIKO_A_SLAVE_ID_3__POR,
	[TAIKO_A_PIN_CTL_OE0] = TAIKO_A_PIN_CTL_OE0__POR,
	[TAIKO_A_PIN_CTL_OE1] = TAIKO_A_PIN_CTL_OE1__POR,
	[TAIKO_A_PIN_CTL_DATA0] = TAIKO_A_PIN_CTL_DATA0__POR,
	[TAIKO_A_PIN_CTL_DATA1] = TAIKO_A_PIN_CTL_DATA1__POR,
	[TAIKO_A_HDRIVE_GENERIC] = TAIKO_A_HDRIVE_GENERIC__POR,
	[TAIKO_A_HDRIVE_OVERRIDE] = TAIKO_A_HDRIVE_OVERRIDE__POR,
	[TAIKO_A_ANA_CSR_WAIT_STATE] = TAIKO_A_ANA_CSR_WAIT_STATE__POR,
	[TAIKO_A_PROCESS_MONITOR_CTL0] = TAIKO_A_PROCESS_MONITOR_CTL0__POR,
	[TAIKO_A_PROCESS_MONITOR_CTL1] = TAIKO_A_PROCESS_MONITOR_CTL1__POR,
	[TAIKO_A_PROCESS_MONITOR_CTL2] = TAIKO_A_PROCESS_MONITOR_CTL2__POR,
	[TAIKO_A_PROCESS_MONITOR_CTL3] = TAIKO_A_PROCESS_MONITOR_CTL3__POR,
	[TAIKO_A_QFUSE_CTL] = TAIKO_A_QFUSE_CTL__POR,
	[TAIKO_A_QFUSE_STATUS] = TAIKO_A_QFUSE_STATUS__POR,
	[TAIKO_A_QFUSE_DATA_OUT0] = TAIKO_A_QFUSE_DATA_OUT0__POR,
	[TAIKO_A_QFUSE_DATA_OUT1] = TAIKO_A_QFUSE_DATA_OUT1__POR,
	[TAIKO_A_QFUSE_DATA_OUT2] = TAIKO_A_QFUSE_DATA_OUT2__POR,
	[TAIKO_A_QFUSE_DATA_OUT3] = TAIKO_A_QFUSE_DATA_OUT3__POR,
	[TAIKO_A_QFUSE_DATA_OUT4] = TAIKO_A_QFUSE_DATA_OUT4__POR,
	[TAIKO_A_QFUSE_DATA_OUT5] = TAIKO_A_QFUSE_DATA_OUT5__POR,
	[TAIKO_A_QFUSE_DATA_OUT6] = TAIKO_A_QFUSE_DATA_OUT6__POR,
	[TAIKO_A_QFUSE_DATA_OUT7] = TAIKO_A_QFUSE_DATA_OUT7__POR,
	[TAIKO_A_CDC_CTL] = TAIKO_A_CDC_CTL__POR,
	[TAIKO_A_LEAKAGE_CTL] = TAIKO_A_LEAKAGE_CTL__POR,
	[TAIKO_A_INTR_MODE] = TAIKO_A_INTR_MODE__POR,
	[TAIKO_A_INTR_MASK0] = TAIKO_A_INTR_MASK0__POR,
	[TAIKO_A_INTR_MASK1] = TAIKO_A_INTR_MASK1__POR,
	[TAIKO_A_INTR_MASK2] = TAIKO_A_INTR_MASK2__POR,
	[TAIKO_A_INTR_MASK3] = TAIKO_A_INTR_MASK3__POR,
	[TAIKO_A_INTR_STATUS0] = TAIKO_A_INTR_STATUS0__POR,
	[TAIKO_A_INTR_STATUS1] = TAIKO_A_INTR_STATUS1__POR,
	[TAIKO_A_INTR_STATUS2] = TAIKO_A_INTR_STATUS2__POR,
	[TAIKO_A_INTR_STATUS3] = TAIKO_A_INTR_STATUS3__POR,
	[TAIKO_A_INTR_CLEAR0] = TAIKO_A_INTR_CLEAR0__POR,
	[TAIKO_A_INTR_CLEAR1] = TAIKO_A_INTR_CLEAR1__POR,
	[TAIKO_A_INTR_CLEAR2] = TAIKO_A_INTR_CLEAR2__POR,
	[TAIKO_A_INTR_CLEAR3] = TAIKO_A_INTR_CLEAR3__POR,
	[TAIKO_A_INTR_LEVEL0] = TAIKO_A_INTR_LEVEL0__POR,
	[TAIKO_A_INTR_LEVEL1] = TAIKO_A_INTR_LEVEL1__POR,
	[TAIKO_A_INTR_LEVEL2] = TAIKO_A_INTR_LEVEL2__POR,
	[TAIKO_A_INTR_LEVEL3] = TAIKO_A_INTR_LEVEL3__POR,
	[TAIKO_A_INTR_TEST0] = TAIKO_A_INTR_TEST0__POR,
	[TAIKO_A_INTR_TEST1] = TAIKO_A_INTR_TEST1__POR,
	[TAIKO_A_INTR_TEST2] = TAIKO_A_INTR_TEST2__POR,
	[TAIKO_A_INTR_TEST3] = TAIKO_A_INTR_TEST3__POR,
	[TAIKO_A_INTR_SET0] = TAIKO_A_INTR_SET0__POR,
	[TAIKO_A_INTR_SET1] = TAIKO_A_INTR_SET1__POR,
	[TAIKO_A_INTR_SET2] = TAIKO_A_INTR_SET2__POR,
	[TAIKO_A_INTR_SET3] = TAIKO_A_INTR_SET3__POR,
	[TAIKO_A_INTR_DESTN0] = TAIKO_A_INTR_DESTN0__POR,
	[TAIKO_A_INTR_DESTN1] = TAIKO_A_INTR_DESTN1__POR,
	[TAIKO_A_INTR_DESTN2] = TAIKO_A_INTR_DESTN2__POR,
	[TAIKO_A_INTR_DESTN3] = TAIKO_A_INTR_DESTN3__POR,
	[TAIKO_A_CDC_TX_I2S_SCK_MODE] = TAIKO_A_CDC_TX_I2S_SCK_MODE__POR,
	[TAIKO_A_CDC_TX_I2S_WS_MODE] = TAIKO_A_CDC_TX_I2S_WS_MODE__POR,
	[TAIKO_A_CDC_DMIC_DATA0_MODE] = TAIKO_A_CDC_DMIC_DATA0_MODE__POR,
	[TAIKO_A_CDC_DMIC_CLK0_MODE] = TAIKO_A_CDC_DMIC_CLK0_MODE__POR,
	[TAIKO_A_CDC_DMIC_DATA1_MODE] = TAIKO_A_CDC_DMIC_DATA1_MODE__POR,
	[TAIKO_A_CDC_DMIC_CLK1_MODE] = TAIKO_A_CDC_DMIC_CLK1_MODE__POR,
	[TAIKO_A_CDC_RX_I2S_SCK_MODE] = TAIKO_A_CDC_RX_I2S_SCK_MODE__POR,
	[TAIKO_A_CDC_RX_I2S_WS_MODE] = TAIKO_A_CDC_RX_I2S_WS_MODE__POR,
	[TAIKO_A_CDC_DMIC_DATA2_MODE] = TAIKO_A_CDC_DMIC_DATA2_MODE__POR,
	[TAIKO_A_CDC_DMIC_CLK2_MODE] = TAIKO_A_CDC_DMIC_CLK2_MODE__POR,
	[TAIKO_A_CDC_INTR1_MODE] = TAIKO_A_CDC_INTR1_MODE__POR,
	[TAIKO_A_CDC_SB_NRZ_SEL_MODE] = TAIKO_A_CDC_SB_NRZ_SEL_MODE__POR,
	[TAIKO_A_CDC_INTR2_MODE] = TAIKO_A_CDC_INTR2_MODE__POR,
	[TAIKO_A_CDC_RF_PA_ON_MODE] = TAIKO_A_CDC_RF_PA_ON_MODE__POR,
	[TAIKO_A_BIAS_REF_CTL] = TAIKO_A_BIAS_REF_CTL__POR,
	[TAIKO_A_BIAS_CENTRAL_BG_CTL] = TAIKO_A_BIAS_CENTRAL_BG_CTL__POR,
	[TAIKO_A_BIAS_PRECHRG_CTL] = TAIKO_A_BIAS_PRECHRG_CTL__POR,
	[TAIKO_A_BIAS_CURR_CTL_1] = TAIKO_A_BIAS_CURR_CTL_1__POR,
	[TAIKO_A_BIAS_CURR_CTL_2] = TAIKO_A_BIAS_CURR_CTL_2__POR,
	[TAIKO_A_BIAS_OSC_BG_CTL] = TAIKO_A_BIAS_OSC_BG_CTL__POR,
	[TAIKO_A_CLK_BUFF_EN1] = TAIKO_A_CLK_BUFF_EN1__POR,
	[TAIKO_A_CLK_BUFF_EN2] = TAIKO_A_CLK_BUFF_EN2__POR,
	[TAIKO_A_LDO_H_MODE_1] = TAIKO_A_LDO_H_MODE_1__POR,
	[TAIKO_A_LDO_H_MODE_2] = TAIKO_A_LDO_H_MODE_2__POR,
	[TAIKO_A_LDO_H_LOOP_CTL] = TAIKO_A_LDO_H_LOOP_CTL__POR,
	[TAIKO_A_LDO_H_COMP_1] = TAIKO_A_LDO_H_COMP_1__POR,
	[TAIKO_A_LDO_H_COMP_2] = TAIKO_A_LDO_H_COMP_2__POR,
	[TAIKO_A_LDO_H_BIAS_1] = TAIKO_A_LDO_H_BIAS_1__POR,
	[TAIKO_A_LDO_H_BIAS_2] = TAIKO_A_LDO_H_BIAS_2__POR,
	[TAIKO_A_LDO_H_BIAS_3] = TAIKO_A_LDO_H_BIAS_3__POR,
	[TAIKO_A_VBAT_CLK] = TAIKO_A_VBAT_CLK__POR,
	[TAIKO_A_VBAT_LOOP] = TAIKO_A_VBAT_LOOP__POR,
	[TAIKO_A_VBAT_REF] = TAIKO_A_VBAT_REF__POR,
	[TAIKO_A_VBAT_ADC_TEST] = TAIKO_A_VBAT_ADC_TEST__POR,
	[TAIKO_A_VBAT_FE] = TAIKO_A_VBAT_FE__POR,
	[TAIKO_A_VBAT_BIAS_1] = TAIKO_A_VBAT_BIAS_1__POR,
	[TAIKO_A_VBAT_BIAS_2] = TAIKO_A_VBAT_BIAS_2__POR,
	[TAIKO_A_VBAT_ADC_DATA_MSB] = TAIKO_A_VBAT_ADC_DATA_MSB__POR,
	[TAIKO_A_VBAT_ADC_DATA_LSB] = TAIKO_A_VBAT_ADC_DATA_LSB__POR,
	[TAIKO_A_MICB_CFILT_1_CTL] = TAIKO_A_MICB_CFILT_1_CTL__POR,
	[TAIKO_A_MICB_CFILT_1_VAL] = TAIKO_A_MICB_CFILT_1_VAL__POR,
	[TAIKO_A_MICB_CFILT_1_PRECHRG] = TAIKO_A_MICB_CFILT_1_PRECHRG__POR,
	[TAIKO_A_MICB_1_CTL] = TAIKO_A_MICB_1_CTL__POR,
	[TAIKO_A_MICB_1_INT_RBIAS] = TAIKO_A_MICB_1_INT_RBIAS__POR,
	[TAIKO_A_MICB_1_MBHC] = TAIKO_A_MICB_1_MBHC__POR,
	[TAIKO_A_MICB_CFILT_2_CTL] = TAIKO_A_MICB_CFILT_2_CTL__POR,
	[TAIKO_A_MICB_CFILT_2_VAL] = TAIKO_A_MICB_CFILT_2_VAL__POR,
	[TAIKO_A_MICB_CFILT_2_PRECHRG] = TAIKO_A_MICB_CFILT_2_PRECHRG__POR,
	[TAIKO_A_MICB_2_CTL] = TAIKO_A_MICB_2_CTL__POR,
	[TAIKO_A_MICB_2_INT_RBIAS] = TAIKO_A_MICB_2_INT_RBIAS__POR,
	[TAIKO_A_MICB_2_MBHC] = TAIKO_A_MICB_2_MBHC__POR,
	[TAIKO_A_MICB_CFILT_3_CTL] = TAIKO_A_MICB_CFILT_3_CTL__POR,
	[TAIKO_A_MICB_CFILT_3_VAL] = TAIKO_A_MICB_CFILT_3_VAL__POR,
	[TAIKO_A_MICB_CFILT_3_PRECHRG] = TAIKO_A_MICB_CFILT_3_PRECHRG__POR,
	[TAIKO_A_MICB_3_CTL] = TAIKO_A_MICB_3_CTL__POR,
	[TAIKO_A_MICB_3_INT_RBIAS] = TAIKO_A_MICB_3_INT_RBIAS__POR,
	[TAIKO_A_MICB_3_MBHC] = TAIKO_A_MICB_3_MBHC__POR,
	[TAIKO_A_MICB_4_CTL] = TAIKO_A_MICB_4_CTL__POR,
	[TAIKO_A_MICB_4_INT_RBIAS] = TAIKO_A_MICB_4_INT_RBIAS__POR,
	[TAIKO_A_MICB_4_MBHC] = TAIKO_A_MICB_4_MBHC__POR,
	[TAIKO_A_MBHC_INSERT_DETECT] = TAIKO_A_MBHC_INSERT_DETECT__POR,
	[TAIKO_A_MBHC_INSERT_DET_STATUS] = TAIKO_A_MBHC_INSERT_DET_STATUS__POR,
	[TAIKO_A_TX_COM_BIAS] = TAIKO_A_TX_COM_BIAS__POR,
	[TAIKO_A_MBHC_SCALING_MUX_1] = TAIKO_A_MBHC_SCALING_MUX_1__POR,
	[TAIKO_A_MBHC_SCALING_MUX_2] = TAIKO_A_MBHC_SCALING_MUX_2__POR,
	[TAIKO_A_MAD_ANA_CTRL] = TAIKO_A_MAD_ANA_CTRL__POR,
	[TAIKO_A_TX_SUP_SWITCH_CTRL_1] = TAIKO_A_TX_SUP_SWITCH_CTRL_1__POR,
	[TAIKO_A_TX_SUP_SWITCH_CTRL_2] = TAIKO_A_TX_SUP_SWITCH_CTRL_2__POR,
	[TAIKO_A_TX_1_2_EN] = TAIKO_A_TX_1_2_EN__POR,
	[TAIKO_A_TX_1_2_TEST_EN] = TAIKO_A_TX_1_2_TEST_EN__POR,
	[TAIKO_A_TX_1_2_ADC_CH1] = TAIKO_A_TX_1_2_ADC_CH1__POR,
	[TAIKO_A_TX_1_2_ADC_CH2] = TAIKO_A_TX_1_2_ADC_CH2__POR,
	[TAIKO_A_TX_1_2_ATEST_REFCTRL] = TAIKO_A_TX_1_2_ATEST_REFCTRL__POR,
	[TAIKO_A_TX_1_2_TEST_CTL] = TAIKO_A_TX_1_2_TEST_CTL__POR,
	[TAIKO_A_TX_1_2_TEST_BLOCK_EN] = TAIKO_A_TX_1_2_TEST_BLOCK_EN__POR,
	[TAIKO_A_TX_1_2_TXFE_CLKDIV] = TAIKO_A_TX_1_2_TXFE_CLKDIV__POR,
	[TAIKO_A_TX_1_2_SAR_ERR_CH1] = TAIKO_A_TX_1_2_SAR_ERR_CH1__POR,
	[TAIKO_A_TX_1_2_SAR_ERR_CH2] = TAIKO_A_TX_1_2_SAR_ERR_CH2__POR,
	[TAIKO_A_TX_3_4_EN] = TAIKO_A_TX_3_4_EN__POR,
	[TAIKO_A_TX_3_4_TEST_EN] = TAIKO_A_TX_3_4_TEST_EN__POR,
	[TAIKO_A_TX_3_4_ADC_CH3] = TAIKO_A_TX_3_4_ADC_CH3__POR,
	[TAIKO_A_TX_3_4_ADC_CH4] = TAIKO_A_TX_3_4_ADC_CH4__POR,
	[TAIKO_A_TX_3_4_ATEST_REFCTRL] = TAIKO_A_TX_3_4_ATEST_REFCTRL__POR,
	[TAIKO_A_TX_3_4_TEST_CTL] = TAIKO_A_TX_3_4_TEST_CTL__POR,
	[TAIKO_A_TX_3_4_TEST_BLOCK_EN] = TAIKO_A_TX_3_4_TEST_BLOCK_EN__POR,
	[TAIKO_A_TX_3_4_TXFE_CKDIV] = TAIKO_A_TX_3_4_TXFE_CKDIV__POR,
	[TAIKO_A_TX_3_4_SAR_ERR_CH3] = TAIKO_A_TX_3_4_SAR_ERR_CH3__POR,
	[TAIKO_A_TX_3_4_SAR_ERR_CH4] = TAIKO_A_TX_3_4_SAR_ERR_CH4__POR,
	[TAIKO_A_TX_5_6_EN] = TAIKO_A_TX_5_6_EN__POR,
	[TAIKO_A_TX_5_6_TEST_EN] = TAIKO_A_TX_5_6_TEST_EN__POR,
	[TAIKO_A_TX_5_6_ADC_CH5] = TAIKO_A_TX_5_6_ADC_CH5__POR,
	[TAIKO_A_TX_5_6_ADC_CH6] = TAIKO_A_TX_5_6_ADC_CH6__POR,
	[TAIKO_A_TX_5_6_ATEST_REFCTRL] = TAIKO_A_TX_5_6_ATEST_REFCTRL__POR,
	[TAIKO_A_TX_5_6_TEST_CTL] = TAIKO_A_TX_5_6_TEST_CTL__POR,
	[TAIKO_A_TX_5_6_TEST_BLOCK_EN] = TAIKO_A_TX_5_6_TEST_BLOCK_EN__POR,
	[TAIKO_A_TX_5_6_TXFE_CKDIV] = TAIKO_A_TX_5_6_TXFE_CKDIV__POR,
	[TAIKO_A_TX_5_6_SAR_ERR_CH5] = TAIKO_A_TX_5_6_SAR_ERR_CH5__POR,
	[TAIKO_A_TX_5_6_SAR_ERR_CH6] = TAIKO_A_TX_5_6_SAR_ERR_CH6__POR,
	[TAIKO_A_TX_7_MBHC_EN] = TAIKO_A_TX_7_MBHC_EN__POR,
	[TAIKO_A_TX_7_MBHC_ATEST_REFCTRL] =
	    TAIKO_A_TX_7_MBHC_ATEST_REFCTRL__POR,
	[TAIKO_A_TX_7_MBHC_ADC] = TAIKO_A_TX_7_MBHC_ADC__POR,
	[TAIKO_A_TX_7_MBHC_TEST_CTL] = TAIKO_A_TX_7_MBHC_TEST_CTL__POR,
	[TAIKO_A_TX_7_MBHC_SAR_ERR] = TAIKO_A_TX_7_MBHC_SAR_ERR__POR,
	[TAIKO_A_TX_7_TXFE_CLKDIV] = TAIKO_A_TX_7_TXFE_CLKDIV__POR,
	[TAIKO_A_BUCK_MODE_1] = TAIKO_A_BUCK_MODE_1__POR,
	[TAIKO_A_BUCK_MODE_2] = TAIKO_A_BUCK_MODE_2__POR,
	[TAIKO_A_BUCK_MODE_3] = TAIKO_A_BUCK_MODE_3__POR,
	[TAIKO_A_BUCK_MODE_4] = TAIKO_A_BUCK_MODE_4__POR,
	[TAIKO_A_BUCK_MODE_5] = TAIKO_A_BUCK_MODE_5__POR,
	[TAIKO_A_BUCK_CTRL_VCL_1] = TAIKO_A_BUCK_CTRL_VCL_1__POR,
	[TAIKO_A_BUCK_CTRL_VCL_2] = TAIKO_A_BUCK_CTRL_VCL_2__POR,
	[TAIKO_A_BUCK_CTRL_VCL_3] = TAIKO_A_BUCK_CTRL_VCL_3__POR,
	[TAIKO_A_BUCK_CTRL_CCL_1] = TAIKO_A_BUCK_CTRL_CCL_1__POR,
	[TAIKO_A_BUCK_CTRL_CCL_2] = TAIKO_A_BUCK_CTRL_CCL_2__POR,
	[TAIKO_A_BUCK_CTRL_CCL_3] = TAIKO_A_BUCK_CTRL_CCL_3__POR,
	[TAIKO_A_BUCK_CTRL_CCL_4] = TAIKO_A_BUCK_CTRL_CCL_4__POR,
	[TAIKO_A_BUCK_CTRL_PWM_DRVR_1] = TAIKO_A_BUCK_CTRL_PWM_DRVR_1__POR,
	[TAIKO_A_BUCK_CTRL_PWM_DRVR_2] = TAIKO_A_BUCK_CTRL_PWM_DRVR_2__POR,
	[TAIKO_A_BUCK_CTRL_PWM_DRVR_3] = TAIKO_A_BUCK_CTRL_PWM_DRVR_3__POR,
	[TAIKO_A_BUCK_TMUX_A_D] = TAIKO_A_BUCK_TMUX_A_D__POR,
	[TAIKO_A_NCP_BUCKREF] = TAIKO_A_NCP_BUCKREF__POR,
	[TAIKO_A_NCP_EN] = TAIKO_A_NCP_EN__POR,
	[TAIKO_A_NCP_CLK] = TAIKO_A_NCP_CLK__POR,
	[TAIKO_A_NCP_STATIC] = TAIKO_A_NCP_STATIC__POR,
	[TAIKO_A_NCP_VTH_LOW] = TAIKO_A_NCP_VTH_LOW__POR,
	[TAIKO_A_NCP_VTH_HIGH] = TAIKO_A_NCP_VTH_HIGH__POR,
	[TAIKO_A_NCP_ATEST] = TAIKO_A_NCP_ATEST__POR,
	[TAIKO_A_NCP_DTEST] = TAIKO_A_NCP_DTEST__POR,
	[TAIKO_A_NCP_DLY1] = TAIKO_A_NCP_DLY1__POR,
	[TAIKO_A_NCP_DLY2] = TAIKO_A_NCP_DLY2__POR,
	[TAIKO_A_RX_AUX_SW_CTL] = TAIKO_A_RX_AUX_SW_CTL__POR,
	[TAIKO_A_RX_PA_AUX_IN_CONN] = TAIKO_A_RX_PA_AUX_IN_CONN__POR,
	[TAIKO_A_RX_COM_TIMER_DIV] = TAIKO_A_RX_COM_TIMER_DIV__POR,
	[TAIKO_A_RX_COM_OCP_CTL] = TAIKO_A_RX_COM_OCP_CTL__POR,
	[TAIKO_A_RX_COM_OCP_COUNT] = TAIKO_A_RX_COM_OCP_COUNT__POR,
	[TAIKO_A_RX_COM_DAC_CTL] = TAIKO_A_RX_COM_DAC_CTL__POR,
	[TAIKO_A_RX_COM_BIAS] = TAIKO_A_RX_COM_BIAS__POR,
	[TAIKO_A_RX_HPH_AUTO_CHOP] = TAIKO_A_RX_HPH_AUTO_CHOP__POR,
	[TAIKO_A_RX_HPH_CHOP_CTL] = TAIKO_A_RX_HPH_CHOP_CTL__POR,
	[TAIKO_A_RX_HPH_BIAS_PA] = TAIKO_A_RX_HPH_BIAS_PA__POR,
	[TAIKO_A_RX_HPH_BIAS_LDO] = TAIKO_A_RX_HPH_BIAS_LDO__POR,
	[TAIKO_A_RX_HPH_BIAS_CNP] = TAIKO_A_RX_HPH_BIAS_CNP__POR,
	[TAIKO_A_RX_HPH_BIAS_WG_OCP] = TAIKO_A_RX_HPH_BIAS_WG_OCP__POR,
	[TAIKO_A_RX_HPH_OCP_CTL] = TAIKO_A_RX_HPH_OCP_CTL__POR,
	[TAIKO_A_RX_HPH_CNP_EN] = TAIKO_A_RX_HPH_CNP_EN__POR,
	[TAIKO_A_RX_HPH_CNP_WG_CTL] = TAIKO_A_RX_HPH_CNP_WG_CTL__POR,
	[TAIKO_A_RX_HPH_CNP_WG_TIME] = TAIKO_A_RX_HPH_CNP_WG_TIME__POR,
	[TAIKO_A_RX_HPH_L_GAIN] = TAIKO_A_RX_HPH_L_GAIN__POR,
	[TAIKO_A_RX_HPH_L_TEST] = TAIKO_A_RX_HPH_L_TEST__POR,
	[TAIKO_A_RX_HPH_L_PA_CTL] = TAIKO_A_RX_HPH_L_PA_CTL__POR,
	[TAIKO_A_RX_HPH_L_DAC_CTL] = TAIKO_A_RX_HPH_L_DAC_CTL__POR,
	[TAIKO_A_RX_HPH_L_ATEST] = TAIKO_A_RX_HPH_L_ATEST__POR,
	[TAIKO_A_RX_HPH_L_STATUS] = TAIKO_A_RX_HPH_L_STATUS__POR,
	[TAIKO_A_RX_HPH_R_GAIN] = TAIKO_A_RX_HPH_R_GAIN__POR,
	[TAIKO_A_RX_HPH_R_TEST] = TAIKO_A_RX_HPH_R_TEST__POR,
	[TAIKO_A_RX_HPH_R_PA_CTL] = TAIKO_A_RX_HPH_R_PA_CTL__POR,
	[TAIKO_A_RX_HPH_R_DAC_CTL] = TAIKO_A_RX_HPH_R_DAC_CTL__POR,
	[TAIKO_A_RX_HPH_R_ATEST] = TAIKO_A_RX_HPH_R_ATEST__POR,
	[TAIKO_A_RX_HPH_R_STATUS] = TAIKO_A_RX_HPH_R_STATUS__POR,
	[TAIKO_A_RX_EAR_BIAS_PA] = TAIKO_A_RX_EAR_BIAS_PA__POR,
	[TAIKO_A_RX_EAR_BIAS_CMBUFF] = TAIKO_A_RX_EAR_BIAS_CMBUFF__POR,
	[TAIKO_A_RX_EAR_EN] = TAIKO_A_RX_EAR_EN__POR,
	[TAIKO_A_RX_EAR_GAIN] = TAIKO_A_RX_EAR_GAIN__POR,
	[TAIKO_A_RX_EAR_CMBUFF] = TAIKO_A_RX_EAR_CMBUFF__POR,
	[TAIKO_A_RX_EAR_ICTL] = TAIKO_A_RX_EAR_ICTL__POR,
	[TAIKO_A_RX_EAR_CCOMP] = TAIKO_A_RX_EAR_CCOMP__POR,
	[TAIKO_A_RX_EAR_VCM] = TAIKO_A_RX_EAR_VCM__POR,
	[TAIKO_A_RX_EAR_CNP] = TAIKO_A_RX_EAR_CNP__POR,
	[TAIKO_A_RX_EAR_DAC_CTL_ATEST] = TAIKO_A_RX_EAR_DAC_CTL_ATEST__POR,
	[TAIKO_A_RX_EAR_STATUS] = TAIKO_A_RX_EAR_STATUS__POR,
	[TAIKO_A_RX_LINE_BIAS_PA] = TAIKO_A_RX_LINE_BIAS_PA__POR,
	[TAIKO_A_RX_BUCK_BIAS1] = TAIKO_A_RX_BUCK_BIAS1__POR,
	[TAIKO_A_RX_BUCK_BIAS2] = TAIKO_A_RX_BUCK_BIAS2__POR,
	[TAIKO_A_RX_LINE_COM] = TAIKO_A_RX_LINE_COM__POR,
	[TAIKO_A_RX_LINE_CNP_EN] = TAIKO_A_RX_LINE_CNP_EN__POR,
	[TAIKO_A_RX_LINE_CNP_WG_CTL] = TAIKO_A_RX_LINE_CNP_WG_CTL__POR,
	[TAIKO_A_RX_LINE_CNP_WG_TIME] = TAIKO_A_RX_LINE_CNP_WG_TIME__POR,
	[TAIKO_A_RX_LINE_1_GAIN] = TAIKO_A_RX_LINE_1_GAIN__POR,
	[TAIKO_A_RX_LINE_1_TEST] = TAIKO_A_RX_LINE_1_TEST__POR,
	[TAIKO_A_RX_LINE_1_DAC_CTL] = TAIKO_A_RX_LINE_1_DAC_CTL__POR,
	[TAIKO_A_RX_LINE_1_STATUS] = TAIKO_A_RX_LINE_1_STATUS__POR,
	[TAIKO_A_RX_LINE_2_GAIN] = TAIKO_A_RX_LINE_2_GAIN__POR,
	[TAIKO_A_RX_LINE_2_TEST] = TAIKO_A_RX_LINE_2_TEST__POR,
	[TAIKO_A_RX_LINE_2_DAC_CTL] = TAIKO_A_RX_LINE_2_DAC_CTL__POR,
	[TAIKO_A_RX_LINE_2_STATUS] = TAIKO_A_RX_LINE_2_STATUS__POR,
	[TAIKO_A_RX_LINE_3_GAIN] = TAIKO_A_RX_LINE_3_GAIN__POR,
	[TAIKO_A_RX_LINE_3_TEST] = TAIKO_A_RX_LINE_3_TEST__POR,
	[TAIKO_A_RX_LINE_3_DAC_CTL] = TAIKO_A_RX_LINE_3_DAC_CTL__POR,
	[TAIKO_A_RX_LINE_3_STATUS] = TAIKO_A_RX_LINE_3_STATUS__POR,
	[TAIKO_A_RX_LINE_4_GAIN] = TAIKO_A_RX_LINE_4_GAIN__POR,
	[TAIKO_A_RX_LINE_4_TEST] = TAIKO_A_RX_LINE_4_TEST__POR,
	[TAIKO_A_RX_LINE_4_DAC_CTL] = TAIKO_A_RX_LINE_4_DAC_CTL__POR,
	[TAIKO_A_RX_LINE_4_STATUS] = TAIKO_A_RX_LINE_4_STATUS__POR,
	[TAIKO_A_RX_LINE_CNP_DBG] = TAIKO_A_RX_LINE_CNP_DBG__POR,
	[TAIKO_A_SPKR_DRV_EN] = TAIKO_A_SPKR_DRV_EN__POR,
	[TAIKO_A_SPKR_DRV_GAIN] = TAIKO_A_SPKR_DRV_GAIN__POR,
	[TAIKO_A_SPKR_DRV_DAC_CTL] = TAIKO_A_SPKR_DRV_DAC_CTL__POR,
	[TAIKO_A_SPKR_DRV_OCP_CTL] = TAIKO_A_SPKR_DRV_OCP_CTL__POR,
	[TAIKO_A_SPKR_DRV_CLIP_DET] = TAIKO_A_SPKR_DRV_CLIP_DET__POR,
	[TAIKO_A_SPKR_DRV_IEC] = TAIKO_A_SPKR_DRV_IEC__POR,
	[TAIKO_A_SPKR_DRV_DBG_DAC] = TAIKO_A_SPKR_DRV_DBG_DAC__POR,
	[TAIKO_A_SPKR_DRV_DBG_PA] = TAIKO_A_SPKR_DRV_DBG_PA__POR,
	[TAIKO_A_SPKR_DRV_DBG_PWRSTG] = TAIKO_A_SPKR_DRV_DBG_PWRSTG__POR,
	[TAIKO_A_SPKR_DRV_BIAS_LDO] = TAIKO_A_SPKR_DRV_BIAS_LDO__POR,
	[TAIKO_A_SPKR_DRV_BIAS_INT] = TAIKO_A_SPKR_DRV_BIAS_INT__POR,
	[TAIKO_A_SPKR_DRV_BIAS_PA] = TAIKO_A_SPKR_DRV_BIAS_PA__POR,
	[TAIKO_A_SPKR_DRV_STATUS_OCP] = TAIKO_A_SPKR_DRV_STATUS_OCP__POR,
	[TAIKO_A_SPKR_DRV_STATUS_PA] = TAIKO_A_SPKR_DRV_STATUS_PA__POR,
	[TAIKO_A_SPKR_PROT_EN] = TAIKO_A_SPKR_PROT_EN__POR,
	[TAIKO_A_SPKR_PROT_ADC_EN] = TAIKO_A_SPKR_PROT_ADC_EN__POR,
	[TAIKO_A_SPKR_PROT_ISENSE_BIAS] = TAIKO_A_SPKR_PROT_ISENSE_BIAS__POR,
	[TAIKO_A_SPKR_PROT_VSENSE_BIAS] = TAIKO_A_SPKR_PROT_VSENSE_BIAS__POR,
	[TAIKO_A_SPKR_PROT_ADC_ATEST_REFCTRL] =
	    TAIKO_A_SPKR_PROT_ADC_ATEST_REFCTRL__POR,
	[TAIKO_A_SPKR_PROT_ADC_TEST_CTL] = TAIKO_A_SPKR_PROT_ADC_TEST_CTL__POR,
	[TAIKO_A_SPKR_PROT_TEST_BLOCK_EN] =
	    TAIKO_A_SPKR_PROT_TEST_BLOCK_EN__POR,
	[TAIKO_A_SPKR_PROT_ATEST] = TAIKO_A_SPKR_PROT_ATEST__POR,
	[TAIKO_A_SPKR_PROT_V_SAR_ERR] = TAIKO_A_SPKR_PROT_V_SAR_ERR__POR,
	[TAIKO_A_SPKR_PROT_I_SAR_ERR] = TAIKO_A_SPKR_PROT_I_SAR_ERR__POR,
	[TAIKO_A_SPKR_PROT_LDO_CTRL] = TAIKO_A_SPKR_PROT_LDO_CTRL__POR,
	[TAIKO_A_SPKR_PROT_ISENSE_CTRL] = TAIKO_A_SPKR_PROT_ISENSE_CTRL__POR,
	[TAIKO_A_SPKR_PROT_VSENSE_CTRL] = TAIKO_A_SPKR_PROT_VSENSE_CTRL__POR,
	[TAIKO_A_RC_OSC_FREQ] = TAIKO_A_RC_OSC_FREQ__POR,
	[TAIKO_A_RC_OSC_TEST] = TAIKO_A_RC_OSC_TEST__POR,
	[TAIKO_A_RC_OSC_STATUS] = TAIKO_A_RC_OSC_STATUS__POR,
	[TAIKO_A_RC_OSC_TUNER] = TAIKO_A_RC_OSC_TUNER__POR,
	[TAIKO_A_MBHC_HPH] = TAIKO_A_MBHC_HPH__POR,
	[TAIKO_A_CDC_ANC1_B1_CTL] = TAIKO_A_CDC_ANC1_B1_CTL__POR,
	[TAIKO_A_CDC_ANC2_B1_CTL] = TAIKO_A_CDC_ANC2_B1_CTL__POR,
	[TAIKO_A_CDC_ANC1_SHIFT] = TAIKO_A_CDC_ANC1_SHIFT__POR,
	[TAIKO_A_CDC_ANC2_SHIFT] = TAIKO_A_CDC_ANC2_SHIFT__POR,
	[TAIKO_A_CDC_ANC1_IIR_B1_CTL] = TAIKO_A_CDC_ANC1_IIR_B1_CTL__POR,
	[TAIKO_A_CDC_ANC2_IIR_B1_CTL] = TAIKO_A_CDC_ANC2_IIR_B1_CTL__POR,
	[TAIKO_A_CDC_ANC1_IIR_B2_CTL] = TAIKO_A_CDC_ANC1_IIR_B2_CTL__POR,
	[TAIKO_A_CDC_ANC2_IIR_B2_CTL] = TAIKO_A_CDC_ANC2_IIR_B2_CTL__POR,
	[TAIKO_A_CDC_ANC1_IIR_B3_CTL] = TAIKO_A_CDC_ANC1_IIR_B3_CTL__POR,
	[TAIKO_A_CDC_ANC2_IIR_B3_CTL] = TAIKO_A_CDC_ANC2_IIR_B3_CTL__POR,
	[TAIKO_A_CDC_ANC1_LPF_B1_CTL] = TAIKO_A_CDC_ANC1_LPF_B1_CTL__POR,
	[TAIKO_A_CDC_ANC2_LPF_B1_CTL] = TAIKO_A_CDC_ANC2_LPF_B1_CTL__POR,
	[TAIKO_A_CDC_ANC1_LPF_B2_CTL] = TAIKO_A_CDC_ANC1_LPF_B2_CTL__POR,
	[TAIKO_A_CDC_ANC2_LPF_B2_CTL] = TAIKO_A_CDC_ANC2_LPF_B2_CTL__POR,
	[TAIKO_A_CDC_ANC1_SPARE] = TAIKO_A_CDC_ANC1_SPARE__POR,
	[TAIKO_A_CDC_ANC2_SPARE] = TAIKO_A_CDC_ANC2_SPARE__POR,
	[TAIKO_A_CDC_ANC1_SMLPF_CTL] = TAIKO_A_CDC_ANC1_SMLPF_CTL__POR,
	[TAIKO_A_CDC_ANC2_SMLPF_CTL] = TAIKO_A_CDC_ANC2_SMLPF_CTL__POR,
	[TAIKO_A_CDC_ANC1_DCFLT_CTL] = TAIKO_A_CDC_ANC1_DCFLT_CTL__POR,
	[TAIKO_A_CDC_ANC2_DCFLT_CTL] = TAIKO_A_CDC_ANC2_DCFLT_CTL__POR,
	[TAIKO_A_CDC_ANC1_GAIN_CTL] = TAIKO_A_CDC_ANC1_GAIN_CTL__POR,
	[TAIKO_A_CDC_ANC2_GAIN_CTL] = TAIKO_A_CDC_ANC2_GAIN_CTL__POR,
	[TAIKO_A_CDC_ANC1_B2_CTL] = TAIKO_A_CDC_ANC1_B2_CTL__POR,
	[TAIKO_A_CDC_ANC2_B2_CTL] = TAIKO_A_CDC_ANC2_B2_CTL__POR,
	[TAIKO_A_CDC_TX1_VOL_CTL_TIMER] = TAIKO_A_CDC_TX1_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX2_VOL_CTL_TIMER] = TAIKO_A_CDC_TX2_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX3_VOL_CTL_TIMER] = TAIKO_A_CDC_TX3_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX4_VOL_CTL_TIMER] = TAIKO_A_CDC_TX4_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX5_VOL_CTL_TIMER] = TAIKO_A_CDC_TX5_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX6_VOL_CTL_TIMER] = TAIKO_A_CDC_TX6_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX7_VOL_CTL_TIMER] = TAIKO_A_CDC_TX7_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX8_VOL_CTL_TIMER] = TAIKO_A_CDC_TX8_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX9_VOL_CTL_TIMER] = TAIKO_A_CDC_TX9_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX10_VOL_CTL_TIMER] = TAIKO_A_CDC_TX10_VOL_CTL_TIMER__POR,
	[TAIKO_A_CDC_TX1_VOL_CTL_GAIN] = TAIKO_A_CDC_TX1_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX2_VOL_CTL_GAIN] = TAIKO_A_CDC_TX2_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX3_VOL_CTL_GAIN] = TAIKO_A_CDC_TX3_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX4_VOL_CTL_GAIN] = TAIKO_A_CDC_TX4_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX5_VOL_CTL_GAIN] = TAIKO_A_CDC_TX5_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX6_VOL_CTL_GAIN] = TAIKO_A_CDC_TX6_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX7_VOL_CTL_GAIN] = TAIKO_A_CDC_TX7_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX8_VOL_CTL_GAIN] = TAIKO_A_CDC_TX8_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX9_VOL_CTL_GAIN] = TAIKO_A_CDC_TX9_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX10_VOL_CTL_GAIN] = TAIKO_A_CDC_TX10_VOL_CTL_GAIN__POR,
	[TAIKO_A_CDC_TX1_VOL_CTL_CFG] = TAIKO_A_CDC_TX1_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX2_VOL_CTL_CFG] = TAIKO_A_CDC_TX2_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX3_VOL_CTL_CFG] = TAIKO_A_CDC_TX3_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX4_VOL_CTL_CFG] = TAIKO_A_CDC_TX4_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX5_VOL_CTL_CFG] = TAIKO_A_CDC_TX5_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX6_VOL_CTL_CFG] = TAIKO_A_CDC_TX6_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX7_VOL_CTL_CFG] = TAIKO_A_CDC_TX7_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX8_VOL_CTL_CFG] = TAIKO_A_CDC_TX8_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX9_VOL_CTL_CFG] = TAIKO_A_CDC_TX9_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX10_VOL_CTL_CFG] = TAIKO_A_CDC_TX10_VOL_CTL_CFG__POR,
	[TAIKO_A_CDC_TX1_MUX_CTL] = TAIKO_A_CDC_TX1_MUX_CTL__POR,
	[TAIKO_A_CDC_TX2_MUX_CTL] = TAIKO_A_CDC_TX2_MUX_CTL__POR,
	[TAIKO_A_CDC_TX3_MUX_CTL] = TAIKO_A_CDC_TX3_MUX_CTL__POR,
	[TAIKO_A_CDC_TX4_MUX_CTL] = TAIKO_A_CDC_TX4_MUX_CTL__POR,
	[TAIKO_A_CDC_TX5_MUX_CTL] = TAIKO_A_CDC_TX5_MUX_CTL__POR,
	[TAIKO_A_CDC_TX6_MUX_CTL] = TAIKO_A_CDC_TX6_MUX_CTL__POR,
	[TAIKO_A_CDC_TX7_MUX_CTL] = TAIKO_A_CDC_TX7_MUX_CTL__POR,
	[TAIKO_A_CDC_TX8_MUX_CTL] = TAIKO_A_CDC_TX8_MUX_CTL__POR,
	[TAIKO_A_CDC_TX9_MUX_CTL] = TAIKO_A_CDC_TX9_MUX_CTL__POR,
	[TAIKO_A_CDC_TX10_MUX_CTL] = TAIKO_A_CDC_TX10_MUX_CTL__POR,
	[TAIKO_A_CDC_TX1_CLK_FS_CTL] = TAIKO_A_CDC_TX1_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX2_CLK_FS_CTL] = TAIKO_A_CDC_TX2_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX3_CLK_FS_CTL] = TAIKO_A_CDC_TX3_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX4_CLK_FS_CTL] = TAIKO_A_CDC_TX4_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX5_CLK_FS_CTL] = TAIKO_A_CDC_TX5_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX6_CLK_FS_CTL] = TAIKO_A_CDC_TX6_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX7_CLK_FS_CTL] = TAIKO_A_CDC_TX7_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX8_CLK_FS_CTL] = TAIKO_A_CDC_TX8_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX9_CLK_FS_CTL] = TAIKO_A_CDC_TX9_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX10_CLK_FS_CTL] = TAIKO_A_CDC_TX10_CLK_FS_CTL__POR,
	[TAIKO_A_CDC_TX1_DMIC_CTL] = TAIKO_A_CDC_TX1_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX2_DMIC_CTL] = TAIKO_A_CDC_TX2_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX3_DMIC_CTL] = TAIKO_A_CDC_TX3_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX4_DMIC_CTL] = TAIKO_A_CDC_TX4_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX5_DMIC_CTL] = TAIKO_A_CDC_TX5_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX6_DMIC_CTL] = TAIKO_A_CDC_TX6_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX7_DMIC_CTL] = TAIKO_A_CDC_TX7_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX8_DMIC_CTL] = TAIKO_A_CDC_TX8_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX9_DMIC_CTL] = TAIKO_A_CDC_TX9_DMIC_CTL__POR,
	[TAIKO_A_CDC_TX10_DMIC_CTL] = TAIKO_A_CDC_TX10_DMIC_CTL__POR,
	[TAIKO_A_CDC_DEBUG_B1_CTL] = TAIKO_A_CDC_DEBUG_B1_CTL__POR,
	[TAIKO_A_CDC_DEBUG_B2_CTL] = TAIKO_A_CDC_DEBUG_B2_CTL__POR,
	[TAIKO_A_CDC_DEBUG_B3_CTL] = TAIKO_A_CDC_DEBUG_B3_CTL__POR,
	[TAIKO_A_CDC_DEBUG_B4_CTL] = TAIKO_A_CDC_DEBUG_B4_CTL__POR,
	[TAIKO_A_CDC_DEBUG_B5_CTL] = TAIKO_A_CDC_DEBUG_B5_CTL__POR,
	[TAIKO_A_CDC_DEBUG_B6_CTL] = TAIKO_A_CDC_DEBUG_B6_CTL__POR,
	[TAIKO_A_CDC_DEBUG_B7_CTL] = TAIKO_A_CDC_DEBUG_B7_CTL__POR,
	[TAIKO_A_CDC_SRC1_PDA_CFG] = TAIKO_A_CDC_SRC1_PDA_CFG__POR,
	[TAIKO_A_CDC_SRC2_PDA_CFG] = TAIKO_A_CDC_SRC2_PDA_CFG__POR,
	[TAIKO_A_CDC_SRC1_FS_CTL] = TAIKO_A_CDC_SRC1_FS_CTL__POR,
	[TAIKO_A_CDC_SRC2_FS_CTL] = TAIKO_A_CDC_SRC2_FS_CTL__POR,
	[TAIKO_A_CDC_RX1_B1_CTL] = TAIKO_A_CDC_RX1_B1_CTL__POR,
	[TAIKO_A_CDC_RX2_B1_CTL] = TAIKO_A_CDC_RX2_B1_CTL__POR,
	[TAIKO_A_CDC_RX3_B1_CTL] = TAIKO_A_CDC_RX3_B1_CTL__POR,
	[TAIKO_A_CDC_RX4_B1_CTL] = TAIKO_A_CDC_RX4_B1_CTL__POR,
	[TAIKO_A_CDC_RX5_B1_CTL] = TAIKO_A_CDC_RX5_B1_CTL__POR,
	[TAIKO_A_CDC_RX6_B1_CTL] = TAIKO_A_CDC_RX6_B1_CTL__POR,
	[TAIKO_A_CDC_RX7_B1_CTL] = TAIKO_A_CDC_RX7_B1_CTL__POR,
	[TAIKO_A_CDC_RX1_B2_CTL] = TAIKO_A_CDC_RX1_B2_CTL__POR,
	[TAIKO_A_CDC_RX2_B2_CTL] = TAIKO_A_CDC_RX2_B2_CTL__POR,
	[TAIKO_A_CDC_RX3_B2_CTL] = TAIKO_A_CDC_RX3_B2_CTL__POR,
	[TAIKO_A_CDC_RX4_B2_CTL] = TAIKO_A_CDC_RX4_B2_CTL__POR,
	[TAIKO_A_CDC_RX5_B2_CTL] = TAIKO_A_CDC_RX5_B2_CTL__POR,
	[TAIKO_A_CDC_RX6_B2_CTL] = TAIKO_A_CDC_RX6_B2_CTL__POR,
	[TAIKO_A_CDC_RX7_B2_CTL] = TAIKO_A_CDC_RX7_B2_CTL__POR,
	[TAIKO_A_CDC_RX1_B3_CTL] = TAIKO_A_CDC_RX1_B3_CTL__POR,
	[TAIKO_A_CDC_RX2_B3_CTL] = TAIKO_A_CDC_RX2_B3_CTL__POR,
	[TAIKO_A_CDC_RX3_B3_CTL] = TAIKO_A_CDC_RX3_B3_CTL__POR,
	[TAIKO_A_CDC_RX4_B3_CTL] = TAIKO_A_CDC_RX4_B3_CTL__POR,
	[TAIKO_A_CDC_RX5_B3_CTL] = TAIKO_A_CDC_RX5_B3_CTL__POR,
	[TAIKO_A_CDC_RX6_B3_CTL] = TAIKO_A_CDC_RX6_B3_CTL__POR,
	[TAIKO_A_CDC_RX7_B3_CTL] = TAIKO_A_CDC_RX7_B3_CTL__POR,
	[TAIKO_A_CDC_RX1_B4_CTL] = TAIKO_A_CDC_RX1_B4_CTL__POR,
	[TAIKO_A_CDC_RX2_B4_CTL] = TAIKO_A_CDC_RX2_B4_CTL__POR,
	[TAIKO_A_CDC_RX3_B4_CTL] = TAIKO_A_CDC_RX3_B4_CTL__POR,
	[TAIKO_A_CDC_RX4_B4_CTL] = TAIKO_A_CDC_RX4_B4_CTL__POR,
	[TAIKO_A_CDC_RX5_B4_CTL] = TAIKO_A_CDC_RX5_B4_CTL__POR,
	[TAIKO_A_CDC_RX6_B4_CTL] = TAIKO_A_CDC_RX6_B4_CTL__POR,
	[TAIKO_A_CDC_RX7_B4_CTL] = TAIKO_A_CDC_RX7_B4_CTL__POR,
	[TAIKO_A_CDC_RX1_B5_CTL] = TAIKO_A_CDC_RX1_B5_CTL__POR,
	[TAIKO_A_CDC_RX2_B5_CTL] = TAIKO_A_CDC_RX2_B5_CTL__POR,
	[TAIKO_A_CDC_RX3_B5_CTL] = TAIKO_A_CDC_RX3_B5_CTL__POR,
	[TAIKO_A_CDC_RX4_B5_CTL] = TAIKO_A_CDC_RX4_B5_CTL__POR,
	[TAIKO_A_CDC_RX5_B5_CTL] = TAIKO_A_CDC_RX5_B5_CTL__POR,
	[TAIKO_A_CDC_RX6_B5_CTL] = TAIKO_A_CDC_RX6_B5_CTL__POR,
	[TAIKO_A_CDC_RX7_B5_CTL] = TAIKO_A_CDC_RX7_B5_CTL__POR,
	[TAIKO_A_CDC_RX1_B6_CTL] = TAIKO_A_CDC_RX1_B6_CTL__POR,
	[TAIKO_A_CDC_RX2_B6_CTL] = TAIKO_A_CDC_RX2_B6_CTL__POR,
	[TAIKO_A_CDC_RX3_B6_CTL] = TAIKO_A_CDC_RX3_B6_CTL__POR,
	[TAIKO_A_CDC_RX4_B6_CTL] = TAIKO_A_CDC_RX4_B6_CTL__POR,
	[TAIKO_A_CDC_RX5_B6_CTL] = TAIKO_A_CDC_RX5_B6_CTL__POR,
	[TAIKO_A_CDC_RX6_B6_CTL] = TAIKO_A_CDC_RX6_B6_CTL__POR,
	[TAIKO_A_CDC_RX7_B6_CTL] = TAIKO_A_CDC_RX7_B6_CTL__POR,
	[TAIKO_A_CDC_RX1_VOL_CTL_B1_CTL] = TAIKO_A_CDC_RX1_VOL_CTL_B1_CTL__POR,
	[TAIKO_A_CDC_RX2_VOL_CTL_B1_CTL] = TAIKO_A_CDC_RX2_VOL_CTL_B1_CTL__POR,
	[TAIKO_A_CDC_RX3_VOL_CTL_B1_CTL] = TAIKO_A_CDC_RX3_VOL_CTL_B1_CTL__POR,
	[TAIKO_A_CDC_RX4_VOL_CTL_B1_CTL] = TAIKO_A_CDC_RX4_VOL_CTL_B1_CTL__POR,
	[TAIKO_A_CDC_RX5_VOL_CTL_B1_CTL] = TAIKO_A_CDC_RX5_VOL_CTL_B1_CTL__POR,
	[TAIKO_A_CDC_RX6_VOL_CTL_B1_CTL] = TAIKO_A_CDC_RX6_VOL_CTL_B1_CTL__POR,
	[TAIKO_A_CDC_RX7_VOL_CTL_B1_CTL] = TAIKO_A_CDC_RX7_VOL_CTL_B1_CTL__POR,
	[TAIKO_A_CDC_RX1_VOL_CTL_B2_CTL] = TAIKO_A_CDC_RX1_VOL_CTL_B2_CTL__POR,
	[TAIKO_A_CDC_RX2_VOL_CTL_B2_CTL] = TAIKO_A_CDC_RX2_VOL_CTL_B2_CTL__POR,
	[TAIKO_A_CDC_RX3_VOL_CTL_B2_CTL] = TAIKO_A_CDC_RX3_VOL_CTL_B2_CTL__POR,
	[TAIKO_A_CDC_RX4_VOL_CTL_B2_CTL] = TAIKO_A_CDC_RX4_VOL_CTL_B2_CTL__POR,
	[TAIKO_A_CDC_RX5_VOL_CTL_B2_CTL] = TAIKO_A_CDC_RX5_VOL_CTL_B2_CTL__POR,
	[TAIKO_A_CDC_RX6_VOL_CTL_B2_CTL] = TAIKO_A_CDC_RX6_VOL_CTL_B2_CTL__POR,
	[TAIKO_A_CDC_RX7_VOL_CTL_B2_CTL] = TAIKO_A_CDC_RX7_VOL_CTL_B2_CTL__POR,
	[TAIKO_A_CDC_VBAT_CFG] = TAIKO_A_CDC_VBAT_CFG__POR,
	[TAIKO_A_CDC_VBAT_ADC_CAL1] = TAIKO_A_CDC_VBAT_ADC_CAL1__POR,
	[TAIKO_A_CDC_VBAT_ADC_CAL2] = TAIKO_A_CDC_VBAT_ADC_CAL2__POR,
	[TAIKO_A_CDC_VBAT_ADC_CAL3] = TAIKO_A_CDC_VBAT_ADC_CAL3__POR,
	[TAIKO_A_CDC_VBAT_PK_EST1] = TAIKO_A_CDC_VBAT_PK_EST1__POR,
	[TAIKO_A_CDC_VBAT_PK_EST2] = TAIKO_A_CDC_VBAT_PK_EST2__POR,
	[TAIKO_A_CDC_VBAT_PK_EST3] = TAIKO_A_CDC_VBAT_PK_EST3__POR,
	[TAIKO_A_CDC_VBAT_RF_PROC1] = TAIKO_A_CDC_VBAT_RF_PROC1__POR,
	[TAIKO_A_CDC_VBAT_RF_PROC2] = TAIKO_A_CDC_VBAT_RF_PROC2__POR,
	[TAIKO_A_CDC_VBAT_TAC1] = TAIKO_A_CDC_VBAT_TAC1__POR,
	[TAIKO_A_CDC_VBAT_TAC2] = TAIKO_A_CDC_VBAT_TAC2__POR,
	[TAIKO_A_CDC_VBAT_TAC3] = TAIKO_A_CDC_VBAT_TAC3__POR,
	[TAIKO_A_CDC_VBAT_TAC4] = TAIKO_A_CDC_VBAT_TAC4__POR,
	[TAIKO_A_CDC_VBAT_GAIN_UPD1] = TAIKO_A_CDC_VBAT_GAIN_UPD1__POR,
	[TAIKO_A_CDC_VBAT_GAIN_UPD2] = TAIKO_A_CDC_VBAT_GAIN_UPD2__POR,
	[TAIKO_A_CDC_VBAT_GAIN_UPD3] = TAIKO_A_CDC_VBAT_GAIN_UPD3__POR,
	[TAIKO_A_CDC_VBAT_GAIN_UPD4] = TAIKO_A_CDC_VBAT_GAIN_UPD4__POR,
	[TAIKO_A_CDC_VBAT_DEBUG1] = TAIKO_A_CDC_VBAT_DEBUG1__POR,
	[TAIKO_A_CDC_CLK_ANC_RESET_CTL] = TAIKO_A_CDC_CLK_ANC_RESET_CTL__POR,
	[TAIKO_A_CDC_CLK_RX_RESET_CTL] = TAIKO_A_CDC_CLK_RX_RESET_CTL__POR,
	[TAIKO_A_CDC_CLK_TX_RESET_B1_CTL] =
	    TAIKO_A_CDC_CLK_TX_RESET_B1_CTL__POR,
	[TAIKO_A_CDC_CLK_TX_RESET_B2_CTL] =
	    TAIKO_A_CDC_CLK_TX_RESET_B2_CTL__POR,
	[TAIKO_A_CDC_CLK_DMIC_B1_CTL] = TAIKO_A_CDC_CLK_DMIC_B1_CTL__POR,
	[TAIKO_A_CDC_CLK_DMIC_B2_CTL] = TAIKO_A_CDC_CLK_DMIC_B2_CTL__POR,
	[TAIKO_A_CDC_CLK_RX_I2S_CTL] = TAIKO_A_CDC_CLK_RX_I2S_CTL__POR,
	[TAIKO_A_CDC_CLK_TX_I2S_CTL] = TAIKO_A_CDC_CLK_TX_I2S_CTL__POR,
	[TAIKO_A_CDC_CLK_OTHR_RESET_B1_CTL] =
	    TAIKO_A_CDC_CLK_OTHR_RESET_B1_CTL__POR,
	[TAIKO_A_CDC_CLK_OTHR_RESET_B2_CTL] =
	    TAIKO_A_CDC_CLK_OTHR_RESET_B2_CTL__POR,
	[TAIKO_A_CDC_CLK_TX_CLK_EN_B1_CTL] =
	    TAIKO_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR,
	[TAIKO_A_CDC_CLK_TX_CLK_EN_B2_CTL] =
	    TAIKO_A_CDC_CLK_TX_CLK_EN_B2_CTL__POR,
	[TAIKO_A_CDC_CLK_OTHR_CTL] = TAIKO_A_CDC_CLK_OTHR_CTL__POR,
	[TAIKO_A_CDC_CLK_RDAC_CLK_EN_CTL] =
	    TAIKO_A_CDC_CLK_RDAC_CLK_EN_CTL__POR,
	[TAIKO_A_CDC_CLK_ANC_CLK_EN_CTL] = TAIKO_A_CDC_CLK_ANC_CLK_EN_CTL__POR,
	[TAIKO_A_CDC_CLK_RX_B1_CTL] = TAIKO_A_CDC_CLK_RX_B1_CTL__POR,
	[TAIKO_A_CDC_CLK_RX_B2_CTL] = TAIKO_A_CDC_CLK_RX_B2_CTL__POR,
	[TAIKO_A_CDC_CLK_MCLK_CTL] = TAIKO_A_CDC_CLK_MCLK_CTL__POR,
	[TAIKO_A_CDC_CLK_PDM_CTL] = TAIKO_A_CDC_CLK_PDM_CTL__POR,
	[TAIKO_A_CDC_CLK_SD_CTL] = TAIKO_A_CDC_CLK_SD_CTL__POR,
	[TAIKO_A_CDC_CLK_POWER_CTL] = TAIKO_A_CDC_CLK_POWER_CTL__POR,
	[TAIKO_A_CDC_CLSH_B1_CTL] = TAIKO_A_CDC_CLSH_B1_CTL__POR,
	[TAIKO_A_CDC_CLSH_B2_CTL] = TAIKO_A_CDC_CLSH_B2_CTL__POR,
	[TAIKO_A_CDC_CLSH_B3_CTL] = TAIKO_A_CDC_CLSH_B3_CTL__POR,
	[TAIKO_A_CDC_CLSH_BUCK_NCP_VARS] = TAIKO_A_CDC_CLSH_BUCK_NCP_VARS__POR,
	[TAIKO_A_CDC_CLSH_IDLE_HPH_THSD] = TAIKO_A_CDC_CLSH_IDLE_HPH_THSD__POR,
	[TAIKO_A_CDC_CLSH_IDLE_EAR_THSD] = TAIKO_A_CDC_CLSH_IDLE_EAR_THSD__POR,
	[TAIKO_A_CDC_CLSH_FCLKONLY_HPH_THSD] =
	    TAIKO_A_CDC_CLSH_FCLKONLY_HPH_THSD__POR,
	[TAIKO_A_CDC_CLSH_FCLKONLY_EAR_THSD] =
	    TAIKO_A_CDC_CLSH_FCLKONLY_EAR_THSD__POR,
	[TAIKO_A_CDC_CLSH_K_ADDR] = TAIKO_A_CDC_CLSH_K_ADDR__POR,
	[TAIKO_A_CDC_CLSH_K_DATA] = TAIKO_A_CDC_CLSH_K_DATA__POR,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_HPH_L] =
	    TAIKO_A_CDC_CLSH_I_PA_FACT_HPH_L__POR,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_HPH_U] =
	    TAIKO_A_CDC_CLSH_I_PA_FACT_HPH_U__POR,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_EAR_L] =
	    TAIKO_A_CDC_CLSH_I_PA_FACT_EAR_L__POR,
	[TAIKO_A_CDC_CLSH_I_PA_FACT_EAR_U] =
	    TAIKO_A_CDC_CLSH_I_PA_FACT_EAR_U__POR,
	[TAIKO_A_CDC_CLSH_V_PA_HD_EAR] = TAIKO_A_CDC_CLSH_V_PA_HD_EAR__POR,
	[TAIKO_A_CDC_CLSH_V_PA_HD_HPH] = TAIKO_A_CDC_CLSH_V_PA_HD_HPH__POR,
	[TAIKO_A_CDC_CLSH_V_PA_MIN_EAR] = TAIKO_A_CDC_CLSH_V_PA_MIN_EAR__POR,
	[TAIKO_A_CDC_CLSH_V_PA_MIN_HPH] = TAIKO_A_CDC_CLSH_V_PA_MIN_HPH__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B1_CTL] = TAIKO_A_CDC_IIR1_GAIN_B1_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B1_CTL] = TAIKO_A_CDC_IIR2_GAIN_B1_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B2_CTL] = TAIKO_A_CDC_IIR1_GAIN_B2_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B2_CTL] = TAIKO_A_CDC_IIR2_GAIN_B2_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B3_CTL] = TAIKO_A_CDC_IIR1_GAIN_B3_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B3_CTL] = TAIKO_A_CDC_IIR2_GAIN_B3_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B4_CTL] = TAIKO_A_CDC_IIR1_GAIN_B4_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B4_CTL] = TAIKO_A_CDC_IIR2_GAIN_B4_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B5_CTL] = TAIKO_A_CDC_IIR1_GAIN_B5_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B5_CTL] = TAIKO_A_CDC_IIR2_GAIN_B5_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B6_CTL] = TAIKO_A_CDC_IIR1_GAIN_B6_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B6_CTL] = TAIKO_A_CDC_IIR2_GAIN_B6_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B7_CTL] = TAIKO_A_CDC_IIR1_GAIN_B7_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B7_CTL] = TAIKO_A_CDC_IIR2_GAIN_B7_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_B8_CTL] = TAIKO_A_CDC_IIR1_GAIN_B8_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_B8_CTL] = TAIKO_A_CDC_IIR2_GAIN_B8_CTL__POR,
	[TAIKO_A_CDC_IIR1_CTL] = TAIKO_A_CDC_IIR1_CTL__POR,
	[TAIKO_A_CDC_IIR2_CTL] = TAIKO_A_CDC_IIR2_CTL__POR,
	[TAIKO_A_CDC_IIR1_GAIN_TIMER_CTL] =
	    TAIKO_A_CDC_IIR1_GAIN_TIMER_CTL__POR,
	[TAIKO_A_CDC_IIR2_GAIN_TIMER_CTL] =
	    TAIKO_A_CDC_IIR2_GAIN_TIMER_CTL__POR,
	[TAIKO_A_CDC_IIR1_COEF_B1_CTL] = TAIKO_A_CDC_IIR1_COEF_B1_CTL__POR,
	[TAIKO_A_CDC_IIR2_COEF_B1_CTL] = TAIKO_A_CDC_IIR2_COEF_B1_CTL__POR,
	[TAIKO_A_CDC_IIR1_COEF_B2_CTL] = TAIKO_A_CDC_IIR1_COEF_B2_CTL__POR,
	[TAIKO_A_CDC_IIR2_COEF_B2_CTL] = TAIKO_A_CDC_IIR2_COEF_B2_CTL__POR,
	[TAIKO_A_CDC_TOP_GAIN_UPDATE] = TAIKO_A_CDC_TOP_GAIN_UPDATE__POR,
	[TAIKO_A_CDC_COMP0_B1_CTL] = TAIKO_A_CDC_COMP0_B1_CTL__POR,
	[TAIKO_A_CDC_COMP1_B1_CTL] = TAIKO_A_CDC_COMP1_B1_CTL__POR,
	[TAIKO_A_CDC_COMP2_B1_CTL] = TAIKO_A_CDC_COMP2_B1_CTL__POR,
	[TAIKO_A_CDC_COMP0_B2_CTL] = TAIKO_A_CDC_COMP0_B2_CTL__POR,
	[TAIKO_A_CDC_COMP1_B2_CTL] = TAIKO_A_CDC_COMP1_B2_CTL__POR,
	[TAIKO_A_CDC_COMP2_B2_CTL] = TAIKO_A_CDC_COMP2_B2_CTL__POR,
	[TAIKO_A_CDC_COMP0_B3_CTL] = TAIKO_A_CDC_COMP0_B3_CTL__POR,
	[TAIKO_A_CDC_COMP1_B3_CTL] = TAIKO_A_CDC_COMP1_B3_CTL__POR,
	[TAIKO_A_CDC_COMP2_B3_CTL] = TAIKO_A_CDC_COMP2_B3_CTL__POR,
	[TAIKO_A_CDC_COMP0_B4_CTL] = TAIKO_A_CDC_COMP0_B4_CTL__POR,
	[TAIKO_A_CDC_COMP1_B4_CTL] = TAIKO_A_CDC_COMP1_B4_CTL__POR,
	[TAIKO_A_CDC_COMP2_B4_CTL] = TAIKO_A_CDC_COMP2_B4_CTL__POR,
	[TAIKO_A_CDC_COMP0_B5_CTL] = TAIKO_A_CDC_COMP0_B5_CTL__POR,
	[TAIKO_A_CDC_COMP1_B5_CTL] = TAIKO_A_CDC_COMP1_B5_CTL__POR,
	[TAIKO_A_CDC_COMP2_B5_CTL] = TAIKO_A_CDC_COMP2_B5_CTL__POR,
	[TAIKO_A_CDC_COMP0_B6_CTL] = TAIKO_A_CDC_COMP0_B6_CTL__POR,
	[TAIKO_A_CDC_COMP1_B6_CTL] = TAIKO_A_CDC_COMP1_B6_CTL__POR,
	[TAIKO_A_CDC_COMP2_B6_CTL] = TAIKO_A_CDC_COMP2_B6_CTL__POR,
	[TAIKO_A_CDC_COMP0_SHUT_DOWN_STATUS] =
	    TAIKO_A_CDC_COMP0_SHUT_DOWN_STATUS__POR,
	[TAIKO_A_CDC_COMP1_SHUT_DOWN_STATUS] =
	    TAIKO_A_CDC_COMP1_SHUT_DOWN_STATUS__POR,
	[TAIKO_A_CDC_COMP2_SHUT_DOWN_STATUS] =
	    TAIKO_A_CDC_COMP2_SHUT_DOWN_STATUS__POR,
	[TAIKO_A_CDC_COMP0_FS_CFG] = TAIKO_A_CDC_COMP0_FS_CFG__POR,
	[TAIKO_A_CDC_COMP1_FS_CFG] = TAIKO_A_CDC_COMP1_FS_CFG__POR,
	[TAIKO_A_CDC_COMP2_FS_CFG] = TAIKO_A_CDC_COMP2_FS_CFG__POR,
	[TAIKO_A_CDC_CONN_RX1_B1_CTL] = TAIKO_A_CDC_CONN_RX1_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX1_B2_CTL] = TAIKO_A_CDC_CONN_RX1_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_RX1_B3_CTL] = TAIKO_A_CDC_CONN_RX1_B3_CTL__POR,
	[TAIKO_A_CDC_CONN_RX2_B1_CTL] = TAIKO_A_CDC_CONN_RX2_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX2_B2_CTL] = TAIKO_A_CDC_CONN_RX2_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_RX2_B3_CTL] = TAIKO_A_CDC_CONN_RX2_B3_CTL__POR,
	[TAIKO_A_CDC_CONN_RX3_B1_CTL] = TAIKO_A_CDC_CONN_RX3_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX3_B2_CTL] = TAIKO_A_CDC_CONN_RX3_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_RX4_B1_CTL] = TAIKO_A_CDC_CONN_RX4_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX4_B2_CTL] = TAIKO_A_CDC_CONN_RX4_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_RX5_B1_CTL] = TAIKO_A_CDC_CONN_RX5_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX5_B2_CTL] = TAIKO_A_CDC_CONN_RX5_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_RX6_B1_CTL] = TAIKO_A_CDC_CONN_RX6_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX6_B2_CTL] = TAIKO_A_CDC_CONN_RX6_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_RX7_B1_CTL] = TAIKO_A_CDC_CONN_RX7_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX7_B2_CTL] = TAIKO_A_CDC_CONN_RX7_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_RX7_B3_CTL] = TAIKO_A_CDC_CONN_RX7_B3_CTL__POR,
	[TAIKO_A_CDC_CONN_ANC_B1_CTL] = TAIKO_A_CDC_CONN_ANC_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_ANC_B2_CTL] = TAIKO_A_CDC_CONN_ANC_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_B1_CTL] = TAIKO_A_CDC_CONN_TX_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_B2_CTL] = TAIKO_A_CDC_CONN_TX_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_B3_CTL] = TAIKO_A_CDC_CONN_TX_B3_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_B4_CTL] = TAIKO_A_CDC_CONN_TX_B4_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ1_B1_CTL] = TAIKO_A_CDC_CONN_EQ1_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ1_B2_CTL] = TAIKO_A_CDC_CONN_EQ1_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ1_B3_CTL] = TAIKO_A_CDC_CONN_EQ1_B3_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ1_B4_CTL] = TAIKO_A_CDC_CONN_EQ1_B4_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ2_B1_CTL] = TAIKO_A_CDC_CONN_EQ2_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ2_B2_CTL] = TAIKO_A_CDC_CONN_EQ2_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ2_B3_CTL] = TAIKO_A_CDC_CONN_EQ2_B3_CTL__POR,
	[TAIKO_A_CDC_CONN_EQ2_B4_CTL] = TAIKO_A_CDC_CONN_EQ2_B4_CTL__POR,
	[TAIKO_A_CDC_CONN_SRC1_B1_CTL] = TAIKO_A_CDC_CONN_SRC1_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_SRC1_B2_CTL] = TAIKO_A_CDC_CONN_SRC1_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_SRC2_B1_CTL] = TAIKO_A_CDC_CONN_SRC2_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_SRC2_B2_CTL] = TAIKO_A_CDC_CONN_SRC2_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B1_CTL] = TAIKO_A_CDC_CONN_TX_SB_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B2_CTL] = TAIKO_A_CDC_CONN_TX_SB_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B3_CTL] = TAIKO_A_CDC_CONN_TX_SB_B3_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B4_CTL] = TAIKO_A_CDC_CONN_TX_SB_B4_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B5_CTL] = TAIKO_A_CDC_CONN_TX_SB_B5_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B6_CTL] = TAIKO_A_CDC_CONN_TX_SB_B6_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B7_CTL] = TAIKO_A_CDC_CONN_TX_SB_B7_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B8_CTL] = TAIKO_A_CDC_CONN_TX_SB_B8_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B9_CTL] = TAIKO_A_CDC_CONN_TX_SB_B9_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B10_CTL] = TAIKO_A_CDC_CONN_TX_SB_B10_CTL__POR,
	[TAIKO_A_CDC_CONN_TX_SB_B11_CTL] = TAIKO_A_CDC_CONN_TX_SB_B11_CTL__POR,
	[TAIKO_A_CDC_CONN_RX_SB_B1_CTL] = TAIKO_A_CDC_CONN_RX_SB_B1_CTL__POR,
	[TAIKO_A_CDC_CONN_RX_SB_B2_CTL] = TAIKO_A_CDC_CONN_RX_SB_B2_CTL__POR,
	[TAIKO_A_CDC_CONN_CLSH_CTL] = TAIKO_A_CDC_CONN_CLSH_CTL__POR,
	[TAIKO_A_CDC_CONN_MISC] = TAIKO_A_CDC_CONN_MISC__POR,
	[TAIKO_A_CDC_CONN_MAD] = TAIKO_A_CDC_CONN_MAD__POR,
	[TAIKO_A_CDC_MBHC_EN_CTL] = TAIKO_A_CDC_MBHC_EN_CTL__POR,
	[TAIKO_A_CDC_MBHC_FIR_B1_CFG] = TAIKO_A_CDC_MBHC_FIR_B1_CFG__POR,
	[TAIKO_A_CDC_MBHC_FIR_B2_CFG] = TAIKO_A_CDC_MBHC_FIR_B2_CFG__POR,
	[TAIKO_A_CDC_MBHC_TIMER_B1_CTL] = TAIKO_A_CDC_MBHC_TIMER_B1_CTL__POR,
	[TAIKO_A_CDC_MBHC_TIMER_B2_CTL] = TAIKO_A_CDC_MBHC_TIMER_B2_CTL__POR,
	[TAIKO_A_CDC_MBHC_TIMER_B3_CTL] = TAIKO_A_CDC_MBHC_TIMER_B3_CTL__POR,
	[TAIKO_A_CDC_MBHC_TIMER_B4_CTL] = TAIKO_A_CDC_MBHC_TIMER_B4_CTL__POR,
	[TAIKO_A_CDC_MBHC_TIMER_B5_CTL] = TAIKO_A_CDC_MBHC_TIMER_B5_CTL__POR,
	[TAIKO_A_CDC_MBHC_TIMER_B6_CTL] = TAIKO_A_CDC_MBHC_TIMER_B6_CTL__POR,
	[TAIKO_A_CDC_MBHC_B1_STATUS] = TAIKO_A_CDC_MBHC_B1_STATUS__POR,
	[TAIKO_A_CDC_MBHC_B2_STATUS] = TAIKO_A_CDC_MBHC_B2_STATUS__POR,
	[TAIKO_A_CDC_MBHC_B3_STATUS] = TAIKO_A_CDC_MBHC_B3_STATUS__POR,
	[TAIKO_A_CDC_MBHC_B4_STATUS] = TAIKO_A_CDC_MBHC_B4_STATUS__POR,
	[TAIKO_A_CDC_MBHC_B5_STATUS] = TAIKO_A_CDC_MBHC_B5_STATUS__POR,
	[TAIKO_A_CDC_MBHC_B1_CTL] = TAIKO_A_CDC_MBHC_B1_CTL__POR,
	[TAIKO_A_CDC_MBHC_B2_CTL] = TAIKO_A_CDC_MBHC_B2_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B1_CTL] = TAIKO_A_CDC_MBHC_VOLT_B1_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B2_CTL] = TAIKO_A_CDC_MBHC_VOLT_B2_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B3_CTL] = TAIKO_A_CDC_MBHC_VOLT_B3_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B4_CTL] = TAIKO_A_CDC_MBHC_VOLT_B4_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B5_CTL] = TAIKO_A_CDC_MBHC_VOLT_B5_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B6_CTL] = TAIKO_A_CDC_MBHC_VOLT_B6_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B7_CTL] = TAIKO_A_CDC_MBHC_VOLT_B7_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B8_CTL] = TAIKO_A_CDC_MBHC_VOLT_B8_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B9_CTL] = TAIKO_A_CDC_MBHC_VOLT_B9_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B10_CTL] = TAIKO_A_CDC_MBHC_VOLT_B10_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B11_CTL] = TAIKO_A_CDC_MBHC_VOLT_B11_CTL__POR,
	[TAIKO_A_CDC_MBHC_VOLT_B12_CTL] = TAIKO_A_CDC_MBHC_VOLT_B12_CTL__POR,
	[TAIKO_A_CDC_MBHC_CLK_CTL] = TAIKO_A_CDC_MBHC_CLK_CTL__POR,
	[TAIKO_A_CDC_MBHC_INT_CTL] = TAIKO_A_CDC_MBHC_INT_CTL__POR,
	[TAIKO_A_CDC_MBHC_DEBUG_CTL] = TAIKO_A_CDC_MBHC_DEBUG_CTL__POR,
	[TAIKO_A_CDC_MBHC_SPARE] = TAIKO_A_CDC_MBHC_SPARE__POR,
	[TAIKO_A_CDC_MAD_MAIN_CTL_1] = TAIKO_A_CDC_MAD_MAIN_CTL_1__POR,
	[TAIKO_A_CDC_MAD_MAIN_CTL_2] = TAIKO_A_CDC_MAD_MAIN_CTL_2__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_1] = TAIKO_A_CDC_MAD_AUDIO_CTL_1__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_2] = TAIKO_A_CDC_MAD_AUDIO_CTL_2__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_3] = TAIKO_A_CDC_MAD_AUDIO_CTL_3__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_4] = TAIKO_A_CDC_MAD_AUDIO_CTL_4__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_5] = TAIKO_A_CDC_MAD_AUDIO_CTL_5__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_6] = TAIKO_A_CDC_MAD_AUDIO_CTL_6__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_7] = TAIKO_A_CDC_MAD_AUDIO_CTL_7__POR,
	[TAIKO_A_CDC_MAD_AUDIO_CTL_8] = TAIKO_A_CDC_MAD_AUDIO_CTL_8__POR,
	[TAIKO_A_CDC_MAD_AUDIO_IIR_CTL_PTR] =
	    TAIKO_A_CDC_MAD_AUDIO_IIR_CTL_PTR__POR,
	[TAIKO_A_CDC_MAD_AUDIO_IIR_CTL_VAL] =
	    TAIKO_A_CDC_MAD_AUDIO_IIR_CTL_VAL__POR,
	[TAIKO_A_CDC_MAD_ULTR_CTL_1] = TAIKO_A_CDC_MAD_ULTR_CTL_1__POR,
	[TAIKO_A_CDC_MAD_ULTR_CTL_2] = TAIKO_A_CDC_MAD_ULTR_CTL_2__POR,
	[TAIKO_A_CDC_MAD_ULTR_CTL_3] = TAIKO_A_CDC_MAD_ULTR_CTL_3__POR,
	[TAIKO_A_CDC_MAD_ULTR_CTL_4] = TAIKO_A_CDC_MAD_ULTR_CTL_4__POR,
	[TAIKO_A_CDC_MAD_ULTR_CTL_5] = TAIKO_A_CDC_MAD_ULTR_CTL_5__POR,
	[TAIKO_A_CDC_MAD_ULTR_CTL_6] = TAIKO_A_CDC_MAD_ULTR_CTL_6__POR,
	[TAIKO_A_CDC_MAD_ULTR_CTL_7] = TAIKO_A_CDC_MAD_ULTR_CTL_7__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_1] = TAIKO_A_CDC_MAD_BEACON_CTL_1__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_2] = TAIKO_A_CDC_MAD_BEACON_CTL_2__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_3] = TAIKO_A_CDC_MAD_BEACON_CTL_3__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_4] = TAIKO_A_CDC_MAD_BEACON_CTL_4__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_5] = TAIKO_A_CDC_MAD_BEACON_CTL_5__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_6] = TAIKO_A_CDC_MAD_BEACON_CTL_6__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_7] = TAIKO_A_CDC_MAD_BEACON_CTL_7__POR,
	[TAIKO_A_CDC_MAD_BEACON_CTL_8] = TAIKO_A_CDC_MAD_BEACON_CTL_8__POR,
	[TAIKO_A_CDC_MAD_BEACON_IIR_CTL_PTR] =
	    TAIKO_A_CDC_MAD_BEACON_IIR_CTL_PTR__POR,
	[TAIKO_A_CDC_MAD_BEACON_IIR_CTL_VAL] =
	    TAIKO_A_CDC_MAD_BEACON_IIR_CTL_VAL__POR,
};
