/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;

public class Grib2Tables {
    private static Logger log = LoggerFactory.getLogger(Grib2Tables.class);

    public static String getProductDefinitionName(int productDefinition) {
        switch (productDefinition) {
            case 0: {
                return "Analysis/forecast at horizontal level/layer";
            }
            case 1: {
                return "Individual ensemble forecast at a point in time";
            }
            case 2: {
                return "Derived forecast on all ensemble members";
            }
            case 3: {
                return "Derived forecasts on cluster of ensemble members over rectangular area";
            }
            case 4: {
                return "Derived forecasts on cluster of ensemble members over circular area";
            }
            case 5: {
                return "Probability forecasts at a horizontal level";
            }
            case 6: {
                return "Percentile forecasts at a horizontal level";
            }
            case 7: {
                return "Analysis or forecast error at a horizontal level";
            }
            case 8: {
                return "Average, accumulation, extreme values or other statistically processed value at a horizontal level";
            }
            case 9: {
                return "Probability forecasts at a horizontal level or in a horizontal layer in a continuous or non-continuous time interval";
            }
            case 10: {
                return "Percentile forecasts at a horizontal level or in a horizontal layer in a continuous or non-continuous time interval";
            }
            case 11: {
                return "Individual ensemble forecast";
            }
            case 12: {
                return "Derived forecast on all ensemble members in a continuous or non-continuous time interval";
            }
            case 13: {
                return "Derived forecasts on cluster of ensemble members over rectangular area in a continuous or non-continuous time interval";
            }
            case 14: {
                return "Derived forecasts on cluster of ensemble members over circular area in a continuous or non-continuous time interval";
            }
            case 15: {
                return "Average, accumulation, extreme values or other statistically-processed values over a spatial area at a horizontal level or in a horizontal layer at a point in time.";
            }
            case 20: {
                return "Radar product";
            }
            case 30: {
                return "Satellite product";
            }
            case 31: {
                return "Satellite product";
            }
            case 40: {
                return "Analysis or forecast at a horizontal level or in a horizontal layer at a point in time for atmospheric chemical constituents.";
            }
            case 41: {
                return "Individual ensemble forecast, control and perturbed, at a horizontal level or in a horizontal layer at a point in time for atmospheric chemical constituents.";
            }
            case 42: {
                return "Average, accumulation, and/or extreme values or other statistically processed values at a horizontal level or in a horizontal layer in a continuous or non-continuous time interval for atmospheric chemical constituents";
            }
            case 43: {
                return "Individual ensemble forecast, control and perturbed, at a horizontal level or in a horizontal layer, in a continuous or non-continuous time interval for atmospheric chemical constituents.";
            }
            case 254: {
                return "CCITTIA5 character string";
            }
        }
        return "Unknown";
    }

    public static final String getTypeGenProcessName(String typeGenProcess) {
        int tgp = typeGenProcess.startsWith("4") ? 4 : Integer.parseInt(typeGenProcess);
        return Grib2Tables.getTypeGenProcessName(tgp);
    }

    public static final String getTypeGenProcessName(int typeGenProcess) {
        switch (typeGenProcess) {
            case 0: {
                return "Analysis";
            }
            case 1: {
                return "Initialization";
            }
            case 2: {
                return "Forecast";
            }
            case 3: {
                return "Bias Corrected Forecast";
            }
            case 4: {
                return "Ensemble Forecast";
            }
            case 5: {
                return "Probability Forecast";
            }
            case 6: {
                return "Forecast Error";
            }
            case 7: {
                return "Analysis Error";
            }
            case 8: {
                return "Observation";
            }
            case 9: {
                return "Climatological";
            }
            case 10: {
                return "Probability-Weighted Forecast";
            }
            case 192: {
                return "Forecast Confidence Indicator";
            }
            case 193: {
                return "Bias Corrected Ensemble Forecast";
            }
            case 255: {
                return "Missing";
            }
        }
        if (typeGenProcess > 3999 && typeGenProcess < 4400) {
            return "Ensemble Forecast";
        }
        return "Unknown";
    }

    public static String getTimeRangeUnitName(int timeRangeUnit) {
        switch (timeRangeUnit) {
            case 0: {
                return "minutes";
            }
            case 1: {
                return "hours";
            }
            case 2: {
                return "days";
            }
            case 3: {
                return "months";
            }
            case 4: {
                return "years";
            }
            case 5: {
                return "decade";
            }
            case 6: {
                return "normal";
            }
            case 7: {
                return "century";
            }
            case 10: {
                return "hours";
            }
            case 11: {
                return "hours";
            }
            case 12: {
                return "hours";
            }
            case 13: {
                return "seconds";
            }
        }
        return "minutes";
    }

    public static String getTypeSurfaceName(int id) {
        switch (id) {
            case 0: {
                return "";
            }
            case 1: {
                return "Ground or water surface";
            }
            case 2: {
                return "Cloud base level";
            }
            case 3: {
                return "Level of cloud tops";
            }
            case 4: {
                return "Level of 0o C isotherm";
            }
            case 5: {
                return "Level of adiabatic condensation lifted from the surface";
            }
            case 6: {
                return "Maximum wind level";
            }
            case 7: {
                return "Tropopause";
            }
            case 8: {
                return "Nominal top of the atmosphere";
            }
            case 9: {
                return "Sea bottom";
            }
            case 10: {
                return "Entire Atmosphere";
            }
            case 11: {
                return "Cumulonimbus Base";
            }
            case 12: {
                return "Cumulonimbus Top";
            }
            case 20: {
                return "Isothermal level";
            }
            case 100: {
                return "Isobaric surface";
            }
            case 101: {
                return "Mean sea level";
            }
            case 102: {
                return "Specific altitude above mean sea level";
            }
            case 103: {
                return "Specified height level above ground";
            }
            case 104: {
                return "Sigma level";
            }
            case 105: {
                return "Hybrid level";
            }
            case 106: {
                return "Depth below land surface";
            }
            case 107: {
                return "Isentropic 'theta' level";
            }
            case 108: {
                return "Level at specified pressure difference from ground to level";
            }
            case 109: {
                return "Potential vorticity surface";
            }
            case 111: {
                return "Eta level";
            }
            case 117: {
                return "Mixed layer depth";
            }
            case 160: {
                return "Depth below sea level";
            }
            case 200: {
                return "Entire atmosphere layer";
            }
            case 201: {
                return "Entire ocean layer";
            }
            case 204: {
                return "Highest tropospheric freezing level";
            }
            case 206: {
                return "Grid scale cloud bottom level";
            }
            case 207: {
                return "Grid scale cloud top level";
            }
            case 209: {
                return "Boundary layer cloud bottom level";
            }
            case 210: {
                return "Boundary layer cloud top level";
            }
            case 211: {
                return "Boundary layer cloud layer";
            }
            case 212: {
                return "Low cloud bottom level";
            }
            case 213: {
                return "Low cloud top level";
            }
            case 214: {
                return "Low cloud layer";
            }
            case 215: {
                return "Cloud ceiling";
            }
            case 220: {
                return "Planetary Boundary Layer";
            }
            case 221: {
                return "Layer Between Two Hybrid Levels";
            }
            case 222: {
                return "Middle cloud bottom level";
            }
            case 223: {
                return "Middle cloud top level";
            }
            case 224: {
                return "Middle cloud layer";
            }
            case 232: {
                return "High cloud bottom level";
            }
            case 233: {
                return "High cloud top level";
            }
            case 234: {
                return "High cloud layer";
            }
            case 235: {
                return "Ocean isotherm level";
            }
            case 236: {
                return "Layer between two depths below ocean surface";
            }
            case 237: {
                return "Bottom of ocean mixed layer";
            }
            case 238: {
                return "Bottom of ocean isothermal layer";
            }
            case 239: {
                return "Layer Ocean Surface and 26C Ocean Isothermal Level";
            }
            case 240: {
                return "Ocean Mixed Layer";
            }
            case 241: {
                return "Ordered Sequence of Data";
            }
            case 242: {
                return "Convective cloud bottom level";
            }
            case 243: {
                return "Convective cloud top level";
            }
            case 244: {
                return "Convective cloud layer";
            }
            case 245: {
                return "Lowest level of the wet bulb zero";
            }
            case 246: {
                return "Maximum equivalent potential temperature level";
            }
            case 247: {
                return "Equilibrium level";
            }
            case 248: {
                return "Shallow convective cloud bottom level";
            }
            case 249: {
                return "Shallow convective cloud top level";
            }
            case 251: {
                return "Deep convective cloud bottom level";
            }
            case 252: {
                return "Deep convective cloud top level";
            }
            case 253: {
                return "Lowest bottom level of supercooled liquid water layer";
            }
            case 254: {
                return "Highest top level of supercooled liquid water layer";
            }
            case 255: {
                return "Missing";
            }
        }
        return "Unknown=" + id;
    }

    public static String getTypeSurfaceNameShort(int id) {
        switch (id) {
            case 0: {
                return "";
            }
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 10: {
                return "entire_atmosphere";
            }
            case 11: {
                return "cumulonimbus_base";
            }
            case 12: {
                return "cumulonimbus_top";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "pressure";
            }
            case 101: {
                return "msl";
            }
            case 102: {
                return "altitude_above_msl";
            }
            case 103: {
                return "height_above_ground";
            }
            case 104: {
                return "sigma";
            }
            case 105: {
                return "hybrid";
            }
            case 106: {
                return "depth_below_surface";
            }
            case 107: {
                return "isentrope";
            }
            case 108: {
                return "pressure_difference";
            }
            case 109: {
                return "potential_vorticity_surface";
            }
            case 111: {
                return "eta";
            }
            case 117: {
                return "mixed_layer_depth";
            }
            case 160: {
                return "depth_below_sea";
            }
            case 200: {
                return "entire_atmosphere";
            }
            case 201: {
                return "entire_ocean";
            }
            case 204: {
                return "highest_tropospheric_freezing";
            }
            case 206: {
                return "grid_scale_cloud_bottom";
            }
            case 207: {
                return "grid_scale_cloud_top";
            }
            case 209: {
                return "boundary_layer_cloud_bottom";
            }
            case 210: {
                return "boundary_layer_cloud_top";
            }
            case 211: {
                return "boundary_layer_cloud";
            }
            case 212: {
                return "low_cloud_bottom";
            }
            case 213: {
                return "low_cloud_top";
            }
            case 214: {
                return "low_cloud";
            }
            case 215: {
                return "cloud_ceiling";
            }
            case 220: {
                return "planetary_boundary";
            }
            case 221: {
                return "between_two_hybrids";
            }
            case 222: {
                return "middle_cloud_bottom";
            }
            case 223: {
                return "middle_cloud_top";
            }
            case 224: {
                return "middle_cloud";
            }
            case 232: {
                return "high_cloud_bottom";
            }
            case 233: {
                return "high_cloud_top";
            }
            case 234: {
                return "high_cloud";
            }
            case 235: {
                return "ocean_isotherm";
            }
            case 236: {
                return "layer_between_two_depths_below_ocean";
            }
            case 237: {
                return "bottom_of_ocean_mixed";
            }
            case 238: {
                return "bottom_of_ocean_isothermal";
            }
            case 239: {
                return "ocean_surface_and_26C_isothermal";
            }
            case 240: {
                return "ocean_mixed";
            }
            case 241: {
                return "ordered_sequence_of_data";
            }
            case 242: {
                return "convective_cloud_bottom";
            }
            case 243: {
                return "convective_cloud_top";
            }
            case 244: {
                return "convective_cloud";
            }
            case 245: {
                return "lowest_level_of_the_wet_bulb_zero";
            }
            case 246: {
                return "maximum_equivalent_potential_temperature";
            }
            case 247: {
                return "equilibrium";
            }
            case 248: {
                return "shallow_convective_cloud_bottom";
            }
            case 249: {
                return "shallow_convective_cloud_top";
            }
            case 251: {
                return "deep_convective_cloud_bottom";
            }
            case 252: {
                return "deep_convective_cloud_top";
            }
            case 253: {
                return "lowest_level_water_layer";
            }
            case 254: {
                return "highest_level_water_layer";
            }
            case 255: {
                return "missing";
            }
        }
        return "Unknown" + id;
    }

    public static String getTypeSurfaceUnit(int id) {
        switch (id) {
            case 11: 
            case 12: {
                return "m";
            }
            case 20: {
                return "K";
            }
            case 100: {
                return "Pa";
            }
            case 102: {
                return "m";
            }
            case 103: {
                return "m";
            }
            case 106: {
                return "m";
            }
            case 107: {
                return "K";
            }
            case 108: {
                return "Pa";
            }
            case 109: {
                return "K m2 kg-1 s-1";
            }
            case 117: {
                return "m";
            }
            case 160: {
                return "m";
            }
            case 235: {
                return "C 0.1";
            }
            case 237: {
                return "m";
            }
            case 238: {
                return "m";
            }
        }
        return "";
    }

    public static String makeSuffix(GribGridRecord ggr) {
        String interval = "";
        if (ggr.productType > 8 && ggr.productType < 15) {
            int span = ggr.forecastTime - ggr.startOfInterval;
            interval = Integer.toString(span) + Grib2Tables.getTimeRangeUnitName(ggr.timeUnit);
        }
        switch (ggr.productType) {
            case 0: 
            case 7: 
            case 40: {
                if (ggr.typeGenProcess != 6 && ggr.typeGenProcess != 7) break;
                return "error";
            }
            case 1: 
            case 11: 
            case 41: 
            case 43: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (ggr.typeGenProcess != 4) break;
                if (ggr.type == 0) {
                    return "unweightedMean";
                }
                if (ggr.type == 1) {
                    return "weightedMean";
                }
                if (ggr.type == 2) {
                    return "stdDev";
                }
                if (ggr.type == 3) {
                    return "stdDevNor";
                }
                if (ggr.type == 4) {
                    return "spread";
                }
                if (ggr.type == 5) {
                    return "anomaly";
                }
                if (ggr.type == 6) {
                    return "unweightedMeanCluster";
                }
                return "unknownEnsemble";
            }
            case 12: 
            case 13: 
            case 14: {
                if (ggr.typeGenProcess != 4) break;
                interval = interval + "_";
                if (ggr.type == 0) {
                    return interval + "unweightedMean";
                }
                if (ggr.type == 1) {
                    return interval + "weightedMean";
                }
                if (ggr.type == 2) {
                    return interval + "stdDev";
                }
                if (ggr.type == 3) {
                    return interval + "stdDevNor";
                }
                if (ggr.type == 4) {
                    return interval + "spread";
                }
                if (ggr.type == 5) {
                    return interval + "anomaly";
                }
                if (ggr.type == 6) {
                    return interval + "unweightedMeanCluster";
                }
                return interval + "unknownEnsemble";
            }
            case 5: {
                if (ggr.typeGenProcess != 5) break;
                return Grib2Tables.getProbabilityVariableNameSuffix(ggr.lowerLimit, ggr.upperLimit, ggr.type);
            }
            case 9: {
                if (ggr.typeGenProcess != 5) break;
                return interval + "_" + Grib2Tables.getProbabilityVariableNameSuffix(ggr.lowerLimit, ggr.upperLimit, ggr.type);
            }
            default: {
                return interval;
            }
        }
        return interval;
    }

    static String getProbabilityVariableNameSuffix(float lowerLimit, float upperLimit, int type) {
        String ll = Float.toString(lowerLimit).replace('.', 'p').replaceFirst("p0$", "");
        String ul = Float.toString(upperLimit).replace('.', 'p').replaceFirst("p0$", "");
        if (type == 0) {
            return "probability_below_" + ll;
        }
        if (type == 1) {
            return "probability_above_" + ul;
        }
        if (type == 2) {
            return "probability_between_" + ll + "_" + ul;
        }
        if (type == 3) {
            return "probability_above_" + ll;
        }
        if (type == 4) {
            return "probability_below_" + ul;
        }
        return "unknownProbability";
    }

    public static String getEnsembleType(int productType, int type) {
        switch (productType) {
            case 1: 
            case 11: 
            case 41: 
            case 43: {
                if (type == 0) {
                    return "Cntrl_high";
                }
                if (type == 1) {
                    return "Cntrl_low";
                }
                if (type == 2) {
                    return "Perturb_neg";
                }
                if (type == 3) {
                    return "Perturb_pos";
                }
                return "unknownEnsemble";
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                if (type == 0) {
                    return "unweightedMean";
                }
                if (type == 1) {
                    return "weightedMean";
                }
                if (type == 2) {
                    return "stdDev";
                }
                if (type == 3) {
                    return "stdDevNor";
                }
                if (type == 4) {
                    return "spread";
                }
                if (type == 5) {
                    return "anomaly";
                }
                if (type == 6) {
                    return "unweightedMeanCluster";
                }
                return "unknownEnsemble";
            }
        }
        return "";
    }

    public static String getGridName(int gdtn) {
        switch (gdtn) {
            case 0: {
                return "Latitude_Longitude";
            }
            case 1: {
                return "Rotated_Latitude_Longitude";
            }
            case 2: {
                return "Stretched_Latitude_Longitude";
            }
            case 3: {
                return "Rotated_and_Stretched_Latitude_Longitude";
            }
            case 10: {
                return "Mercator";
            }
            case 20: {
                return "Polar_Stereographic";
            }
            case 30: {
                return "Lambert_Conformal";
            }
            case 31: {
                return "Albers_Equal_Area";
            }
            case 40: {
                return "Gaussian_Latitude_Longitude";
            }
            case 41: {
                return "Rotated_Gaussian_Latitude_Longitude";
            }
            case 42: {
                return "Stretched_Gaussian Latitude_Longitude";
            }
            case 43: {
                return "Rotated_and_Stretched_Gaussian_Latitude_Longitude";
            }
            case 50: {
                return "Spherical_Harmonic_Coefficients";
            }
            case 51: {
                return "Rotated_Spherical_Harmonic_Coefficients";
            }
            case 52: {
                return "Stretched_Spherical_Harmonic_Coefficients";
            }
            case 53: {
                return "Rotated_and_Stretched_Spherical_Harmonic_Coefficients";
            }
            case 90: {
                return "Space_View_Perspective_or_Orthographic";
            }
            case 100: {
                return "Triangular_Grid_Based_on_an_Icosahedron";
            }
            case 110: {
                return "Equatorial_Azimuthal_Equidistant";
            }
            case 120: {
                return "Azimuth_Range";
            }
            case 204: {
                return "Curvilinear_Orthogonal";
            }
            case 1000: {
                return "Cross_Section_Grid_with_Points_Equally_Spaced_on_the_Horizontal";
            }
            case 1100: {
                return "Hovmoller_Diagram_with_Points_Equally_Spaced_on_the_Horizontal";
            }
            case 1200: {
                return "Time_Section_Grid";
            }
            case 32768: {
                return "Rotated_Latitude_Longitude_Arakawa_Staggered_E_Grid";
            }
        }
        return "Unknown projection" + gdtn;
    }

    public static final int getProjectionType(int gridType) {
        switch (gridType) {
            case 1: {
                return 10;
            }
            case 10: {
                return 3;
            }
            case 20: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 5;
            }
            case 40: {
                return 8;
            }
            case 90: {
                return 7;
            }
            case 204: {
                return 100;
            }
        }
        return -1;
    }

    public static String getShapeName(int shape) {
        switch (shape) {
            case 0: {
                return "Earth spherical with radius = 6,367,470 m";
            }
            case 1: {
                return "Earth spherical with radius specified by producer in m";
            }
            case 2: {
                return "Earth oblate spheroid with major axis = 6,378,160 m and minor axis = 6,356,775 m";
            }
            case 3: {
                return "Earth oblate spheroid with axes specified by producer in m";
            }
            case 4: {
                return "Earth oblate spheroid with major axis = 6,378,137.0 m and minor axis = 6,356,752.314 m";
            }
            case 5: {
                return "Earth represent by WGS84";
            }
            case 6: {
                return "Earth spherical with radius of 6,371,229.0 m";
            }
            case 7: {
                return "Earth oblate spheroid with axes specified by producer in m";
            }
            case 8: {
                return "Earth spherical with radius of 6,371,200.0 m, represent by WGS84";
            }
        }
        return "Unknown Earth Shape";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VectorComponentFlag {
        easterlyNortherlyRelative,
        gridRelative;

    }
}

