#
# Find the OTF2 library
#
# OTF2_INCLUDE_PATH  - Directories to include to use OTF2
# OTF2_LIBRARY_PATH  - Files to link against to use OTF2
# OTF2_CONFIG        - Path to otf2-config


find_program(OTF2_CONFIG otf2-config REQUIRED)
find_program(OTF2_PRINT otf2-print REQUIRED)

IF(NOT OTF2_CONFIG OR NOT EXISTS ${OTF2_CONFIG})
  MESSAGE(STATUS "Cannot find otf2-config")
  SET(OTF2_VERSION ${OTF2_REQUIRED_VERSION})
ELSE()
  message(STATUS "OTF2 installation found. (using ${OTF2_CONFIG})")

  execute_process(COMMAND ${OTF2_CONFIG} "--cppflags" OUTPUT_VARIABLE OTF2_INCLUDE_PATH)
  STRING(REPLACE "\n" "" OTF2_INCLUDE_PATH ${OTF2_INCLUDE_PATH})
  STRING(REPLACE "-I" "" OTF2_INCLUDE_PATH ${OTF2_INCLUDE_PATH})
  
  execute_process(COMMAND ${OTF2_CONFIG} "--ldflags" OUTPUT_VARIABLE _LINK_LD_ARGS)
  STRING( REPLACE " " ";" _LINK_LD_ARGS ${_LINK_LD_ARGS} )
  FOREACH( _ARG ${_LINK_LD_ARGS} )
    IF(${_ARG} MATCHES "^-L")
      STRING(REGEX REPLACE "^-L" "" _ARG ${_ARG})
      STRING(STRIP "${_ARG}" _ARG)
      SET(OTF2_LINK_DIRS ${OTF2_LINK_DIRS} ${_ARG})
    ENDIF(${_ARG} MATCHES "^-L")
  ENDFOREACH(_ARG)

  execute_process(COMMAND ${OTF2_CONFIG} "--libs" OUTPUT_VARIABLE _LINK_LD_ARGS)
  STRING( REPLACE " " ";" _LINK_LD_ARGS ${_LINK_LD_ARGS} )
  FOREACH( _ARG ${_LINK_LD_ARGS} )
    IF(${_ARG} MATCHES "^-l")
      STRING(REGEX REPLACE "^-l" "" _ARG "${_ARG}")
      STRING(STRIP "${_ARG}" _ARG)
      FIND_LIBRARY(_OTF2_LIB_FROM_ARG NAMES ${_ARG}
        HINTS ${OTF2_LINK_DIRS} NO_DEFAULT_PATH
      )
      IF(${_ARG} STREQUAL "otf2" OR ${_ARG} STREQUAL "open-trace-format2")
        SET(OTF2_LIBRARY ${_OTF2_LIB_FROM_ARG})
      ELSE()
        IF(_OTF2_LIB_FROM_ARG)
          LIST(APPEND OTF2_LIBRARIES ${_OTF2_LIB_FROM_ARG})
        ENDIF(_OTF2_LIB_FROM_ARG)
      ENDIF()
      UNSET(_OTF2_LIB_FROM_ARG CACHE)
    ENDIF(${_ARG} MATCHES "^-l")
  ENDFOREACH(_ARG)


  execute_process(COMMAND ${OTF2_CONFIG} "--version" OUTPUT_VARIABLE OTF2_VERSION)
  STRING( REPLACE "otf2-config: version " "" OTF2_VERSION ${OTF2_VERSION} )
  STRING( REPLACE "\n" "" OTF2_VERSION ${OTF2_VERSION} )
  STRING( REPLACE "." ";" _VERSION ${OTF2_VERSION} )
  LIST( GET _VERSION 0 OTF2_MAJOR_VERSION)
  LIST( GET _VERSION 1 OTF2_MINOR_VERSION)
ENDIF()

include (FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(OTF2
  FOUND_VAR OTF2_FOUND
  REQUIRED_VARS OTF2_CONFIG OTF2_LIBRARY OTF2_INCLUDE_PATH
  VERSION_VAR OTF2_VERSION
)

if(NOT OTF2_FOUND)
    unset(OTF2_CONFIG)
    unset(OTF2_CONFIG CACHE)
    unset(OTF2_LINK_DIRS)
    unset(OTF2_LIBRARIES)
endif()

mark_as_advanced(OTF2_LIBRARY)
