/***************************************************************************
 *   Copyright (C) 2008 by Hanna K.                                        *
 *   hanna_k@fmgirl.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef EQONOMIZE_MONTH_SELECTOR_H
#define EQONOMIZE_MONTH_SELECTOR_H

#include <qwidget.h>
#include <qdatetime.h>

class QSpinBox;
class QComboBox;

class EqonomizeMonthSelector : public QWidget {

	Q_OBJECT

	public:

		EqonomizeMonthSelector(QWidget *parent);
		~EqonomizeMonthSelector();
		
		QDate date() const;

	protected:

		QComboBox *monthCombo;
		QSpinBox *yearEdit;

		QDate d_date;

		void updateMonths();

	public slots:

		void setDate(const QDate&);
		void focusMonth();
		void focusYear();

	protected slots:
		
		void onYearChanged(int);
		void onMonthChanged(int);

	signals:

		void dateChanged(const QDate&);
		void yearChanged(const QDate&);
		void monthChanged(const QDate&);

};


#endif
