#
#	Name:             BIG5 to Unicode table (complete)
#	Unicode version:  1.1
#	Table version:    0.0d3
#	Table format:     Format A
#	Date:             11 February 1994
#	Authors:          Glenn Adams <glenn@metis.com>
#                     John H. Jenkins <John_Jenkins@taligent.com>
#
#	Copyright (c) 1991-1994 Unicode, Inc.  All Rights reserved.
#
#	This file is provided as-is by Unicode, Inc. (The Unicode Consortium).
#	No claims are made as to fitness for any particular purpose.  No
#	warranties of any kind are expressed or implied.  The recipient
#	agrees to determine applicability of information provided.  If this
#	file has been provided on magnetic media by Unicode, Inc., the sole
#	remedy for any claim will be exchange of defective media within 90
#	days of receipt.
#
#	Recipient is granted the right to make copies in any form for
#	internal distribution and to freely use the information supplied
#	in the creation of products supporting Unicode.  Unicode, Inc.
#	specifically excludes the right to re-distribute this file directly
#	to third parties or other organizations whether for profit or not.
#
#	General notes:
#
#	This table contains the data Metis and Taligent currently have on how
#       BIG5 characters map into Unicode.
#
#	WARNING!  It is currently impossible to provide round-trip compatibility
#		between BIG5 and Unicode.  
#
#	A number of characters are not currently mapped because
#		of conflicts with other mappings.  They are as follows:
#
#       BIG5        Description                    Comments
#
#       0xA1C3      SPACING HEAVY OVERSCORE        not in Unicode
#       0xA1C5      SPACING HEAVY UNDERSCORE       not in Unicode
#
#	We currently map all of these characters to U+FFFD REPLACEMENT CHARACTER.
#		It is also possible to map these characters to their duplicates, or to
#		the user zone.  
#	
#	Notes:
#
#	1. In addition to the above, there is some uncertainty about the
#       mappings in the range C6A1 - C8FE, and F9DD - F9FE.  The ETEN
#		version of BIG5 organizes the former range differently, and adds
#		additional characters in the latter range.  The correct mappings
#		these ranges need to be determined.
#
#	2.  There is an uncertainty in the mapping of the Big Five character
#		0xA3BC.  This character occurs within the Big Five block of tone marks
#		for bopomofo and is intended to be the tone mark for the first tone in
#		Mandarin Chinese.  We have selected the mapping U+02C9 MODIFIER LETTER
#		MACRON (Mandarin Chinese first tone) to reflect this semantic.  
#		However, because bopomofo uses the absense of a tone mark to indicate
#		the first Mandarin tone, most implementations of Big Five represent
#		this character with a blank space, and so a mapping such as U+2003 EM SPACE
#		might be preferred.  
#		
#			
#
#	Format:  Three tab-separated columns
#		 Column #1 is the BIG5 code (in hex as 0xXXXX)
#		 Column #2 is the Unicode (in hex as 0xXXXX)
#		 Column #3  is the Unicode name (follows a comment sign, '#')
#					The official names for Unicode characters U+4E00
#					to U+9FA5, inclusive, is "CJK UNIFIED IDEOGRAPH-XXXX",
#					where XXXX is the code point.  Including all these
#					names in this file increases its size substantially
#					and needlessly.  The token "<CJK>" is used for the
#					name of these characters.  If necessary, it can be
#					expanded algorithmically by a parser or editor.
#
#	The entries are in BIG5 order
#
#	Any comments or problems, contact <John_Jenkins@taligent.com>
#
#
 0 0000 NULL (NUL)
 1 0001 START OF HEADING (SOH)
 2 0002 START OF TEXT (STX)
 3 0003 END OF TEXT (ETX)
 4 0004 END OF TRANSMISSION (EOT)
 5 0005 ENQUIRY (ENQ)
 6 0006 ACKNOWLEDGE (ACK)
 7 0007 BELL (BEL)
 8 0008 BACKSPACE (BS)
 9 0009 CHARACTER TABULATION (HT)
 A 000a LINE FEED (LF)
 B 000b LINE TABULATION (VT)
 C 000c FORM FEED (FF)
 D 000d CARRIAGE RETURN (CR)
 E 000e SHIFT OUT (SO)
 F 000f SHIFT IN (SI)
10 0010 DATALINK ESCAPE (DLE)
11 0011 DEVICE CONTROL ONE (DC1)
12 0012 DEVICE CONTROL TWO (DC2)
13 0013 DEVICE CONTROL THREE (DC3)
14 0014 DEVICE CONTROL FOUR (DC4)
15 0015 NEGATIVE ACKNOWLEDGE (NAK)
16 0016 SYNCRONOUS IDLE (SYN)
17 0017 END OF TRANSMISSION BLOCK (ETB)
18 0018 CANCEL (CAN)
19 0019 END OF MEDIUM (EM)
1A 001a SUBSTITUTE (SUB)
1B 001b ESCAPE (ESC)
1C 001c FILE SEPARATOR (IS4)
1D 001d GROUP SEPARATOR (IS3)
1E 001e RECORD SEPARATOR (IS2)
1F 001f UNIT SEPARATOR (IS1)
20 0020 SPACE
21 0021 EXCLAMATION MARK
22 0022 QUOTATION MARK
23 0023 NUMBER SIGN
24 0024 DOLLAR SIGN
25 0025 PERCENT SIGN
26 0026 AMPERSAND
27 0027 APOSTROPHE
28 0028 LEFT PARENTHESIS
29 0029 RIGHT PARENTHESIS
2A 002a ASTERISK
2B 002b PLUS SIGN
2C 002c COMMA
2D 002d HYPHEN-MINUS
2E 002e FULL STOP
2F 002f SOLIDUS
30 0030 DIGIT ZERO
31 0031 DIGIT ONE
32 0032 DIGIT TWO
33 0033 DIGIT THREE
34 0034 DIGIT FOUR
35 0035 DIGIT FIVE
36 0036 DIGIT SIX
37 0037 DIGIT SEVEN
38 0038 DIGIT EIGHT
39 0039 DIGIT NINE
3A 003a COLON
3B 003b SEMICOLON
3C 003c LESS-THAN SIGN
3D 003d EQUALS SIGN
3E 003e GREATER-THAN SIGN
3F 003f QUESTION MARK
40 0040 COMMERCIAL AT
41 0041 LATIN CAPITAL LETTER A
42 0042 LATIN CAPITAL LETTER B
43 0043 LATIN CAPITAL LETTER C
44 0044 LATIN CAPITAL LETTER D
45 0045 LATIN CAPITAL LETTER E
46 0046 LATIN CAPITAL LETTER F
47 0047 LATIN CAPITAL LETTER G
48 0048 LATIN CAPITAL LETTER H
49 0049 LATIN CAPITAL LETTER I
4A 004a LATIN CAPITAL LETTER J
4B 004b LATIN CAPITAL LETTER K
4C 004c LATIN CAPITAL LETTER L
4D 004d LATIN CAPITAL LETTER M
4E 004e LATIN CAPITAL LETTER N
4F 004f LATIN CAPITAL LETTER O
50 0050 LATIN CAPITAL LETTER P
51 0051 LATIN CAPITAL LETTER Q
52 0052 LATIN CAPITAL LETTER R
53 0053 LATIN CAPITAL LETTER S
54 0054 LATIN CAPITAL LETTER T
55 0055 LATIN CAPITAL LETTER U
56 0056 LATIN CAPITAL LETTER V
57 0057 LATIN CAPITAL LETTER W
58 0058 LATIN CAPITAL LETTER X
59 0059 LATIN CAPITAL LETTER Y
5A 005a LATIN CAPITAL LETTER Z
5B 005b LEFT SQUARE BRACKET
5C 005c REVERSE SOLIDUS
5D 005d RIGHT SQUARE BRACKET
5E 005e CIRCUMFLEX ACCENT
5F 005f LOW LINE
60 0060 GRAVE ACCENT
61 0061 LATIN SMALL LETTER A
62 0062 LATIN SMALL LETTER B
63 0063 LATIN SMALL LETTER C
64 0064 LATIN SMALL LETTER D
65 0065 LATIN SMALL LETTER E
66 0066 LATIN SMALL LETTER F
67 0067 LATIN SMALL LETTER G
68 0068 LATIN SMALL LETTER H
69 0069 LATIN SMALL LETTER I
6A 006a LATIN SMALL LETTER J
6B 006b LATIN SMALL LETTER K
6C 006c LATIN SMALL LETTER L
6D 006d LATIN SMALL LETTER M
6E 006e LATIN SMALL LETTER N
6F 006f LATIN SMALL LETTER O
70 0070 LATIN SMALL LETTER P
71 0071 LATIN SMALL LETTER Q
72 0072 LATIN SMALL LETTER R
73 0073 LATIN SMALL LETTER S
74 0074 LATIN SMALL LETTER T
75 0075 LATIN SMALL LETTER U
76 0076 LATIN SMALL LETTER V
77 0077 LATIN SMALL LETTER W
78 0078 LATIN SMALL LETTER X
79 0079 LATIN SMALL LETTER Y
7A 007a LATIN SMALL LETTER Z
7B 007b LEFT CURLY BRACKET
7C 007c VERTICAL LINE
7D 007d RIGHT CURLY BRACKET
7E 007e TILDE
7F 007f DELETE (DEL)
A140 3000	# IDEOGRAPHIC SPACE
A141 FF0C	# FULLWIDTH COMMA
A142 3001	# IDEOGRAPHIC COMMA
A143 3002	# IDEOGRAPHIC FULL STOP
A144 FF0E	# FULLWIDTH FULL STOP
A145 2022	# BULLET
A146 FF1B	# FULLWIDTH SEMICOLON
A147 FF1A	# FULLWIDTH COLON
A148 FF1F	# FULLWIDTH QUESTION MARK
A149 FF01	# FULLWIDTH EXCLAMATION MARK
A14A FE30	# PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
A14B 2026	# HORIZONTAL ELLIPSIS
A14C 2025	# TWO DOT LEADER
A14D FE50	# SMALL COMMA
A14E FF64	# HALFWIDTH IDEOGRAPHIC COMMA
A14F FE52	# SMALL FULL STOP
A150 00B7	# MIDDLE DOT
A151 FE54	# SMALL SEMICOLON
A152 FE55	# SMALL COLON
A153 FE56	# SMALL QUESTION MARK
A154 FE57	# SMALL EXCLAMATION MARK
A155 FF5C	# FULLWIDTH VERTICAL BAR
A156 2013	# EN DASH
A157 FE31	# PRESENTATION FORM FOR VERTICAL EM DASH
A158 2014	# EM DASH
A159 FE33	# PRESENTATION FORM FOR VERTICAL LOW LINE
A15A FF3F	# SPACING UNDERSCORE             duplicates A1C4
A15B FE34	# PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
A15C FE4F	# WAVY LOW LINE
A15D FF08	# FULLWIDTH LEFT PARENTHESIS
A15E FF09	# FULLWIDTH RIGHT PARENTHESIS
A15F FE35	# PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
A160 FE36	# PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
A161 FF5B	# FULLWIDTH LEFT CURLY BRACKET
A162 FF5D	# FULLWIDTH RIGHT CURLY BRACKET
A163 FE37	# PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
A164 FE38	# PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
A165 3014	# LEFT TORTOISE SHELL BRACKET
A166 3015	# RIGHT TORTOISE SHELL BRACKET
A167 FE39	# PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
A168 FE3A	# PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
A169 3010	# LEFT BLACK LENTICULAR BRACKET
A16A 3011	# RIGHT BLACK LENTICULAR BRACKET
A16B FE3B	# PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
A16C FE3C	# PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
A16D 300A	# LEFT DOUBLE ANGLE BRACKET
A16E 300B	# RIGHT DOUBLE ANGLE BRACKET
A16F FE3D	# PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
A170 FE3E	# PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
A171 3008	# LEFT ANGLE BRACKET
A172 3009	# RIGHT ANGLE BRACKET
A173 FE3F	# PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
A174 FE40	# PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
A175 300C	# LEFT CORNER BRACKET
A176 300D	# RIGHT CORNER BRACKET
A177 FE41	# PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
A178 FE42	# PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
A179 300E	# LEFT WHITE CORNER BRACKET
A17A 300F	# RIGHT WHITE CORNER BRACKET
A17B FE43	# PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
A17C FE44	# PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
A17D FE59	# SMALL LEFT PARENTHESIS
A17E FE5A	# SMALL RIGHT PARENTHESIS
A1A1 FE5B	# SMALL LEFT CURLY BRACKET
A1A2 FE5C	# SMALL RIGHT CURLY BRACKET
A1A3 FE5D	# SMALL LEFT TORTOISE SHELL BRACKET
A1A4 FE5E	# SMALL RIGHT TORTOISE SHELL BRACKET
A1A5 2018	# LEFT SINGLE QUOTATION MARK
A1A6 2019	# RIGHT SINGLE QUOTATION MARK
A1A7 201C	# LEFT DOUBLE QUOTATION MARK
A1A8 201D	# RIGHT DOUBLE QUOTATION MARK
A1A9 301D	# REVERSED DOUBLE PRIME QUOTATION MARK
A1AA 301E	# DOUBLE PRIME QUOTATION MARK
A1AB 2035	# REVERSED PRIME
A1AC 2032	# PRIME
A1AD FF03	# FULLWIDTH NUMBER SIGN
A1AE FF06	# FULLWIDTH AMPERSAND
A1AF FF0A	# FULLWIDTH ASTERISK
A1B0 203B	# REFERENCE MARK
A1B1 00A7	# SECTION SIGN
A1B2 3003	# DITTO MARK
A1B3 25CB	# WHITE CIRCLE
A1B4 25CF	# BLACK CIRCLE
A1B5 25B3	# WHITE UP-POINTING TRIANGLE
A1B6 25B2	# BLACK UP-POINTING TRIANGLE
A1B7 25CE	# BULLSEYE
A1B8 2606	# WHITE STAR
A1B9 2605	# BLACK STAR
A1BA 25C7	# WHITE DIAMOND
A1BB 25C6	# BLACK DIAMOND
A1BC 25A1	# WHITE SQUARE
A1BD 25A0	# BLACK SQUARE
A1BE 25BD	# WHITE DOWN-POINTING TRIANGLE
A1BF 25BC	# BLACK DOWN-POINTING TRIANGLE
A1C0 32A3	# CIRCLED IDEOGRAPH CORRECT
A1C1 2105	# CARE OF
A1C2 203E	# OVERLINE
A1C3 FFFD	# *** NO MAPPING ***
A1C4 FF3F	# FULLWIDTH LOW LINE
A1C5 FFFD	# *** NO MAPPING ***
A1C6 FE49	# DASHED OVERLINE
A1C7 FE4A	# CENTRELINE OVERLINE
A1C8 FE4D	# DASHED LOW LINE
A1C9 FE4E	# CENTRELINE LOW LINE
A1CA FE4B	# WAVY OVERLINE
A1CB FE4C	# DOUBLE WAVY OVERLINE
A1CC FE5F	# SMALL NUMBER SIGN
A1CD FE60	# SMALL AMPERSAND
A1CE FE61	# SMALL ASTERISK
A1CF FF0B	# FULLWIDTH PLUS SIGN
A1D0 FF0D	# FULLWIDTH HYPHEN-MINUS
A1D1 00D7	# MULTIPLICATION SIGN
A1D2 00F7	# DIVISION SIGN
A1D3 00B1	# PLUS-MINUS SIGN
A1D4 221A	# SQUARE ROOT
A1D5 FF1C	# FULLWIDTH LESS-THAN SIGN
A1D6 FF1E	# FULLWIDTH GREATER-THAN SIGN
A1D7 FF1D	# FULLWIDTH EQUALS SIGN
A1D8 2266	# LESS THAN OVER EQUAL TO
A1D9 2267	# GREATER THAN OVER EQUAL TO
A1DA 2260	# NOT EQUAL TO
A1DB 221E	# INFINITY
A1DC 2252	# APPROXIMATELY EQUAL TO OR THE IMAGE OF
A1DD 2261	# IDENTICAL TO
A1DE FE62	# SMALL PLUS SIGN
A1DF FE63	# SMALL HYPHEN-MINUS
A1E0 FE64	# SMALL LESS-THAN SIGN
A1E1 FE65	# SMALL GREATER-THAN SIGN
A1E2 FE66	# SMALL EQUALS SIGN
A1E3 223C	# TILDE OPERATOR
A1E4 2229	# INTERSECTION
A1E5 222A	# UNION
A1E6 22A5	# UP TACK
A1E7 2220	# ANGLE
A1E8 221F	# RIGHT ANGLE
A1E9 22BF	# RIGHT TRIANGLE
A1EA 33D2	# SQUARE LOG
A1EB 33D1	# SQUARE LN
A1EC 222B	# INTEGRAL
A1ED 222E	# CONTOUR INTEGRAL
A1EE 2235	# BECAUSE
A1EF 2234	# THEREFORE
A1F0 2640	# FEMALE SIGN
A1F1 2642	# MALE SIGN
A1F2 2641	# EARTH
A1F3 2609	# SUN
A1F4 2191	# UPWARDS ARROW
A1F5 2193	# DOWNWARDS ARROW
A1F6 2190	# LEFTWARDS ARROW
A1F7 2192	# RIGHTWARDS ARROW
A1F8 2196	# NORTH WEST ARROW
A1F9 2197	# NORTH EAST ARROW
A1FA 2199	# SOUTH WEST ARROW
A1FB 2198	# SOUTH EAST ARROW
A1FC 2225	# PARALLEL TO
A1FD 2223	# DIVIDES
A1FE 2571	# LT DIAG UP RIGHT TO LOW LEFT   duplicates A2AC
A240 2572	# LT DIAG UP LEFT TO LOW RIGHT   duplicates A2ADp
A241 FF0F	# FULLWIDTH SOLIDUS
A242 FF3C	# FULLWIDTH REVERSE SOLIDUS
A243 FF04	# FULLWIDTH DOLLAR SIGN
A244 00A5	# YEN SIGN
A245 3012	# POSTAL MARK
A246 00A2	# CENT SIGN
A247 00A3	# POUND SIGN
A248 FF05	# FULLWIDTH PERCENT SIGN
A249 FF20	# FULLWIDTH COMMERCIAL AT
A24A 2103	# DEGREE CELSIUS
A24B 2109	# DEGREE FAHRENHEIT
A24C FE69	# SMALL DOLLAR SIGN
A24D FE6A	# SMALL PERCENT SIGN
A24E FE6B	# SMALL COMMERCIAL AT
A24F 33D5	# SQUARE MIL
A250 339C	# SQUARE MM
A251 339D	# SQUARE CM
A252 339E	# SQUARE KM
A253 33CE	# SQUARE KM CAPITAL
A254 33A1	# SQUARE M SQUARED
A255 338E	# SQUARE MG
A256 338F	# SQUARE KG
A257 33C4	# SQUARE CC
A258 00B0	# DEGREE SIGN
A259 5159	# <CJK>
A25A 515B	# <CJK>
A25B 515E	# <CJK>
A25C 515D	# <CJK>
A25D 5161	# <CJK>
A25E 5163	# <CJK>
A25F 55E7	# <CJK>
A260 74E9	# <CJK>
A261 7CCE	# <CJK>
A262 2581	# LOWER ONE EIGHTH BLOCK
A263 2582	# LOWER ONE QUARTER BLOCK
A264 2583	# LOWER THREE EIGHTHS BLOCK
A265 2584	# LOWER HALF BLOCK
A266 2585	# LOWER FIVE EIGHTHS BLOCK
A267 2586	# LOWER THREE QUARTERS BLOCK
A268 2587	# LOWER SEVEN EIGHTHS BLOCK
A269 2588	# FULL BLOCK
A26A 258F	# LEFT ONE EIGHTH BLOCK
A26B 258E	# LEFT ONE QUARTER BLOCK
A26C 258D	# LEFT THREE EIGHTHS BLOCK
A26D 258C	# LEFT HALF BLOCK
A26E 258B	# LEFT FIVE EIGHTHS BLOCK
A26F 258A	# LEFT THREE QUARTERS BLOCK
A270 2589	# LEFT SEVEN EIGHTHS BLOCK
A271 253C	# BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
A272 2534	# BOX DRAWINGS LIGHT UP AND HORIZONTAL
A273 252C	# BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
A274 2524	# BOX DRAWINGS LIGHT VERTICAL AND LEFT
A275 251C	# BOX DRAWINGS LIGHT VERTICAL AND RIGHT
A276 2594	# UPPER ONE EIGHTH BLOCK
A277 2500	# BOX DRAWINGS LIGHT HORIZONTAL
A278 2502	# BOX DRAWINGS LIGHT VERTICAL
A279 2595	# RIGHT ONE EIGHTH BLOCK
A27A 250C	# BOX DRAWINGS LIGHT DOWN AND RIGHT
A27B 2510	# BOX DRAWINGS LIGHT DOWN AND LEFT
A27C 2514	# BOX DRAWINGS LIGHT UP AND RIGHT
A27D 2518	# BOX DRAWINGS LIGHT UP AND LEFT
A27E 256D	# BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
A2A1 256E	# BOX DRAWINGS LIGHT ARC DOWN AND LEFT
A2A2 2570	# BOX DRAWINGS LIGHT ARC UP AND RIGHT
A2A3 256F	# BOX DRAWINGS LIGHT ARC UP AND LEFT
A2A4 2550	# BOX DRAWINGS DOUBLE HORIZONTAL
A2A5 255E	# BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
A2A6 256A	# BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
A2A7 2561	# BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
A2A8 25E2	# BLACK LOWER RIGHT TRIANGLE
A2A9 25E3	# BLACK LOWER LEFT TRIANGLE
A2AA 25E5	# BLACK UPPER RIGHT TRIANGLE
A2AB 25E4	# BLACK UPPER LEFT TRIANGLE
A2AC 2571	# BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
A2AD 2572	# BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
A2AE 2573	# BOX DRAWINGS LIGHT DIAGONAL CROSS
A2AF FF10	# FULLWIDTH DIGIT ZERO
A2B0 FF11	# FULLWIDTH DIGIT ONE
A2B1 FF12	# FULLWIDTH DIGIT TWO
A2B2 FF13	# FULLWIDTH DIGIT THREE
A2B3 FF14	# FULLWIDTH DIGIT FOUR
A2B4 FF15	# FULLWIDTH DIGIT FIVE
A2B5 FF16	# FULLWIDTH DIGIT SIX
A2B6 FF17	# FULLWIDTH DIGIT SEVEN
A2B7 FF18	# FULLWIDTH DIGIT EIGHT
A2B8 FF19	# FULLWIDTH DIGIT NINE
A2B9 2160	# ROMAN NUMERAL ONE
A2BA 2161	# ROMAN NUMERAL TWO
A2BB 2162	# ROMAN NUMERAL THREE
A2BC 2163	# ROMAN NUMERAL FOUR
A2BD 2164	# ROMAN NUMERAL FIVE
A2BE 2165	# ROMAN NUMERAL SIX
A2BF 2166	# ROMAN NUMERAL SEVEN
A2C0 2167	# ROMAN NUMERAL EIGHT
A2C1 2168	# ROMAN NUMERAL NINE
A2C2 2169	# ROMAN NUMERAL TEN
A2C3 3021	# HANGZHOU NUMERAL ONE
A2C4 3022	# HANGZHOU NUMERAL TWO
A2C5 3023	# HANGZHOU NUMERAL THREE
A2C6 3024	# HANGZHOU NUMERAL FOUR
A2C7 3025	# HANGZHOU NUMERAL FIVE
A2C8 3026	# HANGZHOU NUMERAL SIX
A2C9 3027	# HANGZHOU NUMERAL SEVEN
A2CA 3028	# HANGZHOU NUMERAL EIGHT
A2CB 3029	# HANGZHOU NUMERAL NINE
A2CC 5341	# HANGZHOU NUMERAL TEN           conflicts with A451 mapping
A2CD 5344	# <CJK>
A2CE 5345	# HANGZHOU NUMERAL THIRTY        conflicts with A4CA mapping
A2CF FF21	# FULLWIDTH LATIN CAPITAL LETTER A
A2D0 FF22	# FULLWIDTH LATIN CAPITAL LETTER B
A2D1 FF23	# FULLWIDTH LATIN CAPITAL LETTER C
A2D2 FF24	# FULLWIDTH LATIN CAPITAL LETTER D
A2D3 FF25	# FULLWIDTH LATIN CAPITAL LETTER E
A2D4 FF26	# FULLWIDTH LATIN CAPITAL LETTER F
A2D5 FF27	# FULLWIDTH LATIN CAPITAL LETTER G
A2D6 FF28	# FULLWIDTH LATIN CAPITAL LETTER H
A2D7 FF29	# FULLWIDTH LATIN CAPITAL LETTER I
A2D8 FF2A	# FULLWIDTH LATIN CAPITAL LETTER J
A2D9 FF2B	# FULLWIDTH LATIN CAPITAL LETTER K
A2DA FF2C	# FULLWIDTH LATIN CAPITAL LETTER L
A2DB FF2D	# FULLWIDTH LATIN CAPITAL LETTER M
A2DC FF2E	# FULLWIDTH LATIN CAPITAL LETTER N
A2DD FF2F	# FULLWIDTH LATIN CAPITAL LETTER O
A2DE FF30	# FULLWIDTH LATIN CAPITAL LETTER P
A2DF FF31	# FULLWIDTH LATIN CAPITAL LETTER Q
A2E0 FF32	# FULLWIDTH LATIN CAPITAL LETTER R
A2E1 FF33	# FULLWIDTH LATIN CAPITAL LETTER S
A2E2 FF34	# FULLWIDTH LATIN CAPITAL LETTER T
A2E3 FF35	# FULLWIDTH LATIN CAPITAL LETTER U
A2E4 FF36	# FULLWIDTH LATIN CAPITAL LETTER V
A2E5 FF37	# FULLWIDTH LATIN CAPITAL LETTER W
A2E6 FF38	# FULLWIDTH LATIN CAPITAL LETTER X
A2E7 FF39	# FULLWIDTH LATIN CAPITAL LETTER Y
A2E8 FF3A	# FULLWIDTH LATIN CAPITAL LETTER Z
A2E9 FF41	# FULLWIDTH LATIN SMALL LETTER A
A2EA FF42	# FULLWIDTH LATIN SMALL LETTER B
A2EB FF43	# FULLWIDTH LATIN SMALL LETTER C
A2EC FF44	# FULLWIDTH LATIN SMALL LETTER D
A2ED FF45	# FULLWIDTH LATIN SMALL LETTER E
A2EE FF46	# FULLWIDTH LATIN SMALL LETTER F
A2EF FF47	# FULLWIDTH LATIN SMALL LETTER G
A2F0 FF48	# FULLWIDTH LATIN SMALL LETTER H
A2F1 FF49	# FULLWIDTH LATIN SMALL LETTER I
A2F2 FF4A	# FULLWIDTH LATIN SMALL LETTER J
A2F3 FF4B	# FULLWIDTH LATIN SMALL LETTER K
A2F4 FF4C	# FULLWIDTH LATIN SMALL LETTER L
A2F5 FF4D	# FULLWIDTH LATIN SMALL LETTER M
A2F6 FF4E	# FULLWIDTH LATIN SMALL LETTER N
A2F7 FF4F	# FULLWIDTH LATIN SMALL LETTER O
A2F8 FF50	# FULLWIDTH LATIN SMALL LETTER P
A2F9 FF51	# FULLWIDTH LATIN SMALL LETTER Q
A2FA FF52	# FULLWIDTH LATIN SMALL LETTER R
A2FB FF53	# FULLWIDTH LATIN SMALL LETTER S
A2FC FF54	# FULLWIDTH LATIN SMALL LETTER T
A2FD FF55	# FULLWIDTH LATIN SMALL LETTER U
A2FE FF56	# FULLWIDTH LATIN SMALL LETTER V
A340 FF57	# FULLWIDTH LATIN SMALL LETTER W
A341 FF58	# FULLWIDTH LATIN SMALL LETTER X
A342 FF59	# FULLWIDTH LATIN SMALL LETTER Y
A343 FF5A	# FULLWIDTH LATIN SMALL LETTER Z
A344 0391	# GREEK CAPITAL LETTER ALPHA
A345 0392	# GREEK CAPITAL LETTER BETA
A346 0393	# GREEK CAPITAL LETTER GAMMA
A347 0394	# GREEK CAPITAL LETTER DELTA
A348 0395	# GREEK CAPITAL LETTER EPSILON
A349 0396	# GREEK CAPITAL LETTER ZETA
A34A 0397	# GREEK CAPITAL LETTER ETA
A34B 0398	# GREEK CAPITAL LETTER THETA
A34C 0399	# GREEK CAPITAL LETTER IOTA
A34D 039A	# GREEK CAPITAL LETTER KAPPA
A34E 039B	# GREEK CAPITAL LETTER LAMDA
A34F 039C	# GREEK CAPITAL LETTER MU
A350 039D	# GREEK CAPITAL LETTER NU
A351 039E	# GREEK CAPITAL LETTER XI
A352 039F	# GREEK CAPITAL LETTER OMICRON
A353 03A0	# GREEK CAPITAL LETTER PI
A354 03A1	# GREEK CAPITAL LETTER RHO
A355 03A3	# GREEK CAPITAL LETTER SIGMA
A356 03A4	# GREEK CAPITAL LETTER TAU
A357 03A5	# GREEK CAPITAL LETTER UPSILON
A358 03A6	# GREEK CAPITAL LETTER PHI
A359 03A7	# GREEK CAPITAL LETTER CHI
A35A 03A8	# GREEK CAPITAL LETTER PSI
A35B 03A9	# GREEK CAPITAL LETTER OMEGA
A35C 03B1	# GREEK SMALL LETTER ALPHA
A35D 03B2	# GREEK SMALL LETTER BETA
A35E 03B3	# GREEK SMALL LETTER GAMMA
A35F 03B4	# GREEK SMALL LETTER DELTA
A360 03B5	# GREEK SMALL LETTER EPSILON
A361 03B6	# GREEK SMALL LETTER ZETA
A362 03B7	# GREEK SMALL LETTER ETA
A363 03B8	# GREEK SMALL LETTER THETA
A364 03B9	# GREEK SMALL LETTER IOTA
A365 03BA	# GREEK SMALL LETTER KAPPA
A366 03BB	# GREEK SMALL LETTER LAMDA
A367 03BC	# GREEK SMALL LETTER MU
A368 03BD	# GREEK SMALL LETTER NU
A369 03BE	# GREEK SMALL LETTER XI
A36A 03BF	# GREEK SMALL LETTER OMICRON
A36B 03C0	# GREEK SMALL LETTER PI
A36C 03C1	# GREEK SMALL LETTER RHO
A36D 03C3	# GREEK SMALL LETTER SIGMA
A36E 03C4	# GREEK SMALL LETTER TAU
A36F 03C5	# GREEK SMALL LETTER UPSILON
A370 03C6	# GREEK SMALL LETTER PHI
A371 03C7	# GREEK SMALL LETTER CHI
A372 03C8	# GREEK SMALL LETTER PSI
A373 03C9	# GREEK SMALL LETTER OMEGA
A374 3105	# BOPOMOFO LETTER B
A375 3106	# BOPOMOFO LETTER P
A376 3107	# BOPOMOFO LETTER M
A377 3108	# BOPOMOFO LETTER F
A378 3109	# BOPOMOFO LETTER D
A379 310A	# BOPOMOFO LETTER T
A37A 310B	# BOPOMOFO LETTER N
A37B 310C	# BOPOMOFO LETTER L
A37C 310D	# BOPOMOFO LETTER G
A37D 310E	# BOPOMOFO LETTER K
A37E 310F	# BOPOMOFO LETTER H
A3A1 3110	# BOPOMOFO LETTER J
A3A2 3111	# BOPOMOFO LETTER Q
A3A3 3112	# BOPOMOFO LETTER X
A3A4 3113	# BOPOMOFO LETTER ZH
A3A5 3114	# BOPOMOFO LETTER CH
A3A6 3115	# BOPOMOFO LETTER SH
A3A7 3116	# BOPOMOFO LETTER R
A3A8 3117	# BOPOMOFO LETTER Z
A3A9 3118	# BOPOMOFO LETTER C
A3AA 3119	# BOPOMOFO LETTER S
A3AB 311A	# BOPOMOFO LETTER A
A3AC 311B	# BOPOMOFO LETTER O
A3AD 311C	# BOPOMOFO LETTER E
A3AE 311D	# BOPOMOFO LETTER EH
A3AF 311E	# BOPOMOFO LETTER AI
A3B0 311F	# BOPOMOFO LETTER EI
A3B1 3120	# BOPOMOFO LETTER AU
A3B2 3121	# BOPOMOFO LETTER OU
A3B3 3122	# BOPOMOFO LETTER AN
A3B4 3123	# BOPOMOFO LETTER EN
A3B5 3124	# BOPOMOFO LETTER ANG
A3B6 3125	# BOPOMOFO LETTER ENG
A3B7 3126	# BOPOMOFO LETTER ER
A3B8 3127	# BOPOMOFO LETTER I
A3B9 3128	# BOPOMOFO LETTER U
A3BA 3129	# BOPOMOFO LETTER IU
A3BB 02D9	# DOT ABOVE (Mandarin Chinese light tone)
A3BC 02C9	# MODIFIER LETTER MACRON (Mandarin Chinese first tone)
A3BD 02CA	# MODIFIER LETTER ACUTE ACCENT (Mandarin Chinese second tone)
A3BE 02C7	# CARON (Mandarin Chinese third tone)
A3BF 02CB	# MODIFIER LETTER GRAVE ACCENT (Mandarin Chinese fourth tone)
A440 4E00	# <CJK>
A441 4E59	# <CJK>
A442 4E01	# <CJK>
A443 4E03	# <CJK>
A444 4E43	# <CJK>
A445 4E5D	# <CJK>
A446 4E86	# <CJK>
A447 4E8C	# <CJK>
A448 4EBA	# <CJK>
A449 513F	# <CJK>
A44A 5165	# <CJK>
A44B 516B	# <CJK>
A44C 51E0	# <CJK>
A44D 5200	# <CJK>
A44E 5201	# <CJK>
A44F 529B	# <CJK>
A450 5315	# <CJK>
A451 5341	# <CJK>
A452 535C	# <CJK>
A453 53C8	# <CJK>
A454 4E09	# <CJK>
A455 4E0B	# <CJK>
A456 4E08	# <CJK>
A457 4E0A	# <CJK>
A458 4E2B	# <CJK>
A459 4E38	# <CJK>
A45A 51E1	# <CJK>
A45B 4E45	# <CJK>
A45C 4E48	# <CJK>
A45D 4E5F	# <CJK>
A45E 4E5E	# <CJK>
A45F 4E8E	# <CJK>
A460 4EA1	# <CJK>
A461 5140	# <CJK>
A462 5203	# <CJK>
A463 52FA	# <CJK>
A464 5343	# <CJK>
A465 53C9	# <CJK>
A466 53E3	# <CJK>
A467 571F	# <CJK>
A468 58EB	# <CJK>
A469 5915	# <CJK>
A46A 5927	# <CJK>
A46B 5973	# <CJK>
A46C 5B50	# <CJK>
A46D 5B51	# <CJK>
A46E 5B53	# <CJK>
A46F 5BF8	# <CJK>
A470 5C0F	# <CJK>
A471 5C22	# <CJK>
A472 5C38	# <CJK>
A473 5C71	# <CJK>
A474 5DDD	# <CJK>
A475 5DE5	# <CJK>
A476 5DF1	# <CJK>
A477 5DF2	# <CJK>
A478 5DF3	# <CJK>
A479 5DFE	# <CJK>
A47A 5E72	# <CJK>
A47B 5EFE	# <CJK>
A47C 5F0B	# <CJK>
A47D 5F13	# <CJK>
A47E 624D	# <CJK>
A4A1 4E11	# <CJK>
A4A2 4E10	# <CJK>
A4A3 4E0D	# <CJK>
A4A4 4E2D	# <CJK>
A4A5 4E30	# <CJK>
A4A6 4E39	# <CJK>
A4A7 4E4B	# <CJK>
A4A8 5C39	# <CJK>
A4A9 4E88	# <CJK>
A4AA 4E91	# <CJK>
A4AB 4E95	# <CJK>
A4AC 4E92	# <CJK>
A4AD 4E94	# <CJK>
A4AE 4EA2	# <CJK>
A4AF 4EC1	# <CJK>
A4B0 4EC0	# <CJK>
A4B1 4EC3	# <CJK>
A4B2 4EC6	# <CJK>
A4B3 4EC7	# <CJK>
A4B4 4ECD	# <CJK>
A4B5 4ECA	# <CJK>
A4B6 4ECB	# <CJK>
A4B7 4EC4	# <CJK>
A4B8 5143	# <CJK>
A4B9 5141	# <CJK>
A4BA 5167	# <CJK>
A4BB 516D	# <CJK>
A4BC 516E	# <CJK>
A4BD 516C	# <CJK>
A4BE 5197	# <CJK>
A4BF 51F6	# <CJK>
A4C0 5206	# <CJK>
A4C1 5207	# <CJK>
A4C2 5208	# <CJK>
A4C3 52FB	# <CJK>
A4C4 52FE	# <CJK>
A4C5 52FF	# <CJK>
A4C6 5316	# <CJK>
A4C7 5339	# <CJK>
A4C8 5348	# <CJK>
A4C9 5347	# <CJK>
A4CA 5345	# <CJK>
A4CB 535E	# <CJK>
A4CC 5384	# <CJK>
A4CD 53CB	# <CJK>
A4CE 53CA	# <CJK>
A4CF 53CD	# <CJK>
A4D0 58EC	# <CJK>
A4D1 5929	# <CJK>
A4D2 592B	# <CJK>
A4D3 592A	# <CJK>
A4D4 592D	# <CJK>
A4D5 5B54	# <CJK>
A4D6 5C11	# <CJK>
A4D7 5C24	# <CJK>
A4D8 5C3A	# <CJK>
A4D9 5C6F	# <CJK>
A4DA 5DF4	# <CJK>
A4DB 5E7B	# <CJK>
A4DC 5EFF	# <CJK>
A4DD 5F14	# <CJK>
A4DE 5F15	# <CJK>
A4DF 5FC3	# <CJK>
A4E0 6208	# <CJK>
A4E1 6236	# <CJK>
A4E2 624B	# <CJK>
A4E3 624E	# <CJK>
A4E4 652F	# <CJK>
A4E5 6587	# <CJK>
A4E6 6597	# <CJK>
A4E7 65A4	# <CJK>
A4E8 65B9	# <CJK>
A4E9 65E5	# <CJK>
A4EA 66F0	# <CJK>
A4EB 6708	# <CJK>
A4EC 6728	# <CJK>
A4ED 6B20	# <CJK>
A4EE 6B62	# <CJK>
A4EF 6B79	# <CJK>
A4F0 6BCB	# <CJK>
A4F1 6BD4	# <CJK>
A4F2 6BDB	# <CJK>
A4F3 6C0F	# <CJK>
A4F4 6C34	# <CJK>
A4F5 706B	# <CJK>
A4F6 722A	# <CJK>
A4F7 7236	# <CJK>
A4F8 723B	# <CJK>
A4F9 7247	# <CJK>
A4FA 7259	# <CJK>
A4FB 725B	# <CJK>
A4FC 72AC	# <CJK>
A4FD 738B	# <CJK>
A4FE 4E19	# <CJK>
A540 4E16	# <CJK>
A541 4E15	# <CJK>
A542 4E14	# <CJK>
A543 4E18	# <CJK>
A544 4E3B	# <CJK>
A545 4E4D	# <CJK>
A546 4E4F	# <CJK>
A547 4E4E	# <CJK>
A548 4EE5	# <CJK>
A549 4ED8	# <CJK>
A54A 4ED4	# <CJK>
A54B 4ED5	# <CJK>
A54C 4ED6	# <CJK>
A54D 4ED7	# <CJK>
A54E 4EE3	# <CJK>
A54F 4EE4	# <CJK>
A550 4ED9	# <CJK>
A551 4EDE	# <CJK>
A552 5145	# <CJK>
A553 5144	# <CJK>
A554 5189	# <CJK>
A555 518A	# <CJK>
A556 51AC	# <CJK>
A557 51F9	# <CJK>
A558 51FA	# <CJK>
A559 51F8	# <CJK>
A55A 520A	# <CJK>
A55B 52A0	# <CJK>
A55C 529F	# <CJK>
A55D 5305	# <CJK>
A55E 5306	# <CJK>
A55F 5317	# <CJK>
A560 531D	# <CJK>
A561 4EDF	# <CJK>
A562 534A	# <CJK>
A563 5349	# <CJK>
A564 5361	# <CJK>
A565 5360	# <CJK>
A566 536F	# <CJK>
A567 536E	# <CJK>
A568 53BB	# <CJK>
A569 53EF	# <CJK>
A56A 53E4	# <CJK>
A56B 53F3	# <CJK>
A56C 53EC	# <CJK>
A56D 53EE	# <CJK>
A56E 53E9	# <CJK>
A56F 53E8	# <CJK>
A570 53FC	# <CJK>
A571 53F8	# <CJK>
A572 53F5	# <CJK>
A573 53EB	# <CJK>
A574 53E6	# <CJK>
A575 53EA	# <CJK>
A576 53F2	# <CJK>
A577 53F1	# <CJK>
A578 53F0	# <CJK>
A579 53E5	# <CJK>
A57A 53ED	# <CJK>
A57B 53FB	# <CJK>
A57C 56DB	# <CJK>
A57D 56DA	# <CJK>
A57E 5916	# <CJK>
A5A1 592E	# <CJK>
A5A2 5931	# <CJK>
A5A3 5974	# <CJK>
A5A4 5976	# <CJK>
A5A5 5B55	# <CJK>
A5A6 5B83	# <CJK>
A5A7 5C3C	# <CJK>
A5A8 5DE8	# <CJK>
A5A9 5DE7	# <CJK>
A5AA 5DE6	# <CJK>
A5AB 5E02	# <CJK>
A5AC 5E03	# <CJK>
A5AD 5E73	# <CJK>
A5AE 5E7C	# <CJK>
A5AF 5F01	# <CJK>
A5B0 5F18	# <CJK>
A5B1 5F17	# <CJK>
A5B2 5FC5	# <CJK>
A5B3 620A	# <CJK>
A5B4 6253	# <CJK>
A5B5 6254	# <CJK>
A5B6 6252	# <CJK>
A5B7 6251	# <CJK>
A5B8 65A5	# <CJK>
A5B9 65E6	# <CJK>
A5BA 672E	# <CJK>
A5BB 672C	# <CJK>
A5BC 672A	# <CJK>
A5BD 672B	# <CJK>
A5BE 672D	# <CJK>
A5BF 6B63	# <CJK>
A5C0 6BCD	# <CJK>
A5C1 6C11	# <CJK>
A5C2 6C10	# <CJK>
A5C3 6C38	# <CJK>
A5C4 6C41	# <CJK>
A5C5 6C40	# <CJK>
A5C6 6C3E	# <CJK>
A5C7 72AF	# <CJK>
A5C8 7384	# <CJK>
A5C9 7389	# <CJK>
A5CA 74DC	# <CJK>
A5CB 74E6	# <CJK>
A5CC 7518	# <CJK>
A5CD 751F	# <CJK>
A5CE 7528	# <CJK>
A5CF 7529	# <CJK>
A5D0 7530	# <CJK>
A5D1 7531	# <CJK>
A5D2 7532	# <CJK>
A5D3 7533	# <CJK>
A5D4 758B	# <CJK>
A5D5 767D	# <CJK>
A5D6 76AE	# <CJK>
A5D7 76BF	# <CJK>
A5D8 76EE	# <CJK>
A5D9 77DB	# <CJK>
A5DA 77E2	# <CJK>
A5DB 77F3	# <CJK>
A5DC 793A	# <CJK>
A5DD 79BE	# <CJK>
A5DE 7A74	# <CJK>
A5DF 7ACB	# <CJK>
A5E0 4E1E	# <CJK>
A5E1 4E1F	# <CJK>
A5E2 4E52	# <CJK>
A5E3 4E53	# <CJK>
A5E4 4E69	# <CJK>
A5E5 4E99	# <CJK>
A5E6 4EA4	# <CJK>
A5E7 4EA6	# <CJK>
A5E8 4EA5	# <CJK>
A5E9 4EFF	# <CJK>
A5EA 4F09	# <CJK>
A5EB 4F19	# <CJK>
A5EC 4F0A	# <CJK>
A5ED 4F15	# <CJK>
A5EE 4F0D	# <CJK>
A5EF 4F10	# <CJK>
A5F0 4F11	# <CJK>
A5F1 4F0F	# <CJK>
A5F2 4EF2	# <CJK>
A5F3 4EF6	# <CJK>
A5F4 4EFB	# <CJK>
A5F5 4EF0	# <CJK>
A5F6 4EF3	# <CJK>
A5F7 4EFD	# <CJK>
A5F8 4F01	# <CJK>
A5F9 4F0B	# <CJK>
A5FA 5149	# <CJK>
A5FB 5147	# <CJK>
A5FC 5146	# <CJK>
A5FD 5148	# <CJK>
A5FE 5168	# <CJK>
A640 5171	# <CJK>
A641 518D	# <CJK>
A642 51B0	# <CJK>
A643 5217	# <CJK>
A644 5211	# <CJK>
A645 5212	# <CJK>
A646 520E	# <CJK>
A647 5216	# <CJK>
A648 52A3	# <CJK>
A649 5308	# <CJK>
A64A 5321	# <CJK>
A64B 5320	# <CJK>
A64C 5370	# <CJK>
A64D 5371	# <CJK>
A64E 5409	# <CJK>
A64F 540F	# <CJK>
A650 540C	# <CJK>
A651 540A	# <CJK>
A652 5410	# <CJK>
A653 5401	# <CJK>
A654 540B	# <CJK>
A655 5404	# <CJK>
A656 5411	# <CJK>
A657 540D	# <CJK>
A658 5408	# <CJK>
A659 5403	# <CJK>
A65A 540E	# <CJK>
A65B 5406	# <CJK>
A65C 5412	# <CJK>
A65D 56E0	# <CJK>
A65E 56DE	# <CJK>
A65F 56DD	# <CJK>
A660 5733	# <CJK>
A661 5730	# <CJK>
A662 5728	# <CJK>
A663 572D	# <CJK>
A664 572C	# <CJK>
A665 572F	# <CJK>
A666 5729	# <CJK>
A667 5919	# <CJK>
A668 591A	# <CJK>
A669 5937	# <CJK>
A66A 5938	# <CJK>
A66B 5984	# <CJK>
A66C 5978	# <CJK>
A66D 5983	# <CJK>
A66E 597D	# <CJK>
A66F 5979	# <CJK>
A670 5982	# <CJK>
A671 5981	# <CJK>
A672 5B57	# <CJK>
A673 5B58	# <CJK>
A674 5B87	# <CJK>
A675 5B88	# <CJK>
A676 5B85	# <CJK>
A677 5B89	# <CJK>
A678 5BFA	# <CJK>
A679 5C16	# <CJK>
A67A 5C79	# <CJK>
A67B 5DDE	# <CJK>
A67C 5E06	# <CJK>
A67D 5E76	# <CJK>
A67E 5E74	# <CJK>
A6A1 5F0F	# <CJK>
A6A2 5F1B	# <CJK>
A6A3 5FD9	# <CJK>
A6A4 5FD6	# <CJK>
A6A5 620E	# <CJK>
A6A6 620C	# <CJK>
A6A7 620D	# <CJK>
A6A8 6210	# <CJK>
A6A9 6263	# <CJK>
A6AA 625B	# <CJK>
A6AB 6258	# <CJK>
A6AC 6536	# <CJK>
A6AD 65E9	# <CJK>
A6AE 65E8	# <CJK>
A6AF 65EC	# <CJK>
A6B0 65ED	# <CJK>
A6B1 66F2	# <CJK>
A6B2 66F3	# <CJK>
A6B3 6709	# <CJK>
A6B4 673D	# <CJK>
A6B5 6734	# <CJK>
A6B6 6731	# <CJK>
A6B7 6735	# <CJK>
A6B8 6B21	# <CJK>
A6B9 6B64	# <CJK>
A6BA 6B7B	# <CJK>
A6BB 6C16	# <CJK>
A6BC 6C5D	# <CJK>
A6BD 6C57	# <CJK>
A6BE 6C59	# <CJK>
A6BF 6C5F	# <CJK>
A6C0 6C60	# <CJK>
A6C1 6C50	# <CJK>
A6C2 6C55	# <CJK>
A6C3 6C61	# <CJK>
A6C4 6C5B	# <CJK>
A6C5 6C4D	# <CJK>
A6C6 6C4E	# <CJK>
A6C7 7070	# <CJK>
A6C8 725F	# <CJK>
A6C9 725D	# <CJK>
A6CA 767E	# <CJK>
A6CB 7AF9	# <CJK>
A6CC 7C73	# <CJK>
A6CD 7CF8	# <CJK>
A6CE 7F36	# <CJK>
A6CF 7F8A	# <CJK>
A6D0 7FBD	# <CJK>
A6D1 8001	# <CJK>
A6D2 8003	# <CJK>
A6D3 800C	# <CJK>
A6D4 8012	# <CJK>
A6D5 8033	# <CJK>
A6D6 807F	# <CJK>
A6D7 8089	# <CJK>
A6D8 808B	# <CJK>
A6D9 808C	# <CJK>
A6DA 81E3	# <CJK>
A6DB 81EA	# <CJK>
A6DC 81F3	# <CJK>
A6DD 81FC	# <CJK>
A6DE 820C	# <CJK>
A6DF 821B	# <CJK>
A6E0 821F	# <CJK>
A6E1 826E	# <CJK>
A6E2 8272	# <CJK>
A6E3 827E	# <CJK>
A6E4 866B	# <CJK>
A6E5 8840	# <CJK>
A6E6 884C	# <CJK>
A6E7 8863	# <CJK>
A6E8 897F	# <CJK>
A6E9 9621	# <CJK>
A6EA 4E32	# <CJK>
A6EB 4EA8	# <CJK>
A6EC 4F4D	# <CJK>
A6ED 4F4F	# <CJK>
A6EE 4F47	# <CJK>
A6EF 4F57	# <CJK>
A6F0 4F5E	# <CJK>
A6F1 4F34	# <CJK>
A6F2 4F5B	# <CJK>
A6F3 4F55	# <CJK>
A6F4 4F30	# <CJK>
A6F5 4F50	# <CJK>
A6F6 4F51	# <CJK>
A6F7 4F3D	# <CJK>
A6F8 4F3A	# <CJK>
A6F9 4F38	# <CJK>
A6FA 4F43	# <CJK>
A6FB 4F54	# <CJK>
A6FC 4F3C	# <CJK>
A6FD 4F46	# <CJK>
A6FE 4F63	# <CJK>
A740 4F5C	# <CJK>
A741 4F60	# <CJK>
A742 4F2F	# <CJK>
A743 4F4E	# <CJK>
A744 4F36	# <CJK>
A745 4F59	# <CJK>
A746 4F5D	# <CJK>
A747 4F48	# <CJK>
A748 4F5A	# <CJK>
A749 514C	# <CJK>
A74A 514B	# <CJK>
A74B 514D	# <CJK>
A74C 5175	# <CJK>
A74D 51B6	# <CJK>
A74E 51B7	# <CJK>
A74F 5225	# <CJK>
A750 5224	# <CJK>
A751 5229	# <CJK>
A752 522A	# <CJK>
A753 5228	# <CJK>
A754 52AB	# <CJK>
A755 52A9	# <CJK>
A756 52AA	# <CJK>
A757 52AC	# <CJK>
A758 5323	# <CJK>
A759 5373	# <CJK>
A75A 5375	# <CJK>
A75B 541D	# <CJK>
A75C 542D	# <CJK>
A75D 541E	# <CJK>
A75E 543E	# <CJK>
A75F 5426	# <CJK>
A760 544E	# <CJK>
A761 5427	# <CJK>
A762 5446	# <CJK>
A763 5443	# <CJK>
A764 5433	# <CJK>
A765 5448	# <CJK>
A766 5442	# <CJK>
A767 541B	# <CJK>
A768 5429	# <CJK>
A769 544A	# <CJK>
A76A 5439	# <CJK>
A76B 543B	# <CJK>
A76C 5438	# <CJK>
A76D 542E	# <CJK>
A76E 5435	# <CJK>
A76F 5436	# <CJK>
A770 5420	# <CJK>
A771 543C	# <CJK>
A772 5440	# <CJK>
A773 5431	# <CJK>
A774 542B	# <CJK>
A775 541F	# <CJK>
A776 542C	# <CJK>
A777 56EA	# <CJK>
A778 56F0	# <CJK>
A779 56E4	# <CJK>
A77A 56EB	# <CJK>
A77B 574A	# <CJK>
A77C 5751	# <CJK>
A77D 5740	# <CJK>
A77E 574D	# <CJK>
A7A1 5747	# <CJK>
A7A2 574E	# <CJK>
A7A3 573E	# <CJK>
A7A4 5750	# <CJK>
A7A5 574F	# <CJK>
A7A6 573B	# <CJK>
A7A7 58EF	# <CJK>
A7A8 593E	# <CJK>
A7A9 599D	# <CJK>
A7AA 5992	# <CJK>
A7AB 59A8	# <CJK>
A7AC 599E	# <CJK>
A7AD 59A3	# <CJK>
A7AE 5999	# <CJK>
A7AF 5996	# <CJK>
A7B0 598D	# <CJK>
A7B1 59A4	# <CJK>
A7B2 5993	# <CJK>
A7B3 598A	# <CJK>
A7B4 59A5	# <CJK>
A7B5 5B5D	# <CJK>
A7B6 5B5C	# <CJK>
A7B7 5B5A	# <CJK>
A7B8 5B5B	# <CJK>
A7B9 5B8C	# <CJK>
A7BA 5B8B	# <CJK>
A7BB 5B8F	# <CJK>
A7BC 5C2C	# <CJK>
A7BD 5C40	# <CJK>
A7BE 5C41	# <CJK>
A7BF 5C3F	# <CJK>
A7C0 5C3E	# <CJK>
A7C1 5C90	# <CJK>
A7C2 5C91	# <CJK>
A7C3 5C94	# <CJK>
A7C4 5C8C	# <CJK>
A7C5 5DEB	# <CJK>
A7C6 5E0C	# <CJK>
A7C7 5E8F	# <CJK>
A7C8 5E87	# <CJK>
A7C9 5E8A	# <CJK>
A7CA 5EF7	# <CJK>
A7CB 5F04	# <CJK>
A7CC 5F1F	# <CJK>
A7CD 5F64	# <CJK>
A7CE 5F62	# <CJK>
A7CF 5F77	# <CJK>
A7D0 5F79	# <CJK>
A7D1 5FD8	# <CJK>
A7D2 5FCC	# <CJK>
A7D3 5FD7	# <CJK>
A7D4 5FCD	# <CJK>
A7D5 5FF1	# <CJK>
A7D6 5FEB	# <CJK>
A7D7 5FF8	# <CJK>
A7D8 5FEA	# <CJK>
A7D9 6212	# <CJK>
A7DA 6211	# <CJK>
A7DB 6284	# <CJK>
A7DC 6297	# <CJK>
A7DD 6296	# <CJK>
A7DE 6280	# <CJK>
A7DF 6276	# <CJK>
A7E0 6289	# <CJK>
A7E1 626D	# <CJK>
A7E2 628A	# <CJK>
A7E3 627C	# <CJK>
A7E4 627E	# <CJK>
A7E5 6279	# <CJK>
A7E6 6273	# <CJK>
A7E7 6292	# <CJK>
A7E8 626F	# <CJK>
A7E9 6298	# <CJK>
A7EA 626E	# <CJK>
A7EB 6295	# <CJK>
A7EC 6293	# <CJK>
A7ED 6291	# <CJK>
A7EE 6286	# <CJK>
A7EF 6539	# <CJK>
A7F0 653B	# <CJK>
A7F1 6538	# <CJK>
A7F2 65F1	# <CJK>
A7F3 66F4	# <CJK>
A7F4 675F	# <CJK>
A7F5 674E	# <CJK>
A7F6 674F	# <CJK>
A7F7 6750	# <CJK>
A7F8 6751	# <CJK>
A7F9 675C	# <CJK>
A7FA 6756	# <CJK>
A7FB 675E	# <CJK>
A7FC 6749	# <CJK>
A7FD 6746	# <CJK>
A7FE 6760	# <CJK>
A840 6753	# <CJK>
A841 6757	# <CJK>
A842 6B65	# <CJK>
A843 6BCF	# <CJK>
A844 6C42	# <CJK>
A845 6C5E	# <CJK>
A846 6C99	# <CJK>
A847 6C81	# <CJK>
A848 6C88	# <CJK>
A849 6C89	# <CJK>
A84A 6C85	# <CJK>
A84B 6C9B	# <CJK>
A84C 6C6A	# <CJK>
A84D 6C7A	# <CJK>
A84E 6C90	# <CJK>
A84F 6C70	# <CJK>
A850 6C8C	# <CJK>
A851 6C68	# <CJK>
A852 6C96	# <CJK>
A853 6C92	# <CJK>
A854 6C7D	# <CJK>
A855 6C83	# <CJK>
A856 6C72	# <CJK>
A857 6C7E	# <CJK>
A858 6C74	# <CJK>
A859 6C86	# <CJK>
A85A 6C76	# <CJK>
A85B 6C8D	# <CJK>
A85C 6C94	# <CJK>
A85D 6C98	# <CJK>
A85E 6C82	# <CJK>
A85F 7076	# <CJK>
A860 707C	# <CJK>
A861 707D	# <CJK>
A862 7078	# <CJK>
A863 7262	# <CJK>
A864 7261	# <CJK>
A865 7260	# <CJK>
A866 72C4	# <CJK>
A867 72C2	# <CJK>
A868 7396	# <CJK>
A869 752C	# <CJK>
A86A 752B	# <CJK>
A86B 7537	# <CJK>
A86C 7538	# <CJK>
A86D 7682	# <CJK>
A86E 76EF	# <CJK>
A86F 77E3	# <CJK>
A870 79C1	# <CJK>
A871 79C0	# <CJK>
A872 79BF	# <CJK>
A873 7A76	# <CJK>
A874 7CFB	# <CJK>
A875 7F55	# <CJK>
A876 8096	# <CJK>
A877 8093	# <CJK>
A878 809D	# <CJK>
A879 8098	# <CJK>
A87A 809B	# <CJK>
A87B 809A	# <CJK>
A87C 80B2	# <CJK>
A87D 826F	# <CJK>
A87E 8292	# <CJK>
A8A1 828B	# <CJK>
A8A2 828D	# <CJK>
A8A3 898B	# <CJK>
A8A4 89D2	# <CJK>
A8A5 8A00	# <CJK>
A8A6 8C37	# <CJK>
A8A7 8C46	# <CJK>
A8A8 8C55	# <CJK>
A8A9 8C9D	# <CJK>
A8AA 8D64	# <CJK>
A8AB 8D70	# <CJK>
A8AC 8DB3	# <CJK>
A8AD 8EAB	# <CJK>
A8AE 8ECA	# <CJK>
A8AF 8F9B	# <CJK>
A8B0 8FB0	# <CJK>
A8B1 8FC2	# <CJK>
A8B2 8FC6	# <CJK>
A8B3 8FC5	# <CJK>
A8B4 8FC4	# <CJK>
A8B5 5DE1	# <CJK>
A8B6 9091	# <CJK>
A8B7 90A2	# <CJK>
A8B8 90AA	# <CJK>
A8B9 90A6	# <CJK>
A8BA 90A3	# <CJK>
A8BB 9149	# <CJK>
A8BC 91C6	# <CJK>
A8BD 91CC	# <CJK>
A8BE 9632	# <CJK>
A8BF 962E	# <CJK>
A8C0 9631	# <CJK>
A8C1 962A	# <CJK>
A8C2 962C	# <CJK>
A8C3 4E26	# <CJK>
A8C4 4E56	# <CJK>
A8C5 4E73	# <CJK>
A8C6 4E8B	# <CJK>
A8C7 4E9B	# <CJK>
A8C8 4E9E	# <CJK>
A8C9 4EAB	# <CJK>
A8CA 4EAC	# <CJK>
A8CB 4F6F	# <CJK>
A8CC 4F9D	# <CJK>
A8CD 4F8D	# <CJK>
A8CE 4F73	# <CJK>
A8CF 4F7F	# <CJK>
A8D0 4F6C	# <CJK>
A8D1 4F9B	# <CJK>
A8D2 4F8B	# <CJK>
A8D3 4F86	# <CJK>
A8D4 4F83	# <CJK>
A8D5 4F70	# <CJK>
A8D6 4F75	# <CJK>
A8D7 4F88	# <CJK>
A8D8 4F69	# <CJK>
A8D9 4F7B	# <CJK>
A8DA 4F96	# <CJK>
A8DB 4F7E	# <CJK>
A8DC 4F8F	# <CJK>
A8DD 4F91	# <CJK>
A8DE 4F7A	# <CJK>
A8DF 5154	# <CJK>
A8E0 5152	# <CJK>
A8E1 5155	# <CJK>
A8E2 5169	# <CJK>
A8E3 5177	# <CJK>
A8E4 5176	# <CJK>
A8E5 5178	# <CJK>
A8E6 51BD	# <CJK>
A8E7 51FD	# <CJK>
A8E8 523B	# <CJK>
A8E9 5238	# <CJK>
A8EA 5237	# <CJK>
A8EB 523A	# <CJK>
A8EC 5230	# <CJK>
A8ED 522E	# <CJK>
A8EE 5236	# <CJK>
A8EF 5241	# <CJK>
A8F0 52BE	# <CJK>
A8F1 52BB	# <CJK>
A8F2 5352	# <CJK>
A8F3 5354	# <CJK>
A8F4 5353	# <CJK>
A8F5 5351	# <CJK>
A8F6 5366	# <CJK>
A8F7 5377	# <CJK>
A8F8 5378	# <CJK>
A8F9 5379	# <CJK>
A8FA 53D6	# <CJK>
A8FB 53D4	# <CJK>
A8FC 53D7	# <CJK>
A8FD 5473	# <CJK>
A8FE 5475	# <CJK>
A940 5496	# <CJK>
A941 5478	# <CJK>
A942 5495	# <CJK>
A943 5480	# <CJK>
A944 547B	# <CJK>
A945 5477	# <CJK>
A946 5484	# <CJK>
A947 5492	# <CJK>
A948 5486	# <CJK>
A949 547C	# <CJK>
A94A 5490	# <CJK>
A94B 5471	# <CJK>
A94C 5476	# <CJK>
A94D 548C	# <CJK>
A94E 549A	# <CJK>
A94F 5462	# <CJK>
A950 5468	# <CJK>
A951 548B	# <CJK>
A952 547D	# <CJK>
A953 548E	# <CJK>
A954 56FA	# <CJK>
A955 5783	# <CJK>
A956 5777	# <CJK>
A957 576A	# <CJK>
A958 5769	# <CJK>
A959 5761	# <CJK>
A95A 5766	# <CJK>
A95B 5764	# <CJK>
A95C 577C	# <CJK>
A95D 591C	# <CJK>
A95E 5949	# <CJK>
A95F 5947	# <CJK>
A960 5948	# <CJK>
A961 5944	# <CJK>
A962 5954	# <CJK>
A963 59BE	# <CJK>
A964 59BB	# <CJK>
A965 59D4	# <CJK>
A966 59B9	# <CJK>
A967 59AE	# <CJK>
A968 59D1	# <CJK>
A969 59C6	# <CJK>
A96A 59D0	# <CJK>
A96B 59CD	# <CJK>
A96C 59CB	# <CJK>
A96D 59D3	# <CJK>
A96E 59CA	# <CJK>
A96F 59AF	# <CJK>
A970 59B3	# <CJK>
A971 59D2	# <CJK>
A972 59C5	# <CJK>
A973 5B5F	# <CJK>
A974 5B64	# <CJK>
A975 5B63	# <CJK>
A976 5B97	# <CJK>
A977 5B9A	# <CJK>
A978 5B98	# <CJK>
A979 5B9C	# <CJK>
A97A 5B99	# <CJK>
A97B 5B9B	# <CJK>
A97C 5C1A	# <CJK>
A97D 5C48	# <CJK>
A97E 5C45	# <CJK>
A9A1 5C46	# <CJK>
A9A2 5CB7	# <CJK>
A9A3 5CA1	# <CJK>
A9A4 5CB8	# <CJK>
A9A5 5CA9	# <CJK>
A9A6 5CAB	# <CJK>
A9A7 5CB1	# <CJK>
A9A8 5CB3	# <CJK>
A9A9 5E18	# <CJK>
A9AA 5E1A	# <CJK>
A9AB 5E16	# <CJK>
A9AC 5E15	# <CJK>
A9AD 5E1B	# <CJK>
A9AE 5E11	# <CJK>
A9AF 5E78	# <CJK>
A9B0 5E9A	# <CJK>
A9B1 5E97	# <CJK>
A9B2 5E9C	# <CJK>
A9B3 5E95	# <CJK>
A9B4 5E96	# <CJK>
A9B5 5EF6	# <CJK>
A9B6 5F26	# <CJK>
A9B7 5F27	# <CJK>
A9B8 5F29	# <CJK>
A9B9 5F80	# <CJK>
A9BA 5F81	# <CJK>
A9BB 5F7F	# <CJK>
A9BC 5F7C	# <CJK>
A9BD 5FDD	# <CJK>
A9BE 5FE0	# <CJK>
A9BF 5FFD	# <CJK>
A9C0 5FF5	# <CJK>
A9C1 5FFF	# <CJK>
A9C2 600F	# <CJK>
A9C3 6014	# <CJK>
A9C4 602F	# <CJK>
A9C5 6035	# <CJK>
A9C6 6016	# <CJK>
A9C7 602A	# <CJK>
A9C8 6015	# <CJK>
A9C9 6021	# <CJK>
A9CA 6027	# <CJK>
A9CB 6029	# <CJK>
A9CC 602B	# <CJK>
A9CD 601B	# <CJK>
A9CE 6216	# <CJK>
A9CF 6215	# <CJK>
A9D0 623F	# <CJK>
A9D1 623E	# <CJK>
A9D2 6240	# <CJK>
A9D3 627F	# <CJK>
A9D4 62C9	# <CJK>
A9D5 62CC	# <CJK>
A9D6 62C4	# <CJK>
A9D7 62BF	# <CJK>
A9D8 62C2	# <CJK>
A9D9 62B9	# <CJK>
A9DA 62D2	# <CJK>
A9DB 62DB	# <CJK>
A9DC 62AB	# <CJK>
A9DD 62D3	# <CJK>
A9DE 62D4	# <CJK>
A9DF 62CB	# <CJK>
A9E0 62C8	# <CJK>
A9E1 62A8	# <CJK>
A9E2 62BD	# <CJK>
A9E3 62BC	# <CJK>
A9E4 62D0	# <CJK>
A9E5 62D9	# <CJK>
A9E6 62C7	# <CJK>
A9E7 62CD	# <CJK>
A9E8 62B5	# <CJK>
A9E9 62DA	# <CJK>
A9EA 62B1	# <CJK>
A9EB 62D8	# <CJK>
A9EC 62D6	# <CJK>
A9ED 62D7	# <CJK>
A9EE 62C6	# <CJK>
A9EF 62AC	# <CJK>
A9F0 62CE	# <CJK>
A9F1 653E	# <CJK>
A9F2 65A7	# <CJK>
A9F3 65BC	# <CJK>
A9F4 65FA	# <CJK>
A9F5 6614	# <CJK>
A9F6 6613	# <CJK>
A9F7 660C	# <CJK>
A9F8 6606	# <CJK>
A9F9 6602	# <CJK>
A9FA 660E	# <CJK>
A9FB 6600	# <CJK>
A9FC 660F	# <CJK>
A9FD 6615	# <CJK>
A9FE 660A	# <CJK>
AA40 6607	# <CJK>
AA41 670D	# <CJK>
AA42 670B	# <CJK>
AA43 676D	# <CJK>
AA44 678B	# <CJK>
AA45 6795	# <CJK>
AA46 6771	# <CJK>
AA47 679C	# <CJK>
AA48 6773	# <CJK>
AA49 6777	# <CJK>
AA4A 6787	# <CJK>
AA4B 679D	# <CJK>
AA4C 6797	# <CJK>
AA4D 676F	# <CJK>
AA4E 6770	# <CJK>
AA4F 677F	# <CJK>
AA50 6789	# <CJK>
AA51 677E	# <CJK>
AA52 6790	# <CJK>
AA53 6775	# <CJK>
AA54 679A	# <CJK>
AA55 6793	# <CJK>
AA56 677C	# <CJK>
AA57 676A	# <CJK>
AA58 6772	# <CJK>
AA59 6B23	# <CJK>
AA5A 6B66	# <CJK>
AA5B 6B67	# <CJK>
AA5C 6B7F	# <CJK>
AA5D 6C13	# <CJK>
AA5E 6C1B	# <CJK>
AA5F 6CE3	# <CJK>
AA60 6CE8	# <CJK>
AA61 6CF3	# <CJK>
AA62 6CB1	# <CJK>
AA63 6CCC	# <CJK>
AA64 6CE5	# <CJK>
AA65 6CB3	# <CJK>
AA66 6CBD	# <CJK>
AA67 6CBE	# <CJK>
AA68 6CBC	# <CJK>
AA69 6CE2	# <CJK>
AA6A 6CAB	# <CJK>
AA6B 6CD5	# <CJK>
AA6C 6CD3	# <CJK>
AA6D 6CB8	# <CJK>
AA6E 6CC4	# <CJK>
AA6F 6CB9	# <CJK>
AA70 6CC1	# <CJK>
AA71 6CAE	# <CJK>
AA72 6CD7	# <CJK>
AA73 6CC5	# <CJK>
AA74 6CF1	# <CJK>
AA75 6CBF	# <CJK>
AA76 6CBB	# <CJK>
AA77 6CE1	# <CJK>
AA78 6CDB	# <CJK>
AA79 6CCA	# <CJK>
AA7A 6CAC	# <CJK>
AA7B 6CEF	# <CJK>
AA7C 6CDC	# <CJK>
AA7D 6CD6	# <CJK>
AA7E 6CE0	# <CJK>
AAA1 7095	# <CJK>
AAA2 708E	# <CJK>
AAA3 7092	# <CJK>
AAA4 708A	# <CJK>
AAA5 7099	# <CJK>
AAA6 722C	# <CJK>
AAA7 722D	# <CJK>
AAA8 7238	# <CJK>
AAA9 7248	# <CJK>
AAAA 7267	# <CJK>
AAAB 7269	# <CJK>
AAAC 72C0	# <CJK>
AAAD 72CE	# <CJK>
AAAE 72D9	# <CJK>
AAAF 72D7	# <CJK>
AAB0 72D0	# <CJK>
AAB1 73A9	# <CJK>
AAB2 73A8	# <CJK>
AAB3 739F	# <CJK>
AAB4 73AB	# <CJK>
AAB5 73A5	# <CJK>
AAB6 753D	# <CJK>
AAB7 759D	# <CJK>
AAB8 7599	# <CJK>
AAB9 759A	# <CJK>
AABA 7684	# <CJK>
AABB 76C2	# <CJK>
AABC 76F2	# <CJK>
AABD 76F4	# <CJK>
AABE 77E5	# <CJK>
AABF 77FD	# <CJK>
AAC0 793E	# <CJK>
AAC1 7940	# <CJK>
AAC2 7941	# <CJK>
AAC3 79C9	# <CJK>
AAC4 79C8	# <CJK>
AAC5 7A7A	# <CJK>
AAC6 7A79	# <CJK>
AAC7 7AFA	# <CJK>
AAC8 7CFE	# <CJK>
AAC9 7F54	# <CJK>
AACA 7F8C	# <CJK>
AACB 7F8B	# <CJK>
AACC 8005	# <CJK>
AACD 80BA	# <CJK>
AACE 80A5	# <CJK>
AACF 80A2	# <CJK>
AAD0 80B1	# <CJK>
AAD1 80A1	# <CJK>
AAD2 80AB	# <CJK>
AAD3 80A9	# <CJK>
AAD4 80B4	# <CJK>
AAD5 80AA	# <CJK>
AAD6 80AF	# <CJK>
AAD7 81E5	# <CJK>
AAD8 81FE	# <CJK>
AAD9 820D	# <CJK>
AADA 82B3	# <CJK>
AADB 829D	# <CJK>
AADC 8299	# <CJK>
AADD 82AD	# <CJK>
AADE 82BD	# <CJK>
AADF 829F	# <CJK>
AAE0 82B9	# <CJK>
AAE1 82B1	# <CJK>
AAE2 82AC	# <CJK>
AAE3 82A5	# <CJK>
AAE4 82AF	# <CJK>
AAE5 82B8	# <CJK>
AAE6 82A3	# <CJK>
AAE7 82B0	# <CJK>
AAE8 82BE	# <CJK>
AAE9 82B7	# <CJK>
AAEA 864E	# <CJK>
AAEB 8671	# <CJK>
AAEC 521D	# <CJK>
AAED 8868	# <CJK>
AAEE 8ECB	# <CJK>
AAEF 8FCE	# <CJK>
AAF0 8FD4	# <CJK>
AAF1 8FD1	# <CJK>
AAF2 90B5	# <CJK>
AAF3 90B8	# <CJK>
AAF4 90B1	# <CJK>
AAF5 90B6	# <CJK>
AAF6 91C7	# <CJK>
AAF7 91D1	# <CJK>
AAF8 9577	# <CJK>
AAF9 9580	# <CJK>
AAFA 961C	# <CJK>
AAFB 9640	# <CJK>
AAFC 963F	# <CJK>
AAFD 963B	# <CJK>
AAFE 9644	# <CJK>
AB40 9642	# <CJK>
AB41 96B9	# <CJK>
AB42 96E8	# <CJK>
AB43 9752	# <CJK>
AB44 975E	# <CJK>
AB45 4E9F	# <CJK>
AB46 4EAD	# <CJK>
AB47 4EAE	# <CJK>
AB48 4FE1	# <CJK>
AB49 4FB5	# <CJK>
AB4A 4FAF	# <CJK>
AB4B 4FBF	# <CJK>
AB4C 4FE0	# <CJK>
AB4D 4FD1	# <CJK>
AB4E 4FCF	# <CJK>
AB4F 4FDD	# <CJK>
AB50 4FC3	# <CJK>
AB51 4FB6	# <CJK>
AB52 4FD8	# <CJK>
AB53 4FDF	# <CJK>
AB54 4FCA	# <CJK>
AB55 4FD7	# <CJK>
AB56 4FAE	# <CJK>
AB57 4FD0	# <CJK>
AB58 4FC4	# <CJK>
AB59 4FC2	# <CJK>
AB5A 4FDA	# <CJK>
AB5B 4FCE	# <CJK>
AB5C 4FDE	# <CJK>
AB5D 4FB7	# <CJK>
AB5E 5157	# <CJK>
AB5F 5192	# <CJK>
AB60 5191	# <CJK>
AB61 51A0	# <CJK>
AB62 524E	# <CJK>
AB63 5243	# <CJK>
AB64 524A	# <CJK>
AB65 524D	# <CJK>
AB66 524C	# <CJK>
AB67 524B	# <CJK>
AB68 5247	# <CJK>
AB69 52C7	# <CJK>
AB6A 52C9	# <CJK>
AB6B 52C3	# <CJK>
AB6C 52C1	# <CJK>
AB6D 530D	# <CJK>
AB6E 5357	# <CJK>
AB6F 537B	# <CJK>
AB70 539A	# <CJK>
AB71 53DB	# <CJK>
AB72 54AC	# <CJK>
AB73 54C0	# <CJK>
AB74 54A8	# <CJK>
AB75 54CE	# <CJK>
AB76 54C9	# <CJK>
AB77 54B8	# <CJK>
AB78 54A6	# <CJK>
AB79 54B3	# <CJK>
AB7A 54C7	# <CJK>
AB7B 54C2	# <CJK>
AB7C 54BD	# <CJK>
AB7D 54AA	# <CJK>
AB7E 54C1	# <CJK>
ABA1 54C4	# <CJK>
ABA2 54C8	# <CJK>
ABA3 54AF	# <CJK>
ABA4 54AB	# <CJK>
ABA5 54B1	# <CJK>
ABA6 54BB	# <CJK>
ABA7 54A9	# <CJK>
ABA8 54A7	# <CJK>
ABA9 54BF	# <CJK>
ABAA 56FF	# <CJK>
ABAB 5782	# <CJK>
ABAC 578B	# <CJK>
ABAD 57A0	# <CJK>
ABAE 57A3	# <CJK>
ABAF 57A2	# <CJK>
ABB0 57CE	# <CJK>
ABB1 57AE	# <CJK>
ABB2 5793	# <CJK>
ABB3 5955	# <CJK>
ABB4 5951	# <CJK>
ABB5 594F	# <CJK>
ABB6 594E	# <CJK>
ABB7 5950	# <CJK>
ABB8 59DC	# <CJK>
ABB9 59D8	# <CJK>
ABBA 59FF	# <CJK>
ABBB 59E3	# <CJK>
ABBC 59E8	# <CJK>
ABBD 5A03	# <CJK>
ABBE 59E5	# <CJK>
ABBF 59EA	# <CJK>
ABC0 59DA	# <CJK>
ABC1 59E6	# <CJK>
ABC2 5A01	# <CJK>
ABC3 59FB	# <CJK>
ABC4 5B69	# <CJK>
ABC5 5BA3	# <CJK>
ABC6 5BA6	# <CJK>
ABC7 5BA4	# <CJK>
ABC8 5BA2	# <CJK>
ABC9 5BA5	# <CJK>
ABCA 5C01	# <CJK>
ABCB 5C4E	# <CJK>
ABCC 5C4F	# <CJK>
ABCD 5C4D	# <CJK>
ABCE 5C4B	# <CJK>
ABCF 5CD9	# <CJK>
ABD0 5CD2	# <CJK>
ABD1 5DF7	# <CJK>
ABD2 5E1D	# <CJK>
ABD3 5E25	# <CJK>
ABD4 5E1F	# <CJK>
ABD5 5E7D	# <CJK>
ABD6 5EA0	# <CJK>
ABD7 5EA6	# <CJK>
ABD8 5EFA	# <CJK>
ABD9 5F08	# <CJK>
ABDA 5F2D	# <CJK>
ABDB 5F65	# <CJK>
ABDC 5F88	# <CJK>
ABDD 5F85	# <CJK>
ABDE 5F8A	# <CJK>
ABDF 5F8B	# <CJK>
ABE0 5F87	# <CJK>
ABE1 5F8C	# <CJK>
ABE2 5F89	# <CJK>
ABE3 6012	# <CJK>
ABE4 601D	# <CJK>
ABE5 6020	# <CJK>
ABE6 6025	# <CJK>
ABE7 600E	# <CJK>
ABE8 6028	# <CJK>
ABE9 604D	# <CJK>
ABEA 6070	# <CJK>
ABEB 6068	# <CJK>
ABEC 6062	# <CJK>
ABED 6046	# <CJK>
ABEE 6043	# <CJK>
ABEF 606C	# <CJK>
ABF0 606B	# <CJK>
ABF1 606A	# <CJK>
ABF2 6064	# <CJK>
ABF3 6241	# <CJK>
ABF4 62DC	# <CJK>
ABF5 6316	# <CJK>
ABF6 6309	# <CJK>
ABF7 62FC	# <CJK>
ABF8 62ED	# <CJK>
ABF9 6301	# <CJK>
ABFA 62EE	# <CJK>
ABFB 62FD	# <CJK>
ABFC 6307	# <CJK>
ABFD 62F1	# <CJK>
ABFE 62F7	# <CJK>
AC40 62EF	# <CJK>
AC41 62EC	# <CJK>
AC42 62FE	# <CJK>
AC43 62F4	# <CJK>
AC44 6311	# <CJK>
AC45 6302	# <CJK>
AC46 653F	# <CJK>
AC47 6545	# <CJK>
AC48 65AB	# <CJK>
AC49 65BD	# <CJK>
AC4A 65E2	# <CJK>
AC4B 6625	# <CJK>
AC4C 662D	# <CJK>
AC4D 6620	# <CJK>
AC4E 6627	# <CJK>
AC4F 662F	# <CJK>
AC50 661F	# <CJK>
AC51 6628	# <CJK>
AC52 6631	# <CJK>
AC53 6624	# <CJK>
AC54 66F7	# <CJK>
AC55 67FF	# <CJK>
AC56 67D3	# <CJK>
AC57 67F1	# <CJK>
AC58 67D4	# <CJK>
AC59 67D0	# <CJK>
AC5A 67EC	# <CJK>
AC5B 67B6	# <CJK>
AC5C 67AF	# <CJK>
AC5D 67F5	# <CJK>
AC5E 67E9	# <CJK>
AC5F 67EF	# <CJK>
AC60 67C4	# <CJK>
AC61 67D1	# <CJK>
AC62 67B4	# <CJK>
AC63 67DA	# <CJK>
AC64 67E5	# <CJK>
AC65 67B8	# <CJK>
AC66 67CF	# <CJK>
AC67 67DE	# <CJK>
AC68 67F3	# <CJK>
AC69 67B0	# <CJK>
AC6A 67D9	# <CJK>
AC6B 67E2	# <CJK>
AC6C 67DD	# <CJK>
AC6D 67D2	# <CJK>
AC6E 6B6A	# <CJK>
AC6F 6B83	# <CJK>
AC70 6B86	# <CJK>
AC71 6BB5	# <CJK>
AC72 6BD2	# <CJK>
AC73 6BD7	# <CJK>
AC74 6C1F	# <CJK>
AC75 6CC9	# <CJK>
AC76 6D0B	# <CJK>
AC77 6D32	# <CJK>
AC78 6D2A	# <CJK>
AC79 6D41	# <CJK>
AC7A 6D25	# <CJK>
AC7B 6D0C	# <CJK>
AC7C 6D31	# <CJK>
AC7D 6D1E	# <CJK>
AC7E 6D17	# <CJK>
ACA1 6D3B	# <CJK>
ACA2 6D3D	# <CJK>
ACA3 6D3E	# <CJK>
ACA4 6D36	# <CJK>
ACA5 6D1B	# <CJK>
ACA6 6CF5	# <CJK>
ACA7 6D39	# <CJK>
ACA8 6D27	# <CJK>
ACA9 6D38	# <CJK>
ACAA 6D29	# <CJK>
ACAB 6D2E	# <CJK>
ACAC 6D35	# <CJK>
ACAD 6D0E	# <CJK>
ACAE 6D2B	# <CJK>
ACAF 70AB	# <CJK>
ACB0 70BA	# <CJK>
ACB1 70B3	# <CJK>
ACB2 70AC	# <CJK>
ACB3 70AF	# <CJK>
ACB4 70AD	# <CJK>
ACB5 70B8	# <CJK>
ACB6 70AE	# <CJK>
ACB7 70A4	# <CJK>
ACB8 7230	# <CJK>
ACB9 7272	# <CJK>
ACBA 726F	# <CJK>
ACBB 7274	# <CJK>
ACBC 72E9	# <CJK>
ACBD 72E0	# <CJK>
ACBE 72E1	# <CJK>
ACBF 73B7	# <CJK>
ACC0 73CA	# <CJK>
ACC1 73BB	# <CJK>
ACC2 73B2	# <CJK>
ACC3 73CD	# <CJK>
ACC4 73C0	# <CJK>
ACC5 73B3	# <CJK>
ACC6 751A	# <CJK>
ACC7 752D	# <CJK>
ACC8 754F	# <CJK>
ACC9 754C	# <CJK>
ACCA 754E	# <CJK>
ACCB 754B	# <CJK>
ACCC 75AB	# <CJK>
ACCD 75A4	# <CJK>
ACCE 75A5	# <CJK>
ACCF 75A2	# <CJK>
ACD0 75A3	# <CJK>
ACD1 7678	# <CJK>
ACD2 7686	# <CJK>
ACD3 7687	# <CJK>
ACD4 7688	# <CJK>
ACD5 76C8	# <CJK>
ACD6 76C6	# <CJK>
ACD7 76C3	# <CJK>
ACD8 76C5	# <CJK>
ACD9 7701	# <CJK>
ACDA 76F9	# <CJK>
ACDB 76F8	# <CJK>
ACDC 7709	# <CJK>
ACDD 770B	# <CJK>
ACDE 76FE	# <CJK>
ACDF 76FC	# <CJK>
ACE0 7707	# <CJK>
ACE1 77DC	# <CJK>
ACE2 7802	# <CJK>
ACE3 7814	# <CJK>
ACE4 780C	# <CJK>
ACE5 780D	# <CJK>
ACE6 7946	# <CJK>
ACE7 7949	# <CJK>
ACE8 7948	# <CJK>
ACE9 7947	# <CJK>
ACEA 79B9	# <CJK>
ACEB 79BA	# <CJK>
ACEC 79D1	# <CJK>
ACED 79D2	# <CJK>
ACEE 79CB	# <CJK>
ACEF 7A7F	# <CJK>
ACF0 7A81	# <CJK>
ACF1 7AFF	# <CJK>
ACF2 7AFD	# <CJK>
ACF3 7C7D	# <CJK>
ACF4 7D02	# <CJK>
ACF5 7D05	# <CJK>
ACF6 7D00	# <CJK>
ACF7 7D09	# <CJK>
ACF8 7D07	# <CJK>
ACF9 7D04	# <CJK>
ACFA 7D06	# <CJK>
ACFB 7F38	# <CJK>
ACFC 7F8E	# <CJK>
ACFD 7FBF	# <CJK>
ACFE 8004	# <CJK>
AD40 8010	# <CJK>
AD41 800D	# <CJK>
AD42 8011	# <CJK>
AD43 8036	# <CJK>
AD44 80D6	# <CJK>
AD45 80E5	# <CJK>
AD46 80DA	# <CJK>
AD47 80C3	# <CJK>
AD48 80C4	# <CJK>
AD49 80CC	# <CJK>
AD4A 80E1	# <CJK>
AD4B 80DB	# <CJK>
AD4C 80CE	# <CJK>
AD4D 80DE	# <CJK>
AD4E 80E4	# <CJK>
AD4F 80DD	# <CJK>
AD50 81F4	# <CJK>
AD51 8222	# <CJK>
AD52 82E7	# <CJK>
AD53 8303	# <CJK>
AD54 8305	# <CJK>
AD55 82E3	# <CJK>
AD56 82DB	# <CJK>
AD57 82E6	# <CJK>
AD58 8304	# <CJK>
AD59 82E5	# <CJK>
AD5A 8302	# <CJK>
AD5B 8309	# <CJK>
AD5C 82D2	# <CJK>
AD5D 82D7	# <CJK>
AD5E 82F1	# <CJK>
AD5F 8301	# <CJK>
AD60 82DC	# <CJK>
AD61 82D4	# <CJK>
AD62 82D1	# <CJK>
AD63 82DE	# <CJK>
AD64 82D3	# <CJK>
AD65 82DF	# <CJK>
AD66 82EF	# <CJK>
AD67 8306	# <CJK>
AD68 8650	# <CJK>
AD69 8679	# <CJK>
AD6A 867B	# <CJK>
AD6B 867A	# <CJK>
AD6C 884D	# <CJK>
AD6D 886B	# <CJK>
AD6E 8981	# <CJK>
AD6F 89D4	# <CJK>
AD70 8A08	# <CJK>
AD71 8A02	# <CJK>
AD72 8A03	# <CJK>
AD73 8C9E	# <CJK>
AD74 8CA0	# <CJK>
AD75 8D74	# <CJK>
AD76 8D73	# <CJK>
AD77 8DB4	# <CJK>
AD78 8ECD	# <CJK>
AD79 8ECC	# <CJK>
AD7A 8FF0	# <CJK>
AD7B 8FE6	# <CJK>
AD7C 8FE2	# <CJK>
AD7D 8FEA	# <CJK>
AD7E 8FE5	# <CJK>
ADA1 8FED	# <CJK>
ADA2 8FEB	# <CJK>
ADA3 8FE4	# <CJK>
ADA4 8FE8	# <CJK>
ADA5 90CA	# <CJK>
ADA6 90CE	# <CJK>
ADA7 90C1	# <CJK>
ADA8 90C3	# <CJK>
ADA9 914B	# <CJK>
ADAA 914A	# <CJK>
ADAB 91CD	# <CJK>
ADAC 9582	# <CJK>
ADAD 9650	# <CJK>
ADAE 964B	# <CJK>
ADAF 964C	# <CJK>
ADB0 964D	# <CJK>
ADB1 9762	# <CJK>
ADB2 9769	# <CJK>
ADB3 97CB	# <CJK>
ADB4 97ED	# <CJK>
ADB5 97F3	# <CJK>
ADB6 9801	# <CJK>
ADB7 98A8	# <CJK>
ADB8 98DB	# <CJK>
ADB9 98DF	# <CJK>
ADBA 9996	# <CJK>
ADBB 9999	# <CJK>
ADBC 4E58	# <CJK>
ADBD 4EB3	# <CJK>
ADBE 500C	# <CJK>
ADBF 500D	# <CJK>
ADC0 5023	# <CJK>
ADC1 4FEF	# <CJK>
ADC2 5026	# <CJK>
ADC3 5025	# <CJK>
ADC4 4FF8	# <CJK>
ADC5 5029	# <CJK>
ADC6 5016	# <CJK>
ADC7 5006	# <CJK>
ADC8 503C	# <CJK>
ADC9 501F	# <CJK>
ADCA 501A	# <CJK>
ADCB 5012	# <CJK>
ADCC 5011	# <CJK>
ADCD 4FFA	# <CJK>
ADCE 5000	# <CJK>
ADCF 5014	# <CJK>
ADD0 5028	# <CJK>
ADD1 4FF1	# <CJK>
ADD2 5021	# <CJK>
ADD3 500B	# <CJK>
ADD4 5019	# <CJK>
ADD5 5018	# <CJK>
ADD6 4FF3	# <CJK>
ADD7 4FEE	# <CJK>
ADD8 502D	# <CJK>
ADD9 502A	# <CJK>
ADDA 4FFE	# <CJK>
ADDB 502B	# <CJK>
ADDC 5009	# <CJK>
ADDD 517C	# <CJK>
ADDE 51A4	# <CJK>
ADDF 51A5	# <CJK>
ADE0 51A2	# <CJK>
ADE1 51CD	# <CJK>
ADE2 51CC	# <CJK>
ADE3 51C6	# <CJK>
ADE4 51CB	# <CJK>
ADE5 5256	# <CJK>
ADE6 525C	# <CJK>
ADE7 5254	# <CJK>
ADE8 525B	# <CJK>
ADE9 525D	# <CJK>
ADEA 532A	# <CJK>
ADEB 537F	# <CJK>
ADEC 539F	# <CJK>
ADED 539D	# <CJK>
ADEE 53DF	# <CJK>
ADEF 54E8	# <CJK>
ADF0 5510	# <CJK>
ADF1 5501	# <CJK>
ADF2 5537	# <CJK>
ADF3 54FC	# <CJK>
ADF4 54E5	# <CJK>
ADF5 54F2	# <CJK>
ADF6 5506	# <CJK>
ADF7 54FA	# <CJK>
ADF8 5514	# <CJK>
ADF9 54E9	# <CJK>
ADFA 54ED	# <CJK>
ADFB 54E1	# <CJK>
ADFC 5509	# <CJK>
ADFD 54EE	# <CJK>
ADFE 54EA	# <CJK>
AE40 54E6	# <CJK>
AE41 5527	# <CJK>
AE42 5507	# <CJK>
AE43 54FD	# <CJK>
AE44 550F	# <CJK>
AE45 5703	# <CJK>
AE46 5704	# <CJK>
AE47 57C2	# <CJK>
AE48 57D4	# <CJK>
AE49 57CB	# <CJK>
AE4A 57C3	# <CJK>
AE4B 5809	# <CJK>
AE4C 590F	# <CJK>
AE4D 5957	# <CJK>
AE4E 5958	# <CJK>
AE4F 595A	# <CJK>
AE50 5A11	# <CJK>
AE51 5A18	# <CJK>
AE52 5A1C	# <CJK>
AE53 5A1F	# <CJK>
AE54 5A1B	# <CJK>
AE55 5A13	# <CJK>
AE56 59EC	# <CJK>
AE57 5A20	# <CJK>
AE58 5A23	# <CJK>
AE59 5A29	# <CJK>
AE5A 5A25	# <CJK>
AE5B 5A0C	# <CJK>
AE5C 5A09	# <CJK>
AE5D 5B6B	# <CJK>
AE5E 5C58	# <CJK>
AE5F 5BB0	# <CJK>
AE60 5BB3	# <CJK>
AE61 5BB6	# <CJK>
AE62 5BB4	# <CJK>
AE63 5BAE	# <CJK>
AE64 5BB5	# <CJK>
AE65 5BB9	# <CJK>
AE66 5BB8	# <CJK>
AE67 5C04	# <CJK>
AE68 5C51	# <CJK>
AE69 5C55	# <CJK>
AE6A 5C50	# <CJK>
AE6B 5CED	# <CJK>
AE6C 5CFD	# <CJK>
AE6D 5CFB	# <CJK>
AE6E 5CEA	# <CJK>
AE6F 5CE8	# <CJK>
AE70 5CF0	# <CJK>
AE71 5CF6	# <CJK>
AE72 5D01	# <CJK>
AE73 5CF4	# <CJK>
AE74 5DEE	# <CJK>
AE75 5E2D	# <CJK>
AE76 5E2B	# <CJK>
AE77 5EAB	# <CJK>
AE78 5EAD	# <CJK>
AE79 5EA7	# <CJK>
AE7A 5F31	# <CJK>
AE7B 5F92	# <CJK>
AE7C 5F91	# <CJK>
AE7D 5F90	# <CJK>
AE7E 6059	# <CJK>
AEA1 6063	# <CJK>
AEA2 6065	# <CJK>
AEA3 6050	# <CJK>
AEA4 6055	# <CJK>
AEA5 606D	# <CJK>
AEA6 6069	# <CJK>
AEA7 606F	# <CJK>
AEA8 6084	# <CJK>
AEA9 609F	# <CJK>
AEAA 609A	# <CJK>
AEAB 608D	# <CJK>
AEAC 6094	# <CJK>
AEAD 608C	# <CJK>
AEAE 6085	# <CJK>
AEAF 6096	# <CJK>
AEB0 6247	# <CJK>
AEB1 62F3	# <CJK>
AEB2 6308	# <CJK>
AEB3 62FF	# <CJK>
AEB4 634E	# <CJK>
AEB5 633E	# <CJK>
AEB6 632F	# <CJK>
AEB7 6355	# <CJK>
AEB8 6342	# <CJK>
AEB9 6346	# <CJK>
AEBA 634F	# <CJK>
AEBB 6349	# <CJK>
AEBC 633A	# <CJK>
AEBD 6350	# <CJK>
AEBE 633D	# <CJK>
AEBF 632A	# <CJK>
AEC0 632B	# <CJK>
AEC1 6328	# <CJK>
AEC2 634D	# <CJK>
AEC3 634C	# <CJK>
AEC4 6548	# <CJK>
AEC5 6549	# <CJK>
AEC6 6599	# <CJK>
AEC7 65C1	# <CJK>
AEC8 65C5	# <CJK>
AEC9 6642	# <CJK>
AECA 6649	# <CJK>
AECB 664F	# <CJK>
AECC 6643	# <CJK>
AECD 6652	# <CJK>
AECE 664C	# <CJK>
AECF 6645	# <CJK>
AED0 6641	# <CJK>
AED1 66F8	# <CJK>
AED2 6714	# <CJK>
AED3 6715	# <CJK>
AED4 6717	# <CJK>
AED5 6821	# <CJK>
AED6 6838	# <CJK>
AED7 6848	# <CJK>
AED8 6846	# <CJK>
AED9 6853	# <CJK>
AEDA 6839	# <CJK>
AEDB 6842	# <CJK>
AEDC 6854	# <CJK>
AEDD 6829	# <CJK>
AEDE 68B3	# <CJK>
AEDF 6817	# <CJK>
AEE0 684C	# <CJK>
AEE1 6851	# <CJK>
AEE2 683D	# <CJK>
AEE3 67F4	# <CJK>
AEE4 6850	# <CJK>
AEE5 6840	# <CJK>
AEE6 683C	# <CJK>
AEE7 6843	# <CJK>
AEE8 682A	# <CJK>
AEE9 6845	# <CJK>
AEEA 6813	# <CJK>
AEEB 6818	# <CJK>
AEEC 6841	# <CJK>
AEED 6B8A	# <CJK>
AEEE 6B89	# <CJK>
AEEF 6BB7	# <CJK>
AEF0 6C23	# <CJK>
AEF1 6C27	# <CJK>
AEF2 6C28	# <CJK>
AEF3 6C26	# <CJK>
AEF4 6C24	# <CJK>
AEF5 6CF0	# <CJK>
AEF6 6D6A	# <CJK>
AEF7 6D95	# <CJK>
AEF8 6D88	# <CJK>
AEF9 6D87	# <CJK>
AEFA 6D66	# <CJK>
AEFB 6D78	# <CJK>
AEFC 6D77	# <CJK>
AEFD 6D59	# <CJK>
AEFE 6D93	# <CJK>
AF40 6D6C	# <CJK>
AF41 6D89	# <CJK>
AF42 6D6E	# <CJK>
AF43 6D5A	# <CJK>
AF44 6D74	# <CJK>
AF45 6D69	# <CJK>
AF46 6D8C	# <CJK>
AF47 6D8A	# <CJK>
AF48 6D79	# <CJK>
AF49 6D85	# <CJK>
AF4A 6D65	# <CJK>
AF4B 6D94	# <CJK>
AF4C 70CA	# <CJK>
AF4D 70D8	# <CJK>
AF4E 70E4	# <CJK>
AF4F 70D9	# <CJK>
AF50 70C8	# <CJK>
AF51 70CF	# <CJK>
AF52 7239	# <CJK>
AF53 7279	# <CJK>
AF54 72FC	# <CJK>
AF55 72F9	# <CJK>
AF56 72FD	# <CJK>
AF57 72F8	# <CJK>
AF58 72F7	# <CJK>
AF59 7386	# <CJK>
AF5A 73ED	# <CJK>
AF5B 7409	# <CJK>
AF5C 73EE	# <CJK>
AF5D 73E0	# <CJK>
AF5E 73EA	# <CJK>
AF5F 73DE	# <CJK>
AF60 7554	# <CJK>
AF61 755D	# <CJK>
AF62 755C	# <CJK>
AF63 755A	# <CJK>
AF64 7559	# <CJK>
AF65 75BE	# <CJK>
AF66 75C5	# <CJK>
AF67 75C7	# <CJK>
AF68 75B2	# <CJK>
AF69 75B3	# <CJK>
AF6A 75BD	# <CJK>
AF6B 75BC	# <CJK>
AF6C 75B9	# <CJK>
AF6D 75C2	# <CJK>
AF6E 75B8	# <CJK>
AF6F 768B	# <CJK>
AF70 76B0	# <CJK>
AF71 76CA	# <CJK>
AF72 76CD	# <CJK>
AF73 76CE	# <CJK>
AF74 7729	# <CJK>
AF75 771F	# <CJK>
AF76 7720	# <CJK>
AF77 7728	# <CJK>
AF78 77E9	# <CJK>
AF79 7830	# <CJK>
AF7A 7827	# <CJK>
AF7B 7838	# <CJK>
AF7C 781D	# <CJK>
AF7D 7834	# <CJK>
AF7E 7837	# <CJK>
AFA1 7825	# <CJK>
AFA2 782D	# <CJK>
AFA3 7820	# <CJK>
AFA4 781F	# <CJK>
AFA5 7832	# <CJK>
AFA6 7955	# <CJK>
AFA7 7950	# <CJK>
AFA8 7960	# <CJK>
AFA9 795F	# <CJK>
AFAA 7956	# <CJK>
AFAB 795E	# <CJK>
AFAC 795D	# <CJK>
AFAD 7957	# <CJK>
AFAE 795A	# <CJK>
AFAF 79E4	# <CJK>
AFB0 79E3	# <CJK>
AFB1 79E7	# <CJK>
AFB2 79DF	# <CJK>
AFB3 79E6	# <CJK>
AFB4 79E9	# <CJK>
AFB5 79D8	# <CJK>
AFB6 7A84	# <CJK>
AFB7 7A88	# <CJK>
AFB8 7AD9	# <CJK>
AFB9 7B06	# <CJK>
AFBA 7B11	# <CJK>
AFBB 7C89	# <CJK>
AFBC 7D21	# <CJK>
AFBD 7D17	# <CJK>
AFBE 7D0B	# <CJK>
AFBF 7D0A	# <CJK>
AFC0 7D20	# <CJK>
AFC1 7D22	# <CJK>
AFC2 7D14	# <CJK>
AFC3 7D10	# <CJK>
AFC4 7D15	# <CJK>
AFC5 7D1A	# <CJK>
AFC6 7D1C	# <CJK>
AFC7 7D0D	# <CJK>
AFC8 7D19	# <CJK>
AFC9 7D1B	# <CJK>
AFCA 7F3A	# <CJK>
AFCB 7F5F	# <CJK>
AFCC 7F94	# <CJK>
AFCD 7FC5	# <CJK>
AFCE 7FC1	# <CJK>
AFCF 8006	# <CJK>
AFD0 8018	# <CJK>
AFD1 8015	# <CJK>
AFD2 8019	# <CJK>
AFD3 8017	# <CJK>
AFD4 803D	# <CJK>
AFD5 803F	# <CJK>
AFD6 80F1	# <CJK>
AFD7 8102	# <CJK>
AFD8 80F0	# <CJK>
AFD9 8105	# <CJK>
AFDA 80ED	# <CJK>
AFDB 80F4	# <CJK>
AFDC 8106	# <CJK>
AFDD 80F8	# <CJK>
AFDE 80F3	# <CJK>
AFDF 8108	# <CJK>
AFE0 80FD	# <CJK>
AFE1 810A	# <CJK>
AFE2 80FC	# <CJK>
AFE3 80EF	# <CJK>
AFE4 81ED	# <CJK>
AFE5 81EC	# <CJK>
AFE6 8200	# <CJK>
AFE7 8210	# <CJK>
AFE8 822A	# <CJK>
AFE9 822B	# <CJK>
AFEA 8228	# <CJK>
AFEB 822C	# <CJK>
AFEC 82BB	# <CJK>
AFED 832B	# <CJK>
AFEE 8352	# <CJK>
AFEF 8354	# <CJK>
AFF0 834A	# <CJK>
AFF1 8338	# <CJK>
AFF2 8350	# <CJK>
AFF3 8349	# <CJK>
AFF4 8335	# <CJK>
AFF5 8334	# <CJK>
AFF6 834F	# <CJK>
AFF7 8332	# <CJK>
AFF8 8339	# <CJK>
AFF9 8336	# <CJK>
AFFA 8317	# <CJK>
AFFB 8340	# <CJK>
AFFC 8331	# <CJK>
AFFD 8328	# <CJK>
AFFE 8343	# <CJK>
B040 8654	# <CJK>
B041 868A	# <CJK>
B042 86AA	# <CJK>
B043 8693	# <CJK>
B044 86A4	# <CJK>
B045 86A9	# <CJK>
B046 868C	# <CJK>
B047 86A3	# <CJK>
B048 869C	# <CJK>
B049 8870	# <CJK>
B04A 8877	# <CJK>
B04B 8881	# <CJK>
B04C 8882	# <CJK>
B04D 887D	# <CJK>
B04E 8879	# <CJK>
B04F 8A18	# <CJK>
B050 8A10	# <CJK>
B051 8A0E	# <CJK>
B052 8A0C	# <CJK>
B053 8A15	# <CJK>
B054 8A0A	# <CJK>
B055 8A17	# <CJK>
B056 8A13	# <CJK>
B057 8A16	# <CJK>
B058 8A0F	# <CJK>
B059 8A11	# <CJK>
B05A 8C48	# <CJK>
B05B 8C7A	# <CJK>
B05C 8C79	# <CJK>
B05D 8CA1	# <CJK>
B05E 8CA2	# <CJK>
B05F 8D77	# <CJK>
B060 8EAC	# <CJK>
B061 8ED2	# <CJK>
B062 8ED4	# <CJK>
B063 8ECF	# <CJK>
B064 8FB1	# <CJK>
B065 9001	# <CJK>
B066 9006	# <CJK>
B067 8FF7	# <CJK>
B068 9000	# <CJK>
B069 8FFA	# <CJK>
B06A 8FF4	# <CJK>
B06B 9003	# <CJK>
B06C 8FFD	# <CJK>
B06D 9005	# <CJK>
B06E 8FF8	# <CJK>
B06F 9095	# <CJK>
B070 90E1	# <CJK>
B071 90DD	# <CJK>
B072 90E2	# <CJK>
B073 9152	# <CJK>
B074 914D	# <CJK>
B075 914C	# <CJK>
B076 91D8	# <CJK>
B077 91DD	# <CJK>
B078 91D7	# <CJK>
B079 91DC	# <CJK>
B07A 91D9	# <CJK>
B07B 9583	# <CJK>
B07C 9662	# <CJK>
B07D 9663	# <CJK>
B07E 9661	# <CJK>
B0A1 965B	# <CJK>
B0A2 965D	# <CJK>
B0A3 9664	# <CJK>
B0A4 9658	# <CJK>
B0A5 965E	# <CJK>
B0A6 96BB	# <CJK>
B0A7 98E2	# <CJK>
B0A8 99AC	# <CJK>
B0A9 9AA8	# <CJK>
B0AA 9AD8	# <CJK>
B0AB 9B25	# <CJK>
B0AC 9B32	# <CJK>
B0AD 9B3C	# <CJK>
B0AE 4E7E	# <CJK>
B0AF 507A	# <CJK>
B0B0 507D	# <CJK>
B0B1 505C	# <CJK>
B0B2 5047	# <CJK>
B0B3 5043	# <CJK>
B0B4 504C	# <CJK>
B0B5 505A	# <CJK>
B0B6 5049	# <CJK>
B0B7 5065	# <CJK>
B0B8 5076	# <CJK>
B0B9 504E	# <CJK>
B0BA 5055	# <CJK>
B0BB 5075	# <CJK>
B0BC 5074	# <CJK>
B0BD 5077	# <CJK>
B0BE 504F	# <CJK>
B0BF 500F	# <CJK>
B0C0 506F	# <CJK>
B0C1 506D	# <CJK>
B0C2 515C	# <CJK>
B0C3 5195	# <CJK>
B0C4 51F0	# <CJK>
B0C5 526A	# <CJK>
B0C6 526F	# <CJK>
B0C7 52D2	# <CJK>
B0C8 52D9	# <CJK>
B0C9 52D8	# <CJK>
B0CA 52D5	# <CJK>
B0CB 5310	# <CJK>
B0CC 530F	# <CJK>
B0CD 5319	# <CJK>
B0CE 533F	# <CJK>
B0CF 5340	# <CJK>
B0D0 533E	# <CJK>
B0D1 53C3	# <CJK>
B0D2 66FC	# <CJK>
B0D3 5546	# <CJK>
B0D4 556A	# <CJK>
B0D5 5566	# <CJK>
B0D6 5544	# <CJK>
B0D7 555E	# <CJK>
B0D8 5561	# <CJK>
B0D9 5543	# <CJK>
B0DA 554A	# <CJK>
B0DB 5531	# <CJK>
B0DC 5556	# <CJK>
B0DD 554F	# <CJK>
B0DE 5555	# <CJK>
B0DF 552F	# <CJK>
B0E0 5564	# <CJK>
B0E1 5538	# <CJK>
B0E2 552E	# <CJK>
B0E3 555C	# <CJK>
B0E4 552C	# <CJK>
B0E5 5563	# <CJK>
B0E6 5533	# <CJK>
B0E7 5541	# <CJK>
B0E8 5557	# <CJK>
B0E9 5708	# <CJK>
B0EA 570B	# <CJK>
B0EB 5709	# <CJK>
B0EC 57DF	# <CJK>
B0ED 5805	# <CJK>
B0EE 580A	# <CJK>
B0EF 5806	# <CJK>
B0F0 57E0	# <CJK>
B0F1 57E4	# <CJK>
B0F2 57FA	# <CJK>
B0F3 5802	# <CJK>
B0F4 5835	# <CJK>
B0F5 57F7	# <CJK>
B0F6 57F9	# <CJK>
B0F7 5920	# <CJK>
B0F8 5962	# <CJK>
B0F9 5A36	# <CJK>
B0FA 5A41	# <CJK>
B0FB 5A49	# <CJK>
B0FC 5A66	# <CJK>
B0FD 5A6A	# <CJK>
B0FE 5A40	# <CJK>
B140 5A3C	# <CJK>
B141 5A62	# <CJK>
B142 5A5A	# <CJK>
B143 5A46	# <CJK>
B144 5A4A	# <CJK>
B145 5B70	# <CJK>
B146 5BC7	# <CJK>
B147 5BC5	# <CJK>
B148 5BC4	# <CJK>
B149 5BC2	# <CJK>
B14A 5BBF	# <CJK>
B14B 5BC6	# <CJK>
B14C 5C09	# <CJK>
B14D 5C08	# <CJK>
B14E 5C07	# <CJK>
B14F 5C60	# <CJK>
B150 5C5C	# <CJK>
B151 5C5D	# <CJK>
B152 5D07	# <CJK>
B153 5D06	# <CJK>
B154 5D0E	# <CJK>
B155 5D1B	# <CJK>
B156 5D16	# <CJK>
B157 5D22	# <CJK>
B158 5D11	# <CJK>
B159 5D29	# <CJK>
B15A 5D14	# <CJK>
B15B 5D19	# <CJK>
B15C 5D24	# <CJK>
B15D 5D27	# <CJK>
B15E 5D17	# <CJK>
B15F 5DE2	# <CJK>
B160 5E38	# <CJK>
B161 5E36	# <CJK>
B162 5E33	# <CJK>
B163 5E37	# <CJK>
B164 5EB7	# <CJK>
B165 5EB8	# <CJK>
B166 5EB6	# <CJK>
B167 5EB5	# <CJK>
B168 5EBE	# <CJK>
B169 5F35	# <CJK>
B16A 5F37	# <CJK>
B16B 5F57	# <CJK>
B16C 5F6C	# <CJK>
B16D 5F69	# <CJK>
B16E 5F6B	# <CJK>
B16F 5F97	# <CJK>
B170 5F99	# <CJK>
B171 5F9E	# <CJK>
B172 5F98	# <CJK>
B173 5FA1	# <CJK>
B174 5FA0	# <CJK>
B175 5F9C	# <CJK>
B176 607F	# <CJK>
B177 60A3	# <CJK>
B178 6089	# <CJK>
B179 60A0	# <CJK>
B17A 60A8	# <CJK>
B17B 60CB	# <CJK>
B17C 60B4	# <CJK>
B17D 60E6	# <CJK>
B17E 60BD	# <CJK>
B1A1 60C5	# <CJK>
B1A2 60BB	# <CJK>
B1A3 60B5	# <CJK>
B1A4 60DC	# <CJK>
B1A5 60BC	# <CJK>
B1A6 60D8	# <CJK>
B1A7 60D5	# <CJK>
B1A8 60C6	# <CJK>
B1A9 60DF	# <CJK>
B1AA 60B8	# <CJK>
B1AB 60DA	# <CJK>
B1AC 60C7	# <CJK>
B1AD 621A	# <CJK>
B1AE 621B	# <CJK>
B1AF 6248	# <CJK>
B1B0 63A0	# <CJK>
B1B1 63A7	# <CJK>
B1B2 6372	# <CJK>
B1B3 6396	# <CJK>
B1B4 63A2	# <CJK>
B1B5 63A5	# <CJK>
B1B6 6377	# <CJK>
B1B7 6367	# <CJK>
B1B8 6398	# <CJK>
B1B9 63AA	# <CJK>
B1BA 6371	# <CJK>
B1BB 63A9	# <CJK>
B1BC 6389	# <CJK>
B1BD 6383	# <CJK>
B1BE 639B	# <CJK>
B1BF 636B	# <CJK>
B1C0 63A8	# <CJK>
B1C1 6384	# <CJK>
B1C2 6388	# <CJK>
B1C3 6399	# <CJK>
B1C4 63A1	# <CJK>
B1C5 63AC	# <CJK>
B1C6 6392	# <CJK>
B1C7 638F	# <CJK>
B1C8 6380	# <CJK>
B1C9 637B	# <CJK>
B1CA 6369	# <CJK>
B1CB 6368	# <CJK>
B1CC 637A	# <CJK>
B1CD 655D	# <CJK>
B1CE 6556	# <CJK>
B1CF 6551	# <CJK>
B1D0 6559	# <CJK>
B1D1 6557	# <CJK>
B1D2 555F	# <CJK>
B1D3 654F	# <CJK>
B1D4 6558	# <CJK>
B1D5 6555	# <CJK>
B1D6 6554	# <CJK>
B1D7 659C	# <CJK>
B1D8 659B	# <CJK>
B1D9 65AC	# <CJK>
B1DA 65CF	# <CJK>
B1DB 65CB	# <CJK>
B1DC 65CC	# <CJK>
B1DD 65CE	# <CJK>
B1DE 665D	# <CJK>
B1DF 665A	# <CJK>
B1E0 6664	# <CJK>
B1E1 6668	# <CJK>
B1E2 6666	# <CJK>
B1E3 665E	# <CJK>
B1E4 66F9	# <CJK>
B1E5 52D7	# <CJK>
B1E6 671B	# <CJK>
B1E7 6881	# <CJK>
B1E8 68AF	# <CJK>
B1E9 68A2	# <CJK>
B1EA 6893	# <CJK>
B1EB 68B5	# <CJK>
B1EC 687F	# <CJK>
B1ED 6876	# <CJK>
B1EE 68B1	# <CJK>
B1EF 68A7	# <CJK>
B1F0 6897	# <CJK>
B1F1 68B0	# <CJK>
B1F2 6883	# <CJK>
B1F3 68C4	# <CJK>
B1F4 68AD	# <CJK>
B1F5 6886	# <CJK>
B1F6 6885	# <CJK>
B1F7 6894	# <CJK>
B1F8 689D	# <CJK>
B1F9 68A8	# <CJK>
B1FA 689F	# <CJK>
B1FB 68A1	# <CJK>
B1FC 6882	# <CJK>
B1FD 6B32	# <CJK>
B1FE 6BBA	# <CJK>
B240 6BEB	# <CJK>
B241 6BEC	# <CJK>
B242 6C2B	# <CJK>
B243 6D8E	# <CJK>
B244 6DBC	# <CJK>
B245 6DF3	# <CJK>
B246 6DD9	# <CJK>
B247 6DB2	# <CJK>
B248 6DE1	# <CJK>
B249 6DCC	# <CJK>
B24A 6DE4	# <CJK>
B24B 6DFB	# <CJK>
B24C 6DFA	# <CJK>
B24D 6E05	# <CJK>
B24E 6DC7	# <CJK>
B24F 6DCB	# <CJK>
B250 6DAF	# <CJK>
B251 6DD1	# <CJK>
B252 6DAE	# <CJK>
B253 6DDE	# <CJK>
B254 6DF9	# <CJK>
B255 6DB8	# <CJK>
B256 6DF7	# <CJK>
B257 6DF5	# <CJK>
B258 6DC5	# <CJK>
B259 6DD2	# <CJK>
B25A 6E1A	# <CJK>
B25B 6DB5	# <CJK>
B25C 6DDA	# <CJK>
B25D 6DEB	# <CJK>
B25E 6DD8	# <CJK>
B25F 6DEA	# <CJK>
B260 6DF1	# <CJK>
B261 6DEE	# <CJK>
B262 6DE8	# <CJK>
B263 6DC6	# <CJK>
B264 6DC4	# <CJK>
B265 6DAA	# <CJK>
B266 6DEC	# <CJK>
B267 6DBF	# <CJK>
B268 6DE6	# <CJK>
B269 70F9	# <CJK>
B26A 7109	# <CJK>
B26B 710A	# <CJK>
B26C 70FD	# <CJK>
B26D 70EF	# <CJK>
B26E 723D	# <CJK>
B26F 727D	# <CJK>
B270 7281	# <CJK>
B271 731C	# <CJK>
B272 731B	# <CJK>
B273 7316	# <CJK>
B274 7313	# <CJK>
B275 7319	# <CJK>
B276 7387	# <CJK>
B277 7405	# <CJK>
B278 740A	# <CJK>
B279 7403	# <CJK>
B27A 7406	# <CJK>
B27B 73FE	# <CJK>
B27C 740D	# <CJK>
B27D 74E0	# <CJK>
B27E 74F6	# <CJK>
B2A1 74F7	# <CJK>
B2A2 751C	# <CJK>
B2A3 7522	# <CJK>
B2A4 7565	# <CJK>
B2A5 7566	# <CJK>
B2A6 7562	# <CJK>
B2A7 7570	# <CJK>
B2A8 758F	# <CJK>
B2A9 75D4	# <CJK>
B2AA 75D5	# <CJK>
B2AB 75B5	# <CJK>
B2AC 75CA	# <CJK>
B2AD 75CD	# <CJK>
B2AE 768E	# <CJK>
B2AF 76D4	# <CJK>
B2B0 76D2	# <CJK>
B2B1 76DB	# <CJK>
B2B2 7737	# <CJK>
B2B3 773E	# <CJK>
B2B4 773C	# <CJK>
B2B5 7736	# <CJK>
B2B6 7738	# <CJK>
B2B7 773A	# <CJK>
B2B8 786B	# <CJK>
B2B9 7843	# <CJK>
B2BA 784E	# <CJK>
B2BB 7965	# <CJK>
B2BC 7968	# <CJK>
B2BD 796D	# <CJK>
B2BE 79FB	# <CJK>
B2BF 7A92	# <CJK>
B2C0 7A95	# <CJK>
B2C1 7B20	# <CJK>
B2C2 7B28	# <CJK>
B2C3 7B1B	# <CJK>
B2C4 7B2C	# <CJK>
B2C5 7B26	# <CJK>
B2C6 7B19	# <CJK>
B2C7 7B1E	# <CJK>
B2C8 7B2E	# <CJK>
B2C9 7C92	# <CJK>
B2CA 7C97	# <CJK>
B2CB 7C95	# <CJK>
B2CC 7D46	# <CJK>
B2CD 7D43	# <CJK>
B2CE 7D71	# <CJK>
B2CF 7D2E	# <CJK>
B2D0 7D39	# <CJK>
B2D1 7D3C	# <CJK>
B2D2 7D40	# <CJK>
B2D3 7D30	# <CJK>
B2D4 7D33	# <CJK>
B2D5 7D44	# <CJK>
B2D6 7D2F	# <CJK>
B2D7 7D42	# <CJK>
B2D8 7D32	# <CJK>
B2D9 7D31	# <CJK>
B2DA 7F3D	# <CJK>
B2DB 7F9E	# <CJK>
B2DC 7F9A	# <CJK>
B2DD 7FCC	# <CJK>
B2DE 7FCE	# <CJK>
B2DF 7FD2	# <CJK>
B2E0 801C	# <CJK>
B2E1 804A	# <CJK>
B2E2 8046	# <CJK>
B2E3 812F	# <CJK>
B2E4 8116	# <CJK>
B2E5 8123	# <CJK>
B2E6 812B	# <CJK>
B2E7 8129	# <CJK>
B2E8 8130	# <CJK>
B2E9 8124	# <CJK>
B2EA 8202	# <CJK>
B2EB 8235	# <CJK>
B2EC 8237	# <CJK>
B2ED 8236	# <CJK>
B2EE 8239	# <CJK>
B2EF 838E	# <CJK>
B2F0 839E	# <CJK>
B2F1 8398	# <CJK>
B2F2 8378	# <CJK>
B2F3 83A2	# <CJK>
B2F4 8396	# <CJK>
B2F5 83BD	# <CJK>
B2F6 83AB	# <CJK>
B2F7 8392	# <CJK>
B2F8 838A	# <CJK>
B2F9 8393	# <CJK>
B2FA 8389	# <CJK>
B2FB 83A0	# <CJK>
B2FC 8377	# <CJK>
B2FD 837B	# <CJK>
B2FE 837C	# <CJK>
B340 8386	# <CJK>
B341 83A7	# <CJK>
B342 8655	# <CJK>
B343 5F6A	# <CJK>
B344 86C7	# <CJK>
B345 86C0	# <CJK>
B346 86B6	# <CJK>
B347 86C4	# <CJK>
B348 86B5	# <CJK>
B349 86C6	# <CJK>
B34A 86CB	# <CJK>
B34B 86B1	# <CJK>
B34C 86AF	# <CJK>
B34D 86C9	# <CJK>
B34E 8853	# <CJK>
B34F 889E	# <CJK>
B350 8888	# <CJK>
B351 88AB	# <CJK>
B352 8892	# <CJK>
B353 8896	# <CJK>
B354 888D	# <CJK>
B355 888B	# <CJK>
B356 8993	# <CJK>
B357 898F	# <CJK>
B358 8A2A	# <CJK>
B359 8A1D	# <CJK>
B35A 8A23	# <CJK>
B35B 8A25	# <CJK>
B35C 8A31	# <CJK>
B35D 8A2D	# <CJK>
B35E 8A1F	# <CJK>
B35F 8A1B	# <CJK>
B360 8A22	# <CJK>
B361 8C49	# <CJK>
B362 8C5A	# <CJK>
B363 8CA9	# <CJK>
B364 8CAC	# <CJK>
B365 8CAB	# <CJK>
B366 8CA8	# <CJK>
B367 8CAA	# <CJK>
B368 8CA7	# <CJK>
B369 8D67	# <CJK>
B36A 8D66	# <CJK>
B36B 8DBE	# <CJK>
B36C 8DBA	# <CJK>
B36D 8EDB	# <CJK>
B36E 8EDF	# <CJK>
B36F 9019	# <CJK>
B370 900D	# <CJK>
B371 901A	# <CJK>
B372 9017	# <CJK>
B373 9023	# <CJK>
B374 901F	# <CJK>
B375 901D	# <CJK>
B376 9010	# <CJK>
B377 9015	# <CJK>
B378 901E	# <CJK>
B379 9020	# <CJK>
B37A 900F	# <CJK>
B37B 9022	# <CJK>
B37C 9016	# <CJK>
B37D 901B	# <CJK>
B37E 9014	# <CJK>
B3A1 90E8	# <CJK>
B3A2 90ED	# <CJK>
B3A3 90FD	# <CJK>
B3A4 9157	# <CJK>
B3A5 91CE	# <CJK>
B3A6 91F5	# <CJK>
B3A7 91E6	# <CJK>
B3A8 91E3	# <CJK>
B3A9 91E7	# <CJK>
B3AA 91ED	# <CJK>
B3AB 91E9	# <CJK>
B3AC 9589	# <CJK>
B3AD 966A	# <CJK>
B3AE 9675	# <CJK>
B3AF 9673	# <CJK>
B3B0 9678	# <CJK>
B3B1 9670	# <CJK>
B3B2 9674	# <CJK>
B3B3 9676	# <CJK>
B3B4 9677	# <CJK>
B3B5 966C	# <CJK>
B3B6 96C0	# <CJK>
B3B7 96EA	# <CJK>
B3B8 96E9	# <CJK>
B3B9 7AE0	# <CJK>
B3BA 7ADF	# <CJK>
B3BB 9802	# <CJK>
B3BC 9803	# <CJK>
B3BD 9B5A	# <CJK>
B3BE 9CE5	# <CJK>
B3BF 9E75	# <CJK>
B3C0 9E7F	# <CJK>
B3C1 9EA5	# <CJK>
B3C2 9EBB	# <CJK>
B3C3 50A2	# <CJK>
B3C4 508D	# <CJK>
B3C5 5085	# <CJK>
B3C6 5099	# <CJK>
B3C7 5091	# <CJK>
B3C8 5080	# <CJK>
B3C9 5096	# <CJK>
B3CA 5098	# <CJK>
B3CB 509A	# <CJK>
B3CC 6700	# <CJK>
B3CD 51F1	# <CJK>
B3CE 5272	# <CJK>
B3CF 5274	# <CJK>
B3D0 5275	# <CJK>
B3D1 5269	# <CJK>
B3D2 52DE	# <CJK>
B3D3 52DD	# <CJK>
B3D4 52DB	# <CJK>
B3D5 535A	# <CJK>
B3D6 53A5	# <CJK>
B3D7 557B	# <CJK>
B3D8 5580	# <CJK>
B3D9 55A7	# <CJK>
B3DA 557C	# <CJK>
B3DB 558A	# <CJK>
B3DC 559D	# <CJK>
B3DD 5598	# <CJK>
B3DE 5582	# <CJK>
B3DF 559C	# <CJK>
B3E0 55AA	# <CJK>
B3E1 5594	# <CJK>
B3E2 5587	# <CJK>
B3E3 558B	# <CJK>
B3E4 5583	# <CJK>
B3E5 55B3	# <CJK>
B3E6 55AE	# <CJK>
B3E7 559F	# <CJK>
B3E8 553E	# <CJK>
B3E9 55B2	# <CJK>
B3EA 559A	# <CJK>
B3EB 55BB	# <CJK>
B3EC 55AC	# <CJK>
B3ED 55B1	# <CJK>
B3EE 557E	# <CJK>
B3EF 5589	# <CJK>
B3F0 55AB	# <CJK>
B3F1 5599	# <CJK>
B3F2 570D	# <CJK>
B3F3 582F	# <CJK>
B3F4 582A	# <CJK>
B3F5 5834	# <CJK>
B3F6 5824	# <CJK>
B3F7 5830	# <CJK>
B3F8 5831	# <CJK>
B3F9 5821	# <CJK>
B3FA 581D	# <CJK>
B3FB 5820	# <CJK>
B3FC 58F9	# <CJK>
B3FD 58FA	# <CJK>
B3FE 5960	# <CJK>
B440 5A77	# <CJK>
B441 5A9A	# <CJK>
B442 5A7F	# <CJK>
B443 5A92	# <CJK>
B444 5A9B	# <CJK>
B445 5AA7	# <CJK>
B446 5B73	# <CJK>
B447 5B71	# <CJK>
B448 5BD2	# <CJK>
B449 5BCC	# <CJK>
B44A 5BD3	# <CJK>
B44B 5BD0	# <CJK>
B44C 5C0A	# <CJK>
B44D 5C0B	# <CJK>
B44E 5C31	# <CJK>
B44F 5D4C	# <CJK>
B450 5D50	# <CJK>
B451 5D34	# <CJK>
B452 5D47	# <CJK>
B453 5DFD	# <CJK>
B454 5E45	# <CJK>
B455 5E3D	# <CJK>
B456 5E40	# <CJK>
B457 5E43	# <CJK>
B458 5E7E	# <CJK>
B459 5ECA	# <CJK>
B45A 5EC1	# <CJK>
B45B 5EC2	# <CJK>
B45C 5EC4	# <CJK>
B45D 5F3C	# <CJK>
B45E 5F6D	# <CJK>
B45F 5FA9	# <CJK>
B460 5FAA	# <CJK>
B461 5FA8	# <CJK>
B462 60D1	# <CJK>
B463 60E1	# <CJK>
B464 60B2	# <CJK>
B465 60B6	# <CJK>
B466 60E0	# <CJK>
B467 611C	# <CJK>
B468 6123	# <CJK>
B469 60FA	# <CJK>
B46A 6115	# <CJK>
B46B 60F0	# <CJK>
B46C 60FB	# <CJK>
B46D 60F4	# <CJK>
B46E 6168	# <CJK>
B46F 60F1	# <CJK>
B470 610E	# <CJK>
B471 60F6	# <CJK>
B472 6109	# <CJK>
B473 6100	# <CJK>
B474 6112	# <CJK>
B475 621F	# <CJK>
B476 6249	# <CJK>
B477 63A3	# <CJK>
B478 638C	# <CJK>
B479 63CF	# <CJK>
B47A 63C0	# <CJK>
B47B 63E9	# <CJK>
B47C 63C9	# <CJK>
B47D 63C6	# <CJK>
B47E 63CD	# <CJK>
B4A1 63D2	# <CJK>
B4A2 63E3	# <CJK>
B4A3 63D0	# <CJK>
B4A4 63E1	# <CJK>
B4A5 63D6	# <CJK>
B4A6 63ED	# <CJK>
B4A7 63EE	# <CJK>
B4A8 6376	# <CJK>
B4A9 63F4	# <CJK>
B4AA 63EA	# <CJK>
B4AB 63DB	# <CJK>
B4AC 6452	# <CJK>
B4AD 63DA	# <CJK>
B4AE 63F9	# <CJK>
B4AF 655E	# <CJK>
B4B0 6566	# <CJK>
B4B1 6562	# <CJK>
B4B2 6563	# <CJK>
B4B3 6591	# <CJK>
B4B4 6590	# <CJK>
B4B5 65AF	# <CJK>
B4B6 666E	# <CJK>
B4B7 6670	# <CJK>
B4B8 6674	# <CJK>
B4B9 6676	# <CJK>
B4BA 666F	# <CJK>
B4BB 6691	# <CJK>
B4BC 667A	# <CJK>
B4BD 667E	# <CJK>
B4BE 6677	# <CJK>
B4BF 66FE	# <CJK>
B4C0 66FF	# <CJK>
B4C1 671F	# <CJK>
B4C2 671D	# <CJK>
B4C3 68FA	# <CJK>
B4C4 68D5	# <CJK>
B4C5 68E0	# <CJK>
B4C6 68D8	# <CJK>
B4C7 68D7	# <CJK>
B4C8 6905	# <CJK>
B4C9 68DF	# <CJK>
B4CA 68F5	# <CJK>
B4CB 68EE	# <CJK>
B4CC 68E7	# <CJK>
B4CD 68F9	# <CJK>
B4CE 68D2	# <CJK>
B4CF 68F2	# <CJK>
B4D0 68E3	# <CJK>
B4D1 68CB	# <CJK>
B4D2 68CD	# <CJK>
B4D3 690D	# <CJK>
B4D4 6912	# <CJK>
B4D5 690E	# <CJK>
B4D6 68C9	# <CJK>
B4D7 68DA	# <CJK>
B4D8 696E	# <CJK>
B4D9 68FB	# <CJK>
B4DA 6B3E	# <CJK>
B4DB 6B3A	# <CJK>
B4DC 6B3D	# <CJK>
B4DD 6B98	# <CJK>
B4DE 6B96	# <CJK>
B4DF 6BBC	# <CJK>
B4E0 6BEF	# <CJK>
B4E1 6C2E	# <CJK>
B4E2 6C2F	# <CJK>
B4E3 6C2C	# <CJK>
B4E4 6E2F	# <CJK>
B4E5 6E38	# <CJK>
B4E6 6E54	# <CJK>
B4E7 6E21	# <CJK>
B4E8 6E32	# <CJK>
B4E9 6E67	# <CJK>
B4EA 6E4A	# <CJK>
B4EB 6E20	# <CJK>
B4EC 6E25	# <CJK>
B4ED 6E23	# <CJK>
B4EE 6E1B	# <CJK>
B4EF 6E5B	# <CJK>
B4F0 6E58	# <CJK>
B4F1 6E24	# <CJK>
B4F2 6E56	# <CJK>
B4F3 6E6E	# <CJK>
B4F4 6E2D	# <CJK>
B4F5 6E26	# <CJK>
B4F6 6E6F	# <CJK>
B4F7 6E34	# <CJK>
B4F8 6E4D	# <CJK>
B4F9 6E3A	# <CJK>
B4FA 6E2C	# <CJK>
B4FB 6E43	# <CJK>
B4FC 6E1D	# <CJK>
B4FD 6E3E	# <CJK>
B4FE 6ECB	# <CJK>
B540 6E89	# <CJK>
B541 6E19	# <CJK>
B542 6E4E	# <CJK>
B543 6E63	# <CJK>
B544 6E44	# <CJK>
B545 6E72	# <CJK>
B546 6E69	# <CJK>
B547 6E5F	# <CJK>
B548 7119	# <CJK>
B549 711A	# <CJK>
B54A 7126	# <CJK>
B54B 7130	# <CJK>
B54C 7121	# <CJK>
B54D 7136	# <CJK>
B54E 716E	# <CJK>
B54F 711C	# <CJK>
B550 724C	# <CJK>
B551 7284	# <CJK>
B552 7280	# <CJK>
B553 7336	# <CJK>
B554 7325	# <CJK>
B555 7334	# <CJK>
B556 7329	# <CJK>
B557 743A	# <CJK>
B558 742A	# <CJK>
B559 7433	# <CJK>
B55A 7422	# <CJK>
B55B 7425	# <CJK>
B55C 7435	# <CJK>
B55D 7436	# <CJK>
B55E 7434	# <CJK>
B55F 742F	# <CJK>
B560 741B	# <CJK>
B561 7426	# <CJK>
B562 7428	# <CJK>
B563 7525	# <CJK>
B564 7526	# <CJK>
B565 756B	# <CJK>
B566 756A	# <CJK>
B567 75E2	# <CJK>
B568 75DB	# <CJK>
B569 75E3	# <CJK>
B56A 75D9	# <CJK>
B56B 75D8	# <CJK>
B56C 75DE	# <CJK>
B56D 75E0	# <CJK>
B56E 767B	# <CJK>
B56F 767C	# <CJK>
B570 7696	# <CJK>
B571 7693	# <CJK>
B572 76B4	# <CJK>
B573 76DC	# <CJK>
B574 774F	# <CJK>
B575 77ED	# <CJK>
B576 785D	# <CJK>
B577 786C	# <CJK>
B578 786F	# <CJK>
B579 7A0D	# <CJK>
B57A 7A08	# <CJK>
B57B 7A0B	# <CJK>
B57C 7A05	# <CJK>
B57D 7A00	# <CJK>
B57E 7A98	# <CJK>
B5A1 7A97	# <CJK>
B5A2 7A96	# <CJK>
B5A3 7AE5	# <CJK>
B5A4 7AE3	# <CJK>
B5A5 7B49	# <CJK>
B5A6 7B56	# <CJK>
B5A7 7B46	# <CJK>
B5A8 7B50	# <CJK>
B5A9 7B52	# <CJK>
B5AA 7B54	# <CJK>
B5AB 7B4D	# <CJK>
B5AC 7B4B	# <CJK>
B5AD 7B4F	# <CJK>
B5AE 7B51	# <CJK>
B5AF 7C9F	# <CJK>
B5B0 7CA5	# <CJK>
B5B1 7D5E	# <CJK>
B5B2 7D50	# <CJK>
B5B3 7D68	# <CJK>
B5B4 7D55	# <CJK>
B5B5 7D2B	# <CJK>
B5B6 7D6E	# <CJK>
B5B7 7D72	# <CJK>
B5B8 7D61	# <CJK>
B5B9 7D66	# <CJK>
B5BA 7D62	# <CJK>
B5BB 7D70	# <CJK>
B5BC 7D73	# <CJK>
B5BD 5584	# <CJK>
B5BE 7FD4	# <CJK>
B5BF 7FD5	# <CJK>
B5C0 800B	# <CJK>
B5C1 8052	# <CJK>
B5C2 8085	# <CJK>
B5C3 8155	# <CJK>
B5C4 8154	# <CJK>
B5C5 814B	# <CJK>
B5C6 8151	# <CJK>
B5C7 814E	# <CJK>
B5C8 8139	# <CJK>
B5C9 8146	# <CJK>
B5CA 813E	# <CJK>
B5CB 814C	# <CJK>
B5CC 8153	# <CJK>
B5CD 8174	# <CJK>
B5CE 8212	# <CJK>
B5CF 821C	# <CJK>
B5D0 83E9	# <CJK>
B5D1 8403	# <CJK>
B5D2 83F8	# <CJK>
B5D3 840D	# <CJK>
B5D4 83E0	# <CJK>
B5D5 83C5	# <CJK>
B5D6 840B	# <CJK>
B5D7 83C1	# <CJK>
B5D8 83EF	# <CJK>
B5D9 83F1	# <CJK>
B5DA 83F4	# <CJK>
B5DB 8457	# <CJK>
B5DC 840A	# <CJK>
B5DD 83F0	# <CJK>
B5DE 840C	# <CJK>
B5DF 83CC	# <CJK>
B5E0 83FD	# <CJK>
B5E1 83F2	# <CJK>
B5E2 83CA	# <CJK>
B5E3 8438	# <CJK>
B5E4 840E	# <CJK>
B5E5 8404	# <CJK>
B5E6 83DC	# <CJK>
B5E7 8407	# <CJK>
B5E8 83D4	# <CJK>
B5E9 83DF	# <CJK>
B5EA 865B	# <CJK>
B5EB 86DF	# <CJK>
B5EC 86D9	# <CJK>
B5ED 86ED	# <CJK>
B5EE 86D4	# <CJK>
B5EF 86DB	# <CJK>
B5F0 86E4	# <CJK>
B5F1 86D0	# <CJK>
B5F2 86DE	# <CJK>
B5F3 8857	# <CJK>
B5F4 88C1	# <CJK>
B5F5 88C2	# <CJK>
B5F6 88B1	# <CJK>
B5F7 8983	# <CJK>
B5F8 8996	# <CJK>
B5F9 8A3B	# <CJK>
B5FA 8A60	# <CJK>
B5FB 8A55	# <CJK>
B5FC 8A5E	# <CJK>
B5FD 8A3C	# <CJK>
B5FE 8A41	# <CJK>
B640 8A54	# <CJK>
B641 8A5B	# <CJK>
B642 8A50	# <CJK>
B643 8A46	# <CJK>
B644 8A34	# <CJK>
B645 8A3A	# <CJK>
B646 8A36	# <CJK>
B647 8A56	# <CJK>
B648 8C61	# <CJK>
B649 8C82	# <CJK>
B64A 8CAF	# <CJK>
B64B 8CBC	# <CJK>
B64C 8CB3	# <CJK>
B64D 8CBD	# <CJK>
B64E 8CC1	# <CJK>
B64F 8CBB	# <CJK>
B650 8CC0	# <CJK>
B651 8CB4	# <CJK>
B652 8CB7	# <CJK>
B653 8CB6	# <CJK>
B654 8CBF	# <CJK>
B655 8CB8	# <CJK>
B656 8D8A	# <CJK>
B657 8D85	# <CJK>
B658 8D81	# <CJK>
B659 8DCE	# <CJK>
B65A 8DDD	# <CJK>
B65B 8DCB	# <CJK>
B65C 8DDA	# <CJK>
B65D 8DD1	# <CJK>
B65E 8DCC	# <CJK>
B65F 8DDB	# <CJK>
B660 8DC6	# <CJK>
B661 8EFB	# <CJK>
B662 8EF8	# <CJK>
B663 8EFC	# <CJK>
B664 8F9C	# <CJK>
B665 902E	# <CJK>
B666 9035	# <CJK>
B667 9031	# <CJK>
B668 9038	# <CJK>
B669 9032	# <CJK>
B66A 9036	# <CJK>
B66B 9102	# <CJK>
B66C 90F5	# <CJK>
B66D 9109	# <CJK>
B66E 90FE	# <CJK>
B66F 9163	# <CJK>
B670 9165	# <CJK>
B671 91CF	# <CJK>
B672 9214	# <CJK>
B673 9215	# <CJK>
B674 9223	# <CJK>
B675 9209	# <CJK>
B676 921E	# <CJK>
B677 920D	# <CJK>
B678 9210	# <CJK>
B679 9207	# <CJK>
B67A 9211	# <CJK>
B67B 9594	# <CJK>
B67C 958F	# <CJK>
B67D 958B	# <CJK>
B67E 9591	# <CJK>
B6A1 9593	# <CJK>
B6A2 9592	# <CJK>
B6A3 958E	# <CJK>
B6A4 968A	# <CJK>
B6A5 968E	# <CJK>
B6A6 968B	# <CJK>
B6A7 967D	# <CJK>
B6A8 9685	# <CJK>
B6A9 9686	# <CJK>
B6AA 968D	# <CJK>
B6AB 9672	# <CJK>
B6AC 9684	# <CJK>
B6AD 96C1	# <CJK>
B6AE 96C5	# <CJK>
B6AF 96C4	# <CJK>
B6B0 96C6	# <CJK>
B6B1 96C7	# <CJK>
B6B2 96EF	# <CJK>
B6B3 96F2	# <CJK>
B6B4 97CC	# <CJK>
B6B5 9805	# <CJK>
B6B6 9806	# <CJK>
B6B7 9808	# <CJK>
B6B8 98E7	# <CJK>
B6B9 98EA	# <CJK>
B6BA 98EF	# <CJK>
B6BB 98E9	# <CJK>
B6BC 98F2	# <CJK>
B6BD 98ED	# <CJK>
B6BE 99AE	# <CJK>
B6BF 99AD	# <CJK>
B6C0 9EC3	# <CJK>
B6C1 9ECD	# <CJK>
B6C2 9ED1	# <CJK>
B6C3 4E82	# <CJK>
B6C4 50AD	# <CJK>
B6C5 50B5	# <CJK>
B6C6 50B2	# <CJK>
B6C7 50B3	# <CJK>
B6C8 50C5	# <CJK>
B6C9 50BE	# <CJK>
B6CA 50AC	# <CJK>
B6CB 50B7	# <CJK>
B6CC 50BB	# <CJK>
B6CD 50AF	# <CJK>
B6CE 50C7	# <CJK>
B6CF 527F	# <CJK>
B6D0 5277	# <CJK>
B6D1 527D	# <CJK>
B6D2 52DF	# <CJK>
B6D3 52E6	# <CJK>
B6D4 52E4	# <CJK>
B6D5 52E2	# <CJK>
B6D6 52E3	# <CJK>
B6D7 532F	# <CJK>
B6D8 55DF	# <CJK>
B6D9 55E8	# <CJK>
B6DA 55D3	# <CJK>
B6DB 55E6	# <CJK>
B6DC 55CE	# <CJK>
B6DD 55DC	# <CJK>
B6DE 55C7	# <CJK>
B6DF 55D1	# <CJK>
B6E0 55E3	# <CJK>
B6E1 55E4	# <CJK>
B6E2 55EF	# <CJK>
B6E3 55DA	# <CJK>
B6E4 55E1	# <CJK>
B6E5 55C5	# <CJK>
B6E6 55C6	# <CJK>
B6E7 55E5	# <CJK>
B6E8 55C9	# <CJK>
B6E9 5712	# <CJK>
B6EA 5713	# <CJK>
B6EB 585E	# <CJK>
B6EC 5851	# <CJK>
B6ED 5858	# <CJK>
B6EE 5857	# <CJK>
B6EF 585A	# <CJK>
B6F0 5854	# <CJK>
B6F1 586B	# <CJK>
B6F2 584C	# <CJK>
B6F3 586D	# <CJK>
B6F4 584A	# <CJK>
B6F5 5862	# <CJK>
B6F6 5852	# <CJK>
B6F7 584B	# <CJK>
B6F8 5967	# <CJK>
B6F9 5AC1	# <CJK>
B6FA 5AC9	# <CJK>
B6FB 5ACC	# <CJK>
B6FC 5ABE	# <CJK>
B6FD 5ABD	# <CJK>
B6FE 5ABC	# <CJK>
B740 5AB3	# <CJK>
B741 5AC2	# <CJK>
B742 5AB2	# <CJK>
B743 5D69	# <CJK>
B744 5D6F	# <CJK>
B745 5E4C	# <CJK>
B746 5E79	# <CJK>
B747 5EC9	# <CJK>
B748 5EC8	# <CJK>
B749 5F12	# <CJK>
B74A 5F59	# <CJK>
B74B 5FAC	# <CJK>
B74C 5FAE	# <CJK>
B74D 611A	# <CJK>
B74E 610F	# <CJK>
B74F 6148	# <CJK>
B750 611F	# <CJK>
B751 60F3	# <CJK>
B752 611B	# <CJK>
B753 60F9	# <CJK>
B754 6101	# <CJK>
B755 6108	# <CJK>
B756 614E	# <CJK>
B757 614C	# <CJK>
B758 6144	# <CJK>
B759 614D	# <CJK>
B75A 613E	# <CJK>
B75B 6134	# <CJK>
B75C 6127	# <CJK>
B75D 610D	# <CJK>
B75E 6106	# <CJK>
B75F 6137	# <CJK>
B760 6221	# <CJK>
B761 6222	# <CJK>
B762 6413	# <CJK>
B763 643E	# <CJK>
B764 641E	# <CJK>
B765 642A	# <CJK>
B766 642D	# <CJK>
B767 643D	# <CJK>
B768 642C	# <CJK>
B769 640F	# <CJK>
B76A 641C	# <CJK>
B76B 6414	# <CJK>
B76C 640D	# <CJK>
B76D 6436	# <CJK>
B76E 6416	# <CJK>
B76F 6417	# <CJK>
B770 6406	# <CJK>
B771 656C	# <CJK>
B772 659F	# <CJK>
B773 65B0	# <CJK>
B774 6697	# <CJK>
B775 6689	# <CJK>
B776 6687	# <CJK>
B777 6688	# <CJK>
B778 6696	# <CJK>
B779 6684	# <CJK>
B77A 6698	# <CJK>
B77B 668D	# <CJK>
B77C 6703	# <CJK>
B77D 6994	# <CJK>
B77E 696D	# <CJK>
B7A1 695A	# <CJK>
B7A2 6977	# <CJK>
B7A3 6960	# <CJK>
B7A4 6954	# <CJK>
B7A5 6975	# <CJK>
B7A6 6930	# <CJK>
B7A7 6982	# <CJK>
B7A8 694A	# <CJK>
B7A9 6968	# <CJK>
B7AA 696B	# <CJK>
B7AB 695E	# <CJK>
B7AC 6953	# <CJK>
B7AD 6979	# <CJK>
B7AE 6986	# <CJK>
B7AF 695D	# <CJK>
B7B0 6963	# <CJK>
B7B1 695B	# <CJK>
B7B2 6B47	# <CJK>
B7B3 6B72	# <CJK>
B7B4 6BC0	# <CJK>
B7B5 6BBF	# <CJK>
B7B6 6BD3	# <CJK>
B7B7 6BFD	# <CJK>
B7B8 6EA2	# <CJK>
B7B9 6EAF	# <CJK>
B7BA 6ED3	# <CJK>
B7BB 6EB6	# <CJK>
B7BC 6EC2	# <CJK>
B7BD 6E90	# <CJK>
B7BE 6E9D	# <CJK>
B7BF 6EC7	# <CJK>
B7C0 6EC5	# <CJK>
B7C1 6EA5	# <CJK>
B7C2 6E98	# <CJK>
B7C3 6EBC	# <CJK>
B7C4 6EBA	# <CJK>
B7C5 6EAB	# <CJK>
B7C6 6ED1	# <CJK>
B7C7 6E96	# <CJK>
B7C8 6E9C	# <CJK>
B7C9 6EC4	# <CJK>
B7CA 6ED4	# <CJK>
B7CB 6EAA	# <CJK>
B7CC 6EA7	# <CJK>
B7CD 6EB4	# <CJK>
B7CE 714E	# <CJK>
B7CF 7159	# <CJK>
B7D0 7169	# <CJK>
B7D1 7164	# <CJK>
B7D2 7149	# <CJK>
B7D3 7167	# <CJK>
B7D4 715C	# <CJK>
B7D5 716C	# <CJK>
B7D6 7166	# <CJK>
B7D7 714C	# <CJK>
B7D8 7165	# <CJK>
B7D9 715E	# <CJK>
B7DA 7146	# <CJK>
B7DB 7168	# <CJK>
B7DC 7156	# <CJK>
B7DD 723A	# <CJK>
B7DE 7252	# <CJK>
B7DF 7337	# <CJK>
B7E0 7345	# <CJK>
B7E1 733F	# <CJK>
B7E2 733E	# <CJK>
B7E3 746F	# <CJK>
B7E4 745A	# <CJK>
B7E5 7455	# <CJK>
B7E6 745F	# <CJK>
B7E7 745E	# <CJK>
B7E8 7441	# <CJK>
B7E9 743F	# <CJK>
B7EA 7459	# <CJK>
B7EB 745B	# <CJK>
B7EC 745C	# <CJK>
B7ED 7576	# <CJK>
B7EE 7578	# <CJK>
B7EF 7600	# <CJK>
B7F0 75F0	# <CJK>
B7F1 7601	# <CJK>
B7F2 75F2	# <CJK>
B7F3 75F1	# <CJK>
B7F4 75FA	# <CJK>
B7F5 75FF	# <CJK>
B7F6 75F4	# <CJK>
B7F7 75F3	# <CJK>
B7F8 76DE	# <CJK>
B7F9 76DF	# <CJK>
B7FA 775B	# <CJK>
B7FB 776B	# <CJK>
B7FC 7766	# <CJK>
B7FD 775E	# <CJK>
B7FE 7763	# <CJK>
B840 7779	# <CJK>
B841 776A	# <CJK>
B842 776C	# <CJK>
B843 775C	# <CJK>
B844 7765	# <CJK>
B845 7768	# <CJK>
B846 7762	# <CJK>
B847 77EE	# <CJK>
B848 788E	# <CJK>
B849 78B0	# <CJK>
B84A 7897	# <CJK>
B84B 7898	# <CJK>
B84C 788C	# <CJK>
B84D 7889	# <CJK>
B84E 787C	# <CJK>
B84F 7891	# <CJK>
B850 7893	# <CJK>
B851 787F	# <CJK>
B852 797A	# <CJK>
B853 797F	# <CJK>
B854 7981	# <CJK>
B855 842C	# <CJK>
B856 79BD	# <CJK>
B857 7A1C	# <CJK>
B858 7A1A	# <CJK>
B859 7A20	# <CJK>
B85A 7A14	# <CJK>
B85B 7A1F	# <CJK>
B85C 7A1E	# <CJK>
B85D 7A9F	# <CJK>
B85E 7AA0	# <CJK>
B85F 7B77	# <CJK>
B860 7BC0	# <CJK>
B861 7B60	# <CJK>
B862 7B6E	# <CJK>
B863 7B67	# <CJK>
B864 7CB1	# <CJK>
B865 7CB3	# <CJK>
B866 7CB5	# <CJK>
B867 7D93	# <CJK>
B868 7D79	# <CJK>
B869 7D91	# <CJK>
B86A 7D81	# <CJK>
B86B 7D8F	# <CJK>
B86C 7D5B	# <CJK>
B86D 7F6E	# <CJK>
B86E 7F69	# <CJK>
B86F 7F6A	# <CJK>
B870 7F72	# <CJK>
B871 7FA9	# <CJK>
B872 7FA8	# <CJK>
B873 7FA4	# <CJK>
B874 8056	# <CJK>
B875 8058	# <CJK>
B876 8086	# <CJK>
B877 8084	# <CJK>
B878 8171	# <CJK>
B879 8170	# <CJK>
B87A 8178	# <CJK>
B87B 8165	# <CJK>
B87C 816E	# <CJK>
B87D 8173	# <CJK>
B87E 816B	# <CJK>
B8A1 8179	# <CJK>
B8A2 817A	# <CJK>
B8A3 8166	# <CJK>
B8A4 8205	# <CJK>
B8A5 8247	# <CJK>
B8A6 8482	# <CJK>
B8A7 8477	# <CJK>
B8A8 843D	# <CJK>
B8A9 8431	# <CJK>
B8AA 8475	# <CJK>
B8AB 8466	# <CJK>
B8AC 846B	# <CJK>
B8AD 8449	# <CJK>
B8AE 846C	# <CJK>
B8AF 845B	# <CJK>
B8B0 843C	# <CJK>
B8B1 8435	# <CJK>
B8B2 8461	# <CJK>
B8B3 8463	# <CJK>
B8B4 8469	# <CJK>
B8B5 846D	# <CJK>
B8B6 8446	# <CJK>
B8B7 865E	# <CJK>
B8B8 865C	# <CJK>
B8B9 865F	# <CJK>
B8BA 86F9	# <CJK>
B8BB 8713	# <CJK>
B8BC 8708	# <CJK>
B8BD 8707	# <CJK>
B8BE 8700	# <CJK>
B8BF 86FE	# <CJK>
B8C0 86FB	# <CJK>
B8C1 8702	# <CJK>
B8C2 8703	# <CJK>
B8C3 8706	# <CJK>
B8C4 870A	# <CJK>
B8C5 8859	# <CJK>
B8C6 88DF	# <CJK>
B8C7 88D4	# <CJK>
B8C8 88D9	# <CJK>
B8C9 88DC	# <CJK>
B8CA 88D8	# <CJK>
B8CB 88DD	# <CJK>
B8CC 88E1	# <CJK>
B8CD 88CA	# <CJK>
B8CE 88D5	# <CJK>
B8CF 88D2	# <CJK>
B8D0 899C	# <CJK>
B8D1 89E3	# <CJK>
B8D2 8A6B	# <CJK>
B8D3 8A72	# <CJK>
B8D4 8A73	# <CJK>
B8D5 8A66	# <CJK>
B8D6 8A69	# <CJK>
B8D7 8A70	# <CJK>
B8D8 8A87	# <CJK>
B8D9 8A7C	# <CJK>
B8DA 8A63	# <CJK>
B8DB 8AA0	# <CJK>
B8DC 8A71	# <CJK>
B8DD 8A85	# <CJK>
B8DE 8A6D	# <CJK>
B8DF 8A62	# <CJK>
B8E0 8A6E	# <CJK>
B8E1 8A6C	# <CJK>
B8E2 8A79	# <CJK>
B8E3 8A7B	# <CJK>
B8E4 8A3E	# <CJK>
B8E5 8A68	# <CJK>
B8E6 8C62	# <CJK>
B8E7 8C8A	# <CJK>
B8E8 8C89	# <CJK>
B8E9 8CCA	# <CJK>
B8EA 8CC7	# <CJK>
B8EB 8CC8	# <CJK>
B8EC 8CC4	# <CJK>
B8ED 8CB2	# <CJK>
B8EE 8CC3	# <CJK>
B8EF 8CC2	# <CJK>
B8F0 8CC5	# <CJK>
B8F1 8DE1	# <CJK>
B8F2 8DDF	# <CJK>
B8F3 8DE8	# <CJK>
B8F4 8DEF	# <CJK>
B8F5 8DF3	# <CJK>
B8F6 8DFA	# <CJK>
B8F7 8DEA	# <CJK>
B8F8 8DE4	# <CJK>
B8F9 8DE6	# <CJK>
B8FA 8EB2	# <CJK>
B8FB 8F03	# <CJK>
B8FC 8F09	# <CJK>
B8FD 8EFE	# <CJK>
B8FE 8F0A	# <CJK>
B940 8F9F	# <CJK>
B941 8FB2	# <CJK>
B942 904B	# <CJK>
B943 904A	# <CJK>
B944 9053	# <CJK>
B945 9042	# <CJK>
B946 9054	# <CJK>
B947 903C	# <CJK>
B948 9055	# <CJK>
B949 9050	# <CJK>
B94A 9047	# <CJK>
B94B 904F	# <CJK>
B94C 904E	# <CJK>
B94D 904D	# <CJK>
B94E 9051	# <CJK>
B94F 903E	# <CJK>
B950 9041	# <CJK>
B951 9112	# <CJK>
B952 9117	# <CJK>
B953 916C	# <CJK>
B954 916A	# <CJK>
B955 9169	# <CJK>
B956 91C9	# <CJK>
B957 9237	# <CJK>
B958 9257	# <CJK>
B959 9238	# <CJK>
B95A 923D	# <CJK>
B95B 9240	# <CJK>
B95C 923E	# <CJK>
B95D 925B	# <CJK>
B95E 924B	# <CJK>
B95F 9264	# <CJK>
B960 9251	# <CJK>
B961 9234	# <CJK>
B962 9249	# <CJK>
B963 924D	# <CJK>
B964 9245	# <CJK>
B965 9239	# <CJK>
B966 923F	# <CJK>
B967 925A	# <CJK>
B968 9598	# <CJK>
B969 9698	# <CJK>
B96A 9694	# <CJK>
B96B 9695	# <CJK>
B96C 96CD	# <CJK>
B96D 96CB	# <CJK>
B96E 96C9	# <CJK>
B96F 96CA	# <CJK>
B970 96F7	# <CJK>
B971 96FB	# <CJK>
B972 96F9	# <CJK>
B973 96F6	# <CJK>
B974 9756	# <CJK>
B975 9774	# <CJK>
B976 9776	# <CJK>
B977 9810	# <CJK>
B978 9811	# <CJK>
B979 9813	# <CJK>
B97A 980A	# <CJK>
B97B 9812	# <CJK>
B97C 980C	# <CJK>
B97D 98FC	# <CJK>
B97E 98F4	# <CJK>
B9A1 98FD	# <CJK>
B9A2 98FE	# <CJK>
B9A3 99B3	# <CJK>
B9A4 99B1	# <CJK>
B9A5 99B4	# <CJK>
B9A6 9AE1	# <CJK>
B9A7 9CE9	# <CJK>
B9A8 9E82	# <CJK>
B9A9 9F0E	# <CJK>
B9AA 9F13	# <CJK>
B9AB 9F20	# <CJK>
B9AC 50E7	# <CJK>
B9AD 50EE	# <CJK>
B9AE 50E5	# <CJK>
B9AF 50D6	# <CJK>
B9B0 50ED	# <CJK>
B9B1 50DA	# <CJK>
B9B2 50D5	# <CJK>
B9B3 50CF	# <CJK>
B9B4 50D1	# <CJK>
B9B5 50F1	# <CJK>
B9B6 50CE	# <CJK>
B9B7 50E9	# <CJK>
B9B8 5162	# <CJK>
B9B9 51F3	# <CJK>
B9BA 5283	# <CJK>
B9BB 5282	# <CJK>
B9BC 5331	# <CJK>
B9BD 53AD	# <CJK>
B9BE 55FE	# <CJK>
B9BF 5600	# <CJK>
B9C0 561B	# <CJK>
B9C1 5617	# <CJK>
B9C2 55FD	# <CJK>
B9C3 5614	# <CJK>
B9C4 5606	# <CJK>
B9C5 5609	# <CJK>
B9C6 560D	# <CJK>
B9C7 560E	# <CJK>
B9C8 55F7	# <CJK>
B9C9 5616	# <CJK>
B9CA 561F	# <CJK>
B9CB 5608	# <CJK>
B9CC 5610	# <CJK>
B9CD 55F6	# <CJK>
B9CE 5718	# <CJK>
B9CF 5716	# <CJK>
B9D0 5875	# <CJK>
B9D1 587E	# <CJK>
B9D2 5883	# <CJK>
B9D3 5893	# <CJK>
B9D4 588A	# <CJK>
B9D5 5879	# <CJK>
B9D6 5885	# <CJK>
B9D7 587D	# <CJK>
B9D8 58FD	# <CJK>
B9D9 5925	# <CJK>
B9DA 5922	# <CJK>
B9DB 5924	# <CJK>
B9DC 596A	# <CJK>
B9DD 5969	# <CJK>
B9DE 5AE1	# <CJK>
B9DF 5AE6	# <CJK>
B9E0 5AE9	# <CJK>
B9E1 5AD7	# <CJK>
B9E2 5AD6	# <CJK>
B9E3 5AD8	# <CJK>
B9E4 5AE3	# <CJK>
B9E5 5B75	# <CJK>
B9E6 5BDE	# <CJK>
B9E7 5BE7	# <CJK>
B9E8 5BE1	# <CJK>
B9E9 5BE5	# <CJK>
B9EA 5BE6	# <CJK>
B9EB 5BE8	# <CJK>
B9EC 5BE2	# <CJK>
B9ED 5BE4	# <CJK>
B9EE 5BDF	# <CJK>
B9EF 5C0D	# <CJK>
B9F0 5C62	# <CJK>
B9F1 5D84	# <CJK>
B9F2 5D87	# <CJK>
B9F3 5E5B	# <CJK>
B9F4 5E63	# <CJK>
B9F5 5E55	# <CJK>
B9F6 5E57	# <CJK>
B9F7 5E54	# <CJK>
B9F8 5ED3	# <CJK>
B9F9 5ED6	# <CJK>
B9FA 5F0A	# <CJK>
B9FB 5F46	# <CJK>
B9FC 5F70	# <CJK>
B9FD 5FB9	# <CJK>
B9FE 6147	# <CJK>
BA40 613F	# <CJK>
BA41 614B	# <CJK>
BA42 6177	# <CJK>
BA43 6162	# <CJK>
BA44 6163	# <CJK>
BA45 615F	# <CJK>
BA46 615A	# <CJK>
BA47 6158	# <CJK>
BA48 6175	# <CJK>
BA49 622A	# <CJK>
BA4A 6487	# <CJK>
BA4B 6458	# <CJK>
BA4C 6454	# <CJK>
BA4D 64A4	# <CJK>
BA4E 6478	# <CJK>
BA4F 645F	# <CJK>
BA50 647A	# <CJK>
BA51 6451	# <CJK>
BA52 6467	# <CJK>
BA53 6434	# <CJK>
BA54 646D	# <CJK>
BA55 647B	# <CJK>
BA56 6572	# <CJK>
BA57 65A1	# <CJK>
BA58 65D7	# <CJK>
BA59 65D6	# <CJK>
BA5A 66A2	# <CJK>
BA5B 66A8	# <CJK>
BA5C 669D	# <CJK>
BA5D 699C	# <CJK>
BA5E 69A8	# <CJK>
BA5F 6995	# <CJK>
BA60 69C1	# <CJK>
BA61 69AE	# <CJK>
BA62 69D3	# <CJK>
BA63 69CB	# <CJK>
BA64 699B	# <CJK>
BA65 69B7	# <CJK>
BA66 69BB	# <CJK>
BA67 69AB	# <CJK>
BA68 69B4	# <CJK>
BA69 69D0	# <CJK>
BA6A 69CD	# <CJK>
BA6B 69AD	# <CJK>
BA6C 69CC	# <CJK>
BA6D 69A6	# <CJK>
BA6E 69C3	# <CJK>
BA6F 69A3	# <CJK>
BA70 6B49	# <CJK>
BA71 6B4C	# <CJK>
BA72 6C33	# <CJK>
BA73 6F33	# <CJK>
BA74 6F14	# <CJK>
BA75 6EFE	# <CJK>
BA76 6F13	# <CJK>
BA77 6EF4	# <CJK>
BA78 6F29	# <CJK>
BA79 6F3E	# <CJK>
BA7A 6F20	# <CJK>
BA7B 6F2C	# <CJK>
BA7C 6F0F	# <CJK>
BA7D 6F02	# <CJK>
BA7E 6F22	# <CJK>
BAA1 6EFF	# <CJK>
BAA2 6EEF	# <CJK>
BAA3 6F06	# <CJK>
BAA4 6F31	# <CJK>
BAA5 6F38	# <CJK>
BAA6 6F32	# <CJK>
BAA7 6F23	# <CJK>
BAA8 6F15	# <CJK>
BAA9 6F2B	# <CJK>
BAAA 6F2F	# <CJK>
BAAB 6F88	# <CJK>
BAAC 6F2A	# <CJK>
BAAD 6EEC	# <CJK>
BAAE 6F01	# <CJK>
BAAF 6EF2	# <CJK>
BAB0 6ECC	# <CJK>
BAB1 6EF7	# <CJK>
BAB2 7194	# <CJK>
BAB3 7199	# <CJK>
BAB4 717D	# <CJK>
BAB5 718A	# <CJK>
BAB6 7184	# <CJK>
BAB7 7192	# <CJK>
BAB8 723E	# <CJK>
BAB9 7292	# <CJK>
BABA 7296	# <CJK>
BABB 7344	# <CJK>
BABC 7350	# <CJK>
BABD 7464	# <CJK>
BABE 7463	# <CJK>
BABF 746A	# <CJK>
BAC0 7470	# <CJK>
BAC1 746D	# <CJK>
BAC2 7504	# <CJK>
BAC3 7591	# <CJK>
BAC4 7627	# <CJK>
BAC5 760D	# <CJK>
BAC6 760B	# <CJK>
BAC7 7609	# <CJK>
BAC8 7613	# <CJK>
BAC9 76E1	# <CJK>
BACA 76E3	# <CJK>
BACB 7784	# <CJK>
BACC 777D	# <CJK>
BACD 777F	# <CJK>
BACE 7761	# <CJK>
BACF 78C1	# <CJK>
BAD0 789F	# <CJK>
BAD1 78A7	# <CJK>
BAD2 78B3	# <CJK>
BAD3 78A9	# <CJK>
BAD4 78A3	# <CJK>
BAD5 798E	# <CJK>
BAD6 798F	# <CJK>
BAD7 798D	# <CJK>
BAD8 7A2E	# <CJK>
BAD9 7A31	# <CJK>
BADA 7AAA	# <CJK>
BADB 7AA9	# <CJK>
BADC 7AED	# <CJK>
BADD 7AEF	# <CJK>
BADE 7BA1	# <CJK>
BADF 7B95	# <CJK>
BAE0 7B8B	# <CJK>
BAE1 7B75	# <CJK>
BAE2 7B97	# <CJK>
BAE3 7B9D	# <CJK>
BAE4 7B94	# <CJK>
BAE5 7B8F	# <CJK>
BAE6 7BB8	# <CJK>
BAE7 7B87	# <CJK>
BAE8 7B84	# <CJK>
BAE9 7CB9	# <CJK>
BAEA 7CBD	# <CJK>
BAEB 7CBE	# <CJK>
BAEC 7DBB	# <CJK>
BAED 7DB0	# <CJK>
BAEE 7D9C	# <CJK>
BAEF 7DBD	# <CJK>
BAF0 7DBE	# <CJK>
BAF1 7DA0	# <CJK>
BAF2 7DCA	# <CJK>
BAF3 7DB4	# <CJK>
BAF4 7DB2	# <CJK>
BAF5 7DB1	# <CJK>
BAF6 7DBA	# <CJK>
BAF7 7DA2	# <CJK>
BAF8 7DBF	# <CJK>
BAF9 7DB5	# <CJK>
BAFA 7DB8	# <CJK>
BAFB 7DAD	# <CJK>
BAFC 7DD2	# <CJK>
BAFD 7DC7	# <CJK>
BAFE 7DAC	# <CJK>
BB40 7F70	# <CJK>
BB41 7FE0	# <CJK>
BB42 7FE1	# <CJK>
BB43 7FDF	# <CJK>
BB44 805E	# <CJK>
BB45 805A	# <CJK>
BB46 8087	# <CJK>
BB47 8150	# <CJK>
BB48 8180	# <CJK>
BB49 818F	# <CJK>
BB4A 8188	# <CJK>
BB4B 818A	# <CJK>
BB4C 817F	# <CJK>
BB4D 8182	# <CJK>
BB4E 81E7	# <CJK>
BB4F 81FA	# <CJK>
BB50 8207	# <CJK>
BB51 8214	# <CJK>
BB52 821E	# <CJK>
BB53 824B	# <CJK>
BB54 84C9	# <CJK>
BB55 84BF	# <CJK>
BB56 84C6	# <CJK>
BB57 84C4	# <CJK>
BB58 8499	# <CJK>
BB59 849E	# <CJK>
BB5A 84B2	# <CJK>
BB5B 849C	# <CJK>
BB5C 84CB	# <CJK>
BB5D 84B8	# <CJK>
BB5E 84C0	# <CJK>
BB5F 84D3	# <CJK>
BB60 8490	# <CJK>
BB61 84BC	# <CJK>
BB62 84D1	# <CJK>
BB63 84CA	# <CJK>
BB64 873F	# <CJK>
BB65 871C	# <CJK>
BB66 873B	# <CJK>
BB67 8722	# <CJK>
BB68 8725	# <CJK>
BB69 8734	# <CJK>
BB6A 8718	# <CJK>
BB6B 8755	# <CJK>
BB6C 8737	# <CJK>
BB6D 8729	# <CJK>
BB6E 88F3	# <CJK>
BB6F 8902	# <CJK>
BB70 88F4	# <CJK>
BB71 88F9	# <CJK>
BB72 88F8	# <CJK>
BB73 88FD	# <CJK>
BB74 88E8	# <CJK>
BB75 891A	# <CJK>
BB76 88EF	# <CJK>
BB77 8AA6	# <CJK>
BB78 8A8C	# <CJK>
BB79 8A9E	# <CJK>
BB7A 8AA3	# <CJK>
BB7B 8A8D	# <CJK>
BB7C 8AA1	# <CJK>
BB7D 8A93	# <CJK>
BB7E 8AA4	# <CJK>
BBA1 8AAA	# <CJK>
BBA2 8AA5	# <CJK>
BBA3 8AA8	# <CJK>
BBA4 8A98	# <CJK>
BBA5 8A91	# <CJK>
BBA6 8A9A	# <CJK>
BBA7 8AA7	# <CJK>
BBA8 8C6A	# <CJK>
BBA9 8C8D	# <CJK>
BBAA 8C8C	# <CJK>
BBAB 8CD3	# <CJK>
BBAC 8CD1	# <CJK>
BBAD 8CD2	# <CJK>
BBAE 8D6B	# <CJK>
BBAF 8D99	# <CJK>
BBB0 8D95	# <CJK>
BBB1 8DFC	# <CJK>
BBB2 8F14	# <CJK>
BBB3 8F12	# <CJK>
BBB4 8F15	# <CJK>
BBB5 8F13	# <CJK>
BBB6 8FA3	# <CJK>
BBB7 9060	# <CJK>
BBB8 9058	# <CJK>
BBB9 905C	# <CJK>
BBBA 9063	# <CJK>
BBBB 9059	# <CJK>
BBBC 905E	# <CJK>
BBBD 9062	# <CJK>
BBBE 905D	# <CJK>
BBBF 905B	# <CJK>
BBC0 9119	# <CJK>
BBC1 9118	# <CJK>
BBC2 911E	# <CJK>
BBC3 9175	# <CJK>
BBC4 9178	# <CJK>
BBC5 9177	# <CJK>
BBC6 9174	# <CJK>
BBC7 9278	# <CJK>
BBC8 9280	# <CJK>
BBC9 9285	# <CJK>
BBCA 9298	# <CJK>
BBCB 9296	# <CJK>
BBCC 927B	# <CJK>
BBCD 9293	# <CJK>
BBCE 929C	# <CJK>
BBCF 92A8	# <CJK>
BBD0 927C	# <CJK>
BBD1 9291	# <CJK>
BBD2 95A1	# <CJK>
BBD3 95A8	# <CJK>
BBD4 95A9	# <CJK>
BBD5 95A3	# <CJK>
BBD6 95A5	# <CJK>
BBD7 95A4	# <CJK>
BBD8 9699	# <CJK>
BBD9 969C	# <CJK>
BBDA 969B	# <CJK>
BBDB 96CC	# <CJK>
BBDC 96D2	# <CJK>
BBDD 9700	# <CJK>
BBDE 977C	# <CJK>
BBDF 9785	# <CJK>
BBE0 97F6	# <CJK>
BBE1 9817	# <CJK>
BBE2 9818	# <CJK>
BBE3 98AF	# <CJK>
BBE4 98B1	# <CJK>
BBE5 9903	# <CJK>
BBE6 9905	# <CJK>
BBE7 990C	# <CJK>
BBE8 9909	# <CJK>
BBE9 99C1	# <CJK>
BBEA 9AAF	# <CJK>
BBEB 9AB0	# <CJK>
BBEC 9AE6	# <CJK>
BBED 9B41	# <CJK>
BBEE 9B42	# <CJK>
BBEF 9CF4	# <CJK>
BBF0 9CF6	# <CJK>
BBF1 9CF3	# <CJK>
BBF2 9EBC	# <CJK>
BBF3 9F3B	# <CJK>
BBF4 9F4A	# <CJK>
BBF5 5104	# <CJK>
BBF6 5100	# <CJK>
BBF7 50FB	# <CJK>
BBF8 50F5	# <CJK>
BBF9 50F9	# <CJK>
BBFA 5102	# <CJK>
BBFB 5108	# <CJK>
BBFC 5109	# <CJK>
BBFD 5105	# <CJK>
BBFE 51DC	# <CJK>
BC40 5287	# <CJK>
BC41 5288	# <CJK>
BC42 5289	# <CJK>
BC43 528D	# <CJK>
BC44 528A	# <CJK>
BC45 52F0	# <CJK>
BC46 53B2	# <CJK>
BC47 562E	# <CJK>
BC48 563B	# <CJK>
BC49 5639	# <CJK>
BC4A 5632	# <CJK>
BC4B 563F	# <CJK>
BC4C 5634	# <CJK>
BC4D 5629	# <CJK>
BC4E 5653	# <CJK>
BC4F 564E	# <CJK>
BC50 5657	# <CJK>
BC51 5674	# <CJK>
BC52 5636	# <CJK>
BC53 562F	# <CJK>
BC54 5630	# <CJK>
BC55 5880	# <CJK>
BC56 589F	# <CJK>
BC57 589E	# <CJK>
BC58 58B3	# <CJK>
BC59 589C	# <CJK>
BC5A 58AE	# <CJK>
BC5B 58A9	# <CJK>
BC5C 58A6	# <CJK>
BC5D 596D	# <CJK>
BC5E 5B09	# <CJK>
BC5F 5AFB	# <CJK>
BC60 5B0B	# <CJK>
BC61 5AF5	# <CJK>
BC62 5B0C	# <CJK>
BC63 5B08	# <CJK>
BC64 5BEE	# <CJK>
BC65 5BEC	# <CJK>
BC66 5BE9	# <CJK>
BC67 5BEB	# <CJK>
BC68 5C64	# <CJK>
BC69 5C65	# <CJK>
BC6A 5D9D	# <CJK>
BC6B 5D94	# <CJK>
BC6C 5E62	# <CJK>
BC6D 5E5F	# <CJK>
BC6E 5E61	# <CJK>
BC6F 5EE2	# <CJK>
BC70 5EDA	# <CJK>
BC71 5EDF	# <CJK>
BC72 5EDD	# <CJK>
BC73 5EE3	# <CJK>
BC74 5EE0	# <CJK>
BC75 5F48	# <CJK>
BC76 5F71	# <CJK>
BC77 5FB7	# <CJK>
BC78 5FB5	# <CJK>
BC79 6176	# <CJK>
BC7A 6167	# <CJK>
BC7B 616E	# <CJK>
BC7C 615D	# <CJK>
BC7D 6155	# <CJK>
BC7E 6182	# <CJK>
BCA1 617C	# <CJK>
BCA2 6170	# <CJK>
BCA3 616B	# <CJK>
BCA4 617E	# <CJK>
BCA5 61A7	# <CJK>
BCA6 6190	# <CJK>
BCA7 61AB	# <CJK>
BCA8 618E	# <CJK>
BCA9 61AC	# <CJK>
BCAA 619A	# <CJK>
BCAB 61A4	# <CJK>
BCAC 6194	# <CJK>
BCAD 61AE	# <CJK>
BCAE 622E	# <CJK>
BCAF 6469	# <CJK>
BCB0 646F	# <CJK>
BCB1 6479	# <CJK>
BCB2 649E	# <CJK>
BCB3 64B2	# <CJK>
BCB4 6488	# <CJK>
BCB5 6490	# <CJK>
BCB6 64B0	# <CJK>
BCB7 64A5	# <CJK>
BCB8 6493	# <CJK>
BCB9 6495	# <CJK>
BCBA 64A9	# <CJK>
BCBB 6492	# <CJK>
BCBC 64AE	# <CJK>
BCBD 64AD	# <CJK>
BCBE 64AB	# <CJK>
BCBF 649A	# <CJK>
BCC0 64AC	# <CJK>
BCC1 6499	# <CJK>
BCC2 64A2	# <CJK>
BCC3 64B3	# <CJK>
BCC4 6575	# <CJK>
BCC5 6577	# <CJK>
BCC6 6578	# <CJK>
BCC7 66AE	# <CJK>
BCC8 66AB	# <CJK>
BCC9 66B4	# <CJK>
BCCA 66B1	# <CJK>
BCCB 6A23	# <CJK>
BCCC 6A1F	# <CJK>
BCCD 69E8	# <CJK>
BCCE 6A01	# <CJK>
BCCF 6A1E	# <CJK>
BCD0 6A19	# <CJK>
BCD1 69FD	# <CJK>
BCD2 6A21	# <CJK>
BCD3 6A13	# <CJK>
BCD4 6A0A	# <CJK>
BCD5 69F3	# <CJK>
BCD6 6A02	# <CJK>
BCD7 6A05	# <CJK>
BCD8 69ED	# <CJK>
BCD9 6A11	# <CJK>
BCDA 6B50	# <CJK>
BCDB 6B4E	# <CJK>
BCDC 6BA4	# <CJK>
BCDD 6BC5	# <CJK>
BCDE 6BC6	# <CJK>
BCDF 6F3F	# <CJK>
BCE0 6F7C	# <CJK>
BCE1 6F84	# <CJK>
BCE2 6F51	# <CJK>
BCE3 6F66	# <CJK>
BCE4 6F54	# <CJK>
BCE5 6F86	# <CJK>
BCE6 6F6D	# <CJK>
BCE7 6F5B	# <CJK>
BCE8 6F78	# <CJK>
BCE9 6F6E	# <CJK>
BCEA 6F8E	# <CJK>
BCEB 6F7A	# <CJK>
BCEC 6F70	# <CJK>
BCED 6F64	# <CJK>
BCEE 6F97	# <CJK>
BCEF 6F58	# <CJK>
BCF0 6ED5	# <CJK>
BCF1 6F6F	# <CJK>
BCF2 6F60	# <CJK>
BCF3 6F5F	# <CJK>
BCF4 719F	# <CJK>
BCF5 71AC	# <CJK>
BCF6 71B1	# <CJK>
BCF7 71A8	# <CJK>
BCF8 7256	# <CJK>
BCF9 729B	# <CJK>
BCFA 734E	# <CJK>
BCFB 7357	# <CJK>
BCFC 7469	# <CJK>
BCFD 748B	# <CJK>
BCFE 7483	# <CJK>
BD40 747E	# <CJK>
BD41 7480	# <CJK>
BD42 757F	# <CJK>
BD43 7620	# <CJK>
BD44 7629	# <CJK>
BD45 761F	# <CJK>
BD46 7624	# <CJK>
BD47 7626	# <CJK>
BD48 7621	# <CJK>
BD49 7622	# <CJK>
BD4A 769A	# <CJK>
BD4B 76BA	# <CJK>
BD4C 76E4	# <CJK>
BD4D 778E	# <CJK>
BD4E 7787	# <CJK>
BD4F 778C	# <CJK>
BD50 7791	# <CJK>
BD51 778B	# <CJK>
BD52 78CB	# <CJK>
BD53 78C5	# <CJK>
BD54 78BA	# <CJK>
BD55 78CA	# <CJK>
BD56 78BE	# <CJK>
BD57 78D5	# <CJK>
BD58 78BC	# <CJK>
BD59 78D0	# <CJK>
BD5A 7A3F	# <CJK>
BD5B 7A3C	# <CJK>
BD5C 7A40	# <CJK>
BD5D 7A3D	# <CJK>
BD5E 7A37	# <CJK>
BD5F 7A3B	# <CJK>
BD60 7AAF	# <CJK>
BD61 7AAE	# <CJK>
BD62 7BAD	# <CJK>
BD63 7BB1	# <CJK>
BD64 7BC4	# <CJK>
BD65 7BB4	# <CJK>
BD66 7BC6	# <CJK>
BD67 7BC7	# <CJK>
BD68 7BC1	# <CJK>
BD69 7BA0	# <CJK>
BD6A 7BCC	# <CJK>
BD6B 7CCA	# <CJK>
BD6C 7DE0	# <CJK>
BD6D 7DF4	# <CJK>
BD6E 7DEF	# <CJK>
BD6F 7DFB	# <CJK>
BD70 7DD8	# <CJK>
BD71 7DEC	# <CJK>
BD72 7DDD	# <CJK>
BD73 7DE8	# <CJK>
BD74 7DE3	# <CJK>
BD75 7DDA	# <CJK>
BD76 7DDE	# <CJK>
BD77 7DE9	# <CJK>
BD78 7D9E	# <CJK>
BD79 7DD9	# <CJK>
BD7A 7DF2	# <CJK>
BD7B 7DF9	# <CJK>
BD7C 7F75	# <CJK>
BD7D 7F77	# <CJK>
BD7E 7FAF	# <CJK>
BDA1 7FE9	# <CJK>
BDA2 8026	# <CJK>
BDA3 819B	# <CJK>
BDA4 819C	# <CJK>
BDA5 819D	# <CJK>
BDA6 81A0	# <CJK>
BDA7 819A	# <CJK>
BDA8 8198	# <CJK>
BDA9 8517	# <CJK>
BDAA 853D	# <CJK>
BDAB 851A	# <CJK>
BDAC 84EE	# <CJK>
BDAD 852C	# <CJK>
BDAE 852D	# <CJK>
BDAF 8513	# <CJK>
BDB0 8511	# <CJK>
BDB1 8523	# <CJK>
BDB2 8521	# <CJK>
BDB3 8514	# <CJK>
BDB4 84EC	# <CJK>
BDB5 8525	# <CJK>
BDB6 84FF	# <CJK>
BDB7 8506	# <CJK>
BDB8 8782	# <CJK>
BDB9 8774	# <CJK>
BDBA 8776	# <CJK>
BDBB 8760	# <CJK>
BDBC 8766	# <CJK>
BDBD 8778	# <CJK>
BDBE 8768	# <CJK>
BDBF 8759	# <CJK>
BDC0 8757	# <CJK>
BDC1 874C	# <CJK>
BDC2 8753	# <CJK>
BDC3 885B	# <CJK>
BDC4 885D	# <CJK>
BDC5 8910	# <CJK>
BDC6 8907	# <CJK>
BDC7 8912	# <CJK>
BDC8 8913	# <CJK>
BDC9 8915	# <CJK>
BDCA 890A	# <CJK>
BDCB 8ABC	# <CJK>
BDCC 8AD2	# <CJK>
BDCD 8AC7	# <CJK>
BDCE 8AC4	# <CJK>
BDCF 8A95	# <CJK>
BDD0 8ACB	# <CJK>
BDD1 8AF8	# <CJK>
BDD2 8AB2	# <CJK>
BDD3 8AC9	# <CJK>
BDD4 8AC2	# <CJK>
BDD5 8ABF	# <CJK>
BDD6 8AB0	# <CJK>
BDD7 8AD6	# <CJK>
BDD8 8ACD	# <CJK>
BDD9 8AB6	# <CJK>
BDDA 8AB9	# <CJK>
BDDB 8ADB	# <CJK>
BDDC 8C4C	# <CJK>
BDDD 8C4E	# <CJK>
BDDE 8C6C	# <CJK>
BDDF 8CE0	# <CJK>
BDE0 8CDE	# <CJK>
BDE1 8CE6	# <CJK>
BDE2 8CE4	# <CJK>
BDE3 8CEC	# <CJK>
BDE4 8CED	# <CJK>
BDE5 8CE2	# <CJK>
BDE6 8CE3	# <CJK>
BDE7 8CDC	# <CJK>
BDE8 8CEA	# <CJK>
BDE9 8CE1	# <CJK>
BDEA 8D6D	# <CJK>
BDEB 8D9F	# <CJK>
BDEC 8DA3	# <CJK>
BDED 8E2B	# <CJK>
BDEE 8E10	# <CJK>
BDEF 8E1D	# <CJK>
BDF0 8E22	# <CJK>
BDF1 8E0F	# <CJK>
BDF2 8E29	# <CJK>
BDF3 8E1F	# <CJK>
BDF4 8E21	# <CJK>
BDF5 8E1E	# <CJK>
BDF6 8EBA	# <CJK>
BDF7 8F1D	# <CJK>
BDF8 8F1B	# <CJK>
BDF9 8F1F	# <CJK>
BDFA 8F29	# <CJK>
BDFB 8F26	# <CJK>
BDFC 8F2A	# <CJK>
BDFD 8F1C	# <CJK>
BDFE 8F1E	# <CJK>
BE40 8F25	# <CJK>
BE41 9069	# <CJK>
BE42 906E	# <CJK>
BE43 9068	# <CJK>
BE44 906D	# <CJK>
BE45 9077	# <CJK>
BE46 9130	# <CJK>
BE47 912D	# <CJK>
BE48 9127	# <CJK>
BE49 9131	# <CJK>
BE4A 9187	# <CJK>
BE4B 9189	# <CJK>
BE4C 918B	# <CJK>
BE4D 9183	# <CJK>
BE4E 92C5	# <CJK>
BE4F 92BB	# <CJK>
BE50 92B7	# <CJK>
BE51 92EA	# <CJK>
BE52 92AC	# <CJK>
BE53 92E4	# <CJK>
BE54 92C1	# <CJK>
BE55 92B3	# <CJK>
BE56 92BC	# <CJK>
BE57 92D2	# <CJK>
BE58 92C7	# <CJK>
BE59 92F0	# <CJK>
BE5A 92B2	# <CJK>
BE5B 95AD	# <CJK>
BE5C 95B1	# <CJK>
BE5D 9704	# <CJK>
BE5E 9706	# <CJK>
BE5F 9707	# <CJK>
BE60 9709	# <CJK>
BE61 9760	# <CJK>
BE62 978D	# <CJK>
BE63 978B	# <CJK>
BE64 978F	# <CJK>
BE65 9821	# <CJK>
BE66 982B	# <CJK>
BE67 981C	# <CJK>
BE68 98B3	# <CJK>
BE69 990A	# <CJK>
BE6A 9913	# <CJK>
BE6B 9912	# <CJK>
BE6C 9918	# <CJK>
BE6D 99DD	# <CJK>
BE6E 99D0	# <CJK>
BE6F 99DF	# <CJK>
BE70 99DB	# <CJK>
BE71 99D1	# <CJK>
BE72 99D5	# <CJK>
BE73 99D2	# <CJK>
BE74 99D9	# <CJK>
BE75 9AB7	# <CJK>
BE76 9AEE	# <CJK>
BE77 9AEF	# <CJK>
BE78 9B27	# <CJK>
BE79 9B45	# <CJK>
BE7A 9B44	# <CJK>
BE7B 9B77	# <CJK>
BE7C 9B6F	# <CJK>
BE7D 9D06	# <CJK>
BE7E 9D09	# <CJK>
BEA1 9D03	# <CJK>
BEA2 9EA9	# <CJK>
BEA3 9EBE	# <CJK>
BEA4 9ECE	# <CJK>
BEA5 58A8	# <CJK>
BEA6 9F52	# <CJK>
BEA7 5112	# <CJK>
BEA8 5118	# <CJK>
BEA9 5114	# <CJK>
BEAA 5110	# <CJK>
BEAB 5115	# <CJK>
BEAC 5180	# <CJK>
BEAD 51AA	# <CJK>
BEAE 51DD	# <CJK>
BEAF 5291	# <CJK>
BEB0 5293	# <CJK>
BEB1 52F3	# <CJK>
BEB2 5659	# <CJK>
BEB3 566B	# <CJK>
BEB4 5679	# <CJK>
BEB5 5669	# <CJK>
BEB6 5664	# <CJK>
BEB7 5678	# <CJK>
BEB8 566A	# <CJK>
BEB9 5668	# <CJK>
BEBA 5665	# <CJK>
BEBB 5671	# <CJK>
BEBC 566F	# <CJK>
BEBD 566C	# <CJK>
BEBE 5662	# <CJK>
BEBF 5676	# <CJK>
BEC0 58C1	# <CJK>
BEC1 58BE	# <CJK>
BEC2 58C7	# <CJK>
BEC3 58C5	# <CJK>
BEC4 596E	# <CJK>
BEC5 5B1D	# <CJK>
BEC6 5B34	# <CJK>
BEC7 5B78	# <CJK>
BEC8 5BF0	# <CJK>
BEC9 5C0E	# <CJK>
BECA 5F4A	# <CJK>
BECB 61B2	# <CJK>
BECC 6191	# <CJK>
BECD 61A9	# <CJK>
BECE 618A	# <CJK>
BECF 61CD	# <CJK>
BED0 61B6	# <CJK>
BED1 61BE	# <CJK>
BED2 61CA	# <CJK>
BED3 61C8	# <CJK>
BED4 6230	# <CJK>
BED5 64C5	# <CJK>
BED6 64C1	# <CJK>
BED7 64CB	# <CJK>
BED8 64BB	# <CJK>
BED9 64BC	# <CJK>
BEDA 64DA	# <CJK>
BEDB 64C4	# <CJK>
BEDC 64C7	# <CJK>
BEDD 64C2	# <CJK>
BEDE 64CD	# <CJK>
BEDF 64BF	# <CJK>
BEE0 64D2	# <CJK>
BEE1 64D4	# <CJK>
BEE2 64BE	# <CJK>
BEE3 6574	# <CJK>
BEE4 66C6	# <CJK>
BEE5 66C9	# <CJK>
BEE6 66B9	# <CJK>
BEE7 66C4	# <CJK>
BEE8 66C7	# <CJK>
BEE9 66B8	# <CJK>
BEEA 6A3D	# <CJK>
BEEB 6A38	# <CJK>
BEEC 6A3A	# <CJK>
BEED 6A59	# <CJK>
BEEE 6A6B	# <CJK>
BEEF 6A58	# <CJK>
BEF0 6A39	# <CJK>
BEF1 6A44	# <CJK>
BEF2 6A62	# <CJK>
BEF3 6A61	# <CJK>
BEF4 6A4B	# <CJK>
BEF5 6A47	# <CJK>
BEF6 6A35	# <CJK>
BEF7 6A5F	# <CJK>
BEF8 6A48	# <CJK>
BEF9 6B59	# <CJK>
BEFA 6B77	# <CJK>
BEFB 6C05	# <CJK>
BEFC 6FC2	# <CJK>
BEFD 6FB1	# <CJK>
BEFE 6FA1	# <CJK>
BF40 6FC3	# <CJK>
BF41 6FA4	# <CJK>
BF42 6FC1	# <CJK>
BF43 6FA7	# <CJK>
BF44 6FB3	# <CJK>
BF45 6FC0	# <CJK>
BF46 6FB9	# <CJK>
BF47 6FB6	# <CJK>
BF48 6FA6	# <CJK>
BF49 6FA0	# <CJK>
BF4A 6FB4	# <CJK>
BF4B 71BE	# <CJK>
BF4C 71C9	# <CJK>
BF4D 71D0	# <CJK>
BF4E 71D2	# <CJK>
BF4F 71C8	# <CJK>
BF50 71D5	# <CJK>
BF51 71B9	# <CJK>
BF52 71CE	# <CJK>
BF53 71D9	# <CJK>
BF54 71DC	# <CJK>
BF55 71C3	# <CJK>
BF56 71C4	# <CJK>
BF57 7368	# <CJK>
BF58 749C	# <CJK>
BF59 74A3	# <CJK>
BF5A 7498	# <CJK>
BF5B 749F	# <CJK>
BF5C 749E	# <CJK>
BF5D 74E2	# <CJK>
BF5E 750C	# <CJK>
BF5F 750D	# <CJK>
BF60 7634	# <CJK>
BF61 7638	# <CJK>
BF62 763A	# <CJK>
BF63 76E7	# <CJK>
BF64 76E5	# <CJK>
BF65 77A0	# <CJK>
BF66 779E	# <CJK>
BF67 779F	# <CJK>
BF68 77A5	# <CJK>
BF69 78E8	# <CJK>
BF6A 78DA	# <CJK>
BF6B 78EC	# <CJK>
BF6C 78E7	# <CJK>
BF6D 79A6	# <CJK>
BF6E 7A4D	# <CJK>
BF6F 7A4E	# <CJK>
BF70 7A46	# <CJK>
BF71 7A4C	# <CJK>
BF72 7A4B	# <CJK>
BF73 7ABA	# <CJK>
BF74 7BD9	# <CJK>
BF75 7C11	# <CJK>
BF76 7BC9	# <CJK>
BF77 7BE4	# <CJK>
BF78 7BDB	# <CJK>
BF79 7BE1	# <CJK>
BF7A 7BE9	# <CJK>
BF7B 7BE6	# <CJK>
BF7C 7CD5	# <CJK>
BF7D 7CD6	# <CJK>
BF7E 7E0A	# <CJK>
BFA1 7E11	# <CJK>
BFA2 7E08	# <CJK>
BFA3 7E1B	# <CJK>
BFA4 7E23	# <CJK>
BFA5 7E1E	# <CJK>
BFA6 7E1D	# <CJK>
BFA7 7E09	# <CJK>
BFA8 7E10	# <CJK>
BFA9 7F79	# <CJK>
BFAA 7FB2	# <CJK>
BFAB 7FF0	# <CJK>
BFAC 7FF1	# <CJK>
BFAD 7FEE	# <CJK>
BFAE 8028	# <CJK>
BFAF 81B3	# <CJK>
BFB0 81A9	# <CJK>
BFB1 81A8	# <CJK>
BFB2 81FB	# <CJK>
BFB3 8208	# <CJK>
BFB4 8258	# <CJK>
BFB5 8259	# <CJK>
BFB6 854A	# <CJK>
BFB7 8559	# <CJK>
BFB8 8548	# <CJK>
BFB9 8568	# <CJK>
BFBA 8569	# <CJK>
BFBB 8543	# <CJK>
BFBC 8549	# <CJK>
BFBD 856D	# <CJK>
BFBE 856A	# <CJK>
BFBF 855E	# <CJK>
BFC0 8783	# <CJK>
BFC1 879F	# <CJK>
BFC2 879E	# <CJK>
BFC3 87A2	# <CJK>
BFC4 878D	# <CJK>
BFC5 8861	# <CJK>
BFC6 892A	# <CJK>
BFC7 8932	# <CJK>
BFC8 8925	# <CJK>
BFC9 892B	# <CJK>
BFCA 8921	# <CJK>
BFCB 89AA	# <CJK>
BFCC 89A6	# <CJK>
BFCD 8AE6	# <CJK>
BFCE 8AFA	# <CJK>
BFCF 8AEB	# <CJK>
BFD0 8AF1	# <CJK>
BFD1 8B00	# <CJK>
BFD2 8ADC	# <CJK>
BFD3 8AE7	# <CJK>
BFD4 8AEE	# <CJK>
BFD5 8AFE	# <CJK>
BFD6 8B01	# <CJK>
BFD7 8B02	# <CJK>
BFD8 8AF7	# <CJK>
BFD9 8AED	# <CJK>
BFDA 8AF3	# <CJK>
BFDB 8AF6	# <CJK>
BFDC 8AFC	# <CJK>
BFDD 8C6B	# <CJK>
BFDE 8C6D	# <CJK>
BFDF 8C93	# <CJK>
BFE0 8CF4	# <CJK>
BFE1 8E44	# <CJK>
BFE2 8E31	# <CJK>
BFE3 8E34	# <CJK>
BFE4 8E42	# <CJK>
BFE5 8E39	# <CJK>
BFE6 8E35	# <CJK>
BFE7 8F3B	# <CJK>
BFE8 8F2F	# <CJK>
BFE9 8F38	# <CJK>
BFEA 8F33	# <CJK>
BFEB 8FA8	# <CJK>
BFEC 8FA6	# <CJK>
BFED 9075	# <CJK>
BFEE 9074	# <CJK>
BFEF 9078	# <CJK>
BFF0 9072	# <CJK>
BFF1 907C	# <CJK>
BFF2 907A	# <CJK>
BFF3 9134	# <CJK>
BFF4 9192	# <CJK>
BFF5 9320	# <CJK>
BFF6 9336	# <CJK>
BFF7 92F8	# <CJK>
BFF8 9333	# <CJK>
BFF9 932F	# <CJK>
BFFA 9322	# <CJK>
BFFB 92FC	# <CJK>
BFFC 932B	# <CJK>
BFFD 9304	# <CJK>
BFFE 931A	# <CJK>
C040 9310	# <CJK>
C041 9326	# <CJK>
C042 9321	# <CJK>
C043 9315	# <CJK>
C044 932E	# <CJK>
C045 9319	# <CJK>
C046 95BB	# <CJK>
C047 96A7	# <CJK>
C048 96A8	# <CJK>
C049 96AA	# <CJK>
C04A 96D5	# <CJK>
C04B 970E	# <CJK>
C04C 9711	# <CJK>
C04D 9716	# <CJK>
C04E 970D	# <CJK>
C04F 9713	# <CJK>
C050 970F	# <CJK>
C051 975B	# <CJK>
C052 975C	# <CJK>
C053 9766	# <CJK>
C054 9798	# <CJK>
C055 9830	# <CJK>
C056 9838	# <CJK>
C057 983B	# <CJK>
C058 9837	# <CJK>
C059 982D	# <CJK>
C05A 9839	# <CJK>
C05B 9824	# <CJK>
C05C 9910	# <CJK>
C05D 9928	# <CJK>
C05E 991E	# <CJK>
C05F 991B	# <CJK>
C060 9921	# <CJK>
C061 991A	# <CJK>
C062 99ED	# <CJK>
C063 99E2	# <CJK>
C064 99F1	# <CJK>
C065 9AB8	# <CJK>
C066 9ABC	# <CJK>
C067 9AFB	# <CJK>
C068 9AED	# <CJK>
C069 9B28	# <CJK>
C06A 9B91	# <CJK>
C06B 9D15	# <CJK>
C06C 9D23	# <CJK>
C06D 9D26	# <CJK>
C06E 9D28	# <CJK>
C06F 9D12	# <CJK>
C070 9D1B	# <CJK>
C071 9ED8	# <CJK>
C072 9ED4	# <CJK>
C073 9F8D	# <CJK>
C074 9F9C	# <CJK>
C075 512A	# <CJK>
C076 511F	# <CJK>
C077 5121	# <CJK>
C078 5132	# <CJK>
C079 52F5	# <CJK>
C07A 568E	# <CJK>
C07B 5680	# <CJK>
C07C 5690	# <CJK>
C07D 5685	# <CJK>
C07E 5687	# <CJK>
C0A1 568F	# <CJK>
C0A2 58D5	# <CJK>
C0A3 58D3	# <CJK>
C0A4 58D1	# <CJK>
C0A5 58CE	# <CJK>
C0A6 5B30	# <CJK>
C0A7 5B2A	# <CJK>
C0A8 5B24	# <CJK>
C0A9 5B7A	# <CJK>
C0AA 5C37	# <CJK>
C0AB 5C68	# <CJK>
C0AC 5DBC	# <CJK>
C0AD 5DBA	# <CJK>
C0AE 5DBD	# <CJK>
C0AF 5DB8	# <CJK>
C0B0 5E6B	# <CJK>
C0B1 5F4C	# <CJK>
C0B2 5FBD	# <CJK>
C0B3 61C9	# <CJK>
C0B4 61C2	# <CJK>
C0B5 61C7	# <CJK>
C0B6 61E6	# <CJK>
C0B7 61CB	# <CJK>
C0B8 6232	# <CJK>
C0B9 6234	# <CJK>
C0BA 64CE	# <CJK>
C0BB 64CA	# <CJK>
C0BC 64D8	# <CJK>
C0BD 64E0	# <CJK>
C0BE 64F0	# <CJK>
C0BF 64E6	# <CJK>
C0C0 64EC	# <CJK>
C0C1 64F1	# <CJK>
C0C2 64E2	# <CJK>
C0C3 64ED	# <CJK>
C0C4 6582	# <CJK>
C0C5 6583	# <CJK>
C0C6 66D9	# <CJK>
C0C7 66D6	# <CJK>
C0C8 6A80	# <CJK>
C0C9 6A94	# <CJK>
C0CA 6A84	# <CJK>
C0CB 6AA2	# <CJK>
C0CC 6A9C	# <CJK>
C0CD 6ADB	# <CJK>
C0CE 6AA3	# <CJK>
C0CF 6A7E	# <CJK>
C0D0 6A97	# <CJK>
C0D1 6A90	# <CJK>
C0D2 6AA0	# <CJK>
C0D3 6B5C	# <CJK>
C0D4 6BAE	# <CJK>
C0D5 6BDA	# <CJK>
C0D6 6C08	# <CJK>
C0D7 6FD8	# <CJK>
C0D8 6FF1	# <CJK>
C0D9 6FDF	# <CJK>
C0DA 6FE0	# <CJK>
C0DB 6FDB	# <CJK>
C0DC 6FE4	# <CJK>
C0DD 6FEB	# <CJK>
C0DE 6FEF	# <CJK>
C0DF 6F80	# <CJK>
C0E0 6FEC	# <CJK>
C0E1 6FE1	# <CJK>
C0E2 6FE9	# <CJK>
C0E3 6FD5	# <CJK>
C0E4 6FEE	# <CJK>
C0E5 6FF0	# <CJK>
C0E6 71E7	# <CJK>
C0E7 71DF	# <CJK>
C0E8 71EE	# <CJK>
C0E9 71E6	# <CJK>
C0EA 71E5	# <CJK>
C0EB 71ED	# <CJK>
C0EC 71EC	# <CJK>
C0ED 71F4	# <CJK>
C0EE 71E0	# <CJK>
C0EF 7235	# <CJK>
C0F0 7246	# <CJK>
C0F1 7370	# <CJK>
C0F2 7372	# <CJK>
C0F3 74A9	# <CJK>
C0F4 74B0	# <CJK>
C0F5 74A6	# <CJK>
C0F6 74A8	# <CJK>
C0F7 7646	# <CJK>
C0F8 7642	# <CJK>
C0F9 764C	# <CJK>
C0FA 76EA	# <CJK>
C0FB 77B3	# <CJK>
C0FC 77AA	# <CJK>
C0FD 77B0	# <CJK>
C0FE 77AC	# <CJK>
C140 77A7	# <CJK>
C141 77AD	# <CJK>
C142 77EF	# <CJK>
C143 78F7	# <CJK>
C144 78FA	# <CJK>
C145 78F4	# <CJK>
C146 78EF	# <CJK>
C147 7901	# <CJK>
C148 79A7	# <CJK>
C149 79AA	# <CJK>
C14A 7A57	# <CJK>
C14B 7ABF	# <CJK>
C14C 7C07	# <CJK>
C14D 7C0D	# <CJK>
C14E 7BFE	# <CJK>
C14F 7BF7	# <CJK>
C150 7C0C	# <CJK>
C151 7BE0	# <CJK>
C152 7CE0	# <CJK>
C153 7CDC	# <CJK>
C154 7CDE	# <CJK>
C155 7CE2	# <CJK>
C156 7CDF	# <CJK>
C157 7CD9	# <CJK>
C158 7CDD	# <CJK>
C159 7E2E	# <CJK>
C15A 7E3E	# <CJK>
C15B 7E46	# <CJK>
C15C 7E37	# <CJK>
C15D 7E32	# <CJK>
C15E 7E43	# <CJK>
C15F 7E2B	# <CJK>
C160 7E3D	# <CJK>
C161 7E31	# <CJK>
C162 7E45	# <CJK>
C163 7E41	# <CJK>
C164 7E34	# <CJK>
C165 7E39	# <CJK>
C166 7E48	# <CJK>
C167 7E35	# <CJK>
C168 7E3F	# <CJK>
C169 7E2F	# <CJK>
C16A 7F44	# <CJK>
C16B 7FF3	# <CJK>
C16C 7FFC	# <CJK>
C16D 8071	# <CJK>
C16E 8072	# <CJK>
C16F 8070	# <CJK>
C170 806F	# <CJK>
C171 8073	# <CJK>
C172 81C6	# <CJK>
C173 81C3	# <CJK>
C174 81BA	# <CJK>
C175 81C2	# <CJK>
C176 81C0	# <CJK>
C177 81BF	# <CJK>
C178 81BD	# <CJK>
C179 81C9	# <CJK>
C17A 81BE	# <CJK>
C17B 81E8	# <CJK>
C17C 8209	# <CJK>
C17D 8271	# <CJK>
C17E 85AA	# <CJK>
C1A1 8584	# <CJK>
C1A2 857E	# <CJK>
C1A3 859C	# <CJK>
C1A4 8591	# <CJK>
C1A5 8594	# <CJK>
C1A6 85AF	# <CJK>
C1A7 859B	# <CJK>
C1A8 8587	# <CJK>
C1A9 85A8	# <CJK>
C1AA 858A	# <CJK>
C1AB 8667	# <CJK>
C1AC 87C0	# <CJK>
C1AD 87D1	# <CJK>
C1AE 87B3	# <CJK>
C1AF 87D2	# <CJK>
C1B0 87C6	# <CJK>
C1B1 87AB	# <CJK>
C1B2 87BB	# <CJK>
C1B3 87BA	# <CJK>
C1B4 87C8	# <CJK>
C1B5 87CB	# <CJK>
C1B6 893B	# <CJK>
C1B7 8936	# <CJK>
C1B8 8944	# <CJK>
C1B9 8938	# <CJK>
C1BA 893D	# <CJK>
C1BB 89AC	# <CJK>
C1BC 8B0E	# <CJK>
C1BD 8B17	# <CJK>
C1BE 8B19	# <CJK>
C1BF 8B1B	# <CJK>
C1C0 8B0A	# <CJK>
C1C1 8B20	# <CJK>
C1C2 8B1D	# <CJK>
C1C3 8B04	# <CJK>
C1C4 8B10	# <CJK>
C1C5 8C41	# <CJK>
C1C6 8C3F	# <CJK>
C1C7 8C73	# <CJK>
C1C8 8CFA	# <CJK>
C1C9 8CFD	# <CJK>
C1CA 8CFC	# <CJK>
C1CB 8CF8	# <CJK>
C1CC 8CFB	# <CJK>
C1CD 8DA8	# <CJK>
C1CE 8E49	# <CJK>
C1CF 8E4B	# <CJK>
C1D0 8E48	# <CJK>
C1D1 8E4A	# <CJK>
C1D2 8F44	# <CJK>
C1D3 8F3E	# <CJK>
C1D4 8F42	# <CJK>
C1D5 8F45	# <CJK>
C1D6 8F3F	# <CJK>
C1D7 907F	# <CJK>
C1D8 907D	# <CJK>
C1D9 9084	# <CJK>
C1DA 9081	# <CJK>
C1DB 9082	# <CJK>
C1DC 9080	# <CJK>
C1DD 9139	# <CJK>
C1DE 91A3	# <CJK>
C1DF 919E	# <CJK>
C1E0 919C	# <CJK>
C1E1 934D	# <CJK>
C1E2 9382	# <CJK>
C1E3 9328	# <CJK>
C1E4 9375	# <CJK>
C1E5 934A	# <CJK>
C1E6 9365	# <CJK>
C1E7 934B	# <CJK>
C1E8 9318	# <CJK>
C1E9 937E	# <CJK>
C1EA 936C	# <CJK>
C1EB 935B	# <CJK>
C1EC 9370	# <CJK>
C1ED 935A	# <CJK>
C1EE 9354	# <CJK>
C1EF 95CA	# <CJK>
C1F0 95CB	# <CJK>
C1F1 95CC	# <CJK>
C1F2 95C8	# <CJK>
C1F3 95C6	# <CJK>
C1F4 96B1	# <CJK>
C1F5 96B8	# <CJK>
C1F6 96D6	# <CJK>
C1F7 971C	# <CJK>
C1F8 971E	# <CJK>
C1F9 97A0	# <CJK>
C1FA 97D3	# <CJK>
C1FB 9846	# <CJK>
C1FC 98B6	# <CJK>
C1FD 9935	# <CJK>
C1FE 9A01	# <CJK>
C240 99FF	# <CJK>
C241 9BAE	# <CJK>
C242 9BAB	# <CJK>
C243 9BAA	# <CJK>
C244 9BAD	# <CJK>
C245 9D3B	# <CJK>
C246 9D3F	# <CJK>
C247 9E8B	# <CJK>
C248 9ECF	# <CJK>
C249 9EDE	# <CJK>
C24A 9EDC	# <CJK>
C24B 9EDD	# <CJK>
C24C 9EDB	# <CJK>
C24D 9F3E	# <CJK>
C24E 9F4B	# <CJK>
C24F 53E2	# <CJK>
C250 5695	# <CJK>
C251 56AE	# <CJK>
C252 58D9	# <CJK>
C253 58D8	# <CJK>
C254 5B38	# <CJK>
C255 5F5D	# <CJK>
C256 61E3	# <CJK>
C257 6233	# <CJK>
C258 64F4	# <CJK>
C259 64F2	# <CJK>
C25A 64FE	# <CJK>
C25B 6506	# <CJK>
C25C 64FA	# <CJK>
C25D 64FB	# <CJK>
C25E 64F7	# <CJK>
C25F 65B7	# <CJK>
C260 66DC	# <CJK>
C261 6726	# <CJK>
C262 6AB3	# <CJK>
C263 6AAC	# <CJK>
C264 6AC3	# <CJK>
C265 6ABB	# <CJK>
C266 6AB8	# <CJK>
C267 6AC2	# <CJK>
C268 6AAE	# <CJK>
C269 6AAF	# <CJK>
C26A 6B5F	# <CJK>
C26B 6B78	# <CJK>
C26C 6BAF	# <CJK>
C26D 7009	# <CJK>
C26E 700B	# <CJK>
C26F 6FFE	# <CJK>
C270 7006	# <CJK>
C271 6FFA	# <CJK>
C272 7011	# <CJK>
C273 700F	# <CJK>
C274 71FB	# <CJK>
C275 71FC	# <CJK>
C276 71FE	# <CJK>
C277 71F8	# <CJK>
C278 7377	# <CJK>
C279 7375	# <CJK>
C27A 74A7	# <CJK>
C27B 74BF	# <CJK>
C27C 7515	# <CJK>
C27D 7656	# <CJK>
C27E 7658	# <CJK>
C2A1 7652	# <CJK>
C2A2 77BD	# <CJK>
C2A3 77BF	# <CJK>
C2A4 77BB	# <CJK>
C2A5 77BC	# <CJK>
C2A6 790E	# <CJK>
C2A7 79AE	# <CJK>
C2A8 7A61	# <CJK>
C2A9 7A62	# <CJK>
C2AA 7A60	# <CJK>
C2AB 7AC4	# <CJK>
C2AC 7AC5	# <CJK>
C2AD 7C2B	# <CJK>
C2AE 7C27	# <CJK>
C2AF 7C2A	# <CJK>
C2B0 7C1E	# <CJK>
C2B1 7C23	# <CJK>
C2B2 7C21	# <CJK>
C2B3 7CE7	# <CJK>
C2B4 7E54	# <CJK>
C2B5 7E55	# <CJK>
C2B6 7E5E	# <CJK>
C2B7 7E5A	# <CJK>
C2B8 7E61	# <CJK>
C2B9 7E52	# <CJK>
C2BA 7E59	# <CJK>
C2BB 7F48	# <CJK>
C2BC 7FF9	# <CJK>
C2BD 7FFB	# <CJK>
C2BE 8077	# <CJK>
C2BF 8076	# <CJK>
C2C0 81CD	# <CJK>
C2C1 81CF	# <CJK>
C2C2 820A	# <CJK>
C2C3 85CF	# <CJK>
C2C4 85A9	# <CJK>
C2C5 85CD	# <CJK>
C2C6 85D0	# <CJK>
C2C7 85C9	# <CJK>
C2C8 85B0	# <CJK>
C2C9 85BA	# <CJK>
C2CA 85B9	# <CJK>
C2CB 85A6	# <CJK>
C2CC 87EF	# <CJK>
C2CD 87EC	# <CJK>
C2CE 87F2	# <CJK>
C2CF 87E0	# <CJK>
C2D0 8986	# <CJK>
C2D1 89B2	# <CJK>
C2D2 89F4	# <CJK>
C2D3 8B28	# <CJK>
C2D4 8B39	# <CJK>
C2D5 8B2C	# <CJK>
C2D6 8B2B	# <CJK>
C2D7 8C50	# <CJK>
C2D8 8D05	# <CJK>
C2D9 8E59	# <CJK>
C2DA 8E63	# <CJK>
C2DB 8E66	# <CJK>
C2DC 8E64	# <CJK>
C2DD 8E5F	# <CJK>
C2DE 8E55	# <CJK>
C2DF 8EC0	# <CJK>
C2E0 8F49	# <CJK>
C2E1 8F4D	# <CJK>
C2E2 9087	# <CJK>
C2E3 9083	# <CJK>
C2E4 9088	# <CJK>
C2E5 91AB	# <CJK>
C2E6 91AC	# <CJK>
C2E7 91D0	# <CJK>
C2E8 9394	# <CJK>
C2E9 938A	# <CJK>
C2EA 9396	# <CJK>
C2EB 93A2	# <CJK>
C2EC 93B3	# <CJK>
C2ED 93AE	# <CJK>
C2EE 93AC	# <CJK>
C2EF 93B0	# <CJK>
C2F0 9398	# <CJK>
C2F1 939A	# <CJK>
C2F2 9397	# <CJK>
C2F3 95D4	# <CJK>
C2F4 95D6	# <CJK>
C2F5 95D0	# <CJK>
C2F6 95D5	# <CJK>
C2F7 96E2	# <CJK>
C2F8 96DC	# <CJK>
C2F9 96D9	# <CJK>
C2FA 96DB	# <CJK>
C2FB 96DE	# <CJK>
C2FC 9724	# <CJK>
C2FD 97A3	# <CJK>
C2FE 97A6	# <CJK>
C340 97AD	# <CJK>
C341 97F9	# <CJK>
C342 984D	# <CJK>
C343 984F	# <CJK>
C344 984C	# <CJK>
C345 984E	# <CJK>
C346 9853	# <CJK>
C347 98BA	# <CJK>
C348 993E	# <CJK>
C349 993F	# <CJK>
C34A 993D	# <CJK>
C34B 992E	# <CJK>
C34C 99A5	# <CJK>
C34D 9A0E	# <CJK>
C34E 9AC1	# <CJK>
C34F 9B03	# <CJK>
C350 9B06	# <CJK>
C351 9B4F	# <CJK>
C352 9B4E	# <CJK>
C353 9B4D	# <CJK>
C354 9BCA	# <CJK>
C355 9BC9	# <CJK>
C356 9BFD	# <CJK>
C357 9BC8	# <CJK>
C358 9BC0	# <CJK>
C359 9D51	# <CJK>
C35A 9D5D	# <CJK>
C35B 9D60	# <CJK>
C35C 9EE0	# <CJK>
C35D 9F15	# <CJK>
C35E 9F2C	# <CJK>
C35F 5133	# <CJK>
C360 56A5	# <CJK>
C361 58DE	# <CJK>
C362 58DF	# <CJK>
C363 58E2	# <CJK>
C364 5BF5	# <CJK>
C365 9F90	# <CJK>
C366 5EEC	# <CJK>
C367 61F2	# <CJK>
C368 61F7	# <CJK>
C369 61F6	# <CJK>
C36A 61F5	# <CJK>
C36B 6500	# <CJK>
C36C 650F	# <CJK>
C36D 66E0	# <CJK>
C36E 66DD	# <CJK>
C36F 6AE5	# <CJK>
C370 6ADD	# <CJK>
C371 6ADA	# <CJK>
C372 6AD3	# <CJK>
C373 701B	# <CJK>
C374 701F	# <CJK>
C375 7028	# <CJK>
C376 701A	# <CJK>
C377 701D	# <CJK>
C378 7015	# <CJK>
C379 7018	# <CJK>
C37A 7206	# <CJK>
C37B 720D	# <CJK>
C37C 7258	# <CJK>
C37D 72A2	# <CJK>
C37E 7378	# <CJK>
C3A1 737A	# <CJK>
C3A2 74BD	# <CJK>
C3A3 74CA	# <CJK>
C3A4 74E3	# <CJK>
C3A5 7587	# <CJK>
C3A6 7586	# <CJK>
C3A7 765F	# <CJK>
C3A8 7661	# <CJK>
C3A9 77C7	# <CJK>
C3AA 7919	# <CJK>
C3AB 79B1	# <CJK>
C3AC 7A6B	# <CJK>
C3AD 7A69	# <CJK>
C3AE 7C3E	# <CJK>
C3AF 7C3F	# <CJK>
C3B0 7C38	# <CJK>
C3B1 7C3D	# <CJK>
C3B2 7C37	# <CJK>
C3B3 7C40	# <CJK>
C3B4 7E6B	# <CJK>
C3B5 7E6D	# <CJK>
C3B6 7E79	# <CJK>
C3B7 7E69	# <CJK>
C3B8 7E6A	# <CJK>
C3B9 7F85	# <CJK>
C3BA 7E73	# <CJK>
C3BB 7FB6	# <CJK>
C3BC 7FB9	# <CJK>
C3BD 7FB8	# <CJK>
C3BE 81D8	# <CJK>
C3BF 85E9	# <CJK>
C3C0 85DD	# <CJK>
C3C1 85EA	# <CJK>
C3C2 85D5	# <CJK>
C3C3 85E4	# <CJK>
C3C4 85E5	# <CJK>
C3C5 85F7	# <CJK>
C3C6 87FB	# <CJK>
C3C7 8805	# <CJK>
C3C8 880D	# <CJK>
C3C9 87F9	# <CJK>
C3CA 87FE	# <CJK>
C3CB 8960	# <CJK>
C3CC 895F	# <CJK>
C3CD 8956	# <CJK>
C3CE 895E	# <CJK>
C3CF 8B41	# <CJK>
C3D0 8B5C	# <CJK>
C3D1 8B58	# <CJK>
C3D2 8B49	# <CJK>
C3D3 8B5A	# <CJK>
C3D4 8B4E	# <CJK>
C3D5 8B4F	# <CJK>
C3D6 8B46	# <CJK>
C3D7 8B59	# <CJK>
C3D8 8D08	# <CJK>
C3D9 8D0A	# <CJK>
C3DA 8E7C	# <CJK>
C3DB 8E72	# <CJK>
C3DC 8E87	# <CJK>
C3DD 8E76	# <CJK>
C3DE 8E6C	# <CJK>
C3DF 8E7A	# <CJK>
C3E0 8E74	# <CJK>
C3E1 8F54	# <CJK>
C3E2 8F4E	# <CJK>
C3E3 8FAD	# <CJK>
C3E4 908A	# <CJK>
C3E5 908B	# <CJK>
C3E6 91B1	# <CJK>
C3E7 91AE	# <CJK>
C3E8 93E1	# <CJK>
C3E9 93D1	# <CJK>
C3EA 93DF	# <CJK>
C3EB 93C3	# <CJK>
C3EC 93C8	# <CJK>
C3ED 93DC	# <CJK>
C3EE 93DD	# <CJK>
C3EF 93D6	# <CJK>
C3F0 93E2	# <CJK>
C3F1 93CD	# <CJK>
C3F2 93D8	# <CJK>
C3F3 93E4	# <CJK>
C3F4 93D7	# <CJK>
C3F5 93E8	# <CJK>
C3F6 95DC	# <CJK>
C3F7 96B4	# <CJK>
C3F8 96E3	# <CJK>
C3F9 972A	# <CJK>
C3FA 9727	# <CJK>
C3FB 9761	# <CJK>
C3FC 97DC	# <CJK>
C3FD 97FB	# <CJK>
C3FE 985E	# <CJK>
C440 9858	# <CJK>
C441 985B	# <CJK>
C442 98BC	# <CJK>
C443 9945	# <CJK>
C444 9949	# <CJK>
C445 9A16	# <CJK>
C446 9A19	# <CJK>
C447 9B0D	# <CJK>
C448 9BE8	# <CJK>
C449 9BE7	# <CJK>
C44A 9BD6	# <CJK>
C44B 9BDB	# <CJK>
C44C 9D89	# <CJK>
C44D 9D61	# <CJK>
C44E 9D72	# <CJK>
C44F 9D6A	# <CJK>
C450 9D6C	# <CJK>
C451 9E92	# <CJK>
C452 9E97	# <CJK>
C453 9E93	# <CJK>
C454 9EB4	# <CJK>
C455 52F8	# <CJK>
C456 56A8	# <CJK>
C457 56B7	# <CJK>
C458 56B6	# <CJK>
C459 56B4	# <CJK>
C45A 56BC	# <CJK>
C45B 58E4	# <CJK>
C45C 5B40	# <CJK>
C45D 5B43	# <CJK>
C45E 5B7D	# <CJK>
C45F 5BF6	# <CJK>
C460 5DC9	# <CJK>
C461 61F8	# <CJK>
C462 61FA	# <CJK>
C463 6518	# <CJK>
C464 6514	# <CJK>
C465 6519	# <CJK>
C466 66E6	# <CJK>
C467 6727	# <CJK>
C468 6AEC	# <CJK>
C469 703E	# <CJK>
C46A 7030	# <CJK>
C46B 7032	# <CJK>
C46C 7210	# <CJK>
C46D 737B	# <CJK>
C46E 74CF	# <CJK>
C46F 7662	# <CJK>
C470 7665	# <CJK>
C471 7926	# <CJK>
C472 792A	# <CJK>
C473 792C	# <CJK>
C474 792B	# <CJK>
C475 7AC7	# <CJK>
C476 7AF6	# <CJK>
C477 7C4C	# <CJK>
C478 7C43	# <CJK>
C479 7C4D	# <CJK>
C47A 7CEF	# <CJK>
C47B 7CF0	# <CJK>
C47C 8FAE	# <CJK>
C47D 7E7D	# <CJK>
C47E 7E7C	# <CJK>
C4A1 7E82	# <CJK>
C4A2 7F4C	# <CJK>
C4A3 8000	# <CJK>
C4A4 81DA	# <CJK>
C4A5 8266	# <CJK>
C4A6 85FB	# <CJK>
C4A7 85F9	# <CJK>
C4A8 8611	# <CJK>
C4A9 85FA	# <CJK>
C4AA 8606	# <CJK>
C4AB 860B	# <CJK>
C4AC 8607	# <CJK>
C4AD 860A	# <CJK>
C4AE 8814	# <CJK>
C4AF 8815	# <CJK>
C4B0 8964	# <CJK>
C4B1 89BA	# <CJK>
C4B2 89F8	# <CJK>
C4B3 8B70	# <CJK>
C4B4 8B6C	# <CJK>
C4B5 8B66	# <CJK>
C4B6 8B6F	# <CJK>
C4B7 8B5F	# <CJK>
C4B8 8B6B	# <CJK>
C4B9 8D0F	# <CJK>
C4BA 8D0D	# <CJK>
C4BB 8E89	# <CJK>
C4BC 8E81	# <CJK>
C4BD 8E85	# <CJK>
C4BE 8E82	# <CJK>
C4BF 91B4	# <CJK>
C4C0 91CB	# <CJK>
C4C1 9418	# <CJK>
C4C2 9403	# <CJK>
C4C3 93FD	# <CJK>
C4C4 95E1	# <CJK>
C4C5 9730	# <CJK>
C4C6 98C4	# <CJK>
C4C7 9952	# <CJK>
C4C8 9951	# <CJK>
C4C9 99A8	# <CJK>
C4CA 9A2B	# <CJK>
C4CB 9A30	# <CJK>
C4CC 9A37	# <CJK>
C4CD 9A35	# <CJK>
C4CE 9C13	# <CJK>
C4CF 9C0D	# <CJK>
C4D0 9E79	# <CJK>
C4D1 9EB5	# <CJK>
C4D2 9EE8	# <CJK>
C4D3 9F2F	# <CJK>
C4D4 9F5F	# <CJK>
C4D5 9F63	# <CJK>
C4D6 9F61	# <CJK>
C4D7 5137	# <CJK>
C4D8 5138	# <CJK>
C4D9 56C1	# <CJK>
C4DA 56C0	# <CJK>
C4DB 56C2	# <CJK>
C4DC 5914	# <CJK>
C4DD 5C6C	# <CJK>
C4DE 5DCD	# <CJK>
C4DF 61FC	# <CJK>
C4E0 61FE	# <CJK>
C4E1 651D	# <CJK>
C4E2 651C	# <CJK>
C4E3 6595	# <CJK>
C4E4 66E9	# <CJK>
C4E5 6AFB	# <CJK>
C4E6 6B04	# <CJK>
C4E7 6AFA	# <CJK>
C4E8 6BB2	# <CJK>
C4E9 704C	# <CJK>
C4EA 721B	# <CJK>
C4EB 72A7	# <CJK>
C4EC 74D6	# <CJK>
C4ED 74D4	# <CJK>
C4EE 7669	# <CJK>
C4EF 77D3	# <CJK>
C4F0 7C50	# <CJK>
C4F1 7E8F	# <CJK>
C4F2 7E8C	# <CJK>
C4F3 7FBC	# <CJK>
C4F4 8617	# <CJK>
C4F5 862D	# <CJK>
C4F6 861A	# <CJK>
C4F7 8823	# <CJK>
C4F8 8822	# <CJK>
C4F9 8821	# <CJK>
C4FA 881F	# <CJK>
C4FB 896A	# <CJK>
C4FC 896C	# <CJK>
C4FD 89BD	# <CJK>
C4FE 8B74	# <CJK>
C540 8B77	# <CJK>
C541 8B7D	# <CJK>
C542 8D13	# <CJK>
C543 8E8A	# <CJK>
C544 8E8D	# <CJK>
C545 8E8B	# <CJK>
C546 8F5F	# <CJK>
C547 8FAF	# <CJK>
C548 91BA	# <CJK>
C549 942E	# <CJK>
C54A 9433	# <CJK>
C54B 9435	# <CJK>
C54C 943A	# <CJK>
C54D 9438	# <CJK>
C54E 9432	# <CJK>
C54F 942B	# <CJK>
C550 95E2	# <CJK>
C551 9738	# <CJK>
C552 9739	# <CJK>
C553 9732	# <CJK>
C554 97FF	# <CJK>
C555 9867	# <CJK>
C556 9865	# <CJK>
C557 9957	# <CJK>
C558 9A45	# <CJK>
C559 9A43	# <CJK>
C55A 9A40	# <CJK>
C55B 9A3E	# <CJK>
C55C 9ACF	# <CJK>
C55D 9B54	# <CJK>
C55E 9B51	# <CJK>
C55F 9C2D	# <CJK>
C560 9C25	# <CJK>
C561 9DAF	# <CJK>
C562 9DB4	# <CJK>
C563 9DC2	# <CJK>
C564 9DB8	# <CJK>
C565 9E9D	# <CJK>
C566 9EEF	# <CJK>
C567 9F19	# <CJK>
C568 9F5C	# <CJK>
C569 9F66	# <CJK>
C56A 9F67	# <CJK>
C56B 513C	# <CJK>
C56C 513B	# <CJK>
C56D 56C8	# <CJK>
C56E 56CA	# <CJK>
C56F 56C9	# <CJK>
C570 5B7F	# <CJK>
C571 5DD4	# <CJK>
C572 5DD2	# <CJK>
C573 5F4E	# <CJK>
C574 61FF	# <CJK>
C575 6524	# <CJK>
C576 6B0A	# <CJK>
C577 6B61	# <CJK>
C578 7051	# <CJK>
C579 7058	# <CJK>
C57A 7380	# <CJK>
C57B 74E4	# <CJK>
C57C 758A	# <CJK>
C57D 766E	# <CJK>
C57E 766C	# <CJK>
C5A1 79B3	# <CJK>
C5A2 7C60	# <CJK>
C5A3 7C5F	# <CJK>
C5A4 807E	# <CJK>
C5A5 807D	# <CJK>
C5A6 81DF	# <CJK>
C5A7 8972	# <CJK>
C5A8 896F	# <CJK>
C5A9 89FC	# <CJK>
C5AA 8B80	# <CJK>
C5AB 8D16	# <CJK>
C5AC 8D17	# <CJK>
C5AD 8E91	# <CJK>
C5AE 8E93	# <CJK>
C5AF 8F61	# <CJK>
C5B0 9148	# <CJK>
C5B1 9444	# <CJK>
C5B2 9451	# <CJK>
C5B3 9452	# <CJK>
C5B4 973D	# <CJK>
C5B5 973E	# <CJK>
C5B6 97C3	# <CJK>
C5B7 97C1	# <CJK>
C5B8 986B	# <CJK>
C5B9 9955	# <CJK>
C5BA 9A55	# <CJK>
C5BB 9A4D	# <CJK>
C5BC 9AD2	# <CJK>
C5BD 9B1A	# <CJK>
C5BE 9C49	# <CJK>
C5BF 9C31	# <CJK>
C5C0 9C3E	# <CJK>
C5C1 9C3B	# <CJK>
C5C2 9DD3	# <CJK>
C5C3 9DD7	# <CJK>
C5C4 9F34	# <CJK>
C5C5 9F6C	# <CJK>
C5C6 9F6A	# <CJK>
C5C7 9F94	# <CJK>
C5C8 56CC	# <CJK>
C5C9 5DD6	# <CJK>
C5CA 6200	# <CJK>
C5CB 6523	# <CJK>
C5CC 652B	# <CJK>
C5CD 652A	# <CJK>
C5CE 66EC	# <CJK>
C5CF 6B10	# <CJK>
C5D0 74DA	# <CJK>
C5D1 7ACA	# <CJK>
C5D2 7C64	# <CJK>
C5D3 7C63	# <CJK>
C5D4 7C65	# <CJK>
C5D5 7E93	# <CJK>
C5D6 7E96	# <CJK>
C5D7 7E94	# <CJK>
C5D8 81E2	# <CJK>
C5D9 8638	# <CJK>
C5DA 863F	# <CJK>
C5DB 8831	# <CJK>
C5DC 8B8A	# <CJK>
C5DD 9090	# <CJK>
C5DE 908F	# <CJK>
C5DF 9463	# <CJK>
C5E0 9460	# <CJK>
C5E1 9464	# <CJK>
C5E2 9768	# <CJK>
C5E3 986F	# <CJK>
C5E4 995C	# <CJK>
C5E5 9A5A	# <CJK>
C5E6 9A5B	# <CJK>
C5E7 9A57	# <CJK>
C5E8 9AD3	# <CJK>
C5E9 9AD4	# <CJK>
C5EA 9AD1	# <CJK>
C5EB 9C54	# <CJK>
C5EC 9C57	# <CJK>
C5ED 9C56	# <CJK>
C5EE 9DE5	# <CJK>
C5EF 9E9F	# <CJK>
C5F0 9EF4	# <CJK>
C5F1 56D1	# <CJK>
C5F2 58E9	# <CJK>
C5F3 652C	# <CJK>
C5F4 705E	# <CJK>
C5F5 7671	# <CJK>
C5F6 7672	# <CJK>
C5F7 77D7	# <CJK>
C5F8 7F50	# <CJK>
C5F9 7F88	# <CJK>
C5FA 8836	# <CJK>
C5FB 8839	# <CJK>
C5FC 8862	# <CJK>
C5FD 8B93	# <CJK>
C5FE 8B92	# <CJK>
C640 8B96	# <CJK>
C641 8277	# <CJK>
C642 8D1B	# <CJK>
C643 91C0	# <CJK>
C644 946A	# <CJK>
C645 9742	# <CJK>
C646 9748	# <CJK>
C647 9744	# <CJK>
C648 97C6	# <CJK>
C649 9870	# <CJK>
C64A 9A5F	# <CJK>
C64B 9B22	# <CJK>
C64C 9B58	# <CJK>
C64D 9C5F	# <CJK>
C64E 9DF9	# <CJK>
C64F 9DFA	# <CJK>
C650 9E7C	# <CJK>
C651 9E7D	# <CJK>
C652 9F07	# <CJK>
C653 9F77	# <CJK>
C654 9F72	# <CJK>
C655 5EF3	# <CJK>
C656 6B16	# <CJK>
C657 7063	# <CJK>
C658 7C6C	# <CJK>
C659 7C6E	# <CJK>
C65A 883B	# <CJK>
C65B 89C0	# <CJK>
C65C 8EA1	# <CJK>
C65D 91C1	# <CJK>
C65E 9472	# <CJK>
C65F 9470	# <CJK>
C660 9871	# <CJK>
C661 995E	# <CJK>
C662 9AD6	# <CJK>
C663 9B23	# <CJK>
C664 9ECC	# <CJK>
C665 7064	# <CJK>
C666 77DA	# <CJK>
C667 8B9A	# <CJK>
C668 9477	# <CJK>
C669 97C9	# <CJK>
C66A 9A62	# <CJK>
C66B 9A65	# <CJK>
C66C 7E9C	# <CJK>
C66D 8B9C	# <CJK>
C66E 8EAA	# <CJK>
C66F 91C5	# <CJK>
C670 947D	# <CJK>
C671 947E	# <CJK>
C672 947C	# <CJK>
C673 9C77	# <CJK>
C674 9C78	# <CJK>
C675 9EF7	# <CJK>
C676 8C54	# <CJK>
C677 947F	# <CJK>
C678 9E1A	# <CJK>
C679 7228	# <CJK>
C67A 9A6A	# <CJK>
C67B 9B31	# <CJK>
C67C 9E1B	# <CJK>
C67D 9E1E	# <CJK>
C67E 7C72	# <CJK>
C6A1 30FE	# KATAKANA VOICED ITERATION MARK
C6A2 309D	# HIRAGANA ITERATION MARK
C6A3 309E	# HIRAGANA VOICED ITERATION MARK
C6A4 3005	# IDEOGRAPHIC ITERATION MARK
C6A5 3041	# HIRAGANA LETTER SMALL A
C6A6 3042	# HIRAGANA LETTER A
C6A7 3043	# HIRAGANA LETTER SMALL I
C6A8 3044	# HIRAGANA LETTER I
C6A9 3045	# HIRAGANA LETTER SMALL U
C6AA 3046	# HIRAGANA LETTER U
C6AB 3047	# HIRAGANA LETTER SMALL E
C6AC 3048	# HIRAGANA LETTER E
C6AD 3049	# HIRAGANA LETTER SMALL O
C6AE 304A	# HIRAGANA LETTER O
C6AF 304B	# HIRAGANA LETTER KA
C6B0 304C	# HIRAGANA LETTER GA
C6B1 304D	# HIRAGANA LETTER KI
C6B2 304E	# HIRAGANA LETTER GI
C6B3 304F	# HIRAGANA LETTER KU
C6B4 3050	# HIRAGANA LETTER GU
C6B5 3051	# HIRAGANA LETTER KE
C6B6 3052	# HIRAGANA LETTER GE
C6B7 3053	# HIRAGANA LETTER KO
C6B8 3054	# HIRAGANA LETTER GO
C6B9 3055	# HIRAGANA LETTER SA
C6BA 3056	# HIRAGANA LETTER ZA
C6BB 3057	# HIRAGANA LETTER SI
C6BC 3058	# HIRAGANA LETTER ZI
C6BD 3059	# HIRAGANA LETTER SU
C6BE 305A	# HIRAGANA LETTER ZU
C6BF 305B	# HIRAGANA LETTER SE
C6C0 305C	# HIRAGANA LETTER ZE
C6C1 305D	# HIRAGANA LETTER SO
C6C2 305E	# HIRAGANA LETTER ZO
C6C3 305F	# HIRAGANA LETTER TA
C6C4 3060	# HIRAGANA LETTER DA
C6C5 3061	# HIRAGANA LETTER TI
C6C6 3062	# HIRAGANA LETTER DI
C6C7 3063	# HIRAGANA LETTER SMALL TU
C6C8 3064	# HIRAGANA LETTER TU
C6C9 3065	# HIRAGANA LETTER DU
C6CA 3066	# HIRAGANA LETTER TE
C6CB 3067	# HIRAGANA LETTER DE
C6CC 3068	# HIRAGANA LETTER TO
C6CD 3069	# HIRAGANA LETTER DO
C6CE 306A	# HIRAGANA LETTER NA
C6CF 306B	# HIRAGANA LETTER NI
C6D0 306C	# HIRAGANA LETTER NU
C6D1 306D	# HIRAGANA LETTER NE
C6D2 306E	# HIRAGANA LETTER NO
C6D3 306F	# HIRAGANA LETTER HA
C6D4 3070	# HIRAGANA LETTER BA
C6D5 3071	# HIRAGANA LETTER PA
C6D6 3072	# HIRAGANA LETTER HI
C6D7 3073	# HIRAGANA LETTER BI
C6D8 3074	# HIRAGANA LETTER PI
C6D9 3075	# HIRAGANA LETTER HU
C6DA 3076	# HIRAGANA LETTER BU
C6DB 3077	# HIRAGANA LETTER PU
C6DC 3078	# HIRAGANA LETTER HE
C6DD 3079	# HIRAGANA LETTER BE
C6DE 307A	# HIRAGANA LETTER PE
C6DF 307B	# HIRAGANA LETTER HO
C6E0 307C	# HIRAGANA LETTER BO
C6E1 307D	# HIRAGANA LETTER PO
C6E2 307E	# HIRAGANA LETTER MA
C6E3 307F	# HIRAGANA LETTER MI
C6E4 3080	# HIRAGANA LETTER MU
C6E5 3081	# HIRAGANA LETTER ME
C6E6 3082	# HIRAGANA LETTER MO
C6E7 3083	# HIRAGANA LETTER SMALL YA
C6E8 3084	# HIRAGANA LETTER YA
C6E9 3085	# HIRAGANA LETTER SMALL YU
C6EA 3086	# HIRAGANA LETTER YU
C6EB 3087	# HIRAGANA LETTER SMALL YO
C6EC 3088	# HIRAGANA LETTER YO
C6ED 3089	# HIRAGANA LETTER RA
C6EE 308A	# HIRAGANA LETTER RI
C6EF 308B	# HIRAGANA LETTER RU
C6F0 308C	# HIRAGANA LETTER RE
C6F1 308D	# HIRAGANA LETTER RO
C6F2 308E	# HIRAGANA LETTER SMALL WA
C6F3 308F	# HIRAGANA LETTER WA
C6F4 3090	# HIRAGANA LETTER WI
C6F5 3091	# HIRAGANA LETTER WE
C6F6 3092	# HIRAGANA LETTER WO
C6F7 3093	# HIRAGANA LETTER N
C6F8 30A1	# KATAKANA LETTER SMALL A
C6F9 30A2	# KATAKANA LETTER A
C6FA 30A3	# KATAKANA LETTER SMALL I
C6FB 30A4	# KATAKANA LETTER I
C6FC 30A5	# KATAKANA LETTER SMALL U
C6FD 30A6	# KATAKANA LETTER U
C6FE 30A7	# KATAKANA LETTER SMALL E
C740 30A8	# KATAKANA LETTER E
C741 30A9	# KATAKANA LETTER SMALL O
C742 30AA	# KATAKANA LETTER O
C743 30AB	# KATAKANA LETTER KA
C744 30AC	# KATAKANA LETTER GA
C745 30AD	# KATAKANA LETTER KI
C746 30AE	# KATAKANA LETTER GI
C747 30AF	# KATAKANA LETTER KU
C748 30B0	# KATAKANA LETTER GU
C749 30B1	# KATAKANA LETTER KE
C74A 30B2	# KATAKANA LETTER GE
C74B 30B3	# KATAKANA LETTER KO
C74C 30B4	# KATAKANA LETTER GO
C74D 30B5	# KATAKANA LETTER SA
C74E 30B6	# KATAKANA LETTER ZA
C74F 30B7	# KATAKANA LETTER SI
C750 30B8	# KATAKANA LETTER ZI
C751 30B9	# KATAKANA LETTER SU
C752 30BA	# KATAKANA LETTER ZU
C753 30BB	# KATAKANA LETTER SE
C754 30BC	# KATAKANA LETTER ZE
C755 30BD	# KATAKANA LETTER SO
C756 30BE	# KATAKANA LETTER ZO
C757 30BF	# KATAKANA LETTER TA
C758 30C0	# KATAKANA LETTER DA
C759 30C1	# KATAKANA LETTER TI
C75A 30C2	# KATAKANA LETTER DI
C75B 30C3	# KATAKANA LETTER SMALL TU
C75C 30C4	# KATAKANA LETTER TU
C75D 30C5	# KATAKANA LETTER DU
C75E 30C6	# KATAKANA LETTER TE
C75F 30C7	# KATAKANA LETTER DE
C760 30C8	# KATAKANA LETTER TO
C761 30C9	# KATAKANA LETTER DO
C762 30CA	# KATAKANA LETTER NA
C763 30CB	# KATAKANA LETTER NI
C764 30CC	# KATAKANA LETTER NU
C765 30CD	# KATAKANA LETTER NE
C766 30CE	# KATAKANA LETTER NO
C767 30CF	# KATAKANA LETTER HA
C768 30D0	# KATAKANA LETTER BA
C769 30D1	# KATAKANA LETTER PA
C76A 30D2	# KATAKANA LETTER HI
C76B 30D3	# KATAKANA LETTER BI
C76C 30D4	# KATAKANA LETTER PI
C76D 30D5	# KATAKANA LETTER HU
C76E 30D6	# KATAKANA LETTER BU
C76F 30D7	# KATAKANA LETTER PU
C770 30D8	# KATAKANA LETTER HE
C771 30D9	# KATAKANA LETTER BE
C772 30DA	# KATAKANA LETTER PE
C773 30DB	# KATAKANA LETTER HO
C774 30DC	# KATAKANA LETTER BO
C775 30DD	# KATAKANA LETTER PO
C776 30DE	# KATAKANA LETTER MA
C777 30DF	# KATAKANA LETTER MI
C778 30E0	# KATAKANA LETTER MU
C779 30E1	# KATAKANA LETTER ME
C77A 30E2	# KATAKANA LETTER MO
C77B 30E3	# KATAKANA LETTER SMALL YA
C77C 30E4	# KATAKANA LETTER YA
C77D 30E5	# KATAKANA LETTER SMALL YU
C77E 30E6	# KATAKANA LETTER YU
C7A1 30E7	# KATAKANA LETTER SMALL YO
C7A2 30E8	# KATAKANA LETTER YO
C7A3 30E9	# KATAKANA LETTER RA
C7A4 30EA	# KATAKANA LETTER RI
C7A5 30EB	# KATAKANA LETTER RU
C7A6 30EC	# KATAKANA LETTER RE
C7A7 30ED	# KATAKANA LETTER RO
C7A8 30EE	# KATAKANA LETTER SMALL WA
C7A9 30EF	# KATAKANA LETTER WA
C7AA 30F0	# KATAKANA LETTER WI
C7AB 30F1	# KATAKANA LETTER WE
C7AC 30F2	# KATAKANA LETTER WO
C7AD 30F3	# KATAKANA LETTER N
C7AE 30F4	# KATAKANA LETTER VU
C7AF 30F5	# KATAKANA LETTER SMALL KA
C7B0 30F6	# KATAKANA LETTER SMALL KE
C7B1 0414	# CYRILLIC CAPITAL LETTER DE
C7B2 0415	# CYRILLIC CAPITAL LETTER IE
C7B3 0401	# CYRILLIC CAPITAL LETTER IO
C7B4 0416	# CYRILLIC CAPITAL LETTER ZHE
C7B5 0417	# CYRILLIC CAPITAL LETTER ZE
C7B6 0418	# CYRILLIC CAPITAL LETTER I
C7B7 0419	# CYRILLIC CAPITAL LETTER SHORT I
C7B8 041A	# CYRILLIC CAPITAL LETTER KA
C7B9 041B	# CYRILLIC CAPITAL LETTER EL
C7BA 041C	# CYRILLIC CAPITAL LETTER EM
C7BB 0423	# CYRILLIC CAPITAL LETTER U
C7BC 0424	# CYRILLIC CAPITAL LETTER EF
C7BD 0425	# CYRILLIC CAPITAL LETTER HA
C7BE 0426	# CYRILLIC CAPITAL LETTER TSE
C7BF 0427	# CYRILLIC CAPITAL LETTER CHE
C7C0 0428	# CYRILLIC CAPITAL LETTER SHA
C7C1 0429	# CYRILLIC CAPITAL LETTER SHCHA
C7C2 042A	# CYRILLIC CAPITAL LETTER HARD SIGN
C7C3 042B	# CYRILLIC CAPITAL LETTER YERU
C7C4 042C	# CYRILLIC CAPITAL LETTER SOFT SIGN
C7C5 042D	# CYRILLIC CAPITAL LETTER E
C7C6 042E	# CYRILLIC CAPITAL LETTER YU
C7C7 042F	# CYRILLIC CAPITAL LETTER YA
C7C8 0430	# CYRILLIC SMALL LETTER A
C7C9 0431	# CYRILLIC SMALL LETTER BE
C7CA 0432	# CYRILLIC SMALL LETTER VE
C7CB 0433	# CYRILLIC SMALL LETTER GHE
C7CC 0434	# CYRILLIC SMALL LETTER DE
C7CD 0435	# CYRILLIC SMALL LETTER IE
C7CE 0451	# CYRILLIC SMALL LETTER IO
C7CF 0436	# CYRILLIC SMALL LETTER ZHE
C7D0 0437	# CYRILLIC SMALL LETTER ZE
C7D1 0438	# CYRILLIC SMALL LETTER I
C7D2 0439	# CYRILLIC SMALL LETTER SHORT I
C7D3 043A	# CYRILLIC SMALL LETTER KA
C7D4 043B	# CYRILLIC SMALL LETTER EL
C7D5 043C	# CYRILLIC SMALL LETTER EM
C7D6 043D	# CYRILLIC SMALL LETTER EN
C7D7 043E	# CYRILLIC SMALL LETTER O
C7D8 043F	# CYRILLIC SMALL LETTER PE
C7D9 0440	# CYRILLIC SMALL LETTER ER
C7DA 0441	# CYRILLIC SMALL LETTER ES
C7DB 0442	# CYRILLIC SMALL LETTER TE
C7DC 0443	# CYRILLIC SMALL LETTER U
C7DD 0444	# CYRILLIC SMALL LETTER EF
C7DE 0445	# CYRILLIC SMALL LETTER HA
C7DF 0446	# CYRILLIC SMALL LETTER TSE
C7E0 0447	# CYRILLIC SMALL LETTER CHE
C7E1 0448	# CYRILLIC SMALL LETTER SHA
C7E2 0449	# CYRILLIC SMALL LETTER SHCHA
C7E3 044A	# CYRILLIC SMALL LETTER HARD SIGN
C7E4 044B	# CYRILLIC SMALL LETTER YERU
C7E5 044C	# CYRILLIC SMALL LETTER SOFT SIGN
C7E6 044D	# CYRILLIC SMALL LETTER E
C7E7 044E	# CYRILLIC SMALL LETTER YU
C7E8 044F	# CYRILLIC SMALL LETTER YA
C7E9 2460	# CIRCLED DIGIT ONE
C7EA 2461	# CIRCLED DIGIT TWO
C7EB 2462	# CIRCLED DIGIT THREE
C7EC 2463	# CIRCLED DIGIT FOUR
C7ED 2464	# CIRCLED DIGIT FIVE
C7EE 2465	# CIRCLED DIGIT SIX
C7EF 2466	# CIRCLED DIGIT SEVEN
C7F0 2467	# CIRCLED DIGIT EIGHT
C7F1 2468	# CIRCLED DIGIT NINE
C7F2 2469	# CIRCLED NUMBER TEN
C7F3 2474	# PARENTHESIZED DIGIT ONE
C7F4 2475	# PARENTHESIZED DIGIT TWO
C7F5 2476	# PARENTHESIZED DIGIT THREE
C7F6 2477	# PARENTHESIZED DIGIT FOUR
C7F7 2478	# PARENTHESIZED DIGIT FIVE
C7F8 2479	# PARENTHESIZED DIGIT SIX
C7F9 247A	# PARENTHESIZED DIGIT SEVEN
C7FA 247B	# PARENTHESIZED DIGIT EIGHT
C7FB 247C	# PARENTHESIZED DIGIT NINE
C7FC 247D	# PARENTHESIZED NUMBER TEN
C940 4E42	# <CJK>
C941 4E5C	# <CJK>
C942 51F5	# <CJK>
C943 531A	# <CJK>
C944 5382	# <CJK>
C945 4E07	# <CJK>
C946 4E0C	# <CJK>
C947 4E47	# <CJK>
C948 4E8D	# <CJK>
C949 56D7	# <CJK>
C94A FA0C	# CJK COMPATIBILITY IDEOGRAPH-FA0C
C94B 5C6E	# <CJK>
C94C 5F73	# <CJK>
C94D 4E0F	# <CJK>
C94E 5187	# <CJK>
C94F 4E0E	# <CJK>
C950 4E2E	# <CJK>
C951 4E93	# <CJK>
C952 4EC2	# <CJK>
C953 4EC9	# <CJK>
C954 4EC8	# <CJK>
C955 5198	# <CJK>
C956 52FC	# <CJK>
C957 536C	# <CJK>
C958 53B9	# <CJK>
C959 5720	# <CJK>
C95A 5903	# <CJK>
C95B 592C	# <CJK>
C95C 5C10	# <CJK>
C95D 5DFF	# <CJK>
C95E 65E1	# <CJK>
C95F 6BB3	# <CJK>
C960 6BCC	# <CJK>
C961 6C14	# <CJK>
C962 723F	# <CJK>
C963 4E31	# <CJK>
C964 4E3C	# <CJK>
C965 4EE8	# <CJK>
C966 4EDC	# <CJK>
C967 4EE9	# <CJK>
C968 4EE1	# <CJK>
C969 4EDD	# <CJK>
C96A 4EDA	# <CJK>
C96B 520C	# <CJK>
C96C 531C	# <CJK>
C96D 534C	# <CJK>
C96E 5722	# <CJK>
C96F 5723	# <CJK>
C970 5917	# <CJK>
C971 592F	# <CJK>
C972 5B81	# <CJK>
C973 5B84	# <CJK>
C974 5C12	# <CJK>
C975 5C3B	# <CJK>
C976 5C74	# <CJK>
C977 5C73	# <CJK>
C978 5E04	# <CJK>
C979 5E80	# <CJK>
C97A 5E82	# <CJK>
C97B 5FC9	# <CJK>
C97C 6209	# <CJK>
C97D 6250	# <CJK>
C97E 6C15	# <CJK>
C9A1 6C36	# <CJK>
C9A2 6C43	# <CJK>
C9A3 6C3F	# <CJK>
C9A4 6C3B	# <CJK>
C9A5 72AE	# <CJK>
C9A6 72B0	# <CJK>
C9A7 738A	# <CJK>
C9A8 79B8	# <CJK>
C9A9 808A	# <CJK>
C9AA 961E	# <CJK>
C9AB 4F0E	# <CJK>
C9AC 4F18	# <CJK>
C9AD 4F2C	# <CJK>
C9AE 4EF5	# <CJK>
C9AF 4F14	# <CJK>
C9B0 4EF1	# <CJK>
C9B1 4F00	# <CJK>
C9B2 4EF7	# <CJK>
C9B3 4F08	# <CJK>
C9B4 4F1D	# <CJK>
C9B5 4F02	# <CJK>
C9B6 4F05	# <CJK>
C9B7 4F22	# <CJK>
C9B8 4F13	# <CJK>
C9B9 4F04	# <CJK>
C9BA 4EF4	# <CJK>
C9BB 4F12	# <CJK>
C9BC 51B1	# <CJK>
C9BD 5213	# <CJK>
C9BE 5209	# <CJK>
C9BF 5210	# <CJK>
C9C0 52A6	# <CJK>
C9C1 5322	# <CJK>
C9C2 531F	# <CJK>
C9C3 534D	# <CJK>
C9C4 538A	# <CJK>
C9C5 5407	# <CJK>
C9C6 56E1	# <CJK>
C9C7 56DF	# <CJK>
C9C8 572E	# <CJK>
C9C9 572A	# <CJK>
C9CA 5734	# <CJK>
C9CB 593C	# <CJK>
C9CC 5980	# <CJK>
C9CD 597C	# <CJK>
C9CE 5985	# <CJK>
C9CF 597B	# <CJK>
C9D0 597E	# <CJK>
C9D1 5977	# <CJK>
C9D2 597F	# <CJK>
C9D3 5B56	# <CJK>
C9D4 5C15	# <CJK>
C9D5 5C25	# <CJK>
C9D6 5C7C	# <CJK>
C9D7 5C7A	# <CJK>
C9D8 5C7B	# <CJK>
C9D9 5C7E	# <CJK>
C9DA 5DDF	# <CJK>
C9DB 5E75	# <CJK>
C9DC 5E84	# <CJK>
C9DD 5F02	# <CJK>
C9DE 5F1A	# <CJK>
C9DF 5F74	# <CJK>
C9E0 5FD5	# <CJK>
C9E1 5FD4	# <CJK>
C9E2 5FCF	# <CJK>
C9E3 625C	# <CJK>
C9E4 625E	# <CJK>
C9E5 6264	# <CJK>
C9E6 6261	# <CJK>
C9E7 6266	# <CJK>
C9E8 6262	# <CJK>
C9E9 6259	# <CJK>
C9EA 6260	# <CJK>
C9EB 625A	# <CJK>
C9EC 6265	# <CJK>
C9ED 65EF	# <CJK>
C9EE 65EE	# <CJK>
C9EF 673E	# <CJK>
C9F0 6739	# <CJK>
C9F1 6738	# <CJK>
C9F2 673B	# <CJK>
C9F3 673A	# <CJK>
C9F4 673F	# <CJK>
C9F5 673C	# <CJK>
C9F6 6733	# <CJK>
C9F7 6C18	# <CJK>
C9F8 6C46	# <CJK>
C9F9 6C52	# <CJK>
C9FA 6C5C	# <CJK>
C9FB 6C4F	# <CJK>
C9FC 6C4A	# <CJK>
C9FD 6C54	# <CJK>
C9FE 6C4B	# <CJK>
CA40 6C4C	# <CJK>
CA41 7071	# <CJK>
CA42 725E	# <CJK>
CA43 72B4	# <CJK>
CA44 72B5	# <CJK>
CA45 738E	# <CJK>
CA46 752A	# <CJK>
CA47 767F	# <CJK>
CA48 7A75	# <CJK>
CA49 7F51	# <CJK>
CA4A 8278	# <CJK>
CA4B 827C	# <CJK>
CA4C 8280	# <CJK>
CA4D 827D	# <CJK>
CA4E 827F	# <CJK>
CA4F 864D	# <CJK>
CA50 897E	# <CJK>
CA51 9099	# <CJK>
CA52 9097	# <CJK>
CA53 9098	# <CJK>
CA54 909B	# <CJK>
CA55 9094	# <CJK>
CA56 9622	# <CJK>
CA57 9624	# <CJK>
CA58 9620	# <CJK>
CA59 9623	# <CJK>
CA5A 4F56	# <CJK>
CA5B 4F3B	# <CJK>
CA5C 4F62	# <CJK>
CA5D 4F49	# <CJK>
CA5E 4F53	# <CJK>
CA5F 4F64	# <CJK>
CA60 4F3E	# <CJK>
CA61 4F67	# <CJK>
CA62 4F52	# <CJK>
CA63 4F5F	# <CJK>
CA64 4F41	# <CJK>
CA65 4F58	# <CJK>
CA66 4F2D	# <CJK>
CA67 4F33	# <CJK>
CA68 4F3F	# <CJK>
CA69 4F61	# <CJK>
CA6A 518F	# <CJK>
CA6B 51B9	# <CJK>
CA6C 521C	# <CJK>
CA6D 521E	# <CJK>
CA6E 5221	# <CJK>
CA6F 52AD	# <CJK>
CA70 52AE	# <CJK>
CA71 5309	# <CJK>
CA72 5363	# <CJK>
CA73 5372	# <CJK>
CA74 538E	# <CJK>
CA75 538F	# <CJK>
CA76 5430	# <CJK>
CA77 5437	# <CJK>
CA78 542A	# <CJK>
CA79 5454	# <CJK>
CA7A 5445	# <CJK>
CA7B 5419	# <CJK>
CA7C 541C	# <CJK>
CA7D 5425	# <CJK>
CA7E 5418	# <CJK>
CAA1 543D	# <CJK>
CAA2 544F	# <CJK>
CAA3 5441	# <CJK>
CAA4 5428	# <CJK>
CAA5 5424	# <CJK>
CAA6 5447	# <CJK>
CAA7 56EE	# <CJK>
CAA8 56E7	# <CJK>
CAA9 56E5	# <CJK>
CAAA 5741	# <CJK>
CAAB 5745	# <CJK>
CAAC 574C	# <CJK>
CAAD 5749	# <CJK>
CAAE 574B	# <CJK>
CAAF 5752	# <CJK>
CAB0 5906	# <CJK>
CAB1 5940	# <CJK>
CAB2 59A6	# <CJK>
CAB3 5998	# <CJK>
CAB4 59A0	# <CJK>
CAB5 5997	# <CJK>
CAB6 598E	# <CJK>
CAB7 59A2	# <CJK>
CAB8 5990	# <CJK>
CAB9 598F	# <CJK>
CABA 59A7	# <CJK>
CABB 59A1	# <CJK>
CABC 5B8E	# <CJK>
CABD 5B92	# <CJK>
CABE 5C28	# <CJK>
CABF 5C2A	# <CJK>
CAC0 5C8D	# <CJK>
CAC1 5C8F	# <CJK>
CAC2 5C88	# <CJK>
CAC3 5C8B	# <CJK>
CAC4 5C89	# <CJK>
CAC5 5C92	# <CJK>
CAC6 5C8A	# <CJK>
CAC7 5C86	# <CJK>
CAC8 5C93	# <CJK>
CAC9 5C95	# <CJK>
CACA 5DE0	# <CJK>
CACB 5E0A	# <CJK>
CACC 5E0E	# <CJK>
CACD 5E8B	# <CJK>
CACE 5E89	# <CJK>
CACF 5E8C	# <CJK>
CAD0 5E88	# <CJK>
CAD1 5E8D	# <CJK>
CAD2 5F05	# <CJK>
CAD3 5F1D	# <CJK>
CAD4 5F78	# <CJK>
CAD5 5F76	# <CJK>
CAD6 5FD2	# <CJK>
CAD7 5FD1	# <CJK>
CAD8 5FD0	# <CJK>
CAD9 5FED	# <CJK>
CADA 5FE8	# <CJK>
CADB 5FEE	# <CJK>
CADC 5FF3	# <CJK>
CADD 5FE1	# <CJK>
CADE 5FE4	# <CJK>
CADF 5FE3	# <CJK>
CAE0 5FFA	# <CJK>
CAE1 5FEF	# <CJK>
CAE2 5FF7	# <CJK>
CAE3 5FFB	# <CJK>
CAE4 6000	# <CJK>
CAE5 5FF4	# <CJK>
CAE6 623A	# <CJK>
CAE7 6283	# <CJK>
CAE8 628C	# <CJK>
CAE9 628E	# <CJK>
CAEA 628F	# <CJK>
CAEB 6294	# <CJK>
CAEC 6287	# <CJK>
CAED 6271	# <CJK>
CAEE 627B	# <CJK>
CAEF 627A	# <CJK>
CAF0 6270	# <CJK>
CAF1 6281	# <CJK>
CAF2 6288	# <CJK>
CAF3 6277	# <CJK>
CAF4 627D	# <CJK>
CAF5 6272	# <CJK>
CAF6 6274	# <CJK>
CAF7 6537	# <CJK>
CAF8 65F0	# <CJK>
CAF9 65F4	# <CJK>
CAFA 65F3	# <CJK>
CAFB 65F2	# <CJK>
CAFC 65F5	# <CJK>
CAFD 6745	# <CJK>
CAFE 6747	# <CJK>
CB40 6759	# <CJK>
CB41 6755	# <CJK>
CB42 674C	# <CJK>
CB43 6748	# <CJK>
CB44 675D	# <CJK>
CB45 674D	# <CJK>
CB46 675A	# <CJK>
CB47 674B	# <CJK>
CB48 6BD0	# <CJK>
CB49 6C19	# <CJK>
CB4A 6C1A	# <CJK>
CB4B 6C78	# <CJK>
CB4C 6C67	# <CJK>
CB4D 6C6B	# <CJK>
CB4E 6C84	# <CJK>
CB4F 6C8B	# <CJK>
CB50 6C8F	# <CJK>
CB51 6C71	# <CJK>
CB52 6C6F	# <CJK>
CB53 6C69	# <CJK>
CB54 6C9A	# <CJK>
CB55 6C6D	# <CJK>
CB56 6C87	# <CJK>
CB57 6C95	# <CJK>
CB58 6C9C	# <CJK>
CB59 6C66	# <CJK>
CB5A 6C73	# <CJK>
CB5B 6C65	# <CJK>
CB5C 6C7B	# <CJK>
CB5D 6C8E	# <CJK>
CB5E 7074	# <CJK>
CB5F 707A	# <CJK>
CB60 7263	# <CJK>
CB61 72BF	# <CJK>
CB62 72BD	# <CJK>
CB63 72C3	# <CJK>
CB64 72C6	# <CJK>
CB65 72C1	# <CJK>
CB66 72BA	# <CJK>
CB67 72C5	# <CJK>
CB68 7395	# <CJK>
CB69 7397	# <CJK>
CB6A 7393	# <CJK>
CB6B 7394	# <CJK>
CB6C 7392	# <CJK>
CB6D 753A	# <CJK>
CB6E 7539	# <CJK>
CB6F 7594	# <CJK>
CB70 7595	# <CJK>
CB71 7681	# <CJK>
CB72 793D	# <CJK>
CB73 8034	# <CJK>
CB74 8095	# <CJK>
CB75 8099	# <CJK>
CB76 8090	# <CJK>
CB77 8092	# <CJK>
CB78 809C	# <CJK>
CB79 8290	# <CJK>
CB7A 828F	# <CJK>
CB7B 8285	# <CJK>
CB7C 828E	# <CJK>
CB7D 8291	# <CJK>
CB7E 8293	# <CJK>
CBA1 828A	# <CJK>
CBA2 8283	# <CJK>
CBA3 8284	# <CJK>
CBA4 8C78	# <CJK>
CBA5 8FC9	# <CJK>
CBA6 8FBF	# <CJK>
CBA7 909F	# <CJK>
CBA8 90A1	# <CJK>
CBA9 90A5	# <CJK>
CBAA 909E	# <CJK>
CBAB 90A7	# <CJK>
CBAC 90A0	# <CJK>
CBAD 9630	# <CJK>
CBAE 9628	# <CJK>
CBAF 962F	# <CJK>
CBB0 962D	# <CJK>
CBB1 4E33	# <CJK>
CBB2 4F98	# <CJK>
CBB3 4F7C	# <CJK>
CBB4 4F85	# <CJK>
CBB5 4F7D	# <CJK>
CBB6 4F80	# <CJK>
CBB7 4F87	# <CJK>
CBB8 4F76	# <CJK>
CBB9 4F74	# <CJK>
CBBA 4F89	# <CJK>
CBBB 4F84	# <CJK>
CBBC 4F77	# <CJK>
CBBD 4F4C	# <CJK>
CBBE 4F97	# <CJK>
CBBF 4F6A	# <CJK>
CBC0 4F9A	# <CJK>
CBC1 4F79	# <CJK>
CBC2 4F81	# <CJK>
CBC3 4F78	# <CJK>
CBC4 4F90	# <CJK>
CBC5 4F9C	# <CJK>
CBC6 4F94	# <CJK>
CBC7 4F9E	# <CJK>
CBC8 4F92	# <CJK>
CBC9 4F82	# <CJK>
CBCA 4F95	# <CJK>
CBCB 4F6B	# <CJK>
CBCC 4F6E	# <CJK>
CBCD 519E	# <CJK>
CBCE 51BC	# <CJK>
CBCF 51BE	# <CJK>
CBD0 5235	# <CJK>
CBD1 5232	# <CJK>
CBD2 5233	# <CJK>
CBD3 5246	# <CJK>
CBD4 5231	# <CJK>
CBD5 52BC	# <CJK>
CBD6 530A	# <CJK>
CBD7 530B	# <CJK>
CBD8 533C	# <CJK>
CBD9 5392	# <CJK>
CBDA 5394	# <CJK>
CBDB 5487	# <CJK>
CBDC 547F	# <CJK>
CBDD 5481	# <CJK>
CBDE 5491	# <CJK>
CBDF 5482	# <CJK>
CBE0 5488	# <CJK>
CBE1 546B	# <CJK>
CBE2 547A	# <CJK>
CBE3 547E	# <CJK>
CBE4 5465	# <CJK>
CBE5 546C	# <CJK>
CBE6 5474	# <CJK>
CBE7 5466	# <CJK>
CBE8 548D	# <CJK>
CBE9 546F	# <CJK>
CBEA 5461	# <CJK>
CBEB 5460	# <CJK>
CBEC 5498	# <CJK>
CBED 5463	# <CJK>
CBEE 5467	# <CJK>
CBEF 5464	# <CJK>
CBF0 56F7	# <CJK>
CBF1 56F9	# <CJK>
CBF2 576F	# <CJK>
CBF3 5772	# <CJK>
CBF4 576D	# <CJK>
CBF5 576B	# <CJK>
CBF6 5771	# <CJK>
CBF7 5770	# <CJK>
CBF8 5776	# <CJK>
CBF9 5780	# <CJK>
CBFA 5775	# <CJK>
CBFB 577B	# <CJK>
CBFC 5773	# <CJK>
CBFD 5774	# <CJK>
CBFE 5762	# <CJK>
CC40 5768	# <CJK>
CC41 577D	# <CJK>
CC42 590C	# <CJK>
CC43 5945	# <CJK>
CC44 59B5	# <CJK>
CC45 59BA	# <CJK>
CC46 59CF	# <CJK>
CC47 59CE	# <CJK>
CC48 59B2	# <CJK>
CC49 59CC	# <CJK>
CC4A 59C1	# <CJK>
CC4B 59B6	# <CJK>
CC4C 59BC	# <CJK>
CC4D 59C3	# <CJK>
CC4E 59D6	# <CJK>
CC4F 59B1	# <CJK>
CC50 59BD	# <CJK>
CC51 59C0	# <CJK>
CC52 59C8	# <CJK>
CC53 59B4	# <CJK>
CC54 59C7	# <CJK>
CC55 5B62	# <CJK>
CC56 5B65	# <CJK>
CC57 5B93	# <CJK>
CC58 5B95	# <CJK>
CC59 5C44	# <CJK>
CC5A 5C47	# <CJK>
CC5B 5CAE	# <CJK>
CC5C 5CA4	# <CJK>
CC5D 5CA0	# <CJK>
CC5E 5CB5	# <CJK>
CC5F 5CAF	# <CJK>
CC60 5CA8	# <CJK>
CC61 5CAC	# <CJK>
CC62 5C9F	# <CJK>
CC63 5CA3	# <CJK>
CC64 5CAD	# <CJK>
CC65 5CA2	# <CJK>
CC66 5CAA	# <CJK>
CC67 5CA7	# <CJK>
CC68 5C9D	# <CJK>
CC69 5CA5	# <CJK>
CC6A 5CB6	# <CJK>
CC6B 5CB0	# <CJK>
CC6C 5CA6	# <CJK>
CC6D 5E17	# <CJK>
CC6E 5E14	# <CJK>
CC6F 5E19	# <CJK>
CC70 5F28	# <CJK>
CC71 5F22	# <CJK>
CC72 5F23	# <CJK>
CC73 5F24	# <CJK>
CC74 5F54	# <CJK>
CC75 5F82	# <CJK>
CC76 5F7E	# <CJK>
CC77 5F7D	# <CJK>
CC78 5FDE	# <CJK>
CC79 5FE5	# <CJK>
CC7A 602D	# <CJK>
CC7B 6026	# <CJK>
CC7C 6019	# <CJK>
CC7D 6032	# <CJK>
CC7E 600B	# <CJK>
CCA1 6034	# <CJK>
CCA2 600A	# <CJK>
CCA3 6017	# <CJK>
CCA4 6033	# <CJK>
CCA5 601A	# <CJK>
CCA6 601E	# <CJK>
CCA7 602C	# <CJK>
CCA8 6022	# <CJK>
CCA9 600D	# <CJK>
CCAA 6010	# <CJK>
CCAB 602E	# <CJK>
CCAC 6013	# <CJK>
CCAD 6011	# <CJK>
CCAE 600C	# <CJK>
CCAF 6009	# <CJK>
CCB0 601C	# <CJK>
CCB1 6214	# <CJK>
CCB2 623D	# <CJK>
CCB3 62AD	# <CJK>
CCB4 62B4	# <CJK>
CCB5 62D1	# <CJK>
CCB6 62BE	# <CJK>
CCB7 62AA	# <CJK>
CCB8 62B6	# <CJK>
CCB9 62CA	# <CJK>
CCBA 62AE	# <CJK>
CCBB 62B3	# <CJK>
CCBC 62AF	# <CJK>
CCBD 62BB	# <CJK>
CCBE 62A9	# <CJK>
CCBF 62B0	# <CJK>
CCC0 62B8	# <CJK>
CCC1 653D	# <CJK>
CCC2 65A8	# <CJK>
CCC3 65BB	# <CJK>
CCC4 6609	# <CJK>
CCC5 65FC	# <CJK>
CCC6 6604	# <CJK>
CCC7 6612	# <CJK>
CCC8 6608	# <CJK>
CCC9 65FB	# <CJK>
CCCA 6603	# <CJK>
CCCB 660B	# <CJK>
CCCC 660D	# <CJK>
CCCD 6605	# <CJK>
CCCE 65FD	# <CJK>
CCCF 6611	# <CJK>
CCD0 6610	# <CJK>
CCD1 66F6	# <CJK>
CCD2 670A	# <CJK>
CCD3 6785	# <CJK>
CCD4 676C	# <CJK>
CCD5 678E	# <CJK>
CCD6 6792	# <CJK>
CCD7 6776	# <CJK>
CCD8 677B	# <CJK>
CCD9 6798	# <CJK>
CCDA 6786	# <CJK>
CCDB 6784	# <CJK>
CCDC 6774	# <CJK>
CCDD 678D	# <CJK>
CCDE 678C	# <CJK>
CCDF 677A	# <CJK>
CCE0 679F	# <CJK>
CCE1 6791	# <CJK>
CCE2 6799	# <CJK>
CCE3 6783	# <CJK>
CCE4 677D	# <CJK>
CCE5 6781	# <CJK>
CCE6 6778	# <CJK>
CCE7 6779	# <CJK>
CCE8 6794	# <CJK>
CCE9 6B25	# <CJK>
CCEA 6B80	# <CJK>
CCEB 6B7E	# <CJK>
CCEC 6BDE	# <CJK>
CCED 6C1D	# <CJK>
CCEE 6C93	# <CJK>
CCEF 6CEC	# <CJK>
CCF0 6CEB	# <CJK>
CCF1 6CEE	# <CJK>
CCF2 6CD9	# <CJK>
CCF3 6CB6	# <CJK>
CCF4 6CD4	# <CJK>
CCF5 6CAD	# <CJK>
CCF6 6CE7	# <CJK>
CCF7 6CB7	# <CJK>
CCF8 6CD0	# <CJK>
CCF9 6CC2	# <CJK>
CCFA 6CBA	# <CJK>
CCFB 6CC3	# <CJK>
CCFC 6CC6	# <CJK>
CCFD 6CED	# <CJK>
CCFE 6CF2	# <CJK>
CD40 6CD2	# <CJK>
CD41 6CDD	# <CJK>
CD42 6CB4	# <CJK>
CD43 6C8A	# <CJK>
CD44 6C9D	# <CJK>
CD45 6C80	# <CJK>
CD46 6CDE	# <CJK>
CD47 6CC0	# <CJK>
CD48 6D30	# <CJK>
CD49 6CCD	# <CJK>
CD4A 6CC7	# <CJK>
CD4B 6CB0	# <CJK>
CD4C 6CF9	# <CJK>
CD4D 6CCF	# <CJK>
CD4E 6CE9	# <CJK>
CD4F 6CD1	# <CJK>
CD50 7094	# <CJK>
CD51 7098	# <CJK>
CD52 7085	# <CJK>
CD53 7093	# <CJK>
CD54 7086	# <CJK>
CD55 7084	# <CJK>
CD56 7091	# <CJK>
CD57 7096	# <CJK>
CD58 7082	# <CJK>
CD59 709A	# <CJK>
CD5A 7083	# <CJK>
CD5B 726A	# <CJK>
CD5C 72D6	# <CJK>
CD5D 72CB	# <CJK>
CD5E 72D8	# <CJK>
CD5F 72C9	# <CJK>
CD60 72DC	# <CJK>
CD61 72D2	# <CJK>
CD62 72D4	# <CJK>
CD63 72DA	# <CJK>
CD64 72CC	# <CJK>
CD65 72D1	# <CJK>
CD66 73A4	# <CJK>
CD67 73A1	# <CJK>
CD68 73AD	# <CJK>
CD69 73A6	# <CJK>
CD6A 73A2	# <CJK>
CD6B 73A0	# <CJK>
CD6C 73AC	# <CJK>
CD6D 739D	# <CJK>
CD6E 74DD	# <CJK>
CD6F 74E8	# <CJK>
CD70 753F	# <CJK>
CD71 7540	# <CJK>
CD72 753E	# <CJK>
CD73 758C	# <CJK>
CD74 7598	# <CJK>
CD75 76AF	# <CJK>
CD76 76F3	# <CJK>
CD77 76F1	# <CJK>
CD78 76F0	# <CJK>
CD79 76F5	# <CJK>
CD7A 77F8	# <CJK>
CD7B 77FC	# <CJK>
CD7C 77F9	# <CJK>
CD7D 77FB	# <CJK>
CD7E 77FA	# <CJK>
CDA1 77F7	# <CJK>
CDA2 7942	# <CJK>
CDA3 793F	# <CJK>
CDA4 79C5	# <CJK>
CDA5 7A78	# <CJK>
CDA6 7A7B	# <CJK>
CDA7 7AFB	# <CJK>
CDA8 7C75	# <CJK>
CDA9 7CFD	# <CJK>
CDAA 8035	# <CJK>
CDAB 808F	# <CJK>
CDAC 80AE	# <CJK>
CDAD 80A3	# <CJK>
CDAE 80B8	# <CJK>
CDAF 80B5	# <CJK>
CDB0 80AD	# <CJK>
CDB1 8220	# <CJK>
CDB2 82A0	# <CJK>
CDB3 82C0	# <CJK>
CDB4 82AB	# <CJK>
CDB5 829A	# <CJK>
CDB6 8298	# <CJK>
CDB7 829B	# <CJK>
CDB8 82B5	# <CJK>
CDB9 82A7	# <CJK>
CDBA 82AE	# <CJK>
CDBB 82BC	# <CJK>
CDBC 829E	# <CJK>
CDBD 82BA	# <CJK>
CDBE 82B4	# <CJK>
CDBF 82A8	# <CJK>
CDC0 82A1	# <CJK>
CDC1 82A9	# <CJK>
CDC2 82C2	# <CJK>
CDC3 82A4	# <CJK>
CDC4 82C3	# <CJK>
CDC5 82B6	# <CJK>
CDC6 82A2	# <CJK>
CDC7 8670	# <CJK>
CDC8 866F	# <CJK>
CDC9 866D	# <CJK>
CDCA 866E	# <CJK>
CDCB 8C56	# <CJK>
CDCC 8FD2	# <CJK>
CDCD 8FCB	# <CJK>
CDCE 8FD3	# <CJK>
CDCF 8FCD	# <CJK>
CDD0 8FD6	# <CJK>
CDD1 8FD5	# <CJK>
CDD2 8FD7	# <CJK>
CDD3 90B2	# <CJK>
CDD4 90B4	# <CJK>
CDD5 90AF	# <CJK>
CDD6 90B3	# <CJK>
CDD7 90B0	# <CJK>
CDD8 9639	# <CJK>
CDD9 963D	# <CJK>
CDDA 963C	# <CJK>
CDDB 963A	# <CJK>
CDDC 9643	# <CJK>
CDDD 4FCD	# <CJK>
CDDE 4FC5	# <CJK>
CDDF 4FD3	# <CJK>
CDE0 4FB2	# <CJK>
CDE1 4FC9	# <CJK>
CDE2 4FCB	# <CJK>
CDE3 4FC1	# <CJK>
CDE4 4FD4	# <CJK>
CDE5 4FDC	# <CJK>
CDE6 4FD9	# <CJK>
CDE7 4FBB	# <CJK>
CDE8 4FB3	# <CJK>
CDE9 4FDB	# <CJK>
CDEA 4FC7	# <CJK>
CDEB 4FD6	# <CJK>
CDEC 4FBA	# <CJK>
CDED 4FC0	# <CJK>
CDEE 4FB9	# <CJK>
CDEF 4FEC	# <CJK>
CDF0 5244	# <CJK>
CDF1 5249	# <CJK>
CDF2 52C0	# <CJK>
CDF3 52C2	# <CJK>
CDF4 533D	# <CJK>
CDF5 537C	# <CJK>
CDF6 5397	# <CJK>
CDF7 5396	# <CJK>
CDF8 5399	# <CJK>
CDF9 5398	# <CJK>
CDFA 54BA	# <CJK>
CDFB 54A1	# <CJK>
CDFC 54AD	# <CJK>
CDFD 54A5	# <CJK>
CDFE 54CF	# <CJK>
CE40 54C3	# <CJK>
CE41 830D	# <CJK>
CE42 54B7	# <CJK>
CE43 54AE	# <CJK>
CE44 54D6	# <CJK>
CE45 54B6	# <CJK>
CE46 54C5	# <CJK>
CE47 54C6	# <CJK>
CE48 54A0	# <CJK>
CE49 5470	# <CJK>
CE4A 54BC	# <CJK>
CE4B 54A2	# <CJK>
CE4C 54BE	# <CJK>
CE4D 5472	# <CJK>
CE4E 54DE	# <CJK>
CE4F 54B0	# <CJK>
CE50 57B5	# <CJK>
CE51 579E	# <CJK>
CE52 579F	# <CJK>
CE53 57A4	# <CJK>
CE54 578C	# <CJK>
CE55 5797	# <CJK>
CE56 579D	# <CJK>
CE57 579B	# <CJK>
CE58 5794	# <CJK>
CE59 5798	# <CJK>
CE5A 578F	# <CJK>
CE5B 5799	# <CJK>
CE5C 57A5	# <CJK>
CE5D 579A	# <CJK>
CE5E 5795	# <CJK>
CE5F 58F4	# <CJK>
CE60 590D	# <CJK>
CE61 5953	# <CJK>
CE62 59E1	# <CJK>
CE63 59DE	# <CJK>
CE64 59EE	# <CJK>
CE65 5A00	# <CJK>
CE66 59F1	# <CJK>
CE67 59DD	# <CJK>
CE68 59FA	# <CJK>
CE69 59FD	# <CJK>
CE6A 59FC	# <CJK>
CE6B 59F6	# <CJK>
CE6C 59E4	# <CJK>
CE6D 59F2	# <CJK>
CE6E 59F7	# <CJK>
CE6F 59DB	# <CJK>
CE70 59E9	# <CJK>
CE71 59F3	# <CJK>
CE72 59F5	# <CJK>
CE73 59E0	# <CJK>
CE74 59FE	# <CJK>
CE75 59F4	# <CJK>
CE76 59ED	# <CJK>
CE77 5BA8	# <CJK>
CE78 5C4C	# <CJK>
CE79 5CD0	# <CJK>
CE7A 5CD8	# <CJK>
CE7B 5CCC	# <CJK>
CE7C 5CD7	# <CJK>
CE7D 5CCB	# <CJK>
CE7E 5CDB	# <CJK>
CEA1 5CDE	# <CJK>
CEA2 5CDA	# <CJK>
CEA3 5CC9	# <CJK>
CEA4 5CC7	# <CJK>
CEA5 5CCA	# <CJK>
CEA6 5CD6	# <CJK>
CEA7 5CD3	# <CJK>
CEA8 5CD4	# <CJK>
CEA9 5CCF	# <CJK>
CEAA 5CC8	# <CJK>
CEAB 5CC6	# <CJK>
CEAC 5CCE	# <CJK>
CEAD 5CDF	# <CJK>
CEAE 5CF8	# <CJK>
CEAF 5DF9	# <CJK>
CEB0 5E21	# <CJK>
CEB1 5E22	# <CJK>
CEB2 5E23	# <CJK>
CEB3 5E20	# <CJK>
CEB4 5E24	# <CJK>
CEB5 5EB0	# <CJK>
CEB6 5EA4	# <CJK>
CEB7 5EA2	# <CJK>
CEB8 5E9B	# <CJK>
CEB9 5EA3	# <CJK>
CEBA 5EA5	# <CJK>
CEBB 5F07	# <CJK>
CEBC 5F2E	# <CJK>
CEBD 5F56	# <CJK>
CEBE 5F86	# <CJK>
CEBF 6037	# <CJK>
CEC0 6039	# <CJK>
CEC1 6054	# <CJK>
CEC2 6072	# <CJK>
CEC3 605E	# <CJK>
CEC4 6045	# <CJK>
CEC5 6053	# <CJK>
CEC6 6047	# <CJK>
CEC7 6049	# <CJK>
CEC8 605B	# <CJK>
CEC9 604C	# <CJK>
CECA 6040	# <CJK>
CECB 6042	# <CJK>
CECC 605F	# <CJK>
CECD 6024	# <CJK>
CECE 6044	# <CJK>
CECF 6058	# <CJK>
CED0 6066	# <CJK>
CED1 606E	# <CJK>
CED2 6242	# <CJK>
CED3 6243	# <CJK>
CED4 62CF	# <CJK>
CED5 630D	# <CJK>
CED6 630B	# <CJK>
CED7 62F5	# <CJK>
CED8 630E	# <CJK>
CED9 6303	# <CJK>
CEDA 62EB	# <CJK>
CEDB 62F9	# <CJK>
CEDC 630F	# <CJK>
CEDD 630C	# <CJK>
CEDE 62F8	# <CJK>
CEDF 62F6	# <CJK>
CEE0 6300	# <CJK>
CEE1 6313	# <CJK>
CEE2 6314	# <CJK>
CEE3 62FA	# <CJK>
CEE4 6315	# <CJK>
CEE5 62FB	# <CJK>
CEE6 62F0	# <CJK>
CEE7 6541	# <CJK>
CEE8 6543	# <CJK>
CEE9 65AA	# <CJK>
CEEA 65BF	# <CJK>
CEEB 6636	# <CJK>
CEEC 6621	# <CJK>
CEED 6632	# <CJK>
CEEE 6635	# <CJK>
CEEF 661C	# <CJK>
CEF0 6626	# <CJK>
CEF1 6622	# <CJK>
CEF2 6633	# <CJK>
CEF3 662B	# <CJK>
CEF4 663A	# <CJK>
CEF5 661D	# <CJK>
CEF6 6634	# <CJK>
CEF7 6639	# <CJK>
CEF8 662E	# <CJK>
CEF9 670F	# <CJK>
CEFA 6710	# <CJK>
CEFB 67C1	# <CJK>
CEFC 67F2	# <CJK>
CEFD 67C8	# <CJK>
CEFE 67BA	# <CJK>
CF40 67DC	# <CJK>
CF41 67BB	# <CJK>
CF42 67F8	# <CJK>
CF43 67D8	# <CJK>
CF44 67C0	# <CJK>
CF45 67B7	# <CJK>
CF46 67C5	# <CJK>
CF47 67EB	# <CJK>
CF48 67E4	# <CJK>
CF49 67DF	# <CJK>
CF4A 67B5	# <CJK>
CF4B 67CD	# <CJK>
CF4C 67B3	# <CJK>
CF4D 67F7	# <CJK>
CF4E 67F6	# <CJK>
CF4F 67EE	# <CJK>
CF50 67E3	# <CJK>
CF51 67C2	# <CJK>
CF52 67B9	# <CJK>
CF53 67CE	# <CJK>
CF54 67E7	# <CJK>
CF55 67F0	# <CJK>
CF56 67B2	# <CJK>
CF57 67FC	# <CJK>
CF58 67C6	# <CJK>
CF59 67ED	# <CJK>
CF5A 67CC	# <CJK>
CF5B 67AE	# <CJK>
CF5C 67E6	# <CJK>
CF5D 67DB	# <CJK>
CF5E 67FA	# <CJK>
CF5F 67C9	# <CJK>
CF60 67CA	# <CJK>
CF61 67C3	# <CJK>
CF62 67EA	# <CJK>
CF63 67CB	# <CJK>
CF64 6B28	# <CJK>
CF65 6B82	# <CJK>
CF66 6B84	# <CJK>
CF67 6BB6	# <CJK>
CF68 6BD6	# <CJK>
CF69 6BD8	# <CJK>
CF6A 6BE0	# <CJK>
CF6B 6C20	# <CJK>
CF6C 6C21	# <CJK>
CF6D 6D28	# <CJK>
CF6E 6D34	# <CJK>
CF6F 6D2D	# <CJK>
CF70 6D1F	# <CJK>
CF71 6D3C	# <CJK>
CF72 6D3F	# <CJK>
CF73 6D12	# <CJK>
CF74 6D0A	# <CJK>
CF75 6CDA	# <CJK>
CF76 6D33	# <CJK>
CF77 6D04	# <CJK>
CF78 6D19	# <CJK>
CF79 6D3A	# <CJK>
CF7A 6D1A	# <CJK>
CF7B 6D11	# <CJK>
CF7C 6D00	# <CJK>
CF7D 6D1D	# <CJK>
CF7E 6D42	# <CJK>
CFA1 6D01	# <CJK>
CFA2 6D18	# <CJK>
CFA3 6D37	# <CJK>
CFA4 6D03	# <CJK>
CFA5 6D0F	# <CJK>
CFA6 6D40	# <CJK>
CFA7 6D07	# <CJK>
CFA8 6D20	# <CJK>
CFA9 6D2C	# <CJK>
CFAA 6D08	# <CJK>
CFAB 6D22	# <CJK>
CFAC 6D09	# <CJK>
CFAD 6D10	# <CJK>
CFAE 70B7	# <CJK>
CFAF 709F	# <CJK>
CFB0 70BE	# <CJK>
CFB1 70B1	# <CJK>
CFB2 70B0	# <CJK>
CFB3 70A1	# <CJK>
CFB4 70B4	# <CJK>
CFB5 70B5	# <CJK>
CFB6 70A9	# <CJK>
CFB7 7241	# <CJK>
CFB8 7249	# <CJK>
CFB9 724A	# <CJK>
CFBA 726C	# <CJK>
CFBB 7270	# <CJK>
CFBC 7273	# <CJK>
CFBD 726E	# <CJK>
CFBE 72CA	# <CJK>
CFBF 72E4	# <CJK>
CFC0 72E8	# <CJK>
CFC1 72EB	# <CJK>
CFC2 72DF	# <CJK>
CFC3 72EA	# <CJK>
CFC4 72E6	# <CJK>
CFC5 72E3	# <CJK>
CFC6 7385	# <CJK>
CFC7 73CC	# <CJK>
CFC8 73C2	# <CJK>
CFC9 73C8	# <CJK>
CFCA 73C5	# <CJK>
CFCB 73B9	# <CJK>
CFCC 73B6	# <CJK>
CFCD 73B5	# <CJK>
CFCE 73B4	# <CJK>
CFCF 73EB	# <CJK>
CFD0 73BF	# <CJK>
CFD1 73C7	# <CJK>
CFD2 73BE	# <CJK>
CFD3 73C3	# <CJK>
CFD4 73C6	# <CJK>
CFD5 73B8	# <CJK>
CFD6 73CB	# <CJK>
CFD7 74EC	# <CJK>
CFD8 74EE	# <CJK>
CFD9 752E	# <CJK>
CFDA 7547	# <CJK>
CFDB 7548	# <CJK>
CFDC 75A7	# <CJK>
CFDD 75AA	# <CJK>
CFDE 7679	# <CJK>
CFDF 76C4	# <CJK>
CFE0 7708	# <CJK>
CFE1 7703	# <CJK>
CFE2 7704	# <CJK>
CFE3 7705	# <CJK>
CFE4 770A	# <CJK>
CFE5 76F7	# <CJK>
CFE6 76FB	# <CJK>
CFE7 76FA	# <CJK>
CFE8 77E7	# <CJK>
CFE9 77E8	# <CJK>
CFEA 7806	# <CJK>
CFEB 7811	# <CJK>
CFEC 7812	# <CJK>
CFED 7805	# <CJK>
CFEE 7810	# <CJK>
CFEF 780F	# <CJK>
CFF0 780E	# <CJK>
CFF1 7809	# <CJK>
CFF2 7803	# <CJK>
CFF3 7813	# <CJK>
CFF4 794A	# <CJK>
CFF5 794C	# <CJK>
CFF6 794B	# <CJK>
CFF7 7945	# <CJK>
CFF8 7944	# <CJK>
CFF9 79D5	# <CJK>
CFFA 79CD	# <CJK>
CFFB 79CF	# <CJK>
CFFC 79D6	# <CJK>
CFFD 79CE	# <CJK>
CFFE 7A80	# <CJK>
D040 7A7E	# <CJK>
D041 7AD1	# <CJK>
D042 7B00	# <CJK>
D043 7B01	# <CJK>
D044 7C7A	# <CJK>
D045 7C78	# <CJK>
D046 7C79	# <CJK>
D047 7C7F	# <CJK>
D048 7C80	# <CJK>
D049 7C81	# <CJK>
D04A 7D03	# <CJK>
D04B 7D08	# <CJK>
D04C 7D01	# <CJK>
D04D 7F58	# <CJK>
D04E 7F91	# <CJK>
D04F 7F8D	# <CJK>
D050 7FBE	# <CJK>
D051 8007	# <CJK>
D052 800E	# <CJK>
D053 800F	# <CJK>
D054 8014	# <CJK>
D055 8037	# <CJK>
D056 80D8	# <CJK>
D057 80C7	# <CJK>
D058 80E0	# <CJK>
D059 80D1	# <CJK>
D05A 80C8	# <CJK>
D05B 80C2	# <CJK>
D05C 80D0	# <CJK>
D05D 80C5	# <CJK>
D05E 80E3	# <CJK>
D05F 80D9	# <CJK>
D060 80DC	# <CJK>
D061 80CA	# <CJK>
D062 80D5	# <CJK>
D063 80C9	# <CJK>
D064 80CF	# <CJK>
D065 80D7	# <CJK>
D066 80E6	# <CJK>
D067 80CD	# <CJK>
D068 81FF	# <CJK>
D069 8221	# <CJK>
D06A 8294	# <CJK>
D06B 82D9	# <CJK>
D06C 82FE	# <CJK>
D06D 82F9	# <CJK>
D06E 8307	# <CJK>
D06F 82E8	# <CJK>
D070 8300	# <CJK>
D071 82D5	# <CJK>
D072 833A	# <CJK>
D073 82EB	# <CJK>
D074 82D6	# <CJK>
D075 82F4	# <CJK>
D076 82EC	# <CJK>
D077 82E1	# <CJK>
D078 82F2	# <CJK>
D079 82F5	# <CJK>
D07A 830C	# <CJK>
D07B 82FB	# <CJK>
D07C 82F6	# <CJK>
D07D 82F0	# <CJK>
D07E 82EA	# <CJK>
D0A1 82E4	# <CJK>
D0A2 82E0	# <CJK>
D0A3 82FA	# <CJK>
D0A4 82F3	# <CJK>
D0A5 82ED	# <CJK>
D0A6 8677	# <CJK>
D0A7 8674	# <CJK>
D0A8 867C	# <CJK>
D0A9 8673	# <CJK>
D0AA 8841	# <CJK>
D0AB 884E	# <CJK>
D0AC 8867	# <CJK>
D0AD 886A	# <CJK>
D0AE 8869	# <CJK>
D0AF 89D3	# <CJK>
D0B0 8A04	# <CJK>
D0B1 8A07	# <CJK>
D0B2 8D72	# <CJK>
D0B3 8FE3	# <CJK>
D0B4 8FE1	# <CJK>
D0B5 8FEE	# <CJK>
D0B6 8FE0	# <CJK>
D0B7 90F1	# <CJK>
D0B8 90BD	# <CJK>
D0B9 90BF	# <CJK>
D0BA 90D5	# <CJK>
D0BB 90C5	# <CJK>
D0BC 90BE	# <CJK>
D0BD 90C7	# <CJK>
D0BE 90CB	# <CJK>
D0BF 90C8	# <CJK>
D0C0 91D4	# <CJK>
D0C1 91D3	# <CJK>
D0C2 9654	# <CJK>
D0C3 964F	# <CJK>
D0C4 9651	# <CJK>
D0C5 9653	# <CJK>
D0C6 964A	# <CJK>
D0C7 964E	# <CJK>
D0C8 501E	# <CJK>
D0C9 5005	# <CJK>
D0CA 5007	# <CJK>
D0CB 5013	# <CJK>
D0CC 5022	# <CJK>
D0CD 5030	# <CJK>
D0CE 501B	# <CJK>
D0CF 4FF5	# <CJK>
D0D0 4FF4	# <CJK>
D0D1 5033	# <CJK>
D0D2 5037	# <CJK>
D0D3 502C	# <CJK>
D0D4 4FF6	# <CJK>
D0D5 4FF7	# <CJK>
D0D6 5017	# <CJK>
D0D7 501C	# <CJK>
D0D8 5020	# <CJK>
D0D9 5027	# <CJK>
D0DA 5035	# <CJK>
D0DB 502F	# <CJK>
D0DC 5031	# <CJK>
D0DD 500E	# <CJK>
D0DE 515A	# <CJK>
D0DF 5194	# <CJK>
D0E0 5193	# <CJK>
D0E1 51CA	# <CJK>
D0E2 51C4	# <CJK>
D0E3 51C5	# <CJK>
D0E4 51C8	# <CJK>
D0E5 51CE	# <CJK>
D0E6 5261	# <CJK>
D0E7 525A	# <CJK>
D0E8 5252	# <CJK>
D0E9 525E	# <CJK>
D0EA 525F	# <CJK>
D0EB 5255	# <CJK>
D0EC 5262	# <CJK>
D0ED 52CD	# <CJK>
D0EE 530E	# <CJK>
D0EF 539E	# <CJK>
D0F0 5526	# <CJK>
D0F1 54E2	# <CJK>
D0F2 5517	# <CJK>
D0F3 5512	# <CJK>
D0F4 54E7	# <CJK>
D0F5 54F3	# <CJK>
D0F6 54E4	# <CJK>
D0F7 551A	# <CJK>
D0F8 54FF	# <CJK>
D0F9 5504	# <CJK>
D0FA 5508	# <CJK>
D0FB 54EB	# <CJK>
D0FC 5511	# <CJK>
D0FD 5505	# <CJK>
D0FE 54F1	# <CJK>
D140 550A	# <CJK>
D141 54FB	# <CJK>
D142 54F7	# <CJK>
D143 54F8	# <CJK>
D144 54E0	# <CJK>
D145 550E	# <CJK>
D146 5503	# <CJK>
D147 550B	# <CJK>
D148 5701	# <CJK>
D149 5702	# <CJK>
D14A 57CC	# <CJK>
D14B 5832	# <CJK>
D14C 57D5	# <CJK>
D14D 57D2	# <CJK>
D14E 57BA	# <CJK>
D14F 57C6	# <CJK>
D150 57BD	# <CJK>
D151 57BC	# <CJK>
D152 57B8	# <CJK>
D153 57B6	# <CJK>
D154 57BF	# <CJK>
D155 57C7	# <CJK>
D156 57D0	# <CJK>
D157 57B9	# <CJK>
D158 57C1	# <CJK>
D159 590E	# <CJK>
D15A 594A	# <CJK>
D15B 5A19	# <CJK>
D15C 5A16	# <CJK>
D15D 5A2D	# <CJK>
D15E 5A2E	# <CJK>
D15F 5A15	# <CJK>
D160 5A0F	# <CJK>
D161 5A17	# <CJK>
D162 5A0A	# <CJK>
D163 5A1E	# <CJK>
D164 5A33	# <CJK>
D165 5B6C	# <CJK>
D166 5BA7	# <CJK>
D167 5BAD	# <CJK>
D168 5BAC	# <CJK>
D169 5C03	# <CJK>
D16A 5C56	# <CJK>
D16B 5C54	# <CJK>
D16C 5CEC	# <CJK>
D16D 5CFF	# <CJK>
D16E 5CEE	# <CJK>
D16F 5CF1	# <CJK>
D170 5CF7	# <CJK>
D171 5D00	# <CJK>
D172 5CF9	# <CJK>
D173 5E29	# <CJK>
D174 5E28	# <CJK>
D175 5EA8	# <CJK>
D176 5EAE	# <CJK>
D177 5EAA	# <CJK>
D178 5EAC	# <CJK>
D179 5F33	# <CJK>
D17A 5F30	# <CJK>
D17B 5F67	# <CJK>
D17C 605D	# <CJK>
D17D 605A	# <CJK>
D17E 6067	# <CJK>
D1A1 6041	# <CJK>
D1A2 60A2	# <CJK>
D1A3 6088	# <CJK>
D1A4 6080	# <CJK>
D1A5 6092	# <CJK>
D1A6 6081	# <CJK>
D1A7 609D	# <CJK>
D1A8 6083	# <CJK>
D1A9 6095	# <CJK>
D1AA 609B	# <CJK>
D1AB 6097	# <CJK>
D1AC 6087	# <CJK>
D1AD 609C	# <CJK>
D1AE 608E	# <CJK>
D1AF 6219	# <CJK>
D1B0 6246	# <CJK>
D1B1 62F2	# <CJK>
D1B2 6310	# <CJK>
D1B3 6356	# <CJK>
D1B4 632C	# <CJK>
D1B5 6344	# <CJK>
D1B6 6345	# <CJK>
D1B7 6336	# <CJK>
D1B8 6343	# <CJK>
D1B9 63E4	# <CJK>
D1BA 6339	# <CJK>
D1BB 634B	# <CJK>
D1BC 634A	# <CJK>
D1BD 633C	# <CJK>
D1BE 6329	# <CJK>
D1BF 6341	# <CJK>
D1C0 6334	# <CJK>
D1C1 6358	# <CJK>
D1C2 6354	# <CJK>
D1C3 6359	# <CJK>
D1C4 632D	# <CJK>
D1C5 6347	# <CJK>
D1C6 6333	# <CJK>
D1C7 635A	# <CJK>
D1C8 6351	# <CJK>
D1C9 6338	# <CJK>
D1CA 6357	# <CJK>
D1CB 6340	# <CJK>
D1CC 6348	# <CJK>
D1CD 654A	# <CJK>
D1CE 6546	# <CJK>
D1CF 65C6	# <CJK>
D1D0 65C3	# <CJK>
D1D1 65C4	# <CJK>
D1D2 65C2	# <CJK>
D1D3 664A	# <CJK>
D1D4 665F	# <CJK>
D1D5 6647	# <CJK>
D1D6 6651	# <CJK>
D1D7 6712	# <CJK>
D1D8 6713	# <CJK>
D1D9 681F	# <CJK>
D1DA 681A	# <CJK>
D1DB 6849	# <CJK>
D1DC 6832	# <CJK>
D1DD 6833	# <CJK>
D1DE 683B	# <CJK>
D1DF 684B	# <CJK>
D1E0 684F	# <CJK>
D1E1 6816	# <CJK>
D1E2 6831	# <CJK>
D1E3 681C	# <CJK>
D1E4 6835	# <CJK>
D1E5 682B	# <CJK>
D1E6 682D	# <CJK>
D1E7 682F	# <CJK>
D1E8 684E	# <CJK>
D1E9 6844	# <CJK>
D1EA 6834	# <CJK>
D1EB 681D	# <CJK>
D1EC 6812	# <CJK>
D1ED 6814	# <CJK>
D1EE 6826	# <CJK>
D1EF 6828	# <CJK>
D1F0 682E	# <CJK>
D1F1 684D	# <CJK>
D1F2 683A	# <CJK>
D1F3 6825	# <CJK>
D1F4 6820	# <CJK>
D1F5 6B2C	# <CJK>
D1F6 6B2F	# <CJK>
D1F7 6B2D	# <CJK>
D1F8 6B31	# <CJK>
D1F9 6B34	# <CJK>
D1FA 6B6D	# <CJK>
D1FB 8082	# <CJK>
D1FC 6B88	# <CJK>
D1FD 6BE6	# <CJK>
D1FE 6BE4	# <CJK>
D240 6BE8	# <CJK>
D241 6BE3	# <CJK>
D242 6BE2	# <CJK>
D243 6BE7	# <CJK>
D244 6C25	# <CJK>
D245 6D7A	# <CJK>
D246 6D63	# <CJK>
D247 6D64	# <CJK>
D248 6D76	# <CJK>
D249 6D0D	# <CJK>
D24A 6D61	# <CJK>
D24B 6D92	# <CJK>
D24C 6D58	# <CJK>
D24D 6D62	# <CJK>
D24E 6D6D	# <CJK>
D24F 6D6F	# <CJK>
D250 6D91	# <CJK>
D251 6D8D	# <CJK>
D252 6DEF	# <CJK>
D253 6D7F	# <CJK>
D254 6D86	# <CJK>
D255 6D5E	# <CJK>
D256 6D67	# <CJK>
D257 6D60	# <CJK>
D258 6D97	# <CJK>
D259 6D70	# <CJK>
D25A 6D7C	# <CJK>
D25B 6D5F	# <CJK>
D25C 6D82	# <CJK>
D25D 6D98	# <CJK>
D25E 6D2F	# <CJK>
D25F 6D68	# <CJK>
D260 6D8B	# <CJK>
D261 6D7E	# <CJK>
D262 6D80	# <CJK>
D263 6D84	# <CJK>
D264 6D16	# <CJK>
D265 6D83	# <CJK>
D266 6D7B	# <CJK>
D267 6D7D	# <CJK>
D268 6D75	# <CJK>
D269 6D90	# <CJK>
D26A 70DC	# <CJK>
D26B 70D3	# <CJK>
D26C 70D1	# <CJK>
D26D 70DD	# <CJK>
D26E 70CB	# <CJK>
D26F 7F39	# <CJK>
D270 70E2	# <CJK>
D271 70D7	# <CJK>
D272 70D2	# <CJK>
D273 70DE	# <CJK>
D274 70E0	# <CJK>
D275 70D4	# <CJK>
D276 70CD	# <CJK>
D277 70C5	# <CJK>
D278 70C6	# <CJK>
D279 70C7	# <CJK>
D27A 70DA	# <CJK>
D27B 70CE	# <CJK>
D27C 70E1	# <CJK>
D27D 7242	# <CJK>
D27E 7278	# <CJK>
D2A1 7277	# <CJK>
D2A2 7276	# <CJK>
D2A3 7300	# <CJK>
D2A4 72FA	# <CJK>
D2A5 72F4	# <CJK>
D2A6 72FE	# <CJK>
D2A7 72F6	# <CJK>
D2A8 72F3	# <CJK>
D2A9 72FB	# <CJK>
D2AA 7301	# <CJK>
D2AB 73D3	# <CJK>
D2AC 73D9	# <CJK>
D2AD 73E5	# <CJK>
D2AE 73D6	# <CJK>
D2AF 73BC	# <CJK>
D2B0 73E7	# <CJK>
D2B1 73E3	# <CJK>
D2B2 73E9	# <CJK>
D2B3 73DC	# <CJK>
D2B4 73D2	# <CJK>
D2B5 73DB	# <CJK>
D2B6 73D4	# <CJK>
D2B7 73DD	# <CJK>
D2B8 73DA	# <CJK>
D2B9 73D7	# <CJK>
D2BA 73D8	# <CJK>
D2BB 73E8	# <CJK>
D2BC 74DE	# <CJK>
D2BD 74DF	# <CJK>
D2BE 74F4	# <CJK>
D2BF 74F5	# <CJK>
D2C0 7521	# <CJK>
D2C1 755B	# <CJK>
D2C2 755F	# <CJK>
D2C3 75B0	# <CJK>
D2C4 75C1	# <CJK>
D2C5 75BB	# <CJK>
D2C6 75C4	# <CJK>
D2C7 75C0	# <CJK>
D2C8 75BF	# <CJK>
D2C9 75B6	# <CJK>
D2CA 75BA	# <CJK>
D2CB 768A	# <CJK>
D2CC 76C9	# <CJK>
D2CD 771D	# <CJK>
D2CE 771B	# <CJK>
D2CF 7710	# <CJK>
D2D0 7713	# <CJK>
D2D1 7712	# <CJK>
D2D2 7723	# <CJK>
D2D3 7711	# <CJK>
D2D4 7715	# <CJK>
D2D5 7719	# <CJK>
D2D6 771A	# <CJK>
D2D7 7722	# <CJK>
D2D8 7727	# <CJK>
D2D9 7823	# <CJK>
D2DA 782C	# <CJK>
D2DB 7822	# <CJK>
D2DC 7835	# <CJK>
D2DD 782F	# <CJK>
D2DE 7828	# <CJK>
D2DF 782E	# <CJK>
D2E0 782B	# <CJK>
D2E1 7821	# <CJK>
D2E2 7829	# <CJK>
D2E3 7833	# <CJK>
D2E4 782A	# <CJK>
D2E5 7831	# <CJK>
D2E6 7954	# <CJK>
D2E7 795B	# <CJK>
D2E8 794F	# <CJK>
D2E9 795C	# <CJK>
D2EA 7953	# <CJK>
D2EB 7952	# <CJK>
D2EC 7951	# <CJK>
D2ED 79EB	# <CJK>
D2EE 79EC	# <CJK>
D2EF 79E0	# <CJK>
D2F0 79EE	# <CJK>
D2F1 79ED	# <CJK>
D2F2 79EA	# <CJK>
D2F3 79DC	# <CJK>
D2F4 79DE	# <CJK>
D2F5 79DD	# <CJK>
D2F6 7A86	# <CJK>
D2F7 7A89	# <CJK>
D2F8 7A85	# <CJK>
D2F9 7A8B	# <CJK>
D2FA 7A8C	# <CJK>
D2FB 7A8A	# <CJK>
D2FC 7A87	# <CJK>
D2FD 7AD8	# <CJK>
D2FE 7B10	# <CJK>
D340 7B04	# <CJK>
D341 7B13	# <CJK>
D342 7B05	# <CJK>
D343 7B0F	# <CJK>
D344 7B08	# <CJK>
D345 7B0A	# <CJK>
D346 7B0E	# <CJK>
D347 7B09	# <CJK>
D348 7B12	# <CJK>
D349 7C84	# <CJK>
D34A 7C91	# <CJK>
D34B 7C8A	# <CJK>
D34C 7C8C	# <CJK>
D34D 7C88	# <CJK>
D34E 7C8D	# <CJK>
D34F 7C85	# <CJK>
D350 7D1E	# <CJK>
D351 7D1D	# <CJK>
D352 7D11	# <CJK>
D353 7D0E	# <CJK>
D354 7D18	# <CJK>
D355 7D16	# <CJK>
D356 7D13	# <CJK>
D357 7D1F	# <CJK>
D358 7D12	# <CJK>
D359 7D0F	# <CJK>
D35A 7D0C	# <CJK>
D35B 7F5C	# <CJK>
D35C 7F61	# <CJK>
D35D 7F5E	# <CJK>
D35E 7F60	# <CJK>
D35F 7F5D	# <CJK>
D360 7F5B	# <CJK>
D361 7F96	# <CJK>
D362 7F92	# <CJK>
D363 7FC3	# <CJK>
D364 7FC2	# <CJK>
D365 7FC0	# <CJK>
D366 8016	# <CJK>
D367 803E	# <CJK>
D368 8039	# <CJK>
D369 80FA	# <CJK>
D36A 80F2	# <CJK>
D36B 80F9	# <CJK>
D36C 80F5	# <CJK>
D36D 8101	# <CJK>
D36E 80FB	# <CJK>
D36F 8100	# <CJK>
D370 8201	# <CJK>
D371 822F	# <CJK>
D372 8225	# <CJK>
D373 8333	# <CJK>
D374 832D	# <CJK>
D375 8344	# <CJK>
D376 8319	# <CJK>
D377 8351	# <CJK>
D378 8325	# <CJK>
D379 8356	# <CJK>
D37A 833F	# <CJK>
D37B 8341	# <CJK>
D37C 8326	# <CJK>
D37D 831C	# <CJK>
D37E 8322	# <CJK>
D3A1 8342	# <CJK>
D3A2 834E	# <CJK>
D3A3 831B	# <CJK>
D3A4 832A	# <CJK>
D3A5 8308	# <CJK>
D3A6 833C	# <CJK>
D3A7 834D	# <CJK>
D3A8 8316	# <CJK>
D3A9 8324	# <CJK>
D3AA 8320	# <CJK>
D3AB 8337	# <CJK>
D3AC 832F	# <CJK>
D3AD 8329	# <CJK>
D3AE 8347	# <CJK>
D3AF 8345	# <CJK>
D3B0 834C	# <CJK>
D3B1 8353	# <CJK>
D3B2 831E	# <CJK>
D3B3 832C	# <CJK>
D3B4 834B	# <CJK>
D3B5 8327	# <CJK>
D3B6 8348	# <CJK>
D3B7 8653	# <CJK>
D3B8 8652	# <CJK>
D3B9 86A2	# <CJK>
D3BA 86A8	# <CJK>
D3BB 8696	# <CJK>
D3BC 868D	# <CJK>
D3BD 8691	# <CJK>
D3BE 869E	# <CJK>
D3BF 8687	# <CJK>
D3C0 8697	# <CJK>
D3C1 8686	# <CJK>
D3C2 868B	# <CJK>
D3C3 869A	# <CJK>
D3C4 8685	# <CJK>
D3C5 86A5	# <CJK>
D3C6 8699	# <CJK>
D3C7 86A1	# <CJK>
D3C8 86A7	# <CJK>
D3C9 8695	# <CJK>
D3CA 8698	# <CJK>
D3CB 868E	# <CJK>
D3CC 869D	# <CJK>
D3CD 8690	# <CJK>
D3CE 8694	# <CJK>
D3CF 8843	# <CJK>
D3D0 8844	# <CJK>
D3D1 886D	# <CJK>
D3D2 8875	# <CJK>
D3D3 8876	# <CJK>
D3D4 8872	# <CJK>
D3D5 8880	# <CJK>
D3D6 8871	# <CJK>
D3D7 887F	# <CJK>
D3D8 886F	# <CJK>
D3D9 8883	# <CJK>
D3DA 887E	# <CJK>
D3DB 8874	# <CJK>
D3DC 887C	# <CJK>
D3DD 8A12	# <CJK>
D3DE 8C47	# <CJK>
D3DF 8C57	# <CJK>
D3E0 8C7B	# <CJK>
D3E1 8CA4	# <CJK>
D3E2 8CA3	# <CJK>
D3E3 8D76	# <CJK>
D3E4 8D78	# <CJK>
D3E5 8DB5	# <CJK>
D3E6 8DB7	# <CJK>
D3E7 8DB6	# <CJK>
D3E8 8ED1	# <CJK>
D3E9 8ED3	# <CJK>
D3EA 8FFE	# <CJK>
D3EB 8FF5	# <CJK>
D3EC 9002	# <CJK>
D3ED 8FFF	# <CJK>
D3EE 8FFB	# <CJK>
D3EF 9004	# <CJK>
D3F0 8FFC	# <CJK>
D3F1 8FF6	# <CJK>
D3F2 90D6	# <CJK>
D3F3 90E0	# <CJK>
D3F4 90D9	# <CJK>
D3F5 90DA	# <CJK>
D3F6 90E3	# <CJK>
D3F7 90DF	# <CJK>
D3F8 90E5	# <CJK>
D3F9 90D8	# <CJK>
D3FA 90DB	# <CJK>
D3FB 90D7	# <CJK>
D3FC 90DC	# <CJK>
D3FD 90E4	# <CJK>
D3FE 9150	# <CJK>
D440 914E	# <CJK>
D441 914F	# <CJK>
D442 91D5	# <CJK>
D443 91E2	# <CJK>
D444 91DA	# <CJK>
D445 965C	# <CJK>
D446 965F	# <CJK>
D447 96BC	# <CJK>
D448 98E3	# <CJK>
D449 9ADF	# <CJK>
D44A 9B2F	# <CJK>
D44B 4E7F	# <CJK>
D44C 5070	# <CJK>
D44D 506A	# <CJK>
D44E 5061	# <CJK>
D44F 505E	# <CJK>
D450 5060	# <CJK>
D451 5053	# <CJK>
D452 504B	# <CJK>
D453 505D	# <CJK>
D454 5072	# <CJK>
D455 5048	# <CJK>
D456 504D	# <CJK>
D457 5041	# <CJK>
D458 505B	# <CJK>
D459 504A	# <CJK>
D45A 5062	# <CJK>
D45B 5015	# <CJK>
D45C 5045	# <CJK>
D45D 505F	# <CJK>
D45E 5069	# <CJK>
D45F 506B	# <CJK>
D460 5063	# <CJK>
D461 5064	# <CJK>
D462 5046	# <CJK>
D463 5040	# <CJK>
D464 506E	# <CJK>
D465 5073	# <CJK>
D466 5057	# <CJK>
D467 5051	# <CJK>
D468 51D0	# <CJK>
D469 526B	# <CJK>
D46A 526D	# <CJK>
D46B 526C	# <CJK>
D46C 526E	# <CJK>
D46D 52D6	# <CJK>
D46E 52D3	# <CJK>
D46F 532D	# <CJK>
D470 539C	# <CJK>
D471 5575	# <CJK>
D472 5576	# <CJK>
D473 553C	# <CJK>
D474 554D	# <CJK>
D475 5550	# <CJK>
D476 5534	# <CJK>
D477 552A	# <CJK>
D478 5551	# <CJK>
D479 5562	# <CJK>
D47A 5536	# <CJK>
D47B 5535	# <CJK>
D47C 5530	# <CJK>
D47D 5552	# <CJK>
D47E 5545	# <CJK>
D4A1 550C	# <CJK>
D4A2 5532	# <CJK>
D4A3 5565	# <CJK>
D4A4 554E	# <CJK>
D4A5 5539	# <CJK>
D4A6 5548	# <CJK>
D4A7 552D	# <CJK>
D4A8 553B	# <CJK>
D4A9 5540	# <CJK>
D4AA 554B	# <CJK>
D4AB 570A	# <CJK>
D4AC 5707	# <CJK>
D4AD 57FB	# <CJK>
D4AE 5814	# <CJK>
D4AF 57E2	# <CJK>
D4B0 57F6	# <CJK>
D4B1 57DC	# <CJK>
D4B2 57F4	# <CJK>
D4B3 5800	# <CJK>
D4B4 57ED	# <CJK>
D4B5 57FD	# <CJK>
D4B6 5808	# <CJK>
D4B7 57F8	# <CJK>
D4B8 580B	# <CJK>
D4B9 57F3	# <CJK>
D4BA 57CF	# <CJK>
D4BB 5807	# <CJK>
D4BC 57EE	# <CJK>
D4BD 57E3	# <CJK>
D4BE 57F2	# <CJK>
D4BF 57E5	# <CJK>
D4C0 57EC	# <CJK>
D4C1 57E1	# <CJK>
D4C2 580E	# <CJK>
D4C3 57FC	# <CJK>
D4C4 5810	# <CJK>
D4C5 57E7	# <CJK>
D4C6 5801	# <CJK>
D4C7 580C	# <CJK>
D4C8 57F1	# <CJK>
D4C9 57E9	# <CJK>
D4CA 57F0	# <CJK>
D4CB 580D	# <CJK>
D4CC 5804	# <CJK>
D4CD 595C	# <CJK>
D4CE 5A60	# <CJK>
D4CF 5A58	# <CJK>
D4D0 5A55	# <CJK>
D4D1 5A67	# <CJK>
D4D2 5A5E	# <CJK>
D4D3 5A38	# <CJK>
D4D4 5A35	# <CJK>
D4D5 5A6D	# <CJK>
D4D6 5A50	# <CJK>
D4D7 5A5F	# <CJK>
D4D8 5A65	# <CJK>
D4D9 5A6C	# <CJK>
D4DA 5A53	# <CJK>
D4DB 5A64	# <CJK>
D4DC 5A57	# <CJK>
D4DD 5A43	# <CJK>
D4DE 5A5D	# <CJK>
D4DF 5A52	# <CJK>
D4E0 5A44	# <CJK>
D4E1 5A5B	# <CJK>
D4E2 5A48	# <CJK>
D4E3 5A8E	# <CJK>
D4E4 5A3E	# <CJK>
D4E5 5A4D	# <CJK>
D4E6 5A39	# <CJK>
D4E7 5A4C	# <CJK>
D4E8 5A70	# <CJK>
D4E9 5A69	# <CJK>
D4EA 5A47	# <CJK>
D4EB 5A51	# <CJK>
D4EC 5A56	# <CJK>
D4ED 5A42	# <CJK>
D4EE 5A5C	# <CJK>
D4EF 5B72	# <CJK>
D4F0 5B6E	# <CJK>
D4F1 5BC1	# <CJK>
D4F2 5BC0	# <CJK>
D4F3 5C59	# <CJK>
D4F4 5D1E	# <CJK>
D4F5 5D0B	# <CJK>
D4F6 5D1D	# <CJK>
D4F7 5D1A	# <CJK>
D4F8 5D20	# <CJK>
D4F9 5D0C	# <CJK>
D4FA 5D28	# <CJK>
D4FB 5D0D	# <CJK>
D4FC 5D26	# <CJK>
D4FD 5D25	# <CJK>
D4FE 5D0F	# <CJK>
D540 5D30	# <CJK>
D541 5D12	# <CJK>
D542 5D23	# <CJK>
D543 5D1F	# <CJK>
D544 5D2E	# <CJK>
D545 5E3E	# <CJK>
D546 5E34	# <CJK>
D547 5EB1	# <CJK>
D548 5EB4	# <CJK>
D549 5EB9	# <CJK>
D54A 5EB2	# <CJK>
D54B 5EB3	# <CJK>
D54C 5F36	# <CJK>
D54D 5F38	# <CJK>
D54E 5F9B	# <CJK>
D54F 5F96	# <CJK>
D550 5F9F	# <CJK>
D551 608A	# <CJK>
D552 6090	# <CJK>
D553 6086	# <CJK>
D554 60BE	# <CJK>
D555 60B0	# <CJK>
D556 60BA	# <CJK>
D557 60D3	# <CJK>
D558 60D4	# <CJK>
D559 60CF	# <CJK>
D55A 60E4	# <CJK>
D55B 60D9	# <CJK>
D55C 60DD	# <CJK>
D55D 60C8	# <CJK>
D55E 60B1	# <CJK>
D55F 60DB	# <CJK>
D560 60B7	# <CJK>
D561 60CA	# <CJK>
D562 60BF	# <CJK>
D563 60C3	# <CJK>
D564 60CD	# <CJK>
D565 60C0	# <CJK>
D566 6332	# <CJK>
D567 6365	# <CJK>
D568 638A	# <CJK>
D569 6382	# <CJK>
D56A 637D	# <CJK>
D56B 63BD	# <CJK>
D56C 639E	# <CJK>
D56D 63AD	# <CJK>
D56E 639D	# <CJK>
D56F 6397	# <CJK>
D570 63AB	# <CJK>
D571 638E	# <CJK>
D572 636F	# <CJK>
D573 6387	# <CJK>
D574 6390	# <CJK>
D575 636E	# <CJK>
D576 63AF	# <CJK>
D577 6375	# <CJK>
D578 639C	# <CJK>
D579 636D	# <CJK>
D57A 63AE	# <CJK>
D57B 637C	# <CJK>
D57C 63A4	# <CJK>
D57D 633B	# <CJK>
D57E 639F	# <CJK>
D5A1 6378	# <CJK>
D5A2 6385	# <CJK>
D5A3 6381	# <CJK>
D5A4 6391	# <CJK>
D5A5 638D	# <CJK>
D5A6 6370	# <CJK>
D5A7 6553	# <CJK>
D5A8 65CD	# <CJK>
D5A9 6665	# <CJK>
D5AA 6661	# <CJK>
D5AB 665B	# <CJK>
D5AC 6659	# <CJK>
D5AD 665C	# <CJK>
D5AE 6662	# <CJK>
D5AF 6718	# <CJK>
D5B0 6879	# <CJK>
D5B1 6887	# <CJK>
D5B2 6890	# <CJK>
D5B3 689C	# <CJK>
D5B4 686D	# <CJK>
D5B5 686E	# <CJK>
D5B6 68AE	# <CJK>
D5B7 68AB	# <CJK>
D5B8 6956	# <CJK>
D5B9 686F	# <CJK>
D5BA 68A3	# <CJK>
D5BB 68AC	# <CJK>
D5BC 68A9	# <CJK>
D5BD 6875	# <CJK>
D5BE 6874	# <CJK>
D5BF 68B2	# <CJK>
D5C0 688F	# <CJK>
D5C1 6877	# <CJK>
D5C2 6892	# <CJK>
D5C3 687C	# <CJK>
D5C4 686B	# <CJK>
D5C5 6872	# <CJK>
D5C6 68AA	# <CJK>
D5C7 6880	# <CJK>
D5C8 6871	# <CJK>
D5C9 687E	# <CJK>
D5CA 689B	# <CJK>
D5CB 6896	# <CJK>
D5CC 688B	# <CJK>
D5CD 68A0	# <CJK>
D5CE 6889	# <CJK>
D5CF 68A4	# <CJK>
D5D0 6878	# <CJK>
D5D1 687B	# <CJK>
D5D2 6891	# <CJK>
D5D3 688C	# <CJK>
D5D4 688A	# <CJK>
D5D5 687D	# <CJK>
D5D6 6B36	# <CJK>
D5D7 6B33	# <CJK>
D5D8 6B37	# <CJK>
D5D9 6B38	# <CJK>
D5DA 6B91	# <CJK>
D5DB 6B8F	# <CJK>
D5DC 6B8D	# <CJK>
D5DD 6B8E	# <CJK>
D5DE 6B8C	# <CJK>
D5DF 6C2A	# <CJK>
D5E0 6DC0	# <CJK>
D5E1 6DAB	# <CJK>
D5E2 6DB4	# <CJK>
D5E3 6DB3	# <CJK>
D5E4 6E74	# <CJK>
D5E5 6DAC	# <CJK>
D5E6 6DE9	# <CJK>
D5E7 6DE2	# <CJK>
D5E8 6DB7	# <CJK>
D5E9 6DF6	# <CJK>
D5EA 6DD4	# <CJK>
D5EB 6E00	# <CJK>
D5EC 6DC8	# <CJK>
D5ED 6DE0	# <CJK>
D5EE 6DDF	# <CJK>
D5EF 6DD6	# <CJK>
D5F0 6DBE	# <CJK>
D5F1 6DE5	# <CJK>
D5F2 6DDC	# <CJK>
D5F3 6DDD	# <CJK>
D5F4 6DDB	# <CJK>
D5F5 6DF4	# <CJK>
D5F6 6DCA	# <CJK>
D5F7 6DBD	# <CJK>
D5F8 6DED	# <CJK>
D5F9 6DF0	# <CJK>
D5FA 6DBA	# <CJK>
D5FB 6DD5	# <CJK>
D5FC 6DC2	# <CJK>
D5FD 6DCF	# <CJK>
D5FE 6DC9	# <CJK>
D640 6DD0	# <CJK>
D641 6DF2	# <CJK>
D642 6DD3	# <CJK>
D643 6DFD	# <CJK>
D644 6DD7	# <CJK>
D645 6DCD	# <CJK>
D646 6DE3	# <CJK>
D647 6DBB	# <CJK>
D648 70FA	# <CJK>
D649 710D	# <CJK>
D64A 70F7	# <CJK>
D64B 7117	# <CJK>
D64C 70F4	# <CJK>
D64D 710C	# <CJK>
D64E 70F0	# <CJK>
D64F 7104	# <CJK>
D650 70F3	# <CJK>
D651 7110	# <CJK>
D652 70FC	# <CJK>
D653 70FF	# <CJK>
D654 7106	# <CJK>
D655 7113	# <CJK>
D656 7100	# <CJK>
D657 70F8	# <CJK>
D658 70F6	# <CJK>
D659 710B	# <CJK>
D65A 7102	# <CJK>
D65B 710E	# <CJK>
D65C 727E	# <CJK>
D65D 727B	# <CJK>
D65E 727C	# <CJK>
D65F 727F	# <CJK>
D660 731D	# <CJK>
D661 7317	# <CJK>
D662 7307	# <CJK>
D663 7311	# <CJK>
D664 7318	# <CJK>
D665 730A	# <CJK>
D666 7308	# <CJK>
D667 72FF	# <CJK>
D668 730F	# <CJK>
D669 731E	# <CJK>
D66A 7388	# <CJK>
D66B 73F6	# <CJK>
D66C 73F8	# <CJK>
D66D 73F5	# <CJK>
D66E 7404	# <CJK>
D66F 7401	# <CJK>
D670 73FD	# <CJK>
D671 7407	# <CJK>
D672 7400	# <CJK>
D673 73FA	# <CJK>
D674 73FC	# <CJK>
D675 73FF	# <CJK>
D676 740C	# <CJK>
D677 740B	# <CJK>
D678 73F4	# <CJK>
D679 7408	# <CJK>
D67A 7564	# <CJK>
D67B 7563	# <CJK>
D67C 75CE	# <CJK>
D67D 75D2	# <CJK>
D67E 75CF	# <CJK>
D6A1 75CB	# <CJK>
D6A2 75CC	# <CJK>
D6A3 75D1	# <CJK>
D6A4 75D0	# <CJK>
D6A5 768F	# <CJK>
D6A6 7689	# <CJK>
D6A7 76D3	# <CJK>
D6A8 7739	# <CJK>
D6A9 772F	# <CJK>
D6AA 772D	# <CJK>
D6AB 7731	# <CJK>
D6AC 7732	# <CJK>
D6AD 7734	# <CJK>
D6AE 7733	# <CJK>
D6AF 773D	# <CJK>
D6B0 7725	# <CJK>
D6B1 773B	# <CJK>
D6B2 7735	# <CJK>
D6B3 7848	# <CJK>
D6B4 7852	# <CJK>
D6B5 7849	# <CJK>
D6B6 784D	# <CJK>
D6B7 784A	# <CJK>
D6B8 784C	# <CJK>
D6B9 7826	# <CJK>
D6BA 7845	# <CJK>
D6BB 7850	# <CJK>
D6BC 7964	# <CJK>
D6BD 7967	# <CJK>
D6BE 7969	# <CJK>
D6BF 796A	# <CJK>
D6C0 7963	# <CJK>
D6C1 796B	# <CJK>
D6C2 7961	# <CJK>
D6C3 79BB	# <CJK>
D6C4 79FA	# <CJK>
D6C5 79F8	# <CJK>
D6C6 79F6	# <CJK>
D6C7 79F7	# <CJK>
D6C8 7A8F	# <CJK>
D6C9 7A94	# <CJK>
D6CA 7A90	# <CJK>
D6CB 7B35	# <CJK>
D6CC 7B47	# <CJK>
D6CD 7B34	# <CJK>
D6CE 7B25	# <CJK>
D6CF 7B30	# <CJK>
D6D0 7B22	# <CJK>
D6D1 7B24	# <CJK>
D6D2 7B33	# <CJK>
D6D3 7B18	# <CJK>
D6D4 7B2A	# <CJK>
D6D5 7B1D	# <CJK>
D6D6 7B31	# <CJK>
D6D7 7B2B	# <CJK>
D6D8 7B2D	# <CJK>
D6D9 7B2F	# <CJK>
D6DA 7B32	# <CJK>
D6DB 7B38	# <CJK>
D6DC 7B1A	# <CJK>
D6DD 7B23	# <CJK>
D6DE 7C94	# <CJK>
D6DF 7C98	# <CJK>
D6E0 7C96	# <CJK>
D6E1 7CA3	# <CJK>
D6E2 7D35	# <CJK>
D6E3 7D3D	# <CJK>
D6E4 7D38	# <CJK>
D6E5 7D36	# <CJK>
D6E6 7D3A	# <CJK>
D6E7 7D45	# <CJK>
D6E8 7D2C	# <CJK>
D6E9 7D29	# <CJK>
D6EA 7D41	# <CJK>
D6EB 7D47	# <CJK>
D6EC 7D3E	# <CJK>
D6ED 7D3F	# <CJK>
D6EE 7D4A	# <CJK>
D6EF 7D3B	# <CJK>
D6F0 7D28	# <CJK>
D6F1 7F63	# <CJK>
D6F2 7F95	# <CJK>
D6F3 7F9C	# <CJK>
D6F4 7F9D	# <CJK>
D6F5 7F9B	# <CJK>
D6F6 7FCA	# <CJK>
D6F7 7FCB	# <CJK>
D6F8 7FCD	# <CJK>
D6F9 7FD0	# <CJK>
D6FA 7FD1	# <CJK>
D6FB 7FC7	# <CJK>
D6FC 7FCF	# <CJK>
D6FD 7FC9	# <CJK>
D6FE 801F	# <CJK>
D740 801E	# <CJK>
D741 801B	# <CJK>
D742 8047	# <CJK>
D743 8043	# <CJK>
D744 8048	# <CJK>
D745 8118	# <CJK>
D746 8125	# <CJK>
D747 8119	# <CJK>
D748 811B	# <CJK>
D749 812D	# <CJK>
D74A 811F	# <CJK>
D74B 812C	# <CJK>
D74C 811E	# <CJK>
D74D 8121	# <CJK>
D74E 8115	# <CJK>
D74F 8127	# <CJK>
D750 811D	# <CJK>
D751 8122	# <CJK>
D752 8211	# <CJK>
D753 8238	# <CJK>
D754 8233	# <CJK>
D755 823A	# <CJK>
D756 8234	# <CJK>
D757 8232	# <CJK>
D758 8274	# <CJK>
D759 8390	# <CJK>
D75A 83A3	# <CJK>
D75B 83A8	# <CJK>
D75C 838D	# <CJK>
D75D 837A	# <CJK>
D75E 8373	# <CJK>
D75F 83A4	# <CJK>
D760 8374	# <CJK>
D761 838F	# <CJK>
D762 8381	# <CJK>
D763 8395	# <CJK>
D764 8399	# <CJK>
D765 8375	# <CJK>
D766 8394	# <CJK>
D767 83A9	# <CJK>
D768 837D	# <CJK>
D769 8383	# <CJK>
D76A 838C	# <CJK>
D76B 839D	# <CJK>
D76C 839B	# <CJK>
D76D 83AA	# <CJK>
D76E 838B	# <CJK>
D76F 837E	# <CJK>
D770 83A5	# <CJK>
D771 83AF	# <CJK>
D772 8388	# <CJK>
D773 8397	# <CJK>
D774 83B0	# <CJK>
D775 837F	# <CJK>
D776 83A6	# <CJK>
D777 8387	# <CJK>
D778 83AE	# <CJK>
D779 8376	# <CJK>
D77A 839A	# <CJK>
D77B 8659	# <CJK>
D77C 8656	# <CJK>
D77D 86BF	# <CJK>
D77E 86B7	# <CJK>
D7A1 86C2	# <CJK>
D7A2 86C1	# <CJK>
D7A3 86C5	# <CJK>
D7A4 86BA	# <CJK>
D7A5 86B0	# <CJK>
D7A6 86C8	# <CJK>
D7A7 86B9	# <CJK>
D7A8 86B3	# <CJK>
D7A9 86B8	# <CJK>
D7AA 86CC	# <CJK>
D7AB 86B4	# <CJK>
D7AC 86BB	# <CJK>
D7AD 86BC	# <CJK>
D7AE 86C3	# <CJK>
D7AF 86BD	# <CJK>
D7B0 86BE	# <CJK>
D7B1 8852	# <CJK>
D7B2 8889	# <CJK>
D7B3 8895	# <CJK>
D7B4 88A8	# <CJK>
D7B5 88A2	# <CJK>
D7B6 88AA	# <CJK>
D7B7 889A	# <CJK>
D7B8 8891	# <CJK>
D7B9 88A1	# <CJK>
D7BA 889F	# <CJK>
D7BB 8898	# <CJK>
D7BC 88A7	# <CJK>
D7BD 8899	# <CJK>
D7BE 889B	# <CJK>
D7BF 8897	# <CJK>
D7C0 88A4	# <CJK>
D7C1 88AC	# <CJK>
D7C2 888C	# <CJK>
D7C3 8893	# <CJK>
D7C4 888E	# <CJK>
D7C5 8982	# <CJK>
D7C6 89D6	# <CJK>
D7C7 89D9	# <CJK>
D7C8 89D5	# <CJK>
D7C9 8A30	# <CJK>
D7CA 8A27	# <CJK>
D7CB 8A2C	# <CJK>
D7CC 8A1E	# <CJK>
D7CD 8C39	# <CJK>
D7CE 8C3B	# <CJK>
D7CF 8C5C	# <CJK>
D7D0 8C5D	# <CJK>
D7D1 8C7D	# <CJK>
D7D2 8CA5	# <CJK>
D7D3 8D7D	# <CJK>
D7D4 8D7B	# <CJK>
D7D5 8D79	# <CJK>
D7D6 8DBC	# <CJK>
D7D7 8DC2	# <CJK>
D7D8 8DB9	# <CJK>
D7D9 8DBF	# <CJK>
D7DA 8DC1	# <CJK>
D7DB 8ED8	# <CJK>
D7DC 8EDE	# <CJK>
D7DD 8EDD	# <CJK>
D7DE 8EDC	# <CJK>
D7DF 8ED7	# <CJK>
D7E0 8EE0	# <CJK>
D7E1 8EE1	# <CJK>
D7E2 9024	# <CJK>
D7E3 900B	# <CJK>
D7E4 9011	# <CJK>
D7E5 901C	# <CJK>
D7E6 900C	# <CJK>
D7E7 9021	# <CJK>
D7E8 90EF	# <CJK>
D7E9 90EA	# <CJK>
D7EA 90F0	# <CJK>
D7EB 90F4	# <CJK>
D7EC 90F2	# <CJK>
D7ED 90F3	# <CJK>
D7EE 90D4	# <CJK>
D7EF 90EB	# <CJK>
D7F0 90EC	# <CJK>
D7F1 90E9	# <CJK>
D7F2 9156	# <CJK>
D7F3 9158	# <CJK>
D7F4 915A	# <CJK>
D7F5 9153	# <CJK>
D7F6 9155	# <CJK>
D7F7 91EC	# <CJK>
D7F8 91F4	# <CJK>
D7F9 91F1	# <CJK>
D7FA 91F3	# <CJK>
D7FB 91F8	# <CJK>
D7FC 91E4	# <CJK>
D7FD 91F9	# <CJK>
D7FE 91EA	# <CJK>
D840 91EB	# <CJK>
D841 91F7	# <CJK>
D842 91E8	# <CJK>
D843 91EE	# <CJK>
D844 957A	# <CJK>
D845 9586	# <CJK>
D846 9588	# <CJK>
D847 967C	# <CJK>
D848 966D	# <CJK>
D849 966B	# <CJK>
D84A 9671	# <CJK>
D84B 966F	# <CJK>
D84C 96BF	# <CJK>
D84D 976A	# <CJK>
D84E 9804	# <CJK>
D84F 98E5	# <CJK>
D850 9997	# <CJK>
D851 509B	# <CJK>
D852 5095	# <CJK>
D853 5094	# <CJK>
D854 509E	# <CJK>
D855 508B	# <CJK>
D856 50A3	# <CJK>
D857 5083	# <CJK>
D858 508C	# <CJK>
D859 508E	# <CJK>
D85A 509D	# <CJK>
D85B 5068	# <CJK>
D85C 509C	# <CJK>
D85D 5092	# <CJK>
D85E 5082	# <CJK>
D85F 5087	# <CJK>
D860 515F	# <CJK>
D861 51D4	# <CJK>
D862 5312	# <CJK>
D863 5311	# <CJK>
D864 53A4	# <CJK>
D865 53A7	# <CJK>
D866 5591	# <CJK>
D867 55A8	# <CJK>
D868 55A5	# <CJK>
D869 55AD	# <CJK>
D86A 5577	# <CJK>
D86B 5645	# <CJK>
D86C 55A2	# <CJK>
D86D 5593	# <CJK>
D86E 5588	# <CJK>
D86F 558F	# <CJK>
D870 55B5	# <CJK>
D871 5581	# <CJK>
D872 55A3	# <CJK>
D873 5592	# <CJK>
D874 55A4	# <CJK>
D875 557D	# <CJK>
D876 558C	# <CJK>
D877 55A6	# <CJK>
D878 557F	# <CJK>
D879 5595	# <CJK>
D87A 55A1	# <CJK>
D87B 558E	# <CJK>
D87C 570C	# <CJK>
D87D 5829	# <CJK>
D87E 5837	# <CJK>
D8A1 5819	# <CJK>
D8A2 581E	# <CJK>
D8A3 5827	# <CJK>
D8A4 5823	# <CJK>
D8A5 5828	# <CJK>
D8A6 57F5	# <CJK>
D8A7 5848	# <CJK>
D8A8 5825	# <CJK>
D8A9 581C	# <CJK>
D8AA 581B	# <CJK>
D8AB 5833	# <CJK>
D8AC 583F	# <CJK>
D8AD 5836	# <CJK>
D8AE 582E	# <CJK>
D8AF 5839	# <CJK>
D8B0 5838	# <CJK>
D8B1 582D	# <CJK>
D8B2 582C	# <CJK>
D8B3 583B	# <CJK>
D8B4 5961	# <CJK>
D8B5 5AAF	# <CJK>
D8B6 5A94	# <CJK>
D8B7 5A9F	# <CJK>
D8B8 5A7A	# <CJK>
D8B9 5AA2	# <CJK>
D8BA 5A9E	# <CJK>
D8BB 5A78	# <CJK>
D8BC 5AA6	# <CJK>
D8BD 5A7C	# <CJK>
D8BE 5AA5	# <CJK>
D8BF 5AAC	# <CJK>
D8C0 5A95	# <CJK>
D8C1 5AAE	# <CJK>
D8C2 5A37	# <CJK>
D8C3 5A84	# <CJK>
D8C4 5A8A	# <CJK>
D8C5 5A97	# <CJK>
D8C6 5A83	# <CJK>
D8C7 5A8B	# <CJK>
D8C8 5AA9	# <CJK>
D8C9 5A7B	# <CJK>
D8CA 5A7D	# <CJK>
D8CB 5A8C	# <CJK>
D8CC 5A9C	# <CJK>
D8CD 5A8F	# <CJK>
D8CE 5A93	# <CJK>
D8CF 5A9D	# <CJK>
D8D0 5BEA	# <CJK>
D8D1 5BCD	# <CJK>
D8D2 5BCB	# <CJK>
D8D3 5BD4	# <CJK>
D8D4 5BD1	# <CJK>
D8D5 5BCA	# <CJK>
D8D6 5BCE	# <CJK>
D8D7 5C0C	# <CJK>
D8D8 5C30	# <CJK>
D8D9 5D37	# <CJK>
D8DA 5D43	# <CJK>
D8DB 5D6B	# <CJK>
D8DC 5D41	# <CJK>
D8DD 5D4B	# <CJK>
D8DE 5D3F	# <CJK>
D8DF 5D35	# <CJK>
D8E0 5D51	# <CJK>
D8E1 5D4E	# <CJK>
D8E2 5D55	# <CJK>
D8E3 5D33	# <CJK>
D8E4 5D3A	# <CJK>
D8E5 5D52	# <CJK>
D8E6 5D3D	# <CJK>
D8E7 5D31	# <CJK>
D8E8 5D59	# <CJK>
D8E9 5D42	# <CJK>
D8EA 5D39	# <CJK>
D8EB 5D49	# <CJK>
D8EC 5D38	# <CJK>
D8ED 5D3C	# <CJK>
D8EE 5D32	# <CJK>
D8EF 5D36	# <CJK>
D8F0 5D40	# <CJK>
D8F1 5D45	# <CJK>
D8F2 5E44	# <CJK>
D8F3 5E41	# <CJK>
D8F4 5F58	# <CJK>
D8F5 5FA6	# <CJK>
D8F6 5FA5	# <CJK>
D8F7 5FAB	# <CJK>
D8F8 60C9	# <CJK>
D8F9 60B9	# <CJK>
D8FA 60CC	# <CJK>
D8FB 60E2	# <CJK>
D8FC 60CE	# <CJK>
D8FD 60C4	# <CJK>
D8FE 6114	# <CJK>
D940 60F2	# <CJK>
D941 610A	# <CJK>
D942 6116	# <CJK>
D943 6105	# <CJK>
D944 60F5	# <CJK>
D945 6113	# <CJK>
D946 60F8	# <CJK>
D947 60FC	# <CJK>
D948 60FE	# <CJK>
D949 60C1	# <CJK>
D94A 6103	# <CJK>
D94B 6118	# <CJK>
D94C 611D	# <CJK>
D94D 6110	# <CJK>
D94E 60FF	# <CJK>
D94F 6104	# <CJK>
D950 610B	# <CJK>
D951 624A	# <CJK>
D952 6394	# <CJK>
D953 63B1	# <CJK>
D954 63B0	# <CJK>
D955 63CE	# <CJK>
D956 63E5	# <CJK>
D957 63E8	# <CJK>
D958 63EF	# <CJK>
D959 63C3	# <CJK>
D95A 649D	# <CJK>
D95B 63F3	# <CJK>
D95C 63CA	# <CJK>
D95D 63E0	# <CJK>
D95E 63F6	# <CJK>
D95F 63D5	# <CJK>
D960 63F2	# <CJK>
D961 63F5	# <CJK>
D962 6461	# <CJK>
D963 63DF	# <CJK>
D964 63BE	# <CJK>
D965 63DD	# <CJK>
D966 63DC	# <CJK>
D967 63C4	# <CJK>
D968 63D8	# <CJK>
D969 63D3	# <CJK>
D96A 63C2	# <CJK>
D96B 63C7	# <CJK>
D96C 63CC	# <CJK>
D96D 63CB	# <CJK>
D96E 63C8	# <CJK>
D96F 63F0	# <CJK>
D970 63D7	# <CJK>
D971 63D9	# <CJK>
D972 6532	# <CJK>
D973 6567	# <CJK>
D974 656A	# <CJK>
D975 6564	# <CJK>
D976 655C	# <CJK>
D977 6568	# <CJK>
D978 6565	# <CJK>
D979 658C	# <CJK>
D97A 659D	# <CJK>
D97B 659E	# <CJK>
D97C 65AE	# <CJK>
D97D 65D0	# <CJK>
D97E 65D2	# <CJK>
D9A1 667C	# <CJK>
D9A2 666C	# <CJK>
D9A3 667B	# <CJK>
D9A4 6680	# <CJK>
D9A5 6671	# <CJK>
D9A6 6679	# <CJK>
D9A7 666A	# <CJK>
D9A8 6672	# <CJK>
D9A9 6701	# <CJK>
D9AA 690C	# <CJK>
D9AB 68D3	# <CJK>
D9AC 6904	# <CJK>
D9AD 68DC	# <CJK>
D9AE 692A	# <CJK>
D9AF 68EC	# <CJK>
D9B0 68EA	# <CJK>
D9B1 68F1	# <CJK>
D9B2 690F	# <CJK>
D9B3 68D6	# <CJK>
D9B4 68F7	# <CJK>
D9B5 68EB	# <CJK>
D9B6 68E4	# <CJK>
D9B7 68F6	# <CJK>
D9B8 6913	# <CJK>
D9B9 6910	# <CJK>
D9BA 68F3	# <CJK>
D9BB 68E1	# <CJK>
D9BC 6907	# <CJK>
D9BD 68CC	# <CJK>
D9BE 6908	# <CJK>
D9BF 6970	# <CJK>
D9C0 68B4	# <CJK>
D9C1 6911	# <CJK>
D9C2 68EF	# <CJK>
D9C3 68C6	# <CJK>
D9C4 6914	# <CJK>
D9C5 68F8	# <CJK>
D9C6 68D0	# <CJK>
D9C7 68FD	# <CJK>
D9C8 68FC	# <CJK>
D9C9 68E8	# <CJK>
D9CA 690B	# <CJK>
D9CB 690A	# <CJK>
D9CC 6917	# <CJK>
D9CD 68CE	# <CJK>
D9CE 68C8	# <CJK>
D9CF 68DD	# <CJK>
D9D0 68DE	# <CJK>
D9D1 68E6	# <CJK>
D9D2 68F4	# <CJK>
D9D3 68D1	# <CJK>
D9D4 6906	# <CJK>
D9D5 68D4	# <CJK>
D9D6 68E9	# <CJK>
D9D7 6915	# <CJK>
D9D8 6925	# <CJK>
D9D9 68C7	# <CJK>
D9DA 6B39	# <CJK>
D9DB 6B3B	# <CJK>
D9DC 6B3F	# <CJK>
D9DD 6B3C	# <CJK>
D9DE 6B94	# <CJK>
D9DF 6B97	# <CJK>
D9E0 6B99	# <CJK>
D9E1 6B95	# <CJK>
D9E2 6BBD	# <CJK>
D9E3 6BF0	# <CJK>
D9E4 6BF2	# <CJK>
D9E5 6BF3	# <CJK>
D9E6 6C30	# <CJK>
D9E7 6DFC	# <CJK>
D9E8 6E46	# <CJK>
D9E9 6E47	# <CJK>
D9EA 6E1F	# <CJK>
D9EB 6E49	# <CJK>
D9EC 6E88	# <CJK>
D9ED 6E3C	# <CJK>
D9EE 6E3D	# <CJK>
D9EF 6E45	# <CJK>
D9F0 6E62	# <CJK>
D9F1 6E2B	# <CJK>
D9F2 6E3F	# <CJK>
D9F3 6E41	# <CJK>
D9F4 6E5D	# <CJK>
D9F5 6E73	# <CJK>
D9F6 6E1C	# <CJK>
D9F7 6E33	# <CJK>
D9F8 6E4B	# <CJK>
D9F9 6E40	# <CJK>
D9FA 6E51	# <CJK>
D9FB 6E3B	# <CJK>
D9FC 6E03	# <CJK>
D9FD 6E2E	# <CJK>
D9FE 6E5E	# <CJK>
DA40 6E68	# <CJK>
DA41 6E5C	# <CJK>
DA42 6E61	# <CJK>
DA43 6E31	# <CJK>
DA44 6E28	# <CJK>
DA45 6E60	# <CJK>
DA46 6E71	# <CJK>
DA47 6E6B	# <CJK>
DA48 6E39	# <CJK>
DA49 6E22	# <CJK>
DA4A 6E30	# <CJK>
DA4B 6E53	# <CJK>
DA4C 6E65	# <CJK>
DA4D 6E27	# <CJK>
DA4E 6E78	# <CJK>
DA4F 6E64	# <CJK>
DA50 6E77	# <CJK>
DA51 6E55	# <CJK>
DA52 6E79	# <CJK>
DA53 6E52	# <CJK>
DA54 6E66	# <CJK>
DA55 6E35	# <CJK>
DA56 6E36	# <CJK>
DA57 6E5A	# <CJK>
DA58 7120	# <CJK>
DA59 711E	# <CJK>
DA5A 712F	# <CJK>
DA5B 70FB	# <CJK>
DA5C 712E	# <CJK>
DA5D 7131	# <CJK>
DA5E 7123	# <CJK>
DA5F 7125	# <CJK>
DA60 7122	# <CJK>
DA61 7132	# <CJK>
DA62 711F	# <CJK>
DA63 7128	# <CJK>
DA64 713A	# <CJK>
DA65 711B	# <CJK>
DA66 724B	# <CJK>
DA67 725A	# <CJK>
DA68 7288	# <CJK>
DA69 7289	# <CJK>
DA6A 7286	# <CJK>
DA6B 7285	# <CJK>
DA6C 728B	# <CJK>
DA6D 7312	# <CJK>
DA6E 730B	# <CJK>
DA6F 7330	# <CJK>
DA70 7322	# <CJK>
DA71 7331	# <CJK>
DA72 7333	# <CJK>
DA73 7327	# <CJK>
DA74 7332	# <CJK>
DA75 732D	# <CJK>
DA76 7326	# <CJK>
DA77 7323	# <CJK>
DA78 7335	# <CJK>
DA79 730C	# <CJK>
DA7A 742E	# <CJK>
DA7B 742C	# <CJK>
DA7C 7430	# <CJK>
DA7D 742B	# <CJK>
DA7E 7416	# <CJK>
DAA1 741A	# <CJK>
DAA2 7421	# <CJK>
DAA3 742D	# <CJK>
DAA4 7431	# <CJK>
DAA5 7424	# <CJK>
DAA6 7423	# <CJK>
DAA7 741D	# <CJK>
DAA8 7429	# <CJK>
DAA9 7420	# <CJK>
DAAA 7432	# <CJK>
DAAB 74FB	# <CJK>
DAAC 752F	# <CJK>
DAAD 756F	# <CJK>
DAAE 756C	# <CJK>
DAAF 75E7	# <CJK>
DAB0 75DA	# <CJK>
DAB1 75E1	# <CJK>
DAB2 75E6	# <CJK>
DAB3 75DD	# <CJK>
DAB4 75DF	# <CJK>
DAB5 75E4	# <CJK>
DAB6 75D7	# <CJK>
DAB7 7695	# <CJK>
DAB8 7692	# <CJK>
DAB9 76DA	# <CJK>
DABA 7746	# <CJK>
DABB 7747	# <CJK>
DABC 7744	# <CJK>
DABD 774D	# <CJK>
DABE 7745	# <CJK>
DABF 774A	# <CJK>
DAC0 774E	# <CJK>
DAC1 774B	# <CJK>
DAC2 774C	# <CJK>
DAC3 77DE	# <CJK>
DAC4 77EC	# <CJK>
DAC5 7860	# <CJK>
DAC6 7864	# <CJK>
DAC7 7865	# <CJK>
DAC8 785C	# <CJK>
DAC9 786D	# <CJK>
DACA 7871	# <CJK>
DACB 786A	# <CJK>
DACC 786E	# <CJK>
DACD 7870	# <CJK>
DACE 7869	# <CJK>
DACF 7868	# <CJK>
DAD0 785E	# <CJK>
DAD1 7862	# <CJK>
DAD2 7974	# <CJK>
DAD3 7973	# <CJK>
DAD4 7972	# <CJK>
DAD5 7970	# <CJK>
DAD6 7A02	# <CJK>
DAD7 7A0A	# <CJK>
DAD8 7A03	# <CJK>
DAD9 7A0C	# <CJK>
DADA 7A04	# <CJK>
DADB 7A99	# <CJK>
DADC 7AE6	# <CJK>
DADD 7AE4	# <CJK>
DADE 7B4A	# <CJK>
DADF 7B3B	# <CJK>
DAE0 7B44	# <CJK>
DAE1 7B48	# <CJK>
DAE2 7B4C	# <CJK>
DAE3 7B4E	# <CJK>
DAE4 7B40	# <CJK>
DAE5 7B58	# <CJK>
DAE6 7B45	# <CJK>
DAE7 7CA2	# <CJK>
DAE8 7C9E	# <CJK>
DAE9 7CA8	# <CJK>
DAEA 7CA1	# <CJK>
DAEB 7D58	# <CJK>
DAEC 7D6F	# <CJK>
DAED 7D63	# <CJK>
DAEE 7D53	# <CJK>
DAEF 7D56	# <CJK>
DAF0 7D67	# <CJK>
DAF1 7D6A	# <CJK>
DAF2 7D4F	# <CJK>
DAF3 7D6D	# <CJK>
DAF4 7D5C	# <CJK>
DAF5 7D6B	# <CJK>
DAF6 7D52	# <CJK>
DAF7 7D54	# <CJK>
DAF8 7D69	# <CJK>
DAF9 7D51	# <CJK>
DAFA 7D5F	# <CJK>
DAFB 7D4E	# <CJK>
DAFC 7F3E	# <CJK>
DAFD 7F3F	# <CJK>
DAFE 7F65	# <CJK>
DB40 7F66	# <CJK>
DB41 7FA2	# <CJK>
DB42 7FA0	# <CJK>
DB43 7FA1	# <CJK>
DB44 7FD7	# <CJK>
DB45 8051	# <CJK>
DB46 804F	# <CJK>
DB47 8050	# <CJK>
DB48 80FE	# <CJK>
DB49 80D4	# <CJK>
DB4A 8143	# <CJK>
DB4B 814A	# <CJK>
DB4C 8152	# <CJK>
DB4D 814F	# <CJK>
DB4E 8147	# <CJK>
DB4F 813D	# <CJK>
DB50 814D	# <CJK>
DB51 813A	# <CJK>
DB52 81E6	# <CJK>
DB53 81EE	# <CJK>
DB54 81F7	# <CJK>
DB55 81F8	# <CJK>
DB56 81F9	# <CJK>
DB57 8204	# <CJK>
DB58 823C	# <CJK>
DB59 823D	# <CJK>
DB5A 823F	# <CJK>
DB5B 8275	# <CJK>
DB5C 833B	# <CJK>
DB5D 83CF	# <CJK>
DB5E 83F9	# <CJK>
DB5F 8423	# <CJK>
DB60 83C0	# <CJK>
DB61 83E8	# <CJK>
DB62 8412	# <CJK>
DB63 83E7	# <CJK>
DB64 83E4	# <CJK>
DB65 83FC	# <CJK>
DB66 83F6	# <CJK>
DB67 8410	# <CJK>
DB68 83C6	# <CJK>
DB69 83C8	# <CJK>
DB6A 83EB	# <CJK>
DB6B 83E3	# <CJK>
DB6C 83BF	# <CJK>
DB6D 8401	# <CJK>
DB6E 83DD	# <CJK>
DB6F 83E5	# <CJK>
DB70 83D8	# <CJK>
DB71 83FF	# <CJK>
DB72 83E1	# <CJK>
DB73 83CB	# <CJK>
DB74 83CE	# <CJK>
DB75 83D6	# <CJK>
DB76 83F5	# <CJK>
DB77 83C9	# <CJK>
DB78 8409	# <CJK>
DB79 840F	# <CJK>
DB7A 83DE	# <CJK>
DB7B 8411	# <CJK>
DB7C 8406	# <CJK>
DB7D 83C2	# <CJK>
DB7E 83F3	# <CJK>
DBA1 83D5	# <CJK>
DBA2 83FA	# <CJK>
DBA3 83C7	# <CJK>
DBA4 83D1	# <CJK>
DBA5 83EA	# <CJK>
DBA6 8413	# <CJK>
DBA7 83C3	# <CJK>
DBA8 83EC	# <CJK>
DBA9 83EE	# <CJK>
DBAA 83C4	# <CJK>
DBAB 83FB	# <CJK>
DBAC 83D7	# <CJK>
DBAD 83E2	# <CJK>
DBAE 841B	# <CJK>
DBAF 83DB	# <CJK>
DBB0 83FE	# <CJK>
DBB1 86D8	# <CJK>
DBB2 86E2	# <CJK>
DBB3 86E6	# <CJK>
DBB4 86D3	# <CJK>
DBB5 86E3	# <CJK>
DBB6 86DA	# <CJK>
DBB7 86EA	# <CJK>
DBB8 86DD	# <CJK>
DBB9 86EB	# <CJK>
DBBA 86DC	# <CJK>
DBBB 86EC	# <CJK>
DBBC 86E9	# <CJK>
DBBD 86D7	# <CJK>
DBBE 86E8	# <CJK>
DBBF 86D1	# <CJK>
DBC0 8848	# <CJK>
DBC1 8856	# <CJK>
DBC2 8855	# <CJK>
DBC3 88BA	# <CJK>
DBC4 88D7	# <CJK>
DBC5 88B9	# <CJK>
DBC6 88B8	# <CJK>
DBC7 88C0	# <CJK>
DBC8 88BE	# <CJK>
DBC9 88B6	# <CJK>
DBCA 88BC	# <CJK>
DBCB 88B7	# <CJK>
DBCC 88BD	# <CJK>
DBCD 88B2	# <CJK>
DBCE 8901	# <CJK>
DBCF 88C9	# <CJK>
DBD0 8995	# <CJK>
DBD1 8998	# <CJK>
DBD2 8997	# <CJK>
DBD3 89DD	# <CJK>
DBD4 89DA	# <CJK>
DBD5 89DB	# <CJK>
DBD6 8A4E	# <CJK>
DBD7 8A4D	# <CJK>
DBD8 8A39	# <CJK>
DBD9 8A59	# <CJK>
DBDA 8A40	# <CJK>
DBDB 8A57	# <CJK>
DBDC 8A58	# <CJK>
DBDD 8A44	# <CJK>
DBDE 8A45	# <CJK>
DBDF 8A52	# <CJK>
DBE0 8A48	# <CJK>
DBE1 8A51	# <CJK>
DBE2 8A4A	# <CJK>
DBE3 8A4C	# <CJK>
DBE4 8A4F	# <CJK>
DBE5 8C5F	# <CJK>
DBE6 8C81	# <CJK>
DBE7 8C80	# <CJK>
DBE8 8CBA	# <CJK>
DBE9 8CBE	# <CJK>
DBEA 8CB0	# <CJK>
DBEB 8CB9	# <CJK>
DBEC 8CB5	# <CJK>
DBED 8D84	# <CJK>
DBEE 8D80	# <CJK>
DBEF 8D89	# <CJK>
DBF0 8DD8	# <CJK>
DBF1 8DD3	# <CJK>
DBF2 8DCD	# <CJK>
DBF3 8DC7	# <CJK>
DBF4 8DD6	# <CJK>
DBF5 8DDC	# <CJK>
DBF6 8DCF	# <CJK>
DBF7 8DD5	# <CJK>
DBF8 8DD9	# <CJK>
DBF9 8DC8	# <CJK>
DBFA 8DD7	# <CJK>
DBFB 8DC5	# <CJK>
DBFC 8EEF	# <CJK>
DBFD 8EF7	# <CJK>
DBFE 8EFA	# <CJK>
DC40 8EF9	# <CJK>
DC41 8EE6	# <CJK>
DC42 8EEE	# <CJK>
DC43 8EE5	# <CJK>
DC44 8EF5	# <CJK>
DC45 8EE7	# <CJK>
DC46 8EE8	# <CJK>
DC47 8EF6	# <CJK>
DC48 8EEB	# <CJK>
DC49 8EF1	# <CJK>
DC4A 8EEC	# <CJK>
DC4B 8EF4	# <CJK>
DC4C 8EE9	# <CJK>
DC4D 902D	# <CJK>
DC4E 9034	# <CJK>
DC4F 902F	# <CJK>
DC50 9106	# <CJK>
DC51 912C	# <CJK>
DC52 9104	# <CJK>
DC53 90FF	# <CJK>
DC54 90FC	# <CJK>
DC55 9108	# <CJK>
DC56 90F9	# <CJK>
DC57 90FB	# <CJK>
DC58 9101	# <CJK>
DC59 9100	# <CJK>
DC5A 9107	# <CJK>
DC5B 9105	# <CJK>
DC5C 9103	# <CJK>
DC5D 9161	# <CJK>
DC5E 9164	# <CJK>
DC5F 915F	# <CJK>
DC60 9162	# <CJK>
DC61 9160	# <CJK>
DC62 9201	# <CJK>
DC63 920A	# <CJK>
DC64 9225	# <CJK>
DC65 9203	# <CJK>
DC66 921A	# <CJK>
DC67 9226	# <CJK>
DC68 920F	# <CJK>
DC69 920C	# <CJK>
DC6A 9200	# <CJK>
DC6B 9212	# <CJK>
DC6C 91FF	# <CJK>
DC6D 91FD	# <CJK>
DC6E 9206	# <CJK>
DC6F 9204	# <CJK>
DC70 9227	# <CJK>
DC71 9202	# <CJK>
DC72 921C	# <CJK>
DC73 9224	# <CJK>
DC74 9219	# <CJK>
DC75 9217	# <CJK>
DC76 9205	# <CJK>
DC77 9216	# <CJK>
DC78 957B	# <CJK>
DC79 958D	# <CJK>
DC7A 958C	# <CJK>
DC7B 9590	# <CJK>
DC7C 9687	# <CJK>
DC7D 967E	# <CJK>
DC7E 9688	# <CJK>
DCA1 9689	# <CJK>
DCA2 9683	# <CJK>
DCA3 9680	# <CJK>
DCA4 96C2	# <CJK>
DCA5 96C8	# <CJK>
DCA6 96C3	# <CJK>
DCA7 96F1	# <CJK>
DCA8 96F0	# <CJK>
DCA9 976C	# <CJK>
DCAA 9770	# <CJK>
DCAB 976E	# <CJK>
DCAC 9807	# <CJK>
DCAD 98A9	# <CJK>
DCAE 98EB	# <CJK>
DCAF 9CE6	# <CJK>
DCB0 9EF9	# <CJK>
DCB1 4E83	# <CJK>
DCB2 4E84	# <CJK>
DCB3 4EB6	# <CJK>
DCB4 50BD	# <CJK>
DCB5 50BF	# <CJK>
DCB6 50C6	# <CJK>
DCB7 50AE	# <CJK>
DCB8 50C4	# <CJK>
DCB9 50CA	# <CJK>
DCBA 50B4	# <CJK>
DCBB 50C8	# <CJK>
DCBC 50C2	# <CJK>
DCBD 50B0	# <CJK>
DCBE 50C1	# <CJK>
DCBF 50BA	# <CJK>
DCC0 50B1	# <CJK>
DCC1 50CB	# <CJK>
DCC2 50C9	# <CJK>
DCC3 50B6	# <CJK>
DCC4 50B8	# <CJK>
DCC5 51D7	# <CJK>
DCC6 527A	# <CJK>
DCC7 5278	# <CJK>
DCC8 527B	# <CJK>
DCC9 527C	# <CJK>
DCCA 55C3	# <CJK>
DCCB 55DB	# <CJK>
DCCC 55CC	# <CJK>
DCCD 55D0	# <CJK>
DCCE 55CB	# <CJK>
DCCF 55CA	# <CJK>
DCD0 55DD	# <CJK>
DCD1 55C0	# <CJK>
DCD2 55D4	# <CJK>
DCD3 55C4	# <CJK>
DCD4 55E9	# <CJK>
DCD5 55BF	# <CJK>
DCD6 55D2	# <CJK>
DCD7 558D	# <CJK>
DCD8 55CF	# <CJK>
DCD9 55D5	# <CJK>
DCDA 55E2	# <CJK>
DCDB 55D6	# <CJK>
DCDC 55C8	# <CJK>
DCDD 55F2	# <CJK>
DCDE 55CD	# <CJK>
DCDF 55D9	# <CJK>
DCE0 55C2	# <CJK>
DCE1 5714	# <CJK>
DCE2 5853	# <CJK>
DCE3 5868	# <CJK>
DCE4 5864	# <CJK>
DCE5 584F	# <CJK>
DCE6 584D	# <CJK>
DCE7 5849	# <CJK>
DCE8 586F	# <CJK>
DCE9 5855	# <CJK>
DCEA 584E	# <CJK>
DCEB 585D	# <CJK>
DCEC 5859	# <CJK>
DCED 5865	# <CJK>
DCEE 585B	# <CJK>
DCEF 583D	# <CJK>
DCF0 5863	# <CJK>
DCF1 5871	# <CJK>
DCF2 58FC	# <CJK>
DCF3 5AC7	# <CJK>
DCF4 5AC4	# <CJK>
DCF5 5ACB	# <CJK>
DCF6 5ABA	# <CJK>
DCF7 5AB8	# <CJK>
DCF8 5AB1	# <CJK>
DCF9 5AB5	# <CJK>
DCFA 5AB0	# <CJK>
DCFB 5ABF	# <CJK>
DCFC 5AC8	# <CJK>
DCFD 5ABB	# <CJK>
DCFE 5AC6	# <CJK>
DD40 5AB7	# <CJK>
DD41 5AC0	# <CJK>
DD42 5ACA	# <CJK>
DD43 5AB4	# <CJK>
DD44 5AB6	# <CJK>
DD45 5ACD	# <CJK>
DD46 5AB9	# <CJK>
DD47 5A90	# <CJK>
DD48 5BD6	# <CJK>
DD49 5BD8	# <CJK>
DD4A 5BD9	# <CJK>
DD4B 5C1F	# <CJK>
DD4C 5C33	# <CJK>
DD4D 5D71	# <CJK>
DD4E 5D63	# <CJK>
DD4F 5D4A	# <CJK>
DD50 5D65	# <CJK>
DD51 5D72	# <CJK>
DD52 5D6C	# <CJK>
DD53 5D5E	# <CJK>
DD54 5D68	# <CJK>
DD55 5D67	# <CJK>
DD56 5D62	# <CJK>
DD57 5DF0	# <CJK>
DD58 5E4F	# <CJK>
DD59 5E4E	# <CJK>
DD5A 5E4A	# <CJK>
DD5B 5E4D	# <CJK>
DD5C 5E4B	# <CJK>
DD5D 5EC5	# <CJK>
DD5E 5ECC	# <CJK>
DD5F 5EC6	# <CJK>
DD60 5ECB	# <CJK>
DD61 5EC7	# <CJK>
DD62 5F40	# <CJK>
DD63 5FAF	# <CJK>
DD64 5FAD	# <CJK>
DD65 60F7	# <CJK>
DD66 6149	# <CJK>
DD67 614A	# <CJK>
DD68 612B	# <CJK>
DD69 6145	# <CJK>
DD6A 6136	# <CJK>
DD6B 6132	# <CJK>
DD6C 612E	# <CJK>
DD6D 6146	# <CJK>
DD6E 612F	# <CJK>
DD6F 614F	# <CJK>
DD70 6129	# <CJK>
DD71 6140	# <CJK>
DD72 6220	# <CJK>
DD73 9168	# <CJK>
DD74 6223	# <CJK>
DD75 6225	# <CJK>
DD76 6224	# <CJK>
DD77 63C5	# <CJK>
DD78 63F1	# <CJK>
DD79 63EB	# <CJK>
DD7A 6410	# <CJK>
DD7B 6412	# <CJK>
DD7C 6409	# <CJK>
DD7D 6420	# <CJK>
DD7E 6424	# <CJK>
DDA1 6433	# <CJK>
DDA2 6443	# <CJK>
DDA3 641F	# <CJK>
DDA4 6415	# <CJK>
DDA5 6418	# <CJK>
DDA6 6439	# <CJK>
DDA7 6437	# <CJK>
DDA8 6422	# <CJK>
DDA9 6423	# <CJK>
DDAA 640C	# <CJK>
DDAB 6426	# <CJK>
DDAC 6430	# <CJK>
DDAD 6428	# <CJK>
DDAE 6441	# <CJK>
DDAF 6435	# <CJK>
DDB0 642F	# <CJK>
DDB1 640A	# <CJK>
DDB2 641A	# <CJK>
DDB3 6440	# <CJK>
DDB4 6425	# <CJK>
DDB5 6427	# <CJK>
DDB6 640B	# <CJK>
DDB7 63E7	# <CJK>
DDB8 641B	# <CJK>
DDB9 642E	# <CJK>
DDBA 6421	# <CJK>
DDBB 640E	# <CJK>
DDBC 656F	# <CJK>
DDBD 6592	# <CJK>
DDBE 65D3	# <CJK>
DDBF 6686	# <CJK>
DDC0 668C	# <CJK>
DDC1 6695	# <CJK>
DDC2 6690	# <CJK>
DDC3 668B	# <CJK>
DDC4 668A	# <CJK>
DDC5 6699	# <CJK>
DDC6 6694	# <CJK>
DDC7 6678	# <CJK>
DDC8 6720	# <CJK>
DDC9 6966	# <CJK>
DDCA 695F	# <CJK>
DDCB 6938	# <CJK>
DDCC 694E	# <CJK>
DDCD 6962	# <CJK>
DDCE 6971	# <CJK>
DDCF 693F	# <CJK>
DDD0 6945	# <CJK>
DDD1 696A	# <CJK>
DDD2 6939	# <CJK>
DDD3 6942	# <CJK>
DDD4 6957	# <CJK>
DDD5 6959	# <CJK>
DDD6 697A	# <CJK>
DDD7 6948	# <CJK>
DDD8 6949	# <CJK>
DDD9 6935	# <CJK>
DDDA 696C	# <CJK>
DDDB 6933	# <CJK>
DDDC 693D	# <CJK>
DDDD 6965	# <CJK>
DDDE 68F0	# <CJK>
DDDF 6978	# <CJK>
DDE0 6934	# <CJK>
DDE1 6969	# <CJK>
DDE2 6940	# <CJK>
DDE3 696F	# <CJK>
DDE4 6944	# <CJK>
DDE5 6976	# <CJK>
DDE6 6958	# <CJK>
DDE7 6941	# <CJK>
DDE8 6974	# <CJK>
DDE9 694C	# <CJK>
DDEA 693B	# <CJK>
DDEB 694B	# <CJK>
DDEC 6937	# <CJK>
DDED 695C	# <CJK>
DDEE 694F	# <CJK>
DDEF 6951	# <CJK>
DDF0 6932	# <CJK>
DDF1 6952	# <CJK>
DDF2 692F	# <CJK>
DDF3 697B	# <CJK>
DDF4 693C	# <CJK>
DDF5 6B46	# <CJK>
DDF6 6B45	# <CJK>
DDF7 6B43	# <CJK>
DDF8 6B42	# <CJK>
DDF9 6B48	# <CJK>
DDFA 6B41	# <CJK>
DDFB 6B9B	# <CJK>
DDFC FA0D	# CJK COMPATIBILITY IDEOGRAPH-FA0D
DDFD 6BFB	# <CJK>
DDFE 6BFC	# <CJK>
DE40 6BF9	# <CJK>
DE41 6BF7	# <CJK>
DE42 6BF8	# <CJK>
DE43 6E9B	# <CJK>
DE44 6ED6	# <CJK>
DE45 6EC8	# <CJK>
DE46 6E8F	# <CJK>
DE47 6EC0	# <CJK>
DE48 6E9F	# <CJK>
DE49 6E93	# <CJK>
DE4A 6E94	# <CJK>
DE4B 6EA0	# <CJK>
DE4C 6EB1	# <CJK>
DE4D 6EB9	# <CJK>
DE4E 6EC6	# <CJK>
DE4F 6ED2	# <CJK>
DE50 6EBD	# <CJK>
DE51 6EC1	# <CJK>
DE52 6E9E	# <CJK>
DE53 6EC9	# <CJK>
DE54 6EB7	# <CJK>
DE55 6EB0	# <CJK>
DE56 6ECD	# <CJK>
DE57 6EA6	# <CJK>
DE58 6ECF	# <CJK>
DE59 6EB2	# <CJK>
DE5A 6EBE	# <CJK>
DE5B 6EC3	# <CJK>
DE5C 6EDC	# <CJK>
DE5D 6ED8	# <CJK>
DE5E 6E99	# <CJK>
DE5F 6E92	# <CJK>
DE60 6E8E	# <CJK>
DE61 6E8D	# <CJK>
DE62 6EA4	# <CJK>
DE63 6EA1	# <CJK>
DE64 6EBF	# <CJK>
DE65 6EB3	# <CJK>
DE66 6ED0	# <CJK>
DE67 6ECA	# <CJK>
DE68 6E97	# <CJK>
DE69 6EAE	# <CJK>
DE6A 6EA3	# <CJK>
DE6B 7147	# <CJK>
DE6C 7154	# <CJK>
DE6D 7152	# <CJK>
DE6E 7163	# <CJK>
DE6F 7160	# <CJK>
DE70 7141	# <CJK>
DE71 715D	# <CJK>
DE72 7162	# <CJK>
DE73 7172	# <CJK>
DE74 7178	# <CJK>
DE75 716A	# <CJK>
DE76 7161	# <CJK>
DE77 7142	# <CJK>
DE78 7158	# <CJK>
DE79 7143	# <CJK>
DE7A 714B	# <CJK>
DE7B 7170	# <CJK>
DE7C 715F	# <CJK>
DE7D 7150	# <CJK>
DE7E 7153	# <CJK>
DEA1 7144	# <CJK>
DEA2 714D	# <CJK>
DEA3 715A	# <CJK>
DEA4 724F	# <CJK>
DEA5 728D	# <CJK>
DEA6 728C	# <CJK>
DEA7 7291	# <CJK>
DEA8 7290	# <CJK>
DEA9 728E	# <CJK>
DEAA 733C	# <CJK>
DEAB 7342	# <CJK>
DEAC 733B	# <CJK>
DEAD 733A	# <CJK>
DEAE 7340	# <CJK>
DEAF 734A	# <CJK>
DEB0 7349	# <CJK>
DEB1 7444	# <CJK>
DEB2 744A	# <CJK>
DEB3 744B	# <CJK>
DEB4 7452	# <CJK>
DEB5 7451	# <CJK>
DEB6 7457	# <CJK>
DEB7 7440	# <CJK>
DEB8 744F	# <CJK>
DEB9 7450	# <CJK>
DEBA 744E	# <CJK>
DEBB 7442	# <CJK>
DEBC 7446	# <CJK>
DEBD 744D	# <CJK>
DEBE 7454	# <CJK>
DEBF 74E1	# <CJK>
DEC0 74FF	# <CJK>
DEC1 74FE	# <CJK>
DEC2 74FD	# <CJK>
DEC3 751D	# <CJK>
DEC4 7579	# <CJK>
DEC5 7577	# <CJK>
DEC6 6983	# <CJK>
DEC7 75EF	# <CJK>
DEC8 760F	# <CJK>
DEC9 7603	# <CJK>
DECA 75F7	# <CJK>
DECB 75FE	# <CJK>
DECC 75FC	# <CJK>
DECD 75F9	# <CJK>
DECE 75F8	# <CJK>
DECF 7610	# <CJK>
DED0 75FB	# <CJK>
DED1 75F6	# <CJK>
DED2 75ED	# <CJK>
DED3 75F5	# <CJK>
DED4 75FD	# <CJK>
DED5 7699	# <CJK>
DED6 76B5	# <CJK>
DED7 76DD	# <CJK>
DED8 7755	# <CJK>
DED9 775F	# <CJK>
DEDA 7760	# <CJK>
DEDB 7752	# <CJK>
DEDC 7756	# <CJK>
DEDD 775A	# <CJK>
DEDE 7769	# <CJK>
DEDF 7767	# <CJK>
DEE0 7754	# <CJK>
DEE1 7759	# <CJK>
DEE2 776D	# <CJK>
DEE3 77E0	# <CJK>
DEE4 7887	# <CJK>
DEE5 789A	# <CJK>
DEE6 7894	# <CJK>
DEE7 788F	# <CJK>
DEE8 7884	# <CJK>
DEE9 7895	# <CJK>
DEEA 7885	# <CJK>
DEEB 7886	# <CJK>
DEEC 78A1	# <CJK>
DEED 7883	# <CJK>
DEEE 7879	# <CJK>
DEEF 7899	# <CJK>
DEF0 7880	# <CJK>
DEF1 7896	# <CJK>
DEF2 787B	# <CJK>
DEF3 797C	# <CJK>
DEF4 7982	# <CJK>
DEF5 797D	# <CJK>
DEF6 7979	# <CJK>
DEF7 7A11	# <CJK>
DEF8 7A18	# <CJK>
DEF9 7A19	# <CJK>
DEFA 7A12	# <CJK>
DEFB 7A17	# <CJK>
DEFC 7A15	# <CJK>
DEFD 7A22	# <CJK>
DEFE 7A13	# <CJK>
DF40 7A1B	# <CJK>
DF41 7A10	# <CJK>
DF42 7AA3	# <CJK>
DF43 7AA2	# <CJK>
DF44 7A9E	# <CJK>
DF45 7AEB	# <CJK>
DF46 7B66	# <CJK>
DF47 7B64	# <CJK>
DF48 7B6D	# <CJK>
DF49 7B74	# <CJK>
DF4A 7B69	# <CJK>
DF4B 7B72	# <CJK>
DF4C 7B65	# <CJK>
DF4D 7B73	# <CJK>
DF4E 7B71	# <CJK>
DF4F 7B70	# <CJK>
DF50 7B61	# <CJK>
DF51 7B78	# <CJK>
DF52 7B76	# <CJK>
DF53 7B63	# <CJK>
DF54 7CB2	# <CJK>
DF55 7CB4	# <CJK>
DF56 7CAF	# <CJK>
DF57 7D88	# <CJK>
DF58 7D86	# <CJK>
DF59 7D80	# <CJK>
DF5A 7D8D	# <CJK>
DF5B 7D7F	# <CJK>
DF5C 7D85	# <CJK>
DF5D 7D7A	# <CJK>
DF5E 7D8E	# <CJK>
DF5F 7D7B	# <CJK>
DF60 7D83	# <CJK>
DF61 7D7C	# <CJK>
DF62 7D8C	# <CJK>
DF63 7D94	# <CJK>
DF64 7D84	# <CJK>
DF65 7D7D	# <CJK>
DF66 7D92	# <CJK>
DF67 7F6D	# <CJK>
DF68 7F6B	# <CJK>
DF69 7F67	# <CJK>
DF6A 7F68	# <CJK>
DF6B 7F6C	# <CJK>
DF6C 7FA6	# <CJK>
DF6D 7FA5	# <CJK>
DF6E 7FA7	# <CJK>
DF6F 7FDB	# <CJK>
DF70 7FDC	# <CJK>
DF71 8021	# <CJK>
DF72 8164	# <CJK>
DF73 8160	# <CJK>
DF74 8177	# <CJK>
DF75 815C	# <CJK>
DF76 8169	# <CJK>
DF77 815B	# <CJK>
DF78 8162	# <CJK>
DF79 8172	# <CJK>
DF7A 6721	# <CJK>
DF7B 815E	# <CJK>
DF7C 8176	# <CJK>
DF7D 8167	# <CJK>
DF7E 816F	# <CJK>
DFA1 8144	# <CJK>
DFA2 8161	# <CJK>
DFA3 821D	# <CJK>
DFA4 8249	# <CJK>
DFA5 8244	# <CJK>
DFA6 8240	# <CJK>
DFA7 8242	# <CJK>
DFA8 8245	# <CJK>
DFA9 84F1	# <CJK>
DFAA 843F	# <CJK>
DFAB 8456	# <CJK>
DFAC 8476	# <CJK>
DFAD 8479	# <CJK>
DFAE 848F	# <CJK>
DFAF 848D	# <CJK>
DFB0 8465	# <CJK>
DFB1 8451	# <CJK>
DFB2 8440	# <CJK>
DFB3 8486	# <CJK>
DFB4 8467	# <CJK>
DFB5 8430	# <CJK>
DFB6 844D	# <CJK>
DFB7 847D	# <CJK>
DFB8 845A	# <CJK>
DFB9 8459	# <CJK>
DFBA 8474	# <CJK>
DFBB 8473	# <CJK>
DFBC 845D	# <CJK>
DFBD 8507	# <CJK>
DFBE 845E	# <CJK>
DFBF 8437	# <CJK>
DFC0 843A	# <CJK>
DFC1 8434	# <CJK>
DFC2 847A	# <CJK>
DFC3 8443	# <CJK>
DFC4 8478	# <CJK>
DFC5 8432	# <CJK>
DFC6 8445	# <CJK>
DFC7 8429	# <CJK>
DFC8 83D9	# <CJK>
DFC9 844B	# <CJK>
DFCA 842F	# <CJK>
DFCB 8442	# <CJK>
DFCC 842D	# <CJK>
DFCD 845F	# <CJK>
DFCE 8470	# <CJK>
DFCF 8439	# <CJK>
DFD0 844E	# <CJK>
DFD1 844C	# <CJK>
DFD2 8452	# <CJK>
DFD3 846F	# <CJK>
DFD4 84C5	# <CJK>
DFD5 848E	# <CJK>
DFD6 843B	# <CJK>
DFD7 8447	# <CJK>
DFD8 8436	# <CJK>
DFD9 8433	# <CJK>
DFDA 8468	# <CJK>
DFDB 847E	# <CJK>
DFDC 8444	# <CJK>
DFDD 842B	# <CJK>
DFDE 8460	# <CJK>
DFDF 8454	# <CJK>
DFE0 846E	# <CJK>
DFE1 8450	# <CJK>
DFE2 870B	# <CJK>
DFE3 8704	# <CJK>
DFE4 86F7	# <CJK>
DFE5 870C	# <CJK>
DFE6 86FA	# <CJK>
DFE7 86D6	# <CJK>
DFE8 86F5	# <CJK>
DFE9 874D	# <CJK>
DFEA 86F8	# <CJK>
DFEB 870E	# <CJK>
DFEC 8709	# <CJK>
DFED 8701	# <CJK>
DFEE 86F6	# <CJK>
DFEF 870D	# <CJK>
DFF0 8705	# <CJK>
DFF1 88D6	# <CJK>
DFF2 88CB	# <CJK>
DFF3 88CD	# <CJK>
DFF4 88CE	# <CJK>
DFF5 88DE	# <CJK>
DFF6 88DB	# <CJK>
DFF7 88DA	# <CJK>
DFF8 88CC	# <CJK>
DFF9 88D0	# <CJK>
DFFA 8985	# <CJK>
DFFB 899B	# <CJK>
DFFC 89DF	# <CJK>
DFFD 89E5	# <CJK>
DFFE 89E4	# <CJK>
E040 89E1	# <CJK>
E041 89E0	# <CJK>
E042 89E2	# <CJK>
E043 89DC	# <CJK>
E044 89E6	# <CJK>
E045 8A76	# <CJK>
E046 8A86	# <CJK>
E047 8A7F	# <CJK>
E048 8A61	# <CJK>
E049 8A3F	# <CJK>
E04A 8A77	# <CJK>
E04B 8A82	# <CJK>
E04C 8A84	# <CJK>
E04D 8A75	# <CJK>
E04E 8A83	# <CJK>
E04F 8A81	# <CJK>
E050 8A74	# <CJK>
E051 8A7A	# <CJK>
E052 8C3C	# <CJK>
E053 8C4B	# <CJK>
E054 8C4A	# <CJK>
E055 8C65	# <CJK>
E056 8C64	# <CJK>
E057 8C66	# <CJK>
E058 8C86	# <CJK>
E059 8C84	# <CJK>
E05A 8C85	# <CJK>
E05B 8CCC	# <CJK>
E05C 8D68	# <CJK>
E05D 8D69	# <CJK>
E05E 8D91	# <CJK>
E05F 8D8C	# <CJK>
E060 8D8E	# <CJK>
E061 8D8F	# <CJK>
E062 8D8D	# <CJK>
E063 8D93	# <CJK>
E064 8D94	# <CJK>
E065 8D90	# <CJK>
E066 8D92	# <CJK>
E067 8DF0	# <CJK>
E068 8DE0	# <CJK>
E069 8DEC	# <CJK>
E06A 8DF1	# <CJK>
E06B 8DEE	# <CJK>
E06C 8DD0	# <CJK>
E06D 8DE9	# <CJK>
E06E 8DE3	# <CJK>
E06F 8DE2	# <CJK>
E070 8DE7	# <CJK>
E071 8DF2	# <CJK>
E072 8DEB	# <CJK>
E073 8DF4	# <CJK>
E074 8F06	# <CJK>
E075 8EFF	# <CJK>
E076 8F01	# <CJK>
E077 8F00	# <CJK>
E078 8F05	# <CJK>
E079 8F07	# <CJK>
E07A 8F08	# <CJK>
E07B 8F02	# <CJK>
E07C 8F0B	# <CJK>
E07D 9052	# <CJK>
E07E 903F	# <CJK>
E0A1 9044	# <CJK>
E0A2 9049	# <CJK>
E0A3 903D	# <CJK>
E0A4 9110	# <CJK>
E0A5 910D	# <CJK>
E0A6 910F	# <CJK>
E0A7 9111	# <CJK>
E0A8 9116	# <CJK>
E0A9 9114	# <CJK>
E0AA 910B	# <CJK>
E0AB 910E	# <CJK>
E0AC 916E	# <CJK>
E0AD 916F	# <CJK>
E0AE 9248	# <CJK>
E0AF 9252	# <CJK>
E0B0 9230	# <CJK>
E0B1 923A	# <CJK>
E0B2 9266	# <CJK>
E0B3 9233	# <CJK>
E0B4 9265	# <CJK>
E0B5 925E	# <CJK>
E0B6 9283	# <CJK>
E0B7 922E	# <CJK>
E0B8 924A	# <CJK>
E0B9 9246	# <CJK>
E0BA 926D	# <CJK>
E0BB 926C	# <CJK>
E0BC 924F	# <CJK>
E0BD 9260	# <CJK>
E0BE 9267	# <CJK>
E0BF 926F	# <CJK>
E0C0 9236	# <CJK>
E0C1 9261	# <CJK>
E0C2 9270	# <CJK>
E0C3 9231	# <CJK>
E0C4 9254	# <CJK>
E0C5 9263	# <CJK>
E0C6 9250	# <CJK>
E0C7 9272	# <CJK>
E0C8 924E	# <CJK>
E0C9 9253	# <CJK>
E0CA 924C	# <CJK>
E0CB 9256	# <CJK>
E0CC 9232	# <CJK>
E0CD 959F	# <CJK>
E0CE 959C	# <CJK>
E0CF 959E	# <CJK>
E0D0 959B	# <CJK>
E0D1 9692	# <CJK>
E0D2 9693	# <CJK>
E0D3 9691	# <CJK>
E0D4 9697	# <CJK>
E0D5 96CE	# <CJK>
E0D6 96FA	# <CJK>
E0D7 96FD	# <CJK>
E0D8 96F8	# <CJK>
E0D9 96F5	# <CJK>
E0DA 9773	# <CJK>
E0DB 9777	# <CJK>
E0DC 9778	# <CJK>
E0DD 9772	# <CJK>
E0DE 980F	# <CJK>
E0DF 980D	# <CJK>
E0E0 980E	# <CJK>
E0E1 98AC	# <CJK>
E0E2 98F6	# <CJK>
E0E3 98F9	# <CJK>
E0E4 99AF	# <CJK>
E0E5 99B2	# <CJK>
E0E6 99B0	# <CJK>
E0E7 99B5	# <CJK>
E0E8 9AAD	# <CJK>
E0E9 9AAB	# <CJK>
E0EA 9B5B	# <CJK>
E0EB 9CEA	# <CJK>
E0EC 9CED	# <CJK>
E0ED 9CE7	# <CJK>
E0EE 9E80	# <CJK>
E0EF 9EFD	# <CJK>
E0F0 50E6	# <CJK>
E0F1 50D4	# <CJK>
E0F2 50D7	# <CJK>
E0F3 50E8	# <CJK>
E0F4 50F3	# <CJK>
E0F5 50DB	# <CJK>
E0F6 50EA	# <CJK>
E0F7 50DD	# <CJK>
E0F8 50E4	# <CJK>
E0F9 50D3	# <CJK>
E0FA 50EC	# <CJK>
E0FB 50F0	# <CJK>
E0FC 50EF	# <CJK>
E0FD 50E3	# <CJK>
E0FE 50E0	# <CJK>
E140 51D8	# <CJK>
E141 5280	# <CJK>
E142 5281	# <CJK>
E143 52E9	# <CJK>
E144 52EB	# <CJK>
E145 5330	# <CJK>
E146 53AC	# <CJK>
E147 5627	# <CJK>
E148 5615	# <CJK>
E149 560C	# <CJK>
E14A 5612	# <CJK>
E14B 55FC	# <CJK>
E14C 560F	# <CJK>
E14D 561C	# <CJK>
E14E 5601	# <CJK>
E14F 5613	# <CJK>
E150 5602	# <CJK>
E151 55FA	# <CJK>
E152 561D	# <CJK>
E153 5604	# <CJK>
E154 55FF	# <CJK>
E155 55F9	# <CJK>
E156 5889	# <CJK>
E157 587C	# <CJK>
E158 5890	# <CJK>
E159 5898	# <CJK>
E15A 5886	# <CJK>
E15B 5881	# <CJK>
E15C 587F	# <CJK>
E15D 5874	# <CJK>
E15E 588B	# <CJK>
E15F 587A	# <CJK>
E160 5887	# <CJK>
E161 5891	# <CJK>
E162 588E	# <CJK>
E163 5876	# <CJK>
E164 5882	# <CJK>
E165 5888	# <CJK>
E166 587B	# <CJK>
E167 5894	# <CJK>
E168 588F	# <CJK>
E169 58FE	# <CJK>
E16A 596B	# <CJK>
E16B 5ADC	# <CJK>
E16C 5AEE	# <CJK>
E16D 5AE5	# <CJK>
E16E 5AD5	# <CJK>
E16F 5AEA	# <CJK>
E170 5ADA	# <CJK>
E171 5AED	# <CJK>
E172 5AEB	# <CJK>
E173 5AF3	# <CJK>
E174 5AE2	# <CJK>
E175 5AE0	# <CJK>
E176 5ADB	# <CJK>
E177 5AEC	# <CJK>
E178 5ADE	# <CJK>
E179 5ADD	# <CJK>
E17A 5AD9	# <CJK>
E17B 5AE8	# <CJK>
E17C 5ADF	# <CJK>
E17D 5B77	# <CJK>
E17E 5BE0	# <CJK>
E1A1 5BE3	# <CJK>
E1A2 5C63	# <CJK>
E1A3 5D82	# <CJK>
E1A4 5D80	# <CJK>
E1A5 5D7D	# <CJK>
E1A6 5D86	# <CJK>
E1A7 5D7A	# <CJK>
E1A8 5D81	# <CJK>
E1A9 5D77	# <CJK>
E1AA 5D8A	# <CJK>
E1AB 5D89	# <CJK>
E1AC 5D88	# <CJK>
E1AD 5D7E	# <CJK>
E1AE 5D7C	# <CJK>
E1AF 5D8D	# <CJK>
E1B0 5D79	# <CJK>
E1B1 5D7F	# <CJK>
E1B2 5E58	# <CJK>
E1B3 5E59	# <CJK>
E1B4 5E53	# <CJK>
E1B5 5ED8	# <CJK>
E1B6 5ED1	# <CJK>
E1B7 5ED7	# <CJK>
E1B8 5ECE	# <CJK>
E1B9 5EDC	# <CJK>
E1BA 5ED5	# <CJK>
E1BB 5ED9	# <CJK>
E1BC 5ED2	# <CJK>
E1BD 5ED4	# <CJK>
E1BE 5F44	# <CJK>
E1BF 5F43	# <CJK>
E1C0 5F6F	# <CJK>
E1C1 5FB6	# <CJK>
E1C2 612C	# <CJK>
E1C3 6128	# <CJK>
E1C4 6141	# <CJK>
E1C5 615E	# <CJK>
E1C6 6171	# <CJK>
E1C7 6173	# <CJK>
E1C8 6152	# <CJK>
E1C9 6153	# <CJK>
E1CA 6172	# <CJK>
E1CB 616C	# <CJK>
E1CC 6180	# <CJK>
E1CD 6174	# <CJK>
E1CE 6154	# <CJK>
E1CF 617A	# <CJK>
E1D0 615B	# <CJK>
E1D1 6165	# <CJK>
E1D2 613B	# <CJK>
E1D3 616A	# <CJK>
E1D4 6161	# <CJK>
E1D5 6156	# <CJK>
E1D6 6229	# <CJK>
E1D7 6227	# <CJK>
E1D8 622B	# <CJK>
E1D9 642B	# <CJK>
E1DA 644D	# <CJK>
E1DB 645B	# <CJK>
E1DC 645D	# <CJK>
E1DD 6474	# <CJK>
E1DE 6476	# <CJK>
E1DF 6472	# <CJK>
E1E0 6473	# <CJK>
E1E1 647D	# <CJK>
E1E2 6475	# <CJK>
E1E3 6466	# <CJK>
E1E4 64A6	# <CJK>
E1E5 644E	# <CJK>
E1E6 6482	# <CJK>
E1E7 645E	# <CJK>
E1E8 645C	# <CJK>
E1E9 644B	# <CJK>
E1EA 6453	# <CJK>
E1EB 6460	# <CJK>
E1EC 6450	# <CJK>
E1ED 647F	# <CJK>
E1EE 643F	# <CJK>
E1EF 646C	# <CJK>
E1F0 646B	# <CJK>
E1F1 6459	# <CJK>
E1F2 6465	# <CJK>
E1F3 6477	# <CJK>
E1F4 6573	# <CJK>
E1F5 65A0	# <CJK>
E1F6 66A1	# <CJK>
E1F7 66A0	# <CJK>
E1F8 669F	# <CJK>
E1F9 6705	# <CJK>
E1FA 6704	# <CJK>
E1FB 6722	# <CJK>
E1FC 69B1	# <CJK>
E1FD 69B6	# <CJK>
E1FE 69C9	# <CJK>
E240 69A0	# <CJK>
E241 69CE	# <CJK>
E242 6996	# <CJK>
E243 69B0	# <CJK>
E244 69AC	# <CJK>
E245 69BC	# <CJK>
E246 6991	# <CJK>
E247 6999	# <CJK>
E248 698E	# <CJK>
E249 69A7	# <CJK>
E24A 698D	# <CJK>
E24B 69A9	# <CJK>
E24C 69BE	# <CJK>
E24D 69AF	# <CJK>
E24E 69BF	# <CJK>
E24F 69C4	# <CJK>
E250 69BD	# <CJK>
E251 69A4	# <CJK>
E252 69D4	# <CJK>
E253 69B9	# <CJK>
E254 69CA	# <CJK>
E255 699A	# <CJK>
E256 69CF	# <CJK>
E257 69B3	# <CJK>
E258 6993	# <CJK>
E259 69AA	# <CJK>
E25A 69A1	# <CJK>
E25B 699E	# <CJK>
E25C 69D9	# <CJK>
E25D 6997	# <CJK>
E25E 6990	# <CJK>
E25F 69C2	# <CJK>
E260 69B5	# <CJK>
E261 69A5	# <CJK>
E262 69C6	# <CJK>
E263 6B4A	# <CJK>
E264 6B4D	# <CJK>
E265 6B4B	# <CJK>
E266 6B9E	# <CJK>
E267 6B9F	# <CJK>
E268 6BA0	# <CJK>
E269 6BC3	# <CJK>
E26A 6BC4	# <CJK>
E26B 6BFE	# <CJK>
E26C 6ECE	# <CJK>
E26D 6EF5	# <CJK>
E26E 6EF1	# <CJK>
E26F 6F03	# <CJK>
E270 6F25	# <CJK>
E271 6EF8	# <CJK>
E272 6F37	# <CJK>
E273 6EFB	# <CJK>
E274 6F2E	# <CJK>
E275 6F09	# <CJK>
E276 6F4E	# <CJK>
E277 6F19	# <CJK>
E278 6F1A	# <CJK>
E279 6F27	# <CJK>
E27A 6F18	# <CJK>
E27B 6F3B	# <CJK>
E27C 6F12	# <CJK>
E27D 6EED	# <CJK>
E27E 6F0A	# <CJK>
E2A1 6F36	# <CJK>
E2A2 6F73	# <CJK>
E2A3 6EF9	# <CJK>
E2A4 6EEE	# <CJK>
E2A5 6F2D	# <CJK>
E2A6 6F40	# <CJK>
E2A7 6F30	# <CJK>
E2A8 6F3C	# <CJK>
E2A9 6F35	# <CJK>
E2AA 6EEB	# <CJK>
E2AB 6F07	# <CJK>
E2AC 6F0E	# <CJK>
E2AD 6F43	# <CJK>
E2AE 6F05	# <CJK>
E2AF 6EFD	# <CJK>
E2B0 6EF6	# <CJK>
E2B1 6F39	# <CJK>
E2B2 6F1C	# <CJK>
E2B3 6EFC	# <CJK>
E2B4 6F3A	# <CJK>
E2B5 6F1F	# <CJK>
E2B6 6F0D	# <CJK>
E2B7 6F1E	# <CJK>
E2B8 6F08	# <CJK>
E2B9 6F21	# <CJK>
E2BA 7187	# <CJK>
E2BB 7190	# <CJK>
E2BC 7189	# <CJK>
E2BD 7180	# <CJK>
E2BE 7185	# <CJK>
E2BF 7182	# <CJK>
E2C0 718F	# <CJK>
E2C1 717B	# <CJK>
E2C2 7186	# <CJK>
E2C3 7181	# <CJK>
E2C4 7197	# <CJK>
E2C5 7244	# <CJK>
E2C6 7253	# <CJK>
E2C7 7297	# <CJK>
E2C8 7295	# <CJK>
E2C9 7293	# <CJK>
E2CA 7343	# <CJK>
E2CB 734D	# <CJK>
E2CC 7351	# <CJK>
E2CD 734C	# <CJK>
E2CE 7462	# <CJK>
E2CF 7473	# <CJK>
E2D0 7471	# <CJK>
E2D1 7475	# <CJK>
E2D2 7472	# <CJK>
E2D3 7467	# <CJK>
E2D4 746E	# <CJK>
E2D5 7500	# <CJK>
E2D6 7502	# <CJK>
E2D7 7503	# <CJK>
E2D8 757D	# <CJK>
E2D9 7590	# <CJK>
E2DA 7616	# <CJK>
E2DB 7608	# <CJK>
E2DC 760C	# <CJK>
E2DD 7615	# <CJK>
E2DE 7611	# <CJK>
E2DF 760A	# <CJK>
E2E0 7614	# <CJK>
E2E1 76B8	# <CJK>
E2E2 7781	# <CJK>
E2E3 777C	# <CJK>
E2E4 7785	# <CJK>
E2E5 7782	# <CJK>
E2E6 776E	# <CJK>
E2E7 7780	# <CJK>
E2E8 776F	# <CJK>
E2E9 777E	# <CJK>
E2EA 7783	# <CJK>
E2EB 78B2	# <CJK>
E2EC 78AA	# <CJK>
E2ED 78B4	# <CJK>
E2EE 78AD	# <CJK>
E2EF 78A8	# <CJK>
E2F0 787E	# <CJK>
E2F1 78AB	# <CJK>
E2F2 789E	# <CJK>
E2F3 78A5	# <CJK>
E2F4 78A0	# <CJK>
E2F5 78AC	# <CJK>
E2F6 78A2	# <CJK>
E2F7 78A4	# <CJK>
E2F8 7998	# <CJK>
E2F9 798A	# <CJK>
E2FA 798B	# <CJK>
E2FB 7996	# <CJK>
E2FC 7995	# <CJK>
E2FD 7994	# <CJK>
E2FE 7993	# <CJK>
E340 7997	# <CJK>
E341 7988	# <CJK>
E342 7992	# <CJK>
E343 7990	# <CJK>
E344 7A2B	# <CJK>
E345 7A4A	# <CJK>
E346 7A30	# <CJK>
E347 7A2F	# <CJK>
E348 7A28	# <CJK>
E349 7A26	# <CJK>
E34A 7AA8	# <CJK>
E34B 7AAB	# <CJK>
E34C 7AAC	# <CJK>
E34D 7AEE	# <CJK>
E34E 7B88	# <CJK>
E34F 7B9C	# <CJK>
E350 7B8A	# <CJK>
E351 7B91	# <CJK>
E352 7B90	# <CJK>
E353 7B96	# <CJK>
E354 7B8D	# <CJK>
E355 7B8C	# <CJK>
E356 7B9B	# <CJK>
E357 7B8E	# <CJK>
E358 7B85	# <CJK>
E359 7B98	# <CJK>
E35A 5284	# <CJK>
E35B 7B99	# <CJK>
E35C 7BA4	# <CJK>
E35D 7B82	# <CJK>
E35E 7CBB	# <CJK>
E35F 7CBF	# <CJK>
E360 7CBC	# <CJK>
E361 7CBA	# <CJK>
E362 7DA7	# <CJK>
E363 7DB7	# <CJK>
E364 7DC2	# <CJK>
E365 7DA3	# <CJK>
E366 7DAA	# <CJK>
E367 7DC1	# <CJK>
E368 7DC0	# <CJK>
E369 7DC5	# <CJK>
E36A 7D9D	# <CJK>
E36B 7DCE	# <CJK>
E36C 7DC4	# <CJK>
E36D 7DC6	# <CJK>
E36E 7DCB	# <CJK>
E36F 7DCC	# <CJK>
E370 7DAF	# <CJK>
E371 7DB9	# <CJK>
E372 7D96	# <CJK>
E373 7DBC	# <CJK>
E374 7D9F	# <CJK>
E375 7DA6	# <CJK>
E376 7DAE	# <CJK>
E377 7DA9	# <CJK>
E378 7DA1	# <CJK>
E379 7DC9	# <CJK>
E37A 7F73	# <CJK>
E37B 7FE2	# <CJK>
E37C 7FE3	# <CJK>
E37D 7FE5	# <CJK>
E37E 7FDE	# <CJK>
E3A1 8024	# <CJK>
E3A2 805D	# <CJK>
E3A3 805C	# <CJK>
E3A4 8189	# <CJK>
E3A5 8186	# <CJK>
E3A6 8183	# <CJK>
E3A7 8187	# <CJK>
E3A8 818D	# <CJK>
E3A9 818C	# <CJK>
E3AA 818B	# <CJK>
E3AB 8215	# <CJK>
E3AC 8497	# <CJK>
E3AD 84A4	# <CJK>
E3AE 84A1	# <CJK>
E3AF 849F	# <CJK>
E3B0 84BA	# <CJK>
E3B1 84CE	# <CJK>
E3B2 84C2	# <CJK>
E3B3 84AC	# <CJK>
E3B4 84AE	# <CJK>
E3B5 84AB	# <CJK>
E3B6 84B9	# <CJK>
E3B7 84B4	# <CJK>
E3B8 84C1	# <CJK>
E3B9 84CD	# <CJK>
E3BA 84AA	# <CJK>
E3BB 849A	# <CJK>
E3BC 84B1	# <CJK>
E3BD 84D0	# <CJK>
E3BE 849D	# <CJK>
E3BF 84A7	# <CJK>
E3C0 84BB	# <CJK>
E3C1 84A2	# <CJK>
E3C2 8494	# <CJK>
E3C3 84C7	# <CJK>
E3C4 84CC	# <CJK>
E3C5 849B	# <CJK>
E3C6 84A9	# <CJK>
E3C7 84AF	# <CJK>
E3C8 84A8	# <CJK>
E3C9 84D6	# <CJK>
E3CA 8498	# <CJK>
E3CB 84B6	# <CJK>
E3CC 84CF	# <CJK>
E3CD 84A0	# <CJK>
E3CE 84D7	# <CJK>
E3CF 84D4	# <CJK>
E3D0 84D2	# <CJK>
E3D1 84DB	# <CJK>
E3D2 84B0	# <CJK>
E3D3 8491	# <CJK>
E3D4 8661	# <CJK>
E3D5 8733	# <CJK>
E3D6 8723	# <CJK>
E3D7 8728	# <CJK>
E3D8 876B	# <CJK>
E3D9 8740	# <CJK>
E3DA 872E	# <CJK>
E3DB 871E	# <CJK>
E3DC 8721	# <CJK>
E3DD 8719	# <CJK>
E3DE 871B	# <CJK>
E3DF 8743	# <CJK>
E3E0 872C	# <CJK>
E3E1 8741	# <CJK>
E3E2 873E	# <CJK>
E3E3 8746	# <CJK>
E3E4 8720	# <CJK>
E3E5 8732	# <CJK>
E3E6 872A	# <CJK>
E3E7 872D	# <CJK>
E3E8 873C	# <CJK>
E3E9 8712	# <CJK>
E3EA 873A	# <CJK>
E3EB 8731	# <CJK>
E3EC 8735	# <CJK>
E3ED 8742	# <CJK>
E3EE 8726	# <CJK>
E3EF 8727	# <CJK>
E3F0 8738	# <CJK>
E3F1 8724	# <CJK>
E3F2 871A	# <CJK>
E3F3 8730	# <CJK>
E3F4 8711	# <CJK>
E3F5 88F7	# <CJK>
E3F6 88E7	# <CJK>
E3F7 88F1	# <CJK>
E3F8 88F2	# <CJK>
E3F9 88FA	# <CJK>
E3FA 88FE	# <CJK>
E3FB 88EE	# <CJK>
E3FC 88FC	# <CJK>
E3FD 88F6	# <CJK>
E3FE 88FB	# <CJK>
E440 88F0	# <CJK>
E441 88EC	# <CJK>
E442 88EB	# <CJK>
E443 899D	# <CJK>
E444 89A1	# <CJK>
E445 899F	# <CJK>
E446 899E	# <CJK>
E447 89E9	# <CJK>
E448 89EB	# <CJK>
E449 89E8	# <CJK>
E44A 8AAB	# <CJK>
E44B 8A99	# <CJK>
E44C 8A8B	# <CJK>
E44D 8A92	# <CJK>
E44E 8A8F	# <CJK>
E44F 8A96	# <CJK>
E450 8C3D	# <CJK>
E451 8C68	# <CJK>
E452 8C69	# <CJK>
E453 8CD5	# <CJK>
E454 8CCF	# <CJK>
E455 8CD7	# <CJK>
E456 8D96	# <CJK>
E457 8E09	# <CJK>
E458 8E02	# <CJK>
E459 8DFF	# <CJK>
E45A 8E0D	# <CJK>
E45B 8DFD	# <CJK>
E45C 8E0A	# <CJK>
E45D 8E03	# <CJK>
E45E 8E07	# <CJK>
E45F 8E06	# <CJK>
E460 8E05	# <CJK>
E461 8DFE	# <CJK>
E462 8E00	# <CJK>
E463 8E04	# <CJK>
E464 8F10	# <CJK>
E465 8F11	# <CJK>
E466 8F0E	# <CJK>
E467 8F0D	# <CJK>
E468 9123	# <CJK>
E469 911C	# <CJK>
E46A 9120	# <CJK>
E46B 9122	# <CJK>
E46C 911F	# <CJK>
E46D 911D	# <CJK>
E46E 911A	# <CJK>
E46F 9124	# <CJK>
E470 9121	# <CJK>
E471 911B	# <CJK>
E472 917A	# <CJK>
E473 9172	# <CJK>
E474 9179	# <CJK>
E475 9173	# <CJK>
E476 92A5	# <CJK>
E477 92A4	# <CJK>
E478 9276	# <CJK>
E479 929B	# <CJK>
E47A 927A	# <CJK>
E47B 92A0	# <CJK>
E47C 9294	# <CJK>
E47D 92AA	# <CJK>
E47E 928D	# <CJK>
E4A1 92A6	# <CJK>
E4A2 929A	# <CJK>
E4A3 92AB	# <CJK>
E4A4 9279	# <CJK>
E4A5 9297	# <CJK>
E4A6 927F	# <CJK>
E4A7 92A3	# <CJK>
E4A8 92EE	# <CJK>
E4A9 928E	# <CJK>
E4AA 9282	# <CJK>
E4AB 9295	# <CJK>
E4AC 92A2	# <CJK>
E4AD 927D	# <CJK>
E4AE 9288	# <CJK>
E4AF 92A1	# <CJK>
E4B0 928A	# <CJK>
E4B1 9286	# <CJK>
E4B2 928C	# <CJK>
E4B3 9299	# <CJK>
E4B4 92A7	# <CJK>
E4B5 927E	# <CJK>
E4B6 9287	# <CJK>
E4B7 92A9	# <CJK>
E4B8 929D	# <CJK>
E4B9 928B	# <CJK>
E4BA 922D	# <CJK>
E4BB 969E	# <CJK>
E4BC 96A1	# <CJK>
E4BD 96FF	# <CJK>
E4BE 9758	# <CJK>
E4BF 977D	# <CJK>
E4C0 977A	# <CJK>
E4C1 977E	# <CJK>
E4C2 9783	# <CJK>
E4C3 9780	# <CJK>
E4C4 9782	# <CJK>
E4C5 977B	# <CJK>
E4C6 9784	# <CJK>
E4C7 9781	# <CJK>
E4C8 977F	# <CJK>
E4C9 97CE	# <CJK>
E4CA 97CD	# <CJK>
E4CB 9816	# <CJK>
E4CC 98AD	# <CJK>
E4CD 98AE	# <CJK>
E4CE 9902	# <CJK>
E4CF 9900	# <CJK>
E4D0 9907	# <CJK>
E4D1 999D	# <CJK>
E4D2 999C	# <CJK>
E4D3 99C3	# <CJK>
E4D4 99B9	# <CJK>
E4D5 99BB	# <CJK>
E4D6 99BA	# <CJK>
E4D7 99C2	# <CJK>
E4D8 99BD	# <CJK>
E4D9 99C7	# <CJK>
E4DA 9AB1	# <CJK>
E4DB 9AE3	# <CJK>
E4DC 9AE7	# <CJK>
E4DD 9B3E	# <CJK>
E4DE 9B3F	# <CJK>
E4DF 9B60	# <CJK>
E4E0 9B61	# <CJK>
E4E1 9B5F	# <CJK>
E4E2 9CF1	# <CJK>
E4E3 9CF2	# <CJK>
E4E4 9CF5	# <CJK>
E4E5 9EA7	# <CJK>
E4E6 50FF	# <CJK>
E4E7 5103	# <CJK>
E4E8 5130	# <CJK>
E4E9 50F8	# <CJK>
E4EA 5106	# <CJK>
E4EB 5107	# <CJK>
E4EC 50F6	# <CJK>
E4ED 50FE	# <CJK>
E4EE 510B	# <CJK>
E4EF 510C	# <CJK>
E4F0 50FD	# <CJK>
E4F1 510A	# <CJK>
E4F2 528B	# <CJK>
E4F3 528C	# <CJK>
E4F4 52F1	# <CJK>
E4F5 52EF	# <CJK>
E4F6 5648	# <CJK>
E4F7 5642	# <CJK>
E4F8 564C	# <CJK>
E4F9 5635	# <CJK>
E4FA 5641	# <CJK>
E4FB 564A	# <CJK>
E4FC 5649	# <CJK>
E4FD 5646	# <CJK>
E4FE 5658	# <CJK>
E540 565A	# <CJK>
E541 5640	# <CJK>
E542 5633	# <CJK>
E543 563D	# <CJK>
E544 562C	# <CJK>
E545 563E	# <CJK>
E546 5638	# <CJK>
E547 562A	# <CJK>
E548 563A	# <CJK>
E549 571A	# <CJK>
E54A 58AB	# <CJK>
E54B 589D	# <CJK>
E54C 58B1	# <CJK>
E54D 58A0	# <CJK>
E54E 58A3	# <CJK>
E54F 58AF	# <CJK>
E550 58AC	# <CJK>
E551 58A5	# <CJK>
E552 58A1	# <CJK>
E553 58FF	# <CJK>
E554 5AFF	# <CJK>
E555 5AF4	# <CJK>
E556 5AFD	# <CJK>
E557 5AF7	# <CJK>
E558 5AF6	# <CJK>
E559 5B03	# <CJK>
E55A 5AF8	# <CJK>
E55B 5B02	# <CJK>
E55C 5AF9	# <CJK>
E55D 5B01	# <CJK>
E55E 5B07	# <CJK>
E55F 5B05	# <CJK>
E560 5B0F	# <CJK>
E561 5C67	# <CJK>
E562 5D99	# <CJK>
E563 5D97	# <CJK>
E564 5D9F	# <CJK>
E565 5D92	# <CJK>
E566 5DA2	# <CJK>
E567 5D93	# <CJK>
E568 5D95	# <CJK>
E569 5DA0	# <CJK>
E56A 5D9C	# <CJK>
E56B 5DA1	# <CJK>
E56C 5D9A	# <CJK>
E56D 5D9E	# <CJK>
E56E 5E69	# <CJK>
E56F 5E5D	# <CJK>
E570 5E60	# <CJK>
E571 5E5C	# <CJK>
E572 7DF3	# <CJK>
E573 5EDB	# <CJK>
E574 5EDE	# <CJK>
E575 5EE1	# <CJK>
E576 5F49	# <CJK>
E577 5FB2	# <CJK>
E578 618B	# <CJK>
E579 6183	# <CJK>
E57A 6179	# <CJK>
E57B 61B1	# <CJK>
E57C 61B0	# <CJK>
E57D 61A2	# <CJK>
E57E 6189	# <CJK>
E5A1 619B	# <CJK>
E5A2 6193	# <CJK>
E5A3 61AF	# <CJK>
E5A4 61AD	# <CJK>
E5A5 619F	# <CJK>
E5A6 6192	# <CJK>
E5A7 61AA	# <CJK>
E5A8 61A1	# <CJK>
E5A9 618D	# <CJK>
E5AA 6166	# <CJK>
E5AB 61B3	# <CJK>
E5AC 622D	# <CJK>
E5AD 646E	# <CJK>
E5AE 6470	# <CJK>
E5AF 6496	# <CJK>
E5B0 64A0	# <CJK>
E5B1 6485	# <CJK>
E5B2 6497	# <CJK>
E5B3 649C	# <CJK>
E5B4 648F	# <CJK>
E5B5 648B	# <CJK>
E5B6 648A	# <CJK>
E5B7 648C	# <CJK>
E5B8 64A3	# <CJK>
E5B9 649F	# <CJK>
E5BA 6468	# <CJK>
E5BB 64B1	# <CJK>
E5BC 6498	# <CJK>
E5BD 6576	# <CJK>
E5BE 657A	# <CJK>
E5BF 6579	# <CJK>
E5C0 657B	# <CJK>
E5C1 65B2	# <CJK>
E5C2 65B3	# <CJK>
E5C3 66B5	# <CJK>
E5C4 66B0	# <CJK>
E5C5 66A9	# <CJK>
E5C6 66B2	# <CJK>
E5C7 66B7	# <CJK>
E5C8 66AA	# <CJK>
E5C9 66AF	# <CJK>
E5CA 6A00	# <CJK>
E5CB 6A06	# <CJK>
E5CC 6A17	# <CJK>
E5CD 69E5	# <CJK>
E5CE 69F8	# <CJK>
E5CF 6A15	# <CJK>
E5D0 69F1	# <CJK>
E5D1 69E4	# <CJK>
E5D2 6A20	# <CJK>
E5D3 69FF	# <CJK>
E5D4 69EC	# <CJK>
E5D5 69E2	# <CJK>
E5D6 6A1B	# <CJK>
E5D7 6A1D	# <CJK>
E5D8 69FE	# <CJK>
E5D9 6A27	# <CJK>
E5DA 69F2	# <CJK>
E5DB 69EE	# <CJK>
E5DC 6A14	# <CJK>
E5DD 69F7	# <CJK>
E5DE 69E7	# <CJK>
E5DF 6A40	# <CJK>
E5E0 6A08	# <CJK>
E5E1 69E6	# <CJK>
E5E2 69FB	# <CJK>
E5E3 6A0D	# <CJK>
E5E4 69FC	# <CJK>
E5E5 69EB	# <CJK>
E5E6 6A09	# <CJK>
E5E7 6A04	# <CJK>
E5E8 6A18	# <CJK>
E5E9 6A25	# <CJK>
E5EA 6A0F	# <CJK>
E5EB 69F6	# <CJK>
E5EC 6A26	# <CJK>
E5ED 6A07	# <CJK>
E5EE 69F4	# <CJK>
E5EF 6A16	# <CJK>
E5F0 6B51	# <CJK>
E5F1 6BA5	# <CJK>
E5F2 6BA3	# <CJK>
E5F3 6BA2	# <CJK>
E5F4 6BA6	# <CJK>
E5F5 6C01	# <CJK>
E5F6 6C00	# <CJK>
E5F7 6BFF	# <CJK>
E5F8 6C02	# <CJK>
E5F9 6F41	# <CJK>
E5FA 6F26	# <CJK>
E5FB 6F7E	# <CJK>
E5FC 6F87	# <CJK>
E5FD 6FC6	# <CJK>
E5FE 6F92	# <CJK>
E640 6F8D	# <CJK>
E641 6F89	# <CJK>
E642 6F8C	# <CJK>
E643 6F62	# <CJK>
E644 6F4F	# <CJK>
E645 6F85	# <CJK>
E646 6F5A	# <CJK>
E647 6F96	# <CJK>
E648 6F76	# <CJK>
E649 6F6C	# <CJK>
E64A 6F82	# <CJK>
E64B 6F55	# <CJK>
E64C 6F72	# <CJK>
E64D 6F52	# <CJK>
E64E 6F50	# <CJK>
E64F 6F57	# <CJK>
E650 6F94	# <CJK>
E651 6F93	# <CJK>
E652 6F5D	# <CJK>
E653 6F00	# <CJK>
E654 6F61	# <CJK>
E655 6F6B	# <CJK>
E656 6F7D	# <CJK>
E657 6F67	# <CJK>
E658 6F90	# <CJK>
E659 6F53	# <CJK>
E65A 6F8B	# <CJK>
E65B 6F69	# <CJK>
E65C 6F7F	# <CJK>
E65D 6F95	# <CJK>
E65E 6F63	# <CJK>
E65F 6F77	# <CJK>
E660 6F6A	# <CJK>
E661 6F7B	# <CJK>
E662 71B2	# <CJK>
E663 71AF	# <CJK>
E664 719B	# <CJK>
E665 71B0	# <CJK>
E666 71A0	# <CJK>
E667 719A	# <CJK>
E668 71A9	# <CJK>
E669 71B5	# <CJK>
E66A 719D	# <CJK>
E66B 71A5	# <CJK>
E66C 719E	# <CJK>
E66D 71A4	# <CJK>
E66E 71A1	# <CJK>
E66F 71AA	# <CJK>
E670 719C	# <CJK>
E671 71A7	# <CJK>
E672 71B3	# <CJK>
E673 7298	# <CJK>
E674 729A	# <CJK>
E675 7358	# <CJK>
E676 7352	# <CJK>
E677 735E	# <CJK>
E678 735F	# <CJK>
E679 7360	# <CJK>
E67A 735D	# <CJK>
E67B 735B	# <CJK>
E67C 7361	# <CJK>
E67D 735A	# <CJK>
E67E 7359	# <CJK>
E6A1 7362	# <CJK>
E6A2 7487	# <CJK>
E6A3 7489	# <CJK>
E6A4 748A	# <CJK>
E6A5 7486	# <CJK>
E6A6 7481	# <CJK>
E6A7 747D	# <CJK>
E6A8 7485	# <CJK>
E6A9 7488	# <CJK>
E6AA 747C	# <CJK>
E6AB 7479	# <CJK>
E6AC 7508	# <CJK>
E6AD 7507	# <CJK>
E6AE 757E	# <CJK>
E6AF 7625	# <CJK>
E6B0 761E	# <CJK>
E6B1 7619	# <CJK>
E6B2 761D	# <CJK>
E6B3 761C	# <CJK>
E6B4 7623	# <CJK>
E6B5 761A	# <CJK>
E6B6 7628	# <CJK>
E6B7 761B	# <CJK>
E6B8 769C	# <CJK>
E6B9 769D	# <CJK>
E6BA 769E	# <CJK>
E6BB 769B	# <CJK>
E6BC 778D	# <CJK>
E6BD 778F	# <CJK>
E6BE 7789	# <CJK>
E6BF 7788	# <CJK>
E6C0 78CD	# <CJK>
E6C1 78BB	# <CJK>
E6C2 78CF	# <CJK>
E6C3 78CC	# <CJK>
E6C4 78D1	# <CJK>
E6C5 78CE	# <CJK>
E6C6 78D4	# <CJK>
E6C7 78C8	# <CJK>
E6C8 78C3	# <CJK>
E6C9 78C4	# <CJK>
E6CA 78C9	# <CJK>
E6CB 799A	# <CJK>
E6CC 79A1	# <CJK>
E6CD 79A0	# <CJK>
E6CE 799C	# <CJK>
E6CF 79A2	# <CJK>
E6D0 799B	# <CJK>
E6D1 6B76	# <CJK>
E6D2 7A39	# <CJK>
E6D3 7AB2	# <CJK>
E6D4 7AB4	# <CJK>
E6D5 7AB3	# <CJK>
E6D6 7BB7	# <CJK>
E6D7 7BCB	# <CJK>
E6D8 7BBE	# <CJK>
E6D9 7BAC	# <CJK>
E6DA 7BCE	# <CJK>
E6DB 7BAF	# <CJK>
E6DC 7BB9	# <CJK>
E6DD 7BCA	# <CJK>
E6DE 7BB5	# <CJK>
E6DF 7CC5	# <CJK>
E6E0 7CC8	# <CJK>
E6E1 7CCC	# <CJK>
E6E2 7CCB	# <CJK>
E6E3 7DF7	# <CJK>
E6E4 7DDB	# <CJK>
E6E5 7DEA	# <CJK>
E6E6 7DE7	# <CJK>
E6E7 7DD7	# <CJK>
E6E8 7DE1	# <CJK>
E6E9 7E03	# <CJK>
E6EA 7DFA	# <CJK>
E6EB 7DE6	# <CJK>
E6EC 7DF6	# <CJK>
E6ED 7DF1	# <CJK>
E6EE 7DF0	# <CJK>
E6EF 7DEE	# <CJK>
E6F0 7DDF	# <CJK>
E6F1 7F76	# <CJK>
E6F2 7FAC	# <CJK>
E6F3 7FB0	# <CJK>
E6F4 7FAD	# <CJK>
E6F5 7FED	# <CJK>
E6F6 7FEB	# <CJK>
E6F7 7FEA	# <CJK>
E6F8 7FEC	# <CJK>
E6F9 7FE6	# <CJK>
E6FA 7FE8	# <CJK>
E6FB 8064	# <CJK>
E6FC 8067	# <CJK>
E6FD 81A3	# <CJK>
E6FE 819F	# <CJK>
E740 819E	# <CJK>
E741 8195	# <CJK>
E742 81A2	# <CJK>
E743 8199	# <CJK>
E744 8197	# <CJK>
E745 8216	# <CJK>
E746 824F	# <CJK>
E747 8253	# <CJK>
E748 8252	# <CJK>
E749 8250	# <CJK>
E74A 824E	# <CJK>
E74B 8251	# <CJK>
E74C 8524	# <CJK>
E74D 853B	# <CJK>
E74E 850F	# <CJK>
E74F 8500	# <CJK>
E750 8529	# <CJK>
E751 850E	# <CJK>
E752 8509	# <CJK>
E753 850D	# <CJK>
E754 851F	# <CJK>
E755 850A	# <CJK>
E756 8527	# <CJK>
E757 851C	# <CJK>
E758 84FB	# <CJK>
E759 852B	# <CJK>
E75A 84FA	# <CJK>
E75B 8508	# <CJK>
E75C 850C	# <CJK>
E75D 84F4	# <CJK>
E75E 852A	# <CJK>
E75F 84F2	# <CJK>
E760 8515	# <CJK>
E761 84F7	# <CJK>
E762 84EB	# <CJK>
E763 84F3	# <CJK>
E764 84FC	# <CJK>
E765 8512	# <CJK>
E766 84EA	# <CJK>
E767 84E9	# <CJK>
E768 8516	# <CJK>
E769 84FE	# <CJK>
E76A 8528	# <CJK>
E76B 851D	# <CJK>
E76C 852E	# <CJK>
E76D 8502	# <CJK>
E76E 84FD	# <CJK>
E76F 851E	# <CJK>
E770 84F6	# <CJK>
E771 8531	# <CJK>
E772 8526	# <CJK>
E773 84E7	# <CJK>
E774 84E8	# <CJK>
E775 84F0	# <CJK>
E776 84EF	# <CJK>
E777 84F9	# <CJK>
E778 8518	# <CJK>
E779 8520	# <CJK>
E77A 8530	# <CJK>
E77B 850B	# <CJK>
E77C 8519	# <CJK>
E77D 852F	# <CJK>
E77E 8662	# <CJK>
E7A1 8756	# <CJK>
E7A2 8763	# <CJK>
E7A3 8764	# <CJK>
E7A4 8777	# <CJK>
E7A5 87E1	# <CJK>
E7A6 8773	# <CJK>
E7A7 8758	# <CJK>
E7A8 8754	# <CJK>
E7A9 875B	# <CJK>
E7AA 8752	# <CJK>
E7AB 8761	# <CJK>
E7AC 875A	# <CJK>
E7AD 8751	# <CJK>
E7AE 875E	# <CJK>
E7AF 876D	# <CJK>
E7B0 876A	# <CJK>
E7B1 8750	# <CJK>
E7B2 874E	# <CJK>
E7B3 875F	# <CJK>
E7B4 875D	# <CJK>
E7B5 876F	# <CJK>
E7B6 876C	# <CJK>
E7B7 877A	# <CJK>
E7B8 876E	# <CJK>
E7B9 875C	# <CJK>
E7BA 8765	# <CJK>
E7BB 874F	# <CJK>
E7BC 877B	# <CJK>
E7BD 8775	# <CJK>
E7BE 8762	# <CJK>
E7BF 8767	# <CJK>
E7C0 8769	# <CJK>
E7C1 885A	# <CJK>
E7C2 8905	# <CJK>
E7C3 890C	# <CJK>
E7C4 8914	# <CJK>
E7C5 890B	# <CJK>
E7C6 8917	# <CJK>
E7C7 8918	# <CJK>
E7C8 8919	# <CJK>
E7C9 8906	# <CJK>
E7CA 8916	# <CJK>
E7CB 8911	# <CJK>
E7CC 890E	# <CJK>
E7CD 8909	# <CJK>
E7CE 89A2	# <CJK>
E7CF 89A4	# <CJK>
E7D0 89A3	# <CJK>
E7D1 89ED	# <CJK>
E7D2 89F0	# <CJK>
E7D3 89EC	# <CJK>
E7D4 8ACF	# <CJK>
E7D5 8AC6	# <CJK>
E7D6 8AB8	# <CJK>
E7D7 8AD3	# <CJK>
E7D8 8AD1	# <CJK>
E7D9 8AD4	# <CJK>
E7DA 8AD5	# <CJK>
E7DB 8ABB	# <CJK>
E7DC 8AD7	# <CJK>
E7DD 8ABE	# <CJK>
E7DE 8AC0	# <CJK>
E7DF 8AC5	# <CJK>
E7E0 8AD8	# <CJK>
E7E1 8AC3	# <CJK>
E7E2 8ABA	# <CJK>
E7E3 8ABD	# <CJK>
E7E4 8AD9	# <CJK>
E7E5 8C3E	# <CJK>
E7E6 8C4D	# <CJK>
E7E7 8C8F	# <CJK>
E7E8 8CE5	# <CJK>
E7E9 8CDF	# <CJK>
E7EA 8CD9	# <CJK>
E7EB 8CE8	# <CJK>
E7EC 8CDA	# <CJK>
E7ED 8CDD	# <CJK>
E7EE 8CE7	# <CJK>
E7EF 8DA0	# <CJK>
E7F0 8D9C	# <CJK>
E7F1 8DA1	# <CJK>
E7F2 8D9B	# <CJK>
E7F3 8E20	# <CJK>
E7F4 8E23	# <CJK>
E7F5 8E25	# <CJK>
E7F6 8E24	# <CJK>
E7F7 8E2E	# <CJK>
E7F8 8E15	# <CJK>
E7F9 8E1B	# <CJK>
E7FA 8E16	# <CJK>
E7FB 8E11	# <CJK>
E7FC 8E19	# <CJK>
E7FD 8E26	# <CJK>
E7FE 8E27	# <CJK>
E840 8E14	# <CJK>
E841 8E12	# <CJK>
E842 8E18	# <CJK>
E843 8E13	# <CJK>
E844 8E1C	# <CJK>
E845 8E17	# <CJK>
E846 8E1A	# <CJK>
E847 8F2C	# <CJK>
E848 8F24	# <CJK>
E849 8F18	# <CJK>
E84A 8F1A	# <CJK>
E84B 8F20	# <CJK>
E84C 8F23	# <CJK>
E84D 8F16	# <CJK>
E84E 8F17	# <CJK>
E84F 9073	# <CJK>
E850 9070	# <CJK>
E851 906F	# <CJK>
E852 9067	# <CJK>
E853 906B	# <CJK>
E854 912F	# <CJK>
E855 912B	# <CJK>
E856 9129	# <CJK>
E857 912A	# <CJK>
E858 9132	# <CJK>
E859 9126	# <CJK>
E85A 912E	# <CJK>
E85B 9185	# <CJK>
E85C 9186	# <CJK>
E85D 918A	# <CJK>
E85E 9181	# <CJK>
E85F 9182	# <CJK>
E860 9184	# <CJK>
E861 9180	# <CJK>
E862 92D0	# <CJK>
E863 92C3	# <CJK>
E864 92C4	# <CJK>
E865 92C0	# <CJK>
E866 92D9	# <CJK>
E867 92B6	# <CJK>
E868 92CF	# <CJK>
E869 92F1	# <CJK>
E86A 92DF	# <CJK>
E86B 92D8	# <CJK>
E86C 92E9	# <CJK>
E86D 92D7	# <CJK>
E86E 92DD	# <CJK>
E86F 92CC	# <CJK>
E870 92EF	# <CJK>
E871 92C2	# <CJK>
E872 92E8	# <CJK>
E873 92CA	# <CJK>
E874 92C8	# <CJK>
E875 92CE	# <CJK>
E876 92E6	# <CJK>
E877 92CD	# <CJK>
E878 92D5	# <CJK>
E879 92C9	# <CJK>
E87A 92E0	# <CJK>
E87B 92DE	# <CJK>
E87C 92E7	# <CJK>
E87D 92D1	# <CJK>
E87E 92D3	# <CJK>
E8A1 92B5	# <CJK>
E8A2 92E1	# <CJK>
E8A3 92C6	# <CJK>
E8A4 92B4	# <CJK>
E8A5 957C	# <CJK>
E8A6 95AC	# <CJK>
E8A7 95AB	# <CJK>
E8A8 95AE	# <CJK>
E8A9 95B0	# <CJK>
E8AA 96A4	# <CJK>
E8AB 96A2	# <CJK>
E8AC 96D3	# <CJK>
E8AD 9705	# <CJK>
E8AE 9708	# <CJK>
E8AF 9702	# <CJK>
E8B0 975A	# <CJK>
E8B1 978A	# <CJK>
E8B2 978E	# <CJK>
E8B3 9788	# <CJK>
E8B4 97D0	# <CJK>
E8B5 97CF	# <CJK>
E8B6 981E	# <CJK>
E8B7 981D	# <CJK>
E8B8 9826	# <CJK>
E8B9 9829	# <CJK>
E8BA 9828	# <CJK>
E8BB 9820	# <CJK>
E8BC 981B	# <CJK>
E8BD 9827	# <CJK>
E8BE 98B2	# <CJK>
E8BF 9908	# <CJK>
E8C0 98FA	# <CJK>
E8C1 9911	# <CJK>
E8C2 9914	# <CJK>
E8C3 9916	# <CJK>
E8C4 9917	# <CJK>
E8C5 9915	# <CJK>
E8C6 99DC	# <CJK>
E8C7 99CD	# <CJK>
E8C8 99CF	# <CJK>
E8C9 99D3	# <CJK>
E8CA 99D4	# <CJK>
E8CB 99CE	# <CJK>
E8CC 99C9	# <CJK>
E8CD 99D6	# <CJK>
E8CE 99D8	# <CJK>
E8CF 99CB	# <CJK>
E8D0 99D7	# <CJK>
E8D1 99CC	# <CJK>
E8D2 9AB3	# <CJK>
E8D3 9AEC	# <CJK>
E8D4 9AEB	# <CJK>
E8D5 9AF3	# <CJK>
E8D6 9AF2	# <CJK>
E8D7 9AF1	# <CJK>
E8D8 9B46	# <CJK>
E8D9 9B43	# <CJK>
E8DA 9B67	# <CJK>
E8DB 9B74	# <CJK>
E8DC 9B71	# <CJK>
E8DD 9B66	# <CJK>
E8DE 9B76	# <CJK>
E8DF 9B75	# <CJK>
E8E0 9B70	# <CJK>
E8E1 9B68	# <CJK>
E8E2 9B64	# <CJK>
E8E3 9B6C	# <CJK>
E8E4 9CFC	# <CJK>
E8E5 9CFA	# <CJK>
E8E6 9CFD	# <CJK>
E8E7 9CFF	# <CJK>
E8E8 9CF7	# <CJK>
E8E9 9D07	# <CJK>
E8EA 9D00	# <CJK>
E8EB 9CF9	# <CJK>
E8EC 9CFB	# <CJK>
E8ED 9D08	# <CJK>
E8EE 9D05	# <CJK>
E8EF 9D04	# <CJK>
E8F0 9E83	# <CJK>
E8F1 9ED3	# <CJK>
E8F2 9F0F	# <CJK>
E8F3 9F10	# <CJK>
E8F4 511C	# <CJK>
E8F5 5113	# <CJK>
E8F6 5117	# <CJK>
E8F7 511A	# <CJK>
E8F8 5111	# <CJK>
E8F9 51DE	# <CJK>
E8FA 5334	# <CJK>
E8FB 53E1	# <CJK>
E8FC 5670	# <CJK>
E8FD 5660	# <CJK>
E8FE 566E	# <CJK>
E940 5673	# <CJK>
E941 5666	# <CJK>
E942 5663	# <CJK>
E943 566D	# <CJK>
E944 5672	# <CJK>
E945 565E	# <CJK>
E946 5677	# <CJK>
E947 571C	# <CJK>
E948 571B	# <CJK>
E949 58C8	# <CJK>
E94A 58BD	# <CJK>
E94B 58C9	# <CJK>
E94C 58BF	# <CJK>
E94D 58BA	# <CJK>
E94E 58C2	# <CJK>
E94F 58BC	# <CJK>
E950 58C6	# <CJK>
E951 5B17	# <CJK>
E952 5B19	# <CJK>
E953 5B1B	# <CJK>
E954 5B21	# <CJK>
E955 5B14	# <CJK>
E956 5B13	# <CJK>
E957 5B10	# <CJK>
E958 5B16	# <CJK>
E959 5B28	# <CJK>
E95A 5B1A	# <CJK>
E95B 5B20	# <CJK>
E95C 5B1E	# <CJK>
E95D 5BEF	# <CJK>
E95E 5DAC	# <CJK>
E95F 5DB1	# <CJK>
E960 5DA9	# <CJK>
E961 5DA7	# <CJK>
E962 5DB5	# <CJK>
E963 5DB0	# <CJK>
E964 5DAE	# <CJK>
E965 5DAA	# <CJK>
E966 5DA8	# <CJK>
E967 5DB2	# <CJK>
E968 5DAD	# <CJK>
E969 5DAF	# <CJK>
E96A 5DB4	# <CJK>
E96B 5E67	# <CJK>
E96C 5E68	# <CJK>
E96D 5E66	# <CJK>
E96E 5E6F	# <CJK>
E96F 5EE9	# <CJK>
E970 5EE7	# <CJK>
E971 5EE6	# <CJK>
E972 5EE8	# <CJK>
E973 5EE5	# <CJK>
E974 5F4B	# <CJK>
E975 5FBC	# <CJK>
E976 619D	# <CJK>
E977 61A8	# <CJK>
E978 6196	# <CJK>
E979 61C5	# <CJK>
E97A 61B4	# <CJK>
E97B 61C6	# <CJK>
E97C 61C1	# <CJK>
E97D 61CC	# <CJK>
E97E 61BA	# <CJK>
E9A1 61BF	# <CJK>
E9A2 61B8	# <CJK>
E9A3 618C	# <CJK>
E9A4 64D7	# <CJK>
E9A5 64D6	# <CJK>
E9A6 64D0	# <CJK>
E9A7 64CF	# <CJK>
E9A8 64C9	# <CJK>
E9A9 64BD	# <CJK>
E9AA 6489	# <CJK>
E9AB 64C3	# <CJK>
E9AC 64DB	# <CJK>
E9AD 64F3	# <CJK>
E9AE 64D9	# <CJK>
E9AF 6533	# <CJK>
E9B0 657F	# <CJK>
E9B1 657C	# <CJK>
E9B2 65A2	# <CJK>
E9B3 66C8	# <CJK>
E9B4 66BE	# <CJK>
E9B5 66C0	# <CJK>
E9B6 66CA	# <CJK>
E9B7 66CB	# <CJK>
E9B8 66CF	# <CJK>
E9B9 66BD	# <CJK>
E9BA 66BB	# <CJK>
E9BB 66BA	# <CJK>
E9BC 66CC	# <CJK>
E9BD 6723	# <CJK>
E9BE 6A34	# <CJK>
E9BF 6A66	# <CJK>
E9C0 6A49	# <CJK>
E9C1 6A67	# <CJK>
E9C2 6A32	# <CJK>
E9C3 6A68	# <CJK>
E9C4 6A3E	# <CJK>
E9C5 6A5D	# <CJK>
E9C6 6A6D	# <CJK>
E9C7 6A76	# <CJK>
E9C8 6A5B	# <CJK>
E9C9 6A51	# <CJK>
E9CA 6A28	# <CJK>
E9CB 6A5A	# <CJK>
E9CC 6A3B	# <CJK>
E9CD 6A3F	# <CJK>
E9CE 6A41	# <CJK>
E9CF 6A6A	# <CJK>
E9D0 6A64	# <CJK>
E9D1 6A50	# <CJK>
E9D2 6A4F	# <CJK>
E9D3 6A54	# <CJK>
E9D4 6A6F	# <CJK>
E9D5 6A69	# <CJK>
E9D6 6A60	# <CJK>
E9D7 6A3C	# <CJK>
E9D8 6A5E	# <CJK>
E9D9 6A56	# <CJK>
E9DA 6A55	# <CJK>
E9DB 6A4D	# <CJK>
E9DC 6A4E	# <CJK>
E9DD 6A46	# <CJK>
E9DE 6B55	# <CJK>
E9DF 6B54	# <CJK>
E9E0 6B56	# <CJK>
E9E1 6BA7	# <CJK>
E9E2 6BAA	# <CJK>
E9E3 6BAB	# <CJK>
E9E4 6BC8	# <CJK>
E9E5 6BC7	# <CJK>
E9E6 6C04	# <CJK>
E9E7 6C03	# <CJK>
E9E8 6C06	# <CJK>
E9E9 6FAD	# <CJK>
E9EA 6FCB	# <CJK>
E9EB 6FA3	# <CJK>
E9EC 6FC7	# <CJK>
E9ED 6FBC	# <CJK>
E9EE 6FCE	# <CJK>
E9EF 6FC8	# <CJK>
E9F0 6F5E	# <CJK>
E9F1 6FC4	# <CJK>
E9F2 6FBD	# <CJK>
E9F3 6F9E	# <CJK>
E9F4 6FCA	# <CJK>
E9F5 6FA8	# <CJK>
E9F6 7004	# <CJK>
E9F7 6FA5	# <CJK>
E9F8 6FAE	# <CJK>
E9F9 6FBA	# <CJK>
E9FA 6FAC	# <CJK>
E9FB 6FAA	# <CJK>
E9FC 6FCF	# <CJK>
E9FD 6FBF	# <CJK>
E9FE 6FB8	# <CJK>
EA40 6FA2	# <CJK>
EA41 6FC9	# <CJK>
EA42 6FAB	# <CJK>
EA43 6FCD	# <CJK>
EA44 6FAF	# <CJK>
EA45 6FB2	# <CJK>
EA46 6FB0	# <CJK>
EA47 71C5	# <CJK>
EA48 71C2	# <CJK>
EA49 71BF	# <CJK>
EA4A 71B8	# <CJK>
EA4B 71D6	# <CJK>
EA4C 71C0	# <CJK>
EA4D 71C1	# <CJK>
EA4E 71CB	# <CJK>
EA4F 71D4	# <CJK>
EA50 71CA	# <CJK>
EA51 71C7	# <CJK>
EA52 71CF	# <CJK>
EA53 71BD	# <CJK>
EA54 71D8	# <CJK>
EA55 71BC	# <CJK>
EA56 71C6	# <CJK>
EA57 71DA	# <CJK>
EA58 71DB	# <CJK>
EA59 729D	# <CJK>
EA5A 729E	# <CJK>
EA5B 7369	# <CJK>
EA5C 7366	# <CJK>
EA5D 7367	# <CJK>
EA5E 736C	# <CJK>
EA5F 7365	# <CJK>
EA60 736B	# <CJK>
EA61 736A	# <CJK>
EA62 747F	# <CJK>
EA63 749A	# <CJK>
EA64 74A0	# <CJK>
EA65 7494	# <CJK>
EA66 7492	# <CJK>
EA67 7495	# <CJK>
EA68 74A1	# <CJK>
EA69 750B	# <CJK>
EA6A 7580	# <CJK>
EA6B 762F	# <CJK>
EA6C 762D	# <CJK>
EA6D 7631	# <CJK>
EA6E 763D	# <CJK>
EA6F 7633	# <CJK>
EA70 763C	# <CJK>
EA71 7635	# <CJK>
EA72 7632	# <CJK>
EA73 7630	# <CJK>
EA74 76BB	# <CJK>
EA75 76E6	# <CJK>
EA76 779A	# <CJK>
EA77 779D	# <CJK>
EA78 77A1	# <CJK>
EA79 779C	# <CJK>
EA7A 779B	# <CJK>
EA7B 77A2	# <CJK>
EA7C 77A3	# <CJK>
EA7D 7795	# <CJK>
EA7E 7799	# <CJK>
EAA1 7797	# <CJK>
EAA2 78DD	# <CJK>
EAA3 78E9	# <CJK>
EAA4 78E5	# <CJK>
EAA5 78EA	# <CJK>
EAA6 78DE	# <CJK>
EAA7 78E3	# <CJK>
EAA8 78DB	# <CJK>
EAA9 78E1	# <CJK>
EAAA 78E2	# <CJK>
EAAB 78ED	# <CJK>
EAAC 78DF	# <CJK>
EAAD 78E0	# <CJK>
EAAE 79A4	# <CJK>
EAAF 7A44	# <CJK>
EAB0 7A48	# <CJK>
EAB1 7A47	# <CJK>
EAB2 7AB6	# <CJK>
EAB3 7AB8	# <CJK>
EAB4 7AB5	# <CJK>
EAB5 7AB1	# <CJK>
EAB6 7AB7	# <CJK>
EAB7 7BDE	# <CJK>
EAB8 7BE3	# <CJK>
EAB9 7BE7	# <CJK>
EABA 7BDD	# <CJK>
EABB 7BD5	# <CJK>
EABC 7BE5	# <CJK>
EABD 7BDA	# <CJK>
EABE 7BE8	# <CJK>
EABF 7BF9	# <CJK>
EAC0 7BD4	# <CJK>
EAC1 7BEA	# <CJK>
EAC2 7BE2	# <CJK>
EAC3 7BDC	# <CJK>
EAC4 7BEB	# <CJK>
EAC5 7BD8	# <CJK>
EAC6 7BDF	# <CJK>
EAC7 7CD2	# <CJK>
EAC8 7CD4	# <CJK>
EAC9 7CD7	# <CJK>
EACA 7CD0	# <CJK>
EACB 7CD1	# <CJK>
EACC 7E12	# <CJK>
EACD 7E21	# <CJK>
EACE 7E17	# <CJK>
EACF 7E0C	# <CJK>
EAD0 7E1F	# <CJK>
EAD1 7E20	# <CJK>
EAD2 7E13	# <CJK>
EAD3 7E0E	# <CJK>
EAD4 7E1C	# <CJK>
EAD5 7E15	# <CJK>
EAD6 7E1A	# <CJK>
EAD7 7E22	# <CJK>
EAD8 7E0B	# <CJK>
EAD9 7E0F	# <CJK>
EADA 7E16	# <CJK>
EADB 7E0D	# <CJK>
EADC 7E14	# <CJK>
EADD 7E25	# <CJK>
EADE 7E24	# <CJK>
EADF 7F43	# <CJK>
EAE0 7F7B	# <CJK>
EAE1 7F7C	# <CJK>
EAE2 7F7A	# <CJK>
EAE3 7FB1	# <CJK>
EAE4 7FEF	# <CJK>
EAE5 802A	# <CJK>
EAE6 8029	# <CJK>
EAE7 806C	# <CJK>
EAE8 81B1	# <CJK>
EAE9 81A6	# <CJK>
EAEA 81AE	# <CJK>
EAEB 81B9	# <CJK>
EAEC 81B5	# <CJK>
EAED 81AB	# <CJK>
EAEE 81B0	# <CJK>
EAEF 81AC	# <CJK>
EAF0 81B4	# <CJK>
EAF1 81B2	# <CJK>
EAF2 81B7	# <CJK>
EAF3 81A7	# <CJK>
EAF4 81F2	# <CJK>
EAF5 8255	# <CJK>
EAF6 8256	# <CJK>
EAF7 8257	# <CJK>
EAF8 8556	# <CJK>
EAF9 8545	# <CJK>
EAFA 856B	# <CJK>
EAFB 854D	# <CJK>
EAFC 8553	# <CJK>
EAFD 8561	# <CJK>
EAFE 8558	# <CJK>
EB40 8540	# <CJK>
EB41 8546	# <CJK>
EB42 8564	# <CJK>
EB43 8541	# <CJK>
EB44 8562	# <CJK>
EB45 8544	# <CJK>
EB46 8551	# <CJK>
EB47 8547	# <CJK>
EB48 8563	# <CJK>
EB49 853E	# <CJK>
EB4A 855B	# <CJK>
EB4B 8571	# <CJK>
EB4C 854E	# <CJK>
EB4D 856E	# <CJK>
EB4E 8575	# <CJK>
EB4F 8555	# <CJK>
EB50 8567	# <CJK>
EB51 8560	# <CJK>
EB52 858C	# <CJK>
EB53 8566	# <CJK>
EB54 855D	# <CJK>
EB55 8554	# <CJK>
EB56 8565	# <CJK>
EB57 856C	# <CJK>
EB58 8663	# <CJK>
EB59 8665	# <CJK>
EB5A 8664	# <CJK>
EB5B 879B	# <CJK>
EB5C 878F	# <CJK>
EB5D 8797	# <CJK>
EB5E 8793	# <CJK>
EB5F 8792	# <CJK>
EB60 8788	# <CJK>
EB61 8781	# <CJK>
EB62 8796	# <CJK>
EB63 8798	# <CJK>
EB64 8779	# <CJK>
EB65 8787	# <CJK>
EB66 87A3	# <CJK>
EB67 8785	# <CJK>
EB68 8790	# <CJK>
EB69 8791	# <CJK>
EB6A 879D	# <CJK>
EB6B 8784	# <CJK>
EB6C 8794	# <CJK>
EB6D 879C	# <CJK>
EB6E 879A	# <CJK>
EB6F 8789	# <CJK>
EB70 891E	# <CJK>
EB71 8926	# <CJK>
EB72 8930	# <CJK>
EB73 892D	# <CJK>
EB74 892E	# <CJK>
EB75 8927	# <CJK>
EB76 8931	# <CJK>
EB77 8922	# <CJK>
EB78 8929	# <CJK>
EB79 8923	# <CJK>
EB7A 892F	# <CJK>
EB7B 892C	# <CJK>
EB7C 891F	# <CJK>
EB7D 89F1	# <CJK>
EB7E 8AE0	# <CJK>
EBA1 8AE2	# <CJK>
EBA2 8AF2	# <CJK>
EBA3 8AF4	# <CJK>
EBA4 8AF5	# <CJK>
EBA5 8ADD	# <CJK>
EBA6 8B14	# <CJK>
EBA7 8AE4	# <CJK>
EBA8 8ADF	# <CJK>
EBA9 8AF0	# <CJK>
EBAA 8AC8	# <CJK>
EBAB 8ADE	# <CJK>
EBAC 8AE1	# <CJK>
EBAD 8AE8	# <CJK>
EBAE 8AFF	# <CJK>
EBAF 8AEF	# <CJK>
EBB0 8AFB	# <CJK>
EBB1 8C91	# <CJK>
EBB2 8C92	# <CJK>
EBB3 8C90	# <CJK>
EBB4 8CF5	# <CJK>
EBB5 8CEE	# <CJK>
EBB6 8CF1	# <CJK>
EBB7 8CF0	# <CJK>
EBB8 8CF3	# <CJK>
EBB9 8D6C	# <CJK>
EBBA 8D6E	# <CJK>
EBBB 8DA5	# <CJK>
EBBC 8DA7	# <CJK>
EBBD 8E33	# <CJK>
EBBE 8E3E	# <CJK>
EBBF 8E38	# <CJK>
EBC0 8E40	# <CJK>
EBC1 8E45	# <CJK>
EBC2 8E36	# <CJK>
EBC3 8E3C	# <CJK>
EBC4 8E3D	# <CJK>
EBC5 8E41	# <CJK>
EBC6 8E30	# <CJK>
EBC7 8E3F	# <CJK>
EBC8 8EBD	# <CJK>
EBC9 8F36	# <CJK>
EBCA 8F2E	# <CJK>
EBCB 8F35	# <CJK>
EBCC 8F32	# <CJK>
EBCD 8F39	# <CJK>
EBCE 8F37	# <CJK>
EBCF 8F34	# <CJK>
EBD0 9076	# <CJK>
EBD1 9079	# <CJK>
EBD2 907B	# <CJK>
EBD3 9086	# <CJK>
EBD4 90FA	# <CJK>
EBD5 9133	# <CJK>
EBD6 9135	# <CJK>
EBD7 9136	# <CJK>
EBD8 9193	# <CJK>
EBD9 9190	# <CJK>
EBDA 9191	# <CJK>
EBDB 918D	# <CJK>
EBDC 918F	# <CJK>
EBDD 9327	# <CJK>
EBDE 931E	# <CJK>
EBDF 9308	# <CJK>
EBE0 931F	# <CJK>
EBE1 9306	# <CJK>
EBE2 930F	# <CJK>
EBE3 937A	# <CJK>
EBE4 9338	# <CJK>
EBE5 933C	# <CJK>
EBE6 931B	# <CJK>
EBE7 9323	# <CJK>
EBE8 9312	# <CJK>
EBE9 9301	# <CJK>
EBEA 9346	# <CJK>
EBEB 932D	# <CJK>
EBEC 930E	# <CJK>
EBED 930D	# <CJK>
EBEE 92CB	# <CJK>
EBEF 931D	# <CJK>
EBF0 92FA	# <CJK>
EBF1 9325	# <CJK>
EBF2 9313	# <CJK>
EBF3 92F9	# <CJK>
EBF4 92F7	# <CJK>
EBF5 9334	# <CJK>
EBF6 9302	# <CJK>
EBF7 9324	# <CJK>
EBF8 92FF	# <CJK>
EBF9 9329	# <CJK>
EBFA 9339	# <CJK>
EBFB 9335	# <CJK>
EBFC 932A	# <CJK>
EBFD 9314	# <CJK>
EBFE 930C	# <CJK>
EC40 930B	# <CJK>
EC41 92FE	# <CJK>
EC42 9309	# <CJK>
EC43 9300	# <CJK>
EC44 92FB	# <CJK>
EC45 9316	# <CJK>
EC46 95BC	# <CJK>
EC47 95CD	# <CJK>
EC48 95BE	# <CJK>
EC49 95B9	# <CJK>
EC4A 95BA	# <CJK>
EC4B 95B6	# <CJK>
EC4C 95BF	# <CJK>
EC4D 95B5	# <CJK>
EC4E 95BD	# <CJK>
EC4F 96A9	# <CJK>
EC50 96D4	# <CJK>
EC51 970B	# <CJK>
EC52 9712	# <CJK>
EC53 9710	# <CJK>
EC54 9799	# <CJK>
EC55 9797	# <CJK>
EC56 9794	# <CJK>
EC57 97F0	# <CJK>
EC58 97F8	# <CJK>
EC59 9835	# <CJK>
EC5A 982F	# <CJK>
EC5B 9832	# <CJK>
EC5C 9924	# <CJK>
EC5D 991F	# <CJK>
EC5E 9927	# <CJK>
EC5F 9929	# <CJK>
EC60 999E	# <CJK>
EC61 99EE	# <CJK>
EC62 99EC	# <CJK>
EC63 99E5	# <CJK>
EC64 99E4	# <CJK>
EC65 99F0	# <CJK>
EC66 99E3	# <CJK>
EC67 99EA	# <CJK>
EC68 99E9	# <CJK>
EC69 99E7	# <CJK>
EC6A 9AB9	# <CJK>
EC6B 9ABF	# <CJK>
EC6C 9AB4	# <CJK>
EC6D 9ABB	# <CJK>
EC6E 9AF6	# <CJK>
EC6F 9AFA	# <CJK>
EC70 9AF9	# <CJK>
EC71 9AF7	# <CJK>
EC72 9B33	# <CJK>
EC73 9B80	# <CJK>
EC74 9B85	# <CJK>
EC75 9B87	# <CJK>
EC76 9B7C	# <CJK>
EC77 9B7E	# <CJK>
EC78 9B7B	# <CJK>
EC79 9B82	# <CJK>
EC7A 9B93	# <CJK>
EC7B 9B92	# <CJK>
EC7C 9B90	# <CJK>
EC7D 9B7A	# <CJK>
EC7E 9B95	# <CJK>
ECA1 9B7D	# <CJK>
ECA2 9B88	# <CJK>
ECA3 9D25	# <CJK>
ECA4 9D17	# <CJK>
ECA5 9D20	# <CJK>
ECA6 9D1E	# <CJK>
ECA7 9D14	# <CJK>
ECA8 9D29	# <CJK>
ECA9 9D1D	# <CJK>
ECAA 9D18	# <CJK>
ECAB 9D22	# <CJK>
ECAC 9D10	# <CJK>
ECAD 9D19	# <CJK>
ECAE 9D1F	# <CJK>
ECAF 9E88	# <CJK>
ECB0 9E86	# <CJK>
ECB1 9E87	# <CJK>
ECB2 9EAE	# <CJK>
ECB3 9EAD	# <CJK>
ECB4 9ED5	# <CJK>
ECB5 9ED6	# <CJK>
ECB6 9EFA	# <CJK>
ECB7 9F12	# <CJK>
ECB8 9F3D	# <CJK>
ECB9 5126	# <CJK>
ECBA 5125	# <CJK>
ECBB 5122	# <CJK>
ECBC 5124	# <CJK>
ECBD 5120	# <CJK>
ECBE 5129	# <CJK>
ECBF 52F4	# <CJK>
ECC0 5693	# <CJK>
ECC1 568C	# <CJK>
ECC2 568D	# <CJK>
ECC3 5686	# <CJK>
ECC4 5684	# <CJK>
ECC5 5683	# <CJK>
ECC6 567E	# <CJK>
ECC7 5682	# <CJK>
ECC8 567F	# <CJK>
ECC9 5681	# <CJK>
ECCA 58D6	# <CJK>
ECCB 58D4	# <CJK>
ECCC 58CF	# <CJK>
ECCD 58D2	# <CJK>
ECCE 5B2D	# <CJK>
ECCF 5B25	# <CJK>
ECD0 5B32	# <CJK>
ECD1 5B23	# <CJK>
ECD2 5B2C	# <CJK>
ECD3 5B27	# <CJK>
ECD4 5B26	# <CJK>
ECD5 5B2F	# <CJK>
ECD6 5B2E	# <CJK>
ECD7 5B7B	# <CJK>
ECD8 5BF1	# <CJK>
ECD9 5BF2	# <CJK>
ECDA 5DB7	# <CJK>
ECDB 5E6C	# <CJK>
ECDC 5E6A	# <CJK>
ECDD 5FBE	# <CJK>
ECDE 5FBB	# <CJK>
ECDF 61C3	# <CJK>
ECE0 61B5	# <CJK>
ECE1 61BC	# <CJK>
ECE2 61E7	# <CJK>
ECE3 61E0	# <CJK>
ECE4 61E5	# <CJK>
ECE5 61E4	# <CJK>
ECE6 61E8	# <CJK>
ECE7 61DE	# <CJK>
ECE8 64EF	# <CJK>
ECE9 64E9	# <CJK>
ECEA 64E3	# <CJK>
ECEB 64EB	# <CJK>
ECEC 64E4	# <CJK>
ECED 64E8	# <CJK>
ECEE 6581	# <CJK>
ECEF 6580	# <CJK>
ECF0 65B6	# <CJK>
ECF1 65DA	# <CJK>
ECF2 66D2	# <CJK>
ECF3 6A8D	# <CJK>
ECF4 6A96	# <CJK>
ECF5 6A81	# <CJK>
ECF6 6AA5	# <CJK>
ECF7 6A89	# <CJK>
ECF8 6A9F	# <CJK>
ECF9 6A9B	# <CJK>
ECFA 6AA1	# <CJK>
ECFB 6A9E	# <CJK>
ECFC 6A87	# <CJK>
ECFD 6A93	# <CJK>
ECFE 6A8E	# <CJK>
ED40 6A95	# <CJK>
ED41 6A83	# <CJK>
ED42 6AA8	# <CJK>
ED43 6AA4	# <CJK>
ED44 6A91	# <CJK>
ED45 6A7F	# <CJK>
ED46 6AA6	# <CJK>
ED47 6A9A	# <CJK>
ED48 6A85	# <CJK>
ED49 6A8C	# <CJK>
ED4A 6A92	# <CJK>
ED4B 6B5B	# <CJK>
ED4C 6BAD	# <CJK>
ED4D 6C09	# <CJK>
ED4E 6FCC	# <CJK>
ED4F 6FA9	# <CJK>
ED50 6FF4	# <CJK>
ED51 6FD4	# <CJK>
ED52 6FE3	# <CJK>
ED53 6FDC	# <CJK>
ED54 6FED	# <CJK>
ED55 6FE7	# <CJK>
ED56 6FE6	# <CJK>
ED57 6FDE	# <CJK>
ED58 6FF2	# <CJK>
ED59 6FDD	# <CJK>
ED5A 6FE2	# <CJK>
ED5B 6FE8	# <CJK>
ED5C 71E1	# <CJK>
ED5D 71F1	# <CJK>
ED5E 71E8	# <CJK>
ED5F 71F2	# <CJK>
ED60 71E4	# <CJK>
ED61 71F0	# <CJK>
ED62 71E2	# <CJK>
ED63 7373	# <CJK>
ED64 736E	# <CJK>
ED65 736F	# <CJK>
ED66 7497	# <CJK>
ED67 74B2	# <CJK>
ED68 74AB	# <CJK>
ED69 7490	# <CJK>
ED6A 74AA	# <CJK>
ED6B 74AD	# <CJK>
ED6C 74B1	# <CJK>
ED6D 74A5	# <CJK>
ED6E 74AF	# <CJK>
ED6F 7510	# <CJK>
ED70 7511	# <CJK>
ED71 7512	# <CJK>
ED72 750F	# <CJK>
ED73 7584	# <CJK>
ED74 7643	# <CJK>
ED75 7648	# <CJK>
ED76 7649	# <CJK>
ED77 7647	# <CJK>
ED78 76A4	# <CJK>
ED79 76E9	# <CJK>
ED7A 77B5	# <CJK>
ED7B 77AB	# <CJK>
ED7C 77B2	# <CJK>
ED7D 77B7	# <CJK>
ED7E 77B6	# <CJK>
EDA1 77B4	# <CJK>
EDA2 77B1	# <CJK>
EDA3 77A8	# <CJK>
EDA4 77F0	# <CJK>
EDA5 78F3	# <CJK>
EDA6 78FD	# <CJK>
EDA7 7902	# <CJK>
EDA8 78FB	# <CJK>
EDA9 78FC	# <CJK>
EDAA 78F2	# <CJK>
EDAB 7905	# <CJK>
EDAC 78F9	# <CJK>
EDAD 78FE	# <CJK>
EDAE 7904	# <CJK>
EDAF 79AB	# <CJK>
EDB0 79A8	# <CJK>
EDB1 7A5C	# <CJK>
EDB2 7A5B	# <CJK>
EDB3 7A56	# <CJK>
EDB4 7A58	# <CJK>
EDB5 7A54	# <CJK>
EDB6 7A5A	# <CJK>
EDB7 7ABE	# <CJK>
EDB8 7AC0	# <CJK>
EDB9 7AC1	# <CJK>
EDBA 7C05	# <CJK>
EDBB 7C0F	# <CJK>
EDBC 7BF2	# <CJK>
EDBD 7C00	# <CJK>
EDBE 7BFF	# <CJK>
EDBF 7BFB	# <CJK>
EDC0 7C0E	# <CJK>
EDC1 7BF4	# <CJK>
EDC2 7C0B	# <CJK>
EDC3 7BF3	# <CJK>
EDC4 7C02	# <CJK>
EDC5 7C09	# <CJK>
EDC6 7C03	# <CJK>
EDC7 7C01	# <CJK>
EDC8 7BF8	# <CJK>
EDC9 7BFD	# <CJK>
EDCA 7C06	# <CJK>
EDCB 7BF0	# <CJK>
EDCC 7BF1	# <CJK>
EDCD 7C10	# <CJK>
EDCE 7C0A	# <CJK>
EDCF 7CE8	# <CJK>
EDD0 7E2D	# <CJK>
EDD1 7E3C	# <CJK>
EDD2 7E42	# <CJK>
EDD3 7E33	# <CJK>
EDD4 9848	# <CJK>
EDD5 7E38	# <CJK>
EDD6 7E2A	# <CJK>
EDD7 7E49	# <CJK>
EDD8 7E40	# <CJK>
EDD9 7E47	# <CJK>
EDDA 7E29	# <CJK>
EDDB 7E4C	# <CJK>
EDDC 7E30	# <CJK>
EDDD 7E3B	# <CJK>
EDDE 7E36	# <CJK>
EDDF 7E44	# <CJK>
EDE0 7E3A	# <CJK>
EDE1 7F45	# <CJK>
EDE2 7F7F	# <CJK>
EDE3 7F7E	# <CJK>
EDE4 7F7D	# <CJK>
EDE5 7FF4	# <CJK>
EDE6 7FF2	# <CJK>
EDE7 802C	# <CJK>
EDE8 81BB	# <CJK>
EDE9 81C4	# <CJK>
EDEA 81CC	# <CJK>
EDEB 81CA	# <CJK>
EDEC 81C5	# <CJK>
EDED 81C7	# <CJK>
EDEE 81BC	# <CJK>
EDEF 81E9	# <CJK>
EDF0 825B	# <CJK>
EDF1 825A	# <CJK>
EDF2 825C	# <CJK>
EDF3 8583	# <CJK>
EDF4 8580	# <CJK>
EDF5 858F	# <CJK>
EDF6 85A7	# <CJK>
EDF7 8595	# <CJK>
EDF8 85A0	# <CJK>
EDF9 858B	# <CJK>
EDFA 85A3	# <CJK>
EDFB 857B	# <CJK>
EDFC 85A4	# <CJK>
EDFD 859A	# <CJK>
EDFE 859E	# <CJK>
EE40 8577	# <CJK>
EE41 857C	# <CJK>
EE42 8589	# <CJK>
EE43 85A1	# <CJK>
EE44 857A	# <CJK>
EE45 8578	# <CJK>
EE46 8557	# <CJK>
EE47 858E	# <CJK>
EE48 8596	# <CJK>
EE49 8586	# <CJK>
EE4A 858D	# <CJK>
EE4B 8599	# <CJK>
EE4C 859D	# <CJK>
EE4D 8581	# <CJK>
EE4E 85A2	# <CJK>
EE4F 8582	# <CJK>
EE50 8588	# <CJK>
EE51 8585	# <CJK>
EE52 8579	# <CJK>
EE53 8576	# <CJK>
EE54 8598	# <CJK>
EE55 8590	# <CJK>
EE56 859F	# <CJK>
EE57 8668	# <CJK>
EE58 87BE	# <CJK>
EE59 87AA	# <CJK>
EE5A 87AD	# <CJK>
EE5B 87C5	# <CJK>
EE5C 87B0	# <CJK>
EE5D 87AC	# <CJK>
EE5E 87B9	# <CJK>
EE5F 87B5	# <CJK>
EE60 87BC	# <CJK>
EE61 87AE	# <CJK>
EE62 87C9	# <CJK>
EE63 87C3	# <CJK>
EE64 87C2	# <CJK>
EE65 87CC	# <CJK>
EE66 87B7	# <CJK>
EE67 87AF	# <CJK>
EE68 87C4	# <CJK>
EE69 87CA	# <CJK>
EE6A 87B4	# <CJK>
EE6B 87B6	# <CJK>
EE6C 87BF	# <CJK>
EE6D 87B8	# <CJK>
EE6E 87BD	# <CJK>
EE6F 87DE	# <CJK>
EE70 87B2	# <CJK>
EE71 8935	# <CJK>
EE72 8933	# <CJK>
EE73 893C	# <CJK>
EE74 893E	# <CJK>
EE75 8941	# <CJK>
EE76 8952	# <CJK>
EE77 8937	# <CJK>
EE78 8942	# <CJK>
EE79 89AD	# <CJK>
EE7A 89AF	# <CJK>
EE7B 89AE	# <CJK>
EE7C 89F2	# <CJK>
EE7D 89F3	# <CJK>
EE7E 8B1E	# <CJK>
EEA1 8B18	# <CJK>
EEA2 8B16	# <CJK>
EEA3 8B11	# <CJK>
EEA4 8B05	# <CJK>
EEA5 8B0B	# <CJK>
EEA6 8B22	# <CJK>
EEA7 8B0F	# <CJK>
EEA8 8B12	# <CJK>
EEA9 8B15	# <CJK>
EEAA 8B07	# <CJK>
EEAB 8B0D	# <CJK>
EEAC 8B08	# <CJK>
EEAD 8B06	# <CJK>
EEAE 8B1C	# <CJK>
EEAF 8B13	# <CJK>
EEB0 8B1A	# <CJK>
EEB1 8C4F	# <CJK>
EEB2 8C70	# <CJK>
EEB3 8C72	# <CJK>
EEB4 8C71	# <CJK>
EEB5 8C6F	# <CJK>
EEB6 8C95	# <CJK>
EEB7 8C94	# <CJK>
EEB8 8CF9	# <CJK>
EEB9 8D6F	# <CJK>
EEBA 8E4E	# <CJK>
EEBB 8E4D	# <CJK>
EEBC 8E53	# <CJK>
EEBD 8E50	# <CJK>
EEBE 8E4C	# <CJK>
EEBF 8E47	# <CJK>
EEC0 8F43	# <CJK>
EEC1 8F40	# <CJK>
EEC2 9085	# <CJK>
EEC3 907E	# <CJK>
EEC4 9138	# <CJK>
EEC5 919A	# <CJK>
EEC6 91A2	# <CJK>
EEC7 919B	# <CJK>
EEC8 9199	# <CJK>
EEC9 919F	# <CJK>
EECA 91A1	# <CJK>
EECB 919D	# <CJK>
EECC 91A0	# <CJK>
EECD 93A1	# <CJK>
EECE 9383	# <CJK>
EECF 93AF	# <CJK>
EED0 9364	# <CJK>
EED1 9356	# <CJK>
EED2 9347	# <CJK>
EED3 937C	# <CJK>
EED4 9358	# <CJK>
EED5 935C	# <CJK>
EED6 9376	# <CJK>
EED7 9349	# <CJK>
EED8 9350	# <CJK>
EED9 9351	# <CJK>
EEDA 9360	# <CJK>
EEDB 936D	# <CJK>
EEDC 938F	# <CJK>
EEDD 934C	# <CJK>
EEDE 936A	# <CJK>
EEDF 9379	# <CJK>
EEE0 9357	# <CJK>
EEE1 9355	# <CJK>
EEE2 9352	# <CJK>
EEE3 934F	# <CJK>
EEE4 9371	# <CJK>
EEE5 9377	# <CJK>
EEE6 937B	# <CJK>
EEE7 9361	# <CJK>
EEE8 935E	# <CJK>
EEE9 9363	# <CJK>
EEEA 9367	# <CJK>
EEEB 9380	# <CJK>
EEEC 934E	# <CJK>
EEED 9359	# <CJK>
EEEE 95C7	# <CJK>
EEEF 95C0	# <CJK>
EEF0 95C9	# <CJK>
EEF1 95C3	# <CJK>
EEF2 95C5	# <CJK>
EEF3 95B7	# <CJK>
EEF4 96AE	# <CJK>
EEF5 96B0	# <CJK>
EEF6 96AC	# <CJK>
EEF7 9720	# <CJK>
EEF8 971F	# <CJK>
EEF9 9718	# <CJK>
EEFA 971D	# <CJK>
EEFB 9719	# <CJK>
EEFC 979A	# <CJK>
EEFD 97A1	# <CJK>
EEFE 979C	# <CJK>
EF40 979E	# <CJK>
EF41 979D	# <CJK>
EF42 97D5	# <CJK>
EF43 97D4	# <CJK>
EF44 97F1	# <CJK>
EF45 9841	# <CJK>
EF46 9844	# <CJK>
EF47 984A	# <CJK>
EF48 9849	# <CJK>
EF49 9845	# <CJK>
EF4A 9843	# <CJK>
EF4B 9925	# <CJK>
EF4C 992B	# <CJK>
EF4D 992C	# <CJK>
EF4E 992A	# <CJK>
EF4F 9933	# <CJK>
EF50 9932	# <CJK>
EF51 992F	# <CJK>
EF52 992D	# <CJK>
EF53 9931	# <CJK>
EF54 9930	# <CJK>
EF55 9998	# <CJK>
EF56 99A3	# <CJK>
EF57 99A1	# <CJK>
EF58 9A02	# <CJK>
EF59 99FA	# <CJK>
EF5A 99F4	# <CJK>
EF5B 99F7	# <CJK>
EF5C 99F9	# <CJK>
EF5D 99F8	# <CJK>
EF5E 99F6	# <CJK>
EF5F 99FB	# <CJK>
EF60 99FD	# <CJK>
EF61 99FE	# <CJK>
EF62 99FC	# <CJK>
EF63 9A03	# <CJK>
EF64 9ABE	# <CJK>
EF65 9AFE	# <CJK>
EF66 9AFD	# <CJK>
EF67 9B01	# <CJK>
EF68 9AFC	# <CJK>
EF69 9B48	# <CJK>
EF6A 9B9A	# <CJK>
EF6B 9BA8	# <CJK>
EF6C 9B9E	# <CJK>
EF6D 9B9B	# <CJK>
EF6E 9BA6	# <CJK>
EF6F 9BA1	# <CJK>
EF70 9BA5	# <CJK>
EF71 9BA4	# <CJK>
EF72 9B86	# <CJK>
EF73 9BA2	# <CJK>
EF74 9BA0	# <CJK>
EF75 9BAF	# <CJK>
EF76 9D33	# <CJK>
EF77 9D41	# <CJK>
EF78 9D67	# <CJK>
EF79 9D36	# <CJK>
EF7A 9D2E	# <CJK>
EF7B 9D2F	# <CJK>
EF7C 9D31	# <CJK>
EF7D 9D38	# <CJK>
EF7E 9D30	# <CJK>
EFA1 9D45	# <CJK>
EFA2 9D42	# <CJK>
EFA3 9D43	# <CJK>
EFA4 9D3E	# <CJK>
EFA5 9D37	# <CJK>
EFA6 9D40	# <CJK>
EFA7 9D3D	# <CJK>
EFA8 7FF5	# <CJK>
EFA9 9D2D	# <CJK>
EFAA 9E8A	# <CJK>
EFAB 9E89	# <CJK>
EFAC 9E8D	# <CJK>
EFAD 9EB0	# <CJK>
EFAE 9EC8	# <CJK>
EFAF 9EDA	# <CJK>
EFB0 9EFB	# <CJK>
EFB1 9EFF	# <CJK>
EFB2 9F24	# <CJK>
EFB3 9F23	# <CJK>
EFB4 9F22	# <CJK>
EFB5 9F54	# <CJK>
EFB6 9FA0	# <CJK>
EFB7 5131	# <CJK>
EFB8 512D	# <CJK>
EFB9 512E	# <CJK>
EFBA 5698	# <CJK>
EFBB 569C	# <CJK>
EFBC 5697	# <CJK>
EFBD 569A	# <CJK>
EFBE 569D	# <CJK>
EFBF 5699	# <CJK>
EFC0 5970	# <CJK>
EFC1 5B3C	# <CJK>
EFC2 5C69	# <CJK>
EFC3 5C6A	# <CJK>
EFC4 5DC0	# <CJK>
EFC5 5E6D	# <CJK>
EFC6 5E6E	# <CJK>
EFC7 61D8	# <CJK>
EFC8 61DF	# <CJK>
EFC9 61ED	# <CJK>
EFCA 61EE	# <CJK>
EFCB 61F1	# <CJK>
EFCC 61EA	# <CJK>
EFCD 61F0	# <CJK>
EFCE 61EB	# <CJK>
EFCF 61D6	# <CJK>
EFD0 61E9	# <CJK>
EFD1 64FF	# <CJK>
EFD2 6504	# <CJK>
EFD3 64FD	# <CJK>
EFD4 64F8	# <CJK>
EFD5 6501	# <CJK>
EFD6 6503	# <CJK>
EFD7 64FC	# <CJK>
EFD8 6594	# <CJK>
EFD9 65DB	# <CJK>
EFDA 66DA	# <CJK>
EFDB 66DB	# <CJK>
EFDC 66D8	# <CJK>
EFDD 6AC5	# <CJK>
EFDE 6AB9	# <CJK>
EFDF 6ABD	# <CJK>
EFE0 6AE1	# <CJK>
EFE1 6AC6	# <CJK>
EFE2 6ABA	# <CJK>
EFE3 6AB6	# <CJK>
EFE4 6AB7	# <CJK>
EFE5 6AC7	# <CJK>
EFE6 6AB4	# <CJK>
EFE7 6AAD	# <CJK>
EFE8 6B5E	# <CJK>
EFE9 6BC9	# <CJK>
EFEA 6C0B	# <CJK>
EFEB 7007	# <CJK>
EFEC 700C	# <CJK>
EFED 700D	# <CJK>
EFEE 7001	# <CJK>
EFEF 7005	# <CJK>
EFF0 7014	# <CJK>
EFF1 700E	# <CJK>
EFF2 6FFF	# <CJK>
EFF3 7000	# <CJK>
EFF4 6FFB	# <CJK>
EFF5 7026	# <CJK>
EFF6 6FFC	# <CJK>
EFF7 6FF7	# <CJK>
EFF8 700A	# <CJK>
EFF9 7201	# <CJK>
EFFA 71FF	# <CJK>
EFFB 71F9	# <CJK>
EFFC 7203	# <CJK>
EFFD 71FD	# <CJK>
EFFE 7376	# <CJK>
F040 74B8	# <CJK>
F041 74C0	# <CJK>
F042 74B5	# <CJK>
F043 74C1	# <CJK>
F044 74BE	# <CJK>
F045 74B6	# <CJK>
F046 74BB	# <CJK>
F047 74C2	# <CJK>
F048 7514	# <CJK>
F049 7513	# <CJK>
F04A 765C	# <CJK>
F04B 7664	# <CJK>
F04C 7659	# <CJK>
F04D 7650	# <CJK>
F04E 7653	# <CJK>
F04F 7657	# <CJK>
F050 765A	# <CJK>
F051 76A6	# <CJK>
F052 76BD	# <CJK>
F053 76EC	# <CJK>
F054 77C2	# <CJK>
F055 77BA	# <CJK>
F056 78FF	# <CJK>
F057 790C	# <CJK>
F058 7913	# <CJK>
F059 7914	# <CJK>
F05A 7909	# <CJK>
F05B 7910	# <CJK>
F05C 7912	# <CJK>
F05D 7911	# <CJK>
F05E 79AD	# <CJK>
F05F 79AC	# <CJK>
F060 7A5F	# <CJK>
F061 7C1C	# <CJK>
F062 7C29	# <CJK>
F063 7C19	# <CJK>
F064 7C20	# <CJK>
F065 7C1F	# <CJK>
F066 7C2D	# <CJK>
F067 7C1D	# <CJK>
F068 7C26	# <CJK>
F069 7C28	# <CJK>
F06A 7C22	# <CJK>
F06B 7C25	# <CJK>
F06C 7C30	# <CJK>
F06D 7E5C	# <CJK>
F06E 7E50	# <CJK>
F06F 7E56	# <CJK>
F070 7E63	# <CJK>
F071 7E58	# <CJK>
F072 7E62	# <CJK>
F073 7E5F	# <CJK>
F074 7E51	# <CJK>
F075 7E60	# <CJK>
F076 7E57	# <CJK>
F077 7E53	# <CJK>
F078 7FB5	# <CJK>
F079 7FB3	# <CJK>
F07A 7FF7	# <CJK>
F07B 7FF8	# <CJK>
F07C 8075	# <CJK>
F07D 81D1	# <CJK>
F07E 81D2	# <CJK>
F0A1 81D0	# <CJK>
F0A2 825F	# <CJK>
F0A3 825E	# <CJK>
F0A4 85B4	# <CJK>
F0A5 85C6	# <CJK>
F0A6 85C0	# <CJK>
F0A7 85C3	# <CJK>
F0A8 85C2	# <CJK>
F0A9 85B3	# <CJK>
F0AA 85B5	# <CJK>
F0AB 85BD	# <CJK>
F0AC 85C7	# <CJK>
F0AD 85C4	# <CJK>
F0AE 85BF	# <CJK>
F0AF 85CB	# <CJK>
F0B0 85CE	# <CJK>
F0B1 85C8	# <CJK>
F0B2 85C5	# <CJK>
F0B3 85B1	# <CJK>
F0B4 85B6	# <CJK>
F0B5 85D2	# <CJK>
F0B6 8624	# <CJK>
F0B7 85B8	# <CJK>
F0B8 85B7	# <CJK>
F0B9 85BE	# <CJK>
F0BA 8669	# <CJK>
F0BB 87E7	# <CJK>
F0BC 87E6	# <CJK>
F0BD 87E2	# <CJK>
F0BE 87DB	# <CJK>
F0BF 87EB	# <CJK>
F0C0 87EA	# <CJK>
F0C1 87E5	# <CJK>
F0C2 87DF	# <CJK>
F0C3 87F3	# <CJK>
F0C4 87E4	# <CJK>
F0C5 87D4	# <CJK>
F0C6 87DC	# <CJK>
F0C7 87D3	# <CJK>
F0C8 87ED	# <CJK>
F0C9 87D8	# <CJK>
F0CA 87E3	# <CJK>
F0CB 87A4	# <CJK>
F0CC 87D7	# <CJK>
F0CD 87D9	# <CJK>
F0CE 8801	# <CJK>
F0CF 87F4	# <CJK>
F0D0 87E8	# <CJK>
F0D1 87DD	# <CJK>
F0D2 8953	# <CJK>
F0D3 894B	# <CJK>
F0D4 894F	# <CJK>
F0D5 894C	# <CJK>
F0D6 8946	# <CJK>
F0D7 8950	# <CJK>
F0D8 8951	# <CJK>
F0D9 8949	# <CJK>
F0DA 8B2A	# <CJK>
F0DB 8B27	# <CJK>
F0DC 8B23	# <CJK>
F0DD 8B33	# <CJK>
F0DE 8B30	# <CJK>
F0DF 8B35	# <CJK>
F0E0 8B47	# <CJK>
F0E1 8B2F	# <CJK>
F0E2 8B3C	# <CJK>
F0E3 8B3E	# <CJK>
F0E4 8B31	# <CJK>
F0E5 8B25	# <CJK>
F0E6 8B37	# <CJK>
F0E7 8B26	# <CJK>
F0E8 8B36	# <CJK>
F0E9 8B2E	# <CJK>
F0EA 8B24	# <CJK>
F0EB 8B3B	# <CJK>
F0EC 8B3D	# <CJK>
F0ED 8B3A	# <CJK>
F0EE 8C42	# <CJK>
F0EF 8C75	# <CJK>
F0F0 8C99	# <CJK>
F0F1 8C98	# <CJK>
F0F2 8C97	# <CJK>
F0F3 8CFE	# <CJK>
F0F4 8D04	# <CJK>
F0F5 8D02	# <CJK>
F0F6 8D00	# <CJK>
F0F7 8E5C	# <CJK>
F0F8 8E62	# <CJK>
F0F9 8E60	# <CJK>
F0FA 8E57	# <CJK>
F0FB 8E56	# <CJK>
F0FC 8E5E	# <CJK>
F0FD 8E65	# <CJK>
F0FE 8E67	# <CJK>
F140 8E5B	# <CJK>
F141 8E5A	# <CJK>
F142 8E61	# <CJK>
F143 8E5D	# <CJK>
F144 8E69	# <CJK>
F145 8E54	# <CJK>
F146 8F46	# <CJK>
F147 8F47	# <CJK>
F148 8F48	# <CJK>
F149 8F4B	# <CJK>
F14A 9128	# <CJK>
F14B 913A	# <CJK>
F14C 913B	# <CJK>
F14D 913E	# <CJK>
F14E 91A8	# <CJK>
F14F 91A5	# <CJK>
F150 91A7	# <CJK>
F151 91AF	# <CJK>
F152 91AA	# <CJK>
F153 93B5	# <CJK>
F154 938C	# <CJK>
F155 9392	# <CJK>
F156 93B7	# <CJK>
F157 939B	# <CJK>
F158 939D	# <CJK>
F159 9389	# <CJK>
F15A 93A7	# <CJK>
F15B 938E	# <CJK>
F15C 93AA	# <CJK>
F15D 939E	# <CJK>
F15E 93A6	# <CJK>
F15F 9395	# <CJK>
F160 9388	# <CJK>
F161 9399	# <CJK>
F162 939F	# <CJK>
F163 938D	# <CJK>
F164 93B1	# <CJK>
F165 9391	# <CJK>
F166 93B2	# <CJK>
F167 93A4	# <CJK>
F168 93A8	# <CJK>
F169 93B4	# <CJK>
F16A 93A3	# <CJK>
F16B 93A5	# <CJK>
F16C 95D2	# <CJK>
F16D 95D3	# <CJK>
F16E 95D1	# <CJK>
F16F 96B3	# <CJK>
F170 96D7	# <CJK>
F171 96DA	# <CJK>
F172 5DC2	# <CJK>
F173 96DF	# <CJK>
F174 96D8	# <CJK>
F175 96DD	# <CJK>
F176 9723	# <CJK>
F177 9722	# <CJK>
F178 9725	# <CJK>
F179 97AC	# <CJK>
F17A 97AE	# <CJK>
F17B 97A8	# <CJK>
F17C 97AB	# <CJK>
F17D 97A4	# <CJK>
F17E 97AA	# <CJK>
F1A1 97A2	# <CJK>
F1A2 97A5	# <CJK>
F1A3 97D7	# <CJK>
F1A4 97D9	# <CJK>
F1A5 97D6	# <CJK>
F1A6 97D8	# <CJK>
F1A7 97FA	# <CJK>
F1A8 9850	# <CJK>
F1A9 9851	# <CJK>
F1AA 9852	# <CJK>
F1AB 98B8	# <CJK>
F1AC 9941	# <CJK>
F1AD 993C	# <CJK>
F1AE 993A	# <CJK>
F1AF 9A0F	# <CJK>
F1B0 9A0B	# <CJK>
F1B1 9A09	# <CJK>
F1B2 9A0D	# <CJK>
F1B3 9A04	# <CJK>
F1B4 9A11	# <CJK>
F1B5 9A0A	# <CJK>
F1B6 9A05	# <CJK>
F1B7 9A07	# <CJK>
F1B8 9A06	# <CJK>
F1B9 9AC0	# <CJK>
F1BA 9ADC	# <CJK>
F1BB 9B08	# <CJK>
F1BC 9B04	# <CJK>
F1BD 9B05	# <CJK>
F1BE 9B29	# <CJK>
F1BF 9B35	# <CJK>
F1C0 9B4A	# <CJK>
F1C1 9B4C	# <CJK>
F1C2 9B4B	# <CJK>
F1C3 9BC7	# <CJK>
F1C4 9BC6	# <CJK>
F1C5 9BC3	# <CJK>
F1C6 9BBF	# <CJK>
F1C7 9BC1	# <CJK>
F1C8 9BB5	# <CJK>
F1C9 9BB8	# <CJK>
F1CA 9BD3	# <CJK>
F1CB 9BB6	# <CJK>
F1CC 9BC4	# <CJK>
F1CD 9BB9	# <CJK>
F1CE 9BBD	# <CJK>
F1CF 9D5C	# <CJK>
F1D0 9D53	# <CJK>
F1D1 9D4F	# <CJK>
F1D2 9D4A	# <CJK>
F1D3 9D5B	# <CJK>
F1D4 9D4B	# <CJK>
F1D5 9D59	# <CJK>
F1D6 9D56	# <CJK>
F1D7 9D4C	# <CJK>
F1D8 9D57	# <CJK>
F1D9 9D52	# <CJK>
F1DA 9D54	# <CJK>
F1DB 9D5F	# <CJK>
F1DC 9D58	# <CJK>
F1DD 9D5A	# <CJK>
F1DE 9E8E	# <CJK>
F1DF 9E8C	# <CJK>
F1E0 9EDF	# <CJK>
F1E1 9F01	# <CJK>
F1E2 9F00	# <CJK>
F1E3 9F16	# <CJK>
F1E4 9F25	# <CJK>
F1E5 9F2B	# <CJK>
F1E6 9F2A	# <CJK>
F1E7 9F29	# <CJK>
F1E8 9F28	# <CJK>
F1E9 9F4C	# <CJK>
F1EA 9F55	# <CJK>
F1EB 5134	# <CJK>
F1EC 5135	# <CJK>
F1ED 5296	# <CJK>
F1EE 52F7	# <CJK>
F1EF 53B4	# <CJK>
F1F0 56AB	# <CJK>
F1F1 56AD	# <CJK>
F1F2 56A6	# <CJK>
F1F3 56A7	# <CJK>
F1F4 56AA	# <CJK>
F1F5 56AC	# <CJK>
F1F6 58DA	# <CJK>
F1F7 58DD	# <CJK>
F1F8 58DB	# <CJK>
F1F9 5912	# <CJK>
F1FA 5B3D	# <CJK>
F1FB 5B3E	# <CJK>
F1FC 5B3F	# <CJK>
F1FD 5DC3	# <CJK>
F1FE 5E70	# <CJK>
F240 5FBF	# <CJK>
F241 61FB	# <CJK>
F242 6507	# <CJK>
F243 6510	# <CJK>
F244 650D	# <CJK>
F245 6509	# <CJK>
F246 650C	# <CJK>
F247 650E	# <CJK>
F248 6584	# <CJK>
F249 65DE	# <CJK>
F24A 65DD	# <CJK>
F24B 66DE	# <CJK>
F24C 6AE7	# <CJK>
F24D 6AE0	# <CJK>
F24E 6ACC	# <CJK>
F24F 6AD1	# <CJK>
F250 6AD9	# <CJK>
F251 6ACB	# <CJK>
F252 6ADF	# <CJK>
F253 6ADC	# <CJK>
F254 6AD0	# <CJK>
F255 6AEB	# <CJK>
F256 6ACF	# <CJK>
F257 6ACD	# <CJK>
F258 6ADE	# <CJK>
F259 6B60	# <CJK>
F25A 6BB0	# <CJK>
F25B 6C0C	# <CJK>
F25C 7019	# <CJK>
F25D 7027	# <CJK>
F25E 7020	# <CJK>
F25F 7016	# <CJK>
F260 702B	# <CJK>
F261 7021	# <CJK>
F262 7022	# <CJK>
F263 7023	# <CJK>
F264 7029	# <CJK>
F265 7017	# <CJK>
F266 7024	# <CJK>
F267 701C	# <CJK>
F268 702A	# <CJK>
F269 720C	# <CJK>
F26A 720A	# <CJK>
F26B 7207	# <CJK>
F26C 7202	# <CJK>
F26D 7205	# <CJK>
F26E 72A5	# <CJK>
F26F 72A6	# <CJK>
F270 72A4	# <CJK>
F271 72A3	# <CJK>
F272 72A1	# <CJK>
F273 74CB	# <CJK>
F274 74C5	# <CJK>
F275 74B7	# <CJK>
F276 74C3	# <CJK>
F277 7516	# <CJK>
F278 7660	# <CJK>
F279 77C9	# <CJK>
F27A 77CA	# <CJK>
F27B 77C4	# <CJK>
F27C 77F1	# <CJK>
F27D 791D	# <CJK>
F27E 791B	# <CJK>
F2A1 7921	# <CJK>
F2A2 791C	# <CJK>
F2A3 7917	# <CJK>
F2A4 791E	# <CJK>
F2A5 79B0	# <CJK>
F2A6 7A67	# <CJK>
F2A7 7A68	# <CJK>
F2A8 7C33	# <CJK>
F2A9 7C3C	# <CJK>
F2AA 7C39	# <CJK>
F2AB 7C2C	# <CJK>
F2AC 7C3B	# <CJK>
F2AD 7CEC	# <CJK>
F2AE 7CEA	# <CJK>
F2AF 7E76	# <CJK>
F2B0 7E75	# <CJK>
F2B1 7E78	# <CJK>
F2B2 7E70	# <CJK>
F2B3 7E77	# <CJK>
F2B4 7E6F	# <CJK>
F2B5 7E7A	# <CJK>
F2B6 7E72	# <CJK>
F2B7 7E74	# <CJK>
F2B8 7E68	# <CJK>
F2B9 7F4B	# <CJK>
F2BA 7F4A	# <CJK>
F2BB 7F83	# <CJK>
F2BC 7F86	# <CJK>
F2BD 7FB7	# <CJK>
F2BE 7FFD	# <CJK>
F2BF 7FFE	# <CJK>
F2C0 8078	# <CJK>
F2C1 81D7	# <CJK>
F2C2 81D5	# <CJK>
F2C3 8264	# <CJK>
F2C4 8261	# <CJK>
F2C5 8263	# <CJK>
F2C6 85EB	# <CJK>
F2C7 85F1	# <CJK>
F2C8 85ED	# <CJK>
F2C9 85D9	# <CJK>
F2CA 85E1	# <CJK>
F2CB 85E8	# <CJK>
F2CC 85DA	# <CJK>
F2CD 85D7	# <CJK>
F2CE 85EC	# <CJK>
F2CF 85F2	# <CJK>
F2D0 85F8	# <CJK>
F2D1 85D8	# <CJK>
F2D2 85DF	# <CJK>
F2D3 85E3	# <CJK>
F2D4 85DC	# <CJK>
F2D5 85D1	# <CJK>
F2D6 85F0	# <CJK>
F2D7 85E6	# <CJK>
F2D8 85EF	# <CJK>
F2D9 85DE	# <CJK>
F2DA 85E2	# <CJK>
F2DB 8800	# <CJK>
F2DC 87FA	# <CJK>
F2DD 8803	# <CJK>
F2DE 87F6	# <CJK>
F2DF 87F7	# <CJK>
F2E0 8809	# <CJK>
F2E1 880C	# <CJK>
F2E2 880B	# <CJK>
F2E3 8806	# <CJK>
F2E4 87FC	# <CJK>
F2E5 8808	# <CJK>
F2E6 87FF	# <CJK>
F2E7 880A	# <CJK>
F2E8 8802	# <CJK>
F2E9 8962	# <CJK>
F2EA 895A	# <CJK>
F2EB 895B	# <CJK>
F2EC 8957	# <CJK>
F2ED 8961	# <CJK>
F2EE 895C	# <CJK>
F2EF 8958	# <CJK>
F2F0 895D	# <CJK>
F2F1 8959	# <CJK>
F2F2 8988	# <CJK>
F2F3 89B7	# <CJK>
F2F4 89B6	# <CJK>
F2F5 89F6	# <CJK>
F2F6 8B50	# <CJK>
F2F7 8B48	# <CJK>
F2F8 8B4A	# <CJK>
F2F9 8B40	# <CJK>
F2FA 8B53	# <CJK>
F2FB 8B56	# <CJK>
F2FC 8B54	# <CJK>
F2FD 8B4B	# <CJK>
F2FE 8B55	# <CJK>
F340 8B51	# <CJK>
F341 8B42	# <CJK>
F342 8B52	# <CJK>
F343 8B57	# <CJK>
F344 8C43	# <CJK>
F345 8C77	# <CJK>
F346 8C76	# <CJK>
F347 8C9A	# <CJK>
F348 8D06	# <CJK>
F349 8D07	# <CJK>
F34A 8D09	# <CJK>
F34B 8DAC	# <CJK>
F34C 8DAA	# <CJK>
F34D 8DAD	# <CJK>
F34E 8DAB	# <CJK>
F34F 8E6D	# <CJK>
F350 8E78	# <CJK>
F351 8E73	# <CJK>
F352 8E6A	# <CJK>
F353 8E6F	# <CJK>
F354 8E7B	# <CJK>
F355 8EC2	# <CJK>
F356 8F52	# <CJK>
F357 8F51	# <CJK>
F358 8F4F	# <CJK>
F359 8F50	# <CJK>
F35A 8F53	# <CJK>
F35B 8FB4	# <CJK>
F35C 9140	# <CJK>
F35D 913F	# <CJK>
F35E 91B0	# <CJK>
F35F 91AD	# <CJK>
F360 93DE	# <CJK>
F361 93C7	# <CJK>
F362 93CF	# <CJK>
F363 93C2	# <CJK>
F364 93DA	# <CJK>
F365 93D0	# <CJK>
F366 93F9	# <CJK>
F367 93EC	# <CJK>
F368 93CC	# <CJK>
F369 93D9	# <CJK>
F36A 93A9	# <CJK>
F36B 93E6	# <CJK>
F36C 93CA	# <CJK>
F36D 93D4	# <CJK>
F36E 93EE	# <CJK>
F36F 93E3	# <CJK>
F370 93D5	# <CJK>
F371 93C4	# <CJK>
F372 93CE	# <CJK>
F373 93C0	# <CJK>
F374 93D2	# <CJK>
F375 93E7	# <CJK>
F376 957D	# <CJK>
F377 95DA	# <CJK>
F378 95DB	# <CJK>
F379 96E1	# <CJK>
F37A 9729	# <CJK>
F37B 972B	# <CJK>
F37C 972C	# <CJK>
F37D 9728	# <CJK>
F37E 9726	# <CJK>
F3A1 97B3	# <CJK>
F3A2 97B7	# <CJK>
F3A3 97B6	# <CJK>
F3A4 97DD	# <CJK>
F3A5 97DE	# <CJK>
F3A6 97DF	# <CJK>
F3A7 985C	# <CJK>
F3A8 9859	# <CJK>
F3A9 985D	# <CJK>
F3AA 9857	# <CJK>
F3AB 98BF	# <CJK>
F3AC 98BD	# <CJK>
F3AD 98BB	# <CJK>
F3AE 98BE	# <CJK>
F3AF 9948	# <CJK>
F3B0 9947	# <CJK>
F3B1 9943	# <CJK>
F3B2 99A6	# <CJK>
F3B3 99A7	# <CJK>
F3B4 9A1A	# <CJK>
F3B5 9A15	# <CJK>
F3B6 9A25	# <CJK>
F3B7 9A1D	# <CJK>
F3B8 9A24	# <CJK>
F3B9 9A1B	# <CJK>
F3BA 9A22	# <CJK>
F3BB 9A20	# <CJK>
F3BC 9A27	# <CJK>
F3BD 9A23	# <CJK>
F3BE 9A1E	# <CJK>
F3BF 9A1C	# <CJK>
F3C0 9A14	# <CJK>
F3C1 9AC2	# <CJK>
F3C2 9B0B	# <CJK>
F3C3 9B0A	# <CJK>
F3C4 9B0E	# <CJK>
F3C5 9B0C	# <CJK>
F3C6 9B37	# <CJK>
F3C7 9BEA	# <CJK>
F3C8 9BEB	# <CJK>
F3C9 9BE0	# <CJK>
F3CA 9BDE	# <CJK>
F3CB 9BE4	# <CJK>
F3CC 9BE6	# <CJK>
F3CD 9BE2	# <CJK>
F3CE 9BF0	# <CJK>
F3CF 9BD4	# <CJK>
F3D0 9BD7	# <CJK>
F3D1 9BEC	# <CJK>
F3D2 9BDC	# <CJK>
F3D3 9BD9	# <CJK>
F3D4 9BE5	# <CJK>
F3D5 9BD5	# <CJK>
F3D6 9BE1	# <CJK>
F3D7 9BDA	# <CJK>
F3D8 9D77	# <CJK>
F3D9 9D81	# <CJK>
F3DA 9D8A	# <CJK>
F3DB 9D84	# <CJK>
F3DC 9D88	# <CJK>
F3DD 9D71	# <CJK>
F3DE 9D80	# <CJK>
F3DF 9D78	# <CJK>
F3E0 9D86	# <CJK>
F3E1 9D8B	# <CJK>
F3E2 9D8C	# <CJK>
F3E3 9D7D	# <CJK>
F3E4 9D6B	# <CJK>
F3E5 9D74	# <CJK>
F3E6 9D75	# <CJK>
F3E7 9D70	# <CJK>
F3E8 9D69	# <CJK>
F3E9 9D85	# <CJK>
F3EA 9D73	# <CJK>
F3EB 9D7B	# <CJK>
F3EC 9D82	# <CJK>
F3ED 9D6F	# <CJK>
F3EE 9D79	# <CJK>
F3EF 9D7F	# <CJK>
F3F0 9D87	# <CJK>
F3F1 9D68	# <CJK>
F3F2 9E94	# <CJK>
F3F3 9E91	# <CJK>
F3F4 9EC0	# <CJK>
F3F5 9EFC	# <CJK>
F3F6 9F2D	# <CJK>
F3F7 9F40	# <CJK>
F3F8 9F41	# <CJK>
F3F9 9F4D	# <CJK>
F3FA 9F56	# <CJK>
F3FB 9F57	# <CJK>
F3FC 9F58	# <CJK>
F3FD 5337	# <CJK>
F3FE 56B2	# <CJK>
F440 56B5	# <CJK>
F441 56B3	# <CJK>
F442 58E3	# <CJK>
F443 5B45	# <CJK>
F444 5DC6	# <CJK>
F445 5DC7	# <CJK>
F446 5EEE	# <CJK>
F447 5EEF	# <CJK>
F448 5FC0	# <CJK>
F449 5FC1	# <CJK>
F44A 61F9	# <CJK>
F44B 6517	# <CJK>
F44C 6516	# <CJK>
F44D 6515	# <CJK>
F44E 6513	# <CJK>
F44F 65DF	# <CJK>
F450 66E8	# <CJK>
F451 66E3	# <CJK>
F452 66E4	# <CJK>
F453 6AF3	# <CJK>
F454 6AF0	# <CJK>
F455 6AEA	# <CJK>
F456 6AE8	# <CJK>
F457 6AF9	# <CJK>
F458 6AF1	# <CJK>
F459 6AEE	# <CJK>
F45A 6AEF	# <CJK>
F45B 703C	# <CJK>
F45C 7035	# <CJK>
F45D 702F	# <CJK>
F45E 7037	# <CJK>
F45F 7034	# <CJK>
F460 7031	# <CJK>
F461 7042	# <CJK>
F462 7038	# <CJK>
F463 703F	# <CJK>
F464 703A	# <CJK>
F465 7039	# <CJK>
F466 7040	# <CJK>
F467 703B	# <CJK>
F468 7033	# <CJK>
F469 7041	# <CJK>
F46A 7213	# <CJK>
F46B 7214	# <CJK>
F46C 72A8	# <CJK>
F46D 737D	# <CJK>
F46E 737C	# <CJK>
F46F 74BA	# <CJK>
F470 76AB	# <CJK>
F471 76AA	# <CJK>
F472 76BE	# <CJK>
F473 76ED	# <CJK>
F474 77CC	# <CJK>
F475 77CE	# <CJK>
F476 77CF	# <CJK>
F477 77CD	# <CJK>
F478 77F2	# <CJK>
F479 7925	# <CJK>
F47A 7923	# <CJK>
F47B 7927	# <CJK>
F47C 7928	# <CJK>
F47D 7924	# <CJK>
F47E 7929	# <CJK>
F4A1 79B2	# <CJK>
F4A2 7A6E	# <CJK>
F4A3 7A6C	# <CJK>
F4A4 7A6D	# <CJK>
F4A5 7AF7	# <CJK>
F4A6 7C49	# <CJK>
F4A7 7C48	# <CJK>
F4A8 7C4A	# <CJK>
F4A9 7C47	# <CJK>
F4AA 7C45	# <CJK>
F4AB 7CEE	# <CJK>
F4AC 7E7B	# <CJK>
F4AD 7E7E	# <CJK>
F4AE 7E81	# <CJK>
F4AF 7E80	# <CJK>
F4B0 7FBA	# <CJK>
F4B1 7FFF	# <CJK>
F4B2 8079	# <CJK>
F4B3 81DB	# <CJK>
F4B4 81D9	# <CJK>
F4B5 820B	# <CJK>
F4B6 8268	# <CJK>
F4B7 8269	# <CJK>
F4B8 8622	# <CJK>
F4B9 85FF	# <CJK>
F4BA 8601	# <CJK>
F4BB 85FE	# <CJK>
F4BC 861B	# <CJK>
F4BD 8600	# <CJK>
F4BE 85F6	# <CJK>
F4BF 8604	# <CJK>
F4C0 8609	# <CJK>
F4C1 8605	# <CJK>
F4C2 860C	# <CJK>
F4C3 85FD	# <CJK>
F4C4 8819	# <CJK>
F4C5 8810	# <CJK>
F4C6 8811	# <CJK>
F4C7 8817	# <CJK>
F4C8 8813	# <CJK>
F4C9 8816	# <CJK>
F4CA 8963	# <CJK>
F4CB 8966	# <CJK>
F4CC 89B9	# <CJK>
F4CD 89F7	# <CJK>
F4CE 8B60	# <CJK>
F4CF 8B6A	# <CJK>
F4D0 8B5D	# <CJK>
F4D1 8B68	# <CJK>
F4D2 8B63	# <CJK>
F4D3 8B65	# <CJK>
F4D4 8B67	# <CJK>
F4D5 8B6D	# <CJK>
F4D6 8DAE	# <CJK>
F4D7 8E86	# <CJK>
F4D8 8E88	# <CJK>
F4D9 8E84	# <CJK>
F4DA 8F59	# <CJK>
F4DB 8F56	# <CJK>
F4DC 8F57	# <CJK>
F4DD 8F55	# <CJK>
F4DE 8F58	# <CJK>
F4DF 8F5A	# <CJK>
F4E0 908D	# <CJK>
F4E1 9143	# <CJK>
F4E2 9141	# <CJK>
F4E3 91B7	# <CJK>
F4E4 91B5	# <CJK>
F4E5 91B2	# <CJK>
F4E6 91B3	# <CJK>
F4E7 940B	# <CJK>
F4E8 9413	# <CJK>
F4E9 93FB	# <CJK>
F4EA 9420	# <CJK>
F4EB 940F	# <CJK>
F4EC 9414	# <CJK>
F4ED 93FE	# <CJK>
F4EE 9415	# <CJK>
F4EF 9410	# <CJK>
F4F0 9428	# <CJK>
F4F1 9419	# <CJK>
F4F2 940D	# <CJK>
F4F3 93F5	# <CJK>
F4F4 9400	# <CJK>
F4F5 93F7	# <CJK>
F4F6 9407	# <CJK>
F4F7 940E	# <CJK>
F4F8 9416	# <CJK>
F4F9 9412	# <CJK>
F4FA 93FA	# <CJK>
F4FB 9409	# <CJK>
F4FC 93F8	# <CJK>
F4FD 940A	# <CJK>
F4FE 93FF	# <CJK>
F540 93FC	# <CJK>
F541 940C	# <CJK>
F542 93F6	# <CJK>
F543 9411	# <CJK>
F544 9406	# <CJK>
F545 95DE	# <CJK>
F546 95E0	# <CJK>
F547 95DF	# <CJK>
F548 972E	# <CJK>
F549 972F	# <CJK>
F54A 97B9	# <CJK>
F54B 97BB	# <CJK>
F54C 97FD	# <CJK>
F54D 97FE	# <CJK>
F54E 9860	# <CJK>
F54F 9862	# <CJK>
F550 9863	# <CJK>
F551 985F	# <CJK>
F552 98C1	# <CJK>
F553 98C2	# <CJK>
F554 9950	# <CJK>
F555 994E	# <CJK>
F556 9959	# <CJK>
F557 994C	# <CJK>
F558 994B	# <CJK>
F559 9953	# <CJK>
F55A 9A32	# <CJK>
F55B 9A34	# <CJK>
F55C 9A31	# <CJK>
F55D 9A2C	# <CJK>
F55E 9A2A	# <CJK>
F55F 9A36	# <CJK>
F560 9A29	# <CJK>
F561 9A2E	# <CJK>
F562 9A38	# <CJK>
F563 9A2D	# <CJK>
F564 9AC7	# <CJK>
F565 9ACA	# <CJK>
F566 9AC6	# <CJK>
F567 9B10	# <CJK>
F568 9B12	# <CJK>
F569 9B11	# <CJK>
F56A 9C0B	# <CJK>
F56B 9C08	# <CJK>
F56C 9BF7	# <CJK>
F56D 9C05	# <CJK>
F56E 9C12	# <CJK>
F56F 9BF8	# <CJK>
F570 9C40	# <CJK>
F571 9C07	# <CJK>
F572 9C0E	# <CJK>
F573 9C06	# <CJK>
F574 9C17	# <CJK>
F575 9C14	# <CJK>
F576 9C09	# <CJK>
F577 9D9F	# <CJK>
F578 9D99	# <CJK>
F579 9DA4	# <CJK>
F57A 9D9D	# <CJK>
F57B 9D92	# <CJK>
F57C 9D98	# <CJK>
F57D 9D90	# <CJK>
F57E 9D9B	# <CJK>
F5A1 9DA0	# <CJK>
F5A2 9D94	# <CJK>
F5A3 9D9C	# <CJK>
F5A4 9DAA	# <CJK>
F5A5 9D97	# <CJK>
F5A6 9DA1	# <CJK>
F5A7 9D9A	# <CJK>
F5A8 9DA2	# <CJK>
F5A9 9DA8	# <CJK>
F5AA 9D9E	# <CJK>
F5AB 9DA3	# <CJK>
F5AC 9DBF	# <CJK>
F5AD 9DA9	# <CJK>
F5AE 9D96	# <CJK>
F5AF 9DA6	# <CJK>
F5B0 9DA7	# <CJK>
F5B1 9E99	# <CJK>
F5B2 9E9B	# <CJK>
F5B3 9E9A	# <CJK>
F5B4 9EE5	# <CJK>
F5B5 9EE4	# <CJK>
F5B6 9EE7	# <CJK>
F5B7 9EE6	# <CJK>
F5B8 9F30	# <CJK>
F5B9 9F2E	# <CJK>
F5BA 9F5B	# <CJK>
F5BB 9F60	# <CJK>
F5BC 9F5E	# <CJK>
F5BD 9F5D	# <CJK>
F5BE 9F59	# <CJK>
F5BF 9F91	# <CJK>
F5C0 513A	# <CJK>
F5C1 5139	# <CJK>
F5C2 5298	# <CJK>
F5C3 5297	# <CJK>
F5C4 56C3	# <CJK>
F5C5 56BD	# <CJK>
F5C6 56BE	# <CJK>
F5C7 5B48	# <CJK>
F5C8 5B47	# <CJK>
F5C9 5DCB	# <CJK>
F5CA 5DCF	# <CJK>
F5CB 5EF1	# <CJK>
F5CC 61FD	# <CJK>
F5CD 651B	# <CJK>
F5CE 6B02	# <CJK>
F5CF 6AFC	# <CJK>
F5D0 6B03	# <CJK>
F5D1 6AF8	# <CJK>
F5D2 6B00	# <CJK>
F5D3 7043	# <CJK>
F5D4 7044	# <CJK>
F5D5 704A	# <CJK>
F5D6 7048	# <CJK>
F5D7 7049	# <CJK>
F5D8 7045	# <CJK>
F5D9 7046	# <CJK>
F5DA 721D	# <CJK>
F5DB 721A	# <CJK>
F5DC 7219	# <CJK>
F5DD 737E	# <CJK>
F5DE 7517	# <CJK>
F5DF 766A	# <CJK>
F5E0 77D0	# <CJK>
F5E1 792D	# <CJK>
F5E2 7931	# <CJK>
F5E3 792F	# <CJK>
F5E4 7C54	# <CJK>
F5E5 7C53	# <CJK>
F5E6 7CF2	# <CJK>
F5E7 7E8A	# <CJK>
F5E8 7E87	# <CJK>
F5E9 7E88	# <CJK>
F5EA 7E8B	# <CJK>
F5EB 7E86	# <CJK>
F5EC 7E8D	# <CJK>
F5ED 7F4D	# <CJK>
F5EE 7FBB	# <CJK>
F5EF 8030	# <CJK>
F5F0 81DD	# <CJK>
F5F1 8618	# <CJK>
F5F2 862A	# <CJK>
F5F3 8626	# <CJK>
F5F4 861F	# <CJK>
F5F5 8623	# <CJK>
F5F6 861C	# <CJK>
F5F7 8619	# <CJK>
F5F8 8627	# <CJK>
F5F9 862E	# <CJK>
F5FA 8621	# <CJK>
F5FB 8620	# <CJK>
F5FC 8629	# <CJK>
F5FD 861E	# <CJK>
F5FE 8625	# <CJK>
F640 8829	# <CJK>
F641 881D	# <CJK>
F642 881B	# <CJK>
F643 8820	# <CJK>
F644 8824	# <CJK>
F645 881C	# <CJK>
F646 882B	# <CJK>
F647 884A	# <CJK>
F648 896D	# <CJK>
F649 8969	# <CJK>
F64A 896E	# <CJK>
F64B 896B	# <CJK>
F64C 89FA	# <CJK>
F64D 8B79	# <CJK>
F64E 8B78	# <CJK>
F64F 8B45	# <CJK>
F650 8B7A	# <CJK>
F651 8B7B	# <CJK>
F652 8D10	# <CJK>
F653 8D14	# <CJK>
F654 8DAF	# <CJK>
F655 8E8E	# <CJK>
F656 8E8C	# <CJK>
F657 8F5E	# <CJK>
F658 8F5B	# <CJK>
F659 8F5D	# <CJK>
F65A 9146	# <CJK>
F65B 9144	# <CJK>
F65C 9145	# <CJK>
F65D 91B9	# <CJK>
F65E 943F	# <CJK>
F65F 943B	# <CJK>
F660 9436	# <CJK>
F661 9429	# <CJK>
F662 943D	# <CJK>
F663 943C	# <CJK>
F664 9430	# <CJK>
F665 9439	# <CJK>
F666 942A	# <CJK>
F667 9437	# <CJK>
F668 942C	# <CJK>
F669 9440	# <CJK>
F66A 9431	# <CJK>
F66B 95E5	# <CJK>
F66C 95E4	# <CJK>
F66D 95E3	# <CJK>
F66E 9735	# <CJK>
F66F 973A	# <CJK>
F670 97BF	# <CJK>
F671 97E1	# <CJK>
F672 9864	# <CJK>
F673 98C9	# <CJK>
F674 98C6	# <CJK>
F675 98C0	# <CJK>
F676 9958	# <CJK>
F677 9956	# <CJK>
F678 9A39	# <CJK>
F679 9A3D	# <CJK>
F67A 9A46	# <CJK>
F67B 9A44	# <CJK>
F67C 9A42	# <CJK>
F67D 9A41	# <CJK>
F67E 9A3A	# <CJK>
F6A1 9A3F	# <CJK>
F6A2 9ACD	# <CJK>
F6A3 9B15	# <CJK>
F6A4 9B17	# <CJK>
F6A5 9B18	# <CJK>
F6A6 9B16	# <CJK>
F6A7 9B3A	# <CJK>
F6A8 9B52	# <CJK>
F6A9 9C2B	# <CJK>
F6AA 9C1D	# <CJK>
F6AB 9C1C	# <CJK>
F6AC 9C2C	# <CJK>
F6AD 9C23	# <CJK>
F6AE 9C28	# <CJK>
F6AF 9C29	# <CJK>
F6B0 9C24	# <CJK>
F6B1 9C21	# <CJK>
F6B2 9DB7	# <CJK>
F6B3 9DB6	# <CJK>
F6B4 9DBC	# <CJK>
F6B5 9DC1	# <CJK>
F6B6 9DC7	# <CJK>
F6B7 9DCA	# <CJK>
F6B8 9DCF	# <CJK>
F6B9 9DBE	# <CJK>
F6BA 9DC5	# <CJK>
F6BB 9DC3	# <CJK>
F6BC 9DBB	# <CJK>
F6BD 9DB5	# <CJK>
F6BE 9DCE	# <CJK>
F6BF 9DB9	# <CJK>
F6C0 9DBA	# <CJK>
F6C1 9DAC	# <CJK>
F6C2 9DC8	# <CJK>
F6C3 9DB1	# <CJK>
F6C4 9DAD	# <CJK>
F6C5 9DCC	# <CJK>
F6C6 9DB3	# <CJK>
F6C7 9DCD	# <CJK>
F6C8 9DB2	# <CJK>
F6C9 9E7A	# <CJK>
F6CA 9E9C	# <CJK>
F6CB 9EEB	# <CJK>
F6CC 9EEE	# <CJK>
F6CD 9EED	# <CJK>
F6CE 9F1B	# <CJK>
F6CF 9F18	# <CJK>
F6D0 9F1A	# <CJK>
F6D1 9F31	# <CJK>
F6D2 9F4E	# <CJK>
F6D3 9F65	# <CJK>
F6D4 9F64	# <CJK>
F6D5 9F92	# <CJK>
F6D6 4EB9	# <CJK>
F6D7 56C6	# <CJK>
F6D8 56C5	# <CJK>
F6D9 56CB	# <CJK>
F6DA 5971	# <CJK>
F6DB 5B4B	# <CJK>
F6DC 5B4C	# <CJK>
F6DD 5DD5	# <CJK>
F6DE 5DD1	# <CJK>
F6DF 5EF2	# <CJK>
F6E0 6521	# <CJK>
F6E1 6520	# <CJK>
F6E2 6526	# <CJK>
F6E3 6522	# <CJK>
F6E4 6B0B	# <CJK>
F6E5 6B08	# <CJK>
F6E6 6B09	# <CJK>
F6E7 6C0D	# <CJK>
F6E8 7055	# <CJK>
F6E9 7056	# <CJK>
F6EA 7057	# <CJK>
F6EB 7052	# <CJK>
F6EC 721E	# <CJK>
F6ED 721F	# <CJK>
F6EE 72A9	# <CJK>
F6EF 737F	# <CJK>
F6F0 74D8	# <CJK>
F6F1 74D5	# <CJK>
F6F2 74D9	# <CJK>
F6F3 74D7	# <CJK>
F6F4 766D	# <CJK>
F6F5 76AD	# <CJK>
F6F6 7935	# <CJK>
F6F7 79B4	# <CJK>
F6F8 7A70	# <CJK>
F6F9 7A71	# <CJK>
F6FA 7C57	# <CJK>
F6FB 7C5C	# <CJK>
F6FC 7C59	# <CJK>
F6FD 7C5B	# <CJK>
F6FE 7C5A	# <CJK>
F740 7CF4	# <CJK>
F741 7CF1	# <CJK>
F742 7E91	# <CJK>
F743 7F4F	# <CJK>
F744 7F87	# <CJK>
F745 81DE	# <CJK>
F746 826B	# <CJK>
F747 8634	# <CJK>
F748 8635	# <CJK>
F749 8633	# <CJK>
F74A 862C	# <CJK>
F74B 8632	# <CJK>
F74C 8636	# <CJK>
F74D 882C	# <CJK>
F74E 8828	# <CJK>
F74F 8826	# <CJK>
F750 882A	# <CJK>
F751 8825	# <CJK>
F752 8971	# <CJK>
F753 89BF	# <CJK>
F754 89BE	# <CJK>
F755 89FB	# <CJK>
F756 8B7E	# <CJK>
F757 8B84	# <CJK>
F758 8B82	# <CJK>
F759 8B86	# <CJK>
F75A 8B85	# <CJK>
F75B 8B7F	# <CJK>
F75C 8D15	# <CJK>
F75D 8E95	# <CJK>
F75E 8E94	# <CJK>
F75F 8E9A	# <CJK>
F760 8E92	# <CJK>
F761 8E90	# <CJK>
F762 8E96	# <CJK>
F763 8E97	# <CJK>
F764 8F60	# <CJK>
F765 8F62	# <CJK>
F766 9147	# <CJK>
F767 944C	# <CJK>
F768 9450	# <CJK>
F769 944A	# <CJK>
F76A 944B	# <CJK>
F76B 944F	# <CJK>
F76C 9447	# <CJK>
F76D 9445	# <CJK>
F76E 9448	# <CJK>
F76F 9449	# <CJK>
F770 9446	# <CJK>
F771 973F	# <CJK>
F772 97E3	# <CJK>
F773 986A	# <CJK>
F774 9869	# <CJK>
F775 98CB	# <CJK>
F776 9954	# <CJK>
F777 995B	# <CJK>
F778 9A4E	# <CJK>
F779 9A53	# <CJK>
F77A 9A54	# <CJK>
F77B 9A4C	# <CJK>
F77C 9A4F	# <CJK>
F77D 9A48	# <CJK>
F77E 9A4A	# <CJK>
F7A1 9A49	# <CJK>
F7A2 9A52	# <CJK>
F7A3 9A50	# <CJK>
F7A4 9AD0	# <CJK>
F7A5 9B19	# <CJK>
F7A6 9B2B	# <CJK>
F7A7 9B3B	# <CJK>
F7A8 9B56	# <CJK>
F7A9 9B55	# <CJK>
F7AA 9C46	# <CJK>
F7AB 9C48	# <CJK>
F7AC 9C3F	# <CJK>
F7AD 9C44	# <CJK>
F7AE 9C39	# <CJK>
F7AF 9C33	# <CJK>
F7B0 9C41	# <CJK>
F7B1 9C3C	# <CJK>
F7B2 9C37	# <CJK>
F7B3 9C34	# <CJK>
F7B4 9C32	# <CJK>
F7B5 9C3D	# <CJK>
F7B6 9C36	# <CJK>
F7B7 9DDB	# <CJK>
F7B8 9DD2	# <CJK>
F7B9 9DDE	# <CJK>
F7BA 9DDA	# <CJK>
F7BB 9DCB	# <CJK>
F7BC 9DD0	# <CJK>
F7BD 9DDC	# <CJK>
F7BE 9DD1	# <CJK>
F7BF 9DDF	# <CJK>
F7C0 9DE9	# <CJK>
F7C1 9DD9	# <CJK>
F7C2 9DD8	# <CJK>
F7C3 9DD6	# <CJK>
F7C4 9DF5	# <CJK>
F7C5 9DD5	# <CJK>
F7C6 9DDD	# <CJK>
F7C7 9EB6	# <CJK>
F7C8 9EF0	# <CJK>
F7C9 9F35	# <CJK>
F7CA 9F33	# <CJK>
F7CB 9F32	# <CJK>
F7CC 9F42	# <CJK>
F7CD 9F6B	# <CJK>
F7CE 9F95	# <CJK>
F7CF 9FA2	# <CJK>
F7D0 513D	# <CJK>
F7D1 5299	# <CJK>
F7D2 58E8	# <CJK>
F7D3 58E7	# <CJK>
F7D4 5972	# <CJK>
F7D5 5B4D	# <CJK>
F7D6 5DD8	# <CJK>
F7D7 882F	# <CJK>
F7D8 5F4F	# <CJK>
F7D9 6201	# <CJK>
F7DA 6203	# <CJK>
F7DB 6204	# <CJK>
F7DC 6529	# <CJK>
F7DD 6525	# <CJK>
F7DE 6596	# <CJK>
F7DF 66EB	# <CJK>
F7E0 6B11	# <CJK>
F7E1 6B12	# <CJK>
F7E2 6B0F	# <CJK>
F7E3 6BCA	# <CJK>
F7E4 705B	# <CJK>
F7E5 705A	# <CJK>
F7E6 7222	# <CJK>
F7E7 7382	# <CJK>
F7E8 7381	# <CJK>
F7E9 7383	# <CJK>
F7EA 7670	# <CJK>
F7EB 77D4	# <CJK>
F7EC 7C67	# <CJK>
F7ED 7C66	# <CJK>
F7EE 7E95	# <CJK>
F7EF 826C	# <CJK>
F7F0 863A	# <CJK>
F7F1 8640	# <CJK>
F7F2 8639	# <CJK>
F7F3 863C	# <CJK>
F7F4 8631	# <CJK>
F7F5 863B	# <CJK>
F7F6 863E	# <CJK>
F7F7 8830	# <CJK>
F7F8 8832	# <CJK>
F7F9 882E	# <CJK>
F7FA 8833	# <CJK>
F7FB 8976	# <CJK>
F7FC 8974	# <CJK>
F7FD 8973	# <CJK>
F7FE 89FE	# <CJK>
F840 8B8C	# <CJK>
F841 8B8E	# <CJK>
F842 8B8B	# <CJK>
F843 8B88	# <CJK>
F844 8C45	# <CJK>
F845 8D19	# <CJK>
F846 8E98	# <CJK>
F847 8F64	# <CJK>
F848 8F63	# <CJK>
F849 91BC	# <CJK>
F84A 9462	# <CJK>
F84B 9455	# <CJK>
F84C 945D	# <CJK>
F84D 9457	# <CJK>
F84E 945E	# <CJK>
F84F 97C4	# <CJK>
F850 97C5	# <CJK>
F851 9800	# <CJK>
F852 9A56	# <CJK>
F853 9A59	# <CJK>
F854 9B1E	# <CJK>
F855 9B1F	# <CJK>
F856 9B20	# <CJK>
F857 9C52	# <CJK>
F858 9C58	# <CJK>
F859 9C50	# <CJK>
F85A 9C4A	# <CJK>
F85B 9C4D	# <CJK>
F85C 9C4B	# <CJK>
F85D 9C55	# <CJK>
F85E 9C59	# <CJK>
F85F 9C4C	# <CJK>
F860 9C4E	# <CJK>
F861 9DFB	# <CJK>
F862 9DF7	# <CJK>
F863 9DEF	# <CJK>
F864 9DE3	# <CJK>
F865 9DEB	# <CJK>
F866 9DF8	# <CJK>
F867 9DE4	# <CJK>
F868 9DF6	# <CJK>
F869 9DE1	# <CJK>
F86A 9DEE	# <CJK>
F86B 9DE6	# <CJK>
F86C 9DF2	# <CJK>
F86D 9DF0	# <CJK>
F86E 9DE2	# <CJK>
F86F 9DEC	# <CJK>
F870 9DF4	# <CJK>
F871 9DF3	# <CJK>
F872 9DE8	# <CJK>
F873 9DED	# <CJK>
F874 9EC2	# <CJK>
F875 9ED0	# <CJK>
F876 9EF2	# <CJK>
F877 9EF3	# <CJK>
F878 9F06	# <CJK>
F879 9F1C	# <CJK>
F87A 9F38	# <CJK>
F87B 9F37	# <CJK>
F87C 9F36	# <CJK>
F87D 9F43	# <CJK>
F87E 9F4F	# <CJK>
F8A1 9F71	# <CJK>
F8A2 9F70	# <CJK>
F8A3 9F6E	# <CJK>
F8A4 9F6F	# <CJK>
F8A5 56D3	# <CJK>
F8A6 56CD	# <CJK>
F8A7 5B4E	# <CJK>
F8A8 5C6D	# <CJK>
F8A9 652D	# <CJK>
F8AA 66ED	# <CJK>
F8AB 66EE	# <CJK>
F8AC 6B13	# <CJK>
F8AD 705F	# <CJK>
F8AE 7061	# <CJK>
F8AF 705D	# <CJK>
F8B0 7060	# <CJK>
F8B1 7223	# <CJK>
F8B2 74DB	# <CJK>
F8B3 74E5	# <CJK>
F8B4 77D5	# <CJK>
F8B5 7938	# <CJK>
F8B6 79B7	# <CJK>
F8B7 79B6	# <CJK>
F8B8 7C6A	# <CJK>
F8B9 7E97	# <CJK>
F8BA 7F89	# <CJK>
F8BB 826D	# <CJK>
F8BC 8643	# <CJK>
F8BD 8838	# <CJK>
F8BE 8837	# <CJK>
F8BF 8835	# <CJK>
F8C0 884B	# <CJK>
F8C1 8B94	# <CJK>
F8C2 8B95	# <CJK>
F8C3 8E9E	# <CJK>
F8C4 8E9F	# <CJK>
F8C5 8EA0	# <CJK>
F8C6 8E9D	# <CJK>
F8C7 91BE	# <CJK>
F8C8 91BD	# <CJK>
F8C9 91C2	# <CJK>
F8CA 946B	# <CJK>
F8CB 9468	# <CJK>
F8CC 9469	# <CJK>
F8CD 96E5	# <CJK>
F8CE 9746	# <CJK>
F8CF 9743	# <CJK>
F8D0 9747	# <CJK>
F8D1 97C7	# <CJK>
F8D2 97E5	# <CJK>
F8D3 9A5E	# <CJK>
F8D4 9AD5	# <CJK>
F8D5 9B59	# <CJK>
F8D6 9C63	# <CJK>
F8D7 9C67	# <CJK>
F8D8 9C66	# <CJK>
F8D9 9C62	# <CJK>
F8DA 9C5E	# <CJK>
F8DB 9C60	# <CJK>
F8DC 9E02	# <CJK>
F8DD 9DFE	# <CJK>
F8DE 9E07	# <CJK>
F8DF 9E03	# <CJK>
F8E0 9E06	# <CJK>
F8E1 9E05	# <CJK>
F8E2 9E00	# <CJK>
F8E3 9E01	# <CJK>
F8E4 9E09	# <CJK>
F8E5 9DFF	# <CJK>
F8E6 9DFD	# <CJK>
F8E7 9E04	# <CJK>
F8E8 9EA0	# <CJK>
F8E9 9F1E	# <CJK>
F8EA 9F46	# <CJK>
F8EB 9F74	# <CJK>
F8EC 9F75	# <CJK>
F8ED 9F76	# <CJK>
F8EE 56D4	# <CJK>
F8EF 652E	# <CJK>
F8F0 65B8	# <CJK>
F8F1 6B18	# <CJK>
F8F2 6B19	# <CJK>
F8F3 6B17	# <CJK>
F8F4 6B1A	# <CJK>
F8F5 7062	# <CJK>
F8F6 7226	# <CJK>
F8F7 72AA	# <CJK>
F8F8 77D8	# <CJK>
F8F9 77D9	# <CJK>
F8FA 7939	# <CJK>
F8FB 7C69	# <CJK>
F8FC 7C6B	# <CJK>
F8FD 7CF6	# <CJK>
F8FE 7E9A	# <CJK>
F940 7E98	# <CJK>
F941 7E9B	# <CJK>
F942 7E99	# <CJK>
F943 81E0	# <CJK>
F944 81E1	# <CJK>
F945 8646	# <CJK>
F946 8647	# <CJK>
F947 8648	# <CJK>
F948 8979	# <CJK>
F949 897A	# <CJK>
F94A 897C	# <CJK>
F94B 897B	# <CJK>
F94C 89FF	# <CJK>
F94D 8B98	# <CJK>
F94E 8B99	# <CJK>
F94F 8EA5	# <CJK>
F950 8EA4	# <CJK>
F951 8EA3	# <CJK>
F952 946E	# <CJK>
F953 946D	# <CJK>
F954 946F	# <CJK>
F955 9471	# <CJK>
F956 9473	# <CJK>
F957 9749	# <CJK>
F958 9872	# <CJK>
F959 995F	# <CJK>
F95A 9C68	# <CJK>
F95B 9C6E	# <CJK>
F95C 9C6D	# <CJK>
F95D 9E0B	# <CJK>
F95E 9E0D	# <CJK>
F95F 9E10	# <CJK>
F960 9E0F	# <CJK>
F961 9E12	# <CJK>
F962 9E11	# <CJK>
F963 9EA1	# <CJK>
F964 9EF5	# <CJK>
F965 9F09	# <CJK>
F966 9F47	# <CJK>
F967 9F78	# <CJK>
F968 9F7B	# <CJK>
F969 9F7A	# <CJK>
F96A 9F79	# <CJK>
F96B 571E	# <CJK>
F96C 7066	# <CJK>
F96D 7C6F	# <CJK>
F96E 883C	# <CJK>
F96F 8DB2	# <CJK>
F970 8EA6	# <CJK>
F971 91C3	# <CJK>
F972 9474	# <CJK>
F973 9478	# <CJK>
F974 9476	# <CJK>
F975 9475	# <CJK>
F976 9A60	# <CJK>
F977 9C74	# <CJK>
F978 9C73	# <CJK>
F979 9C71	# <CJK>
F97A 9C75	# <CJK>
F97B 9E14	# <CJK>
F97C 9E13	# <CJK>
F97D 9EF6	# <CJK>
F97E 9F0A	# <CJK>
F9A1 9FA4	# <CJK>
F9A2 7068	# <CJK>
F9A3 7065	# <CJK>
F9A4 7CF7	# <CJK>
F9A5 866A	# <CJK>
F9A6 883E	# <CJK>
F9A7 883D	# <CJK>
F9A8 883F	# <CJK>
F9A9 8B9E	# <CJK>
F9AA 8C9C	# <CJK>
F9AB 8EA9	# <CJK>
F9AC 8EC9	# <CJK>
F9AD 974B	# <CJK>
F9AE 9873	# <CJK>
F9AF 9874	# <CJK>
F9B0 98CC	# <CJK>
F9B1 9961	# <CJK>
F9B2 99AB	# <CJK>
F9B3 9A64	# <CJK>
F9B4 9A66	# <CJK>
F9B5 9A67	# <CJK>
F9B6 9B24	# <CJK>
F9B7 9E15	# <CJK>
F9B8 9E17	# <CJK>
F9B9 9F48	# <CJK>
F9BA 6207	# <CJK>
F9BB 6B1E	# <CJK>
F9BC 7227	# <CJK>
F9BD 864C	# <CJK>
F9BE 8EA8	# <CJK>
F9BF 9482	# <CJK>
F9C0 9480	# <CJK>
F9C1 9481	# <CJK>
F9C2 9A69	# <CJK>
F9C3 9A68	# <CJK>
F9C4 9B2E	# <CJK>
F9C5 9E19	# <CJK>
F9C6 7229	# <CJK>
F9C7 864B	# <CJK>
F9C8 8B9F	# <CJK>
F9C9 9483	# <CJK>
F9CA 9C79	# <CJK>
F9CB 9EB7	# <CJK>
F9CC 7675	# <CJK>
F9CD 9A6B	# <CJK>
F9CE 9C7A	# <CJK>
F9CF 9E1D	# <CJK>
F9D0 7069	# <CJK>
F9D1 706A	# <CJK>
F9D2 9EA4	# <CJK>
F9D3 9F7E	# <CJK>
F9D4 9F49	# <CJK>
F9D5 9F98	# <CJK>
