/* $Id: hawki_variance.h,v 1.2 2009/03/13 11:52:14 cgarcia Exp $
 *
 * This file is part of the HAWKI Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2009/03/13 11:52:14 $
 * $Revision: 1.2 $
 * $Name: hawki-1_8_12 $
 */

#ifndef HAWKI_VARIANCE_H
#define HAWKI_VARIANCE_H

/*-----------------------------------------------------------------------------
   								Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
   							        Prototypes
 -----------------------------------------------------------------------------*/

cpl_image * hawki_image_create_variance
(const cpl_image * image,
 double            gain,
 double            ron,
 int               ndit,
 int               ndsamples);

cpl_imagelist * hawki_imglist_create_variances_and_delete
(cpl_imagelist * imagelist_raw, 
 double          gain,
 double          ron,
 int             ndit,
 int             ndsamples);

#endif
