## Contributing to Toolkit

We love contributors! Yes we do! If you would like to contribute to Toolkit, please follow the following guidelines:

* Please ensure you have [EditorConfig](http://editorconfig.org/) installed in your editor of choice to ensure our condig standards are being followed.
* Where possible, we would prefer to stay away from Ruby functionality. If something can be done entirely within Sass, it should be.
* With limited exception, such as where Toolkit expands upon the functionality in a way that is not contribute-able back upstream, additions should non mimic functionality provided by Compass, other [@import](https://github.com/at-import) extensions, or any included Compass extension. Currently included Compass extensions are [Breakpoint](https://github.com/at-import/breakpoint), [Singularity](https://github.com/at-import/Singularity), [Color Schemer](https://github.com/at-import/color-schemer), and [Sassy Strings](https://github.com/Snugug/Sassy-Strings).
* Toolkit is primarily a place for functionality, not components or UI elements.
* All functions and mixins that have defaulted arguments *must* provide globally configurable [settings](https://github.com/at-import/toolkit/blob/2.x.x/stylesheets/toolkit/_settings.scss) for their defaults instead of only having them inside the mixin definition. This provides users with a great deal more flexibility and makes the tools in Toolkit more useful.
* When writing mixins that have no required input arguments, such as the [Clearfix](https://github.com/at-import/toolkit/blob/2.x.x/stylesheets/toolkit/_clearfix.scss) mixin, also include sensible namespaced silent selectors to extend from, where applicable. When doing so, be sure to include an option in the mixin for using the extended version instead of writing the output of the mixin. This argument should be called `$extend` and, where appropriate, be defaulted to `true`.
* All mixins, where appropriate, should follow the [DRY mixin pattern](http://alistapart.com/article/dry-ing-out-your-sass-mixins). And example of this in practice is the [Intrinsic Ratio](https://github.com/at-import/toolkit/blob/2.x.x/stylesheets/toolkit/_intrinsic-ratio.scss) mixin.
* All new features require documentation in the README file in order for them to be considered for inclusion. Documentation should follow the existing documentation standard as used in the README file. 
* All new features require passing tests to be written. Features that break existing test or fail or provide their own tests will not be considered. 
* Each individual feature you would like to add, or bug you would like to squash, should be an individual pull request. Each pull request should be from an individual feature branch to either the latest stable or development branch. **The current *stable* branch is 1.x.x. The current *development* branch is 2.x.x**. Contributions that are not in the form of a pull request will not be considered. If your pull request does not apply cleanly we will ask you to fix that before we will look into pulling it in. We may ask you to update or make changes to the code you've submitted, please don't take this the wrong way. If a pull request smells (such as if a large amount of code is all within a single commit, or the coding standards aren't in line with core Toolkit) we may ask you to rewrite your commit.
