*
* $Id: e407m.F,v 1.1.1.1 1996/04/01 15:01:26 mclareni Exp $
*
* $Log: e407m.F,v $
* Revision 1.1.1.1  1996/04/01 15:01:26  mclareni
* Mathlib gen
*
*
#include "gen/pilot.h"
      SUBROUTINE E407M
C     Routine to test the MATHLIB routines CHECF and DCHECF (E406)
C     Summation of Chebyshev Series.

#include "gen/imp64.inc"
      DIMENSION X(4),C(0:33,4),N(4)

      COMMON/ER/ERRMAX
#include "iorc.inc"

      DATA X /-0.5D0,0.3D0,-0.9D0,0.1D0/, N /20,31,30,33/
      DATA TSTERR/1D-14/

C     COEFF FOR EXP(X)  -1 <= X <= +1,  ...SUM C(N)T(N)(X)

      DATA C( 0,1) /1.2660658777520083355982446D0/
      DATA C( 1,1) /1.1303182079849700544153921D0/
      DATA C( 2,1) / .2714953395340765623657051D0/
      DATA C( 3,1) / .0443368498486638049525715D0/
      DATA C( 4,1) / .0054742404420937326502762D0/
      DATA C( 5,1) / .0005429263119139437503621D0/
      DATA C( 6,1) / .0000449773229542951466547D0/
      DATA C( 7,1) / .0000031984364624019905059D0/
      DATA C( 8,1) / .0000001992124806672795726D0/
      DATA C( 9,1) / .0000000110367717255173443D0/
      DATA C(10,1) / .0000000005505896079673747D0/
      DATA C(11,1) / .0000000000249795661698498D0/
      DATA C(12,1) / .0000000000010391522306786D0/
      DATA C(13,1) / .0000000000000399126335641D0/
      DATA C(14,1) / .0000000000000014237580108D0/
      DATA C(15,1) / .0000000000000000474092610D0/
      DATA C(16,1) / .0000000000000000014801801D0/
      DATA C(17,1) / .0000000000000000000434992D0/
      DATA C(18,1) / .0000000000000000000012074D0/
      DATA C(19,1) / .0000000000000000000000318D0/
      DATA C(20,1) / .0000000000000000000000008D0/

C     COEFF FOR ARCTAN(X)/X   -1 <= X <= +1,  ...SUM C(N)T(2N)(X)

      DATA C( 0,2) / .8813735870195430252326093D0/
      DATA C( 1,2) /-.1058929245467058552584637D0/
      DATA C( 2,2) / .0111358420594055299138723D0/
      DATA C( 3,2) /-.0013811950036003977146939D0/
      DATA C( 4,2) / .0001857429732785420087542D0/
      DATA C( 5,2) /-.0000262151961127332694683D0/
      DATA C( 6,2) / .0000038210365944894531171D0/
      DATA C( 7,2) /-.0000005699186166576665323D0/
      DATA C( 8,2) / .0000000864887786445082819D0/
      DATA C( 9,2) /-.0000000133033839756249329D0/
      DATA C(10,2) / .0000000020685057635866255D0/
      DATA C(11,2) /-.0000000003244863920937630D0/
      DATA C(12,2) / .0000000000512796625558139D0/
      DATA C(13,2) /-.0000000000081547875603392D0/
      DATA C(14,2) / .0000000000013038071918812D0/
      DATA C(15,2) /-.0000000000002094297848694D0/
      DATA C(16,2) / .0000000000000337782083636D0/
      DATA C(17,2) /-.0000000000000054676499774D0/
      DATA C(18,2) / .0000000000000008878874409D0/
      DATA C(19,2) /-.0000000000000001445980916D0/
      DATA C(20,2) / .0000000000000000236097132D0/
      DATA C(21,2) /-.0000000000000000038639904D0/
      DATA C(22,2) / .0000000000000000006337335D0/
      DATA C(23,2) /-.0000000000000000001041412D0/
      DATA C(24,2) / .0000000000000000000171441D0/
      DATA C(25,2) /-.0000000000000000000028270D0/
      DATA C(26,2) / .0000000000000000000004669D0/
      DATA C(27,2) /-.0000000000000000000000772D0/
      DATA C(28,2) / .0000000000000000000000128D0/
      DATA C(29,2) /-.0000000000000000000000021D0/
      DATA C(30,2) / .0000000000000000000000004D0/
      DATA C(31,2) /-.0000000000000000000000001D0/

C     COEFF FOR  ARCTAN(X)   -1 <= X <= +1, ...SUM C(N)T(2N+1)(X)

      DATA C( 0,3) / .8284271247461900976033775D0/
      DATA C( 1,3) /-.0473785412436501626722957D0/
      DATA C( 2,3) / .0048773235279025660995892D0/
      DATA C( 3,3) /-.0005977260151609278529698D0/
      DATA C( 4,3) / .0000797638885829043696430D0/
      DATA C( 5,3) /-.0000111970797591219081756D0/
      DATA C( 6,3) / .0000016255589889158932924D0/
      DATA C( 7,3) /-.0000002417149190065791252D0/
      DATA C( 8,3) / .0000000365926973344416745D0/
      DATA C( 9,3) /-.0000000056174391060191537D0/
      DATA C(10,3) / .0000000008720096857464312D0/
      DATA C(11,3) /-.0000000001366033647689746D0/
      DATA C(12,3) / .0000000000215624374977373D0/
      DATA C(13,3) /-.0000000000034254901842290D0/
      DATA C(14,3) / .0000000000005471887035059D0/
      DATA C(15,3) /-.0000000000000878257882529D0/
      DATA C(16,3) / .0000000000000141552791931D0/
      DATA C(17,3) /-.0000000000000022898812683D0/
      DATA C(18,3) / .0000000000000003716446746D0/
      DATA C(19,3) /-.0000000000000000604941892D0/
      DATA C(20,3) / .0000000000000000098728614D0/
      DATA C(21,3) /-.0000000000000000016151285D0/
      DATA C(22,3) / .0000000000000000002647961D0/
      DATA C(23,3) /-.0000000000000000000434986D0/
      DATA C(24,3) / .0000000000000000000071586D0/
      DATA C(25,3) /-.0000000000000000000011800D0/
      DATA C(26,3) / .0000000000000000000001948D0/
      DATA C(27,3) /-.0000000000000000000000322D0/
      DATA C(28,3) / .0000000000000000000000053D0/
      DATA C(29,3) /-.0000000000000000000000009D0/
      DATA C(30,3) / .0000000000000000000000001D0/

C     COEFF FOR 1/(1 + X)    0 <= X <= +1,   ...SUM C(N)T*(N)(X)

      DATA C( 0,4) / .7071067811865475244008444D0/
      DATA C( 1,4) /-.2426406871192851464050662D0/
      DATA C( 2,4) / .0416305603426158296287083D0/
      DATA C( 3,4) /-.0071426749364098313671837D0/
      DATA C( 4,4) / .0012254892758431585743939D0/
      DATA C( 5,4) /-.0002102607186491200791795D0/
      DATA C( 6,4) / .0000360750360515619006832D0/
      DATA C( 7,4) /-.0000061894976602513249199D0/
      DATA C( 8,4) / .0000010619499099460488361D0/
      DATA C( 9,4) /-.0000001822017994249680967D0/
      DATA C(10,4) / .0000000312608866037597441D0/
      DATA C(11,4) /-.0000000053635201975903677D0/
      DATA C(12,4) / .0000000009202345817824620D0/
      DATA C(13,4) /-.0000000001578872931044043D0/
      DATA C(14,4) / .0000000000270891768439637D0/
      DATA C(15,4) /-.0000000000046477679593778D0/
      DATA C(16,4) / .0000000000007974309123030D0/
      DATA C(17,4) /-.0000000000001368175144401D0/
      DATA C(18,4) / .0000000000000234741743376D0/
      DATA C(19,4) /-.0000000000000040275315853D0/
      DATA C(20,4) / .0000000000000006910151743D0/
      DATA C(21,4) /-.0000000000000001185594603D0/
      DATA C(22,4) / .0000000000000000203415875D0/
      DATA C(23,4) /-.0000000000000000034900647D0/
      DATA C(24,4) / .0000000000000000005988004D0/
      DATA C(25,4) /-.0000000000000000001027379D0/
      DATA C(26,4) / .0000000000000000000176270D0/
      DATA C(27,4) /-.0000000000000000000030243D0/
      DATA C(28,4) / .0000000000000000000005189D0/
      DATA C(29,4) /-.0000000000000000000000890D0/
      DATA C(30,4) / .0000000000000000000000153D0/
      DATA C(31,4) /-.0000000000000000000000026D0/
      DATA C(32,4) / .0000000000000000000000005D0/
      DATA C(33,4) /-.0000000000000000000000001D0/

      CALL HEADER('E407',0)
C     Initialise largest error
      ERRMAX=0D0
#if defined(CERNLIB_DOUBLE)
      WRITE(LOUT,'(/9X,''X'',19X,''DCHSUM'',34X,''TEST'',11X,
     +''Error'')')
#endif
#if !defined(CERNLIB_DOUBLE)
      WRITE(LOUT,'(/9X,''X'',19X,'' CHSUM'',34X,''TEST'',11X,
     +''Error'')')
#endif
      CALL TE407(X,N,C)
      WRITE(LOUT,'(/'' Largest Error was'',1P,D10.1)') ERRMAX
C     Check if the test was successful
      IRC=ITEST('E407',ERRMAX .LE. TSTERR)
      CALL PAGEND('E407')
      RETURN
      END
      SUBROUTINE TE407(X,N,C)
#include "gen/imp64.inc"
      DIMENSION X(4),C(0:33,4),N(4)
      COMMON/ER/ERRMAX
#include "iorc.inc"
#if defined(CERNLIB_DOUBLE)
      R=DCHSUM(1,C(0,1),N(1),X(1))
#endif
#if !defined(CERNLIB_DOUBLE)
      R= CHSUM(1,C(0,1),N(1),X(1))
#endif
      T=EXP(X(1))
      ERRMAX=MAX(ERRMAX,ABS(R-T))
      WRITE(LOUT,100) X(1),R,T,R-T
#if defined(CERNLIB_DOUBLE)
      R=DCHSUM(2,C(0,2),N(2),X(2))
#endif
#if !defined(CERNLIB_DOUBLE)
      R= CHSUM(2,C(0,2),N(2),X(2))
#endif
      T=ATAN(X(2))/X(2)
      ERRMAX=MAX(ERRMAX,ABS(R-T))
      WRITE(LOUT,100) X(2),R,T,R-T
#if defined(CERNLIB_DOUBLE)
      R=DCHSUM(3,C(0,3),N(3),X(3))
#endif
#if !defined(CERNLIB_DOUBLE)
      R= CHSUM(3,C(0,3),N(3),X(3))
#endif
      T=ATAN(X(3))
      ERRMAX=MAX(ERRMAX,ABS(R-T))
      WRITE(LOUT,100) X(3),R,T,R-T
#if defined(CERNLIB_DOUBLE)
      R=DCHSUM(4,C(0,4),N(4),X(4))
#endif
#if !defined(CERNLIB_DOUBLE)
      R= CHSUM(4,C(0,4),N(4),X(4))
#endif
      T=1/(1+X(4))
      ERRMAX=MAX(ERRMAX,ABS(R-T))
      WRITE(LOUT,100) X(4),R,T,R-T
  100 FORMAT(1X,F10.1,2F35.25,1P,D10.1/)
      END
