/*
 * X11 interface for Atom-4 game board
 * Header file
 *
 * $Id: xtriboard.h,v 1.14 2003/03/12 04:09:55 hsteoh Exp hsteoh $
 */

#ifndef XTRIBOARD_H
#define XTRIBOARD_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "game.h"
#include "triboard.h"

#include "xcursor.h"
#include "xsprite.h"
#include "xutil.h"

#define CELL_WIDTH	24
#define CELL_HEIGHT	21

#define NUM_BALLS	8


class xtriboard : public xwindow {
  int cell_wd, cell_dp;			// dimensions (in cells)
  xsprite_engine *eng;			// [R]

  Pixmap buffer;			// drawing buffer
  tiled_bckgnd *tritile;		// tiled background

  // FIXME: this should be moved to class XAtom4
  static char *ballnames[NUM_BALLS];
  xflatsprite *balls[8];

  // Auto-positioning cursor
  xcursor *cursor;

  // TESTING: ideally, this should be done in class xatom4
  atom4 *game;				// [R]

  // Cell coordinate calculations
  inline int real_xcoor(int x, int y) {
    return x*CELL_WIDTH + (y%2+1)*CELL_WIDTH/2;
  }
  inline int real_ycoor(int x, int y) {
    return (y+1)*CELL_HEIGHT;
  }
  inline void draw_at(int x, int y, xflatsprite *spr) {
    spr->draw(buffer, real_xcoor(x,y), real_ycoor(x,y));
  }

  // compute board coors from scrn coors
  static void drawcell(int bx, int by, celltype cell, void *context);
public:
  // Note: width, depth are in units of cells.
  xtriboard(xconnection *conn, xsprite_engine *eng, xwindow *parent,
            atom4 *game, int x, int y);
  ~xtriboard();

  // Convert screen coors to board coors
  void calc_bcoor(int rx, int ry, int &bx, int &by);
  void cursor_on()  { cursor->on(); }
  void cursor_off() { cursor->off(); }
  void set_cursor(celltype tile) { cursor->set_sprite(balls[tile-'a']); }

  // Maintenance
  void refresh();

  // Event handlers
  void expose(XExposeEvent ev);
  void mouse_enter(XEnterWindowEvent ev);
  void mouse_leave(XLeaveWindowEvent ev);
  void mouse_move(XMotionEvent ev);
};


#endif // XTRIBOARD_H
