/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

package installer;

import java.awt.event.*;
import java.util.*;
import javax.swing.*;

public class IdeFinal extends javax.swing.JPanel implements ActionListener, InstallListener {

    /** Creates new form Welcome */
    public IdeFinal(InstallWizard wizard) {
        this.wizard = wizard;
        setBackground(java.awt.Color.white);
    ideupdater = null;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        statusPanel = new javax.swing.JPanel();
    statusPanel.setBackground(java.awt.Color.white);
        statusLine = new javax.swing.JLabel("Ready", javax.swing.JLabel.CENTER);

        setLayout(new java.awt.BorderLayout());

        statusPanel.setLayout(new java.awt.BorderLayout());

        statusLine.setText("Waiting to install IDE support.");
        statusPanel.add(statusLine, java.awt.BorderLayout.CENTER);

        add(statusPanel, java.awt.BorderLayout.CENTER);
    nav = new NavPanel(wizard, true, true, true, InstallWizard.IDEVERSIONS, "");
    nav.setNextListener(this);
    nav.removeCancelListener(nav);
    nav.setCancelListener(this);
    nav.navNext.setText("Install");
    add(nav, java.awt.BorderLayout.SOUTH);
    }//GEN-END:initComponents

    public java.awt.Dimension getPreferredSize() {
        return new java.awt.Dimension(InstallWizard.DEFWIDTH, InstallWizard.DEFHEIGHT);
    }

    public void actionPerformed(ActionEvent e) {
    // navNext is "Install"
        if (e.getSource() == nav.navNext)
    {
            JProgressBar progressBar=new JProgressBar();
            progressBar.setMaximum(10);
            progressBar.setValue(0);
            statusPanel.add(progressBar, java.awt.BorderLayout.SOUTH);
            nav.enableNext(false);
            nav.enableBack(false);
            nav.enableCancel(false);
            ArrayList<?> locations = InstallWizard.getLocations();
            //System.out.println("here "+locations.size());
            // Returned 1
            String progpath=null;
            String path=null;
            String classespath=null;
            for (int i =0;i<locations.size();i++){
                path= (String)locations.get(i);

            //InstallWizard.currentPath = path;
            ideupdater = new IdeUpdater( path, statusLine, progressBar );
        ideupdater.addInstallListener(this);
        InstallWizard.setInstallStarted(true);
        //InstallWizard.setPatchedTypes(false);
        //InstallWizard.setPatchedJava(false);
        //InstallWizard.setPatchedRDB(false);
        ideupdater.start();
            }
        }

    // set to "Exit" at end of installation process
    if (e.getSource() == nav.navCancel) {
        int answer = JOptionPane.showConfirmDialog(wizard, "Are you sure you want to exit?");
        if (answer == JOptionPane.YES_OPTION)
        {
            wizard.exitForm(null);
        }
        else
        {
            return;
        }
    }
    }// actionPerformed


    public void installationComplete(InstallationEvent ev) {
        //System.out.println("Detected installation complete");
    //if( InstUtil.hasNetbeansInstallation() || InstUtil.hasJeditInstallation() ) {
        //System.out.println("Detected installation complete (IDE(s) detected)");
        nav.removeCancelListener(this);
        nav.setCancelListener(nav);
        nav.navCancel.setText("Finish");
        nav.enableCancel(true);
        ideupdater = null;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel statusPanel;
    private javax.swing.JLabel statusLine;
    private InstallWizard wizard;
    private NavPanel nav;
    //private XmlUpdater xud;
    private IdeUpdater ideupdater;
    // End of variables declaration//GEN-END:variables

}
