/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import groovy.lang.GroovyObject;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.callsite.AbstractCallSite;
import org.codehaus.groovy.vmplugin.v8.CacheableCallSite;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.InstrumentedClosuresHelper;
import org.gradle.internal.classpath.InstrumentedGroovyCallsHelper;
import org.gradle.internal.classpath.InstrumentedGroovyCallsTracker;
import org.gradle.internal.classpath.intercept.CallInterceptorResolver;
import org.gradle.internal.classpath.intercept.CallSiteDecorator;
import org.gradle.internal.instrumentation.api.groovybytecode.AbstractCallInterceptor;
import org.gradle.internal.instrumentation.api.groovybytecode.CallInterceptor;
import org.gradle.internal.instrumentation.api.groovybytecode.CompositeCallInterceptor;
import org.gradle.internal.instrumentation.api.groovybytecode.InterceptScope;
import org.gradle.internal.instrumentation.api.groovybytecode.Invocation;
import org.gradle.internal.instrumentation.api.groovybytecode.InvocationImpl;

@NonNullApi
public class DefaultCallSiteDecorator
implements CallSiteDecorator,
CallInterceptorResolver {
    private static final MethodHandle MAYBE_INSTRUMENTED_DYNAMIC_CALL_MH;
    private final Map<InterceptScope, CallInterceptor> interceptors = new HashMap<InterceptScope, CallInterceptor>();
    private final Set<String> interceptedCallSiteNames = new HashSet<String>();
    private final CallInterceptor dispatchingConstructorInterceptor = new AbstractCallInterceptor(new InterceptScope[0]){

        @Nullable
        public Object intercept(Invocation invocation, String consumer) throws Throwable {
            CallInterceptor realConstructorInterceptor;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof Class && (realConstructorInterceptor = (CallInterceptor)DefaultCallSiteDecorator.this.interceptors.get(InterceptScope.constructorsOf((Class)((Class)receiver)))) != null) {
                return realConstructorInterceptor.intercept(invocation, consumer);
            }
            return invocation.callNext();
        }
    };

    public DefaultCallSiteDecorator(List<CallInterceptor> callInterceptors) {
        callInterceptors.forEach(this::addInterceptor);
    }

    private void addInterceptor(CallInterceptor interceptor) {
        for (InterceptScope scope : interceptor.getInterceptScopes()) {
            this.interceptors.compute(scope, (__, previous) -> previous == null ? interceptor : new CompositeCallInterceptor(previous, interceptor));
            this.interceptedCallSiteNames.add(scope.getCallSiteName());
        }
    }

    @Override
    public CallSite maybeDecorateIndyCallSite(CallSite originalCallSite, MethodHandles.Lookup caller, String callType, String name, int flags) {
        CacheableCallSite ccs = DefaultCallSiteDecorator.toGroovyCacheableCallSite(originalCallSite);
        switch (callType) {
            case "invoke": {
                this.maybeApplyInterceptor(ccs, caller, InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD, name, flags, this.interceptors.get(InterceptScope.methodsNamed((String)name)));
                break;
            }
            case "getProperty": {
                this.maybeApplyInterceptor(ccs, caller, InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY, name, flags, this.interceptors.get(InterceptScope.readsOfPropertiesNamed((String)name)));
                break;
            }
            case "init": {
                this.maybeApplyInterceptor(ccs, caller, null, name, flags, this.dispatchingConstructorInterceptor);
            }
        }
        return ccs;
    }

    private void maybeApplyInterceptor(CacheableCallSite cs, MethodHandles.Lookup caller, @Nullable InstrumentedGroovyCallsTracker.CallKind callKind, String name, int flags, @Nullable CallInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        MethodHandle defaultTarget = cs.getDefaultTarget();
        if (callKind != null) {
            defaultTarget = this.addHitInstrumentedDynamicCall(defaultTarget, caller, callKind, name);
        }
        defaultTarget = interceptor.decorateMethodHandle(defaultTarget, caller, flags);
        MethodHandle fallbackTarget = cs.getFallbackTarget();
        if (callKind != null) {
            fallbackTarget = this.addHitInstrumentedDynamicCall(fallbackTarget, caller, callKind, name);
        }
        fallbackTarget = interceptor.decorateMethodHandle(fallbackTarget, caller, flags);
        cs.setTarget(defaultTarget);
        cs.setDefaultTarget(defaultTarget);
        cs.setFallbackTarget(fallbackTarget);
    }

    private MethodHandle addHitInstrumentedDynamicCall(MethodHandle methodHandle, MethodHandles.Lookup caller, InstrumentedGroovyCallsTracker.CallKind callKind, String name) {
        return MethodHandles.insertArguments(MAYBE_INSTRUMENTED_DYNAMIC_CALL_MH, 0, new Object[]{this.interceptedCallSiteNames, caller.lookupClass().getName(), name, callKind, methodHandle}).asVarargsCollector(Object[].class).asType(methodHandle.type());
    }

    @Nullable
    private static Object maybeInstrumentedDynamicCallViaMethodHandle(Set<String> interceptedCallSiteNames, String callerClassName, String callSiteName, InstrumentedGroovyCallsTracker.CallKind kind, MethodHandle delegate, Object[] delegateArgs) throws Throwable {
        if (interceptedCallSiteNames.contains(callSiteName)) {
            InstrumentedClosuresHelper.INSTANCE.hitInstrumentedDynamicCall();
            return InstrumentedGroovyCallsHelper.withEntryPoint(callerClassName, callSiteName, kind, () -> delegate.invokeWithArguments(delegateArgs));
        }
        return delegate.invokeWithArguments(delegateArgs);
    }

    private static CacheableCallSite toGroovyCacheableCallSite(CallSite cs) {
        if (!(cs instanceof CacheableCallSite)) {
            throw new GradleException("Groovy produced unrecognized call site type of " + cs.getClass());
        }
        return (CacheableCallSite)cs;
    }

    @Override
    public org.codehaus.groovy.runtime.callsite.CallSite maybeDecorateGroovyCallSite(org.codehaus.groovy.runtime.callsite.CallSite originalCallSite) {
        if (this.shouldDecorate(originalCallSite)) {
            return new DecoratingCallSite(originalCallSite);
        }
        return originalCallSite;
    }

    private boolean shouldDecorate(org.codehaus.groovy.runtime.callsite.CallSite callSite) {
        return this.interceptedCallSiteNames.contains(callSite.getName());
    }

    @Override
    @Nullable
    public CallInterceptor resolveCallInterceptor(InterceptScope scope) {
        return this.interceptors.get(scope);
    }

    @Override
    public boolean isAwareOfCallSiteName(String name) {
        return this.interceptedCallSiteNames.contains(name);
    }

    static {
        String name = "maybeInstrumentedDynamicCallViaMethodHandle";
        try {
            MAYBE_INSTRUMENTED_DYNAMIC_CALL_MH = MethodHandles.lookup().findStatic(DefaultCallSiteDecorator.class, name, MethodType.methodType(Object.class, Set.class, String.class, String.class, InstrumentedGroovyCallsTracker.CallKind.class, MethodHandle.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("failed to link " + name, e);
        }
    }

    private class DecoratingCallSite
    extends AbstractCallSite {
        @Nullable
        private org.codehaus.groovy.runtime.callsite.CallSite groovyDefaultCallSite;

        public DecoratingCallSite(org.codehaus.groovy.runtime.callsite.CallSite prev) {
            super(prev);
            this.groovyDefaultCallSite = null;
        }

        @Nullable
        public Object call(Object receiver, Object[] args) throws Throwable {
            CallInterceptor interceptor = DefaultCallSiteDecorator.this.resolveCallInterceptor(InterceptScope.methodsNamed((String)this.getName()));
            if (interceptor != null) {
                return interceptor.intercept((Invocation)new InvocationImpl(receiver, args, () -> super.call(receiver, args)), this.callSiteOwnerClassName());
            }
            return super.call(receiver, args);
        }

        @Nullable
        public Object callStatic(Class receiver, Object[] args) throws Throwable {
            CallInterceptor interceptor = DefaultCallSiteDecorator.this.resolveCallInterceptor(InterceptScope.methodsNamed((String)this.getName()));
            if (interceptor != null) {
                return interceptor.intercept((Invocation)new InvocationImpl((Object)receiver, args, () -> super.callStatic(receiver, args)), this.callSiteOwnerClassName());
            }
            return super.callStatic(receiver, args);
        }

        @Nullable
        public Object callConstructor(Object receiver, Object[] args) throws Throwable {
            return DefaultCallSiteDecorator.this.dispatchingConstructorInterceptor.intercept((Invocation)new InvocationImpl(receiver, args, () -> super.callConstructor(receiver, args)), this.callSiteOwnerClassName());
        }

        @Nullable
        private Object maybeInstrumentedDynamicCall(CallStrategy callStrategy, Object receiver, @Nullable Object[] args) throws Throwable {
            if (DefaultCallSiteDecorator.this.interceptedCallSiteNames.contains(this.getName())) {
                InstrumentedGroovyCallsTracker.CallKind kind = callStrategy == CallStrategy.CALL_CURRENT ? InstrumentedGroovyCallsTracker.CallKind.INVOKE_METHOD : InstrumentedGroovyCallsTracker.CallKind.GET_PROPERTY;
                InstrumentedClosuresHelper.INSTANCE.hitInstrumentedDynamicCall();
                return InstrumentedGroovyCallsHelper.withEntryPoint(this.callSiteOwnerClassName(), this.getName(), kind, () -> this.invokeDefaultGroovyCallSiteImplementation(receiver, args, callStrategy));
            }
            if (callStrategy == CallStrategy.CALL_CURRENT) {
                return super.callCurrent((GroovyObject)receiver, args);
            }
            return super.callGroovyObjectGetProperty(receiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object invokeDefaultGroovyCallSiteImplementation(Object receiver, @Nullable Object[] args, CallStrategy callStrategy) throws Throwable {
            assert (this.groovyDefaultCallSite != this);
            switch (callStrategy) {
                case CALL_CURRENT: {
                    if (this.groovyDefaultCallSite != null) {
                        return this.groovyDefaultCallSite.callCurrent((GroovyObject)receiver, args);
                    }
                    try {
                        Object object = super.callCurrent((GroovyObject)receiver, args);
                        return object;
                    }
                    finally {
                        this.restoreCallSiteArrayEntry();
                    }
                }
                case CALL_GROOVY_OBJECT_GET_PROPERTY: {
                    if (this.groovyDefaultCallSite != null) {
                        return this.groovyDefaultCallSite.callGroovyObjectGetProperty(receiver);
                    }
                    try {
                        Object object = super.callGroovyObjectGetProperty(receiver);
                        return object;
                    }
                    finally {
                        this.restoreCallSiteArrayEntry();
                    }
                }
                case CALL_GET_PROPERTY: {
                    if (this.groovyDefaultCallSite != null) {
                        return this.groovyDefaultCallSite.callGetProperty(receiver);
                    }
                    try {
                        Object object = super.callGetProperty(receiver);
                        return object;
                    }
                    finally {
                        this.restoreCallSiteArrayEntry();
                    }
                }
            }
            throw new IllegalArgumentException("Unexpected callStrategy " + (Object)((Object)callStrategy));
        }

        private void restoreCallSiteArrayEntry() {
            org.codehaus.groovy.runtime.callsite.CallSite callSiteInArrayAfterCall = this.array.array[this.index];
            if (callSiteInArrayAfterCall != this) {
                this.groovyDefaultCallSite = callSiteInArrayAfterCall;
            }
            this.array.array[this.index] = this;
        }

        @Nullable
        public Object callGetProperty(Object receiver) throws Throwable {
            CallInterceptor interceptor = DefaultCallSiteDecorator.this.resolveCallInterceptor(InterceptScope.readsOfPropertiesNamed((String)this.getName()));
            if (interceptor != null) {
                return interceptor.intercept((Invocation)new InvocationImpl(receiver, new Object[0], () -> this.maybeInstrumentedDynamicCall(CallStrategy.CALL_GET_PROPERTY, receiver, null)), this.callSiteOwnerClassName());
            }
            return this.maybeInstrumentedDynamicCall(CallStrategy.CALL_GET_PROPERTY, receiver, null);
        }

        @Nullable
        public Object callGroovyObjectGetProperty(Object receiver) throws Throwable {
            return this.maybeInstrumentedDynamicCall(CallStrategy.CALL_GROOVY_OBJECT_GET_PROPERTY, receiver, null);
        }

        @Nullable
        public Object callCurrent(GroovyObject receiver, Object[] args) throws Throwable {
            return this.maybeInstrumentedDynamicCall(CallStrategy.CALL_CURRENT, receiver, args);
        }

        private String callSiteOwnerClassName() {
            return this.array.owner.getName();
        }
    }

    @NonNullApi
    static enum CallStrategy {
        CALL_CURRENT,
        CALL_GET_PROPERTY,
        CALL_GROOVY_OBJECT_GET_PROPERTY;

    }
}

