/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.transaction;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Deleter;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(CompileTransaction.class);
    private final Deleter deleter;
    private final FileOperations fileOperations;
    private final PatternSet classesToDelete;
    private final JavaCompileSpec spec;
    private final Map<GeneratedResource.Location, PatternSet> resourcesToDelete;
    private final File stashDirectory;
    private final File tempDir;
    private final File backupDirectory;

    public CompileTransaction(JavaCompileSpec spec, PatternSet classesToDelete, Map<GeneratedResource.Location, PatternSet> resourcesToDelete, FileOperations fileOperations, Deleter deleter) {
        this.spec = spec;
        this.tempDir = new File(spec.getTempDir(), "compileTransaction");
        this.stashDirectory = new File(this.tempDir, "stash-dir");
        this.backupDirectory = new File(this.tempDir, "backup-dir");
        this.classesToDelete = classesToDelete;
        this.resourcesToDelete = resourcesToDelete;
        this.fileOperations = fileOperations;
        this.deleter = deleter;
    }

    public <T> T execute(Function<WorkResult, T> function) {
        this.ensureEmptyDirectoriesBeforeExecution();
        List<StashedFile> stashedFiles = this.stashFilesThatShouldBeDeleted();
        try {
            if (this.supportsIncrementalCompilationAfterFailure()) {
                this.spec.setClassBackupDir(this.backupDirectory);
            }
            T result = function.apply(WorkResults.didWork((!stashedFiles.isEmpty() ? 1 : 0) != 0));
            this.deleteEmptyDirectoriesAfterCompilation(stashedFiles);
            return result;
        }
        catch (CompilationFailedException e) {
            if (this.supportsIncrementalCompilationAfterFailure()) {
                this.rollback(stashedFiles, e.getCompilerPartialResult().orElse(null));
            }
            throw e;
        }
    }

    private boolean supportsIncrementalCompilationAfterFailure() {
        return this.spec.getCompileOptions().supportsIncrementalCompilationAfterFailure();
    }

    private void ensureEmptyDirectoriesBeforeExecution() {
        try {
            this.tempDir.mkdirs();
            HashSet<File> ensureEmptyDirectories = new HashSet<File>();
            this.deleter.ensureEmptyDirectory(this.stashDirectory);
            ensureEmptyDirectories.add(this.stashDirectory);
            this.deleter.ensureEmptyDirectory(this.backupDirectory);
            ensureEmptyDirectories.add(this.backupDirectory);
            try (Stream<Path> dirStream = Files.list(this.tempDir.toPath());){
                dirStream.map(Path::toFile).filter(file -> !ensureEmptyDirectories.contains(file)).forEach(this::deleteRecursively);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void deleteRecursively(File file) {
        try {
            this.deleter.deleteRecursively(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private List<StashedFile> stashFilesThatShouldBeDeleted() {
        int uniqueId = 0;
        ArrayList<StashedFile> stashedFiles = new ArrayList<StashedFile>();
        for (File fileToDelete : this.collectFilesToDelete(this.classesToDelete, this.resourcesToDelete)) {
            File stashedFile = new File(this.stashDirectory, fileToDelete.getName() + ".uniqueId" + uniqueId++);
            CompileTransaction.moveFile(fileToDelete, stashedFile);
            stashedFiles.add(new StashedFile(fileToDelete, stashedFile));
        }
        return stashedFiles;
    }

    private void deleteEmptyDirectoriesAfterCompilation(List<StashedFile> stashedFiles) {
        ImmutableSet<File> outputDirectories = this.getOutputDirectories();
        Set potentiallyEmptyFolders = stashedFiles.stream().map(file -> ((StashedFile)file).sourceFile.getParentFile()).collect(Collectors.toSet());
        StaleOutputCleaner.cleanEmptyOutputDirectories((Deleter)this.deleter, potentiallyEmptyFolders, outputDirectories);
    }

    private void rollback(List<StashedFile> stashResult, @Nullable ApiCompilerResult compilerResult) {
        if (compilerResult != null) {
            this.deleteGeneratedFiles(compilerResult);
            CompileTransaction.rollbackOverwrittenFiles(compilerResult);
        }
        CompileTransaction.rollbackStashedFiles(stashResult);
    }

    private void deleteGeneratedFiles(ApiCompilerResult compilerResult) {
        PatternSet classesToDelete = this.getNewGeneratedClasses(compilerResult);
        Map<GeneratedResource.Location, PatternSet> resourcesToDelete = this.getNewGeneratedResources(compilerResult);
        Set<File> filesToDelete = this.collectFilesToDelete(classesToDelete, resourcesToDelete);
        StaleOutputCleaner.cleanOutputs((Deleter)this.deleter, filesToDelete, this.getOutputDirectories());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting generated files: {}", filesToDelete.stream().sorted().collect(Collectors.toList()));
        }
    }

    private PatternSet getNewGeneratedClasses(ApiCompilerResult result) {
        PatternSet filesToDelete = this.fileOperations.patternSet();
        result.getSourceClassesMapping().values().stream().flatMap(Collection::stream).forEach(className -> {
            filesToDelete.include(new String[]{className.replace(".", "/").concat(".class")});
            filesToDelete.include(new String[]{className.replaceAll("[.$]", "_").concat(".h")});
        });
        HashSet<String> annotationProcessorTypes = new HashSet<String>(result.getAnnotationProcessingResult().getGeneratedAggregatingTypes());
        result.getAnnotationProcessingResult().getGeneratedTypesWithIsolatedOrigin().values().stream().flatMap(Collection::stream).forEach(annotationProcessorTypes::add);
        annotationProcessorTypes.forEach(className -> {
            filesToDelete.include(new String[]{className.replace(".", "/").concat(".class")});
            filesToDelete.include(new String[]{className.replaceAll("[.$]", "_").concat(".h")});
            filesToDelete.include(new String[]{className.replace(".", "/").concat(".java")});
        });
        return filesToDelete;
    }

    private Map<GeneratedResource.Location, PatternSet> getNewGeneratedResources(ApiCompilerResult result) {
        EnumMap<GeneratedResource.Location, PatternSet> resourcesByLocation = new EnumMap<GeneratedResource.Location, PatternSet>(GeneratedResource.Location.class);
        Stream.of(GeneratedResource.Location.values()).forEach(location -> resourcesByLocation.put((GeneratedResource.Location)((Object)location), this.fileOperations.patternSet()));
        result.getAnnotationProcessingResult().getGeneratedAggregatingResources().forEach(resource -> ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(new String[]{resource.getPath()}));
        result.getAnnotationProcessingResult().getGeneratedResourcesWithIsolatedOrigin().values().stream().flatMap(Collection::stream).forEach(resource -> ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(new String[]{resource.getPath()}));
        return resourcesByLocation;
    }

    private Set<File> collectFilesToDelete(PatternSet classesToDelete, Map<GeneratedResource.Location, PatternSet> resourcesToDelete) {
        File compileOutput = this.spec.getDestinationDir();
        File annotationProcessorOutput = this.spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory();
        File headerOutput = this.spec.getCompileOptions().getHeaderOutputDirectory();
        HashSet<File> filesToDelete = new HashSet<File>();
        filesToDelete.addAll(this.collectFilesToDelete(classesToDelete, compileOutput));
        filesToDelete.addAll(this.collectFilesToDelete(classesToDelete, annotationProcessorOutput));
        filesToDelete.addAll(this.collectFilesToDelete(classesToDelete, headerOutput));
        filesToDelete.addAll(this.collectFilesToDelete(resourcesToDelete.get((Object)GeneratedResource.Location.CLASS_OUTPUT), compileOutput));
        filesToDelete.addAll(this.collectFilesToDelete(resourcesToDelete.get((Object)GeneratedResource.Location.SOURCE_OUTPUT), (File)MoreObjects.firstNonNull((Object)annotationProcessorOutput, (Object)compileOutput)));
        filesToDelete.addAll(this.collectFilesToDelete(resourcesToDelete.get((Object)GeneratedResource.Location.NATIVE_HEADER_OUTPUT), headerOutput));
        return filesToDelete;
    }

    private Set<File> collectFilesToDelete(PatternSet patternSet, File sourceDirectory) {
        if (patternSet != null && !patternSet.isEmpty() && sourceDirectory != null && sourceDirectory.exists()) {
            return this.fileOperations.fileTree((Object)sourceDirectory).matching((PatternFilterable)patternSet).getFiles();
        }
        return Collections.emptySet();
    }

    private ImmutableSet<File> getOutputDirectories() {
        return (ImmutableSet)Stream.of(this.spec.getDestinationDir(), this.spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory(), this.spec.getCompileOptions().getHeaderOutputDirectory()).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    private static void rollbackOverwrittenFiles(ApiCompilerResult result) {
        result.getBackupClassFiles().forEach((original, backup) -> CompileTransaction.moveFile(new File((String)backup), new File((String)original)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restoring overwritten files: {}", result.getBackupClassFiles().keySet().stream().sorted().collect(Collectors.toList()));
        }
    }

    private static void rollbackStashedFiles(List<StashedFile> stashedFiles) {
        stashedFiles.forEach(StashedFile::unstash);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restoring stashed files: {}", stashedFiles.stream().map(f -> ((StashedFile)f).sourceFile.getAbsolutePath()).sorted().collect(Collectors.toList()));
        }
    }

    private static void moveFile(File sourceFile, File destinationFile) {
        try {
            destinationFile.getParentFile().mkdirs();
            Files.move(sourceFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static class StashedFile {
        private final File sourceFile;
        private final File stashFile;

        private StashedFile(File sourceFile, File stashFile) {
            this.sourceFile = sourceFile;
            this.stashFile = stashFile;
        }

        public void unstash() {
            CompileTransaction.moveFile(this.stashFile, this.sourceFile);
        }
    }
}

