/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Array;
import java.util.List;
import org.osgi.util.converter.AbstractCollectionDelegate;

class ArrayDelegate<T>
extends AbstractCollectionDelegate<T>
implements List<T> {
    private final Object backingArray;

    ArrayDelegate(Object arr) {
        this.backingArray = arr;
    }

    @Override
    public int size() {
        return Array.getLength(this.backingArray);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        Object[] arr = (Object[])Array.newInstance(Object.class, this.size());
        for (int i = 0; i < this.size(); ++i) {
            arr[i] = Array.get(this.backingArray, i);
        }
        return arr;
    }

    @Override
    public T get(int index) {
        return (T)Array.get(this.backingArray, index);
    }
}

