/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(16, 24, -23, -25) >> 0u) => ivec4(16, 24, -23, -25)
 * (ivec4(16, 24, -23, -25) >> 1u) => ivec4(8, 12, -12, -13)
 * (ivec4(16, 24, -23, -25) >> 2u) => ivec4(4, 6, -6, -7)
 * (ivec4(16, 24, -23, -25) >> 5u) => ivec4(0, 0, -1, -1)
 * (ivec4(16, 24, -23, -25) >> 25u) => ivec4(0, 0, -1, -1)
 * (ivec4(16, 24, -23, -25) >> 31u) => ivec4(0, 0, -1, -1)
 * (ivec4(16, 24, 23, 25) >> 0u) => ivec4(16, 24, 23, 25)
 * (ivec4(16, 24, 23, 25) >> 1u) => ivec4(8, 12, 11, 12)
 * (ivec4(16, 24, 23, 25) >> 2u) => ivec4(4, 6, 5, 6)
 * (ivec4(16, 24, 23, 25) >> 5u) => ivec4(0, 0, 0, 0)
 * (ivec4(16, 24, 23, 25) >> 25u) => ivec4(0, 0, 0, 0)
 * (ivec4(16, 24, 23, 25) >> 31u) => ivec4(0, 0, 0, 0)
 * (ivec4(-23, -12, 14, 19) >> 0u) => ivec4(-23, -12, 14, 19)
 * (ivec4(-23, -12, 14, 19) >> 1u) => ivec4(-12, -6, 7, 9)
 * (ivec4(-23, -12, 14, 19) >> 2u) => ivec4(-6, -3, 3, 4)
 * (ivec4(-23, -12, 14, 19) >> 5u) => ivec4(-1, -1, 0, 0)
 * (ivec4(-23, -12, 14, 19) >> 25u) => ivec4(-1, -1, 0, 0)
 * (ivec4(-23, -12, 14, 19) >> 31u) => ivec4(-1, -1, 0, 0)
 * (ivec4(23, 12, 14, 19) >> 0u) => ivec4(23, 12, 14, 19)
 * (ivec4(23, 12, 14, 19) >> 1u) => ivec4(11, 6, 7, 9)
 * (ivec4(23, 12, 14, 19) >> 2u) => ivec4(5, 3, 3, 4)
 * (ivec4(23, 12, 14, 19) >> 5u) => ivec4(0, 0, 0, 0)
 * (ivec4(23, 12, 14, 19) >> 25u) => ivec4(0, 0, 0, 0)
 * (ivec4(23, 12, 14, 19) >> 31u) => ivec4(0, 0, 0, 0)
 */
#version 150

void main()
{
  float[all(equal((ivec4(16, 24, -23, -25) >> 0u), ivec4(16, 24, -23, -25))) ? 1 : -1] array0;
  float[all(equal((ivec4(16, 24, -23, -25) >> 1u), ivec4(8, 12, -12, -13))) ? 1 : -1] array1;
  float[all(equal((ivec4(16, 24, -23, -25) >> 2u), ivec4(4, 6, -6, -7))) ? 1 : -1] array2;
  float[all(equal((ivec4(16, 24, -23, -25) >> 5u), ivec4(0, 0, -1, -1))) ? 1 : -1] array3;
  float[all(equal((ivec4(16, 24, -23, -25) >> 25u), ivec4(0, 0, -1, -1))) ? 1 : -1] array4;
  float[all(equal((ivec4(16, 24, -23, -25) >> 31u), ivec4(0, 0, -1, -1))) ? 1 : -1] array5;
  float[all(equal((ivec4(16, 24, 23, 25) >> 0u), ivec4(16, 24, 23, 25))) ? 1 : -1] array6;
  float[all(equal((ivec4(16, 24, 23, 25) >> 1u), ivec4(8, 12, 11, 12))) ? 1 : -1] array7;
  float[all(equal((ivec4(16, 24, 23, 25) >> 2u), ivec4(4, 6, 5, 6))) ? 1 : -1] array8;
  float[all(equal((ivec4(16, 24, 23, 25) >> 5u), ivec4(0, 0, 0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec4(16, 24, 23, 25) >> 25u), ivec4(0, 0, 0, 0))) ? 1 : -1] array10;
  float[all(equal((ivec4(16, 24, 23, 25) >> 31u), ivec4(0, 0, 0, 0))) ? 1 : -1] array11;
  float[all(equal((ivec4(-23, -12, 14, 19) >> 0u), ivec4(-23, -12, 14, 19))) ? 1 : -1] array12;
  float[all(equal((ivec4(-23, -12, 14, 19) >> 1u), ivec4(-12, -6, 7, 9))) ? 1 : -1] array13;
  float[all(equal((ivec4(-23, -12, 14, 19) >> 2u), ivec4(-6, -3, 3, 4))) ? 1 : -1] array14;
  float[all(equal((ivec4(-23, -12, 14, 19) >> 5u), ivec4(-1, -1, 0, 0))) ? 1 : -1] array15;
  float[all(equal((ivec4(-23, -12, 14, 19) >> 25u), ivec4(-1, -1, 0, 0))) ? 1 : -1] array16;
  float[all(equal((ivec4(-23, -12, 14, 19) >> 31u), ivec4(-1, -1, 0, 0))) ? 1 : -1] array17;
  float[all(equal((ivec4(23, 12, 14, 19) >> 0u), ivec4(23, 12, 14, 19))) ? 1 : -1] array18;
  float[all(equal((ivec4(23, 12, 14, 19) >> 1u), ivec4(11, 6, 7, 9))) ? 1 : -1] array19;
  float[all(equal((ivec4(23, 12, 14, 19) >> 2u), ivec4(5, 3, 3, 4))) ? 1 : -1] array20;
  float[all(equal((ivec4(23, 12, 14, 19) >> 5u), ivec4(0, 0, 0, 0))) ? 1 : -1] array21;
  float[all(equal((ivec4(23, 12, 14, 19) >> 25u), ivec4(0, 0, 0, 0))) ? 1 : -1] array22;
  float[all(equal((ivec4(23, 12, 14, 19) >> 31u), ivec4(0, 0, 0, 0))) ? 1 : -1] array23;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length());
}
