/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) << uvec2(13u, 26u)) => u64vec2(81920ul, 805306368ul)
 * (u64vec2(10ul, 12ul) << uvec2(2u, 26u)) => u64vec2(40ul, 805306368ul)
 * (u64vec2(42ul, 48ul) << uvec2(13u, 26u)) => u64vec2(344064ul, 3221225472ul)
 * (u64vec2(42ul, 48ul) << uvec2(2u, 26u)) => u64vec2(168ul, 3221225472ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) << uvec2(13u, 26u)), u64vec2(81920ul, 805306368ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) << uvec2(2u, 26u)), u64vec2(40ul, 805306368ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(42ul, 48ul) << uvec2(13u, 26u)), u64vec2(344064ul, 3221225472ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(42ul, 48ul) << uvec2(2u, 26u)), u64vec2(168ul, 3221225472ul))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
