/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) << u64vec2(13ul, 63ul)) => u64vec2(81920ul, 0ul)
 * (u64vec2(10ul, 12ul) << u64vec2(52ul, 50ul)) => u64vec2(45035996273704960ul, 13510798882111488ul)
 * (u64vec2(10ul, 12ul) << u64vec2(24ul, 61ul)) => u64vec2(167772160ul, 9223372036854775808ul)
 * (u64vec2(42ul, 48ul) << u64vec2(13ul, 63ul)) => u64vec2(344064ul, 0ul)
 * (u64vec2(42ul, 48ul) << u64vec2(52ul, 50ul)) => u64vec2(189151184349560832ul, 54043195528445952ul)
 * (u64vec2(42ul, 48ul) << u64vec2(24ul, 61ul)) => u64vec2(704643072ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) << u64vec2(13ul, 63ul)), u64vec2(81920ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) << u64vec2(52ul, 50ul)), u64vec2(45035996273704960ul, 13510798882111488ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(10ul, 12ul) << u64vec2(24ul, 61ul)), u64vec2(167772160ul, 9223372036854775808ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(42ul, 48ul) << u64vec2(13ul, 63ul)), u64vec2(344064ul, 0ul))) ? 1 : -1] array3;
  float[all(equal((u64vec2(42ul, 48ul) << u64vec2(52ul, 50ul)), u64vec2(189151184349560832ul, 54043195528445952ul))) ? 1 : -1] array4;
  float[all(equal((u64vec2(42ul, 48ul) << u64vec2(24ul, 61ul)), u64vec2(704643072ul, 0ul))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
