/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ci;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMetadata;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ciMethod
extends ciMetadata {
    private static CIntField interpreterThrowoutCountField;
    private static CIntField interpreterInvocationCountField;
    private static CIntField instructionsSizeField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ciMethod");
        interpreterThrowoutCountField = new CIntField(type.getCIntegerField("_interpreter_throwout_count"), 0L);
        interpreterInvocationCountField = new CIntField(type.getCIntegerField("_interpreter_invocation_count"), 0L);
        try {
            instructionsSizeField = new CIntField(type.getCIntegerField("_instructions_size"), 0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ciMethod(Address addr) {
        super(addr);
    }

    public Method method() {
        return (Method)this.getMetadata();
    }

    public int interpreterThrowoutCount() {
        return (int)interpreterThrowoutCountField.getValue(this.getAddress());
    }

    public int interpreterInvocationCount() {
        return (int)interpreterInvocationCountField.getValue(this.getAddress());
    }

    public int instructionsSize() {
        if (instructionsSizeField == null) {
            Method method = this.method();
            NMethod nm = method.getNativeMethod();
            if (nm != null) {
                return (int)nm.codeEnd().minus(nm.getVerifiedEntryPoint());
            }
            return 0;
        }
        return (int)instructionsSizeField.getValue(this.getAddress());
    }

    public void printShortName(PrintStream st) {
        Method method = this.method();
        st.printf(" %s::%s", method.getMethodHolder().getName().asString().replace('/', '.'), method.getName().asString());
    }

    @Override
    public void dumpReplayData(PrintStream out) {
        Method method = (Method)this.getMetadata();
        NMethod nm = method.getNativeMethod();
        InstanceKlass holder = method.getMethodHolder();
        out.println("ciMethod " + holder.getName().asString() + " " + OopUtilities.escapeString(method.getName().asString()) + " " + method.getSignature().asString() + " " + method.getInvocationCount() + " " + method.getBackedgeCount() + " " + this.interpreterInvocationCount() + " " + this.interpreterThrowoutCount() + " " + this.instructionsSize());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ciMethod.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

