/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.PairMap;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class NbIOProvider
extends IOProvider {
    private static final PairMap namesToIos = new PairMap();
    private static final String STDOUT = NbBundle.getMessage(NbIOProvider.class, (String)"LBL_STDOUT");

    public OutputWriter getStdOut() {
        if (Controller.LOG) {
            Controller.log("NbIOProvider.getStdOut");
        }
        InputOutput inputOutput = this.getIO(STDOUT, false, null);
        NbWriter nbWriter = ((NbIO)inputOutput).writer();
        Controller.ensureViewInDefault((NbIO)inputOutput, true);
        if (nbWriter != null && nbWriter.isClosed()) {
            try {
                nbWriter.reset();
                nbWriter = (NbWriter)inputOutput.getOut();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                inputOutput = this.getIO(STDOUT, true, null);
                nbWriter = (NbWriter)inputOutput.getOut();
            }
        } else {
            nbWriter = (NbWriter)inputOutput.getOut();
        }
        return nbWriter;
    }

    public InputOutput getIO(String string, boolean bl) {
        return this.getIO(string, bl, new Action[0]);
    }

    public InputOutput getIO(String string, Action[] actionArray) {
        return this.getIO(string, true, actionArray);
    }

    private InputOutput getIO(String string, boolean bl, Action[] actionArray) {
        NbIO nbIO;
        if (Controller.LOG) {
            Controller.log("GETIO: " + string + " new:" + bl);
        }
        if ((nbIO = namesToIos.get(string)) == null || bl) {
            nbIO = new NbIO(string, actionArray);
            namesToIos.add(string, nbIO);
            Controller.ensureViewInDefault(nbIO, bl);
        }
        return nbIO;
    }

    static void dispose(NbIO nbIO) {
        namesToIos.remove(nbIO);
    }

    static void setWeak(boolean bl) {
        namesToIos.setWeak(bl);
    }
}

