/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.idpverifyemail;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.idpverifyemail.IdpVerifyAccountLinkActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class IdpVerifyAccountLinkActionTokenHandler
extends AbstractActionTokenHandler<IdpVerifyAccountLinkActionToken> {
    public IdpVerifyAccountLinkActionTokenHandler() {
        super("idp-verify-account-via-email", IdpVerifyAccountLinkActionToken.class, "staleCodeMessage", EventType.IDENTITY_PROVIDER_LINK_ACCOUNT, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super IdpVerifyAccountLinkActionToken>[] getVerifiers(ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        return TokenUtils.predicates(this.verifyEmail(tokenContext));
    }

    @Override
    public Response handleToken(IdpVerifyAccountLinkActionToken token, ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        EventBuilder event = tokenContext.getEvent();
        UriInfo uriInfo = tokenContext.getUriInfo();
        RealmModel realm = tokenContext.getRealm();
        KeycloakSession session = tokenContext.getSession();
        event.event(EventType.IDENTITY_PROVIDER_LINK_ACCOUNT).detail("email", user.getEmail()).detail("identity_provider", token.getIdentityProviderAlias()).detail("identity_provider_identity", token.getIdentityProviderUsername());
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        if (authSession.getAuthNote("VERIFY_ACCOUNT_IDP_USERNAME") != null) {
            return this.sendEmailAlreadyVerified(session, event, user);
        }
        AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
        if (tokenContext.isAuthenticationSessionFresh()) {
            AuthenticationSessionCompoundId compoundId = AuthenticationSessionCompoundId.encoded((String)token.getCompoundAuthenticationSessionId());
            ClientModel originalClient = realm.getClientById(compoundId.getClientUUID());
            AuthenticationSessionModel origAuthSession = asm.getAuthenticationSessionByIdAndClient(realm, compoundId.getRootSessionId(), originalClient, compoundId.getTabId());
            if (origAuthSession == null || origAuthSession.getAuthNote("VERIFY_ACCOUNT_IDP_USERNAME") != null) {
                return this.sendEmailAlreadyVerified(session, event, user);
            }
            token.setOriginalCompoundAuthenticationSessionId(token.getCompoundAuthenticationSessionId());
            String authSessionEncodedId = AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId();
            token.setCompoundAuthenticationSessionId(authSessionEncodedId);
            UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo), authSession.getClient().getClientId(), authSession.getTabId(), AuthenticationProcessor.getClientData(session, authSession));
            String confirmUri = builder.build(new Object[]{realm.getName()}).toString();
            LoginFormsProvider forms = (LoginFormsProvider)session.getProvider(LoginFormsProvider.class);
            return forms.setAuthenticationSession(authSession).setAttribute("messageHeader", (Object)forms.getMessage("confirmAccountLinking", new Object[]{token.getIdentityProviderUsername(), token.getIdentityProviderAlias()})).setSuccess("confirmAccountLinkingBody", new Object[]{token.getIdentityProviderUsername(), token.getIdentityProviderAlias()}).setAttribute("actionUri", (Object)confirmUri).createInfoPage();
        }
        user.setEmailVerified(true);
        event.success();
        if (token.getOriginalCompoundAuthenticationSessionId() != null) {
            asm.removeAuthenticationSession(realm, authSession, true);
            AuthenticationSessionCompoundId compoundId = AuthenticationSessionCompoundId.encoded((String)token.getOriginalCompoundAuthenticationSessionId());
            ClientModel originalClient = realm.getClientById(compoundId.getClientUUID());
            authSession = asm.getAuthenticationSessionByIdAndClient(realm, compoundId.getRootSessionId(), originalClient, compoundId.getTabId());
            if (authSession != null) {
                authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
            }
            this.setUserVerifiedSingleObject(token, realm, session, user);
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("identityProviderLinkSuccess", new Object[]{token.getIdentityProviderAlias(), token.getIdentityProviderUsername()}).setAttribute("skipLink", (Object)true).createInfoPage();
        }
        authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
        return tokenContext.brokerFlow(null, null, authSession.getAuthNote("current.flow.path"));
    }

    private void setUserVerifiedSingleObject(IdpVerifyAccountLinkActionToken token, RealmModel realm, KeycloakSession session, UserModel user) {
        int singleObjectLifespan = realm.getActionTokenGeneratedByUserLifespan();
        String userId = user.getId();
        String idpAlias = token.getIdentityProviderAlias();
        session.singleUseObjects().put(IdpVerifyAccountLinkActionTokenHandler.getUserVerifiedSingleObjectKey(userId, idpAlias), (long)singleObjectLifespan, Map.of());
    }

    public static boolean runIfUserVerified(KeycloakSession session, UserModel user, IdentityProviderModel broker, Runnable runnable) {
        String singleObjectKey;
        boolean isUserVerified;
        if (user == null) {
            return false;
        }
        SingleUseObjectProvider singleObjects = session.singleUseObjects();
        boolean bl = isUserVerified = singleObjects.remove(singleObjectKey = IdpVerifyAccountLinkActionTokenHandler.getUserVerifiedSingleObjectKey(user.getId(), broker.getAlias())) != null;
        if (isUserVerified) {
            runnable.run();
        }
        return isUserVerified;
    }

    private static String getUserVerifiedSingleObjectKey(String userId, String idpAlias) {
        return "kc.brokering.user.verified." + userId + "." + idpAlias;
    }

    private Response sendEmailAlreadyVerified(KeycloakSession session, EventBuilder event, UserModel user) {
        event.user(user).error("email_already_verified");
        return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(session.getContext().getAuthenticationSession()).setInfo("emailVerifiedAlreadyMessage", new Object[]{user.getEmail()}).createInfoPage();
    }
}

