/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.lang.ref.Cleaner;
import java.security.Provider;
import org.jitsi.srtp.crypto.OpenSslAesCtrCipherSpi;
import org.jitsi.srtp.crypto.OpenSslAesEcbCipherSpi;
import org.jitsi.srtp.crypto.OpenSslAesGcmAuthOnlyCipherSpi;
import org.jitsi.srtp.crypto.OpenSslAesGcmCipherSpi;
import org.jitsi.srtp.crypto.OpenSslHmacSpi;
import org.jitsi.utils.JNIUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class JitsiOpenSslProvider
extends Provider {
    private static final Logger logger = new LoggerImpl(JitsiOpenSslProvider.class.getName());
    private static boolean libraryLoaded = false;
    static final Cleaner CLEANER;

    private static native boolean OpenSSL_Init();

    public static boolean isLoaded() {
        return libraryLoaded;
    }

    public JitsiOpenSslProvider() {
        super("JitsiOpenSslProvider", "1", "Jitsi OpenSSL SRTP security provider");
        this.put("Cipher.AES/CTR/NoPadding", OpenSslAesCtrCipherSpi.class.getName());
        this.put("Cipher.AES/GCM/NoPadding", OpenSslAesGcmCipherSpi.class.getName());
        this.put("Cipher.AES/ECB/NoPadding", OpenSslAesEcbCipherSpi.class.getName());
        this.put("Cipher.AES/GCM-AuthOnly/NoPadding", OpenSslAesGcmAuthOnlyCipherSpi.class.getName());
        this.put("MAC.HmacSHA1", OpenSslHmacSpi.class.getName());
    }

    static {
        Cleaner cleaner = null;
        String[] versions = new String[]{"1.1", "3"};
        for (int i = 0; i < versions.length; ++i) {
            String version = versions[i];
            try {
                JNIUtils.loadLibrary("jitsisrtp_" + version, JitsiOpenSslProvider.class.getClassLoader());
                if (JitsiOpenSslProvider.OpenSSL_Init()) {
                    logger.info(() -> "jitsisrtp successfully loaded for OpenSSL " + version);
                    libraryLoaded = true;
                    cleaner = Cleaner.create();
                    break;
                }
                logger.warn("OpenSSL_Init failed");
                continue;
            }
            catch (UnsatisfiedLinkError t2) {
                if (i == versions.length - 1) {
                    logger.warn("Unable to load jitsisrtp", t2);
                    continue;
                }
                logger.debug(() -> "Unable to load jitsisrtp for OpenSSL " + version + ": " + t2);
            }
        }
        CLEANER = cleaner;
    }
}

