/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.security.WECollection;

public class WrapperEventPermission
extends Permission {
    private static final long serialVersionUID = 8916489326587298168L;
    public static String EVENT_TYPE_SERVICE = "service";
    public static String EVENT_TYPE_CONTROL = "control";
    public static String EVENT_TYPE_REMOTE_CONTROL = "remoteControl";
    public static String EVENT_TYPE_CORE = "core";
    private static int MASK_SERVICE = 1;
    private static int MASK_CONTROL = 2;
    private static int MASK_REMOTE_CONTROL = 8;
    private static int MASK_CORE = 65536;
    private static int MASK_ALL = MASK_SERVICE | MASK_CONTROL | MASK_REMOTE_CONTROL | MASK_CORE;
    private int m_eventTypeMask;

    public WrapperEventPermission(String eventTypes) {
        super("*");
        this.m_eventTypeMask = this.buildEventTypeMask(eventTypes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WrapperEventPermission)) {
            return false;
        }
        WrapperEventPermission wsp = (WrapperEventPermission)obj;
        return this.m_eventTypeMask == wsp.m_eventTypeMask && this.getName().equals(wsp.getName());
    }

    public String getActions() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if ((this.m_eventTypeMask & MASK_SERVICE) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(EVENT_TYPE_SERVICE);
        }
        if ((this.m_eventTypeMask & MASK_CONTROL) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(EVENT_TYPE_CONTROL);
        }
        if ((this.m_eventTypeMask & MASK_REMOTE_CONTROL) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(EVENT_TYPE_REMOTE_CONTROL);
        }
        if ((this.m_eventTypeMask & MASK_CORE) != 0) {
            if (first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(EVENT_TYPE_CORE);
        }
        return sb.toString();
    }

    public boolean implies(Permission p2) {
        if (!(p2 instanceof WrapperEventPermission)) {
            return false;
        }
        WrapperEventPermission wsp = (WrapperEventPermission)p2;
        return (this.m_eventTypeMask & wsp.m_eventTypeMask) == wsp.m_eventTypeMask && this.impliesIgnoreEventTypeMask(wsp);
    }

    public PermissionCollection newPermissionCollection() {
        return new WECollection();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    int getActionMask() {
        return this.m_eventTypeMask;
    }

    boolean impliesIgnoreEventTypeMask(WrapperEventPermission p2) {
        if (this.getName().equals(p2.getName())) {
            return true;
        }
        return p2.getName().endsWith("*") && this.getName().startsWith(p2.getName().substring(0, p2.getName().length() - 1));
    }

    private int buildEventTypeMask(String eventTypes) {
        if (eventTypes == EVENT_TYPE_SERVICE) {
            return MASK_SERVICE;
        }
        if (eventTypes == EVENT_TYPE_CONTROL) {
            return MASK_CONTROL;
        }
        if (eventTypes == EVENT_TYPE_REMOTE_CONTROL) {
            return MASK_REMOTE_CONTROL;
        }
        if (eventTypes == EVENT_TYPE_CORE) {
            return MASK_CORE;
        }
        if (eventTypes.equals("*")) {
            return MASK_ALL;
        }
        int mask = 0;
        StringTokenizer st = new StringTokenizer(eventTypes, ",");
        while (st.hasMoreTokens()) {
            String eventType = st.nextToken();
            if (eventType.equals(EVENT_TYPE_SERVICE)) {
                mask |= MASK_SERVICE;
                continue;
            }
            if (eventType.equals(EVENT_TYPE_CONTROL)) {
                mask |= MASK_CONTROL;
                continue;
            }
            if (eventType.equals(EVENT_TYPE_REMOTE_CONTROL)) {
                mask |= MASK_REMOTE_CONTROL;
                continue;
            }
            if (eventType.equals(EVENT_TYPE_CORE)) {
                mask |= MASK_CORE;
                continue;
            }
            throw new IllegalArgumentException(WrapperManager.getRes().getString("Invalid permission eventType: \"{0}\"", eventType));
        }
        return mask;
    }
}

