/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.Constants;
import org.apache.fop.layoutmgr.inline.ScaledBaselineTable;

public class BasicScaledBaselineTable
implements ScaledBaselineTable,
Constants {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$inline$BasicScaledBaselineTable == null ? (class$org$apache$fop$layoutmgr$inline$BasicScaledBaselineTable = BasicScaledBaselineTable.class$("org.apache.fop.layoutmgr.inline.BasicScaledBaselineTable")) : class$org$apache$fop$layoutmgr$inline$BasicScaledBaselineTable));
    private int altitude;
    private int depth;
    private int xHeight;
    private int dominantBaselineIdentifier;
    private int writingMode;
    private int dominantBaselineOffset;
    private int beforeEdgeOffset;
    private int afterEdgeOffset;
    private static final float HANGING_BASELINE_FACTOR = 0.8f;
    private static final float MATHEMATICAL_BASELINE_FACTOR = 0.5f;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$inline$BasicScaledBaselineTable;

    public BasicScaledBaselineTable(int altitude, int depth, int xHeight, int dominantBaselineIdentifier, int writingMode) {
        this.altitude = altitude;
        this.depth = depth;
        this.xHeight = xHeight;
        this.dominantBaselineIdentifier = dominantBaselineIdentifier;
        this.writingMode = writingMode;
        this.dominantBaselineOffset = this.getBaselineDefaultOffset(this.dominantBaselineIdentifier);
        this.beforeEdgeOffset = altitude - this.dominantBaselineOffset;
        this.afterEdgeOffset = depth - this.dominantBaselineOffset;
    }

    public int getDominantBaselineIdentifier() {
        return this.dominantBaselineIdentifier;
    }

    public int getWritingMode() {
        return this.writingMode;
    }

    public int getBaseline(int baselineIdentifier) {
        int offset = 0;
        if (!this.isHorizontalWritingMode()) {
            switch (baselineIdentifier) {
                case 20: 
                case 143: 
                case 144: 
                case 145: {
                    this.log.warn((Object)"The given baseline is only supported for horizontal writing modes");
                    return 0;
                }
            }
        }
        switch (baselineIdentifier) {
            case 14: 
            case 145: {
                offset = this.beforeEdgeOffset;
                break;
            }
            case 6: 
            case 24: 
            case 56: 
            case 59: 
            case 82: 
            case 84: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                offset = this.getBaselineDefaultOffset(baselineIdentifier) - this.dominantBaselineOffset;
                break;
            }
            case 4: 
            case 20: {
                offset = this.afterEdgeOffset;
            }
        }
        return offset;
    }

    private boolean isHorizontalWritingMode() {
        return this.writingMode == 79 || this.writingMode == 121;
    }

    private int getBaselineDefaultOffset(int baselineIdentifier) {
        int offset = 0;
        switch (baselineIdentifier) {
            case 142: {
                offset = this.altitude;
                break;
            }
            case 56: {
                offset = Math.round((float)this.altitude * 0.8f);
                break;
            }
            case 24: {
                offset = (this.altitude - this.depth) / 2 + this.depth;
                break;
            }
            case 84: {
                offset = this.xHeight / 2;
                break;
            }
            case 82: {
                offset = Math.round((float)this.altitude * 0.5f);
                break;
            }
            case 6: {
                offset = 0;
                break;
            }
            case 59: 
            case 141: {
                offset = this.depth;
            }
        }
        return offset;
    }

    public void setBeforeAndAfterBaselines(int beforeBaseline, int afterBaseline) {
        this.beforeEdgeOffset = beforeBaseline;
        this.afterEdgeOffset = afterBaseline;
    }

    public ScaledBaselineTable deriveScaledBaselineTable(int baselineIdentifier) {
        BasicScaledBaselineTable bac = new BasicScaledBaselineTable(this.altitude, this.depth, this.xHeight, baselineIdentifier, this.writingMode);
        return bac;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

