"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../common/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function defineRoutes(router, dataSourceEnabled) {
  router.get({
    path: '/api/top_queries',
    validate: {
      query: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      var _request$query;
      // data source disabled
      if (!dataSourceEnabled || !((_request$query = request.query) !== null && _request$query !== void 0 && _request$query.dataSourceId)) {
        const client = context.queryInsights_plugin.queryInsightsClient.asScoped(request).callAsCurrentUser;
        const res = await client('queryInsights.getTopNQueries');
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } else {
        var _request$query2;
        const client = context.dataSource.opensearch.legacy.getClient((_request$query2 = request.query) === null || _request$query2 === void 0 ? void 0 : _request$query2.dataSourceId);
        const res = await client.callAPI('queryInsights.getTopNQueries', {});
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      }
    } catch (error) {
      console.error('Unable to get top queries: ', error);
      return response.ok({
        body: {
          ok: false,
          response: error.message
        }
      });
    }
  });
  router.get({
    path: '/api/top_queries/latency',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        to: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        id: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      var _request$query3;
      const {
        from,
        to,
        id
      } = request.query;
      const params = {
        from,
        to,
        id
      };
      if (!dataSourceEnabled || !((_request$query3 = request.query) !== null && _request$query3 !== void 0 && _request$query3.dataSourceId)) {
        const client = context.queryInsights_plugin.queryInsightsClient.asScoped(request).callAsCurrentUser;
        const res = id != null ? await client('queryInsights.getTopNQueriesLatencyForId', params) : await client('queryInsights.getTopNQueriesLatency', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } else {
        var _request$query4;
        const client = context.dataSource.opensearch.legacy.getClient((_request$query4 = request.query) === null || _request$query4 === void 0 ? void 0 : _request$query4.dataSourceId);
        const res = id != null ? await client.callAPI('queryInsights.getTopNQueriesLatencyForId', params) : await client.callAPI('queryInsights.getTopNQueriesLatency', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      }
    } catch (error) {
      console.error('Unable to get top queries (latency): ', error);
      return response.ok({
        body: {
          ok: false,
          response: error.message
        }
      });
    }
  });
  router.get({
    path: '/api/top_queries/cpu',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        to: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        id: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      var _request$query5;
      const {
        from,
        to,
        id
      } = request.query;
      const params = {
        from,
        to,
        id
      };
      if (!dataSourceEnabled || !((_request$query5 = request.query) !== null && _request$query5 !== void 0 && _request$query5.dataSourceId)) {
        const client = context.queryInsights_plugin.queryInsightsClient.asScoped(request).callAsCurrentUser;
        const res = id != null ? await client('queryInsights.getTopNQueriesCpuForId', params) : await client('queryInsights.getTopNQueriesCpu', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } else {
        var _request$query6;
        const client = context.dataSource.opensearch.legacy.getClient((_request$query6 = request.query) === null || _request$query6 === void 0 ? void 0 : _request$query6.dataSourceId);
        const res = id != null ? await client.callAPI('queryInsights.getTopNQueriesCpuForId', params) : await client.callAPI('queryInsights.getTopNQueriesCpu', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      }
    } catch (error) {
      console.error('Unable to get top queries (cpu): ', error);
      return response.ok({
        body: {
          ok: false,
          response: error.message
        }
      });
    }
  });
  router.get({
    path: '/api/top_queries/memory',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        to: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        id: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      var _request$query7;
      const {
        from,
        to,
        id
      } = request.query;
      const params = {
        from,
        to,
        id
      };
      if (!dataSourceEnabled || !((_request$query7 = request.query) !== null && _request$query7 !== void 0 && _request$query7.dataSourceId)) {
        const client = context.queryInsights_plugin.queryInsightsClient.asScoped(request).callAsCurrentUser;
        const res = id != null ? await client('queryInsights.getTopNQueriesMemoryForId', params) : await client('queryInsights.getTopNQueriesMemory', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } else {
        var _request$query8;
        const client = context.dataSource.opensearch.legacy.getClient((_request$query8 = request.query) === null || _request$query8 === void 0 ? void 0 : _request$query8.dataSourceId);
        const res = id != null ? await client.callAPI('queryInsights.getTopNQueriesMemoryForId', params) : await client.callAPI('queryInsights.getTopNQueriesMemory', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      }
    } catch (error) {
      console.error('Unable to get top queries (memory): ', error);
      return response.ok({
        body: {
          ok: false,
          response: error.message
        }
      });
    }
  });
  router.get({
    path: '/api/settings',
    validate: {
      query: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      var _request$query9;
      if (!dataSourceEnabled || !((_request$query9 = request.query) !== null && _request$query9 !== void 0 && _request$query9.dataSourceId)) {
        const client = context.queryInsights_plugin.queryInsightsClient.asScoped(request).callAsCurrentUser;
        const res = await client('queryInsights.getSettings');
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } else {
        var _request$query10;
        const client = context.dataSource.opensearch.legacy.getClient((_request$query10 = request.query) === null || _request$query10 === void 0 ? void 0 : _request$query10.dataSourceId);
        const res = await client.callAPI('queryInsights.getSettings', {});
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      }
    } catch (error) {
      console.error('Unable to get top queries: ', error);
      return response.ok({
        body: {
          ok: false,
          response: error.message
        }
      });
    }
  });
  router.put({
    path: '/api/update_settings',
    validate: {
      query: _configSchema.schema.object({
        metric: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        enabled: _configSchema.schema.maybe(_configSchema.schema.boolean({
          defaultValue: false
        })),
        top_n_size: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        window_size: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        exporterType: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        group_by: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        })),
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        delete_after_days: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    try {
      var _request$query11;
      const query = request.query;
      const params = {
        body: {
          persistent: {
            [`search.insights.top_queries.${query.metric}.enabled`]: query.enabled,
            [`search.insights.top_queries.${query.metric}.top_n_size`]: query.top_n_size,
            [`search.insights.top_queries.${query.metric}.window_size`]: query.window_size
          }
        }
      };
      if (query.group_by !== '') {
        params.body.persistent['search.insights.top_queries.group_by'] = query.group_by;
      }
      if (query.delete_after_days !== '') {
        params.body.persistent['search.insights.top_queries.exporter.delete_after_days'] = query.delete_after_days;
      }
      if (query.exporterType !== '') {
        params.body.persistent['search.insights.top_queries.exporter.type'] = query.exporterType === _constants.EXPORTER_TYPE.localIndex ? query.exporterType : _constants.EXPORTER_TYPE.none;
      }
      if (!dataSourceEnabled || !((_request$query11 = request.query) !== null && _request$query11 !== void 0 && _request$query11.dataSourceId)) {
        const client = context.queryInsights_plugin.queryInsightsClient.asScoped(request).callAsCurrentUser;
        const res = await client('queryInsights.setSettings', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } else {
        var _request$query12;
        const client = context.dataSource.opensearch.legacy.getClient((_request$query12 = request.query) === null || _request$query12 === void 0 ? void 0 : _request$query12.dataSourceId);
        const res = await client.callAPI('queryInsights.setSettings', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      }
    } catch (error) {
      console.error('Unable to set settings: ', error);
      return response.ok({
        body: {
          ok: false,
          response: error.message
        }
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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