"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class QueryService {
  constructor(_client, logger) {
    this.logger = logger;
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat, context) => {
      try {
        const queryRequest = {
          query: request.body
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, params);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.response,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (context, request) => {
      return this.describeQueryInternal(request, 'ppl.sqlQuery', 'json', context);
    });
    _defineProperty(this, "describePPLQuery", async (context, request) => {
      return this.describeQueryInternal(request, 'ppl.pplQuery', 'json', context);
    });
    this.client = _client;
  }
}
exports.QueryService = QueryService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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