/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.http.MediaType;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationManagerFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNegotiationConfigurer {
    private ContentNegotiationManagerFactoryBean factoryBean = new ContentNegotiationManagerFactoryBean();

    public ContentNegotiationConfigurer(ServletContext servletContext) {
        this.factoryBean.setServletContext(servletContext);
    }

    public ContentNegotiationConfigurer favorPathExtension(boolean favorPathExtension) {
        this.factoryBean.setFavorPathExtension(favorPathExtension);
        return this;
    }

    public ContentNegotiationConfigurer mediaType(String extension, MediaType mediaType) {
        this.factoryBean.getMediaTypes().put(extension, mediaType);
        return this;
    }

    public ContentNegotiationConfigurer mediaTypes(Map<String, MediaType> mediaTypes) {
        if (mediaTypes != null) {
            this.factoryBean.getMediaTypes().putAll(mediaTypes);
        }
        return this;
    }

    public ContentNegotiationConfigurer replaceMediaTypes(Map<String, MediaType> mediaTypes) {
        this.factoryBean.getMediaTypes().clear();
        this.mediaTypes(mediaTypes);
        return this;
    }

    public ContentNegotiationConfigurer useJaf(boolean useJaf) {
        this.factoryBean.setUseJaf(useJaf);
        return this;
    }

    public ContentNegotiationConfigurer favorParameter(boolean favorParameter) {
        this.factoryBean.setFavorParameter(favorParameter);
        return this;
    }

    public ContentNegotiationConfigurer parameterName(String parameterName) {
        this.factoryBean.setParameterName(parameterName);
        return this;
    }

    public ContentNegotiationConfigurer ignoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.factoryBean.setIgnoreAcceptHeader(ignoreAcceptHeader);
        return this;
    }

    public ContentNegotiationConfigurer defaultContentType(MediaType defaultContentType) {
        this.factoryBean.setDefaultContentType(defaultContentType);
        return this;
    }

    protected ContentNegotiationManager getContentNegotiationManager() throws Exception {
        this.factoryBean.afterPropertiesSet();
        return this.factoryBean.getObject();
    }
}

