# Pylint-Ignore

**WARNING: This file is programmatically generated.**

This file is parsed by [`pylint-ignore`](https://pypi.org/project/pylint-ignore/)
to determine which
[Pylint messages](https://pylint.pycqa.org/en/stable/technical_reference/features.html)
should be ignored.

- Do not edit this file manually.
- To update, use `pylint-ignore --update-ignorefile`

The recommended approach to using `pylint-ignore` is:

1. If a message refers to a valid issue, update your code rather than
   ignoring the message.
2. If a message should *always* be ignored (globally), then to do so
   via the usual `pylintrc` or `setup.cfg` files rather than this
   `pylint-ignore.md` file.
3. If a message is a false positive, add a comment of this form to your code:
   `# pylint:disable=<symbol> ; explain why this is a false positive`


# Overview

 - [W0201: attribute-defined-outside-init (3x)](#w0201-attribute-defined-outside-init)
 - [W0621: redefined-outer-name (5x)](#w0621-redefined-outer-name)
 - [W0703: broad-except (8x)](#w0703-broad-except)
 - [C0302: too-many-lines (1x)](#c0302-too-many-lines)
 - [C0415: import-outside-toplevel (2x)](#c0415-import-outside-toplevel)
 - [R0911: too-many-return-statements (9x)](#r0911-too-many-return-statements)
 - [R0912: too-many-branches (3x)](#r0912-too-many-branches)
 - [R0914: too-many-locals (3x)](#r0914-too-many-locals)
 - [R0915: too-many-statements (4x)](#r0915-too-many-statements)
 - [R1710: inconsistent-return-statements (2x)](#r1710-inconsistent-return-statements)
 - [R1728: consider-using-generator (3x)](#r1728-consider-using-generator)


# W0201: attribute-defined-outside-init

## File setup.py - Line 18 - W0201 (attribute-defined-outside-init)

- `message: Attribute 'pytest_args' defined outside __init__`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  15:     def initialize_options(self):
  ...
  16:         TestCommand.initialize_options(self)
  17:         try:
> 18:             self.pytest_args = ["-n", str(cpu_count()), "--boxed"]
  19:         except (ImportError, NotImplementedError):
  20:             self.pytest_args = ["-n", "1", "--boxed"]
```


## File setup.py - Line 20 - W0201 (attribute-defined-outside-init)

- `message: Attribute 'pytest_args' defined outside __init__`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  15:     def initialize_options(self):
  ...
  18:             self.pytest_args = ["-n", str(cpu_count()), "--boxed"]
  19:         except (ImportError, NotImplementedError):
> 20:             self.pytest_args = ["-n", "1", "--boxed"]
  21: 
  22:     def finalize_options(self):
```


## File setup.py - Line 25 - W0201 (attribute-defined-outside-init)

- `message: Attribute 'test_suite' defined outside __init__`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  22:     def finalize_options(self):
  ...
  23:         TestCommand.finalize_options(self)
  24:         self.test_args = []
> 25:         self.test_suite = True
  26: 
  27:     def run_tests(self):
```


# W0621: redefined-outer-name

## File wapitiCore/attack/attack.py - Line 370 - W0621 (redefined-outer-name)

- `message: Redefining name 'param_name' from outer scope (line 626)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  353:     def mutate(self, request: Request):
  ...
  368: 
  369:             for i, __ in enumerate(params_list):
> 370:                 param_name = quote(params_list[i][0])
  371: 
  372:                 if self._skip_list and param_name in self._skip_list:
```


## File wapitiCore/attack/attack.py - Line 398 - W0621 (redefined-outer-name)

- `message: Redefining name 'payload' from outer scope (line 626)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  353:     def mutate(self, request: Request):
  ...
  396:                     self._attack_hashes.add(hash(attack_pattern))
  397: 
> 398:                     for payload, original_flags in self.iter_payloads():
  399: 
  400:                         if ("[FILE_NAME]" in payload or "[FILE_NOEXT]" in payload) and not request.file_name:
```


## File wapitiCore/attack/attack.py - Line 527 - W0621 (redefined-outer-name)

- `message: Redefining name 'param_name' from outer scope (line 626)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  520:     def mutate(self, request: Request):
  ...
  525:         for i in range(len(request.file_params)):
  526:             new_params = request.file_params
> 527:             param_name = new_params[i][0]
  528: 
  529:             if self._skip_list and param_name in self._skip_list:
```


## File wapitiCore/attack/attack.py - Line 535 - W0621 (redefined-outer-name)

- `message: Redefining name 'payload' from outer scope (line 626)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  520:     def mutate(self, request: Request):
  ...
  533:                 continue
  534: 
> 535:             for payload, original_flags in self.iter_payloads():
  536: 
  537:                 if ("[FILE_NAME]" in payload or "[FILE_NOEXT]" in payload) and not request.file_name:
```


## File wapitiCore/attack/attack.py - Line 582 - W0621 (redefined-outer-name)

- `message: Redefining name 'flags' from outer scope (line 626)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  576:     def read_payloads(self, filename):
  ...
  580:             with open(filename, errors="ignore", encoding='utf-8') as file:
  581:                 for line in file:
> 582:                     clean_line, flags = self.process_line(line)
  583:                     if clean_line:
  584:                         lines.append((clean_line, flags))
```


# W0703: broad-except

## File wapitiCore/net/lamejs.py - Line 41 - W0703 (broad-except)

- `message: Catching too general exception Exception`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  28:     def __init__(self, data):
  ...
  39:             rootnode = jsparser3.parse(data, None, 0)
  40:             self.read_node(rootnode)
> 41:         except Exception:
  42:             pass
  43:
```


## File wapitiCore/attack/mod_drupal_enum.py - Line 118 - W0703 (broad-except)

- `message: Catching too general exception Exception`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   28:     def get_hashes(self):
  ...
  116:             except RequestError:
  117:                 self.network_errors += 1
> 118:             except Exception as exception:
  119:                 logging.exception(exception)
  120:             else:
```


## File wapitiCore/attack/mod_takeover.py - Line 157 - W0703 (broad-except)

- `message: Catching too general exception BaseException`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   67:     def __init__(self):
  ...
  155:                         except dns.asyncresolver.NXDOMAIN:
  156:                             return True
> 157:                         except BaseException:
  158:                             continue
  159:
```


## File wapitiCore/attack/mod_takeover.py - Line 174 - W0703 (broad-except)

- `message: Catching too general exception BaseException`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   67:     def __init__(self):
  ...
  172:         except dns.resolver.NXDOMAIN:
  173:             return True
> 174:         except BaseException as exception:
  175:             logging.warning(f"ANY request for {root_domain}: {exception}")
  176:
```


## File wapitiCore/attack/mod_nikto.py - Line 233 - W0703 (broad-except)

- `message: Catching too general exception Exception`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   72:     def __init__(self, crawler, persister, attack_options, stop_event):
  ...
  231:             self.network_errors += 1
  232:             return
> 233:         except Exception as exception:
  234:             logging.warning(f"{exception} occurred with URL {evil_request.url}")
  235:             return
```


## File wapitiCore/main/wapiti.py - Line 482 - W0703 (broad-except)

- `message: Catching too general exception Exception`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  229:     def _init_attacks(self, stop_event: asyncio.Event):
  ...
  480:                     await asyncio.sleep(1)
  481:                     continue
> 482:                 except Exception as exception:
  483:                     # Catch every possible exceptions and print it
  484:                     exception_traceback = sys.exc_info()[2]
```


## File wapitiCore/net/crawler.py - Line 677 - W0703 (broad-except)

- `message: Catching too general exception Exception`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  667:     def extract_links(self, page, request) -> List:
  ...
  675:             try:
  676:                 swf_links = swf.extract_links_from_swf(page.bytes)
> 677:             except Exception:
  678:                 pass
  679:         elif "/x-javascript" in page.type or "/x-js" in page.type or "/javascript" in page.type:
```


## File wapitiCore/net/crawler.py - Line 918 - W0703 (broad-except)

- `message: Catching too general exception Exception`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  667:     def extract_links(self, page, request) -> List:
  ...
  916:                 try:
  917:                     success, resources = await task
> 918:                 except Exception as exception:
  919:                     logging.error(f"{request} generated an exception: {exception.__class__.__name__}")
  920:                 else:
```


# C0302: too-many-lines

## File wapitiCore/main/wapiti.py - Line 1 - C0302 (too-many-lines)

- `message: Too many lines in module (1367/1000)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
> 1: #!/usr/bin/env python3
  2: # -*- coding: utf-8 -*-
  3: # This file is part of the Wapiti project (https://wapiti-scanner.github.io)
```


# C0415: import-outside-toplevel

## File setup.py - Line 28 - C0415 (import-outside-toplevel)

- `message: Import outside toplevel (pytest)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  26: 
  27:     def run_tests(self):
> 28:         import pytest
  29: 
  30:         errno = pytest.main(self.pytest_args)
```


## File wapitiCore/net/crawler.py - Line 353 - C0415 (import-outside-toplevel)

- `message: Import outside toplevel (httpx_ntlm.HttpNtlmAuth)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  340:     def auth_method(self, value):
  ...
  351:             elif self._auth_method == "ntlm":
  352:                 # https://github.com/ulodciv/httpx-ntlm
> 353:                 from httpx_ntlm import HttpNtlmAuth
  354:                 self._auth = HttpNtlmAuth(username, password)  # username in the form domain\user
  355:
```


# R0911: too-many-return-statements

## File wapitiCore/net/swf.py - Line 26 - R0911 (too-many-return-statements)

- `message: Too many return statements (12/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  24: 
  25: 
> 26: def looks_like_an_url(string):
  27:     string = string.strip()
  28:     if len(string) < 3:
```


## File wapitiCore/net/lamejs.py - Line 50 - R0911 (too-many-return-statements)

- `message: Too many return statements (11/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  26: class LameJs:
  ...
  48:         return self.links
  49: 
> 50:     def read_node(self, node):
  51:         if node.type == "SCRIPT":
  52:             logging.debug("# SCRIPT")
```


## File wapitiCore/attack/mod_takeover.py - Line 93 - R0911 (too-many-return-statements)

- `message: Too many return statements (12/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  66: class Takeover:
  ...
  91:         return False
  92: 
> 93:     async def check(self, origin: str, domain: str) -> bool:
  94:         if "." not in domain or domain.endswith((".local", ".internal")):
  95:             # Stuff like "localhost": internal CNAMEs we can't control
```


## File wapitiCore/net/jsoncookie.py - Line 140 - R0911 (too-many-return-statements)

- `message: Too many return statements (7/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   30: class JsonCookie:
  ...
  138:         return cook_jar
  139: 
> 140:     def delete(self, domain, path=None, key=None):
  141:         if not domain:
  142:             return False
```


## File wapitiCore/net/crawler.py - Line 246 - R0911 (too-many-return-statements)

- `message: Too many return statements (12/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  140: class AsyncCrawler:
  ...
  244:         self._scope = value
  245: 
> 246:     def is_in_scope(self, resource):
  247:         if self._scope == Scope.PUNK:
  248:             # Life is short
```


## File wapitiCore/attack/mod_sql.py - Line 288 - R0911 (too-many-return-statements)

- `message: Too many return statements (7/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  273: class mod_sql(Attack):
  ...
  286: 
  287:     @staticmethod
> 288:     def _find_pattern_in_response(data):
  289:         for dbms, regex_list in DBMS_ERROR_PATTERNS.items():
  290:             for regex in regex_list:
```


## File wapitiCore/net/page.py - Line 355 - R0911 (too-many-return-statements)

- `message: Too many return statements (9/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   76: class Page:
  ...
  353:             yield tag["formaction"]
  354: 
> 355:     def make_absolute(self, link: str) -> str:
  356:         """Convert a relative URL to an absolute one (with scheme, host, path, etc) and use the base href if present.
  357:
```


## File wapitiCore/net/xss_utils.py - Line 496 - R0911 (too-many-return-statements)

- `message: Too many return statements (11/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  494:     return False
  495: 
> 496: def check_payload(data_dir, payloads_file, external_endpoint, proto_endpoint, response, flags, taint):
  497:     config_reader = ConfigParser(interpolation=None)
  498:     with open(path_join(data_dir, payloads_file), encoding='utf-8') as payload_file:
```


## File wapitiCore/net/crawler.py - Line 755 - R0911 (too-many-return-statements)

- `message: Too many return statements (7/6)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  565: class Explorer:
  ...
  753:         return new_requests
  754: 
> 755:     async def async_analyze(self, request) -> Tuple[bool, List]:
  756:         async with self._sem:
  757:             self._processed_requests.append(request)  # thread safe
```


# R0912: too-many-branches

## File wapitiCore/net/lamejs.py - Line 50 - R0912 (too-many-branches)

- `message: Too many branches (43/40)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  26: class LameJs:
  ...
  48:         return self.links
  49: 
> 50:     def read_node(self, node):
  51:         if node.type == "SCRIPT":
  52:             logging.debug("# SCRIPT")
```


## File wapitiCore/net/page.py - Line 721 - R0912 (too-many-branches)

- `message: Too many branches (41/40)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   76: class Page:
  ...
  719:         return result
  720: 
> 721:     def iter_forms(self, autofill=True):
  722:         """Returns a generator of Request extracted from the Page.
  723:
```


## File wapitiCore/main/wapiti.py - Line 767 - R0912 (too-many-branches)

- `message: Too many branches (69/40)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  765: 
  766: 
> 767: async def wapiti_main():
  768:     banners = [
  769:         """
```


# R0914: too-many-locals

## File wapitiCore/report/xmlreportgenerator.py - Line 171 - R0914 (too-many-locals)

- `message: Too many local variables (42/25)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   30: class XMLReportGenerator(ReportGenerator):
  ...
  169:         self._additionals[category].append(addition_dict)
  170: 
> 171:     def generate_report(self, output_path):
  172:         """
  173:         Create a xml file with a report of the vulnerabilities which have been logged with
```


## File wapitiCore/attack/mod_nikto.py - Line 186 - R0914 (too-many-locals)

- `message: Too many local variables (28/25)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   56: class mod_nikto(Attack):
  ...
  184:                         tasks.remove(task)
  185: 
> 186:     async def process_line(self, line):
  187:         match = match_or = match_and = False
  188:         fail = fail_or = False
```


## File wapitiCore/main/wapiti.py - Line 767 - R0914 (too-many-locals)

- `message: Too many local variables (28/25)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  765: 
  766: 
> 767: async def wapiti_main():
  768:     banners = [
  769:         """
```


# R0915: too-many-statements

## File wapitiCore/report/xmlreportgenerator.py - Line 171 - R0915 (too-many-statements)

- `message: Too many statements (111/100)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   30: class XMLReportGenerator(ReportGenerator):
  ...
  169:         self._additionals[category].append(addition_dict)
  170: 
> 171:     def generate_report(self, output_path):
  172:         """
  173:         Create a xml file with a report of the vulnerabilities which have been logged with
```


## File wapitiCore/attack/mod_nikto.py - Line 186 - R0915 (too-many-statements)

- `message: Too many statements (109/100)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   56: class mod_nikto(Attack):
  ...
  184:                         tasks.remove(task)
  185: 
> 186:     async def process_line(self, line):
  187:         match = match_or = match_and = False
  188:         fail = fail_or = False
```


## File wapitiCore/main/wapiti.py - Line 397 - R0915 (too-many-statements)

- `message: Too many statements (113/100)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
   92: class Wapiti:
  ...
  395:                 yield resource
  396: 
> 397:     async def attack(self, stop_event: asyncio.Event):
  398:         """Launch the attacks based on the preferences set by the command line"""
  399:         self._init_attacks(stop_event)
```


## File wapitiCore/main/wapiti.py - Line 767 - R0915 (too-many-statements)

- `message: Too many statements (227/100)`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  765: 
  766: 
> 767: async def wapiti_main():
  768:     banners = [
  769:         """
```


# R1710: inconsistent-return-statements

## File wapitiCore/net/lamejs.py - Line 50 - R1710 (inconsistent-return-statements)

- `message: Either all return statements in a function should return an expression, or none of them should.`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  26: class LameJs:
  ...
  48:         return self.links
  49: 
> 50:     def read_node(self, node):
  51:         if node.type == "SCRIPT":
  52:             logging.debug("# SCRIPT")
```


## File wapitiCore/net/jsoncookie.py - Line 50 - R1710 (inconsistent-return-statements)

- `message: Either all return statements in a function should return an expression, or none of them should.`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  30: class JsonCookie:
  ...
  48:         return self.cookiedict
  49: 
> 50:     def addcookies(self, cookies):
  51:         """Inject Cookies from a CookieJar into our JSON dictionary."""
  52:         if not isinstance(cookies, Cookies):
```


# R1728: consider-using-generator

## File wapitiCore/net/web.py - Line 267 - R1728 (consider-using-generator)

- `message: Consider using a generator instead 'tuple(tuple(param) for param in self._get_params)'`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  265:     def __hash__(self):
  266:         if self._cached_hash is None:
> 267:             get_kv = tuple([tuple(param) for param in self._get_params])
  268:             if isinstance(self._post_params, list):
  269:                 post_kv = tuple([tuple(param) for param in self._post_params])
```


## File wapitiCore/net/web.py - Line 269 - R1728 (consider-using-generator)

- `message: Consider using a generator instead 'tuple(tuple(param) for param in self._post_params)'`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  265:     def __hash__(self):
  ...
  267:             get_kv = tuple([tuple(param) for param in self._get_params])
  268:             if isinstance(self._post_params, list):
> 269:                 post_kv = tuple([tuple(param) for param in self._post_params])
  270:             else:
  271:                 post_kv = self._enctype + str(len(self._post_params))
```


## File wapitiCore/net/web.py - Line 272 - R1728 (consider-using-generator)

- `message: Consider using a generator instead 'tuple(tuple([param[0], param[1][0]]) for param in self._file_params)'`
- `author : julient`
- `date   : 2021-10-18T20:55:14`

```
  265:     def __hash__(self):
  ...
  270:             else:
  271:                 post_kv = self._enctype + str(len(self._post_params))
> 272:             file_kv = tuple([tuple([param[0], param[1][0]]) for param in self._file_params])
  273: 
  274:             self._cached_hash = hash((self._method, self._resource_path, get_kv, post_kv, file_kv))
```


