// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UABD_4H_TRACE_AARCH64_H_
#define VIXL_SIM_UABD_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uabd_4H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f7f, 0x4ccc, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x3333, 0x5554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x007f, 0x3332, 0x5553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0x3331, 0x5545, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007d, 0x3323, 0x54d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x006f, 0x32b6, 0x54d7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0002, 0x32b5, 0x54d6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x32b4, 0x2222, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f7f, 0x4ccc, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x4ccd, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x4cce, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7777, 0x7777, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xaa2b, 0x9999, 0xaa2b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xff01, 0xcc4e, 0xaa2d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xff02, 0xcc4f, 0xaa2e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xcc4f, 0xaa2e, 0x7ff3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xcc50, 0xaa9b, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xccbd, 0xaaa8, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff71, 0xccca, 0xaaa9, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xcccb, 0xaaaa, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xcccc, 0x5555, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0x3333, 0x5554, 0x7ffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3332, 0x5553, 0x7fed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3331, 0x5545, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3323, 0x54d8, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b5, 0x54d6, 0x4cca, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccb, 0x2aaa, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccc, 0x2aab, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x4ccd, 0x2aac, 0x2aad, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x4cce, 0x5555, 0x4ccf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7777, 0x7777, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x9999, 0xaa2b, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xcc4d, 0xaa2c, 0x7f85, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xcc4e, 0xaa2d, 0x7f86, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xaa2d, 0x7f86, 0x7ff2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xaa2e, 0x7ff3, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc50, 0xaa9b, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbd, 0xaaa8, 0x8001, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xaaa9, 0x8002, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xaaaa, 0x7ffd, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0x5555, 0x7ffc, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5554, 0x7ffb, 0x7fee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5553, 0x7fed, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5545, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa8, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aa9, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aaa, 0x0003, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x2aab, 0x0004, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x2aac, 0x2aad, 0x4cce, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x5555, 0x4ccf, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7777, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0xaa2b, 0x7f84, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xaa2c, 0x7f85, 0x7f85, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0x7f85, 0x7f85, 0x7ff1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0x7f86, 0x7ff2, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2e, 0x7ff3, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9b, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0x8001, 0x8001, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0x8002, 0x7ffe, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x7ffd, 0x7ffd, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffb, 0x7fee, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fed, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f80, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa8, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x0003, 0x0003, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x0004, 0x2aac, 0x4ccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x2aad, 0x4cce, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x4ccf, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7f83, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x7f84, 0x7f84, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f84, 0x7f84, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7f85, 0x7ff1, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f86, 0x7ff2, 0x7ffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff3, 0x7fff, 0x7fff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8001, 0x7fff, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x7ffe, 0x7ffe, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0x7ffd, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffc, 0x7fef, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fee, 0x7f82, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f81, 0x7f81, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x7f80, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f7f, 0x4ccc, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccb, 0x2aaa, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aa9, 0x0002, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0001, 0x0001, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x0002, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0003, 0x2aab, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x2aac, 0x4ccd, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aad, 0x4cce, 0x7f81, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccf, 0x7f82, 0x7f82, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0x7f83, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0xff83, 0xffef, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f84, 0xfff0, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7ff1, 0xfffd, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff2, 0x7ffe, 0xfffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0xffff, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x7fff, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ffe, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0x0010, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7fef, 0x007d, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f82, 0x007e, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x007f, 0x3332, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x3333, 0x5554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccc, 0x5555, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aaa, 0x7ffd, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0002, 0x7ffe, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x8001, 0xaaa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0xaaaa, 0xcccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x2aab, 0xcccc, 0xff7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4ccd, 0xff80, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x7f81, 0xff81, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0xff82, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0xff82, 0xff82, 0xffee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xff83, 0xffef, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0xfff0, 0xfffc, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0xfffd, 0xfffd, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xfffe, 0xfffe, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xffff, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x0002, 0x000f, 0x007b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x0010, 0x007c, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x007d, 0x007d, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x007e, 0x007e, 0x3331, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x007f, 0x3332, 0x5553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x3333, 0x5554, 0x7ffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x5555, 0x7ffc, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x7ffd, 0x7ffd, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x7ffe, 0x7ffe, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8000, 0x8000, 0xaaa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x8001, 0xaaa9, 0xccca, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0xaaaa, 0xcccb, 0xff7e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcccc, 0xff7f, 0xff7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0xff80, 0xff80, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0xff81, 0xff81, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff81, 0xff81, 0xffe0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff82, 0xffee, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xffef, 0xfffb, 0xffee, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xfffc, 0xfffc, 0xffef, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffd, 0xfffd, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfffe, 0x0002, 0x000f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0001, 0x000e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x000e, 0x006d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x000f, 0x007b, 0x006e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007c, 0x007c, 0x006f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007d, 0x007d, 0x3323, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0x3331, 0x5545, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3332, 0x5553, 0x7fed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5554, 0x7ffb, 0x7fee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0x7ffd, 0x7ff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ffe, 0x7ffe, 0x7ff1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0xaa9a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8000, 0xaaa8, 0xccbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaa9, 0xccca, 0xff70, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccb, 0xff7e, 0xff71, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff7f, 0xff7f, 0xff72, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff80, 0xff80, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff80, 0xff73, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff81, 0xffe0, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xffee, 0xffed, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffef, 0xfffb, 0xffee, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfffc, 0xffef, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xfffd, 0x0010, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x0002, 0x000f, 0x007b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x000e, 0x006d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x000e, 0x006d, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000f, 0x007b, 0x006e, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x007c, 0x006f, 0x32b6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007d, 0x3323, 0x54d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3331, 0x5545, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5553, 0x7fed, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffb, 0x7fee, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffc, 0x7fef, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0x7ff0, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ffe, 0x7ff1, 0xaa2d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0xaa9a, 0xcc4f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xaaa8, 0xccbc, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xccca, 0xff70, 0xff04, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xff7e, 0xff71, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff7f, 0xff72, 0xff06, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff72, 0xff06, 0xff72, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff73, 0xff73, 0xff7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xffe0, 0xff80, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffee, 0xffed, 0xff81, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffee, 0xff82, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xffef, 0x007d, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0010, 0x007c, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x000f, 0x007b, 0x006e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x000e, 0x006d, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000e, 0x006d, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007b, 0x006e, 0x0002, 0x32b5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x006f, 0x32b6, 0x54d7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3323, 0x54d8, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5545, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fed, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fee, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7fef, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ff0, 0x7f84, 0xaa2c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ff1, 0xaa2d, 0xcc4e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xaa9a, 0xcc4f, 0xff02, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0xccbc, 0xff03, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xff70, 0xff04, 0xff04, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xff71, 0xff05, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff71, 0xff05, 0xff05, 0xff71, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff72, 0xff06, 0xff72, 0xff7e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff73, 0xff73, 0xff7f, 0xff7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffe0, 0xff80, 0xff80, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffed, 0xff81, 0xff81, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffee, 0xff82, 0x007e, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffef, 0x007d, 0x007d, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007c, 0x007c, 0x006f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000f, 0x007b, 0x006e, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000e, 0x006d, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006d, 0x0001, 0x0001, 0x32b4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0002, 0x32b5, 0x54d6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f80, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f81, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f82, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x7f83, 0x7f83, 0xaa2b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff0, 0x7f84, 0xaa2c, 0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0xaa2d, 0xcc4e, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9a, 0xcc4f, 0xff02, 0xff02, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbc, 0xff03, 0xff03, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff70, 0xff04, 0xff04, 0xff04, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xff04, 0xff04, 0xccbd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff05, 0xff05, 0xff71, 0xccca, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff06, 0xff72, 0xff7e, 0xcccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff73, 0xff7f, 0xff7f, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff80, 0xff80, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff81, 0x007f, 0x3332, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0x007e, 0x007e, 0x3331, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007d, 0x007d, 0x3323, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x007c, 0x006f, 0x32b6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007b, 0x006e, 0x0002, 0x32b5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006d, 0x0001, 0x0001, 0x32b4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x32b4, 0x2222, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b5, 0x54d6, 0x4cca, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x7f80, 0x4ccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x7f81, 0x4cce, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7f82, 0x7777, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0xaa2b, 0x9999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0xaa2c, 0xcc4d, 0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0xcc4e, 0xff01, 0xcc4e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xff02, 0xff02, 0xcc4f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xff03, 0xff03, 0xcc50, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xff03, 0xcc50, 0xaa9b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xff04, 0xccbd, 0xaaa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff05, 0xff71, 0xccca, 0xaaa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff72, 0xff7e, 0xcccb, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff7f, 0xcccc, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff80, 0x3333, 0x5554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0x007f, 0x3332, 0x5553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0x3331, 0x5545, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007d, 0x3323, 0x54d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007c, 0x006f, 0x32b6, 0x54d7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006e, 0x0002, 0x32b5, 0x54d6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x32b4, 0x2222, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f7f, 0x4ccc, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x4ccd, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x4cce, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7777, 0x7777, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xaa2b, 0x9999, 0xaa2b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xff01, 0xcc4e, 0xaa2d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xff02, 0xcc4f, 0xaa2e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xcc4f, 0xaa2e, 0x7ff3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xcc50, 0xaa9b, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff04, 0xccbd, 0xaaa8, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff71, 0xccca, 0xaaa9, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xcccb, 0xaaaa, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xcccc, 0x5555, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0x3333, 0x5554, 0x7ffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3332, 0x5553, 0x7fed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x3331, 0x5545, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x3323, 0x54d8, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x32b5, 0x54d6, 0x4cca, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccb, 0x2aaa, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccc, 0x2aab, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x4ccd, 0x2aac, 0x2aad, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x4cce, 0x5555, 0x4ccf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7777, 0x7777, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x9999, 0xaa2b, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xcc4d, 0xaa2c, 0x7f85, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xcc4e, 0xaa2d, 0x7f86, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xaa2d, 0x7f86, 0x7ff2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xaa2e, 0x7ff3, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc50, 0xaa9b, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbd, 0xaaa8, 0x8001, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xaaa9, 0x8002, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xaaaa, 0x7ffd, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0x5555, 0x7ffc, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5554, 0x7ffb, 0x7fee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x5553, 0x7fed, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x5545, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa8, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aa9, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aaa, 0x0003, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x2aab, 0x0004, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x2aac, 0x2aad, 0x4cce, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x5555, 0x4ccf, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7777, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0xaa2b, 0x7f84, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xaa2c, 0x7f85, 0x7f85, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0x7f85, 0x7f85, 0x7ff1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0x7f86, 0x7ff2, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2e, 0x7ff3, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9b, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0x8001, 0x8001, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0x8002, 0x7ffe, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x7ffd, 0x7ffd, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x7ffb, 0x7fee, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x7fed, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5545, 0x7f80, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x2aa8, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x0003, 0x0003, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x0004, 0x2aac, 0x4ccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x2aad, 0x4cce, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x4ccf, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7f83, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x7f84, 0x7f84, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f84, 0x7f84, 0x7ff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7f85, 0x7ff1, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f86, 0x7ff2, 0x7ffe, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff3, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8001, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x7ffe, 0x7ffe, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0x7ffd, 0x7ff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7ffc, 0x7fef, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffb, 0x7fee, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fed, 0x7f81, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x7f80, 0x4ccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x7f7f, 0x4ccc, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7e, 0x4ccb, 0x2aaa, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cca, 0x2aa9, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa8, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x0002, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0003, 0x2aab, 0x4ccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x2aac, 0x4ccd, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aad, 0x4cce, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccf, 0x7f82, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0x7f83, 0x7fef, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7f84, 0x7ff0, 0x7ffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f85, 0x7ff1, 0x7ffd, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff2, 0x7ffe, 0x7ffe, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ffe, 0x7ffe, 0x7ff1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0x7ff0, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x7fef, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fee, 0x7f82, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x7f81, 0x4cce, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x4ccd, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x4ccc, 0x2aab, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x2aaa, 0x0003, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x2aaa, 0x4ccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x2aab, 0x4ccc, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4ccd, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x7f81, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7f82, 0x5546, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0x7fef, 0x5553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0x7ff0, 0x7ffc, 0x5554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0x7ffd, 0x7ffd, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ffe, 0x7ffe, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x8001, 0xaaa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8000, 0x8000, 0xaaa8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0xaa9a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ffe, 0x7ff1, 0xaa2d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ff0, 0x7f84, 0xaa2c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x7f83, 0x7f83, 0xaa2b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7f82, 0x7777, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x4cce, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x4ccd, 0x2aac, 0x2aad, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x2aab, 0x0004, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x0003, 0x0003, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x0002, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x2aa9, 0x2222, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x2aaa, 0x4ccb, 0x54d6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4ccc, 0x7f7f, 0x54d7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x7f80, 0x7f80, 0x54d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x7f81, 0x54d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x54d9, 0x3324, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x5546, 0x3331, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7fef, 0x5553, 0x3332, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff0, 0x7ffc, 0x5554, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0x5555, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ffe, 0xaaaa, 0xcccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8001, 0xaaa9, 0xccca, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8000, 0xaaa8, 0xccbc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0xaa9a, 0xcc4f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7ff1, 0xaa2d, 0xcc4e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff0, 0x7f84, 0xaa2c, 0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0xaa2b, 0x9999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7777, 0x7777, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x4cce, 0x5555, 0x4ccf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x2aac, 0x2aad, 0x4cce, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x0004, 0x2aac, 0x4ccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0003, 0x2aab, 0x4ccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x2aaa, 0x4ccb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x2aa9, 0x2222, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x2aa9, 0x2222, 0x32b4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x4ccb, 0x54d6, 0x32b5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x7f7f, 0x54d7, 0x32b6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x54d8, 0x32b7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x54d8, 0x32b7, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x54d9, 0x3324, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x5546, 0x3331, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fef, 0x5553, 0x3332, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffc, 0x5554, 0x3333, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x5555, 0xcccc, 0xff7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xaaaa, 0xcccb, 0xff7e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaa9, 0xccca, 0xff70, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0xaaa8, 0xccbc, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xaa9a, 0xcc4f, 0xff02, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff1, 0xaa2d, 0xcc4e, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f84, 0xaa2c, 0xcc4d, 0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0xaa2b, 0x9999, 0xaa2b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7777, 0x7777, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x5555, 0x4ccf, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x2aad, 0x4cce, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x2aac, 0x4ccd, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x2aab, 0x4ccc, 0x7f7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x2aaa, 0x4ccb, 0x54d6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x2aa9, 0x2222, 0x32b4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x2222, 0x32b4, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x54d6, 0x32b5, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x54d7, 0x32b6, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d7, 0x32b6, 0x0003, 0x006f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d8, 0x32b7, 0x0070, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d9, 0x3324, 0x007d, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5546, 0x3331, 0x007e, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5553, 0x3332, 0x007f, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x3333, 0xff80, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0xcccc, 0xff7f, 0xff7f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccb, 0xff7e, 0xff71, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xccca, 0xff70, 0xff04, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa8, 0xccbc, 0xff03, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa9a, 0xcc4f, 0xff02, 0xff02, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2d, 0xcc4e, 0xff01, 0xcc4e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x9999, 0xaa2b, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7777, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x4ccf, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aad, 0x4cce, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4ccd, 0x7f80, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4ccc, 0x7f7f, 0x54d7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x4ccb, 0x54d6, 0x32b5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x2222, 0x32b4, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x32b4, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x32b5, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b5, 0x0002, 0x0002, 0x006e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b6, 0x0003, 0x006f, 0x007b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b7, 0x0070, 0x007c, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3324, 0x007d, 0x007d, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3331, 0x007e, 0x007e, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3332, 0x007f, 0xff81, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0xff80, 0xff80, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff7f, 0xff7f, 0xff72, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccb, 0xff7e, 0xff71, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccca, 0xff70, 0xff04, 0xff04, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccbc, 0xff03, 0xff03, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4f, 0xff02, 0xff02, 0xcc4f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4e, 0xff01, 0xcc4e, 0xaa2d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xcc4d, 0xaa2c, 0x7f85, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0xaa2b, 0x7f84, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7777, 0x7f83, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccf, 0x7f82, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4cce, 0x7f81, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccd, 0x7f80, 0x7f80, 0x54d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x7f7f, 0x54d7, 0x32b6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccb, 0x54d6, 0x32b5, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2222, 0x32b4, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x006d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0002, 0x006e, 0x007a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x006f, 0x007b, 0x007b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0070, 0x007c, 0x007c, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007d, 0x007d, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007e, 0xff82, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0xff81, 0xff81, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff80, 0xff80, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7f, 0xff7f, 0xff72, 0xff06, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff7e, 0xff71, 0xff05, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff70, 0xff04, 0xff04, 0xff04, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff03, 0xff03, 0xff03, 0xcc50, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff02, 0xff02, 0xcc4f, 0xaa2e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xcc4e, 0xaa2d, 0x7f86, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4d, 0xaa2c, 0x7f85, 0x7f85, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa2b, 0x7f84, 0x7f84, 0x7f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0x7f83, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f82, 0x7f82, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x7f81, 0x54d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x7f80, 0x54d8, 0x32b7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f7f, 0x54d7, 0x32b6, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x54d6, 0x32b5, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32b4, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_uabd_4H = 576;

#endif  // VIXL_SIM_UABD_4H_TRACE_AARCH64_H_
